import{s as Wn,f as sn,n as Rn,o as Qn}from"../chunks/scheduler.37c15a92.js";import{S as Vn,i as Sn,g as i,s,r as m,A as Xn,h,f as e,c as a,j as ct,u as y,x as o,k as p,y as Yn,a as l,v as M,d,t as g,w as T}from"../chunks/index.2bf4358c.js";import{C as an}from"../chunks/CodeBlock.4e987730.js";import{D as Pn}from"../chunks/DocNotebookDropdown.efc1fb7c.js";import{H as ht,E as zn}from"../chunks/getInferenceSnippets.39afd8fb.js";function Fn(hn){let w,rt,ot,ut,j,mt,J,yt,b,on="Trong phần này, chúng ta sẽ xem xét kỹ hơn về lớp <code>Interface</code> và hiểu các tham số chính được sử dụng để tạo ra nó.",Mt,f,dt,v,pn="Bạn sẽ nhận thấy rằng lớp <code>Interface</code> có 3 tham số bắt buộc:",gt,U,cn="<code>Interface(fn, inputs, outputs, ...)</code>",Tt,I,rn="Các tham số này là:",wt,C,un="<li><code>fn</code>: hàm dự đoán được bao bọc bởi giao diện Gradio. Hàm này có thể nhận một hoặc nhiều tham số và trả về một hoặc nhiều giá trị</li> <li><code>inputs</code>: (các) loại thành phần đầu vào. Gradio cung cấp nhiều thành phần được tạo sẵn như<code>&quot;image&quot;</code> hay <code>&quot;mic&quot;</code>.</li> <li><code>outputs</code>: (các) loại thành phần đầu ra. Một lần nữa, Gradio cung cấp nhiều thành phần được tạo sẵn, ví dụ: <code>&quot;image&quot;</code> hay <code>&quot;label&quot;</code>.</li>",jt,k,mn='Để có danh sách đầy đủ các thành phần, <a href="https://gradio.app/docs" rel="nofollow">xem tài liệu Gradio</a>. Mỗi thành phần được tạo sẵn có thể được tùy chỉnh bằng cách khởi tạo lớp tương ứng với thành phần.',Jt,x,yn='Ví dụ: như chúng ta đã thấy trong <a href="/course/chapter9/2">phần trước</a>, thay vì truyền tham số <code>input</code> vào trong <code>&quot;textbox&quot;</code>, bạn có thể truyền vào <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> để tạo một hộp văn bản có 7 dòng và một nhãn.',bt,q,Mn="Hãy xem một ví dụ khác, lần này với thành phần <code>Audio</code>.",ft,A,vt,$,dn=`Như đã đề cập trước đó, Gradio cung cấp nhiều đầu vào và đầu ra khác nhau.
Vì vậy, hãy xây dựng một  <code>Interface</code> hoạt động với âm thanh.`,Ut,G,gn="Trong ví dụ này, chúng tôi sẽ xây dựng một hàm chuyển đổi âm thanh sang âm thanh mà nhận tập tin âm thanh và chỉ cần đảo ngược nó.",It,H,Tn=`Chúng ta sẽ sử dụng thành phần <code>Audio</code> cho đầu vào. Khi sử dụng thành phần <code>Audio</code>, bạn có thể chỉ định xem bạn có muốn <code>source</code> của âm thanh là một tệp mà người dùng
tải lên hoặc micrô mà người dùng ghi lại giọng nói của họ. Trong trường hợp này, hãy đặt nó thành <code>&quot;microphone&quot;</code>. Chỉ cho vui thôi, chúng ta sẽ thêm một nhãn vào phần  <code>Audio</code> của mình có nội dung “Speak here…”, nghĩa là “Nói ở đây …“.`,Ct,B,wn=`Ngoài ra, chúng ta muốn nhận âm thanh dưới dạng mảng numpy để ta có thể dễ dàng “đảo ngược” nó lại. Vì vậy, chúng ta sẽ đặt <code>&quot;type&quot;</code> là <code>&quot;numpy&quot;</code>, chuyển đầu vào
dữ liệu dưới dạng một bộ (<code>sample_rate</code>, <code>data</code>) trong hàm của chúng ta.`,kt,_,jn="Chúng ta cũng sẽ sử dụng thành phần đầu ra <code>Audio</code> có thể tự động hiển thị một bộ tuple với tốc độ mẫu và mảng dữ liệu phức tạp dưới dạng tệp âm thanh có thể phát. Trong trường hợp này, chúng ta không cần thực hiện bất kỳ tùy chỉnh nào, vì vậy cta sẽ sử dụng chuỗi phím tắt <code>&quot;audio&quot;</code>.",xt,Z,qt,E,Jn='Đoạn mã trên sẽ tạo ra một giao diện giống như bên dưới (nếu trình duyệt của bạn không yêu cầu bạn cấp quyền đối với micrô, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">mở bản demo sang một tab khác</a>.)',At,c,bn,$t,L,fn="Bây giờ bạn có thể ghi lại giọng nói của mình và nghe thấy chính mình đang nói ngược lại - thật ma quái 👻!",Gt,N,Ht,W,vn="Giả sử chúng ta có một hàm phức tạp hơn, với nhiều đầu vào và đầu ra. Trong ví dụ dưới đây, chúng ta có một hàm lấy chỉ mục thả xuống, giá trị thanh trượt và số, và trả về một mẫu âm thanh của một giai điệu âm nhạc.",Bt,R,Un="Hãy xem cách chúng ta chuyển danh sách các thành phần đầu vào và đầu ra, và xem liệu bạn có thể theo dõi những gì đang xảy ra không.",_t,Q,In="Chìa khóa ở đây là khi bạn truyền vào:",Zt,V,Cn="<li>danh sách các thành phần đầu vào, mỗi thành phần tương ứng với một tham số theo thứ tự.</li> <li>danh sách các thành phần đầu ra, mỗi thành phần tương ứng với một giá trị trả về.</li>",Et,S,kn="Đoạn mã bên dưới cho thấy cách ba thành phần đầu vào xếp hàng với ba tham số của hàm <code>generate_tone()</code>:",Lt,X,Nt,r,xn,Wt,Y,Rt,P,qn="Cho đến nay, chúng tôi đã sử dụng phương thức <code>launch()</code> để khởi chạy giao diện, nhưng chúng ta chưa thực sự thảo luận về những gì nó làm.",Qt,z,An="Theo mặc định, phương thức <code>launch()</code> sẽ khởi chạy bản demo trong một máy chủ web đang chạy cục bộ. Nếu bạn đang chạy mã của mình trong notebook Jupyter hoặc Colab, thì Gradio sẽ nhúng GUI demo vào notebook để bạn có thể dễ dàng sử dụng.",Vt,F,$n="Bạn có thể tùy chỉnh hành vi của <code>launch()</code> thông qua các tham số khác nhau:",St,D,Gn="<li><code>inline</code> - có hiển thị giao diện nội tuyến trên notebook Python hay không.</li> <li><code>inbrowser</code> - có tự động khởi chạy giao diện trong tab mới trên trình duyệt mặc định hay không.</li> <li><code>share</code> - có tạo một liên kết có thể chia sẻ công khai từ máy tính của bạn cho giao diện hay không. Giống như một liên kết Google Drive!</li>",Xt,K,Hn="Chúng tôi sẽ trình bày chi tiết hơn về tham số <code>share</code> trong phần tiếp theo!",Yt,O,Pt,tt,Bn="Hãy xây dựng một giao diện cho phép bạn giới thiệu mô hình <strong>nhận dạng giọng nói</strong>. Để làm cho nó thú vị, chúng ta sẽ chấp nhận hoặc đầu vào micrô hoặc một tệp đã tải lên.",zt,nt,_n=`Như thường lệ, chúng ta sẽ tải mô hình nhận dạng giọng nói của mình bằng cách sử dụng hàm <code>pipeline()</code> từ 🤗 Transformers.
Nếu bạn cần cập nhật nhanh, bạn có thể quay lại <a href="/course/chapter1/3">phần đó trong Chương 1</a>. Tiếp theo, chúng ta sẽ triển khai một hàm <code>transcribe_audio()</code> để xử lý âm thanh và trả về phiên âm. Cuối cùng, chúng ta sẽ gói hàm này trong một <code>Interface</code> với các thành phần <code>Audio</code> cho đầu vào và chỉ văn bản cho đầu ra. Nhìn chung, mã cho ứng dụng này như sau:`,Ft,et,Dt,lt,Zn='Nếu trình duyệt của bạn không yêu cầu bạn cấp quyền đối với micrô, hãy <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">mở bản demo trong một tab riêng</a>.',Kt,u,En,Ot,st,Ln="Nó đó! Bây giờ bạn có thể sử dụng giao diện này để phiên âm âm thanh. Chú ý ở đây rằng bằng cách đặt tham số <code>option</code> là <code>True</code>, chúng ta cho phép người dùng cung cấp micrô hoặc tệp âm thanh (hoặc không, nhưng điều đó sẽ trả lại thông báo lỗi).",tn,at,Nn="Tiếp tục xem cách chia sẻ giao diện của bạn với những người khác!",nn,it,en,pt,ln;return j=new ht({props:{title:"Hiểu lớp Interface",local:"hiểu-lớp-interface",headingTag:"h1"}}),J=new Pn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/vi/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/vi/chapter9/section3.ipynb"}]}}),f=new ht({props:{title:"Cách tạo một Interface",local:"cách-tạo-một-interface",headingTag:"h2"}}),A=new ht({props:{title:"Một ví dụ đơn giản với âm thanh",local:"một-ví-dụ-đơn-giản-với-âm-thanh",headingTag:"h2"}}),Z=new an({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),N=new ht({props:{title:"Xử lý nhiều đầu vào và đầu ra",local:"xử-lý-nhiều-đầu-vào-và-đầu-ra",headingTag:"h2"}}),X=new an({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),Y=new ht({props:{title:"Phương thức launch()",local:"phương-thức-launch",headingTag:"h3"}}),O=new ht({props:{title:"✏️ Hãy áp dụng nó!",local:"-hãy-áp-dụng-nó",headingTag:"h2"}}),et=new an({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),it=new zn({props:{source:"https://github.com/huggingface/course/blob/main/chapters/vi/chapter9/3.mdx"}}),{c(){w=i("meta"),rt=s(),ot=i("p"),ut=s(),m(j.$$.fragment),mt=s(),m(J.$$.fragment),yt=s(),b=i("p"),b.innerHTML=on,Mt=s(),m(f.$$.fragment),dt=s(),v=i("p"),v.innerHTML=pn,gt=s(),U=i("p"),U.innerHTML=cn,Tt=s(),I=i("p"),I.textContent=rn,wt=s(),C=i("ul"),C.innerHTML=un,jt=s(),k=i("p"),k.innerHTML=mn,Jt=s(),x=i("p"),x.innerHTML=yn,bt=s(),q=i("p"),q.innerHTML=Mn,ft=s(),m(A.$$.fragment),vt=s(),$=i("p"),$.innerHTML=dn,Ut=s(),G=i("p"),G.textContent=gn,It=s(),H=i("p"),H.innerHTML=Tn,Ct=s(),B=i("p"),B.innerHTML=wn,kt=s(),_=i("p"),_.innerHTML=jn,xt=s(),m(Z.$$.fragment),qt=s(),E=i("p"),E.innerHTML=Jn,At=s(),c=i("iframe"),$t=s(),L=i("p"),L.textContent=fn,Gt=s(),m(N.$$.fragment),Ht=s(),W=i("p"),W.textContent=vn,Bt=s(),R=i("p"),R.textContent=Un,_t=s(),Q=i("p"),Q.textContent=In,Zt=s(),V=i("ul"),V.innerHTML=Cn,Et=s(),S=i("p"),S.innerHTML=kn,Lt=s(),m(X.$$.fragment),Nt=s(),r=i("iframe"),Wt=s(),m(Y.$$.fragment),Rt=s(),P=i("p"),P.innerHTML=qn,Qt=s(),z=i("p"),z.innerHTML=An,Vt=s(),F=i("p"),F.innerHTML=$n,St=s(),D=i("ul"),D.innerHTML=Gn,Xt=s(),K=i("p"),K.innerHTML=Hn,Yt=s(),m(O.$$.fragment),Pt=s(),tt=i("p"),tt.innerHTML=Bn,zt=s(),nt=i("p"),nt.innerHTML=_n,Ft=s(),m(et.$$.fragment),Dt=s(),lt=i("p"),lt.innerHTML=Zn,Kt=s(),u=i("iframe"),Ot=s(),st=i("p"),st.innerHTML=Ln,tn=s(),at=i("p"),at.textContent=Nn,nn=s(),m(it.$$.fragment),en=s(),pt=i("p"),this.h()},l(t){const n=Xn("svelte-u9bgzb",document.head);w=h(n,"META",{name:!0,content:!0}),n.forEach(e),rt=a(t),ot=h(t,"P",{}),ct(ot).forEach(e),ut=a(t),y(j.$$.fragment,t),mt=a(t),y(J.$$.fragment,t),yt=a(t),b=h(t,"P",{"data-svelte-h":!0}),o(b)!=="svelte-xe96uk"&&(b.innerHTML=on),Mt=a(t),y(f.$$.fragment,t),dt=a(t),v=h(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1cjdu40"&&(v.innerHTML=pn),gt=a(t),U=h(t,"P",{"data-svelte-h":!0}),o(U)!=="svelte-5xxju6"&&(U.innerHTML=cn),Tt=a(t),I=h(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-xqxlrw"&&(I.textContent=rn),wt=a(t),C=h(t,"UL",{"data-svelte-h":!0}),o(C)!=="svelte-x74dgj"&&(C.innerHTML=un),jt=a(t),k=h(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1sk6bds"&&(k.innerHTML=mn),Jt=a(t),x=h(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1b5q675"&&(x.innerHTML=yn),bt=a(t),q=h(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1wnp7jd"&&(q.innerHTML=Mn),ft=a(t),y(A.$$.fragment,t),vt=a(t),$=h(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-f05xnr"&&($.innerHTML=dn),Ut=a(t),G=h(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-l08naj"&&(G.textContent=gn),It=a(t),H=h(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1pxvmk3"&&(H.innerHTML=Tn),Ct=a(t),B=h(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-j9pi35"&&(B.innerHTML=wn),kt=a(t),_=h(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-7m2l6g"&&(_.innerHTML=jn),xt=a(t),y(Z.$$.fragment,t),qt=a(t),E=h(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-16fqgts"&&(E.innerHTML=Jn),At=a(t),c=h(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(c).forEach(e),$t=a(t),L=h(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1q6fanq"&&(L.textContent=fn),Gt=a(t),y(N.$$.fragment,t),Ht=a(t),W=h(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ripq4o"&&(W.textContent=vn),Bt=a(t),R=h(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1n0hhrk"&&(R.textContent=Un),_t=a(t),Q=h(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-e4msx3"&&(Q.textContent=In),Zt=a(t),V=h(t,"UL",{"data-svelte-h":!0}),o(V)!=="svelte-27kd5i"&&(V.innerHTML=Cn),Et=a(t),S=h(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-12b4chk"&&(S.innerHTML=kn),Lt=a(t),y(X.$$.fragment,t),Nt=a(t),r=h(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(r).forEach(e),Wt=a(t),y(Y.$$.fragment,t),Rt=a(t),P=h(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1e24e0s"&&(P.innerHTML=qn),Qt=a(t),z=h(t,"P",{"data-svelte-h":!0}),o(z)!=="svelte-ss0j09"&&(z.innerHTML=An),Vt=a(t),F=h(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1n38ln1"&&(F.innerHTML=$n),St=a(t),D=h(t,"UL",{"data-svelte-h":!0}),o(D)!=="svelte-wa3lyf"&&(D.innerHTML=Gn),Xt=a(t),K=h(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-597w6a"&&(K.innerHTML=Hn),Yt=a(t),y(O.$$.fragment,t),Pt=a(t),tt=h(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-znezbr"&&(tt.innerHTML=Bn),zt=a(t),nt=h(t,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-1d14t68"&&(nt.innerHTML=_n),Ft=a(t),y(et.$$.fragment,t),Dt=a(t),lt=h(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-w71vac"&&(lt.innerHTML=Zn),Kt=a(t),u=h(t,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),ct(u).forEach(e),Ot=a(t),st=h(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-o3694q"&&(st.innerHTML=Ln),tn=a(t),at=h(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1mcu745"&&(at.textContent=Nn),nn=a(t),y(it.$$.fragment,t),en=a(t),pt=h(t,"P",{}),ct(pt).forEach(e),this.h()},h(){p(w,"name","hf:doc:metadata"),p(w,"content",Dn),sn(c.src,bn="https://course-demos-audio-reverse.hf.space")||p(c,"src",bn),p(c,"frameborder","0"),p(c,"height","250"),p(c,"title","Gradio app"),p(c,"class","container p-0 flex-grow space-iframe"),p(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),sn(r.src,xn="https://course-demos-generate-tone.hf.space")||p(r,"src",xn),p(r,"frameborder","0"),p(r,"height","450"),p(r,"title","Gradio app"),p(r,"class","container p-0 flex-grow space-iframe"),p(r,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(r,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),sn(u.src,En="https://course-demos-asr.hf.space")||p(u,"src",En),p(u,"frameborder","0"),p(u,"height","550"),p(u,"title","Gradio app"),p(u,"class","container p-0 flex-grow space-iframe"),p(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(t,n){Yn(document.head,w),l(t,rt,n),l(t,ot,n),l(t,ut,n),M(j,t,n),l(t,mt,n),M(J,t,n),l(t,yt,n),l(t,b,n),l(t,Mt,n),M(f,t,n),l(t,dt,n),l(t,v,n),l(t,gt,n),l(t,U,n),l(t,Tt,n),l(t,I,n),l(t,wt,n),l(t,C,n),l(t,jt,n),l(t,k,n),l(t,Jt,n),l(t,x,n),l(t,bt,n),l(t,q,n),l(t,ft,n),M(A,t,n),l(t,vt,n),l(t,$,n),l(t,Ut,n),l(t,G,n),l(t,It,n),l(t,H,n),l(t,Ct,n),l(t,B,n),l(t,kt,n),l(t,_,n),l(t,xt,n),M(Z,t,n),l(t,qt,n),l(t,E,n),l(t,At,n),l(t,c,n),l(t,$t,n),l(t,L,n),l(t,Gt,n),M(N,t,n),l(t,Ht,n),l(t,W,n),l(t,Bt,n),l(t,R,n),l(t,_t,n),l(t,Q,n),l(t,Zt,n),l(t,V,n),l(t,Et,n),l(t,S,n),l(t,Lt,n),M(X,t,n),l(t,Nt,n),l(t,r,n),l(t,Wt,n),M(Y,t,n),l(t,Rt,n),l(t,P,n),l(t,Qt,n),l(t,z,n),l(t,Vt,n),l(t,F,n),l(t,St,n),l(t,D,n),l(t,Xt,n),l(t,K,n),l(t,Yt,n),M(O,t,n),l(t,Pt,n),l(t,tt,n),l(t,zt,n),l(t,nt,n),l(t,Ft,n),M(et,t,n),l(t,Dt,n),l(t,lt,n),l(t,Kt,n),l(t,u,n),l(t,Ot,n),l(t,st,n),l(t,tn,n),l(t,at,n),l(t,nn,n),M(it,t,n),l(t,en,n),l(t,pt,n),ln=!0},p:Rn,i(t){ln||(d(j.$$.fragment,t),d(J.$$.fragment,t),d(f.$$.fragment,t),d(A.$$.fragment,t),d(Z.$$.fragment,t),d(N.$$.fragment,t),d(X.$$.fragment,t),d(Y.$$.fragment,t),d(O.$$.fragment,t),d(et.$$.fragment,t),d(it.$$.fragment,t),ln=!0)},o(t){g(j.$$.fragment,t),g(J.$$.fragment,t),g(f.$$.fragment,t),g(A.$$.fragment,t),g(Z.$$.fragment,t),g(N.$$.fragment,t),g(X.$$.fragment,t),g(Y.$$.fragment,t),g(O.$$.fragment,t),g(et.$$.fragment,t),g(it.$$.fragment,t),ln=!1},d(t){t&&(e(rt),e(ot),e(ut),e(mt),e(yt),e(b),e(Mt),e(dt),e(v),e(gt),e(U),e(Tt),e(I),e(wt),e(C),e(jt),e(k),e(Jt),e(x),e(bt),e(q),e(ft),e(vt),e($),e(Ut),e(G),e(It),e(H),e(Ct),e(B),e(kt),e(_),e(xt),e(qt),e(E),e(At),e(c),e($t),e(L),e(Gt),e(Ht),e(W),e(Bt),e(R),e(_t),e(Q),e(Zt),e(V),e(Et),e(S),e(Lt),e(Nt),e(r),e(Wt),e(Rt),e(P),e(Qt),e(z),e(Vt),e(F),e(St),e(D),e(Xt),e(K),e(Yt),e(Pt),e(tt),e(zt),e(nt),e(Ft),e(Dt),e(lt),e(Kt),e(u),e(Ot),e(st),e(tn),e(at),e(nn),e(en),e(pt)),e(w),T(j,t),T(J,t),T(f,t),T(A,t),T(Z,t),T(N,t),T(X,t),T(Y,t),T(O,t),T(et,t),T(it,t)}}}const Dn='{"title":"Hiểu lớp Interface","local":"hiểu-lớp-interface","sections":[{"title":"Cách tạo một Interface","local":"cách-tạo-một-interface","sections":[],"depth":2},{"title":"Một ví dụ đơn giản với âm thanh","local":"một-ví-dụ-đơn-giản-với-âm-thanh","sections":[],"depth":2},{"title":"Xử lý nhiều đầu vào và đầu ra","local":"xử-lý-nhiều-đầu-vào-và-đầu-ra","sections":[{"title":"Phương thức launch()","local":"phương-thức-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Hãy áp dụng nó!","local":"-hãy-áp-dụng-nó","sections":[],"depth":2}],"depth":1}';function Kn(hn){return Qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class se extends Vn{constructor(w){super(),Sn(this,w,Kn,Fn,Wn,{})}}export{se as component};
