---
license: mit
task_categories:
- object-detection
language:
- en
tags:
- computer-vision
- object-detection
- yolo
pretty_name: YOLO Object Detection Dataset
size_categories:
- 10K<n<100K
---

# YOLO Object Detection Dataset

## Dataset Description

This dataset contains 30 object classes in YOLO format for object detection tasks.

### Classes

- 0: avatar
- 1: avatar-nonhuman
- 2: button
- 3: campfire
- 4: chat box
- 5: chat bubble
- 6: controller
- 7: dashboard
- 8: guardian
- 9: hand
- 10: hud
- 11: indicator-mute
- 12: interactable
- 13: locomotion-target
- 14: menu
- 15: out of bounds
- 16: portal
- 17: progress bar
- 18: seat-multiple
- 19: seat-single
- 20: sign-graphic
- 21: sign-text
- 22: spawner
- 23: table
- 24: target
- 25: ui-graphic
- 26: ui-text
- 27: watch
- 28: writing surface
- 29: writing utensil

### Dataset Structure

```
dataset/
├── train/
│   ├── images/        # Training images (.jpg)
│   └── labels/        # YOLO annotations (.txt)
├── valid/
│   ├── images/        # Validation images
│   └── labels/        # YOLO annotations
├── test/
│   ├── images/        # Test images
│   └── labels/        # YOLO annotations
└── data.yaml          # Dataset configuration
```

### Usage

#### With YOLOv8/Ultralytics
```python
from ultralytics import YOLO
model = YOLO('yolov8n.pt')
model.train(data='path/to/data.yaml', epochs=100)
```

#### With Transformers
```python
from datasets import load_dataset
dataset = load_dataset("dkillough/DISCOVR")
```
