import os
import io
import av
import lmdb
import json
from pickle import dumps, loads
import numpy as np
import torch
from torchvision.transforms.functional import resize
import tensorflow as tf
import tensorflow_datasets as tfds
from einops import rearrange

def save_video(file, video):
    container = av.open(file, 'w', 'mp4')
    stream = container.add_stream('libx264', rate=30)
    stream.height = video[0].shape[0]
    stream.width = video[0].shape[1]
    stream.bit_rate = 2000000 # 2Mbps
    stream.pix_fmt = 'yuv420p'
    for i in range(len(video)):
        frame = av.VideoFrame.from_ndarray(video[i], format='rgb24')
        frame = frame.reformat(format=stream.pix_fmt)
        for packet in stream.encode(frame):
            container.mux(packet)
    # Flush stream
    for packet in stream.encode():
        container.mux(packet)
    container.close()

if __name__ == '__main__':
    tf_builder = tfds.builder_from_directory('./droid/1.0.0/')
    tf_dataset = tf_builder.as_dataset(split="train")
    data_dir = './lmdb_dataset'
    if not os.path.exists(data_dir):
        os.makedirs(data_dir)
    env = lmdb.open(data_dir, map_size=int(3e12)) # maximum size of memory map is 3TB
    saved_id = 0
    for episode_id, episode in enumerate(tf_dataset):
        file_path = episode['episode_metadata']['file_path'].numpy().decode('utf-8')
        recording_folderpath = episode['episode_metadata']['recording_folderpath'].numpy().decode('utf-8')
        if 'success' not in file_path:
            print(f'skipping {episode_id}/{len(tf_dataset)}')
            continue
        left_camera = []
        arm_camera = []
        right_camera = []
        cartesian_pos = []
        cartesian_action = []
        gripper_pos = []
        gripper_action = []
        joint_pos = []
        joint_action = []
        reward = []
        inst = []
        skip_episode = False
        for step_id, single_step in enumerate(episode['steps']):
            if single_step['language_instruction'].numpy().decode('utf-8') not in inst:
                inst.append(single_step['language_instruction'].numpy().decode('utf-8'))
            if single_step['language_instruction_2'].numpy().decode('utf-8') not in inst:
                inst.append(single_step['language_instruction_2'].numpy().decode('utf-8'))
            if single_step['language_instruction_3'].numpy().decode('utf-8') not in inst:
                inst.append(single_step['language_instruction_3'].numpy().decode('utf-8'))
            if len(inst) == 1 and inst[0] == '':
                skip_episode = True
                break
            '''
            TODO
            left_camera.append(single_step['observation']['exterior_image_1_left'].numpy())
            right_camera.append(single_step['observation']['exterior_image_2_left'].numpy())
            arm_camera.append(single_step['observation']['wrist_image_left'].numpy())
            '''
            cartesian_pos.append(single_step['observation']['cartesian_position'].numpy().tolist())
            gripper_pos.append(single_step['observation']['gripper_position'].numpy().tolist())
            joint_pos.append(single_step['observation']['joint_position'].numpy().tolist())
            cartesian_action.append(single_step['action_dict']['cartesian_position'].numpy().tolist())
            gripper_action.append(single_step['action_dict']['gripper_position'].numpy().tolist())
            joint_action.append(single_step['action_dict']['joint_position'].numpy().tolist())
            reward.append(single_step['reward'].numpy().tolist())
        if skip_episode:
            print(f'skipping {episode_id}/{len(tf_dataset)}')
            continue
        print(f'saving {episode_id}/{len(tf_dataset)}')
        '''
        # TODO
        save_video(f'droid_videos/episode_{episode_id}_left_camera.mp4', left_camera)
        save_video(f'droid_videos/episode_{episode_id}_right_camera.mp4', right_camera)
        save_video(f'droid_videos/episode_{episode_id}_arm_camera.mp4', arm_camera)
        for i in range(len(inst)):
            if inst[i] == '':
                continue
            js_data.append({"path": f'droid_videos/episode_{episode_id}_left_camera.mp4', "recording_folder": recording_folderpath, "cap": [inst[i]]})
            js_data.append({"path": f'droid_videos/episode_{episode_id}_right_camera.mp4', "recording_folder": recording_folderpath, "cap": [inst[i]]})
            js_data.append({"path": f'droid_videos/episode_{episode_id}_arm_camera.mp4', "recording_folder": recording_folderpath, "cap": [inst[i]]})
  
        '''
        for i, command in enumerate(inst):
            if command == '':
                del inst[i]
        episode_data = {
            'episode_id': episode_id,
            'recoding_folder': recording_folderpath,
            'inst': inst,
            'cartesian_pos': np.stack(cartesian_pos),
            'cartesian_action': np.stack(cartesian_action),
            'gripper_pos': np.stack(gripper_pos),
            'gripper_action': np.stack(gripper_action),
            'joint_pos': np.stack(joint_pos),
            'joint_action': np.stack(joint_action),
            'reward': np.stack(reward),
        }
        with env.begin(write=True) as txn:
            txn.put(f'saved_episode_{saved_id}'.encode(), dumps(episode_data))
            saved_id += 1
