import json

# Function to read jsonl files
def read_jsonl(file_path, num_lines=None):
    entries = []
    with open(file_path, 'r') as file:
        lines = file.readlines(num_lines)
        for line in lines:
            entries.append(json.loads(line))
    return entries

# Function to extract and save the required keys to new jsonl files
def save_jsonl(files_data, base_path="/mnt/data/"):
    for file_name, data in files_data.items():
        file_path = base_path + file_name + ".jsonl"
        with open(file_path, 'w') as file:
            for entry in data:
                json.dump(entry, file)
                file.write('\n')

# Extracting the required keys and data
variants = ["cartoon", "handmake", "painting", "sketch", "tattoo", "weather"]
files_data = {}

# Reading all entries in the jsonl file
for entry in read_jsonl('/path/to/your/input/file.jsonl'):  
    question_id = entry['question_id']
    question = entry['question']
    for variant in variants:
        image_key = f"image_{variant}"
        answer_key = f"answer_{variant}" if variant != "tattoo" else "answer_tatto"
        
        file_data = {
            "question_id": question_id,
            "question": question,
            "image": entry[image_key],
            "answer": entry[answer_key],
        }
        if variant not in files_data:
            files_data[variant] = []
        files_data[variant].append(file_data)

# Saving the extracted data to new jsonl files
save_jsonl(files_data)
