import customtkinter, copyright_dict_1005
import os, json, random, NAIA_generation
from danbooru_character import character_dict_count
from danbooru_character import character_dict as character_dict_full
from modules import naia_functions
from artist_dictionary import artist_dict
import pandas as pd
import tkinter as tk
from tkinter import font
import tagbag
import base64, io, time, threading
import character_dictionary as cd
import math, pyperclip
from PIL import Image


class Character_search(customtkinter.CTkToplevel):
    def __init__(self, app, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("캐릭터 검색 및 사전")
        #self.resizable(width=False, height=False)
        self.app = app
        self.attributes('-topmost', True)
        my_font = customtkinter.CTkFont('Pretendard', 13)

        character_book_dict = {}
        favorite_characters = {}

        # 경로를 안전하게 처리하기 위해 os.path.join 사용
        character_book_path = os.path.join('.', 'Character_book.json')
        favorite_characters_path = os.path.join('.', 'favorite_characters.json')

        # Character_book.json 처리
        try:
            if os.path.exists(character_book_path):
                with open(character_book_path, 'r', encoding='utf-8') as f:
                    try:
                        character_book_dict = json.load(f)
                        self.dictionary_parity = True
                    except:
                        character_book_dict = {}
        except FileNotFoundError:
            character_book_dict = {}

        # favorite_characters.json 처리
        try:
            if os.path.exists(favorite_characters_path):
                with open(favorite_characters_path, 'r', encoding='utf-8') as f:
                    try:
                        favorite_characters = json.load(f)
                    except:
                        favorite_characters = {}
        except FileNotFoundError:
            favorite_characters = {}

        def lost_top_most(self):
            self.attributes('-topmost', False)

        def on_close(self):
                self.withdraw()

        frame_head = customtkinter.CTkFrame(self, width=750, height=40)
        frame_head.grid(row =0, column =0, columnspan=5, padx=5, pady=5, sticky="nsew")
        frame_left = customtkinter.CTkFrame(self, width=300, height=520)
        frame_left.grid(row =1, column =0, padx=5, pady=5, sticky="nsew")
        frame_right = customtkinter.CTkFrame(self, width=450, height=520)
        frame_right.grid(row =1, column =2, padx=5, pady=5, sticky="nsew")

        search_word = customtkinter.StringVar()
        search_entry = customtkinter.CTkEntry(frame_head, font=my_font, textvariable=search_word)

        character_prompt_frame = customtkinter.CTkFrame(frame_right)
        character_prompt_frame.grid(row=0, column=0, padx=10, pady=5, sticky="nsew")
        prompt_label = customtkinter.CTkLabel(character_prompt_frame, text="캐릭터 프롬프트: ", font=my_font)
        prompt_label.grid(row=0, column=0, padx=10, pady=5, sticky="w")

        def generate_character(self):
            prompt = character_prompt.get("0.0", "end-1c")
            prompt_cos = cosplay_prompt.get("0.0", "end-1c")
            if app.app_mode == "NAI": concat_entry = generate_entry.get() + ", {{portrait, upper body}}"
            else: concat_entry = generate_entry.get() + ", portrait, upper body"
            keywords = [item.strip() for item in prompt.split(',')]
            if len(keywords) >= 2:
                if app.app_mode == "NAI":
                    keyword = keywords[1]
                    keywords[1] = '{{'+keyword+'}}'
                    keywords.insert(2, concat_entry)
                else:
                    keyword = keywords[1]
                    keywords[1] = keyword.replace("(", "\\(").replace(")", "\\)")
                    keywords.insert(2, concat_entry)
            else:
                keyword = keywords[0]
            request_prompt = ', '.join(keywords)
            instant_image_generation_book(self, request_prompt, keyword, prompt, prompt_cos)

        character_prompt_generation = customtkinter.CTkButton(character_prompt_frame, font=my_font, text="즉시생성", fg_color="grey", hover_color="grey10", command=lambda: generate_character(self))
        character_prompt_generation.grid(row=0, column=1, padx=5, pady=5, sticky="w")
        continuous_generation = customtkinter.IntVar()
        continuous_generation_button = customtkinter.CTkCheckBox(character_prompt_frame, font=my_font, text="빈 도감 자동채우기", variable=continuous_generation)
        continuous_generation_button.grid(row=0, column=2, padx=5, pady=5, sticky="w")

        character_prompt = customtkinter.CTkTextbox(frame_right, font=customtkinter.CTkFont('Pretendard', 15), width=450)
        character_prompt.grid(row=1, column=0, padx=10, pady=5, sticky="w")
        character_prompt.tag_config("yellow_text", foreground="yellow")

        cosplay_prompt_frame = customtkinter.CTkFrame(frame_right)
        cosplay_prompt_frame.grid(row=2, column=0, padx=10, pady=5, sticky="nsew")
        prompt_label = customtkinter.CTkLabel(cosplay_prompt_frame, text="더이상 사용되지 않음:", font=my_font)
        prompt_label.grid(row=0, column=0, padx=10, pady=5, sticky="w")
        cosplay_prompt_generation = customtkinter.CTkButton(cosplay_prompt_frame, font=my_font, text="즉시생성", fg_color="grey", hover_color="grey10", command=lambda: app.instant_image_generation_book())
        cosplay_prompt_generation.grid(row=0, column=1, padx=5, pady=5, sticky="w")
        cosplay_prompt = customtkinter.CTkTextbox(frame_right, font=customtkinter.CTkFont('Pretendard', 15), width=450)
        cosplay_prompt.grid(row=3, column=0, padx=10, pady=5, sticky="w")
        image_label = customtkinter.CTkLabel(frame_right, text="")
        image_label.grid(row=0, rowspan=4, column=1, padx=10, pady=5, sticky="w")
        white_image = Image.new('RGB', (384, 512), 'white')
        white_photo = customtkinter.CTkImage(white_image, size=(384,512))
        image_label.configure(image=white_photo)
        generate_label = customtkinter.CTkLabel(self, text="Portrait 생성시 적용할 선행 고정 프롬프트 : ", font=my_font)
        generate_label.grid(row=2, column=0, padx=5, pady=5, sticky="w")
        generate_entry = customtkinter.CTkEntry(self, font=my_font)
        generate_entry.grid(row=2, column=1, columnspan=2, padx=5, pady=5, sticky="nsew")

        if character_book_dict != None and 'user_fix_prompt' in character_book_dict and character_book_dict['user_fix_prompt'] != None:
            generate_entry.delete(0, "end")
            generate_entry.insert(0, character_book_dict['user_fix_prompt'])

        def instant_image_generation_book(self, request_prompt, character_name, p1, p2):
            if app.running_flag == False and app.automation_button.get() == 0:
                character_prompt_generation.configure(state="disabled")
                #cosplay_prompt_generation.configure(state="disabled")
                app.running_flag = True
                scale_pre = app.cfg_scale_entry.get()
                try:
                    scale_pre = float(scale_pre)
                except:
                    scale_pre = 5.0
                    app.cfg_scale_var.set("5.0")
                rescale_pre = app.prompt_guidance_rescale_entry.get()
                try:
                    rescale_pre = float(rescale_pre)
                except:
                    rescale_pre = 0
                    app.prompt_guidance_rescale_var.set("0")
                uncond_pre = app.uncond_strength_entry.get()
                try:
                    uncond_pre = float(uncond_pre)
                    #uncond_pre = round(uncond_pre / 0.05) * 0.05
                    if (uncond_pre > 162):
                        uncond_pre = 19.19
                        app.uncond_strength_entry.delete(0, "end")
                        app.uncond_strength_entry.insert(0, "1.5")
                except:
                    uncond_pre = 1.0
                    app.uncond_strength_entry.delete(0, "end")
                    app.uncond_strength_entry.insert(0, "1.0")
                if ' + ' in app.sampler_button.get():
                    _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
                else:
                    _sampler = app.sampler_button.get()
                    _noise_schedule = "native"
                gen_request = {
                        "width":896,
                        "height":1152,
                        "quality_toggle":app.auto_quality_toggle.get(),
                        "seed":random.randint(0,2**32 - 1),
                        "sampler":_sampler,
                        "noise_schedule": _noise_schedule,
                        "scale":scale_pre,
                        "sema":app.sema_button.get(),
                        "sema_dyn": app.dyn_button.get(),
                        "cfg_rescale": rescale_pre,
                        "uncond_scale":uncond_pre,
                        "prompt": request_prompt,
                        "negative":app.negative_prompt_input.get("0.0", "end-1c"),
                        "user_screen_size": app.get_max_size(),
                        "start_time": app.start_time,
                        "access_token": app.access_token,
                        "save_folder": app.output_file_path,
                        "png_rule": app.name_var.get(),
                        "type": "normal",
                        "enable_hr" : False,
                        "enable_AD" : False
                    }
                if app.app_mode == "NAI" and app.variety_button.get() == 1:
                    gen_request["skip_cfg_above_sigma"] = True
                if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                    gen_request["dynamic_thresholding"] = True
                if app.app_mode == "WEBUI" and app.sema_button_var.get() == 1:
                    try:
                        hr_steps_pre = int(app.hires_steps_entry.get())
                    except:
                        hr_steps_pre = 16
                        app.hires_steps_entry.delete(0, "end")
                        app.hires_steps_entry.insert(0, '16')
                    try:
                        upscale_pre = float(app.upscale_entry.get())
                        upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                    except:
                        upscale_pre = 1.5
                    app.upscale_entry.delete(0, "end")
                    app.upscale_entry.insert(0, str(upscale_pre))
                    try:
                        denoise_pre = float(app.denoise_entry.get())
                    except:
                        denoise_pre = 0.35
                        app.denoise_entry.delete(0, "end")
                        app.denoise_entry.insert(0, '0.35')
                    gen_request["enable_hr"] = True
                    gen_request["hr_second_pass_steps"] = hr_steps_pre
                    gen_request["hr_upscaler"] = app.hires_sampler_entry.get()
                    gen_request["hr_scale"] = upscale_pre
                    gen_request["denoising_strength"] = denoise_pre
                if app.awai_activate_i2i.get() == 1:
                    gen_request["enable_AD"] = True
                    ad_str_pre = app.autodetailer_strength.get()
                    try:
                        ad_str_pre = float(ad_str_pre)
                        ad_str_pre = round(ad_str_pre, 2)
                    except:
                        ad_str_pre = 0.4
                        app.autodetailer_strength.delete(0, "end")
                        app.autodetailer_strength.insert(0, "0.4")
                    gen_request["ad_data_str"] =  ad_str_pre
                def run_generation():
                        if gen_request["png_rule"] == "count":
                            app.generation_count += 1
                            gen_request["count"] =app.generation_count
                        app.state_label.configure(text ="state : 도감 이미지 요청됨 ", text_color = "#FFFF97")
                        if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                        result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                        app.running_flag = False
                        app.nai_generation_count += 1
                        character_prompt_generation.configure(state="normal")
                        #cosplay_prompt_generation.configure(state="normal")
                        app.state_label.configure(text =f"도감 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                        if info:
                            temp = naia_functions.extract_prompt_info(info, app.app_mode)
                            if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                        else:
                            temp = result_prompt
                        naia_functions.process_text_with_links(app, app.image_label_report, temp, artist_dict)
                        if result_image:
                            image_bytes = io.BytesIO()
                            book_image = Image.open(filename).resize((384,512))
                            book_image = book_image.convert('RGB')
                            book_image.save(image_bytes, format='JPEG', quality=90)
                            image_bytes = base64.b64encode(image_bytes.getvalue()).decode('utf-8')
                            character_book_dict[character_name] = [0, p1, p2, image_bytes]
                            character_book_dict['user_fix_prompt'] = generate_entry.get()
                            fav_button.configure(state="normal")
                            with open('Character_book.json', 'w', encoding='utf-8') as f:
                                json.dump(character_book_dict, f, ensure_ascii=False, indent=4)
                            image_stream = io.BytesIO(base64.b64decode(image_bytes))
                            reloaded_image = Image.open(image_stream)
                            image_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(384,512)))
                            if app.state() != 'zoomed':
                                instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                            else:
                                current_image = Image.open(filename)
                                current_image = Image.open(filename)
                                new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                                instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                            app.image_label.configure(image=instant_result_image)
                            app.ext_set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                            if continuous_generation.get() == 1:
                                listbox.focus()
                                instant_wait = round(random.uniform(3.5, 5.5) + app.delay_offset + (11.4 - response_time), 2)
                                cosplay_prompt.delete("0.0", "end")
                                cosplay_prompt.insert("0.0", f"다음 생성까지의 지연시간 : {instant_wait}초 \n자동화 설정의 딜레이 옵션에 영향을 받습니다.")
                                if instant_wait > 0: time.sleep(int(instant_wait))
                                app.after(500, move_selection_down(self))
                        else:
                            if continuous_generation.get() == 1:
                                app.after(500, generate_character(self))
                generation_thread = threading.Thread(target=run_generation, daemon=True)
                generation_thread.start()

        def move_selection_down(self):
            selected_indices = listbox.curselection()
            if selected_indices:
                current_index = selected_indices[0]
                next_index = current_index + 1

                # 리스트의 끝을 넘어가지 않도록 확인
                if next_index < listbox.size():
                    listbox.selection_clear(current_index)
                    listbox.selection_set(next_index)
                    listbox.see(next_index)
                else:
                    continuous_generation_button.deselect()
                keyword_with_count = listbox.get(next_index).strip()
                keyword = keyword_with_count.split(' - ')[0].strip()
                if keyword not in character_book_dict and continuous_generation.get() == 1:
                    character_prompt.delete("0.0", "end")
                    character_prompt.insert("0.0", character_dict_full[keyword])
                    app.after(500, generate_character(self))
                elif continuous_generation.get() == 1:
                    app.after(500, move_selection_down(self))

        def on_key_release(event):
            search_keyword = search_entry.get()
            update_listbox(search_keyword)

        def on_search():
            # 검색 버튼 이벤트 처리 함수
            selected_indices = listbox.curselection()
            if not selected_indices:  # If there is no selection
                print("No selection made.")
                return
        
            # Assuming the first selected index (single selection mode)
            selected_index = selected_indices[0]
            # Get the keyword from the listbox, split by '-', and trim whitespace
            keyword_with_count = listbox.get(selected_index).strip()
            keyword = keyword_with_count.split(' - ')[0].strip()
        
            # Call the analyze function with the selected keyword
            print(f"Analyzing keyword: {keyword}")
            character, cosplay = analyze_keywords_in_data('csdataset2.parquet', keyword)
            character_prompt.delete("0.0", "end")
            character_prompt.insert("0.0", character)
            cosplay_prompt.delete("0.0", "end")
            cosplay_prompt.insert("0.0", cosplay)

        def analyze_keywords_in_data(parquet_file, keyword):
            # Parquet 파일 읽기
            df = pd.read_parquet(parquet_file)
        
            bag_of_tags = ['penis', 'character name', 'upper body','holding','full body', 'artist name', 'male focus', 'open mouth', 'mature male', 'muscular', 'muscular male', 'closed mouth','closed eyes', 'white background', 'solo', 'breasts', 'simple background', 'smile', 'looking at viewer', 'flat chest', 'small breasts', 'medium breasts', 'large breasts', 'huge breasts','aqua eyes', 'black eyes', 'blue eyes', 'brown eyes', 'green eyes', 'grey eyes', 'orange eyes', 'purple eyes', 'pink eyes', 'red eyes', 'white eyes', 'yellow eyes', 'amber eyes', 'heterochromia', 'multicolored eyes', 'aqua pupils', 'blue pupils', 'brown pupils', 'green pupils', 'grey pupils', 'orange pupils', 'pink pupils', 'purple pupils', 'red pupils', 'white pupils', 'yellow pupils', 'pointy ears', 'long pointy ears', 'aqua hair', 'black hair', 'blonde hair', 'blue hair', 'light blue hair', 'dark blue hair', 'brown hair', 'light brown hair', 'green hair', 'dark green hair', 'light green hair', 'grey hair', 'orange hair', 'pink hair', 'purple hair', 'light purple hair', 'red hair', 'white hair', 'multicolored hair', 'colored inner hair', 'colored tips', 'roots (hair)', 'gradient hair', 'print hair', 'rainbow hair', 'split-color hair', 'spotted hair', 'streaked hair', 'two-tone hair', 'very short hair', 'short hair', 'medium hair', 'long hair', 'very long hair', 'absurdly long hair', 'big hair', 'bald', 'bald girl', 'bob cut', 'inverted bob', 'bowl cut', 'buzz cut', 'chonmage', 'crew cut', 'flattop', 'okappa', 'pixie cut', 'undercut', 'flipped hair', 'wolf cut', 'cornrows', 'dreadlocks', 'hime cut', 'mullet', 'bow-shaped hair', 'braid', 'braided bangs', 'front braid', 'side braid', 'french braid', 'crown braid', 'single braid', 'multiple braids', 'twin braids', 'low twin braids', 'tri braids', 'quad braids', 'flower-shaped hair', 'hair bun', 'braided bun', 'single hair bun', 'double bun', 'cone hair bun', 'doughnut hair bun', 'heart hair bun', 'triple bun', 'cone hair bun', 'hair rings', 'single hair ring', 'half updo', 'one side up', 'two side up', 'low-braided long hair', 'low-tied long hair', 'mizura', 'multi-tied hair', 'nihongami', 'ponytail', 'folded ponytail', 'front ponytail', 'high ponytail', 'short ponytail', 'side ponytail', 'split ponytail', 'star-shaped hair', 'topknot', 'twintails', 'low twintails', 'short twintails', 'uneven twintails', 'tri tails', 'quad tails', 'quin tails', 'twisted hair', 'afro', 'huge afro', 'beehive hairdo', 'crested hair', 'pompadour', 'quiff', 'shouten pegasus mix mori', 'curly hair', 'drill hair', 'twin drills', 'tri drills', 'hair flaps', 'messy hair', 'pointy hair', 'ringlets', 'spiked hair', 'straight hair', 'wavy hair', 'bangs', 'arched bangs', 'asymmetrical bangs', 'bangs pinned back', 'blunt bangs', 'crossed bangs', 'diagonal bangs', 'dyed bangs', 'fanged bangs', 'hair over eyes', 'hair over one eye', 'long bangs', 'parted bangs', 'curtained hair', 'ribbon bangs', 'short bangs', 'swept bangs', 'hair between eyes', 'hair intakes', 'single hair intake', 'sidelocks', 'asymmetrical sidelocks', 'drill sidelocks', 'low-tied sidelocks', 'sidelocks tied back', 'single sidelock', 'ahoge', 'heart ahoge', 'huge ahoge', 'antenna hair', 'heart antenna hair', 'comb over', 'hair pulled back', 'hair slicked back', 'mohawk', 'oseledets', 'lone nape hair', 'hair bikini', 'hair censor', 'hair in own mouth', 'hair over breasts', 'hair over one breast', 'hair over crotch', 'hair over shoulder', 'hair scarf', 'alternate hairstyle', 'hair down', 'hair up', 'asymmetrical hair', 'sidecut', 'blunt ends', 'dark skin', 'dark-skinned female', 'pale skin', 'sun tatoo', 'black skin', 'blue skin', 'green skin', 'grey skin', 'orange skin', 'pink skin', 'purple skin', 'red skin', 'white skin', 'yellow skin', 'colored skin', 'multiple tails', 'demon tail', 'dragon tail', 'ghost tail', 'pikachu tail', 'snake head tail', 'fiery tail', 'bear tail', 'rabbit tail', 'cat tail', 'cow tail', 'deer tail', 'dog tail', 'ermine tail', 'fox tail', 'horse tail', 'leopard tail', 'lion tail', 'monkey tail', 'mouse tail', 'pig tail', 'sheep tail', 'squirrel tail', 'tiger tail', 'wolf tail', 'crocodilian tail', 'fish tail', 'scorpion tail', 'snake tail', 'tadpole tail']
            mini_bag_of_tags = ['penis', 'character name', 'upper body', 'full body',  'alternate costume','artist name', 'male focus', 'open mouth', 'mature male', 'muscular', 'muscular male', 'closed mouth','closed eyes','white background', 'solo', 'breasts', 'simple background', 'smile', 'looking at viewer']
            # 'character' 열에서 keyword에 해당하는 행만 필터링
            filtered_df = df[df['character'] == keyword]
            filtered_df = filtered_df[~filtered_df['character'].str.contains(',', na=False)]
            if filtered_df.empty:
                filtered_df = df[df['character'].str.contains(keyword, na=False, regex=False)]
            filtered_df = filtered_df[~(filtered_df['rating'] == 'e')]
            #print(len(filtered_df))
            # keyword:count 형태로 데이터 집계할 딕셔너리 생성
            keyword_count_dict = {}
        
            # 각 행의 'general' 열 처리
            for general in filtered_df['general']:
                # 문자열 분할
                tags = [tag.strip() for tag in general.split(',')]
                
                # 딕셔너리에 각 태그의 count 추가
                for tag in tags:
                    keyword_count_dict[tag] = keyword_count_dict.get(tag, 0) + 1
        
            # 특정 키워드 제외
            exclude_keywords = bag_of_tags
            keyword_count_dict1 = keyword_count_dict.copy()
            keyword_count_dict1 = {k: v for k, v in keyword_count_dict1.items() if k not in mini_bag_of_tags}
            keyword_count_dict = {k: v for k, v in keyword_count_dict.items() if k not in exclude_keywords}
        
            # 가장 높은 count 값 찾기
            highest_count = max(keyword_count_dict.values()) if keyword_count_dict else 0
            highest_count1 = max(keyword_count_dict1.values()) if keyword_count_dict1 else 0
        
            if(len(filtered_df)) < 10:
                weight = 0.6
            elif(len(filtered_df)) < 30:
                weight = 0.5
            elif(len(filtered_df)) < 80:
                weight = 0.45
            elif(len(filtered_df)) < 160:
                weight = 0.35
            elif(len(filtered_df)) < 280:
                weight = 0.3
            else:
                weight = 0.2
            
            result_list = []
            result_list1 = []
            # count가 highest_count*0.4 이상인 키워드 출력
            for k, v in keyword_count_dict.items():
                if '|' in k: continue
                if v >= highest_count * weight:
                    result_list.append(k)
        
            for k, v in keyword_count_dict1.items():
                if '|' in k: continue
                if v >= highest_count1 * weight:
                    result_list1.append(k)
        
            result_list1.insert(1, keyword)
            result_list.insert(1, "alternative costume, ["+keyword+" (cosplay)]")
            return ", ".join(result_list1),", ".join(result_list)

        def update_listbox(search_keyword):
            # Clear the listbox
            if listbox.size() > 0:
                listbox.delete(0, "end")

            # List to hold all matching keywords and counts
            all_matching_keywords = []

            # Set to track added keywords to avoid duplicates
            added_keywords = set()

            # Check if the search keyword is not empty and has at least 3 characters
            if search_keyword and len(search_keyword) >= 3:
                # Search in copyright_dict first
                for key, keywords in copyright_dict_1005.copyright_dict.items():
                    if search_keyword.lower() in key.lower():
                        for keyword in keywords:
                            count = character_dict_count.get(keyword, 0)
                            if count > 50 and keyword not in added_keywords and keyword in character_dict_full:
                                all_matching_keywords.append((keyword, count))
                                added_keywords.add(keyword)

                # Then search in character_dictionary
                matching_keywords = [
                    (k, v) for k, v in character_dict_count.items()
                    if search_keyword.lower() in k.lower() and v > 50 and k not in added_keywords and k in character_dict_full
                ]
                all_matching_keywords.extend(matching_keywords)

            else:
                # Sort all keywords by count in descending order
                all_matching_keywords = [
                    (k, v) for k, v in cd.character_dictionary.items() if v > 50 and k not in added_keywords and k in character_dict_full
                ]

            # Now sort all matching keywords by count in descending order and insert into listbox
            all_matching_keywords.sort(key=lambda item: item[1], reverse=True)
            for keyword, count in all_matching_keywords:
                    listbox.insert("end", f"{keyword} - {count}")

        search_entry.grid(row =0, column =0, padx=5, pady=5, sticky="nsew")
        search_entry.bind("<KeyRelease>", on_key_release) 
        search_label = customtkinter.CTkLabel(frame_head, text="◀ 검색 대상 copyright/character 입력 (English) | 성능 이슈로 Danbooru 20장 이상만 표시", font=my_font)
        search_label.grid(row =0, column =1, padx=5, pady=5, sticky="w")
        self.after(2500, lambda: self.attributes('-topmost', False))

        def show_image(event):
            highlight_tags = ["aqua","black","blonde","blue","brown","cyan","green","grey","orange","pink","purple","red","violet","white","yellow","mouth", "eyes", " cap", " ears", " girl", " ornament", " hat", "beret", " ear "]

            def insert_with_color(cs_text_input, current_lookup):
                words = [word.strip() for word in current_lookup.split(',')]
                for index, word in enumerate(words):
                    highlight = False
                    start_index = cs_text_input.index("end-1c")
                    if index == len(words) - 1:  # 마지막 원소인 경우
                        cs_text_input.insert("end", word)
                    else:
                        cs_text_input.insert("end", word + ", ")
                    end_index = cs_text_input.index("end-1c")

                    for tag in highlight_tags:
                        if tag in word:
                            highlight = True
                    if word == "hat": highlight = True
                    # 조건 확인
                    if word == keyword or word in tagbag.bag_of_tags[5:] or 'tail' in word or 'pupil' in word:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#FFFF97")
                    elif highlight:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#AED395")
            selected_indices = listbox.curselection()
            selected_index = selected_indices[0]
            keyword_with_count = listbox.get(selected_index).strip()
            keyword = keyword_with_count.split(' - ')[0].strip()
            character_prompt.delete("0.0", "end")
            if keyword in character_dict_full: insert_with_color(character_prompt, character_dict_full[keyword])
            if keyword in character_book_dict:
                try:
                    image_stream = io.BytesIO(base64.b64decode(character_book_dict[keyword][3]))
                    reloaded_image = Image.open(image_stream)
                    image_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(384,512)))
                    #cosplay_prompt.delete("0.0", "end")
                    #insert_with_color(cosplay_prompt, character_book_dict[keyword][2])
                    try:
                        fav_rem_button.grid_forget()
                        fav_button.grid(row = 0, column=0, padx=5, pady=5, sticky="n")
                    except:
                        pass
                    fav_button.configure(state="normal")
                    if keyword in favorite_characters:
                        fav_button.grid_forget()
                        fav_rem_button.grid(row = 0, column=0, padx=5, pady=5, sticky="n")                 
                except:
                    return
            else:
                fav_button.configure(state="disabled")
                image_label.configure(image=white_photo)

        listbox = tk.Listbox(frame_left, width=32, height=30, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
        listbox.bind('<<ListboxSelect>>', show_image)
        listbox.grid(row = 0, column=0, padx=5, pady=5, sticky="nsew")
        scrollbar = tk.Scrollbar(frame_left, orient="v", command=listbox.yview)
        scrollbar.grid(row=0, column=1, sticky='ns')
        listbox.config(yscrollcommand=scrollbar.set)

        search_frame = customtkinter.CTkFrame(self)
        search_frame.grid(row = 1, column=1, padx=5, pady=140, sticky="w")

        def add_favorite():
            selected_indices = listbox.curselection()
            selected_index = selected_indices[0]
            keyword_with_count = listbox.get(selected_index).strip()
            keyword = keyword_with_count.split(' - ')[0].strip()
            words = [word.strip() for word in character_prompt.get("0.0","end").split(',')]
            description = []
            for word in words:
                if word == keyword or word in tagbag.bag_of_tags[5:] or 'tail' in word or 'pupil' in word:
                    description.append(word)
            favorite_characters[keyword] = ', '.join(description)
            with open('favorite_characters.json', 'w', encoding='utf-8') as f:
                json.dump(favorite_characters, f, ensure_ascii=False, indent=4)
            with open('wildcards/favorite_character.txt', 'w') as file:
                for value in favorite_characters.values():
                    file.write('100:' + value + '\n')
            fav_button.grid_forget()
            fav_rem_button.grid(row = 0, column=0, padx=5, pady=5, sticky="n")
            character_prompt.delete("0.0", "end")
            character_prompt.insert("0.0", f"favorite_character 와일드카드에 캐릭터 정보가 추가되었습니다 : {favorite_characters[keyword]}", "yellow_text")
            fav_button.configure(state="disabled")

        def rem_favorite():
            selected_indices = listbox.curselection()
            selected_index = selected_indices[0]
            keyword_with_count = listbox.get(selected_index).strip()
            keyword = keyword_with_count.split(' - ')[0].strip()
            del favorite_characters[keyword]
            with open('favorite_characters.json', 'w', encoding='utf-8') as f:
                json.dump(favorite_characters, f, ensure_ascii=False, indent=4)
            with open('wildcards/favorite_character.txt', 'w') as file:
                for value in favorite_characters.values():
                    file.write('100:' + value + '\n')
            fav_rem_button.grid_forget()
            fav_button.grid(row = 0, column=0, padx=5, pady=5, sticky="n")


        fav_button = customtkinter.CTkButton(search_frame, font=my_font, text="Favorite 등록", state="disabled", command=add_favorite)
        fav_button.grid(row = 0, column=0, padx=5, pady=5, sticky="n")

        fav_rem_button = customtkinter.CTkButton(search_frame, font=my_font, text="Favorite 제거", command=rem_favorite, fg_color="#FFFFFF", hover_color="grey", text_color="#FF362B")

        search_button = customtkinter.CTkButton(search_frame, font=my_font, text="조회", fg_color="grey", hover_color="grey10", command=on_search)
        search_button.grid(row = 1, column=0, padx=5, pady=5, sticky="n")

        all_keywords = sorted(
                    ((k, v) for k, v in character_dict_count.items() if v > 50),
                    key=lambda item: item[1],
                    reverse=True
                )
        for keyword, count in all_keywords:
            if keyword in character_dict_full:
                listbox.insert("end", f"{keyword} - {count}")
        
        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))

        collection_button = customtkinter.CTkButton(frame_head, text="Copyright 도감", font=my_font, fg_color="grey", hover_color="grey10", command=lambda: open_collection(self))
        collection_button.grid(row =0, column =2, padx=50, pady=5, sticky="e")

        #add_custom_character_button = customtkinter.CTkButton(frame_head, text="Copyright 도감", font=my_font, fg_color="grey", hover_color="grey10", command=lambda: open_collection(self))
        #add_custom_character_button.grid(row =0, column =3, padx=50, pady=5, sticky="e")

        def open_collection(self):
            self.attributes('-topmost', False)
            collection_window = customtkinter.CTkToplevel()
            collection_window.title("도감")
            collection_window.attributes('-topmost', True)
            collection_window.resizable(width=False, height=False)

            _height = app.winfo_screenheight()
            if _height < 1152:
                yview = 660
                ylist = 46
            else:
                yview = 700
                ylist = 50

            collection_frame_head = customtkinter.CTkFrame(collection_window, width=1220, height=40)
            collection_frame_head.grid(row =0, column =0, columnspan=5, padx=5, pady=5, sticky="nsew")

            collection_label1 = customtkinter.CTkLabel(collection_frame_head, font=my_font, text="이름을 눌러 특징을 복사합니다.")
            collection_label1.grid(row = 0, column=0, padx=5, pady=5, sticky="nsew")

            collection_frame_left = customtkinter.CTkFrame(collection_window, width=300, height=yview)
            collection_frame_left.grid(row =1, column =0, padx=5, pady=5, sticky="nsew")
            collection_frame_right = customtkinter.CTkScrollableFrame(collection_window, width=900, height=yview)
            collection_frame_right.grid(row =1, column =2, padx=5, pady=5, sticky="nsew")

            show_window = []

            def copy_character_info(key):
                text = character_book_dict[key][1].split(',')
                text_list = [keyword.strip() for keyword in text]
                charactersitics = []
                charactersitics.append(key)
                count = 0
                for texts in text_list: 
                    if count < 4 and texts in tagbag.bag_of_tags[5:]  and 'tail' not in texts and 'pupil' not in texts and '1girl' not in texts and '1boy' not in texts and '1other' not in texts:
                        charactersitics.append(texts)
                        count += 1
                texts = ', '.join(charactersitics)
                pyperclip.copy(texts)
                collection_label1.configure(text=f"선택하신 {texts}가 클립보드에 복사되었습니다.", text_color="#FFFF97")




            def spread_image(event, show_window):
                collection_frame_right._parent_canvas.yview_moveto(0)
                selected_indices = collection_listbox.curselection()
                selected_index = selected_indices[0]
                collection_listbox.configure(state="disabled")
                if show_window:
                    for i in show_window:
                        i.destroy()
                keyword_with_count = collection_listbox.get(selected_index).strip()
                keyword = ' '.join(keyword_with_count.split('%')[1].split()).strip()
                try:
                    key_in_book = split_dict[keyword]
                    # 나머지 코드...
                except KeyError:
                    print(f"KeyError: '{keyword}' not found in the split dictionary.")
                count = 0
                for key in key_in_book:
                    _row = count//3
                    _column = count%3
                    if key in character_book_dict:
                        f = customtkinter.CTkFrame(collection_frame_right, width = 298, height=394)
                        f.grid(row=_row, column=_column, padx=5, pady=5, sticky="nsew")
                        name = key
                        if len(key) > 45:
                            name = key[:44]
                        b = customtkinter.CTkButton(f, font=my_font,text=name, state="disabled" if len(key) > 45 else "normal", fg_color="grey10", hover_color="grey10", text_color_disabled="white", command=lambda name=name: copy_character_info(name))
                        b.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                        image_stream = io.BytesIO(base64.b64decode(character_book_dict[key][3]))
                        reloaded_image = Image.open(image_stream)
                        i = customtkinter.CTkLabel(f, text="", image=customtkinter.CTkImage(reloaded_image, size=(288,384)))
                        i.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                        show_window.append(f)
                        count += 1
                collection_listbox.configure(state="normal")
                collection_listbox.selection_clear(selected_index)

            collection_listbox = tk.Listbox(collection_frame_left, width=32, height=ylist, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
            collection_listbox.bind('<<ListboxSelect>>',lambda event:  spread_image(event, show_window))
            collection_listbox.grid(row = 0, column=0, padx=5, pady=5, sticky="nsew")
            scrollbar = tk.Scrollbar(collection_frame_left, orient="v", command=collection_listbox.yview)
            scrollbar.grid(row=0, column=1, sticky='ns')
            collection_listbox.config(yscrollcommand=scrollbar.set)

            

            all_collections = sorted(
                ((k, v) for k, v in copyright_dict_1005.copyright_dict.items()),
                key=lambda item: len(item[1]),
                reverse=True
            )
            all_collections.insert(0, ('Favorites', list(favorite_characters.keys())))

            split_dict = {}
            for keyword, value in all_collections:
                if keyword == 'Favorites':
                    key_in_book = list(favorite_characters.keys())
                    cover = sum(key in character_book_dict for key in key_in_book)
                    coverage = f"{round((cover / len(key_in_book)) * 100, 1) if cover else 0}%"
                else:
                    key_in_book = copyright_dict_1005.copyright_dict[keyword]
                    cover = sum(key in character_book_dict for key in key_in_book)
                    coverage = f"{round((cover / len(key_in_book)) * 100, 1) if cover else 0}%"
                
                # key_in_book의 길이가 90을 초과하는 경우 처리
                if len(key_in_book) > 96:
                    for i in range(0, len(key_in_book), 96):
                        part_key = f"{keyword} ({i//96 + 1})"
                        split_dict[part_key] = key_in_book[i:i+96]
                        cover_part = sum(key in character_book_dict for key in split_dict[part_key])
                        coverage_part = f"{round((cover_part / len(split_dict[part_key])) * 100, 1) if cover_part else 0}%"
                        collection_listbox.insert("end", f"{coverage_part:<7s}{keyword} ({i//96 + 1})")
                else:
                    split_dict[keyword] = key_in_book
                    collection_listbox.insert("end", f"{coverage:<7s}{keyword}")
