import customtkinter
import os, webbrowser
import time
import threading
from plyer import notification

class Automation_setting(customtkinter.CTkToplevel):
    def __init__(self, app, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("Automation 종료/지연 설정")

        self.var = customtkinter.StringVar()
        self.attributes('-topmost', True)
        my_font = customtkinter.CTkFont('Pretendard', 13)
        self.app = app

        def show_option(self):
            if self.var.get() == 'timer':
                self.timer_label.grid(row=4, column=0, pady=5)
                self.timer_entry.grid(row=4, column=1, pady=5)
                self.windows_shutdown_check.grid(row=5, column=0, columnspan=3, sticky="n", pady=5)
                self.reapply_automation_check.grid(row=6, column=0, columnspan=3, sticky="n", pady=5)
                self.notify_check.grid(row=7, column=0, columnspan=3, sticky="n", pady=5)
                self.count_label.grid_forget()
                self.count_entry.grid_forget()
            elif self.var.get() == 'count':
                self.count_label.grid(row=4, column=0, pady=5)
                self.count_entry.grid(row=4, column=1, pady=5)
                self.windows_shutdown_check.grid(row=5, column=0, columnspan=3, sticky="n", pady=5)
                self.reapply_automation_check.grid(row=6, column=0, columnspan=3, sticky="n", pady=5)
                self.notify_check.grid(row=7, column=0, columnspan=3, sticky="n", pady=5)
                self.timer_label.grid_forget()
                self.timer_entry.grid_forget()
            else:
                self.timer_label.grid_forget()
                self.timer_entry.grid_forget()
                self.count_label.grid_forget()
                self.count_entry.grid_forget()
                self.windows_shutdown_check.grid_forget()
                self.reapply_automation_check.grid_forget()
                self.notify_check.grid_forget()

        def on_close(self):
            self.withdraw()

        self.upper_frame = customtkinter.CTkFrame(self, fg_color="#242424")
        self.upper_frame.grid(row=0, column=0, columnspan=3, sticky="n")

        self.label_time = customtkinter.CTkLabel(self.upper_frame, text="이미지 생성당 지연시간 추가 (초) : 2초 권장", font = my_font)
        self.label_time.grid(row=0, column=0, columnspan=3, sticky="n")

        self.delay_entry = customtkinter.CTkEntry(self.upper_frame, font = my_font)
        self.delay_entry.grid(row=1, column=0, sticky="n")
        self.delay_entry.insert(0, self.app.delay_offset)

        self.lazymode = customtkinter.CTkCheckBox(self.upper_frame, font = my_font, text="랜덤 지연시간")
        self.lazymode.grid(row=1, column=1, columnspan=2, sticky="n", padx=8)

        self.repeat_frame = customtkinter.CTkFrame(self, fg_color="#242424")
        self.repeat_frame.grid(row=2, column=0, columnspan=3, sticky="n")

        self.label_repeat = customtkinter.CTkLabel(self.repeat_frame, text="동일 이미지를 다음 횟수만큼 반복하여 생성 (Default=1)", font = my_font)
        self.label_repeat.grid(row=0, column=0, columnspan=3, sticky="n")

        self.repeat_entry = customtkinter.CTkEntry(self.repeat_frame, font = my_font, width=70)
        self.repeat_entry.grid(row=1, column=0, columnspan=3, sticky="n")

        def set_wc_hold():
            if self.repeat_wildcard_hold_var.get() == 1:
                self.app.hold_wildcard = True
            else:
                self.app.hold_wildcard = False

        self.repeat_wildcard_hold_var = customtkinter.IntVar()
        self.repeat_wildcard_hold = customtkinter.CTkCheckBox(self.repeat_frame, font = my_font, text="와일드카드 고정", variable=self.repeat_wildcard_hold_var, command=set_wc_hold, border_color="grey10", state="disabled" if self.app.toggle_wildcard_preopen.get() == 1 else "normal")
        #self.repeat_wildcard_hold.grid(row=1, column=2, sticky="n")

        self.repeat_wildcard_hold_exp = customtkinter.CTkLabel(self.repeat_frame, text="와일드카드 고정 : 선행프롬의 와일드카드 먼저 오픈 옵션을 끄셔야 합니다", font = my_font, text_color = "#FFFF97")
        #self.repeat_wildcard_hold_exp.grid(row=2, column=0, columnspan=3, sticky="n")

        self.label_wildcard_repeat = customtkinter.CTkLabel(self.repeat_frame, text="와일드카드 개봉시 다음 횟수만큼 연속으로 할당 (Default=1)", font = my_font)
        self.label_wildcard_repeat.grid(row=3, column=0, columnspan=3, sticky="n")

        self.wildcard_repeat_entry = customtkinter.CTkEntry(self.repeat_frame, font = my_font, width=70)
        self.wildcard_repeat_entry.grid(row=4, column=0,columnspan=3,  sticky="n")
        self.wildcard_repeat_entry.insert(0, str(self.app.wildcard_preopen_repeat))

        self.label = customtkinter.CTkLabel(self.repeat_frame, text="자동화 종료 조건", font = my_font)
        self.label.grid(row=5, column=0, columnspan=3, sticky="n")

        self.prompt_label = customtkinter.CTkLabel(self.repeat_frame, text="프롬프트 재탑재 (ctrl+랜덤) 기능 설정", font = my_font)
        #self.prompt_label.grid(row=6, column=0, columnspan=3, sticky="n")

        self.radio1 = customtkinter.CTkRadioButton(self, text="무제한", variable=self.var, value="unlimited", command=lambda: show_option(self), font = my_font)
        self.radio1.grid(row=3, column=0)
        self.radio2 = customtkinter.CTkRadioButton(self, text="타이머", variable=self.var, value="timer", command=lambda: show_option(self), font = my_font)
        self.radio2.grid(row=3, column=1)
        self.radio3 = customtkinter.CTkRadioButton(self, text="생성카운트", variable=self.var, value="count", command=lambda: show_option(self), font = my_font)
        self.radio3.grid(row=3, column=2)

        self.timer_label = customtkinter.CTkLabel(self, text="자동화 동작 시간(분) : ", font = my_font)
        self.timer_entry = customtkinter.CTkEntry(self)

        self.count_label = customtkinter.CTkLabel(self, text="자동 생성 횟수 : ", font = my_font)
        self.count_entry = customtkinter.CTkEntry(self)

        self.windows_shutdown = customtkinter.IntVar()
        self.windows_shutdown_check = customtkinter.CTkCheckBox(self, text="자동화가 자동으로 끝나면 윈도우를 종료합니다.", variable=self.windows_shutdown, font = my_font)

        self.reapply_automation = customtkinter.IntVar()
        self.reapply_automation_check = customtkinter.CTkCheckBox(self, text="자동화 버튼을 체크할 때 이 옵션을 다시 적용합니다.", variable=self.reapply_automation, font = my_font)

        self.notify_check = customtkinter.CTkCheckBox(self, text="자동화가 자동으로 끝나면 알림을 보냅니다.", font = my_font)
        self.notify_check.select()

        self.apply_button = customtkinter.CTkButton(self, text="적용", font = my_font, command=lambda: on_apply(self))
        self.stop_button = customtkinter.CTkButton(self, text="중단", font = my_font, command=lambda: on_stop(self))
        self.close_button = customtkinter.CTkButton(self, text="닫기", font = my_font, command=lambda: on_close(self))

        self.apply_button.grid(row=8, column=0, pady=5)
        self.stop_button.grid(row=8, column=1, pady=5)
        self.close_button.grid(row=8, column=2, pady=5)

        self.text_hyperlink = customtkinter.CTkLabel(self, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2")
        self.text_hyperlink.grid(row=9, column=0, columnspan=3, padx=5, pady=15, sticky="n")
        self.text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/101279343"))

        def on_apply(self):
            if self.reapply_automation.get() == 1:
                self.app.reapply_automation_check = True
            else:
                self.app.reapply_automation_check = False
            selected_option = self.var.get()
            if self.delay_entry.get():
                try:
                    self.app.delay_offset = round(float(self.delay_entry.get()), 1)
                    if self.app.delay_offset > 60:
                        self.app.delay_offset = 60
                    elif self.app.delay_offset < -13:
                        self.app.delay_offset = -13
                    self.app.automation_setting_button.configure(text=f"자동화 설정 ({str(round(self.app.delay_offset, 1))}초)")
                    if self.lazymode.get():
                        self.app.lazymode = True
                    else:
                        self.app.lazymode = False
                except ValueError as e:
                    print(e)
                    self.app.delay_offset = 0
            else:
                self.app.delay_offset = 0
                self.app.automation_setting_button.configure(text=f"자동화 설정")
            if self.repeat_entry.get():
                try:
                    self.app.image_generation_repeat = int(self.repeat_entry.get())
                except:
                    self.repeat_entry.delete(0, "end")
                    self.app.image_generation_repeat = 1
            if self.wildcard_repeat_entry.get():
                try:
                    self.app.wildcard_preopen_repeat = int(self.wildcard_repeat_entry.get())
                    self.app.wildcard_preopen_repeat_current = self.app.wildcard_preopen_repeat
                except:
                    self.wildcard_repeat_entry.delete(0, "end")
                    self.app.image_generation_repeat = 1
            if selected_option == "timer":
                self.app.auto_time_left_flag = True
                self.app.auto_count_left_flag = False
                self.app.notify_check = True if self.notify_check.get() == 1 else False
                try:
                    # 엔트리에서 입력된 시간을 분 단위에서 초 단위로 변환
                    self.app.auto_time_left = int(self.timer_entry.get()) * 60
                except ValueError:
                    # 잘못된 입력 처리
                    print("Invalid input for timer. Please enter a number.")
                    return
            elif selected_option == "count":
                self.app.auto_count_left_flag = True
                self.app.auto_time_left_flag = False
                self.app.notify_check = True if self.notify_check.get() == 1 else False
                try:
                    self.app.auto_count_left = int(self.count_entry.get())
                except ValueError:
                    # 잘못된 입력 처리
                    print("Invalid input for count. Please enter a number.")
                    return
            else:
                self.app.auto_time_left_flag = False
                self.app.auto_count_left_flag = False
            on_stop(self)  # 이전 스레드 종료
            start_auto_thread()  # 새 스레드 시작
            
        def show_shutdown_warning():
            def cancel_shutdown():
                os.system("shutdown -a")
                warning_window.destroy()

            def on_warning_window_close():
                if warning_window.after_id is not None:
                    self.app.after_cancel(warning_window.after_id)
                warning_window.destroy()

            self.app.deiconify()
            self.app.lift() 

            warning_window = customtkinter.CTkToplevel(self.app)
            warning_window.title("Shutdown Warning")
            warning_window.attributes("-topmost", True)
            warning_window.protocol("WM_DELETE_WINDOW", on_warning_window_close)
            warning_window.after_id = None

            label = customtkinter.CTkLabel(warning_window, text="     프로그램 및 컴퓨터가 90/120초 후에 종료됩니다.     ", font=my_font)
            label.pack(pady=15)

            cancel_button = customtkinter.CTkButton(warning_window, text="취소", command=cancel_shutdown, font=my_font)
            cancel_button.pack(pady=5)

            # 90초 후에 프로그램 종료
            warning_window.after_id = warning_window.after(90000, self.app.exit_program)

        def shutdown_computer():
            os.system("shutdown /s /t 120")
            show_shutdown_warning()

        def auto_time_thread(stop_event):
            def seconds_to_hms(seconds):
                h = seconds // 3600
                m = (seconds % 3600) // 60
                s = seconds % 60
                if h != 0:
                    if (s%2) == 0:
                        return f"{h:02d}:{m:02d}"
                    else: 
                        return f"{h:02d} {m:02d}"
                else:
                    if (s%2) == 0:
                        return f"{m:02d}:{s:02d}"
                    else: 
                        return f"{m:02d} {s:02d}"
            
            def update_label_for_time_finished():
                self.app.automation_button.configure(text="자동화 (종료됨)")
                self.app.auto_time_left_flag = False
                self.app.automation_button.deselect()
                if self.windows_shutdown.get() == 1:
                    shutdown_computer()
                elif self.app.notify_check == True:
                    notification.notify(
                    title = '자동생성이 완료되었어요.',
                    message = '결과를 확인해 보세요.',
                    app_name = "NAIA",
                    app_icon = self.app.basedir+'/icoico.ico',
                    timeout = 5,  # seconds
                )

            while not stop_event.is_set() and self.app.auto_time_left > 0:
                time.sleep(1)
                self.app.auto_time_left -= 1
                remaining_time = seconds_to_hms(self.app.auto_time_left)
                self.app.after(0, lambda: self.app.automation_button.configure(text=f"자동화 ({remaining_time})"))

            if self.app.auto_time_left <= 0:
                self.app.after(0, update_label_for_time_finished)

            if self.app.stop_event.is_set():
                self.app.after(0, lambda: self.app.automation_button.configure(text="자동화"))
                self.app.auto_time_left_flag = False

        def auto_count_thread(stop_event):
            def update_label_for_count_finished():
                self.app.automation_button.configure(text="자동화 (종료됨)")
                self.app.auto_time_left_flag = False
                self.app.automation_button.deselect()
                if self.windows_shutdown.get() == 1:
                    shutdown_computer()
                elif self.app.notify_check == True:
                    notification.notify(
                    title = '자동생성이 완료되었어요.',
                    message = '결과를 확인해 보세요.',
                    app_name = "NAIA",
                    app_icon = self.app.basedir+'/icoico.ico',
                    timeout = 5,  # seconds
                )

            while not stop_event.is_set():
                time.sleep(1)  # 주기적으로 확인
                self.app.after(0, lambda: self.app.automation_button.configure(text=f"자동화 ({self.app.auto_count_left})"))
                if self.app.auto_count_left <= 0:
                    self.app.after(0, update_label_for_count_finished)
                    break  # 루프 탈출
            if self.app.stop_event.is_set():
                self.app.after(0, lambda: self.app.automation_button.configure(text="자동화"))
                self.app.auto_count_left_flag = False

        # 스레드 시작 및 종료 함수
        def start_auto_thread():
            self.app.stop_event = threading.Event()
            self.app.auto_thread = None

            if self.app.auto_time_left_flag:
                self.app.auto_thread = threading.Thread(target=auto_time_thread, args=(self.app.stop_event,), daemon=True)
            elif self.app.auto_count_left_flag:
                self.app.auto_thread = threading.Thread(target=auto_count_thread, args=(self.app.stop_event,), daemon=True)

            if self.app.auto_thread is not None:
                self.app.auto_thread.start()

        def stop_auto_thread(self):
            if self.app.stop_event is not None:
                self.app.stop_event.set()

        def on_stop(self):
            stop_auto_thread(self)

        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))

    def on_apply(self):
        def auto_time_thread(stop_event):
            def seconds_to_hms(seconds):
                h = seconds // 3600
                m = (seconds % 3600) // 60
                s = seconds % 60
                if h != 0:
                    if (s%2) == 0:
                        return f"{h:02d}:{m:02d}"
                    else: 
                        return f"{h:02d} {m:02d}"
                else:
                    if (s%2) == 0:
                        return f"{m:02d}:{s:02d}"
                    else: 
                        return f"{m:02d} {s:02d}"
            
            def update_label_for_time_finished():
                self.app.automation_button.configure(text="자동화 (종료됨)")
                self.app.auto_time_left_flag = False
                self.app.automation_button.deselect()
                notification.notify(
                title = '자동생성이 완료되었어요.',
                message = '결과를 확인해 보세요.',
                app_name = "NAIA",
                app_icon = self.app.basedir+'/icoico.ico',
                timeout = 5,  # seconds
            )

            while not stop_event.is_set() and self.app.auto_time_left > 0:
                time.sleep(1)
                self.app.auto_time_left -= 1
                remaining_time = seconds_to_hms(self.app.auto_time_left)
                self.app.after(0, lambda: self.app.automation_button.configure(text=f"자동화 ({remaining_time})"))

            if self.app.auto_time_left <= 0:
                self.app.after(0, update_label_for_time_finished)

            if self.app.stop_event.is_set():
                self.app.after(0, lambda: self.app.automation_button.configure(text="자동화"))
                self.app.auto_time_left_flag = False

        def auto_count_thread(stop_event):
            def update_label_for_count_finished():
                self.app.automation_button.configure(text="자동화 (종료됨)")
                self.app.auto_time_left_flag = False
                self.app.automation_button.deselect()
                notification.notify(
                title = '자동생성이 완료되었어요.',
                message = '결과를 확인해 보세요.',
                app_name = "NAIA",
                app_icon = self.app.basedir+'/icoico.ico',
                timeout = 5,  # seconds
                )

            while not stop_event.is_set():
                time.sleep(1)  # 주기적으로 확인
                self.app.after(0, lambda: self.app.automation_button.configure(text=f"자동화 ({self.app.auto_count_left})"))
                if self.app.auto_count_left <= 0:
                    self.app.after(0, update_label_for_count_finished)
                    break  # 루프 탈출
            if self.app.stop_event.is_set():
                self.app.after(0, lambda: self.app.automation_button.configure(text="자동화"))
                self.app.auto_count_left_flag = False
        def stop_auto_thread(self):
            if self.app.stop_event is not None:
                self.app.stop_event.set()

        def on_stop(self):
            stop_auto_thread(self)

        def start_auto_thread():
            self.app.stop_event = threading.Event()
            self.app.auto_thread = None

            if self.app.auto_time_left_flag:
                self.app.auto_thread = threading.Thread(target=auto_time_thread, args=(self.app.stop_event,), daemon=True)
            elif self.app.auto_count_left_flag:
                self.app.auto_thread = threading.Thread(target=auto_count_thread, args=(self.app.stop_event,), daemon=True)

            if self.app.auto_thread is not None:
                self.app.auto_thread.start()

        if self.reapply_automation.get() == 1:
            self.app.reapply_automation_check = True
        else:
            self.app.reapply_automation_check = False
        selected_option = self.var.get()
        if self.delay_entry.get():
            try:
                self.app.delay_offset = round(float(self.delay_entry.get()), 1)
                if self.app.delay_offset > 60:
                    self.app.delay_offset = 60
                elif self.app.delay_offset < -13:
                    self.app.delay_offset = -13
                self.app.automation_setting_button.configure(text=f"자동화 설정 ({str(round(self.app.delay_offset, 1))}초)")
                if self.lazymode.get():
                    self.app.lazymode = True
                else:
                    self.app.lazymode = False
            except ValueError as e:
                print(e)
                self.app.delay_offset = 0
        else:
            self.app.delay_offset = 0
            self.app.automation_setting_button.configure(text=f"자동화 설정")
        if self.repeat_entry.get():
            try:
                self.app.image_generation_repeat = int(self.repeat_entry.get())
            except:
                self.repeat_entry.delete(0, "end")
                self.app.image_generation_repeat = 1
        if self.wildcard_repeat_entry.get():
            try:
                self.app.wildcard_preopen_repeat = int(self.wildcard_repeat_entry.get())
                self.app.wildcard_preopen_repeat_current = self.app.wildcard_preopen_repeat
            except:
                self.wildcard_repeat_entry.delete(0, "end")
                self.app.image_generation_repeat = 1
        if selected_option == "timer":
            self.app.auto_time_left_flag = True
            self.app.auto_count_left_flag = False
            try:
                # 엔트리에서 입력된 시간을 분 단위에서 초 단위로 변환
                self.app.auto_time_left = int(self.timer_entry.get()) * 60
            except ValueError:
                # 잘못된 입력 처리
                print("Invalid input for timer. Please enter a number.")
                return
        elif selected_option == "count":
            self.app.auto_count_left_flag = True
            self.app.auto_time_left_flag = False
            try:
                self.app.auto_count_left = int(self.count_entry.get())
            except ValueError:
                # 잘못된 입력 처리
                print("Invalid input for count. Please enter a number.")
                return
        else:
            self.auto_time_left_flag = False
            self.auto_count_left_flag = False
        on_stop(self)  # 이전 스레드 종료
        start_auto_thread()  # 새 스레드 시작