import customtkinter
from tkinter import filedialog
import os, requests, json, webbrowser

class Advanced_setting(customtkinter.CTkToplevel):
    def __init__(self, app, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("기타 설정")
        self.resizable(width=False, height=False)
        self.geometry("270x658")
        self.attributes('-topmost', True)
        my_font = customtkinter.CTkFont('Pretendard', 13)

        def on_close(self):
                self.withdraw()

        def select_folder(self):
            folder_selected = filedialog.askdirectory()
            try:
                self.save_path.configure(state="normal")
                self.save_path.delete(0,"end")
                self.save_path.insert(0, folder_selected)
                self.save_path.configure(state="disabled")
                app.output_file_path_personal = True
                app.output_file_path = folder_selected
            except:
                pass

        def deselect_folder(self):
                self.save_path.configure(state="normal")
                app.output_file_path = f"output_NAI\\{app.start_time}"
                self.save_path.delete(0,"end")
                self.save_path.insert(0, app.output_file_path)
                self.save_path.configure(state="disabled")
                app.output_file_path_personal = True

        self.advanced_setting_frame = customtkinter.CTkFrame(self, width=250)
        self.advanced_setting_frame.grid(row=0, column=0, padx=10, pady=5, sticky="nsew")
        self.change_save_path_button = customtkinter.CTkButton(self.advanced_setting_frame, text="이미지 저장 경로 변경", command= lambda: select_folder(self), font=my_font, width=250)
        self.change_save_path_button.grid(row=0, column=0, pady=5,sticky="nsew")
        self.save_path = customtkinter.CTkEntry(self.advanced_setting_frame, font=my_font, width=250)
        self.save_path.insert(0, app.output_file_path)
        self.save_path.configure(state="disabled")
        self.save_path.grid(row=1, column=0, pady=5,sticky="nsew")
        self.change_save_path_button2 = customtkinter.CTkButton(self.advanced_setting_frame, text="경로 초기화", command= lambda: deselect_folder(self), font=my_font, width=250)
        self.change_save_path_button2.grid(row=2, column=0, pady=5,sticky="nsew")
        self.file_name_label = customtkinter.CTkLabel(self.advanced_setting_frame, text=" -- 파일명.png 규칙 설정 -- " , font=my_font, width=250)
        self.file_name_label.grid(row=3, column=0, pady=5,sticky="n")
        self.radio1 = customtkinter.CTkRadioButton(self.advanced_setting_frame, text="생성시간.png : 20231230_123001.png", variable=app.name_var, value="time", font=my_font)
        self.radio1.grid(row=4, column=0)
        self.radio2 = customtkinter.CTkRadioButton(self.advanced_setting_frame, text="생성순서.png : 00001.png,00002.png", variable=app.name_var, value="count", font=my_font)
        self.radio2.grid(row=5, column=0)
        self.file_name_label2 = customtkinter.CTkLabel(self.advanced_setting_frame, text="*생성순서 적용시 날짜_시간 폴더에 저장" , font=my_font, width=250)
        self.file_name_label2.grid(row=6, column=0, pady=5,sticky="n")
        self.file_name_label3 = customtkinter.CTkLabel(self.advanced_setting_frame, text="ui_config.ini 수정시 UI 사이즈 조절가능" , font=my_font, width=250, text_color="#FFFF97")
        self.file_name_label3.grid(row=7, column=0, pady=5,sticky="n")

        self.savefilesort_frame = customtkinter.CTkFrame(self.advanced_setting_frame, width=250)
        self.savefilesort_frame.grid(row=9, column=0, pady=5,sticky="n")

        self.activate_sorting = customtkinter.CTkCheckBox(self.savefilesort_frame, text="자동 분류 기능 활성화" , font=my_font, width=250)
        self.activate_sorting.grid(row=0, column=0, columnspan=2, pady=5,sticky="w")
        if app.save_folder_option and app.save_folder_option["isEnabled"]: self.activate_sorting.select()

        self.file_name_label4 = customtkinter.CTkLabel(self.savefilesort_frame, text="Depth 1 : " , font=my_font, width=60, text_color="#FFFF97")
        self.file_name_label4.grid(row=1, column=0, pady=5,sticky="w")

        self.sorting_condition = ["None", "해상도별 폴더", "캐릭터명 인식", "EQ(nsfw)/SG(safe)", "와일드카드 지정", "프롬프트 조건식", "생성 일자"]

        def after_press():
            self.save_folder_option.configure(text="폴더명 분류 설정 저장", state="normal")

        def command_enable():
            commands = {
                "isEnabled" : True if self.activate_sorting.get() else False,
                "depth1" : self.save_folder_depth1.get(),
                "depth2" : self.save_folder_depth2.get(),
                "command1" : self.save_folder_depth1_line.get(),
                "command2" : self.save_folder_depth2_line.get()
            }
            app.save_folder_option = commands
            self.save_folder_option.configure(text="설정 저장됨", state="disabled")
            self.after(2000, after_press)

        self.save_folder_depth1 = customtkinter.CTkComboBox(self.savefilesort_frame, values=self.sorting_condition, width=180, font=my_font)
        self.save_folder_depth1.grid(row=1, column=1, padx=5, pady=5, sticky="w")
        if app.save_folder_option: self.save_folder_depth1.set(app.save_folder_option["depth1"])

        self.file_name_label5 = customtkinter.CTkLabel(self.savefilesort_frame, text="Depth 2 : " , font=my_font, width=60, text_color="#FFFF97")
        self.file_name_label5.grid(row=3, column=0, pady=5,sticky="w")

        self.save_folder_depth1_line = customtkinter.CTkEntry(self.savefilesort_frame, font=my_font, width=250)
        self.save_folder_depth1_line.grid(row=2, column=0, columnspan=2, pady=5,sticky="nsew")
        if app.save_folder_option: self.save_folder_depth1_line.insert(0, app.save_folder_option["command1"])

        self.save_folder_depth2 = customtkinter.CTkComboBox(self.savefilesort_frame, values=self.sorting_condition, width=180, font=my_font)
        self.save_folder_depth2.grid(row=3, column=1, padx=5, pady=5, sticky="w")
        if app.save_folder_option: self.save_folder_depth2.set(app.save_folder_option["depth2"])

        self.save_folder_depth2_line = customtkinter.CTkEntry(self.savefilesort_frame, font=my_font, width=250)
        self.save_folder_depth2_line.grid(row=4, column=0, columnspan=2, pady=5,sticky="nsew")
        if app.save_folder_option: self.save_folder_depth2_line.insert(0, app.save_folder_option["command2"])

        self.save_folder_option = customtkinter.CTkButton(self.savefilesort_frame, font=my_font, width=240, text="폴더명 분류 설정 저장", command=command_enable)
        self.save_folder_option.grid(row=5, column=0, columnspan=2, pady=5,sticky="n")

        def validation():
            _message = self.multi_account_line.get().strip()
            if self.multi_account.get() == 1 and "pst-" in _message:
                try:
                    response = requests.get("https://api.novelai.net/user/subscription", headers={
                        "Authorization": f"Bearer {_message}"}, timeout=3)
                    data_dict = json.loads(response.content)
                    if data_dict['perks']['unlimitedMaxPriority']:
                        app.access_token_muiti = _message
                        self.multi_account.configure(text="RR-멀티 계정 활성화 완료", text_color="yellow")
                    else:
                        self.multi_account.deselect()
                        self.multi_account_line.delete(0, "end")
                        self.multi_account_line.insert(0, "Opus 구독 상태 아님")
                except:
                    self.multi_account.deselect()
                    self.multi_account_line.delete(0, "end")
                    self.multi_account_line.insert(0, "토큰 검증 실패")
            elif self.multi_account.get() == 0:
                app.access_token_muiti = None

        def api_count_off():
            pass

        self.api_count_off = customtkinter.CTkCheckBox(self.savefilesort_frame, text="NAI 사용량 제한 해제 (Not Recommend)" , font=my_font, width=250, command=api_count_off, variable=app.nai_api_limit_off)
        self.api_count_off.grid(row=6, column=0, columnspan=2, pady=5,sticky="w")
        if app.nai_api_limit_off.get() == 1: self.api_count_off.select() 

        self.multi_account = customtkinter.CTkCheckBox(self.savefilesort_frame, text="RR-멀티 계정 활성화 (영구 토큰 입력)" , font=my_font, width=250, command=validation)
        self.multi_account.grid(row=7, column=0, columnspan=2, pady=5,sticky="w")

        self.multi_account_line = customtkinter.CTkEntry(self.savefilesort_frame, font=my_font, width=250)
        self.multi_account_line.grid(row=8, column=0, columnspan=2, pady=5,sticky="nsew")

        if app.access_token_muiti: 
            self.multi_account.select()
            self.multi_account.configure(text="RR-멀티 계정 활성화 완료", text_color="yellow")
            self.multi_account_line.insert(0, app.access_token_muiti)

        text_hyperlink = customtkinter.CTkLabel(self.savefilesort_frame, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2")
        text_hyperlink.grid(row=9, column=0, columnspan=2, padx=5, sticky="n")
        text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/115060368"))

        def activate_webuia_standalone():
            file_path = os.path.join('.', '.webuia_standalone')
            if self.webuia_standalone.get() == 1:
                if os.path.exists(file_path): return
                nai_access_token = app.nai_access_token
                if "http" in nai_access_token:
                    nai_access_token = None
                with open(file_path, 'w') as file:
                    file.write(f"{app.access_token}\n")
                    file.write(f"{nai_access_token}\n")
            else:
                try: 
                    if os.path.exists(file_path): os.remove(file_path)
                except: pass

        if app.app_mode == "WEBUI":
            self.webuia_standalone = customtkinter.CTkCheckBox(self.advanced_setting_frame, text="다음 실행시 WEBUIA 단독 실행" , font=my_font, width=250, command=activate_webuia_standalone)
            self.webuia_standalone.grid(row=8, column=0, pady=5,sticky="n")
            if os.path.exists(os.path.join('.', '.webuia_standalone')): 
                self.webuia_standalone.select()

        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))