from PIL import Image
import io, base64, customtkinter, os, re, string, piexif

def process_text_with_links(app, textbox, temp, artist_dict, _by="instant"):
    text_widget = textbox._textbox
    temp = temp.replace("UNICODE","")
    temp = temp.replace("\\","")
    temp_c = ""
    temp_n = ""
    characters = []
    char_positions = []

    for tag in text_widget.tag_names():
        if tag.startswith("link_"):
            text_widget.tag_delete(tag)

    try:
        if ", v4_prompt:" in temp:
            v4_prompt_start = temp.find(", v4_prompt:")
            if ", sampler" in temp:
                sampler_start = temp.find(", sampler")
                if v4_prompt_start < sampler_start:
                    temp_c = temp[v4_prompt_start:sampler_start]
                    temp = temp[:v4_prompt_start] + temp[sampler_start:]

            if ', v4_negative_prompt' in temp_c:
                temp_c, temp_n = temp_c.split(', v4_negative_prompt', 1)
            while "char_caption:" in temp_c:
                start_index = temp_c.find("char_caption:")
                if ", centers:" in temp_c[start_index:]:
                    end_index = temp_c.find(", centers:", start_index)
                    caption = temp_c[start_index:end_index].strip()
                    if caption:
                        characters.append(caption)
                    temp_c = temp_c[end_index + len(", centers:"):]
                else:
                    caption = temp_c[start_index:].strip()
                    if caption:
                        characters.append(caption)
                    break    

            if "{base_caption:" in temp_n:
                base_caption_start = temp_n.find("{base_caption:") + len("{base_caption:")
                if ", char_captions:" in temp_n[base_caption_start:]:
                    char_captions_start = temp_n.find(", char_captions:", base_caption_start)
                    temp_n = ', v4_negative_prompt:' + temp_n[base_caption_start:char_captions_start]
                else:
                    temp_n = ', v4_negative_prompt:' + temp_n[base_caption_start:]

            n_samples_pos = temp.find(", n_samples")
            if n_samples_pos != -1 and characters:
                char_text = ""
                for i, v in enumerate(characters[:6]):
                    v = v.replace("char_caption: ", "")
                    _ctext = f", C{i+1} : {v}"
                    start_pos = len(char_text) 
                    char_text += _ctext
                    char_positions.append((start_pos, len(_ctext), i))
                temp = temp[:n_samples_pos] + char_text + temp_n + temp[n_samples_pos:]
    except:
        pass

    textbox.configure(state="normal", text_color="#DCE4EE")
    textbox.delete("0.0", "end")
    textbox.insert("end", temp)

    colors = [
        "#FFB6C1",  # 연한 분홍색 (Light Pink)
        "#ADD8E6",  # 연한 파란색 (Light Blue)
        "#90EE90",  # 연한 녹색 (Light Green)
        "#FFFF99",  # 연한 노란색 (Light Yellow)
        "#D8BFD8",  # 연한 보라색 (Light Purple)
        "#FADAB9"   # 연한 주황색 (Light Orange)
    ]
    if characters:
        for i, v in enumerate(characters[:6]):
            search_text = f"C{i+1} : "
            start_pos = "1.0"
            while True:
                start_pos = text_widget.search(search_text, start_pos, "end")
                if not start_pos:
                    break
                end_pos = f"{start_pos}+{len(search_text) + len(v.replace('char_caption: ', ''))}c"
                tag_name = f"char_tag_{i}"
                text_widget.tag_add(tag_name, start_pos, end_pos)
                text_widget.tag_configure(tag_name, foreground=colors[i])
                start_pos = end_pos
    
    def show_artist_info(artist_name):
        app.image_preview_toplelvel.withdraw()
        black_image = Image.new('RGB', (100, 100), '#2B2B2B')
        app.image_preview_label.configure(text="", image=customtkinter.CTkImage(black_image, size=(100,100)) )
        app.image_preview_button2.configure(fg_color="grey", state="normal", text="WC에서 제거")
        _artist_name = artist_name if app.app_mode == "NAI" else artist_name.replace('\\', '')
        if len(app.image_queue[app.current_window]) > 4 and _artist_name in app.filename_wildcard_dict[app.image_queue[app.current_window][3]] and _artist_name not in app.fixed_prompt_input.get("0.0", "end-1c"):
            _name = app.filename_wildcard_dict[app.image_queue[app.current_window][3]][_artist_name]
            app.image_count_label.configure(text=f"{artist_name} : {artist_dict[artist_name]} <{_name}>")
            app.image_preview_button1.grid(row=1, column=0, padx=2, pady=2, sticky="ew")
            app.image_preview_button2.grid(row=1, column=1, padx=2, pady=2, sticky="ew")
            app.image_preview_button3.grid(row=1, column=2, padx=2, pady=2, sticky="ew")
            if app.app_mode == "NAI" and os.path.exists(os.path.join("artist_thumb", "NAI", f"{artist_name}.jpg")):
                reloaded_image = Image.open(os.path.join("artist_thumb", "NAI", f"{artist_name}.jpg"))
                app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            elif app.app_mode == "WEBUI":
                model_name = app.webui_current_model.get().split('.safetensors')[0]
                if os.path.exists(os.path.join("artist_thumb", model_name, f"{artist_name}.jpg")):
                    reloaded_image = Image.open(os.path.join("artist_thumb", model_name, f"{artist_name}.jpg"))
                    app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            elif app.artist_information and artist_name in app.artist_information:
                image_stream = io.BytesIO(base64.b64decode(app.artist_information[artist_name][0]))
                reloaded_image = Image.open(image_stream)
                app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            else:
                black_image = Image.new('RGB', (100, 100), '#2B2B2B')
                app.image_preview_label.configure(text="썸네일이 없습니다 !\n랜덤작가 관리 기능에서 만들어보세요.", image=customtkinter.CTkImage(black_image, size=(100,100)) )
        else:
            app.image_preview_button3.grid(row=1, column=1, padx=2, pady=2, sticky="ew")
            app.image_count_label.configure(text=f"{artist_name} : {artist_dict[artist_name]}")            
            if app.app_mode == "NAI" and os.path.exists(os.path.join("artist_thumb", "NAI", f"{artist_name}.jpg")):
                reloaded_image = Image.open(os.path.join("artist_thumb", "NAI", f"{artist_name}.jpg"))
                app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            elif app.app_mode == "WEBUI":
                model_name = app.webui_current_model.get().split('.safetensors')[0]
                if os.path.exists(os.path.join("artist_thumb", model_name, f"{artist_name}.jpg")):
                    reloaded_image = Image.open(os.path.join("artist_thumb", model_name, f"{artist_name}.jpg"))
                    app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            elif app.artist_information and artist_name in app.artist_information:
                image_stream = io.BytesIO(base64.b64decode(app.artist_information[artist_name][0]))
                reloaded_image = Image.open(image_stream)
                app.image_preview_label.configure(image=customtkinter.CTkImage(reloaded_image, size=(512,512)))
            else:
                black_image = Image.new('RGB', (100, 100), '#2B2B2B')
                app.image_preview_label.configure(text="썸네일이 없습니다 !\n랜덤작가 관리 기능에서 만들어보세요.", image=customtkinter.CTkImage(black_image, size=(100,100)) )
                #else: app.image_preview_label.configure(text="랜덤 작가 관리메뉴를 열어\n artist_thumbnail 파일을 로드해주세요\n  파일은 채널 내 artist_thumbnail 검색", image=customtkinter.CTkImage(black_image, size=(100,100)) )
        bbox = textbox.dlineinfo("insert")
        if bbox:
            x, y, width, height, baseline = bbox
            abs_x = textbox.winfo_rootx() + x - 50
            abs_y = textbox.winfo_rooty() - 478
            app.image_preview_toplelvel.geometry(f"300x388+{abs_x}+{abs_y}")
            app.image_preview_toplelvel.deiconify()

        def popup_focus_out(event=None):
            app.image_preview_toplelvel.withdraw()
            app.image_preview_button1.grid_forget()
            app.image_preview_button2.grid_forget()
            app.image_preview_button3.grid_forget()
        app.image_preview_toplelvel.lift()
        app.image_preview_toplelvel.focus()
        app.image_preview_toplelvel.bind("<FocusOut>", popup_focus_out)
        app.image_preview_toplelvel.bind('<Escape>', popup_focus_out)
    
    # 중첩된 괄호와 artist: 접두사 제거
    temp2 = temp.replace("{", "").replace("}", "")
    temp2 = temp2.replace("[", "").replace("]", "")
    temp2 = re.sub(r":\d+(\.\d+)?(?=[\],)])", "", temp2)
    temp2 = temp2.replace("artist:", "")
    
    # 작가명 추출
    words = temp2.split(", ")

    def clean_word(word):
        open_count = word.count("(")
        close_count = word.count(")")

        # "("가 더 많으면 앞에서 "(" 제거
        if open_count > close_count:
            while word.startswith("(") and open_count != close_count:
                word = word[1:]
                open_count -= 1
        
        # ")"가 더 많으면 뒤에서 ")" 제거
        elif close_count > open_count:
            while word.endswith(")") and open_count != close_count:
                word = word[:-1]
                close_count -= 1
        while word.startswith("(") and word.endswith(")"):
            word = word[1:-1]  # 앞뒤 한 글자씩 제거
        return word.strip()

    artists = [clean_word(word) for word in words if clean_word(word) in artist_dict]
    
    # 중복 제거
    artists = list(dict.fromkeys(artists))
    
    # 추출된 작가명에 대해서만 태그 처리
    tag_count = 0
    start_idx = "1.0"

    # "Negative prompt:" 위치 찾기
    neg_prompt_pos = text_widget.search("Negative prompt:", "1.0", "end")
    # 검색 끝 위치 설정 - Negative prompt가 있으면 그 위치까지, 없으면 끝까지
    end_idx = neg_prompt_pos if neg_prompt_pos else "end"

    for artist_name in artists:
        while True:
            # 정확한 작가명 위치 찾기 - 검색 범위를 end_idx까지로 제한
            pos = text_widget.search(artist_name, start_idx, end_idx, exact=True)
            if not pos:
                break
                
            # 찾은 위치가 'artist:' 다음에 나오는지 확인
            line_start = text_widget.index(f"{pos} linestart")
            line_end = text_widget.index(f"{pos} lineend")
            line_text = text_widget.get(line_start, line_end)
            
            # artist: 뒤에 나오는 이름인지 확인
            if artist_name in line_text:
                tag_name = f"link_{tag_count}"
                end_pos = f"{pos}+{len(artist_name)}c"
                
                # 태그 추가
                text_widget.tag_add(tag_name, pos, end_pos)
                _artist_name = artist_name if app.app_mode == "NAI" else artist_name.replace('(', '\\(').replace(')', '\\)')
                if _artist_name in app.fixed_prompt_result_for_artist_check: text_widget.tag_configure(tag_name, foreground="#FAF9D7")
                else: text_widget.tag_configure(tag_name, foreground="#FFFF9B")
                text_widget.tag_bind(tag_name, 
                                "<Button-1>", 
                                lambda e, a=artist_name: show_artist_info(a))
                tag_count += 1
            
            start_idx = f"{pos}+1c"
    
    textbox.configure(state="disabled")

def extract_prompt_info(info, app_mode=""):
    def decode_user_comment(exif_dict):
        if 'Exif' in exif_dict and 37510 in exif_dict['Exif']:
            user_comment = exif_dict['Exif'][37510]
            if user_comment.startswith(b'UNICODE\x00\x00'):
                try:
                    # UNICODE 헤더(8바이트) 제거 후 UTF-16으로 디코딩
                    unicode_data = user_comment[8:]
                    decoded_text = unicode_data.decode('utf-16').replace('\x00', '')
                    decoded_text = decoded_text.replace("UNICODE", "")
                    return re.sub(f"[^{string.printable}]", "", decoded_text)
                except UnicodeDecodeError:
                    return None
        return None

    try:
        # 1. NAI 모드인 경우 Comment 필드 확인
        if app_mode == "NAI":
            return info.get('Comment', '')
        
        # 2. parameters 필드 확인
        if 'parameters' in info:
            return info['parameters']
        
        # 3. EXIF 데이터 확인
        if 'exif' in info:
            exif_dict = piexif.load(info['exif'])
            
            # UserComment에서 프롬프트 추출 시도
            decoded_comment = decode_user_comment(exif_dict)
            if decoded_comment:
                return decoded_comment
            
            # 다른 EXIF 필드에서도 프롬프트 찾기 시도
            for ifd in exif_dict:
                if ifd == 'thumbnail':
                    continue
                if isinstance(exif_dict[ifd], dict):
                    for tag, value in exif_dict[ifd].items():
                        # 문자열이나 바이트 형태의 데이터가 있는 경우
                        if isinstance(value, (bytes, str)) and value:
                            try:
                                if isinstance(value, bytes):
                                    decoded = value.decode('utf-8', errors='ignore')
                                else:
                                    decoded = value
                                if decoded and len(decoded) > 10:  # 의미 있는 길이의 텍스트만 고려
                                    # 영어 및 숫자 이외의 문자를 제거하여 필터링
                                    return re.sub(f"[^{string.printable}]", "", decoded)
                            except:
                                continue
        
        # 4. 아무것도 찾지 못한 경우 기본값 반환
        return "AI 생성 이미지가 아니거나 메타데이터가 포함된 이미지가 아닙니다."
    
    except Exception as e:
        print(f"프롬프트 추출 중 오류 발생: {e}")
        return "webp or jpeg prompts"