import customtkinter
from subui.account_setting import AccountSetting
from subui.advanced_setting import Advanced_setting
from subui.automation_setting import Automation_setting
from subui.character_search import Character_search
from subui.cheatsheet import IntegratedAdvancedEditor
from subui.characterpos import PositionSelector
from modules.naia_data import Data
from modules import naia_functions
from modules.naia_e621 import WordLevelTagRecommender
from modules.naia_textboxautocomplete import AutoCompleteHandler
import tkinter as tk
from tkinter import font, Canvas
from PIL import Image, ImageEnhance, ImageDraw, ImageFont,ImageTk, ImageGrab
import os, sys, glob
import ctypes
import pandas as pd
import numpy as np
import NAIA_search, NAIA_random_function_core, NAIA_generation, NAIA_utils, NAIA_Login
import json
import arti_list, tagbag, wlist, copyright_list_reformatted, remove_result_e, remove_result_qe
import character_dictionary as cd
import time
from datetime import datetime, timedelta
import random
import threading, pyperclip
from CTkListbox import *
from tkinter import filedialog, messagebox
import io
from openpyxl import Workbook
from openpyxl.styles import Alignment
from openpyxl.drawing.image import Image as OpenpyxlImage
from collections import Counter
from artist_dictionary import artist_dict
import re
import requests
import base64
import math
import webbrowser
import subprocess, copy
if sys.platform == "win32": import win32clipboard
from tkinterdnd2 import TkinterDnD, DND_ALL
import gzip
from pathlib import Path
import configparser
import multiprocessing
from multiprocessing import Pool
from NAIA_tag_elements import generals
from send2trash import send2trash
from transformers import CLIPTokenizer
import psutil, piexif
from danbooru_character import character_dict as dan_character_dict
from danbooru_character import character_dict_count
from danbooru_character_full import character_dict_full



def perform_search_parallel(_df, search_params):
    try:
        df = pd.read_parquet(_df, engine="pyarrow")
        df = NAIA_search.search(df, *search_params)
        if not type(df) != type(None) or not df.empty:
            return df
    except Exception as e:
        print(f"Error processing {_df}: {e}")
    return None

def process_parent(parent_ids, pr, _pd, event_df):
    parents_to_remove = []
    for parent in parent_ids:
        child_ids = event_df[event_df['parent_id'] == parent]['id'].tolist()
        df = event_df[event_df['id'].isin(child_ids)]
        df = NAIA_search.search(df, pr, "")
        if df is None or df.empty:
            parents_to_remove.append(parent)
        elif _pd:
            len1 = len(df)
            df = NAIA_search.search(df, "", _pd)
            try: len2 = len(df)
            except: 
                parents_to_remove.append(parent)
                continue
            if len1 != len2:
                parents_to_remove.append(parent)
    return parents_to_remove

def get_windows_display_scale():
    try:
        if sys.platform == "darwin":  # Mac OS
            import AppKit
            screen = AppKit.NSScreen.mainScreen()
            scale_factor = screen.backingScaleFactor()
            return scale_factor * 100
        elif sys.platform == "win32":  # Windows
            user32 = ctypes.windll.user32
            gdi32 = ctypes.windll.gdi32
            dc = user32.GetDC(None)
            logical_dpi_x = gdi32.GetDeviceCaps(dc, 88)  
            scale = logical_dpi_x / 96.0 * 100
            user32.ReleaseDC(None, dc)
            return scale
        else:  # Linux 또는 기타 OS
            return 100.0
    except:
        return 100.0

def process_string(input_string):
    input_string = input_string.replace("(", "\(").replace(")", "\)").replace("artist:", "").replace(":",",")
    weight = 1.0
    weight_stack = [weight]
    tokens = [] 
    current_token = ''
    idx = 0

    while idx < len(input_string):
        c = input_string[idx]
        if c == '{':
            if current_token != '':
                tokens.append({'text': current_token, 'weight': weight, 'separator': ''})
                current_token = ''
            weight *= 1.05
            weight_stack.append(weight)
            idx += 1
        elif c == '}':
            if current_token != '':
                tokens.append({'text': current_token, 'weight': weight, 'separator': ''})
                current_token = ''
            weight_stack.pop()
            weight = weight_stack[-1]
            idx += 1
        elif c == '[':
            if current_token != '':
                tokens.append({'text': current_token, 'weight': weight, 'separator': ''})
                current_token = ''
            weight /= 1.05
            weight_stack.append(weight)
            idx += 1
        elif c == ']':
            if current_token != '':
                tokens.append({'text': current_token, 'weight': weight, 'separator': ''})
                current_token = ''
            weight_stack.pop()
            weight = weight_stack[-1]
            idx += 1
        elif c in ', \n\t':  # 공백 ' '을 구분자에 포함했습니다.
            if current_token != '':
                tokens.append({'text': current_token, 'weight': weight, 'separator': c})
                current_token = ''
            else:
                if tokens:
                    tokens[-1]['separator'] += c
            idx += 1
        else:
            current_token += c
            idx += 1

    if current_token != '':
        tokens.append({'text': current_token, 'weight': weight, 'separator': ''})

    return tokens

def format_tokens(tokens):
    output_parts = []
    temp_tokens = []
    current_weight = None

    for token in tokens:
        # 가중치를 소수점 두 자리로 반올림합니다
        weight = round(token['weight'], 2)

        if current_weight is None:
            current_weight = weight
            temp_tokens.append(token)
        elif weight == current_weight:
            temp_tokens.append(token)
        else:
            # 이전 토큰들을 처리합니다
            output = process_temp_tokens(temp_tokens, current_weight)
            output_parts.append(output)
            temp_tokens = [token]
            current_weight = weight

    # 남은 토큰들을 처리합니다
    if temp_tokens:
        output = process_temp_tokens(temp_tokens, current_weight)
        output_parts.append(output)

    return ''.join(output_parts)

def process_temp_tokens(temp_tokens, weight):
    output = ''
    if weight == 1.0:
        for token in temp_tokens:
            output += token['text'] + token['separator']
    else:
        tokens_text = ''
        for i, token in enumerate(temp_tokens):
            tokens_text += token['text']
            # 마지막 토큰이 아니면 구분자를 추가합니다
            if i < len(temp_tokens) - 1:
                tokens_text += token['separator']
        output = '(' + tokens_text + ':' + str(weight) + ')'
        # 마지막 토큰의 구분자를 괄호 밖에 추가합니다
        output += temp_tokens[-1]['separator']
    return output

def prompt_NAI_to_WEBUI(_str):
    return format_tokens(process_string(_str))


class Wildcard_open(customtkinter.CTkToplevel):
    def __init__(self, app, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("작가 조합 관리 및 와일드카드")
        self.attributes('-topmost', True)
        self.resizable(width=False, height=False)

        my_font = customtkinter.CTkFont('Pretendard', 13)

        wildcards = {}
        items = 0
        preset_frame_left = customtkinter.CTkFrame(self, width=250, height=600)
        preset_frame_left.grid(row=1, rowspan=10, column=0, padx=5, pady=5, sticky="nsew")
        preset_frame_right = customtkinter.CTkFrame(self, width=700, height=600)
        preset_frame_right.grid(row=1, rowspan=10, column=1, columnspan=2, padx=5, pady=5, sticky="nsew")
        preset_insert_right_frame = customtkinter.CTkFrame(self)
        preset_insert_right_frame.grid(row=0, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")

        # 와일드카드 추가 버튼 및 명칭 입력
        preset_insert_button = customtkinter.CTkButton(preset_insert_right_frame, text="와일드카드 추가", font=my_font, command=lambda: add_wildcard(self, wildcards))
        preset_insert_button.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
        preset_insert_name = customtkinter.CTkLabel(preset_insert_right_frame, text="와일드카드 명칭 : ", font=my_font)
        preset_insert_name.grid(row=0, column=1, padx=5, pady=5, sticky="w")
        preset_insert_name_entry = customtkinter.CTkEntry(preset_insert_right_frame, width=200, font=my_font)
        preset_insert_name_entry.grid(row=0, column=2, padx=5, pady=5, sticky="w")
        
        # 삭제 버튼과 페이지 컨트롤을 포함하는 프레임
        control_frame = customtkinter.CTkFrame(preset_insert_right_frame)
        control_frame.grid(row=0, column=3, padx=5, pady=5, sticky="e")
        
        remove_preset_button = customtkinter.CTkButton(control_frame, text="이 와일드카드를 삭제", font=my_font, fg_color="grey10", hover_color="grey", command=lambda: remove_wildcard(self))
        remove_preset_button.grid(row=0, column=0, padx=5, pady=5, sticky="e")

        # 페이지 컨트롤
        current_page = [0]
        max_page = [1]

        def prev_pressed():
            if current_page[0] > 0:
                current_page[0] -= 1
                if current_page[0] == 0:
                    prev_button.configure(state="disabled")
                next_button.configure(state="normal")
                page_label.configure(text=f" {current_page[0] + 1} / {max_page[0]} ")
                update_wildcard_display()

        def next_pressed():
            if current_page[0] < max_page[0] - 1:
                current_page[0] += 1
                if current_page[0] == max_page[0] - 1:
                    next_button.configure(state="disabled")
                prev_button.configure(state="normal")
                page_label.configure(text=f" {current_page[0] + 1} / {max_page[0]} ")
                update_wildcard_display()

        prev_button = customtkinter.CTkButton(control_frame, text="◀", width=30, font=my_font, command=prev_pressed, state="disabled")
        prev_button.grid(row=0, column=1, padx=2, pady=5)
        page_label = customtkinter.CTkLabel(control_frame, text=" 1 / 1 ", width=70, font=my_font)
        page_label.grid(row=0, column=2, padx=2, pady=5)
        next_button = customtkinter.CTkButton(control_frame, text="▶", width=30, font=my_font, command=next_pressed)
        next_button.grid(row=0, column=3, padx=2, pady=5)

        preset_list = CTkListbox(preset_frame_left, height=600, font=my_font, command=lambda x: on_select_wildcard(x))
        preset_list.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")

        # UI 요소를 저장할 리스트 초기화
        ui_elements = []
        empty_image = customtkinter.CTkImage(Image.new('RGB', size=(200,200), color="#2B2B2B"), size=(200, 200))
        for i in range(3):  # 3개의 행 생성
            row_frame = customtkinter.CTkFrame(preset_frame_right)
            row_frame.grid(row=i, column=0, padx=5, pady=5, sticky="nsew")
            
            # 각 행의 요소들
            select_btn = customtkinter.CTkButton(row_frame, text="복사", width=40, height=200, font=my_font, state="disabled")
            select_btn.grid(row=0, column=0, padx=5, sticky="nsew")
            
            artist_text = customtkinter.CTkTextbox(row_frame, width=240, height=200, font=my_font)
            artist_text.grid(row=0, column=1, padx=5, sticky="w")
            
            image_btn = customtkinter.CTkButton(row_frame, text="", width=200, height=200, font=my_font, state="disabled", image=empty_image, fg_color="transparent")
            image_btn.grid(row=0, column=2, padx=5, sticky="w")
            
            delete_btn = customtkinter.CTkButton(row_frame, text="✖", width=40, height=200, font=my_font, 
                                               fg_color="grey", hover_color="grey10", state="disabled")
            delete_btn.grid(row=0, column=3, padx=5, sticky="nsew")
            
            ui_elements.append((select_btn, artist_text, image_btn, delete_btn))

        def update_wildcard_display():
            items_per_page = 3
            start_idx = current_page[0] * items_per_page
            end_idx = min(start_idx + items_per_page, len(self.wildcards))
            
            # 모든 UI 요소를 초기화
            for select_btn, artist_text, image_btn, delete_btn in ui_elements:
                select_btn.configure(state="disabled")
                artist_text.configure(state="normal")
                artist_text.delete("0.0", "end")
                artist_text.configure(state="disabled")
                image_btn.configure(state="disabled")
                delete_btn.configure(state="disabled")

            # 현재 페이지의 와일드카드 데이터를 표시
            for i, (wildcard_name, wildcard_data) in enumerate(list(self.wildcards.items())[start_idx:end_idx]):
                select_btn, artist_text, image_btn, delete_btn = ui_elements[i]
                
                select_btn.configure(state="normal")
                artist_text.configure(state="normal")
                artist_text.delete("0.0", "end")
                artist_text.insert("0.0", wildcard_name)
                artist_text.configure(state="disabled")
                image_btn.configure(state="normal")
                delete_btn.configure(state="normal")

        def add_wildcard(self, wildcards):
            wildcard_name = preset_insert_name_entry.get()
            if len(wildcard_name.strip()) < 1:
                pass
                #preset_label.configure(text="와일드카드 이름을 정확히 입력해주세요.", text_color="#FFFF97")
            else:
                wildcard = {
                    'wildcard_name': wildcard_name,
                }
                updated_wildcard = {wildcard_name: wildcard}
                if self.wildcards:
                    updated_wildcard.update(self.wildcards)
                else:
                    self.wildcards = updated_wildcard
                save_wildcard(updated_wildcard)
                self.wildcards = load_wildcard()
                update_list(self, self.wildcards)
                update_max_page()
                update_wildcard_display()

        def update_list(self, wildcards):
            if preset_list.size() != 0:
                preset_list.delete(0, "END")
            if wildcards:
                for i, names in enumerate(wildcards.keys()):
                    preset_list.insert(i, names)
            self.wildcards = wildcards

        def update_max_page():
            max_page[0] = max(1, (len(self.wildcards) + 3) // 4)
            page_label.configure(text=f" {current_page[0] + 1} / {max_page[0]} ")
            if max_page[0] == 1:
                next_button.configure(state="disabled")
            else:
                next_button.configure(state="normal")

        def save_wildcard(wildcards):
            # 경로를 안전하게 처리하기 위해 os.path.join 사용
            wildcard_file_path = os.path.join('.', 'NAIA_wildcard.json')
            with open(wildcard_file_path, 'w', encoding='utf-8') as f:
                json.dump(wildcards, f, ensure_ascii=False, indent=4)

        def load_wildcard():
            # 경로를 안전하게 처리하기 위해 os.path.join 사용
            wildcard_file_path = os.path.join('.', 'NAIA_wildcard.json')
            try:
                if os.path.exists(wildcard_file_path):
                    with open(wildcard_file_path, 'r', encoding='utf-8') as f:
                        return json.load(f)
            except FileNotFoundError:
                return {}

        def remove_wildcard(self):
            wildcards = self.wildcards
            wildcard_name = preset_list.get()
            if wildcard_name in wildcards:
                del wildcards[wildcard_name]
                save_wildcard(wildcards)
                self.wildcards = load_wildcard()
                update_list(self, self.wildcards)
                update_max_page()
                update_wildcard_display()

        def on_select_wildcard(selected):
            # 와일드카드 선택 시의 동작을 여기에 구현
            pass

        def on_close(self):
            self.withdraw()

        wildcards = load_wildcard()
        self.wildcards = wildcards
        update_list(self, wildcards)
        update_max_page()
        update_wildcard_display()
        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))
        self.after(1500, lambda: self.attributes('-topmost', False))

class Preset_open(customtkinter.CTkToplevel):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("프롬프트 검색/설정 프리셋")
        self.attributes('-topmost', True)
        self.resizable(width=False, height=False)

        my_font = customtkinter.CTkFont('Pretendard', 13)

        presets ={}
        items = 0
        preset_frame_left = customtkinter.CTkFrame(self, width=250, height=520)
        preset_frame_left.grid(row =1, rowspan=10, column =0, padx=5, pady=5, sticky="nsew")
        preset_frame_right = customtkinter.CTkFrame(self, width=700, height=520)
        preset_frame_right.grid(row =1, rowspan=10, column =1, columnspan = 2, padx=5, pady=5, sticky="nsew")
        preset_insert_right_frame = customtkinter.CTkFrame(self)
        preset_insert_right_frame.grid(row =0, column =0, columnspan=2, padx=5, pady=5, sticky="nsew")
        preset_insert_button = customtkinter.CTkButton(preset_insert_right_frame, text="프리셋 추가", font=my_font, command=lambda: add_preset(self, presets))
        preset_insert_button.grid(row =0, column =0, padx=5, pady=5, sticky="nsew")
        preset_insert_name = customtkinter.CTkLabel(preset_insert_right_frame, text="프리셋 명칭 : ", font=my_font)
        preset_insert_name.grid(row =0, column =1, padx=5, pady=5, sticky="w")
        preset_insert_name_entry = customtkinter.CTkEntry(preset_insert_right_frame,width=200, font=my_font)
        preset_insert_name_entry.grid(row =0, column =2, padx=5, pady=5, sticky="w")
        preset_insert_description = customtkinter.CTkLabel(preset_insert_right_frame, text=" 설명 : ", font=my_font)
        preset_insert_description.grid(row =0, column =3, padx=5, pady=5, sticky="w")
        preset_insert_description_entry = customtkinter.CTkEntry(preset_insert_right_frame, width=420, font=my_font)
        preset_insert_description_entry.grid(row =0, column =4, padx=5, pady=5, sticky="w")
        preset_frame_bottom = customtkinter.CTkFrame(self)
        preset_frame_bottom.grid(row =11, column =0, columnspan=2, padx=5, pady=5, sticky="nsew")
        preset_label = customtkinter.CTkLabel(preset_frame_bottom, text="생성기 내 좌측 패널의 값들을 프리셋으로 저장할 수 있습니다.", font=my_font)
        preset_label.grid(row =0, column=0,sticky="n" )

        def _yield(selected_option):
            ypreset = self.presets[selected_option]
            yield_preset_description.configure(text=ypreset['description'])
            yield_preset_search.configure(state="normal")
            yield_preset_search.delete("0.0", "end")
            yield_preset_search.insert("0.0", ypreset['search'])
            yield_preset_exclude.configure(state="normal")
            yield_preset_exclude.delete("0.0", "end")
            yield_preset_exclude.insert("0.0", ypreset['exclude'])
            yield_preset_prompt.configure(state="normal")
            yield_preset_prompt.delete("0.0", "end")
            yield_preset_prompt.insert("0.0", ypreset['prompt'])
            yield_preset_prompt.configure(state="disabled")
            _text = ""
            if ypreset['explicit'] == 1:
                _text += "Explicit "
            if ypreset['nsfw'] == 1:
                _text += "NSFW "
            if ypreset['sensitive'] == 1:
                _text += "Sensitive "
            if ypreset['general'] == 1:
                _text += "General"
            yield_activated_ratings.configure(text = _text)
            yield_prefix.configure(state="normal")
            yield_prefix.delete("0.0", "end")
            yield_prefix.insert("0.0", ypreset['fix'])
            yield_prefix.configure(state="disabled")
            yield_postfix.configure(state="normal")
            yield_postfix.delete("0.0", "end")
            yield_postfix.insert("0.0", ypreset['fix_after'])
            yield_postfix.configure(state="disabled")
            yield_negative.configure(state="normal")
            yield_negative.delete("0.0", "end")
            yield_negative.insert("0.0", ypreset['negative'])
            yield_negative.configure(state="disabled")
            yield_autohide.configure(state="normal")
            yield_autohide.delete("0.0", "end")
            yield_autohide.insert("0.0", ypreset['auto_hide'])
            yield_autohide.configure(state="disabled")
            if "random_preset" in ypreset and ypreset["random_preset"]:
                actiave_random.select()
            else:
                actiave_random.deselect()
            _text = ""
            if ypreset['rm_artist'] == 1:
                _text += "작가명제거 "
            if ypreset['rm_copyright'] == 1:
                _text += "작품명제거 "
            if ypreset['rm_character'] == 1:
                _text += "캐릭터특징제거"
            if 'cfg' in ypreset and ypreset["cfg"]:
                _text += str(" CFG Scale : "+ypreset["cfg"])
            if 'pgr' in ypreset and ypreset["pgr"]:
                _text += str(" Rescale : "+ypreset["pgr"])
            if 'smea' in ypreset and ypreset["smea"]:
                _text += " SMEA"
            if 'sampler' in ypreset and ypreset["sampler"]:
                try: _text += " "+ ypreset["sampler"].split(" + ")[0]
                except: pass
            yield_rm.configure(text = _text)



        preset_list = CTkListbox(preset_frame_left, height=570, font=my_font, command= _yield)
        preset_list.grid(row = 0, column=0, padx=5, pady=5, sticky="nsew")

        show_preset_description = customtkinter.CTkButton(preset_frame_right, text="Description", font=my_font, width=150, fg_color="grey10", text_color_disabled="white",state="disabled")
        show_preset_description.grid(row = 0, column = 0, padx=5, pady=5, sticky="w")
        yield_preset_description = customtkinter.CTkLabel(preset_frame_right, text="", font=my_font, width=550)
        yield_preset_description.grid(row = 0, column = 1, padx=5, pady=5, sticky="w")
        
        def insert_search():
            if preset_list.get():
                app.search_label_entry.delete(0, "end")
                app.search_label_entry.insert(0, yield_preset_search.get("0.0", "end"))
        show_preset_search = customtkinter.CTkButton(preset_frame_right, text="Search Keyword", font=my_font, width=150, fg_color="grey10", hover_color="grey", command=insert_search)
        show_preset_search.grid(row = 1, column = 0, padx=5, pady=5, sticky="w")
        yield_preset_search = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=28, fg_color='#2B2B2B')
        yield_preset_search.grid(row = 1, column = 1, padx=5, pady=5, sticky="w")
        def insert_exclude():
            if preset_list.get():
                app.exclude_label_entry.delete(0, "end")
                app.exclude_label_entry.insert(0, yield_preset_exclude.get("0.0", "end"))
        show_preset_exclude = customtkinter.CTkButton(preset_frame_right, text="Exclude Keyword", font=my_font, width=150, fg_color="grey10", hover_color="grey", command=insert_exclude)
        show_preset_exclude.grid(row = 2, column = 0, padx=5, pady=5, sticky="w")
        yield_preset_exclude = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=28, fg_color='#2B2B2B')
        yield_preset_exclude.grid(row = 2, column = 1, padx=5, pady=5, sticky="w")
        def insert_prompt():
            if preset_list.get():
                app.text_input.delete("0.0","end")
                app.text_input.insert("0.0", yield_preset_prompt.get("0.0", "end"))
        show_preset_prompt = customtkinter.CTkButton(preset_frame_right, text="Prompt", font=my_font, width=150, height=100, fg_color="grey10", hover_color="grey", command=insert_prompt)
        show_preset_prompt.grid(row = 3, column = 0, padx=5, pady=5, sticky="w")
        yield_preset_prompt = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=100, fg_color='#2B2B2B')
        yield_preset_prompt.grid(row = 3, column = 1, padx=5, pady=5, sticky="w")
        def insert_ratings():
            if preset_list.get():
                app.rating_select_explicit.deselect()
                app.rating_select_nsfw.deselect()
                app.rating_select_sensitive.deselect()
                app.rating_select_general.deselect()
                _text = yield_activated_ratings.cget("text")
                if "Explicit" in _text:
                    app.rating_select_explicit.select()
                if "NSFW" in _text:
                    app.rating_select_nsfw.select()   
                if "Sensitive" in _text:
                    app.rating_select_sensitive.select()   
                if "General" in _text:
                    app.rating_select_general.select()   
        show_activated_ratings = customtkinter.CTkButton(preset_frame_right, text="Ratings", font=my_font, width=150, fg_color="grey10", hover_color="grey", command=insert_ratings)
        show_activated_ratings.grid(row = 4, column = 0, padx=5, pady=5, sticky="w")
        yield_activated_ratings = customtkinter.CTkLabel(preset_frame_right, text="", font=my_font, width=550)
        yield_activated_ratings.grid(row = 4, column = 1, padx=5, pady=5, sticky="w")

        #선행고정
        def insert_prefix():
            if preset_list.get():
                app.fixed_prompt_input.delete("0.0","end")
                app.fixed_prompt_input.insert("0.0", yield_prefix.get("0.0", "end"))
        show_prefix = customtkinter.CTkButton(preset_frame_right, text="Pre-fix", font=my_font, width=150, height=50, fg_color="grey10", hover_color="grey", command=insert_prefix)
        show_prefix.grid(row = 5, column = 0, padx=5, pady=5, sticky="w")
        yield_prefix = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=50, fg_color='#2B2B2B')
        yield_prefix.grid(row = 5, column = 1, padx=5, pady=5, sticky="w")
        def insert_postfix():
            if preset_list.get():
                app.fixed_prompt_after_input.delete("0.0","end")
                app.fixed_prompt_after_input.insert("0.0", yield_postfix.get("0.0", "end"))
        show_postfix = customtkinter.CTkButton(preset_frame_right, text="Post-fix", font=my_font, width=150, height=50, fg_color="grey10", hover_color="grey", command=insert_postfix)
        show_postfix.grid(row = 6, column = 0, padx=5, pady=5, sticky="w")
        yield_postfix = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=50, fg_color='#2B2B2B')
        yield_postfix.grid(row = 6, column = 1, padx=5, pady=5, sticky="w")
        def insert_negative():
            if preset_list.get():
                app.negative_prompt_input.delete("0.0","end")
                app.negative_prompt_input.insert("0.0", yield_negative.get("0.0", "end"))
        show_negative = customtkinter.CTkButton(preset_frame_right, text="Negative prompt", font=my_font, width=150, height=70, fg_color="grey10", hover_color="grey", command=insert_negative)
        show_negative.grid(row = 7, column = 0, padx=5, pady=5, sticky="w")
        yield_negative = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=70, fg_color='#2B2B2B')
        yield_negative.grid(row = 7, column = 1, padx=5, pady=5, sticky="w")
        def insert_autohide():
            if preset_list.get():
                app.auto_hide_keyword_input.delete("0.0","end")
                app.auto_hide_keyword_input.insert("0.0", yield_autohide.get("0.0", "end"))
        show_autohide = customtkinter.CTkButton(preset_frame_right, text="Hidden keyword", font=my_font, width=150, height=70, fg_color="grey10", hover_color="grey", command=insert_autohide)
        show_autohide.grid(row = 8, column = 0, padx=5, pady=5, sticky="w")
        yield_autohide = customtkinter.CTkTextbox(preset_frame_right, font=my_font, state="disabled",width=550, height=70, fg_color='#2B2B2B')
        yield_autohide.grid(row = 8, column = 1, padx=5, pady=5, sticky="w")
        

        def insert_rm():
            if preset_list.get():
                app.rm_artist_name_button.deselect()
                app.rm_copyright_name_button.deselect()
                app.rm_characteristic_button.deselect()
                _text = yield_rm.cget("text")
                if "작가명제거" in _text:
                    app.rm_artist_name_button.select()
                if "작품명제거" in _text:
                    app.rm_copyright_name_button.select()   
                if "캐릭터특징제거" in _text:
                    app.rm_characteristic_button.select()   
        show_rm = customtkinter.CTkButton(preset_frame_right, text="Options", font=my_font, width=150, fg_color="grey10", hover_color="grey", command=insert_rm)
        show_rm.grid(row = 9, column = 0, padx=5, pady=5, sticky="w")
        yield_rm = customtkinter.CTkLabel(preset_frame_right, text="", font=my_font, width=550)
        yield_rm.grid(row = 9, column = 1, padx=5, pady=5, sticky="w")
        def apply_all():
            if preset_list.get():
                insert_search()
                insert_exclude()
                insert_prompt()
                insert_ratings()
                insert_prefix()
                insert_postfix()
                insert_negative()
                insert_autohide()
                insert_rm()
        def activate_randomize():
            current = preset_list.get(preset_list.curselection())
            if actiave_random.get() == 1:
                self.presets[current]['random_preset'] = True
            else:
                self.presets[current]['random_preset'] = False
            save_preset(self.presets)
            
        actiave_random = customtkinter.CTkCheckBox(preset_frame_right, text="랜덤 프리셋 기능을 사용할 때 이 프리셋을 포함합니다", font=my_font, width=150, command=activate_randomize)
        actiave_random.grid(row = 10, column = 0, columnspan=2, padx=5, pady=5, sticky="n")
        apply_all = customtkinter.CTkButton(preset_frame_right, text="일괄설정", font=my_font, width=150, command=apply_all)
        apply_all.grid(row = 11, column = 0, padx=5, pady=5, sticky="w")
        def remove_preset(self):
            presets = self.presets
            preset_name = preset_list.get()
            if preset_name in presets:
                del presets[preset_name]
                save_preset(presets)
                self.presets = load_preset()
                update_list(self, self.presets)
        remove_preset_button = customtkinter.CTkButton(preset_frame_right, text="이 프리셋을 삭제", font=my_font, fg_color="grey10", hover_color="grey", command=lambda: remove_preset(self))
        remove_preset_button.grid(row = 11, column =1, padx=5, pady=5, sticky="nsew")
        


        def add_preset(self, presets):
            preset_name = preset_insert_name_entry.get()
            if len(preset_name.strip()) < 1:
                preset_label.configure(text="프리셋 이름을 정확히 입력해주세요.", text_color="#FFFF97")
            else:
                preset = {
                    'preset_name':preset_name,
                    'description':preset_insert_description_entry.get(),
                    'search':app.search_label_entry.get(),
                    'exclude':app.exclude_label_entry.get(),
                    'prompt':app.text_input.get("0.0", "end-1c"),
                    'fix':app.fixed_prompt_input.get("0.0", "end-1c"),
                    'fix_after':app.fixed_prompt_after_input.get("0.0", "end-1c"),
                    'negative':app.negative_prompt_input.get("0.0", "end-1c"),
                    'auto_hide':app.auto_hide_keyword_input.get("0.0", "end-1c"),
                    'rm_artist':app.rm_artist_name_button.get(),
                    'rm_character':app.rm_characteristic_button.get(),
                    'rm_copyright':app.rm_copyright_name_button.get(),
                    'explicit':app.rating_select_explicit.get(),
                    'nsfw':app.rating_select_nsfw.get(),
                    'sensitive':app.rating_select_sensitive.get(),
                    'general':app.rating_select_general.get(),
                    'cfg': app.cfg_scale_var.get(),
                    'random_preset': False,
                    'smea': app.sema_button_var.get(),
                    'pgr': app.prompt_guidance_rescale_var.get(),
                    'sampler': app.sampler_var.get()
                }
                updated_preset = {preset_name: preset}
                if self.presets:
                    updated_preset.update(self.presets)
                else:
                    self.presets = updated_preset
                save_preset(updated_preset)
                self.presets = load_preset()
                update_list(self, self.presets)

        def update_list(self, presets):
            if preset_list.size() != 0:
                preset_list.delete(0, "END")
            if presets:
                for i, names in enumerate(presets.keys()):
                    preset_list.insert(i, names)
            self.presets = presets

        def save_preset(presets):
            # 경로를 안전하게 처리하기 위해 os.path.join 사용
            preset_file_path = os.path.join('.', 'NAIA_preset.json')
            with open(preset_file_path, 'w', encoding='utf-8') as f:
                json.dump(presets, f, ensure_ascii=False, indent=4)
            app.random_preset = presets.copy()
            app.random_preset = {k: v for k, v in presets.items() if "random_preset" in v and v.get("random_preset") == 1}

        def load_preset():
            # 경로를 안전하게 처리하기 위해 os.path.join 사용
            preset_file_path = os.path.join('.', 'NAIA_preset.json')
            try:
                if os.path.exists(preset_file_path):
                    with open(preset_file_path, 'r', encoding='utf-8') as f:
                        return json.load(f)
            except FileNotFoundError:
                return {}

        def on_close(self):
            self.withdraw()

        presets = load_preset()
        self.presets = presets
        update_list(self, presets)
        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))

class WebuiSetting(customtkinter.CTkToplevel):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("WebUI URL Setting")
        self.attributes('-topmost', True)

        def on_close(self):
            self.withdraw()

        def WEBUI_connect(self):
            url = self.WEBUI_URL_entry.get().strip()
            if app.NAI_webui_address:
                try: 
                    NAIA_Login.test_webui(app.NAI_webui_address)
                except:
                    app.NAI_webui_address = None
            try:
                if app.NAI_webui_address is None:
                    url_with_protocol = NAIA_Login.test_webui(url)
                    app.NAI_webui_address = url_with_protocol
                    app.webui_guide_button.configure(state="normal")
                    #app.webui_dtg_button.configure(state="normal")
                    try:
                        guide_setting_file_path = os.path.join('.', 'NAIA_webui_guide_setting.json')

                        if os.path.exists(guide_setting_file_path):
                            with open(guide_setting_file_path, "r", encoding='utf-8') as f:
                                app.webui_guide_setting = json.load(f)
                            if "image_size" in app.webui_guide_setting:
                                if app.webui_guide_setting["image_size"] == "중간": app.temp_guide_image_size = (368, 368)
                                elif app.webui_guide_setting["image_size"] == "작게": app.temp_guide_image_size = (256, 256)
                                else: app.temp_guide_image_size = (480, 480)
                            if "image_resolution" in app.webui_guide_setting:
                                if app.webui_guide_setting["image_resolution"] == "1024 해상도": app.webui_image_resoluiton =1
                                else: app.webui_image_resoluiton = 0
                        else:
                            app.webui_guide_setting = None
                    except:
                        app.webui_guide_setting = None
                else:
                    url_with_protocol = app.NAI_webui_address
                if not url_with_protocol:
                    raise Exception('somethings wrong')
                app.start_Webui(url_with_protocol)
                app.webui_guide_button.configure(state="normal")
                #app.webui_dtg_button.configure(state="normal")
                self.withdraw()
                try:
                    app.enable_autodetailer.grid_forget()
                    app.autodetailer_strength.grid_forget()
                    app.enable_auto_webui_i2i.grid_forget()
                    app.enable_auto_webui_i2i_strength.grid_forget()
                    app.auto_webui_adi2i_frame.grid_forget()
                    app.awai_activate_i2i.grid_forget()
                except:
                    pass
                app.awai_activate_i2i = customtkinter.CTkCheckBox(app.text_input_frame,text="매 NAI 생성마다 ADetailer 및 i2i 자동 실행", font=my_font)
                app.awai_activate_i2i.grid(row=26, column=0, sticky="w")
                app.enable_autodetailer = customtkinter.CTkCheckBox(app.text_input_frame,text="WEBUI img2img ADetailer 활성화 / 강도 : ", font=my_font)
                app.enable_autodetailer.grid(row = 27, column = 0, sticky="w")
                app.autodetailer_strength = customtkinter.CTkEntry(app.text_input_frame, font=my_font, textvariable=tk.StringVar(value = "0.4"),width=50)
                app.autodetailer_strength.grid(row = 27, column = 0, padx=165, sticky="e")
                if app.awai_settings_preload: 
                    app.autodetailer_strength.delete(0, "end")
                    app.autodetailer_strength.insert(0, app.awai_settings_preload["value1"])
                app.enable_auto_webui_i2i = customtkinter.CTkCheckBox(app.text_input_frame,text="WEBUI img2img Denoise 활성화 / 강도 : ", font=my_font)
                app.enable_auto_webui_i2i.grid(row = 28, column = 0, sticky="w")
                app.enable_auto_webui_i2i_strength = customtkinter.CTkEntry(app.text_input_frame, font=my_font, textvariable=tk.StringVar(value = "0.5"),width=50)
                app.enable_auto_webui_i2i_strength.grid(row = 28, column = 0, padx=165, sticky="e")
                if app.awai_settings_preload: 
                    app.enable_auto_webui_i2i_strength.delete(0, "end")
                    app.enable_auto_webui_i2i_strength.insert(0, app.awai_settings_preload["value2"])
                app.enable_auto_hires = customtkinter.CTkCheckBox(app.text_input_frame,text="WEBUI img2img Resize 활성화 / 배율 : ", font=my_font)
                app.enable_auto_hires.grid(row = 29, column = 0, sticky="w")
                app.enable_auto_hires_x = customtkinter.CTkEntry(app.text_input_frame, font=my_font, textvariable=tk.StringVar(value = "1.5"),width=50)
                app.enable_auto_hires_x.grid(row = 29, column = 0, padx=165, sticky="e")
                if app.awai_settings_preload: 
                    app.enable_auto_hires_x.delete(0, "end")
                    app.enable_auto_hires_x.insert(0, app.awai_settings_preload["value3"])
                app.auto_webui_adi2i_frame = customtkinter.CTkFrame(app.text_input_frame, fg_color="#2B2B2B")
                app.auto_webui_adi2i_frame.grid(row = 30, sticky="nsew")
                app.awai_textlabel1 = customtkinter.CTkLabel(app.auto_webui_adi2i_frame,text="* WEBUI img2img 요청시 프롬프트 앞에 붙일 고정 프롬프트", font=my_font)
                app.awai_textlabel1.grid(row=0, column = 0, sticky="w")
                app.awai_entry1 = customtkinter.CTkEntry(app.auto_webui_adi2i_frame,font=my_font,width=480)
                app.awai_entry1.grid(row=1, column = 0, sticky="w")
                if app.awai_settings_preload: app.awai_entry1.insert(0, app.awai_settings_preload["entry1"])
                app.awai_textlabel2 = customtkinter.CTkLabel(app.auto_webui_adi2i_frame,text="* WEBUI img2img 요청시 프롬프트 뒤에 붙일 고정 프롬프트", font=my_font)
                app.awai_textlabel2.grid(row=2, column = 0, sticky="w")
                app.awai_entry2 = customtkinter.CTkEntry(app.auto_webui_adi2i_frame,font=my_font,width=480)
                app.awai_entry2.grid(row=3, column = 0, sticky="w")
                if app.awai_settings_preload: app.awai_entry2.insert(0, app.awai_settings_preload["entry2"])
                app.awai_textlabel3 = customtkinter.CTkLabel(app.auto_webui_adi2i_frame,text="* WEBUI img2img 요청시 삭제할 NAI 후행 고정 프롬프트", font=my_font)
                app.awai_textlabel3.grid(row=4, column = 0, sticky="w")
                app.awai_entry3 = customtkinter.CTkEntry(app.auto_webui_adi2i_frame,font=my_font,width=480)
                app.awai_entry3.grid(row=5, column = 0, sticky="w")
                if app.awai_settings_preload: app.awai_entry3.insert(0, app.awai_settings_preload["entry3"])
                app.awai_textlabel4 = customtkinter.CTkLabel(app.auto_webui_adi2i_frame,text="* WEBUI img2img 요청시 사용할 네거티브 프롬프트", font=my_font)
                app.awai_textlabel4.grid(row=6, column = 0, sticky="w")
                app.awai_negative = customtkinter.CTkTextbox(app.auto_webui_adi2i_frame, width=490, height=100, font=my_font, undo=True)
                app.awai_negative.grid(row=7, column=0, sticky="nsew")
                if app.awai_settings_preload: app.awai_negative.insert("0.0", app.awai_settings_preload["negative"])
                app.awai_rm_artist = customtkinter.CTkCheckBox(app.auto_webui_adi2i_frame,text="WEBUI img2img 요청시 'artist' 문구를 포함하는 프롬프트 제거", font=my_font)
                app.awai_rm_artist.grid(row=8, column=0, sticky="w")
                if app.awai_settings_preload and app.awai_settings_preload["rm_artist"] == 1: app.awai_rm_artist.select()
                app.awai_scheduler_list = NAIA_utils.get_schedulers_list(app.NAI_webui_address)
                app.awai_scheduler_label = customtkinter.CTkLabel(app.auto_webui_adi2i_frame, text="WEBUI Scheduler : ", font=my_font)
                app.awai_scheduler_label.grid(row=9, column=0,pady=5, padx=5, sticky="w")
                app.awai_current_scheduler = customtkinter.StringVar(value="SGM Uniform")
                app.awai_scheduler_button = customtkinter.CTkComboBox(app.auto_webui_adi2i_frame, width=210, values=app.awai_scheduler_list, variable=app.awai_current_scheduler, font=my_font)
                app.awai_scheduler_button.grid(row=9, column=0,pady=5, padx=5, sticky="n")
                app.awai_sampler_var = customtkinter.StringVar(value="Euler a")
                app.awai_sampler_label = customtkinter.CTkLabel(app.auto_webui_adi2i_frame,text="WEBUI Sampler : ", font=my_font)
                app.awai_sampler_label.grid(row=10, column=0, pady=5, padx=5, sticky="w")
                app.awai_sampler_button = customtkinter.CTkComboBox(app.auto_webui_adi2i_frame, width=250,values=NAIA_utils.get_sampler_list(app.NAI_webui_address), variable=app.awai_sampler_var, font=my_font)
                app.awai_sampler_button.grid(row=10, column=0, pady=5, padx=5, sticky="n")
                def change_model(choice):
                    def change_model_request():
                        app.current_model_box.configure(state="disabled")
                        try:
                            res = NAIA_utils.change_model(app.NAI_webui_address, choice)
                            app.current_model_box.configure(state="normal")
                        except:
                            app.current_model_box.configure(state="normal")
                        if res == True:
                            app.webui_current_model.set(choice)
                    if choice == app.previous_model:
                        return
                    else:
                        model_change_thread = threading.Thread(target=change_model_request, daemon=True)
                        model_change_thread.start()
                app.webui_current_model = customtkinter.StringVar(value=NAIA_utils.get_current_model(app.NAI_webui_address))
                app.previous_model = app.webui_current_model.get()
                app.webui_model_list = NAIA_utils.get_model_list(app.NAI_webui_address)
                app.current_model_box = customtkinter.CTkComboBox(app.auto_webui_adi2i_frame, width=330,values=app.webui_model_list, variable=app.webui_current_model, command=change_model, font=my_font)
                app.current_model_box.grid(row=11, column=0, pady=5, padx=5, sticky="w")
                def open_lora_list_awai():
                    _list = NAIA_utils.get_lora_list(app.NAI_webui_address)
                    _text = "\n".join(_list)
                    prompt_window = customtkinter.CTkToplevel()
                    prompt_window.title("LoRA 리스트")
                    prompt_window.attributes('-topmost', True)
                    prompt_window.resizable(width=False, height=False)

                    text_label1 = customtkinter.CTkLabel(prompt_window, text="WEBUI 활성 로라 목록", font=customtkinter.CTkFont('Pretendard', 13))
                    text_label1.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                    text_output1 = customtkinter.CTkTextbox(prompt_window, height=550, width=380, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                    text_output1.insert("0.0", _text)
                    text_label2 = customtkinter.CTkLabel(prompt_window, text="드래그 후 Ctrl + C로 복사", font=customtkinter.CTkFont('Pretendard', 13))
                    text_label2.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")

                app.lora_button = customtkinter.CTkButton(app.auto_webui_adi2i_frame, text="LoRA 리스트", font=my_font, fg_color="grey10", hover_color="grey", command=open_lora_list_awai, width=100)
                app.lora_button.grid(row=9, column=0,pady=5, padx=5, sticky="e")
                app.after(4000, app.iconify())
            except Exception as e:
                print(e)
                self.state_label.configure(text="--api 설정이 안되어있거나, webui 실행중이 아닙니다.", font=my_font)
                self.webui_connect_guide.grid(row = 4, column = 0, columnspan=2, padx=5, pady=5, sticky="nsew")

        self.button_frame = customtkinter.CTkFrame(self)
        self.button_frame.grid(row=0, padx=5, pady=5, sticky="nsew")
        self.button_frame.columnconfigure(0, weight=1)
        self.button_frame.columnconfigure(1, weight=4)

        my_font = customtkinter.CTkFont('Pretendard', 13)
        self.WEBUI_URL_label = customtkinter.CTkLabel(self.button_frame, text="URL:", font=my_font)
        self.WEBUI_URL_label.grid(row = 0, column = 0, padx=5, pady=5, sticky="nsew")
        self.WEBUI_URL_entry = customtkinter.CTkEntry(self.button_frame, textvariable=tk.StringVar(value="127.0.0.1:7860"))
        self.WEBUI_URL_entry.grid(row = 0, column = 1, padx=5, pady=5, sticky="nsew")
        self.connect_button = customtkinter.CTkButton(self.button_frame, text="Connect", command=lambda:WEBUI_connect(self))
        self.connect_button.grid(row = 2, column = 0, columnspan=2, padx=5, pady=5, sticky="n")
        self.state_label = customtkinter.CTkLabel(self.button_frame, text="webui 실행 시 --api 옵션을 추가해야 합니다.", font=my_font)
        self.state_label.grid(row = 3, column = 0, columnspan=2, padx=5, pady=5, sticky="nsew")
        self.webui_connect_guide = customtkinter.CTkLabel(self.button_frame, text="가이드 열기 (arca.live)", font=my_font, text_color="lightblue", cursor="hand2")    
        self.webui_connect_guide.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/77118138"))
        WEBUI_connect(self)
        if self.state == "withdrawn": self.state_label.configure(text="webui 실행 시 --api 옵션을 추가해야 합니다.", font=my_font)
        
        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))


class App(customtkinter.CTk, TkinterDnD.DnDWrapper):
    access_token = None
    NAI_ID = None
    data = Data(wlist, tagbag, arti_list, copyright_list_reformatted, cd, remove_result_e, remove_result_qe)

    def __init__(self, _args=None):
        super().__init__()
        
        # 플랫폼 확인
        self.is_mac = sys.platform == "darwin"
        
        # Mac OS에서는 TkinterDnD 대신 대체 로직 사용
        if not self.is_mac:
            self.TkdndVersion = TkinterDnD._require(self)
        
        if getattr(sys, 'frozen', False):
            basedir = sys._MEIPASS
        else:
            basedir = os.path.dirname(__file__)
        self.basedir = basedir
        
        # 폰트 파일 경로 설정
        self.bold_font_path = os.path.abspath(os.path.join(basedir, "Pretendard-Bold.otf"))
        self.regular_font_path = os.path.abspath(os.path.join(basedir, "Pretendard-Regular.otf"))
        
        # Mac OS와 Windows에서 각각 다른 방식으로 폰트 로드
        if self.is_mac:
            # Mac OS에서 폰트 로드
            try:
                from Foundation import NSURL, NSFileManager # type: ignore
                from AppKit import NSFontManager # type: ignore
                
                # 사용자의 폰트 디렉토리 사용 (권한 문제 없음)
                font_dir = os.path.expanduser('~/Library/Fonts')
                os.makedirs(font_dir, exist_ok=True)
                
                fonts_installed = False
                # 폰트 파일 복사
                for font_path in [self.bold_font_path, self.regular_font_path]:
                    font_name = os.path.basename(font_path)
                    dest_path = os.path.join(font_dir, font_name)
                    if not os.path.exists(dest_path):
                        try:
                            import shutil
                            shutil.copy2(font_path, dest_path)
                            fonts_installed = True
                            print(f"Font installed successfully: {font_name}")
                        except Exception as e:
                            print(f"Font copy error: {e}")
                
                # 새로운 폰트가 설치된 경우에만 캐시 업데이트 시도
                if fonts_installed:
                    try:
                        # 사용자 영역의 폰트 캐시만 업데이트
                        os.system('atsutil databases -removeuser')
                    except Exception as cache_error:
                        # 캐시 업데이트 실패는 치명적이지 않으므로 경고만 출력
                        print(f"Font cache update warning (non-critical): {cache_error}")
                        
            except Exception as e:
                print(f"Mac font installation error: {e}")
                
        else:
            # Windows에서 폰트 로드
            try:
                ctypes.windll.gdi32.AddFontResourceW(self.bold_font_path)
                ctypes.windll.gdi32.AddFontResourceW(self.regular_font_path)
                
                # 시스템에 폰트 변경 알림
                hwnd = ctypes.windll.user32.GetForegroundWindow()
                ctypes.windll.user32.PostMessageW(0xFFFF, 0x001D, 0, 0)
            except Exception as e:
                print(f"Windows font installation error: {e}")

        my_font = customtkinter.CTkFont('Pretendard' if self.winfo_screenheight() < 1152 else 'Pretendard', 13)
        large_font = customtkinter.CTkFont('Pretendard' if self.winfo_screenheight() < 1152 else 'Pretendard', 13)
        v_large_font = customtkinter.CTkFont('Pretendard' if self.winfo_screenheight() < 1152 else 'Pretendard', 14, weight="normal")
        self.v_large_font = v_large_font
        self.large_font = large_font

        self.font_paths = [self.bold_font_path, self.regular_font_path]

        self.re_update = False
        self.config = configparser.ConfigParser()
        self.last_token = 0

        self.s_token = CLIPTokenizer.from_pretrained("openai/clip-vit-base-patch32")

        def cs(text):
            if self.auto_quality_toggle_var.get():
                return len(self.s_token.encode(text)) + 12
            else:
                return len(self.s_token.encode(text))

        def cs_prompt(text):
            ltx = text.split(', ')
            rm_tx = []
            for tx in ltx:
                if tx.startswith("*(") or tx.startswith("resolution:") or tx.startswith("seed:") or tx.startswith("\n\n") or tx.startswith("#"):
                    rm_tx.append(tx)
            for tx in rm_tx:
                if tx in ltx: ltx.remove(tx)
            for i, tx in enumerate(ltx):
                if '->' in tx: ltx[i] = tx.split('->')[0]
                elif '|' in tx: ltx[i] = tx.split('|')[0]
            text = ','.join(ltx)
            text = text.replace('{','').replace('}','').replace('[','').replace(']','').replace('<','')
            self.last_token = cs(text)
            return str(self.last_token)+" / 225"

        #UI 사이즈 획득
        config_file_path = os.path.join('.', 'ui_config.ini')

        if os.path.exists(config_file_path):
            try:
                self.config.read(config_file_path)
            except:
                self.config['SET_PROMPT_UI_SIZE'] = {
                    'MAIN_PROMPT': '200',
                    'PREFIX_PROMPT': '100',
                    'POSTFIX_PROMPT': '60',
                    'NEGATIVE_PROMPT': '100',
                    'AUTOHIDE_KEYWORD': '100',
                    'CONDITIONAL_PROMPT': '100',
                    'CONDITIONAL_NEGATIVE': '100'
                }
                with open(config_file_path, 'w') as configfile:
                    self.config.write(configfile)
        else:
            self.config['SET_PROMPT_UI_SIZE'] = {
                    'MAIN_PROMPT': '200',
                    'PREFIX_PROMPT': '100',
                    'POSTFIX_PROMPT': '60',
                    'NEGATIVE_PROMPT': '100',
                    'AUTOHIDE_KEYWORD': '100',
                    'CONDITIONAL_PROMPT': '100',
                    'CONDITIONAL_NEGATIVE': '100'
                    }
            with open(config_file_path, 'w') as configfile:
                self.config.write(configfile)

        #UI 사이즈 할당
        self.ui_size = {}
        try: self.ui_size['prompt'] = int(self.config['SET_PROMPT_UI_SIZE']['MAIN_PROMPT'])
        except: self.ui_size['prompt'] = 200
        try: self.ui_size['prefix'] = int(self.config['SET_PROMPT_UI_SIZE']['PREFIX_PROMPT'])
        except: self.ui_size['prefix'] = 100
        try: self.ui_size['postfix'] = int(self.config['SET_PROMPT_UI_SIZE']['POSTFIX_PROMPT'])
        except: self.ui_size['postfix'] = 60
        try: self.ui_size['negative'] = int(self.config['SET_PROMPT_UI_SIZE']['NEGATIVE_PROMPT'])
        except: self.ui_size['negative'] = 100
        try: self.ui_size['autohide'] = int(self.config['SET_PROMPT_UI_SIZE']['AUTOHIDE_KEYWORD'])
        except: self.ui_size['autohide'] = 100
        try: self.ui_size['cond_prompt'] = int(self.config['SET_PROMPT_UI_SIZE']['CONDITIONAL_PROMPT'])
        except: self.ui_size['cond_prompt'] = 100
        try: self.ui_size['cond_negative'] = int(self.config['SET_PROMPT_UI_SIZE']['CONDITIONAL_NEGATIVE'])
        except: self.ui_size['cond_negative'] = 100

        self.resolutions = ["1024 x 1024", "960 x 1088", "896 x 1152", "832 x 1216", "1088 x 960", "1152 x 896", "1216 x 832"]

        #_args 체크
        standalone_file_path = os.path.join('.', '.webuia_standalone')
        if _args:
            self.app_mode = _args[0] #"WEBUI"
            self.webui_address = _args[1]
            self.access_token = _args[1]
            self.nai_access_token = _args[2]
            if self.nai_access_token is None:
                self.nai_access_token = self.webui_address
        elif os.path.exists(standalone_file_path):
            self.app_mode = "WEBUI"
            try:
                with open(standalone_file_path, 'r') as file:
                    self.access_token = file.readline().strip()
                    self.webui_address = self.access_token
                    self.nai_access_token = file.readline().strip()
                    if self.nai_access_token is None:
                        self.nai_access_token = self.webui_address
            except:
                self.app_mode = "NAI"

        else:
            self.app_mode = "NAI"

        #For Automation 
        self.auto_time_left = 0
        self.auto_time_left_flag = False
        self.auto_count_left = 0
        self.auto_count_left_flag = False
        self.delay_offset = 2.0 if self.app_mode == "NAI" else -13.0
        self.auto_thread = None
        self.stop_event = None
        self.hold_wildcard = False
        self.tb3_generated = []

        #For Generation
        self.current_prompt_rating = None
        self.generation_queue = []

        #Prior queue
        self.prior_queue = []

        #json file
        self.dictionary_parity = False

        self.start_time_prime = datetime.now()
        self.start_time = self.start_time_prime.strftime('%Y%m%d_%H%M')
        self.xy_plot_count = 0
        self.import_image_negative = {}

        self.main_title = "NAIA Beta v1.5 testv5 (032609)"
        if self.app_mode == "NAI": 
            self.title(self.main_title)
            self.iconbitmap(basedir+'/icoico.ico')
        else: 
            self.title(self.main_title + f" ( WEBUI : {self.webui_address} )")
            self.iconbitmap(basedir+'/webuico.ico')
        self.grid_rowconfigure(0, weight=1)

        if not self.is_mac: ctypes.windll.shcore.SetProcessDpiAwareness(1)
        #디자인: 상용 프로그램의 스타일과 유사하도록 UI를 새롭게 개편한다.
        self.display_scale = get_windows_display_scale()
        self.left_frame = customtkinter.CTkScrollableFrame(self, width=510, height=990 if self.display_scale < 150 else 960)
        self.left_frame.grid(row=0, column=0, sticky="nsew")
        self.right_frame = customtkinter.CTkScrollableFrame(self, width=775,height=990 if self.display_scale < 150 else 960)
        self.right_frame.grid(row=0, column=1, sticky="nsew")                                                                                                                                                      
        self.hidden_frame = customtkinter.CTkScrollableFrame(self, width=350)
        self.image_label_report_sub = customtkinter.CTkTextbox(self.hidden_frame,width=250, height=500, font=large_font)
        self.image_label_report_sub.grid(row=2, column=0, columnspan=2, pady=5, padx=5, sticky="nsew")
        self.image_label_report_sub.configure(state="disabled")
        self.state_label2 = customtkinter.CTkLabel(self.hidden_frame, text="state : idle", font=my_font)
        self.state_label2.grid(row=8, column=0, columnspan=2, pady=5, padx=5, sticky="n") 
        self.sync_odd = 0
        self.last_prompt_len = 0
        self.adtx = ""
        self.last_prefix_len = 0
        self.fdtx = ""
        self.awai_settings_preload = None
        self.access_token_muiti = None
        self.nai_generation_count = 0
        self.sync_characters_nai4 = None
        self.i2i_negative_is_on = False
        
        def sync_text():
            if self.re_update == True:
                update()
                self.re_update = False
            if self.app_mode == "NAI": 
                if self.running_flag:
                    self.transform_button.configure(state="disabled")
                else:
                    self.transform_button.configure(state="normal")
            if self.image_generation_button.cget("state") == "disabled" and self.reset_generation.cget("state") == "disabled":
                self.reset_generation.configure(text="생성 버튼 복원", state="normal")
            elif self.image_generation_button.cget("state") == "normal" and self.reset_generation.cget("state") == "normal":
                self.reset_generation.configure(text="", state="disabled")
            content = self.image_label_report.get("0.0", "end-1c").rstrip()
            label = self.state_label.cget("text").rstrip()
            label_sub = self.state_label2.cget("text").rstrip()
            content_sub = self.image_label_report_sub.get("0.0", "end-1c").rstrip()
            if self.automation_button.get() == 1 and self.skip_225_button.get() == 1 and self.last_token > 225:
                if self.wildcard_preopen_repeat > 1: self.wildcard_preopen_repeat_current -= 1
                try: random_function()
                except: self.random_function_button.configure(state="normal", command=_random_function)
            self.random_function_pressed = False
            if content != content_sub:
                self.image_label_report_sub.configure(state="normal")
                self.image_label_report_sub.delete("0.0", "end")
                self.image_label_report_sub.insert("0.0", content)
                self.image_label_report_sub.configure(text_color=self.image_label_report.cget("text_color"),state="disabled")
            if label != label_sub:
                self.state_label2.configure(text=label, text_color=self.image_label_report.cget("text_color"))
            if " x " not in self.resolution_var.get():
                resolutions = self.resolutions
                random_resolution = random.choice(resolutions)
                self.resolution_button.set(random_resolution)
            current_text = self.text_input.get("0.0", "end")
            if self.last_prompt_len != len(current_text):
                self.last_prompt_len = len(current_text)
                self.adtx = " ( " + cs_prompt(current_text) + " )"
            current_prefix = self.fixed_prompt_input.get("0.0", "end") + self.fixed_prompt_after_input.get("0.0", "end-1c")
            if self.last_prefix_len != len(current_prefix):
                self.last_prefix_len = len(current_prefix)
                self.fdtx = cs_prompt(current_prefix).split(' / ')[0]
                self.fixed_prompt_label.configure(text=f" --------------------- 선행 고정 프롬프트 ( {self.fdtx} ) ------------------ Steps : ")
            if self.image_reference:
                if self.sync_odd == 0:
                    self.text_input_label.configure(text=f" ----------------------- 프롬프트 (VT ON) ------------{self.adtx} ", text_color="#FFFF97")
                    self.sync_odd = 1
                else:
                    self.text_input_label.configure(text=f" ----------------------- 프롬프트 (VT ON) ------------{self.adtx} ", text_color="#F2FBFF")
                    self.sync_odd = 0                 
            else:
                self.text_input_label.configure(text=f" ------------------------ 프롬프트 -------------{self.adtx} ", text_color="#F2FBFF")
            if self.app_mode == "NAI":
                try: _temp_steps = int(self.force_steps_entry.get())
                except: 
                    self.force_steps_entry.delete(0, "end")
                    self.force_steps_entry.insert(0, "28")         
                    _temp_steps = 28
                if _temp_steps > 28:
                    if self.sync_odd == 0:
                        self.anlas_label.configure(text_color="#FD8853")
                        if not self.image_reference: self.sync_odd = 1
                    else:
                        self.anlas_label.configure(text_color="#FFFF97")
                        if not self.image_reference: self.sync_odd = 0
                    if _temp_steps > 50:
                        self.force_steps_entry.delete(0, "end")
                        self.force_steps_entry.insert(0, "50")
                    if _temp_steps < 1:
                        self.force_steps_entry.delete(0, "end")
                        self.force_steps_entry.insert(0, "1")   
                else: self.anlas_label.configure(text_color="#FFFF97")
            if self.sync_transform_image:
                image = self.sync_transform_image.copy()
                image.save('tempimage_transform.png')
                self.sync_transform_image = None
                instant_transform(image, 'tempimage_transform.png')
            if self.sync_i2i_img:
                if img2img_window is not None:
                    self.img2img_window.destroy()
                    self.img2img_window = None
                if self.sync_i2i_contents:
                    if "rf" in self.sync_i2i_contents and self.sync_i2i_contents["rf"] == True:
                        random_function()
                        temp_prompt = [keyword.strip() for keyword in self.text_input.get("0.0", "end-1c").split(",")]
                        temp_prompt = [keyword for keyword in temp_prompt if not keyword.startswith("#")]
                        self.sync_i2i_contents["prompt"] = ', '.join(temp_prompt)
                    _img2img(self,self.sync_i2i_img, self.sync_i2i_contents.copy())
                else:
                    _img2img(self,self.sync_i2i_img)
                self.sync_i2i_img = None
                self.sync_i2i_contents = None
            if self.sync_outpainting and self.sync_outpainting[4] == "manual":
                if img2img_window is not None:
                    self.img2img_window.destroy()
                    self.img2img_window = None
                _img2img(self, self.sync_outpainting[0], self.sync_outpainting[3], self.sync_outpainting[1], self.sync_outpainting[2])
                self.sync_outpainting = None
            if self.current_model_nai.get() == "NAID4" or self.current_model_nai.get() == "NAID4-Curated":
                if not self.naid4_characters_frame.winfo_ismapped():
                    self.ai_choice.grid(row=3, column=0, padx=5, pady=14, sticky="w")
                    self.pos_viewer.grid(row=3, column=0, padx=5, sticky="e")
                    self.naid4_position_frame.grid(row=3, column=1, columnspan=2, sticky="nsew")
                    self.naid4_characters_frame.grid(row=4, column=0, columnspan=3, pady=5, sticky="nsew")
            else:
                if self.naid4_characters_frame.winfo_ismapped():
                    self.ai_choice.grid_forget()
                    self.pos_viewer.grid_forget()
                    self.naid4_position_frame.grid_forget()
                    self.naid4_characters_frame.grid_forget()
            if self.sync_characters_nai4:
                for frame_dict in self.character_frames:
                    frame_dict['frame'].grid_forget()
                self.character_frames.clear()
                for idx, character in enumerate(self.sync_characters_nai4['characters'], start=1):
                    new_frame_dict = create_character_frame(
                        self.naid4_characters_frame,
                        idx,
                        large_font,
                        v_large_font,
                        self.character_frames,
                        lambda: add_new_character(self.naid4_characters_frame, large_font, v_large_font, self.character_frames),
                        remove_character
                    )
                    new_frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")
                    new_frame_dict['textbox'].delete("0.0", "end")
                    new_frame_dict['textbox'].insert("0.0", self.sync_characters_nai4['characters'][idx-1])
                    new_frame_dict['uc'].delete("0.0", "end")
                    new_frame_dict['uc'].insert("0.0", self.sync_characters_nai4['uc'][idx-1])
                    self.character_frames.append(new_frame_dict)
                self.sync_characters_nai4 = None
            content = self.text_input.get("1.0", "end")
            if ":begin" in content:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.toggle_prompt_fix_button.select()
                    hold_prompt()
            highlight_text()
            self.after(500, sync_text)

        #검색 키워드 창 관리 프레임
        self.search_frame = customtkinter.CTkFrame(self.left_frame)
        self.search_frame.grid(row=0, column=0, sticky="nsew")

        def open_AccountSetting(self):
            if self.AccountSetting is None:
                self.AccountSetting = AccountSetting(self)
            else:
                if self.AccountSetting.state() == 'withdrawn':
                    self.AccountSetting.deiconify()
                else:
                    self.AccountSetting.NAI_ID_entry.focus()

        def NAI_token_remove(self):
            app.access_token = None
            app.NAI_ID = None
            if self.running_flag or self.automation_button.get()==1 or self.image_generation_button.cget("state") == "disabled":
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> NAI 토큰의 제거가 가능한 상태가 아닙니다. 모든 작업/자동화 설정을 마치고 시도 해주세요.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")
            else:
                app.NAI_Account_Login.configure(state="disabled")
                app.NAI_Token_Remove.configure(state="disabled")
                app.NAI_Account_State.configure(text="NAI Logout", text_color="red")
                app.image_generation_button.configure(state="disabled")
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> NAI 토큰 제거 완료(Logout). 프로그램을 정상적으로 종료 후 재실행해야 반영됩니다.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")

            
        self.AccountSetting = None
        #NAI 계정 관리 프레임
        self.NAI_Account_Frame = customtkinter.CTkFrame(self.search_frame, width=440, height=50, bg_color="transparent")
        self.NAI_Account_Frame.grid(row=0, column=0, columnspan=3, pady=5,sticky="nsew")
        self.NAI_Account_Frame.columnconfigure(0, weight=4)
        self.NAI_Account_Frame.columnconfigure(1, weight=4)
        self.NAI_Account_Frame.columnconfigure(2, weight=4)
        self.NAI_Account_Frame.columnconfigure(3, weight=4)

        def search_ui_hide():
            if self.ui_hide_var.get() == 0:
                self.NAI_Account_State.configure(text="검색 UI 펼치기")
                self.search_label.grid_forget()
                search_hyperlink.grid_forget()
                self.low_sepc_mode.grid_forget()
                self.search_label_entry.grid_forget()
                self.exclude_label.grid_forget()
                self.exclude_label_entry.grid_forget()
                self.select_rating_frame.grid_forget()
                self.fav_button.grid_forget()
                self.prompt_preset_button.grid_forget()
                self.searched_prompt_label.grid_forget()
                self.cached_prompt_label.grid_forget()
                self.search_frame_extend.grid_forget()
                if self.app_mode == "NAI":
                    if self.webui_guide_button.get() == 1: self.image_guide_frame.grid_forget()
                if self.app_mode == "WEBUI":
                    self.lora_button.grid_forget()
                    self.scheduler_label.grid_forget()
                    self.current_scheduler.grid_forget()
                    self.current_model_box.grid_forget()
                    self.instant_row_button.grid_forget()
            else:
                self.NAI_Account_State.configure(text="검색 UI 숨기기")
                self.search_label.grid(row=1, column=0, padx=8, sticky="w")
                search_hyperlink.grid(row=1, column=0, padx=8, sticky="e")
                self.search_label_entry.grid(row=2, column=0, padx=8, sticky="w")
                self.exclude_label.grid(row=3, column=0, padx=8, sticky="w")
                self.exclude_label_entry.grid(row=4, column=0, padx=8, sticky="w")
                self.select_rating_frame.grid(row=6, column=0, padx=8, pady=10, sticky="nsew")
                self.low_sepc_mode.grid(row=3, column=0,  padx=8, sticky="e")
                self.fav_button.grid(row=0, column=2, padx=15, sticky="e")
                self.prompt_preset_button.grid(row=0, column=2, sticky="w")
                self.searched_prompt_label.grid(row=0, column=0, sticky="ew")
                self.cached_prompt_label.grid(row=0, column=1, sticky="ew")
                self.search_frame_extend.grid(row=5, column=0, padx=8, pady=2, sticky="nsew")
                if self.app_mode == "NAI":
                    if self.webui_guide_button.get() == 1: self.image_guide_frame.grid(row=1, rowspan=4, column=0, columnspan=3 , pady=2, sticky="nsew")
                if self.app_mode == "WEBUI":
                    self.lora_button.grid(row=1, column=2,pady=5, padx=5, sticky="nsew")
                    self.scheduler_label.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")
                    self.current_scheduler.grid(row=2, column=1, padx=5, pady=5, sticky="nsew")
                    self.current_model_box.grid(row=1, column=0, columnspan=2, pady=5, padx=5, sticky="w")
                    self.instant_row_button.grid(row=2, column=2,pady=5, padx=5, sticky="nsew")

        def open_WebuiSetting(self):
            if self.WebuiSetting is None:
                self.WebuiSetting = WebuiSetting(self)
            else:
                if self.WebuiSetting.state() == 'withdrawn':
                    self.WebuiSetting.deiconify()
                else:
                    self.WebuiSetting.WEBUI_URL_entry.focus()

        def open_auto_nai(self):
            if self.autonai_window is None:
                _auto_nai()
            else:
                if self.autonai_window.state() == 'withdrawn':
                    self.autonai_window.deiconify()
                else:
                    self.autonai_window.lift()

        self.auto_nai_setting = None
        nai_i2i_file_path = os.path.join('.', 'WEBUIA_nai_i2i.json')

        if self.app_mode == 'WEBUI':
            try:
                if os.path.exists(nai_i2i_file_path):
                    with open(nai_i2i_file_path, 'r', encoding='utf-8') as f:
                        self.auto_nai_setting = json.load(f)
            except:
                self.auto_nai_setting = None
                
        def _auto_nai():
            def on_close():
                auto_nai_window.withdraw()

            def on_apply():
                try:
                    _val = round(float(denoise_entry.get()), 2)
                    if _val >= 0.01 and _val <= 1:
                        self.i2i_value = _val
                except: pass
                self.auto_nai_setting = [
                    rm_prompt.get("0.0", "end-1c").split("\n"),
                    entry1.get(),
                    add_prompt1.get("0.0", "end-1c"),
                    add_prompt2.get("0.0", "end-1c"),
                    negative_input.get("0.0", "end-1c"),
                    sampler_var.get()
                ]
                with open("WEBUIA_nai_i2i.json", "w") as f:
                    json.dump(self.auto_nai_setting, f, ensure_ascii=False, indent=4)
                self.autonai.configure(state="normal")
                on_close()

            auto_nai_window = customtkinter.CTkToplevel()
            self.autonai_window = auto_nai_window
            auto_nai_window.title("NAI I2I 자동화 세부설정")
            auto_nai_window.attributes('-topmost', True)
            auto_nai_window.resizable(width=False, height=False)

            left_frame = customtkinter.CTkFrame(auto_nai_window)
            left_frame.grid(row=0, column=0, padx=5, sticky="w")
            right_frame = customtkinter.CTkFrame(auto_nai_window)
            right_frame.grid(row=0, column=1, padx=5, sticky="w")

            label1 = customtkinter.CTkLabel(left_frame, text="다음 문자열을 제거합니다 (line마다 적용)", font=my_font)
            label1.grid(row=0, column=0, padx=5, sticky="n")
            rm_prompt = customtkinter.CTkTextbox(left_frame, font=my_font, width=300)
            rm_prompt.grid(row=1, column=0, padx=5, sticky="n")

            label2 = customtkinter.CTkLabel(left_frame, text="다음 문자열을 찾아 NAI 프롬프트로 대치합니다", font=my_font)
            label2.grid(row=2, column=0, padx=5, sticky="n")
            entry1 = customtkinter.CTkEntry(left_frame, font=my_font, width=280)
            entry1.grid(row=3, column=0, padx=5, sticky="n")

            label3 = customtkinter.CTkLabel(left_frame, text="삽입할 NAI 프롬프트", font=my_font)
            label3.grid(row=4, column=0, padx=5, sticky="n")
            add_prompt1 = customtkinter.CTkTextbox(left_frame, font=my_font, width=300)
            add_prompt1.grid(row=5, column=0, padx=5, sticky="n")

            label4 = customtkinter.CTkLabel(right_frame, text="삽입할 NAI 프롬프트 (후행)", font=my_font)
            label4.grid(row=0, column=0, padx=5, sticky="n")
            add_prompt2 = customtkinter.CTkTextbox(right_frame, font=my_font, width=300, height=120)
            add_prompt2.grid(row=1, column=0, padx=5, sticky="n")

            label5 = customtkinter.CTkLabel(right_frame, text="사용할 NAI 네거티브", font=my_font)
            label5.grid(row=2, column=0, padx=5, sticky="n")
            negative_input = customtkinter.CTkTextbox(right_frame, font=my_font, width=300)
            negative_input.grid(row=3, column=0, padx=5, sticky="n")

            label6 = customtkinter.CTkLabel(right_frame, text="디노이즈 강도 (0.01 ~ 0.99)", font=my_font)
            label6.grid(row=4, column=0, padx=5, sticky="n")
            denoise_entry = customtkinter.CTkEntry(right_frame, font=my_font)
            denoise_entry.grid(row=5, column=0, padx=5, sticky="n")
            denoise_entry.insert(0, str(round(self.i2i_value, 2)))

            label7 = customtkinter.CTkLabel(right_frame, text="NAI 샘플러 선택", font=my_font)
            label7.grid(row=6, column=0, padx=5, sticky="n")
            sampler_var = customtkinter.StringVar(value="k_euler_ancestral + native")
            sampler_button = customtkinter.CTkComboBox(right_frame, width=210,values=["k_euler + native", "k_euler + karras", "k_euler + exponential", "k_euler_ancestral + native", "k_euler_ancestral + karras","k_euler_ancestral + exponential", "k_dpmpp_2s_ancestral + native", "k_dpmpp_2s_ancestral + karras", "k_dpmpp_2s_ancestral + exponential", "k_dpmpp_sde + native", "k_dpmpp_sde + karras", "k_dpmpp_sde + exponential","k_dpmpp_2m + native", "k_dpmpp_2m + karras", "k_dpmpp_2m + exponential",  "k_dpmpp_2m_sde + native", "k_dpmpp_2m_sde + karras", "k_dpmpp_2m_sde + exponential"], variable=sampler_var, font=my_font)
            sampler_button.grid(row=7, column=0, padx=15, sticky="n")

            apply_settings = customtkinter.CTkButton(auto_nai_window, text="설정 적용", font=my_font, command=on_apply)
            apply_settings.grid(row=1, column=0, padx=5, sticky="n")

            text_hyperlink = customtkinter.CTkLabel(auto_nai_window, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2")
            text_hyperlink.grid(row=1, column=1, padx=5, pady=5, sticky="nsew")
            text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/100402142"))

            if self.auto_nai_setting:
                rm_pr = '\n'.join(self.auto_nai_setting[0]).strip()
                rm_prompt.insert("0.0", rm_pr)
                entry1.insert(0, self.auto_nai_setting[1])
                add_prompt1.insert("0.0", self.auto_nai_setting[2])
                add_prompt2.insert("0.0", self.auto_nai_setting[3])
                negative_input.insert("0.0", self.auto_nai_setting[4])
                if len(self.auto_nai_setting) >= 6:
                    try: sampler_var.set(self.auto_nai_setting[5])
                    except: pass

            auto_nai_window.protocol("WM_DELETE_WINDOW", on_close)
            auto_nai_window.after(2000, lambda: auto_nai_window.attributes('-topmost', False))

        def auto_nai_on():
            if self.autonai_var.get():
                self.delay_offset = 2.0
                self.automation_setting_button.configure(text=f"자동화 설정 ({str(round(self.delay_offset, 1))}초)")
            else:
                self.delay_offset = -7.0
                self.automation_setting_button.configure(text=f"자동화 설정 ({str(round(self.delay_offset, 1))}초)")                

        #NAI 계정 로그인 상태
        self.ui_hide_var = customtkinter.IntVar(value=1)
        self.NAI_Account_State = customtkinter.CTkCheckBox(self.NAI_Account_Frame, text="NAI Login 필요 " if self.app_mode == "NAI" else "검색 UI 숨김", font=my_font, variable=self.ui_hide_var, command=search_ui_hide, border_color="#333333", fg_color="grey10", hover_color="#50164A")
        self.NAI_Account_State.grid(row=0, column=0, padx=10, sticky="w")
        if self.app_mode == 'WEBUI':
            self.autonai_var = customtkinter.IntVar()
            self.autonai = customtkinter.CTkCheckBox(self.NAI_Account_Frame, text="생성 후 결과물을 NAI로 I2I", font=my_font, variable=self.autonai_var, text_color="white", state="disabled", command=auto_nai_on)
            self.autonai.grid(row=0, column=1, padx=5, sticky="w")
            if self.auto_nai_setting: self.autonai.configure(state="normal")
            self.autonai_window=None
            self.autonai_setting = customtkinter.CTkButton(self.NAI_Account_Frame, text="NAI I2I 설정", font=my_font, command= lambda: open_auto_nai(self))
            self.autonai_setting.grid(row=0, column=2, padx=5, sticky="w")

        def update_ui():
            if self.app_mode == "NAI" and self.access_token:
                self.NAI_Account_Login.grid_forget()
                self.hide_image_ui.grid(row=0, column=1, padx=10, sticky="ew")

        def hide_image_ui():
            if self.hide_image_ui.get() == 1:
                self.right_frame.grid_forget()
            else:
                self.right_frame.grid(row=0, column=1, sticky="nsew")         
                
        #NAI 계정 로그인 버튼
        self.NAI_Account_Login = customtkinter.CTkButton(self.NAI_Account_Frame, text="NAI 계정연결", font=my_font, command=lambda: open_AccountSetting(self), width=100)
        self.hide_image_ui = customtkinter.CTkCheckBox(self.NAI_Account_Frame, text="이미지 UI 숨김", font=my_font, command=hide_image_ui, border_color="#333333", fg_color="grey10", hover_color="#50164A", width=100)
        
        #NAI 토큰 해제 버튼
        self.NAI_Token_Remove = customtkinter.CTkButton(self.NAI_Account_Frame, text="NAI 토큰제거", state="disabled", fg_color="#848484", font=my_font, command=lambda: NAI_token_remove(self), width=100)
    
        #WEBUI 전환 버튼
        self.WebuiSetting = None
        self.WEBUI_MODE = customtkinter.CTkButton(self.NAI_Account_Frame, text="↙ WEBUIA 전환", fg_color="grey10", hover_color="#ED7D31", font=my_font, width=110, command=lambda: open_WebuiSetting(self))

        if self.app_mode == "NAI":
            self.NAI_Account_Login.grid(row=0, column=1, padx=10, sticky="ew")
            self.NAI_Token_Remove.grid(row=0, column=2,padx=10, sticky="ew")
            self.WEBUI_MODE.grid(row=0, column=3, sticky="ew")

        def show_autocomplete_popup():
            # 팝업 윈도우 생성
            popup = tk.Toplevel()
            # 팝업 윈도우의 크기와 위치 설정
            popup.geometry("200x100+300+300")  # 너비x높이+X위치+Y위치
            #popup.attributes('-topmost', True)
            popup.overrideredirect(True)

            # 자동완성 목록을 위한 Listbox 위젯 생성
            listbox = tk.Listbox(popup)
            listbox.pack(fill=tk.BOTH, expand=True)

            # 예시 자동완성 태그들 추가
            for tag in ["태그1", "태그2", "태그3"]:
                listbox.insert(tk.END, tag)

            # 팝업 외부 클릭 시 팝업 닫기 이벤트 바인딩
            def close_popup(event):
                popup.destroy()
            popup.lift()

            popup.bind("<FocusOut>", close_popup)

        self.previous_search_text = set()
        def detect_keyword_insertion(event):
            current_text = self.search_label_entry.get()
            current_keywords = set([ctx.strip() for ctx in current_text.split(",")]) if current_text else set()
            added_keywords = current_keywords - self.previous_search_text
            removed_keywords = self.previous_search_text - current_keywords
            
            if added_keywords:
                print("추가된 키워드:", added_keywords)
                show_autocomplete_popup()
    
            self.previous_search_text = current_keywords

        #검색,제외 키워드 창
        self.search_label = customtkinter.CTkLabel(self.search_frame, text="검색 키워드 입력 : keyword, *keyword, {keyword1|keyword2}", font=my_font)
        self.search_label.grid(row=1, column=0, padx=8, sticky="w")
        search_hyperlink = customtkinter.CTkLabel(self.search_frame, text="가이드 열기 (arca.live)          ", font=customtkinter.CTkFont('Pretendard', 13),text_color="lightblue", cursor="hand2")
        search_hyperlink.grid(row=1, column=0, sticky="e")
        search_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/96006690"))
        self.search_label_entry = customtkinter.CTkEntry(self.search_frame, width=490)
        self.search_label_entry.grid(row=2, column=0, padx=8, sticky="w")
        #self.search_label_entry.bind("<KeyRelease>", detect_keyword_insertion)
        self.exclude_label = customtkinter.CTkLabel(self.search_frame, text="제외 키워드 입력 : keyword, ~keyword", font=my_font)
        self.exclude_label.grid(row=3, column=0, padx=8, sticky="w")
        self.exclude_label_entry = customtkinter.CTkEntry(self.search_frame, width=490)
        self.exclude_label_entry.grid(row=4, column=0, padx=8, sticky="w")
        self.low_sepc_mode_var = customtkinter.IntVar()
        self.low_sepc_mode = customtkinter.CTkCheckBox(self.search_frame, text="저사양/싱글코어 검색모드              ", font=my_font, variable=self.low_sepc_mode_var)
        self.low_sepc_mode.grid(row=3, column=0,  padx=8, sticky="e")

        #추가 확장
        self.search_frame_extend = customtkinter.CTkFrame(self.search_frame, width=490, fg_color="#2B2B2B")
        self.search_frame_extend.grid(row=5, column=0, padx=8, pady=2, sticky="nsew")

        #검색 수위 관리 창
        self.select_rating_frame = customtkinter.CTkFrame(self.search_frame, width=490)
        self.select_rating_frame.grid(row=6, column=0, padx=8, pady=3, sticky="nsew")

        #NAI 모델 선택창
        self.nai_model_select = customtkinter.CTkLabel(self.search_frame_extend, text="NAIA : ", font=my_font)
        self.nai_model_select.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")

        if self.app_mode == "NAI": self.nai_model_list = [ "NAID4", "NAID4-Curated","NAID3-Anime", "NAID3-Furry"]
        else: self.nai_model_list = ["NAID3-Anime", "NAID4", "NAID4-Curated", "NAID3-Furry"]

        self.current_model_nai = customtkinter.CTkComboBox(self.search_frame_extend, values=self.nai_model_list, width=120, font=my_font)
        self.current_model_nai.grid(row=0, column=1, padx=5, sticky="w")
        self.nai4_character_list = []
        self.nai4_character_uc_list = []
        self.nai4_character_list_freeze = []
        self.nai4_character_uc_list_freeze = []

        self.stacker_window = None
        def open_prompt_stacker():
            if self.stacker_window is None:
                stacker_window_open()
            else:
                if self.stacker_window.state() == 'withdrawn':
                    self.stacker_window.deiconify()
                else:
                    self.stacker_window.lift()

        def stacker_window_open():
            stacker_window = customtkinter.CTkToplevel()
            self.stacker_window = stacker_window
            stacker_window.title("parquet 파일 관리")
            stacker_window.attributes('-topmost', True)
            stacker_window.resizable(width=False, height=False)

            def on_close():
                stacker_window.withdraw()

            def save_as_parquet():
                file_path = filedialog.asksaveasfilename(
                    title="심층검색 프롬프트 내보내기",  
                    filetypes=[("Parquet files", "*.parquet")],  
                    defaultextension=".parquet"  
                )
                if file_path:  
                    self.cached_rows.to_parquet(file_path, engine='pyarrow')

            label1 = customtkinter.CTkLabel(stacker_window, text=" 남은 프롬프트 행을 .parquet 파일로 내보냅니다 ", font=my_font)
            label1.grid(row=0, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")
            button1 = customtkinter.CTkButton(stacker_window, text="Export to .parquet", font=my_font, command=save_as_parquet)
            button1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
            button1r = customtkinter.CTkButton(stacker_window, text="심층검색창 열기", font=my_font, command=depth_search, fg_color="#7030A0", hover_color="#481F67")
            button1r.grid(row=1, column=1, padx=5, pady=5, sticky="nsew")

            def clear_queue():
                self.cached_rows = self.cached_rows.iloc[0:0]
                update_labels()

            label2 = customtkinter.CTkLabel(stacker_window, text=" 남은 프롬프트 행을 비웁니다. ", font=my_font)
            label2.grid(row=2, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")
            button2 = customtkinter.CTkButton(stacker_window, text=" Clear Queue ", font=my_font, command=clear_queue, fg_color="grey10", hover_color="grey")
            button2.grid(row=3, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")

            def import_queue():
                file_path = filedialog.askopenfilename(
                    title="개인화 프롬프트 불러오기",
                    filetypes=[("Parquet files", "*.parquet")],
                    defaultextension=".parquet"
                )
                if file_path:
                    df = pd.read_parquet(file_path, engine="pyarrow")
                    df = pd.concat([self.cached_rows, df], ignore_index=True)
                    self.cached_rows = df.drop_duplicates()
                    update_labels()

            label3 = customtkinter.CTkLabel(stacker_window, text=" .parquet 파일을 불러와 [남은 프롬프트 행]에 합칩니다 ", font=my_font)
            label3.grid(row=4, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")
            button3 = customtkinter.CTkButton(stacker_window, text=" Concat .parquet ", font=my_font, command=import_queue, fg_color="#ED7D31", hover_color="#CC5D12")
            button3.grid(row=5, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")

            stacker_window.protocol("WM_DELETE_WINDOW", on_close)
            stacker_window.after(2000, lambda: stacker_window.attributes('-topmost', False))

        self.prompt_stacker_button = customtkinter.CTkButton(self.search_frame_extend, text="프롬프트 스태커", font=my_font, fg_color="grey10", hover_color="grey", command=open_prompt_stacker)
        self.prompt_stacker_button.grid(row=0, column=2, padx=5, pady=5, sticky="w")

        def reset_save():
            self.save_settings_button.configure(text="현재 설정 저장", state="normal")

        def foce_save():
            self.save_settings()
            self.save_settings_button.configure(state="disabled", text="app_settings 저장됨 !")
            self.after(3500, reset_save)


        self.save_settings_button = customtkinter.CTkButton(self.search_frame_extend, text="현재 설정 저장", font=my_font, fg_color="#004054", hover_color="#007599", command=foce_save)
        self.save_settings_button.grid(row=0, column=3, padx=5, pady=5, sticky="w")


        
        
        #검색 수위 체크박스
        self.rating_select_var_explicit = customtkinter.IntVar(value=1)
        self.rating_select_var_nsfw = customtkinter.IntVar(value=1)
        self.rating_select_var_sensitive = customtkinter.IntVar(value=1)
        self.rating_select_var_general = customtkinter.IntVar(value=1)
        self.rating_select_explicit = customtkinter.CTkCheckBox(self.select_rating_frame, width=85, text="Explicit", variable= self.rating_select_var_explicit, font=my_font)
        self.rating_select_explicit.grid(row=0, column=0, sticky="ew")
        self.rating_select_nsfw = customtkinter.CTkCheckBox(self.select_rating_frame, width=80,text="NSFW", variable= self.rating_select_var_nsfw, font=my_font)
        self.rating_select_nsfw.grid(row=0, column=1, sticky="ew")
        self.rating_select_sensitive = customtkinter.CTkCheckBox(self.select_rating_frame,width=90, text="Sensitive", variable= self.rating_select_var_sensitive, font=my_font)
        self.rating_select_sensitive.grid(row=0, column=2, sticky="ew")
        self.rating_select_general = customtkinter.CTkCheckBox(self.select_rating_frame,width=85, text="General", variable= self.rating_select_var_general, font=my_font)
        self.rating_select_general.grid(row=0, column=3, sticky="e")

        self.cached_rows = None
        self.searching_flag = False
        self.search_thread = None
        self.freezed_cached_rows = None
        self.depth_search_window = None

        def fav_check(id):
            return id in self.fav_id_list

        def null_prompt_attention():
            self.text_input.delete("0.0", "end")
            self.text_input.insert("0.0", "현재 조건에 맞는 프롬프트가 없습니다.")

        def depth_search():
            if self.depth_search_window is None:
                _depth_search()
            else:
                self.depth_search_window.deiconify()

        def _depth_search():
            depth_search_window = customtkinter.CTkToplevel()
            depth_search_window.title("심층검색 / 관리")
            depth_search_window.attributes('-topmost', True)
            depth_search_window.resizable(width=False, height=False)
            self.depth_search_window = depth_search_window
            self.freezed_cached_rows = self.cached_rows.copy()

            def perform_depth_search():
                self.search_button.configure(text="심층검색중", state="disabled")
                self.searching_flag = True
                df = self.cached_rows

                if rating_select_explicit.get() == 0:
                    df = df[df['rating'] != "e"]
                if rating_select_nsfw.get() == 0:
                    df = df[df['rating'] != "q"]
                if rating_select_sensitive.get() == 0:
                    df = df[df['rating'] != "s"]
                if rating_select_general.get() == 0:
                    df = df[df['rating'] != "g"]
                if limit_minimum.get():
                    try: lm = int(limit_min_entry.get())
                    except: lm = self.freezed_cached_rows['id'].iloc[0]
                    df = df[df['tokens'] > lm]
                if limit_maximum.get():
                    try: lm = int(limit_max_entry.get())
                    except: lm = self.freezed_cached_rows['id'].iloc[-1]
                    df = df[df['tokens'] < lm]
                if rem_original_character.get():
                    df = df[df['character'].notna()]
                if limit_minimum_post.get():
                    try: lm = int(limit_min_entry_post.get())
                    except: lm = 50
                    df = df[df['id'] > lm]
                if limit_maximum_post.get():
                    try: lm = int(limit_max_entry_post.get())
                    except: lm = 150
                    df = df[df['id'] < lm]

                df = NAIA_search.search(df, search_label_entry.get(), exclude_label_entry.get())
                
                if df is None:
                    null_prompt_attention() # 문자열 비었다고 경고
                else:
                    self.cached_rows = df
                    df.reset_index(drop=True, inplace=True)
                    update_labels()
                self.searching_flag = False
                depth_search_execute.configure(text="남은 프롬프트 행에서 재검색 : "+str(len(self.cached_rows)))
                prompt_rollback.configure(text="이전 프롬프트행 복원 : "+str(len(self.freezed_cached_rows)))
                self.search_button.configure(text="검색", state="normal")
                prompt_rollback.configure(state="normal")

            def rollback():
                self.cached_rows = self.freezed_cached_rows.copy()
                update_labels()
                depth_search_execute.configure(text="남은 프롬프트 행에서 재검색 : "+str(len(self.cached_rows)))
                prompt_rollback.configure(state="disabled")

            def depth_search_close():
                self.freezed_cached_rows = None
                self.depth_search_window = None
                depth_search_window.destroy()

            search_label = customtkinter.CTkLabel(depth_search_window, text="검색 키워드 입력 : keyword, *keyword, {keyword1|keyword2}", font=my_font)
            search_label.grid(row=1, column=0, columnspan=2, padx=8, pady=5, sticky="w")
            search_label_entry = customtkinter.CTkEntry(depth_search_window, width=490)
            search_label_entry.grid(row=2, column=0, columnspan=2, padx=8, pady=5, sticky="w")
            exclude_label = customtkinter.CTkLabel(depth_search_window, text="제외 키워드 입력 : keyword, ~keyword", font=my_font)
            exclude_label.grid(row=3, column=0, columnspan=2,  padx=8, pady=5, sticky="w")
            exclude_label_entry = customtkinter.CTkEntry(depth_search_window, width=490)
            exclude_label_entry.grid(row=4, column=0, columnspan=2, padx=8, pady=5, sticky="w")
            additional_frame = customtkinter.CTkFrame(depth_search_window, width=490)
            additional_frame.grid(row=5, column=0, columnspan=2, padx=5, pady=5, sticky="nsew")
            additional_frame.columnconfigure(0, weight= 1)
            additional_frame.columnconfigure(1, weight= 1)
            additional_frame.columnconfigure(2, weight= 1)
            additional_frame.columnconfigure(3, weight= 1)
            limit_minimum = customtkinter.CTkCheckBox(additional_frame, font=my_font, text="최소 토큰 수 제한 : ")
            limit_minimum.grid(row=0, column=0, padx=5, pady=5, sticky="w")
            limit_min_entry = customtkinter.CTkEntry(additional_frame, font=my_font, width=60)
            limit_min_entry.grid(row=0, column=1, padx=5, pady=5, sticky="w")
            limit_min_entry.insert(0, "50")
            limit_maximum = customtkinter.CTkCheckBox(additional_frame, font=my_font, text="최대 토큰 수 제한 : ")
            limit_maximum.grid(row=0, column=2, padx=5, pady=5, sticky="w")
            limit_max_entry = customtkinter.CTkEntry(additional_frame, font=my_font, width=60)
            limit_max_entry.grid(row=0, column=3, padx=5, pady=5, sticky="w")
            limit_max_entry.insert(0, "150")
            limit_minimum_post = customtkinter.CTkCheckBox(additional_frame, font=my_font, text="검색 시작 포스트 id : ")
            limit_minimum_post.grid(row=1, column=0, padx=5, pady=5, sticky="w")
            limit_min_entry_post = customtkinter.CTkEntry(additional_frame, font=my_font, width=80)
            limit_min_entry_post.grid(row=1, column=1, padx=5, pady=5, sticky="w")
            limit_min_entry_post.insert(0, str(self.freezed_cached_rows['id'].iloc[0]))
            limit_maximum_post = customtkinter.CTkCheckBox(additional_frame, font=my_font, text="검색 종료 포스트 id : ")
            limit_maximum_post.grid(row=1, column=2, padx=5, pady=5, sticky="w")
            limit_max_entry_post = customtkinter.CTkEntry(additional_frame, font=my_font, width=80)
            limit_max_entry_post.grid(row=1, column=3, padx=5, pady=5, sticky="w")
            limit_max_entry_post.insert(0, str(self.freezed_cached_rows['id'].iloc[-1]))
            rating_select_explicit = customtkinter.CTkCheckBox(additional_frame, text="Explicit", font=my_font)
            rating_select_explicit.grid(row=2, column=0, sticky="n")
            rating_select_nsfw = customtkinter.CTkCheckBox(additional_frame, text="NSFW", font=my_font)
            rating_select_nsfw.grid(row=2, column=1, sticky="n")
            rating_select_sensitive = customtkinter.CTkCheckBox(additional_frame,text="Sensitive", font=my_font)
            rating_select_sensitive.grid(row=2, column=2, sticky="n")
            rating_select_general = customtkinter.CTkCheckBox(additional_frame, text="General", font=my_font)
            rating_select_general.grid(row=2, column=3, sticky="n")
            rating_select_explicit.select()
            rating_select_nsfw.select()
            rating_select_sensitive.select()
            rating_select_general.select()

            exclude_label_autocomplete = AutoCompleteHandler(
                master=depth_search_window,
                app_mode=self.app_mode, 
                text_widget=exclude_label_entry,
                autocomplete_var=tk.IntVar(value=1),
                wildcard_dict_tree=None
            )

            search_label_autocomplete = AutoCompleteHandler(
                master=depth_search_window,
                app_mode=self.app_mode, 
                text_widget=search_label_entry,
                autocomplete_var=tk.IntVar(value=1),
                wildcard_dict_tree=None
            )


            depth_search_execute = customtkinter.CTkButton(depth_search_window, text="남은 프롬프트 행에서 재검색 : "+str(len(self.cached_rows)), font=my_font, command=perform_depth_search)
            depth_search_execute.grid(row=10, column=0, padx=5,pady=10,  sticky="n")
            prompt_rollback = customtkinter.CTkButton(depth_search_window, text="이전 프롬프트행 복원 : "+str(len(self.freezed_cached_rows)), font=my_font, fg_color="#7030A0", hover_color="#481F67", command=rollback, state="disabled")
            prompt_rollback.grid(row=10, column=1, padx=5,pady=10,  sticky="n")
            depth_search_window.protocol("WM_DELETE_WINDOW", depth_search_close)
            depth_search_window.after(2000, lambda: depth_search_window.attributes('-topmost', False))

            #추가 옵션
            rem_original_character = customtkinter.CTkCheckBox(depth_search_window, font=my_font, text="캐릭터명이 비어있는 프롬프트 행 제외")
            rem_original_character.grid(row=11, column=0,  columnspan=2, padx=5, pady=5, sticky="w")            
            rem_has_parent = customtkinter.CTkCheckBox(depth_search_window, font=my_font, text="캐릭터명이 비어있는 프롬프트 행 제외")
            rem_has_parent.grid(row=12, column=0,  columnspan=2, padx=5, pady=5, sticky="w")       

        def perform_search():
            dflist = [os.path.join("tags", f"tags_{i:02}.parquet") if i < 100 else os.path.join("tags", f"tags_{i:03}.parquet") for i in range(130)]
            success_flag = False

            for i,  _df in enumerate(dflist):
                df = pd.read_parquet(os.path.join(basedir,_df), engine="pyarrow")
                df = NAIA_search.search(df, self.search_label_entry.get(), self.exclude_label_entry.get(), self.rating_select_explicit.get(), self.rating_select_nsfw.get(), self.rating_select_sensitive.get(), self.rating_select_general.get())
                
                if success_flag == False and type(df) != type(None) and not df.empty:
                    self.cached_rows = pd.DataFrame()
                    success_flag = True

                if type(df) != type(None) and not df.empty:
                    self.cached_rows = pd.concat([self.cached_rows, df], ignore_index=True)
                self.search_button.configure(text=f"검색 ({int(i*0.091)}%)")
                update_labels()

            self.searching_flag = False
            self.search_button.configure(text="검색", state="normal")

        def update_labels():
            if type(self.cached_rows) != type(None):
                self.searched_prompt_label.configure(text="검색 프롬프트 행 : " + str(len(self.cached_rows)))
                self.cached_prompt_label.configure(text="남은 프롬프트 행 : " + str(len(self.cached_rows)))
            if self.prior_queue:
                self.cached_prompt_label.configure(text = "남은 우선예약 큐 : "+str(len(self.prior_queue)), text_color="#ED7D31")
   
        #검색 결과 관리 창
        self.searched_prompt_frame = customtkinter.CTkFrame(self.search_frame)
        self.searched_prompt_frame.grid(row=7, column=0, padx=8, pady=5, sticky="nsew")
        self.searched_prompt_frame.columnconfigure(0, weight= 1)
        self.searched_prompt_frame.columnconfigure(1, weight= 1)
        self.searched_prompt_frame.columnconfigure(2, weight= 1)
        self.searched_prompt_label = customtkinter.CTkLabel(self.searched_prompt_frame, text="검색 프롬프트 행 : 0", font=my_font)
        self.searched_prompt_label.grid(row=0, column=0, sticky="ew")
        self.cached_prompt_label = customtkinter.CTkLabel(self.searched_prompt_frame, text="남은 프롬프트 행 : 0", font=my_font)
        self.cached_prompt_label.grid(row=0, column=1, sticky="ew")

        if self.app_mode == "WEBUI":
            def change_model(choice):
                def change_model_request():
                    self.current_model_box.configure(state="disabled")
                    try:
                        res = NAIA_utils.change_model(self.access_token, choice)
                        self.current_model_box.configure(state="normal")
                    except:
                        self.current_model_box.configure(state="normal")
                    if res == True:
                        self.webui_current_model.set(choice)
                if choice == self.previous_model:
                    return
                else:
                    model_change_thread = threading.Thread(target=change_model_request, daemon=True)
                    model_change_thread.start()

            self.searched_prompt_frame.configure(fg_color="#2B2B2B")
            self.webui_current_model = customtkinter.StringVar(value=NAIA_utils.get_current_model(self.access_token))
            self.previous_model = self.webui_current_model.get()
            self.webui_model_list = NAIA_utils.get_model_list(self.access_token)
            self.current_model_box = customtkinter.CTkComboBox(self.searched_prompt_frame, width=330,values=self.webui_model_list, variable=self.webui_current_model, command=change_model, font=my_font)
            self.current_model_box.grid(row=1, column=0, columnspan=2, pady=5, padx=5, sticky="w")

            def open_lora_list():
                _list = NAIA_utils.get_lora_list(self.access_token)
                _text = "\n".join(_list)
                prompt_window = customtkinter.CTkToplevel()
                prompt_window.title("LoRA 리스트")
                prompt_window.attributes('-topmost', True)
                prompt_window.resizable(width=False, height=False)

                text_label1 = customtkinter.CTkLabel(prompt_window, text="WEBUI 활성 로라 목록", font=customtkinter.CTkFont('Pretendard', 13))
                text_label1.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                text_output1 = customtkinter.CTkTextbox(prompt_window, height=550, width=380, font=customtkinter.CTkFont('Pretendard', 15))
                text_output1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                text_output1.insert("0.0", _text)
                text_label2 = customtkinter.CTkLabel(prompt_window, text="드래그 후 Ctrl + C로 복사", font=customtkinter.CTkFont('Pretendard', 13))
                text_label2.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")

            self.temp_scheduler = "Automatic"

            self.lora_button = customtkinter.CTkButton(self.searched_prompt_frame, text="LoRA 리스트", font=my_font, fg_color="grey10", hover_color="grey", command=open_lora_list)
            self.lora_button.grid(row=1, column=2,pady=5, padx=5, sticky="nsew")
            self.scheduler_isExist = False
            try: 
                self.webui_scheduler_list = NAIA_utils.get_schedulers_list(self.access_token)
                self.scheduler_label = customtkinter.CTkLabel(self.searched_prompt_frame, text="Schedule Type : ", font=customtkinter.CTkFont('Pretendard', 13))
                self.scheduler_label.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")
                self.current_scheduler = customtkinter.CTkComboBox(self.searched_prompt_frame, values=self.webui_scheduler_list, font=my_font)
                self.current_scheduler.grid(row=2, column=1, padx=5, pady=5, sticky="nsew")
                self.scheduler_isExist = True
            except: 
                pass

        fdf = None

        self.Preset_open = None
        def open_Preset(self):
            if self.Preset_open is None:
                self.Preset_open = Preset_open(self)
            else:
                if self.Preset_open.state() == 'withdrawn':
                    self.Preset_open.deiconify()
                else:
                    self.Preset_open.focus()

        self.Awildcard_open = None
        def open_Awildcard(self):
            if self.Awildcard_open is None:
                self.Awildcard_open = Wildcard_open(self)
            else:
                if self.Awildcard_open.state() == 'withdrawn':
                    self.Awildcard_open.deiconify()
                else:
                    self.Awildcard_open.focus()

        def open_favorite():
            favorite_window = customtkinter.CTkToplevel()
            favorite_window.title("선호 프롬프트")
            favorite_window.attributes('-topmost', True)
            favorite_window.resizable(width=False, height=False)
            self.freezed_cached_rows = self.cached_rows.copy()
            odf = None

            global fdf
            fdf = pd.read_parquet("favorite_prompt.parquet", engine="pyarrow")
            fdf = fdf.iloc[::-1].reset_index(drop=True)
            odf = fdf.copy()
            max_page = [1 + len(fdf) // 5]

            def perform_favorite_search():
                global fdf
                fdf = NAIA_search.search(odf, search_label_entry.get(), exclude_label_entry.get())
                
                if type(fdf) == type(None):
                    assign_row.configure(text="검색 결과 없음")
                    return 
                
                assign_row.configure(text="랜덤 프롬프트에 삽입 "+str(len(fdf)))
                prompt_rollback.configure(text="이전 프롬프트행 복원 : "+str(len(self.freezed_cached_rows)))
                self.search_button.configure(text="검색", state="normal")
                max_page[0] = 1 + len(fdf) // 5
                current_page[0] = 0
                page.configure(text=f" 1 / {max_page[0]} ")
                prev_button.configure(state="disabled")


                if max_page[0] == 1:
                    next_button.configure(state="disabled")
                else:
                    next_button.configure(state="normal")
                update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font)

            def import_prompt():
                global fdf
                if fdf is None:
                    null_prompt_attention() # 문자열 비었다고 경고
                else:
                    self.cached_rows = fdf.copy()
                    fdf.reset_index(drop=True, inplace=True)
                    update_labels()
                prompt_rollback.configure(state="normal")

            def rollback():
                global fdf
                self.cached_rows = self.freezed_cached_rows.copy()
                update_labels(self.cached_rows)
                assign_row.configure(text="랜덤 프롬프트에 삽입 "+str(len(fdf)))
                prompt_rollback.configure(state="disabled")

            def favorite_search_close():
                self.freezed_cached_rows = None
                favorite_window.destroy()

            search_frame =  customtkinter.CTkFrame(favorite_window, width=990)
            search_frame.grid(row=0, column=0, padx=5,pady=5,  sticky="nsew")
            search_label = customtkinter.CTkLabel(search_frame, text="검색 키워드 입력 : keyword, *keyword, {keyword1|keyword2}", font=my_font)
            search_label.grid(row=0, column=0, columnspan=2, padx=8, pady=5, sticky="nsew")
            search_label_entry = customtkinter.CTkEntry(search_frame, width=485)
            search_label_entry.grid(row=1, column=0, columnspan=2, padx=8, pady=5, sticky="nsew")
            exclude_label = customtkinter.CTkLabel(search_frame, text="제외 키워드 입력 : keyword, ~keyword", font=my_font)
            exclude_label.grid(row=0, column=2,  columnspan=2, padx=8, pady=5, sticky="nsew")
            exclude_label_entry = customtkinter.CTkEntry(search_frame, width=485)
            exclude_label_entry.grid(row=1, column=2, columnspan=2, padx=8, pady=5, sticky="nsew")

            depth_search_execute = customtkinter.CTkButton(search_frame, text="선호 프롬프트내 검색", font=my_font, command=perform_favorite_search)
            depth_search_execute.grid(row=2, column=0, padx=5,pady=5,  sticky="n")

            assign_row = customtkinter.CTkButton(search_frame, text="랜덤 프롬프트에 삽입 "+str(len(fdf)), font=my_font, fg_color="#CDCDCD", text_color="black", hover_color="#848484", command=import_prompt)
            assign_row.grid(row=2, column=1, padx=5,pady=5,  sticky="n")

            prompt_rollback = customtkinter.CTkButton(search_frame, text="이전 프롬프트행 복원 : "+str(len(self.freezed_cached_rows)), font=my_font, fg_color="#7030A0", hover_color="#481F67", command=rollback, state="disabled")
            prompt_rollback.grid(row=2, column=2, padx=5,pady=5,  sticky="n")

            page_frame = customtkinter.CTkFrame(search_frame)
            page_frame.grid(row=2, column=3, padx=5,pady=5 ,sticky="nsew")

            def prev_pressed():
                current_page[0] -= 1
                if current_page[0] <= 0:
                    prev_button.configure(state="disabled")
                if current_page[0] < max_page[0]:
                    next_button.configure(state="normal")
                page.configure( text=f"{1+current_page[0]} / {max_page[0]} ")
                update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font)

            def next_pressed():
                current_page[0] += 1
                if current_page[0] >= max_page[0]-1:
                    next_button.configure(state="disabled")
                prev_button.configure(state="normal")
                page.configure( text=f"{1+current_page[0]} / {max_page[0]} ")
                update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font)


            page = customtkinter.CTkLabel(page_frame, text=f" 1 / {max_page[0]} ", font=my_font, width=70)
            page.grid(row=0, column=1,  padx=5, sticky="nsew")
            prev_button = customtkinter.CTkButton(page_frame, text=" ◀ Prev ", font=my_font, width=70, state="disabled", command=prev_pressed)
            prev_button.grid(row=0, column=0,  padx=5 ,sticky="nsew")
            next_button = customtkinter.CTkButton(page_frame, text=" Next ▶ ", font=my_font, width=70, command=next_pressed)
            next_button.grid(row=0, column=2,  padx=5,  sticky="nsew")
            if max_page[0] == 1:
                next_button.configure(state="disabled")



            favorite_window.protocol("WM_DELETE_WINDOW", favorite_search_close)

            headers = ['↙', 'character', 'copyright', 'artist', 'general prompts', 'image', 'delete']
            headers_width = [60, 120, 120, 120, 360, 120, 60]
            header_frame = customtkinter.CTkFrame(favorite_window)
            header_frame.grid(row=6, column=0, padx=5,pady=5,  sticky="nsew")
            empty_image = customtkinter.CTkImage(Image.new('RGB', size=(192,192), color="#2B2B2B"), size=(120, 120))

            for i, header in enumerate(headers):
                label = customtkinter.CTkLabel(header_frame, text=header, width=headers_width[i], font=my_font)
                label.grid(row=0, column=i, sticky="nsew", padx=5)

            ui_elements = []  # UI 요소 저장용 이중 리스트

            for i in range(5):  # DataFrame 길이를 고려
                row_elements = []
                if i < len(fdf):
                    row = fdf.iloc[i]
                row_frame = customtkinter.CTkFrame(favorite_window)
                row_frame.grid(row=i+7, column=0, sticky="nsew", padx=5, pady=5)

                for j, header in enumerate(['↙', 'character', 'copyright', 'artist', 'general', 'image', 'delete']):
                    if header == '↙':
                        button = customtkinter.CTkButton(
                            row_frame, width=headers_width[j], font=my_font,
                            text="↙", height=28, state="disabled"
                        )
                        button.grid(row=0, padx=5, column=j, sticky="nsew")
                        element = button
                    elif header == 'delete':
                        delete_button = customtkinter.CTkButton(
                            row_frame, width=headers_width[j], font=my_font, text="✖",
                            height=28, fg_color="grey", hover_color="grey10", state="disabled"
                        )
                        delete_button.grid(row=0, padx=5, column=j, sticky="nsew")
                        element = delete_button
                    elif header == 'image':
                        label = customtkinter.CTkLabel(row_frame, width=headers_width[j], font=my_font, text=" ", height=120)
                        label.grid(row=0, padx=5, column=j, sticky="nsew")
                        element = label
                    else:
                        text = customtkinter.CTkTextbox(row_frame, width=headers_width[j], font=my_font, height=120)
                        text.grid(row=0, padx=5, column=j, sticky="nsew")
                        element = text
                    row_elements.append(element)
                    
                ui_elements.append(row_elements)  # 각 행의 UI 요소를 추가

            # 이미지 삭제 함수
            def delete_image(image_path):
                try:
                    os.remove(image_path)
                except OSError as e:
                    print(f"Error deleting file {image_path}: {e.strerror}")

            # DataFrame 행 삭제 및 업데이트 함수
            def delete_row(fdf, idx, image_path, basedir):
                # DataFrame에서 특정 id 값을 가진 행을 'deleted'로 표시
                fdf.loc[fdf['id'] == idx, 'deleted'] = 'deleted'
                
                # DataFrame에서 특정 행 삭제
                row_indices = fdf.index[fdf['id'] == idx].tolist()
                sdf = pd.read_parquet("favorite_prompt.parquet", engine='pyarrow')
                try:
                    if row_indices:
                        fdf.drop(index=row_indices, inplace=True)
                        odf.drop(index=row_indices, inplace=True)
                        # 변경된 DataFrame을 parquet 파일로 저장
                        odf.to_parquet("favorite_prompt.parquet", engine='pyarrow')
                        # 이미지 파일 삭제
                        delete_image(image_path)
                except:
                    sdf.to_parquet("favorite_prompt.parquet", engine='pyarrow')
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<ExceptionAlert> parquet 처리 실패로 창이 닫혔습니다. 정기적으로 데이터를 백업 해 주세요.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    favorite_search_close()
                    return
                
                update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font)

            # 삭제 버튼 클릭 시 실행될 함수를 생성하는 함수
            def make_delete_command(fdf, idx, image_path, basedir):
                def command():
                    delete_row(fdf, idx, image_path, basedir)
                return command

            def make_select_command(dataframe, row_id):
                """
                특정 DataFrame 행의 'id' 값을 출력하는 커맨드를 생성하는 함수.
                이 함수는 람다 함수를 사용하여 버튼에 할당될 커맨드를 반환합니다.
                """
                def command():
                    popped_row = dataframe.loc[dataframe['id'] == row_id]
                    if not popped_row.empty:
                        popped_row_series = popped_row.iloc[0]  # 첫 번째 행을 Series로 변환
                        if self.control_pressed:
                            # 얻은 Series에 random_function을 적용합니다.
                            random_function(popped_row_series)
                        else:
                            self.prior_queue.append(popped_row_series)
                            self.cached_prompt_label.configure(text = "남은 우선예약 큐 : "+str(len(self.prior_queue)), text_color="#ED7D31")
                return command

            def update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font):
                global fdf
                base_image_path = "favorite_prompts"
                rows_per_page = 5
                start_index = current_page[0] * rows_per_page  # current_page[0]에서 수정됨, current_page가 이미 정수라고 가정
                end_index = min(start_index + rows_per_page, len(fdf))

                for i in range(5):  # 최대 5개의 행을 처리
                    # 현재 페이지에 표시할 데이터가 있는 경우
                    if i < end_index - start_index:
                        row = fdf.iloc[start_index + i]
                        for j, header in enumerate(['↙', 'character', 'copyright', 'artist', 'general', 'image', 'delete']):
                            element = ui_elements[i][j]  # 기존 UI 요소에 접근
                            if header == '↙':
                                # '↙' 버튼의 커맨드 업데이트
                                element.configure(state="normal", command=make_select_command(fdf, row['id']))
                            elif header == 'delete':
                                # 'delete' 버튼의 커맨드 업데이트
                                image_path = f"{base_image_path}/{row['id']}.jpg"
                                element.configure(state="normal", command=make_delete_command(fdf, row['id'], image_path, basedir))
                            elif header == 'image':
                                try:
                                    image_path = f"{base_image_path}/{row['id']}.jpg"
                                    if os.path.exists(image_path):
                                        _image = customtkinter.CTkImage(Image.open(image_path), size=(120, 120))
                                        element.configure(image=_image)
                                    else:
                                        raise FileNotFoundError
                                except FileNotFoundError:
                                    element.configure(text="Image Not Found")
                            else:
                                # 텍스트박스의 텍스트 업데이트
                                text_value = row[header] if pd.notna(row[header]) else ""
                                element.delete("0.0", "end")
                                element.insert("0.0", text_value)
                    else:
                        # 현재 페이지에 표시할 데이터가 없는 경우, 비어 있는 행의 내용을 초기화
                        for j, element in enumerate(ui_elements[i]):
                            if isinstance(element, customtkinter.CTkLabel):
                                element.configure(text=" ", image=empty_image)
                                element.image = empty_image
                            elif isinstance(element, customtkinter.CTkTextbox):
                                element.delete("0.0", "end")
                            elif isinstance(element, customtkinter.CTkButton):
                                element.configure(state="disabled")



            # 현재 페이지를 0으로 설정 (0부터 시작)
            current_page = [0]

            comment_label = customtkinter.CTkLabel(favorite_window, font=my_font, text="↙ 버튼 클릭시 우선생성 큐에 삽입, Ctrl+↙ 클릭시 즉시 프롬프트 삽입", text_color="#F9E987")
            comment_label.grid(row=13, column=0, padx=5, sticky="w")

            # UI 업데이트 함수 호출
            update_ui_with_dataframe(current_page, favorite_window, headers_width, my_font)
            favorite_window.after(1500, lambda: favorite_window.attributes('-topmost', False))

        def press_Awildcard():
            open_Awildcard(self)

        def select_preset():
            if self.control_pressed:
                pass
            else:
                open_Preset(self)

        self.prompt_preset_button = customtkinter.CTkButton(self.searched_prompt_frame, width=80, text="프리셋", fg_color="#848484", font=my_font, command= select_preset)
        self.prompt_preset_button.grid(row=0, column=2, sticky="w")

        self.fav_button = customtkinter.CTkButton(self.searched_prompt_frame, width=40, text=" ★ ", font=my_font, fg_color="#7030A0", hover_color="#481F67",  command= open_favorite)
        self.fav_button.grid(row=0, column=2, padx=15, sticky="e")

        try:
            parquet_path = os.path.join("favorite_prompt.parquet")
            temp_df = pd.read_parquet(parquet_path, engine="pyarrow")
            self.fav_id_list = []
            if 'id' in temp_df.columns:
                self.fav_id_list.extend(temp_df['id'].tolist())
            del(temp_df)        
        except:
            self.fav_id_list = []
            #여기서 오류남 이따 고치셈
            self.fav_button.configure(state="disabled")

        self.character_copyright_dict = None
        try:
            json_path = os.path.join("character_copyrights_dict")
            with open(json_path, 'r', encoding='utf-8') as f:
                self.character_copyright_dict = json.load(f)
        except:
            self.character_copyright_dict = None

        self.sequence_index = None
        self.turbo_is_seq = False
        def seq_click_callback(event):
            if self.sequence_index or self.running_flag:
                return
            self.text_input.tag_unbind("highlight_seq", "<Button-1>")
            self.text_input.tag_config("highlight_seq", foreground="yellow", underline=False)
            self.text_input.tag_unbind("highlight_seq", "<Enter>")
            self.text_input.tag_unbind("highlight_seq", "<Leave>")
            self.text_input.configure(cursor="arrow")
            click_index = self.text_input.index("@%d,%d" % (event.x, event.y))
            ranges = self.text_input.tag_ranges("highlight_seq")
            occurrence = None
            for i in range(0, len(ranges), 2):
                start_range = ranges[i]
                end_range = ranges[i+1]
                # 클릭 인덱스가 해당 범위 내에 있는지 확인
                if self.text_input.compare(click_index, ">=", start_range) and self.text_input.compare(click_index, "<", end_range):
                    # occurrence 번호는 i//2 + 1 (첫 occurrence는 1부터 시작)
                    occurrence = (i // 2) + 1
                    break
            if occurrence is not None:
                self.sequence_index = occurrence
                _NAIA_generate()

        def highlight_text(event=None):
            # 전체 텍스트 읽어오기
            content = self.text_input.get("1.0", tk.END)
            
            # 기존의 모든 하이라이트 태그 제거
            self.text_input.tag_remove("default", "1.0", tk.END)
            self.text_input.tag_remove("highlight", "1.0", tk.END)
            self.text_input.tag_remove("highlight_begin_end", "1.0", tk.END)
            self.text_input.tag_remove("highlight_seq", "1.0", tk.END)
            self.text_input.tag_remove("highlight_dash", "1.0", tk.END)
            
            # ---------------------------
            # 1. '#' 하이라이트 (기존 기능)
            for match in re.finditer(r'#.*?([,\n]|$)', content):
                start = "1.0 + {}c".format(match.start())
                end = "1.0 + {}c".format(match.end())
                self.text_input.tag_add("highlight", start, end)
            
            # ---------------------------
            # 2. ":begin"과 ":end" 하이라이트 (하늘색)
            # :begin 처리 (문자열 길이 6)
            if ":begin" in content:
                idx = "1.0"
                while True:
                    idx = self.text_input.search(":begin", idx, stopindex="end")
                    if not idx:
                        break
                    end_idx = "{}+6c".format(idx)
                    self.text_input.tag_add("highlight_begin_end", idx, end_idx)
                    idx = end_idx

                # :end 처리 (문자열 길이 4)
                idx = "1.0"
                while True:
                    idx = self.text_input.search(":end", idx, stopindex="end")
                    if not idx:
                        break
                    end_idx = "{}+4c".format(idx)
                    self.text_input.tag_add("highlight_begin_end", idx, end_idx)
                    idx = end_idx
                
                # ---------------------------
                # 3. ":seq" 하이라이트 (노란색)
                # ":seq"를 포함하는 토큰에서 첫 번째 공백 또는 줄바꿈 전까지의 텍스트만 강조합니다.
                # 예시: ":seq1 looking at viewer"에서 ":seq1"만 강조됨.
                for match in re.finditer(r"(:seq\S*)", content):
                    start = "1.0 + {}c".format(match.start(1))
                    end = "1.0 + {}c".format(match.end(1))
                    self.text_input.tag_add("highlight_seq", start, end)

            # ---------------------------
            # 4. 쉼표 다음으로 오는 -로 시작하는 태그 하이라이트 (grey10)
            # 예시: ", -example"에서 "-example" 부분을 강조합니다.
            for match in re.finditer(r"(?<=,\s)(-[^,\n]+)", content):
                start = "1.0 + {}c".format(match.start(1))
                end = "1.0 + {}c".format(match.end(1))
                self.text_input.tag_add("highlight_dash", start, end)

            # ---------------------------
            # 태그 스타일 설정 (하이라이트 색상)
            self.text_input.tag_config("highlight", foreground="orange")  # '#' 하이라이트 색상 (필요 시 조정)
            self.text_input.tag_config("highlight_begin_end", foreground="sky blue")
            self.text_input.tag_config("highlight_dash", foreground="grey")

            if not self.running_flag:
                self.text_input.tag_config("highlight_seq", foreground="yellow", underline=True)
                self.text_input.tag_bind("highlight_seq", "<Enter>", lambda e: self.text_input.configure(cursor="hand2"))
                self.text_input.tag_bind("highlight_seq", "<Leave>", lambda e: self.text_input.configure(cursor="arrow"))
                self.text_input.tag_bind("highlight_seq", "<Button-1>", seq_click_callback)
            else:
                self.text_input.tag_config("highlight_seq", foreground="yellow", underline=False)
                self.text_input.tag_unbind("highlight_seq", "<Enter>")
                self.text_input.tag_unbind("highlight_seq", "<Leave>")
                self.text_input.tag_unbind("highlight_seq", "<Button-1>")



        def on_enter_pressed(event):
            if self.control_pressed:
                NAIA_generate(self)
                return "break"
            else:
               highlight_text()

        def on_tab_pressed(event):
            if self.toggle_prompt_fix_button.get() == 0:
                time.sleep(0.2)
                random_function()

        def open_vibe():
            filepath = filedialog.askopenfilename(title="Open Image", filetypes=[("Image files", "*.png;*.jpg;*.webp"), ("All files", "*.*")])
            if filepath:  
                set_image_reference(Image.open(filepath))

        #WEBUI 이미지 가이드 프레임
        self.image_guide_frame = customtkinter.CTkFrame(self.searched_prompt_frame)

        def guide_reroll():
            if self.guide_generation_thread_contents != None:
                guide_generation_thread = threading.Thread(target=run_webui_guide, args=(self.guide_generation_thread_contents, "reroll"), daemon=True)
                guide_generation_thread.start()

        self.webui_guide_setting = None
        self.webui_guide_setting_window = None
        self.webui_guide_image_save = customtkinter.IntVar(value = 0)
        self.webui_guide_maintain_artist = customtkinter.IntVar(value = 0)
        self.temp_guide_prompt = None
        self.temp_guide_seed = None
        self.temp_guide_filename = None
        self.nai_api_limit_off = customtkinter.IntVar(value = 0)

        def open_webui_guide_setting():
            guide_setting_file_path = os.path.join('.', 'NAIA_webui_guide_setting.json')

            if self.webui_guide_setting_window is None:
                try:
                    if os.path.exists(guide_setting_file_path):
                        with open(guide_setting_file_path, "r", encoding='utf-8') as f:
                            self.webui_guide_setting = json.load(f)
                except:
                    self.webui_guide_setting = None
                webui_guide_setting()
            else:
                if self.webui_guide_setting_window.state() == 'withdrawn':
                    self.webui_guide_setting_window.deiconify()
                else:
                    self.webui_guide_setting_window.lift()

        def webui_guide_setting():
            def on_close():
                webui_guide_setting_window.withdraw()

            def on_apply():
                try:
                    self.webui_guide_setting = {
                        "prefix": prefix.get("0.0", "end-1c"),
                        "postfix": postfix.get("0.0", "end-1c"),
                        "negative": negative.get("0.0", "end-1c"),
                        "steps": int(entry1.get()),
                        "cfg_scale": round(float(entry2.get()), 1),
                        "sampler": sampler_var.get(),
                        "vibe_ie":round(float(value1.get()), 2),
                        "vibe_strength":round(float(value2.get()), 2),
                        "i2i_strength": round(float(value3.get()), 2),
                        "image_size": image_size_var.get(),
                        "rm_character": rm_character.get(),
                        "image_resolution": image_resolution_var.get(),
                        "rm_prompt" : rm_text.get()
                    }
                    if self.webui_guide_setting["image_size"] == "중간": self.temp_guide_image_size = (368, 368)
                    elif self.webui_guide_setting["image_size"] == "작게": self.temp_guide_image_size = (256, 256)
                    else: self.temp_guide_image_size = (480, 480)
                    if self.webui_guide_setting["image_resolution"] == "1024 해상도": self.webui_image_resoluiton =1
                    else: self.webui_image_resoluiton = 0
                    with open("NAIA_webui_guide_setting.json", "w") as f:
                        json.dump(self.webui_guide_setting, f, ensure_ascii=False, indent=4)
                    if self.guide_generation_thread_contents:
                        self.guide_generation_thread_contents = {
                            "prompt": self.guide_generation_thread_contents["prompt"],
                            "prefix": self.webui_guide_setting["prefix"],
                            "negative": self.webui_guide_setting["negative"],
                            "postfix": self.webui_guide_setting["postfix"],
                            "steps": self.webui_guide_setting["steps"],
                            "cfg_scale": self.webui_guide_setting["cfg_scale"],
                            "sampler": self.webui_guide_setting["sampler"],
                            "vibe_ie": self.webui_guide_setting["vibe_ie"],
                            "vibe_strength": self.webui_guide_setting["vibe_strength"],
                            "i2i_strength": self.webui_guide_setting["i2i_strength"]
                        }
                        try: self.guide_generation_thread_contents["rm_text"] = self.webui_guide_setting["rm_prompt"]
                        except: pass
                    webui_guide_setting_window.withdraw()
                except:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> NAIA_webui_guide_setting의 입력값이 잘못되었습니다. 데이터가 손실되었을 가능성이 있습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")                    

            webui_guide_setting_window = customtkinter.CTkToplevel()
            self.webui_guide_setting_window = webui_guide_setting_window
            webui_guide_setting_window.title("WEBUIA 이미지 가이드 세부설정")
            webui_guide_setting_window.attributes('-topmost', True)
            webui_guide_setting_window.resizable(width=False, height=False)

            webui_guide_setting_window_left = customtkinter.CTkFrame(webui_guide_setting_window)
            webui_guide_setting_window_left.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
            webui_guide_setting_window_right = customtkinter.CTkFrame(webui_guide_setting_window)
            webui_guide_setting_window_right.grid(row=0, column=1, padx=5, pady=5, sticky="nsew")

            label1 = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="prefix : 프롬프트의 앞에 적용됩니다.")
            label1.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
            prefix = customtkinter.CTkTextbox(webui_guide_setting_window_left, font=my_font, width=400, height=100)
            prefix.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
            if self.webui_guide_setting and self.webui_guide_setting["prefix"]: prefix.insert("0.0", self.webui_guide_setting["prefix"])

            label2 = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="postfix : 프롬프트의 뒤에 적용됩니다.  (LoRA 포함)")
            label2.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")
            postfix = customtkinter.CTkTextbox(webui_guide_setting_window_left, font=my_font, width=400, height=100)
            postfix.grid(row=3, column=0, padx=5, pady=5, sticky="nsew")
            if self.webui_guide_setting and self.webui_guide_setting["postfix"]: postfix.insert("0.0", self.webui_guide_setting["postfix"])

            label3 = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="Negative prompt : 네거티브 프롬프트로 사용됩니다..")
            label3.grid(row=4, column=0, padx=5, pady=5, sticky="nsew")
            negative = customtkinter.CTkTextbox(webui_guide_setting_window_left, font=my_font, width=400, height=100)
            negative.grid(row=5, column=0, padx=5, pady=5, sticky="nsew")
            if self.webui_guide_setting and self.webui_guide_setting["negative"]: negative.insert("0.0", self.webui_guide_setting["negative"])

            label4 = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="Step : ")
            label4.grid(row=6, column=0, padx=95, pady=5, sticky="w")
            entry1 = customtkinter.CTkEntry(webui_guide_setting_window_left, font=my_font, width=100)
            entry1.grid(row=6, column=0, padx=155, pady=5, sticky="e")
            if self.webui_guide_setting and self.webui_guide_setting["steps"]: entry1.insert(0, str(self.webui_guide_setting["steps"]))
            else: entry1.insert(0, "12")

            label5 = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="CFG Scale : ")
            label5.grid(row=7, column=0, padx=85, pady=5, sticky="w")
            entry2 = customtkinter.CTkEntry(webui_guide_setting_window_left, font=my_font, width=100)
            entry2.grid(row=7, column=0, padx=155, pady=5, sticky="e")
            if self.webui_guide_setting and self.webui_guide_setting["cfg_scale"]: entry2.insert(0, str(self.webui_guide_setting["cfg_scale"]))
            else: entry2.insert(0, "2.5")
            
            label_botton = customtkinter.CTkLabel(webui_guide_setting_window_left, font=my_font, text="다음 태그를 포함하는 프롬프트를 삭제합니다 (쉼표로 구분, 작가명 추천)", text_color="#FFFF97")
            label_botton.grid(row=8, column=0, padx=5, pady=5, sticky="n")
            rm_text = customtkinter.CTkEntry(webui_guide_setting_window_left, font=my_font, width=400)
            rm_text.grid(row=9, column=0, padx=5, pady=5, sticky="n")
            if self.webui_guide_setting and "rm_text" in self.webui_guide_setting: rm_text.insert(0, self.webui_guide_setting["rm_prompt"])

            sampler_label = customtkinter.CTkLabel(webui_guide_setting_window_left, text="Sampler (Euler A 권장):", font=my_font)
            sampler_label.grid(row=10, column=0, pady=5, padx=5, sticky="n")
            sampler_var = customtkinter.StringVar(value="k_dpm_3m_sde")
            sampler_button = customtkinter.CTkComboBox(webui_guide_setting_window_left, width=250,values=NAIA_utils.get_sampler_list(self.NAI_webui_address), variable=sampler_var, font=my_font)
            sampler_button.grid(row=11, column=0, pady=5, padx=5, sticky="n")
            if self.webui_guide_setting and self.webui_guide_setting["sampler"]: sampler_var.set(self.webui_guide_setting["sampler"])

            right_label1 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="Vibe Transfer: Information Exctract (0.01~1)")
            right_label1.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
            value1 = customtkinter.CTkEntry(webui_guide_setting_window_right, font=my_font, width=40)
            value1.grid(row=1, column=0, padx=5, pady=5, sticky="n")
            if self.webui_guide_setting and self.webui_guide_setting["vibe_ie"]: value1.insert(0, str(self.webui_guide_setting["vibe_ie"]))
            else: value1.insert(0, "1")

            right_label2 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="Vibe Transfer: Strength (0.01~1)")
            right_label2.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")
            value2 = customtkinter.CTkEntry(webui_guide_setting_window_right, font=my_font, width=40)
            value2.grid(row=3, column=0, padx=5, pady=5, sticky="n")
            if self.webui_guide_setting and self.webui_guide_setting["vibe_strength"]: value2.insert(0, str(self.webui_guide_setting["vibe_strength"]))
            else: value2.insert(0, "0.4")

            right_label3 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="Img2Img : Strength (0.5~0.99)")
            right_label3.grid(row=4, column=0, padx=5, pady=5, sticky="nsew")
            value3 = customtkinter.CTkEntry(webui_guide_setting_window_right, font=my_font, width=40)
            value3.grid(row=5, column=0, padx=5, pady=5, sticky="n")
            if self.webui_guide_setting and self.webui_guide_setting["i2i_strength"]: value3.insert(0, str(self.webui_guide_setting["i2i_strength"]))
            else: value3.insert(0, "0.7")

            #right_label4 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="이미지가 길쭉해지면 Strength를 높이세요", text_color="#FFFF97")
            #right_label4.grid(row=6, column=0, padx=5, pady=5, sticky="nsew")
            right_label4 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="UI에서의 가이드 이미지 크기 설정 (생성 속도와 무관)")
            right_label4.grid(row=7, column=0, padx=5, pady=5, sticky="nsew")

            image_size_var = customtkinter.StringVar(value="중간")
            image_size = customtkinter.CTkComboBox(webui_guide_setting_window_right, width=100,values=["작게", "중간", "크게"], variable=image_size_var, font=my_font)
            image_size.grid(row=8, column=0, pady=5, padx=5, sticky="n")
            if self.webui_guide_setting and "image_size" in self.webui_guide_setting: image_size_var.set(self.webui_guide_setting["image_size"])

            right_label6 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="WEBUI 생성 이미지의 해상도 설정 (생성 속도에 영향)")
            right_label6.grid(row=9, column=0, padx=5, pady=5, sticky="nsew")
            image_resolution_var = customtkinter.StringVar(value="1024 해상도")
            image_resolution = customtkinter.CTkComboBox(webui_guide_setting_window_right, width=100,values=["768 해상도", "1024 해상도"], variable=image_resolution_var, font=my_font)
            image_resolution.grid(row=10, column=0, pady=5, padx=5, sticky="n")
            if self.webui_guide_setting and "image_resolution" in self.webui_guide_setting: image_resolution_var.set(self.webui_guide_setting["image_resolution"])

            right_label5 = customtkinter.CTkLabel(webui_guide_setting_window_right, font=my_font, text="깨진 이미지 생성을 방지하기 위해 캐릭터 명을 지울까요?")
            right_label5.grid(row=11, column=0, padx=5, pady=5, sticky="nsew")
            rm_character = customtkinter.CTkCheckBox(webui_guide_setting_window_right, text="캐릭터명 제거", font=my_font)
            rm_character.grid(row=12, column=0, pady=5, padx=5, sticky="n")
            if self.webui_guide_setting and "rm_character" in self.webui_guide_setting: 
                if self.webui_guide_setting["rm_character"] == 1: rm_character.select()
                else: rm_character.deselect()

            save_webui_image = customtkinter.CTkCheckBox(webui_guide_setting_window_right, text="생성한 이미지를 저장합니다", variable=self.webui_guide_image_save, font=my_font)
            #save_webui_image.grid(row=13, column=0, pady=5, padx=5, sticky="n")
            #use_artist_name = customtkinter.CTkCheckBox(webui_guide_setting_window_right, text="선행 고정 프롬프트의 내용을 유지합니다", font=my_font, variable=self.webui_guide_maintain_artist)
            #use_artist_name.grid(row=14, column=0, pady=5, padx=5, sticky="n")

            text_hyperlink = customtkinter.CTkLabel(webui_guide_setting_window_right, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2")
            text_hyperlink.grid(row=15, column=0, padx=5, pady=5, sticky="nsew")
            text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/100744273"))

            apply_button = customtkinter.CTkButton(webui_guide_setting_window, font=my_font, text="해당 설정을 적용합니다", command=on_apply)
            apply_button.grid(row=1, column=0, columnspan=2, padx=5, pady=5, sticky="n")

            webui_guide_setting_window.protocol("WM_DELETE_WINDOW", on_close)
            webui_guide_setting_window.after(2000, lambda: webui_guide_setting_window.attributes('-topmost', False))

        if self.app_mode == "NAI":
            self.image_guide_frame.columnconfigure(0, weight=1)
            self.image_guide_frame.columnconfigure(1, weight=5)
            self.image_guide_frame.columnconfigure(2, weight=1)

            _temp_image = Image.open(basedir+'/icoico.ico')
            self.webui_guide_image = customtkinter.CTkLabel(self.image_guide_frame, text="", image=customtkinter.CTkImage(_temp_image, size=(368, 368)))
            self.webui_guide_image.grid(row=0, rowspan=4, column=0, columnspan=3, pady=5, sticky="nsew")
            self.guide_reroll = customtkinter.CTkButton(self.image_guide_frame, text="재생성", width=120, font=my_font, command=guide_reroll)
            self.guide_reroll.grid(row=4, column=1, pady=5, padx=(10, 0), sticky="w")
            self.guide_vibe = customtkinter.CTkCheckBox(self.image_guide_frame, text="Vibe", width=40, font=my_font)
            self.guide_vibe.grid(row=4, column=1, pady=5, padx=(140, 0), sticky="w")
            self.guide_i2i = customtkinter.CTkCheckBox(self.image_guide_frame, text="I2I", width=40, font=my_font)
            self.guide_i2i.grid(row=4, column=1, pady=5, padx=(220, 0), sticky="w")
            self.guide_setting = customtkinter.CTkButton(self.image_guide_frame, text="설정", fg_color="grey10", hover_color="grey", width=60, font=my_font, command=open_webui_guide_setting)
            self.guide_setting.grid(row=4, column=1, pady=5, padx=(0, 90), sticky="e")

            def _guide_send():
                if self.temp_guide_prompt and self.temp_guide_filename and self.temp_guide_seed:
                    self.temp_guide_prompt = self.temp_guide_prompt.replace(self.guide_generation_thread_contents['prefix']+", ","").replace(", "+self.guide_generation_thread_contents['postfix'], "")
                    set_image_to_queue(self.temp_guide_resized_image, self.temp_guide_prompt, str(self.temp_guide_seed), self.temp_guide_filename)
                    self.temp_guide_seed = None
                    self.temp_guide_prompt = None
                    self.temp_guide_filename = None

            self.guide_send_to_naia = customtkinter.CTkButton(self.image_guide_frame, text="  ➡️", font=my_font, text_color="white", fg_color="transparent", width=5, command=_guide_send)
            self.guide_send_to_naia.grid(row=4, column=1, pady=5, padx=(0, 10), sticky="e")
            """
            self.webui_guide_quality_var = customtkinter.IntVar()
            self.guide_lq = customtkinter.CTkRadioButton(self.image_guide_frame, text="LQ", variable= self.webui_guide_quality_var, value=0, font=large_font)
            self.guide_lq.grid(row=0, column=3, sticky="e")
            self.guide_nq = customtkinter.CTkRadioButton(self.image_guide_frame, text="NQ", variable= self.webui_guide_quality_var, value=1, font=large_font)
            self.guide_nq.grid(row=1, column=3, sticky="e")
            self.guide_hq = customtkinter.CTkRadioButton(self.image_guide_frame, text="HQ", variable= self.webui_guide_quality_var, value=2, font=large_font)
            self.guide_hq.grid(row=2, column=3, sticky="e")
            """

        self.ui_resize_window = None
        self.naid4_characters_frame_size_weight = 1

        def open_window_resize():
            if self.ui_resize_window is None:
                _open_window_resize()
            else:
                if self.ui_resize_window.state() == 'withdrawn':
                    self.ui_resize_window.deiconify()
                else:
                    self.ui_resize_window.lift()

        def _open_window_resize():
            def on_close():
                ui_resize_window.withdraw()

            def on_apply():
                self.config['SET_PROMPT_UI_SIZE'] = {
                    'MAIN_PROMPT': str(entry1.get().strip()),
                    'PREFIX_PROMPT': str(entry2.get().strip()),
                    'POSTFIX_PROMPT': str(entry3.get().strip()),
                    'NEGATIVE_PROMPT': str(entry4.get().strip()),
                    'AUTOHIDE_KEYWORD': str(entry5.get().strip()),
                    'CONDITIONAL_PROMPT': str(entry6.get().strip()),
                    'CONDITIONAL_NEGATIVE': str(entry7.get().strip())
                    }
                try: self.ui_size['prompt'] = int(self.config['SET_PROMPT_UI_SIZE']['MAIN_PROMPT'])
                except: self.ui_size['prompt'] = 200
                try: self.ui_size['prefix'] = int(self.config['SET_PROMPT_UI_SIZE']['PREFIX_PROMPT'])
                except: self.ui_size['prefix'] = 100
                try: self.ui_size['postfix'] = int(self.config['SET_PROMPT_UI_SIZE']['POSTFIX_PROMPT'])
                except: self.ui_size['postfix'] = 60
                try: self.ui_size['negative'] = int(self.config['SET_PROMPT_UI_SIZE']['NEGATIVE_PROMPT'])
                except: self.ui_size['negative'] = 100
                try: self.ui_size['autohide'] = int(self.config['SET_PROMPT_UI_SIZE']['AUTOHIDE_KEYWORD'])
                except: self.ui_size['autohide'] = 100
                try: self.ui_size['cond_prompt'] = int(self.config['SET_PROMPT_UI_SIZE']['CONDITIONAL_PROMPT'])
                except: self.ui_size['cond_prompt'] = 100
                try: self.ui_size['cond_negative'] = int(self.config['SET_PROMPT_UI_SIZE']['CONDITIONAL_NEGATIVE'])
                except: self.ui_size['cond_negative'] = 100
                with open('ui_config.ini', 'w') as configfile:
                    self.config.write(configfile)
                self.text_input.configure(height=self.ui_size['prompt'])
                self.fixed_prompt_input.configure(height=self.ui_size['prefix'])
                self.fixed_prompt_after_input.configure(height=self.ui_size['postfix'])
                self.negative_prompt_input.configure(height=self.ui_size['negative'])
                self.auto_hide_keyword_input.configure(height=self.ui_size['autohide'])
                self.conditional_prompt_input.configure(height=self.ui_size['cond_prompt'])
                self.conditional_negative_input.configure(height=self.ui_size['cond_negative'])

            ui_resize_window = customtkinter.CTkToplevel()
            self.ui_resize_window = ui_resize_window
            ui_resize_window.title("높이설정")
            ui_resize_window.attributes('-topmost', True)
            ui_resize_window.resizable(width=False, height=False)

            label1 = customtkinter.CTkLabel(ui_resize_window, text="        메인 프롬프트창 높이 : ",  font=my_font)
            label2 = customtkinter.CTkLabel(ui_resize_window, text="선행 고정 프롬프트창 높이 : ",  font=my_font)
            label3 = customtkinter.CTkLabel(ui_resize_window, text="후행 고정 프롬프트창 높이 : ",  font=my_font)
            label4 = customtkinter.CTkLabel(ui_resize_window, text=" 네거티브 프롬프트창 높이 : ",  font=my_font)
            label5 = customtkinter.CTkLabel(ui_resize_window, text=" 자동숨김 프롬프트창 높이 : ",  font=my_font)
            label6 = customtkinter.CTkLabel(ui_resize_window, text="    조건부 프롬프트창 높이 : ",  font=my_font)
            label7 = customtkinter.CTkLabel(ui_resize_window, text="    조건부 네거티브창 높이 : ",  font=my_font)
            entry1 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry2 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry3 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry4 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry5 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry6 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            entry7 = customtkinter.CTkEntry(ui_resize_window, font=my_font, width=40)
            pxlabel1 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel2 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel3 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel4 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel5 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel6 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)
            pxlabel7 = customtkinter.CTkLabel(ui_resize_window, text=" px ",  font=my_font)

            entry1.insert(0, self.ui_size['prompt'])
            entry2.insert(0, self.ui_size['prefix'])
            entry3.insert(0, self.ui_size['postfix'])
            entry4.insert(0, self.ui_size['negative'])
            entry5.insert(0, self.ui_size['autohide'])
            entry6.insert(0, self.ui_size['cond_prompt'])
            entry7.insert(0, self.ui_size['cond_negative'])

            label1.grid(row = 0, column = 0, padx=5, pady=5, sticky="e")
            entry1.grid(row = 0, column = 1, padx=5, pady=5, sticky="n")
            pxlabel1.grid(row = 0, column = 2, padx=5, pady=5, sticky="w")

            label2.grid(row = 1, column = 0, padx=5, pady=5, sticky="e")
            entry2.grid(row = 1, column = 1, padx=5, pady=5, sticky="n")
            pxlabel2.grid(row = 1, column = 2, padx=5, pady=5, sticky="w")

            label3.grid(row = 2, column = 0, padx=5, pady=5, sticky="e")
            entry3.grid(row = 2, column = 1, padx=5, pady=5, sticky="n")
            pxlabel3.grid(row = 2, column = 2, padx=5, pady=5, sticky="w")

            label4.grid(row = 3, column = 0, padx=5, pady=5, sticky="e")
            entry4.grid(row = 3, column = 1, padx=5, pady=5, sticky="n")
            pxlabel4.grid(row = 3, column = 2, padx=5, pady=5, sticky="w")

            label5.grid(row = 4, column = 0, padx=5, pady=5, sticky="e")
            entry5.grid(row = 4, column = 1, padx=5, pady=5, sticky="n")
            pxlabel5.grid(row = 4, column = 2, padx=5, pady=5, sticky="w")

            label6.grid(row = 5, column = 0, padx=5, pady=5, sticky="e")
            entry6.grid(row = 5, column = 1, padx=5, pady=5, sticky="n")
            pxlabel6.grid(row = 5, column = 2, padx=5, pady=5, sticky="w")

            label7.grid(row = 6, column = 0, padx=5, pady=5, sticky="e")
            entry7.grid(row = 6, column = 1, padx=5, pady=5, sticky="n")
            pxlabel7.grid(row = 6, column = 2, padx=5, pady=5, sticky="w")

            apply_button = customtkinter.CTkButton(ui_resize_window, text="적용",  font=my_font, command=on_apply)
            apply_button.grid(row = 7, column = 0, columnspan=3, padx=5, pady=5, sticky="n")

            ui_resize_window.protocol("WM_DELETE_WINDOW", on_close)
            #ui_resize_window.after(2000, lambda: ui_resize_window.attributes('-topmost', False))


        #텍스트 입력
        self.text_input_frame = customtkinter.CTkFrame(self.searched_prompt_frame)
        self.text_input_frame.grid(row=6, column=0, columnspan=3 , pady=2, sticky="nsew")
        self.text_input_label = customtkinter.CTkLabel(self.text_input_frame, text=" ---------------------- 프롬프트 ---------------------- ", font=large_font)
        self.text_input_label.grid(row = 0, sticky="n" )
        self.IntegratedAdvancedEditor = None

        def quick_preset_function(choice):
            if choice == "새 프리셋 추가 (+)":
                preset_window = customtkinter.CTkToplevel()
                preset_window.title("추가할 프리셋 이름을 입력해주세요")
                preset_window.geometry("400x130")
                preset_window.attributes('-topmost', True)

                preset_window.grid_columnconfigure(0, weight=1)
                preset_window.grid_columnconfigure(1, weight=1)

                name_entry = customtkinter.CTkEntry(preset_window, width=300, font=my_font)
                name_entry.grid(row=0, column=0, columnspan=2, padx=20, pady=5)
                
                preset_type = customtkinter.StringVar(value="현재 프리셋 복사")

                copy_radio = customtkinter.CTkRadioButton(
                    preset_window,
                    text="현재 프리셋 복사",
                    variable=preset_type,
                    value="현재 프리셋 복사",
                    font=my_font
                )
                empty_radio = customtkinter.CTkRadioButton(
                    preset_window,
                    text="빈 프리셋 생성",
                    variable=preset_type,
                    value="빈 프리셋 생성",
                    font=my_font
                )

                copy_radio.grid(row=1, column=0, padx=20, pady=5)
                empty_radio.grid(row=1, column=1, padx=20, pady=5)

                def create_preset():
                    preset_name = name_entry.get()
                    if not preset_name:
                        messagebox.showwarning("경고", "프리셋 이름을 입력해주세요.")
                        return
                        
                    # 금지된 문자 검사
                    forbidden_chars = r'[\\/:*?"<>|]'
                    if re.search(forbidden_chars, preset_name):
                        messagebox.showwarning("경고", r"프리셋 이름에 다음 문자를 사용할 수 없습니다: \ / : * ? \" < > |")
                        return
                        
                    base_path = 'quick_preset'
                    if self.app_mode == "NAI":
                        folder_path = base_path
                    else:
                        folder_path = os.path.join(base_path, 'webui')
                    
                    # 경로가 없으면 생성
                    try:
                        os.makedirs(folder_path, exist_ok=True)  # exist_ok=True를 사용하면 이미 존재하는 경우 에러가 발생하지 않음
                    except Exception as e:
                        messagebox.showerror("오류", f"폴더 생성 중 오류가 발생했습니다:\n{str(e)}")
                        return              
                    
                    # 프리셋 파일 경로
                    preset_path = os.path.join(folder_path, f"{preset_name}.json")
                    
                    # 파일이 이미 존재하는지 확인
                    if os.path.exists(preset_path):
                        messagebox.showwarning("경고", f"'{preset_name}' 프리셋이 이미 존재합니다.")
                        return
                        
                    # 프리셋 데이터 준비
                    if self.app_mode == "NAI":
                        preset_data = {
                            'prompt':app.text_input.get("0.0", "end-1c"),
                            'fix':app.fixed_prompt_input.get("0.0", "end-1c"),
                            'fix_after':app.fixed_prompt_after_input.get("0.0", "end-1c"),
                            'negative':app.negative_prompt_input.get("0.0", "end-1c"),
                            'cfg': app.cfg_scale_var.get(),
                            'dyn': app.dyn_button_var.get(),
                            'var': app.variety_var.get(),
                            'dec': app.decrsp_var.get(),
                            'smea': app.sema_button_var.get(),
                            'pgr': app.prompt_guidance_rescale_var.get(),
                            'sampler': app.sampler_var.get()
                        }
                        if self.character_frames:
                            try:
                                character_data = []
                                for frame_dict in self.character_frames:
                                    frame_data = {
                                        'textbox_content': frame_dict['textbox'].get("0.0", "end-1c"),
                                        'uc_content': frame_dict['uc'].get("0.0", "end-1c")
                                    }
                                    character_data.append(frame_data)
                                preset_data['character_frames'] = character_data
                            except:
                                preset_data['character_frames'] = []
                        prev_preset_path = os.path.join(folder_path, f"{self.last_preset}.json")
                        try:
                            with open(prev_preset_path, 'w', encoding='utf-8') as f:
                                json.dump(preset_data, f, ensure_ascii=False, indent=4)
                        except:
                            pass
                        if preset_type.get() != "현재 프리셋 복사":
                            preset_data = {
                                'prompt': "",
                                'fix': "",
                                'fix_after': "",
                                'negative': "lowres, {bad}, error, fewer, extra, missing, worst quality, jpeg artifacts, bad quality, watermark, unfinished, displeasing, chromatic aberration, signature, extra digits, artistic error, username, scan, [abstract]",
                                'cfg': "5.0",
                                'dyn': 1,
                                'var': 1,
                                'dec': 1,
                                'smea': 1,
                                'pgr': "0",
                                'sampler': "k_euler_ancestral + karras"
                            }
                            for frame_dict in self.character_frames:
                                frame_dict['frame'].destroy()
                            self.character_frames.clear()
                            add_callback = lambda: self.add_new_character(
                                self.naid4_characters_frame,
                                self.large_font,
                                self.v_large_font,
                                self.character_frames
                            )
                            self.add_new_character(
                                self.naid4_characters_frame,
                                self.large_font,
                                self.v_large_font,
                                self.character_frames
                            )
                            self.text_input.delete("0.0", "end")
                            self.text_input.insert("0.0", preset_data["prompt"])
                            self.fixed_prompt_input.delete("0.0", "end")
                            self.fixed_prompt_input.insert("0.0", preset_data["fix"])
                            self.fixed_prompt_after_input.delete("0.0", "end")
                            self.fixed_prompt_after_input.insert("0.0", preset_data["fix_after"])
                            self.negative_prompt_input.delete("0.0", "end")
                            self.negative_prompt_input.insert("0.0", preset_data["negative"])
                            self.cfg_scale_entry.delete(0, "end")
                            self.cfg_scale_entry.insert(0, str(preset_data["cfg"]))
                            self.cfg_scale_var.set(preset_data["cfg"])
                            if preset_data["smea"] == 1: self.sema_button.select() 
                            else: self.sema_button.deselect()
                            if preset_data["dyn"] == 1: self.dyn_button.select() 
                            else: self.dyn_button.deselect()
                            if preset_data["var"] == 1: self.variety_button.select() 
                            else: self.variety_button.deselect()
                            if preset_data["dec"] == 1: self.decrsp_button.select() 
                            else: self.decrsp_button.deselect()
                            self.prompt_guidance_rescale_entry.delete(0, "end")
                            self.prompt_guidance_rescale_entry.insert(0, str(preset_data["pgr"]))
                            self.prompt_guidance_rescale_var.set(preset_data["pgr"])
                            self.sampler_var.set(preset_data["sampler"])
                            self.sampler_button.set(preset_data["sampler"])
                    else:
                        preset_data = {
                            'prompt':app.text_input.get("0.0", "end-1c"),
                            'fix':app.fixed_prompt_input.get("0.0", "end-1c"),
                            'fix_after':app.fixed_prompt_after_input.get("0.0", "end-1c"),
                            'negative':app.negative_prompt_input.get("0.0", "end-1c"),
                            'cfg': app.cfg_scale_var.get(),
                            'step': app.prompt_guidance_rescale_var.get(),
                            'sampler': app.sampler_var.get(),
                            'scheduler' : self.current_scheduler.get()
                        }
                        prev_preset_path = os.path.join(folder_path, f"{self.last_preset}.json")
                        try:
                            with open(prev_preset_path, 'w', encoding='utf-8') as f:
                                json.dump(preset_data, f, ensure_ascii=False, indent=4)
                        except:
                            pass
                        if preset_type.get() != "현재 프리셋 복사":
                            preset_data = {
                                'prompt': "",
                                'fix': "",
                                'fix_after': "",
                                'negative': "",
                                'cfg': "6.0",
                                'step': "28",
                                'sampler': "Euler",
                                'scheduler' : "Automatic"
                            }                                                   
                            self.text_input.delete("0.0", "end")
                            self.text_input.insert("0.0", preset_data["prompt"])
                            self.fixed_prompt_input.delete("0.0", "end")
                            self.fixed_prompt_input.insert("0.0", preset_data["fix"])
                            self.fixed_prompt_after_input.delete("0.0", "end")
                            self.fixed_prompt_after_input.insert("0.0", preset_data["fix_after"])
                            self.negative_prompt_input.delete("0.0", "end")
                            self.negative_prompt_input.insert("0.0", preset_data["negative"])
                            self.cfg_scale_entry.delete(0, "end")
                            self.cfg_scale_entry.insert(0, str(preset_data["cfg"]))
                            self.cfg_scale_var.set(preset_data["cfg"])
                            self.prompt_guidance_rescale_entry.delete(0, "end")
                            self.prompt_guidance_rescale_entry.insert(0, str(preset_data["step"]))
                            self.prompt_guidance_rescale_var.set(preset_data["step"])
                            self.sampler_var.set(preset_data["sampler"])
                            self.sampler_button.set(preset_data["sampler"])
                            self.current_scheduler.set(preset_data["scheduler"])
                    try:
                        with open(preset_path, 'w', encoding='utf-8') as f:
                            json.dump(preset_data, f, ensure_ascii=False, indent=4)
                        # 프리셋 리스트에 새 프리셋 추가
                        self.quick_preset_list.insert(-1, preset_name)  # 마지막 항목("새 프리셋 추가 (+)") 앞에 삽입
                        self.quick_preset.configure(values=self.quick_preset_list)
                        self.current_preset.set(preset_name)
                        self.last_preset = preset_name
                        preset_window.destroy()
                        
                    except Exception as e:
                        messagebox.showerror("오류", f"프리셋 저장 중 오류가 발생했습니다:\n{str(e)}")
                
                # 버튼 생성
                create_button = customtkinter.CTkButton(
                    preset_window,
                    text="생성",
                    command=create_preset,
                    font=my_font
                )
                cancel_button = customtkinter.CTkButton(
                    preset_window,
                    text="취소",
                    command=preset_window.destroy,
                    font=my_font,
                    fg_color="grey",
                    hover_color="grey10"
                )
                
                # 버튼 배치
                create_button.grid(row=2, column=0, padx=20, pady=5)
                cancel_button.grid(row=2, column=1, padx=20, pady=5)
            else:
                base_path = 'quick_preset'
                if self.app_mode == "NAI":
                    folder_path = base_path
                else:
                    folder_path = os.path.join(base_path, 'webui')
                open_preset_path = os.path.join(folder_path, f"{choice}.json")
                if self.app_mode == "NAI":
                    preset_data = {
                        'prompt':app.text_input.get("0.0", "end-1c"),
                        'fix':app.fixed_prompt_input.get("0.0", "end-1c"),
                        'fix_after':app.fixed_prompt_after_input.get("0.0", "end-1c"),
                        'negative':app.negative_prompt_input.get("0.0", "end-1c"),
                        'cfg': app.cfg_scale_var.get(),
                        'dyn': app.dyn_button_var.get(),
                        'var': app.variety_var.get(),
                        'dec': app.decrsp_var.get(),
                        'smea': app.sema_button_var.get(),
                        'pgr': app.prompt_guidance_rescale_var.get(),
                        'sampler': app.sampler_var.get()
                    }
                    if self.character_frames:
                        try:
                            character_data = []
                            for frame_dict in self.character_frames:
                                frame_data = {
                                    'textbox_content': frame_dict['textbox'].get("0.0", "end-1c"),
                                    'uc_content': frame_dict['uc'].get("0.0", "end-1c")
                                }
                                character_data.append(frame_data)
                            preset_data['character_frames'] = character_data
                        except:
                            preset_data['character_frames'] = []
                    prev_preset_path = os.path.join(folder_path, f"{self.last_preset}.json")
                    if os.path.exists(prev_preset_path):
                        try:
                            with open(prev_preset_path, 'w', encoding='utf-8') as f:
                                json.dump(preset_data, f, ensure_ascii=False, indent=4)
                        except:
                            pass
                else:
                    preset_data = {
                        'prompt':app.text_input.get("0.0", "end-1c"),
                        'fix':app.fixed_prompt_input.get("0.0", "end-1c"),
                        'fix_after':app.fixed_prompt_after_input.get("0.0", "end-1c"),
                        'negative':app.negative_prompt_input.get("0.0", "end-1c"),
                        'cfg': app.cfg_scale_var.get(),
                        'step': app.prompt_guidance_rescale_var.get(),
                        'sampler': app.sampler_var.get(),
                        'scheduler' : self.current_scheduler.get()
                    }
                    prev_preset_path = os.path.join(folder_path, f"{self.last_preset}.json")
                    if os.path.exists(prev_preset_path):
                        try:
                            with open(prev_preset_path, 'w', encoding='utf-8') as f:
                                json.dump(preset_data, f, ensure_ascii=False, indent=4)
                        except:
                            pass
                try:
                    # JSON 파일 읽기
                    with open(open_preset_path, 'r', encoding='utf-8') as f:
                        preset_data = json.load(f)
                    
                    # NAI 모드일 때
                    if self.app_mode == "NAI":
                        # 기본 프롬프트들 적용
                        self.text_input.delete("0.0", "end")
                        self.text_input.insert("0.0", preset_data.get("prompt", ""))
                        self.fixed_prompt_input.delete("0.0", "end")
                        self.fixed_prompt_input.insert("0.0", preset_data.get("fix", ""))
                        self.fixed_prompt_after_input.delete("0.0", "end")
                        self.fixed_prompt_after_input.insert("0.0", preset_data.get("fix_after", ""))
                        self.negative_prompt_input.delete("0.0", "end")
                        self.negative_prompt_input.insert("0.0", preset_data.get("negative", ""))
                        
                        # 설정값들 적용
                        self.cfg_scale_entry.delete(0, "end")
                        self.cfg_scale_entry.insert(0, str(preset_data.get("cfg", "5.0")))
                        self.cfg_scale_var.set(preset_data.get("cfg", "5.0"))
                        
                        # 체크박스 상태 적용
                        if preset_data.get("smea", 1) == 1: self.sema_button.select()
                        else: self.sema_button.deselect()
                        if preset_data.get("dyn", 1) == 1: self.dyn_button.select()
                        else: self.dyn_button.deselect()
                        if preset_data.get("var", 1) == 1: self.variety_button.select()
                        else: self.variety_button.deselect()
                        if preset_data.get("dec", 1) == 1: self.decrsp_button.select()
                        else: self.decrsp_button.deselect()
                        
                        # guidance와 sampler 설정
                        self.prompt_guidance_rescale_entry.delete(0, "end")
                        self.prompt_guidance_rescale_entry.insert(0, str(preset_data.get("pgr", "0")))
                        self.prompt_guidance_rescale_var.set(preset_data.get("pgr", "0"))
                        self.sampler_var.set(preset_data.get("sampler", "k_euler_ancestral + karras"))
                        self.sampler_button.set(preset_data.get("sampler", "k_euler_ancestral + karras"))
                        
                        # character frames가 있다면 적용
                        if 'character_frames' in preset_data:
                            # 기존 프레임 제거
                            for frame_dict in self.character_frames:
                                frame_dict['frame'].destroy()
                            self.character_frames.clear()
                            
                            # 저장된 프레임 복원
                            for frame_data in preset_data['character_frames']:
                                new_frame_dict = self.create_character_frame(
                                    self.naid4_characters_frame,
                                    len(self.character_frames) + 1,
                                    self.large_font,
                                    self.v_large_font,
                                    self.character_frames,
                                    lambda p=self.naid4_characters_frame, lf=self.large_font, vf=self.v_large_font, fl=self.character_frames: self.add_new_character(p, lf, vf, fl),
                                    self.remove_character
                                )
                                
                                new_frame_dict['textbox'].delete("0.0", "end")
                                new_frame_dict['textbox'].insert("0.0", frame_data.get('textbox_content', ""))
                                new_frame_dict['uc'].delete("0.0", "end")
                                new_frame_dict['uc'].insert("0.0", frame_data.get('uc_content', ""))
                                
                                new_frame_dict['frame'].grid(row=len(self.character_frames) + 2, column=0, columnspan=3, sticky="nsew")
                                self.character_frames.append(new_frame_dict)
                    else:
                        # 기본 프롬프트들 적용
                        self.text_input.delete("0.0", "end")
                        self.text_input.insert("0.0", preset_data.get("prompt", ""))
                        self.fixed_prompt_input.delete("0.0", "end")
                        self.fixed_prompt_input.insert("0.0", preset_data.get("fix", ""))
                        self.fixed_prompt_after_input.delete("0.0", "end")
                        self.fixed_prompt_after_input.insert("0.0", preset_data.get("fix_after", ""))
                        self.negative_prompt_input.delete("0.0", "end")
                        self.negative_prompt_input.insert("0.0", preset_data.get("negative", ""))
                        
                        # 설정값들 적용
                        self.cfg_scale_entry.delete(0, "end")
                        self.cfg_scale_entry.insert(0, str(preset_data.get("cfg", "6.0")))
                        self.cfg_scale_var.set(preset_data.get("cfg", "6.0"))
                        
                        # step과 sampler 설정
                        self.prompt_guidance_rescale_entry.delete(0, "end")
                        self.prompt_guidance_rescale_entry.insert(0, str(preset_data.get("step", "28")))
                        self.prompt_guidance_rescale_var.set(preset_data.get("step", "28"))
                        self.sampler_var.set(preset_data.get("sampler", "Euler"))
                        self.sampler_button.set(preset_data.get("sampler", "Euler"))
                        self.current_scheduler.set(preset_data.get("scheduler", "Automatic"))
                        
                    self.last_preset = choice
                    
                except Exception as e:
                    print(f"프리셋 로드 중 오류 발생: {e}")
            

        self.quick_preset_list = ["기본 설정", "새 프리셋 추가 (+)"]
        self.current_preset = customtkinter.StringVar(value="기본 설정")
        self.quick_preset = customtkinter.CTkComboBox(self.searched_prompt_frame, values=self.quick_preset_list, variable=self.current_preset, font=my_font, width=200, command=quick_preset_function)
        self.quick_preset.grid(row=5, column=1, columnspan=2, padx=5, pady=2, sticky="w")
        self.quick_preset_label = customtkinter.CTkLabel(self.searched_prompt_frame, text="퀵 프리셋 : ",  font=my_font)
        self.quick_preset_label.grid(row=5, column=0, padx=5, pady=2, sticky="nsew")
        self.last_preset = self.current_preset.get()

        def update_quick_preset_list():
            base_path = 'quick_preset'
            if self.app_mode == "NAI":
                folder_path = base_path
            else:
                folder_path = os.path.join(base_path, 'webui')
            try:
                if not os.path.exists(folder_path):
                    os.makedirs(folder_path)
                json_files = [f for f in os.listdir(folder_path) if f.endswith('.json')]
                preset_names = [os.path.splitext(f)[0] for f in json_files]
                if '기본 설정' in preset_names: preset_names.remove('기본 설정')
                if preset_names:
                    self.quick_preset_list[1:1] = sorted(preset_names)
                    self.quick_preset.configure(values=self.quick_preset_list)
            except Exception as e:
                print(f"프리셋 리스트 업데이트 중 오류 발생: {e}")
                self.quick_preset_list = ["기본 설정", "새 프리셋 추가 (+)"]
        self.update_quick_preset_list = update_quick_preset_list
        

        def open_cheatsheet():
            if not os.path.exists(os.path.join("cheatsheet", "origin")):
                os.makedirs(os.path.join("cheatsheet", "origin"))
            _link = os.path.join("cheatsheet", "origin")
            if self.IntegratedAdvancedEditor is None:
                self.IntegratedAdvancedEditor = IntegratedAdvancedEditor(self, _link)
            else:
                if self.IntegratedAdvancedEditor.state() == 'withdrawn':
                    self.IntegratedAdvancedEditor.deiconify()
                else:
                    self.IntegratedAdvancedEditor.search_entry.focus()

        self.vibe_import = customtkinter.CTkButton(self.text_input_frame, font=my_font, width=45, height=24, text="사용자 사전", fg_color="grey10", hover_color="grey", command=open_cheatsheet)
        self.vibe_import.grid(row = 0, column=0, sticky="e")
        self.ui_setup = customtkinter.CTkButton(self.text_input_frame, font=my_font, width=30, height=24, text="UI 조정", fg_color="#2B2B2B", hover_color="grey10", text_color="grey",command=open_window_resize)
        self.ui_setup.grid(row = 0, column=0, sticky="w")
        self.text_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['prompt'], font=v_large_font, undo=True)
        self.text_input.grid(row=1, column=0, pady=5, sticky="nsew")
        self.text_input.bind("<Return>", on_enter_pressed)
        self.text_input.bind("<Tab>", on_tab_pressed)
        self.text_input.bind("<FocusOut>", highlight_text)
        self.text_input.tag_config("highlight", foreground="#FFFF97")
        self.text_input.tag_bind("highlight_seq", "<Button-1>", seq_click_callback)
        self.current_popped_row = None
        self.generated_popped_row = None
        self.generated_popped_row_freezed = None
        self.finish_series_gen_request = False
        self.dtg_flag = False
        self.dtg_event = None
        self.st_clothes = []
        self.st_background = []
        self.fts1 = ""
        self.generated_prompt_set = {}

        def get_random_preset():
            key = random.choice(list(self.random_preset.keys()))
            value = self.random_preset[key]
            fix = value["fix"]
            fix_after = value["fix_after"]
            negative = value["negative"]
            if len(negative) > 2:
                self.negative_prompt_input.delete("0.0", "end")
                self.negative_prompt_input.insert("0.0", negative)
            if len(fix) > 2:
                self.fixed_prompt_input.delete("0.0", "end")
                self.fixed_prompt_input.insert("0.0", self.preset_randomizer_var.get()+", "+fix if len(self.preset_randomizer_var.get())>2 else fix)
            if len(fix_after) > 2:
                self.fixed_prompt_after_input.delete("0.0", "end")
                self.fixed_prompt_after_input.insert("0.0", fix_after)
            if "cfg" in value:
                self.cfg_scale_var.set(str(value["cfg"]))
            if "pgr" in value:
                self.prompt_guidance_rescale_var.set(str(value["pgr"]))
            if "smea" in value and value["smea"] == 1:
                self.sema_button.select()
            elif "smea" in value and value["smea"] == 0:
                self.sema_button.deselect()

        self.general_prompt = ""
        self._evinpaint_flag = False
        self.event_df = None
        self.event_df_parent = []
        self.event_already_run = []
        self.wildcard_current_dict = {}
        self.fixed_prompt_result_for_artist_check = ""

        def random_function(edf = None):
            self.fts1 = ""
            self.generated_prompt_set = {}
            self.event_turbo3_already_run = False
            if self.webui_dtg_var.get() == 1:
                self.random_function_button.configure(state="disabled")
            if self.wildacrd_standalone.get() == 1:
                instant_row = {
                    'id': 80000000,
                    'copyright': None,
                    'character': None,
                    'artist': None,
                    'general': '*(wildcard standalone)' if (self.webui_dtg_var.get() == 0) else "",
                    'rating': 'n'
                }
                edf = pd.Series(instant_row)
            elif self.turbo_button.get() == 1 and self.turbo_mode == 3 and not self.prior_queue:
                if type(self.event_df) == type(None) or type(app.event_df_parent) == type(None):
                    self.event_df = pd.read_parquet(os.path.join(basedir, 'NAIA_event_dataset.parquet')) #.str.contains(keyword, na=False)
                    self.event_df_parent  = self.event_df[self.event_df["has_children"]]
                    self.event_df_parent = NAIA_search.search(self.event_df_parent, self.search_label_entry.get(), self.exclude_label_entry.get())
                    if type(app.event_df_parent) == type(None):
                        app.image_label_report.configure(state="normal")
                        app.image_label_report.delete("0.0", "end")
                        app.image_label_report.insert("0.0", f"매칭되는 이벤트가 없습니다. 다시 검색해주세요.")
                        app.image_label_report.configure(text_color="#FFFF97")
                        app.image_label_report.configure(state="disabled")
                        return
                    self.event_df_parent = self.event_df_parent['id'].tolist()
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", f"캐싱된 이벤트 수 : {len(self.event_df_parent)} 입니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                if len(self.event_df_parent) > 0:
                    self.event_current = {}
                    if type(edf) == type(None): random_parent_id = random.choice(self.event_df_parent)
                    else:
                        random_parent_id = edf["id"].iloc[0]
                        edf = None
                    ev_id = int(random_parent_id)
                    ids = self.event_df[self.event_df['parent_id'] == random_parent_id]['id'].tolist()
                    ids.insert(0, random_parent_id)
                    idf = self.event_df[self.event_df['id'].isin(ids)]
                    idf_len = len(idf)
                    if self.event_viewer_checkbox.get():  
                        for widget in self.event_image_view.winfo_children():
                            widget.destroy()
                        event_file_path = os.path.join('t3_event', str(ev_id))
                        if os.path.exists(event_file_path):
                            try:
                                with open(event_file_path, 'r', encoding='utf-8') as f:
                                    ev_list = json.load(f)
                            except FileNotFoundError: ev_list = {}
                            except json.JSONDecodeError: ev_list = {}
                            if ev_list:
                                for key in sorted(ev_list.keys()):
                                    if key == "text": continue
                                    value = ev_list[key]
                                    image_stream = io.BytesIO(base64.b64decode(value))
                                    reloaded_image = Image.open(image_stream)
                                    _label1 = customtkinter.CTkLabel(self.event_image_view, text=f"[{key}]", font=my_font, width=128)
                                    _label1.grid(row=int(key)*2, column=1, padx=5, sticky="n")
                                    _label2 = customtkinter.CTkLabel(self.event_image_view, text="", image=customtkinter.CTkImage(reloaded_image, size=(128,128)), width=128)
                                    _label2.grid(row=int(key)*2+1, column=1, padx=5, sticky="n")
                        if(self.event_viewer_textbox):
                            self.event_viewer_textbox.delete("0.0", "end")
                            self.event_viewer_textbox.insert("0.0", "parent:"+str(random_parent_id)+"\n\n", "hl")
                            self.event_viewer_textbox.insert("end", "event length : "+str(idf_len)+"\n")
                    glist = []
                    for index, row in enumerate(idf.iterrows()):
                        row_info = row[1]
                        _tokens = int(row_info["tokens"])
                        _general = row_info["general"]
                        glist.append(_general+"\n\n")
                        if index == 0:
                            rrw, rrh = find_max_resolution(int(row_info["image_width"]), int(row_info["image_height"]), 1048576)
                            if self.event_viewer_checkbox.get():                            
                                self.event_viewer_textbox.insert("end", "parent score : "+str(row_info["score"])+"\n")
                                self.event_viewer_textbox.insert("end", "recommend resolution : "+str(rrw)+ " x " + str(rrh) + "\n\n")
                                self.event_viewer_textbox.insert("end", f"start prompt [0] : {_tokens} tokens \n", "hl2")
                                self.event_viewer_textbox.insert("end", _general +"\n\n")
                            previous_prompt = row_info["general"].split(', ')
                        else:
                            if self.event_viewer_checkbox.get(): self.event_viewer_textbox.insert("end", f"event step [{index}] : {_tokens} tokens\n", "hl2")
                            current_prompt = row_info["general"].split(', ')
                            difference1 = [k for k in current_prompt if k not in previous_prompt]
                            diff1 = ', '.join(difference1)
                            difference2 = [k for k in previous_prompt if k not in current_prompt]
                            diff2 = ', '.join(difference2)
                            self.event_current[index] = {
                                "difference" : len(difference1) + len(difference2),
                                "add" : difference1.copy(),
                                "rem" : difference2.copy()
                            }
                            previous_prompt = current_prompt
                            if self.event_viewer_checkbox.get():   
                                self.event_viewer_textbox.insert("end", f"step difference ({len(difference1) + len(difference2)}) : \n")
                                self.event_viewer_textbox.insert("end", f"      add ({len(difference1)}) : {diff1} \n", "hl")
                                self.event_viewer_textbox.insert("end", f"      rem ({len(difference2)}) : {diff2} \n\n", "hl2")
                        insert_pq(row[1])
                    if self.event_viewer_checkbox.get():   
                        self.event_viewer_textbox.insert("end", "\n\n")
                        for i, line in enumerate(glist):
                            self.event_viewer_textbox.insert("end", f"step {i+1} \n" + line)
                        self.event_current["text"] = self.event_viewer_textbox.get("0.0", "end")
                    self.wildcard_preopen_repeat = idf_len + 1
                    self.wildcard_preopen_repeat_current = self.wildcard_preopen_repeat
                    if self.seed_fix_button.get() == 1 and self.random_resolution_button.get() == 0:
                        self.seed_entry.delete(0, 'end')
                        try: self.seed_entry.insert(0, random.randint(0,2**32 - 1))
                        except: pass
                    if self.random_resolution_button.get() == 0:
                        if self.event_activate_resolution.get() == 1:
                            self.resolution_button.set(str(rrw)+ " x " + str(rrh))
                        else:
                            resolutions = self.resolutions
                            random_resolution = random.choice(resolutions)
                            self.resolution_button.set(random_resolution)
            if self.set_vibe_wildcard:
                clear_all_vibe_frames()
                self.set_vibe_wildcard = False
            if(self.random_function_pressed) == False:
                self.random_function_pressed = True
                self.random_function_button.configure(state="disabled")
                if type(edf) == type(None):
                    if self.toggle_prompt_fix.get()==0 and type(self.cached_rows) == type(None):
                        # self.text_input.delete("0.0", "end")
                        # self.text_input.insert("0.0", "먼저 키워드 검색을 해 주세요.")
                        # self.random_function_button.configure(state="normal")
                        # self.random_function_pressed = False
                        # return
                        df = pd.read_parquet(os.path.join(basedir, 'NAIA_event_dataset.parquet'))
                        df = df[df["rating"] == "s"]
                        df = df[df["score"] > 150]
                        df = NAIA_search.search(df, "1girl", "mature female, futanari, furry")
                        df['artist'] = df['artist'].apply(lambda x: random.choice(NAIA_utils.rd_artist))
                        self.cached_rows = df.copy()
                        update_labels()
                    if self.toggle_prompt_fix.get()==1 and type(self.cached_rows) == type(None):
                        self.random_function_pressed = False
                        return
                    elif self.toggle_prompt_fix.get()==0 and self.cached_rows.empty:
                        if (self.automation_button.get() == 0):
                            self.text_input.delete("0.0", "end")
                            self.text_input.insert("0.0", "먼저 키워드 검색을 해 주세요.")
                            self.random_function_button.configure(state="normal")
                            self.random_function_pressed = False
                            return
                        elif type(self.freezed_cached_rows) != type(None):
                            self.text_input.delete("0.0", "end")
                            self.text_input.insert("0.0", "기존 프롬프트를 복원합니다.")
                            self.cached_rows = self.freezed_cached_rows.copy()
                            time.sleep(1)
                            self.random_function_button.configure(state="normal")
                            self.random_function_pressed = False
                            app.after(0, random_function)
                            return
                        else:
                            self.text_input.delete("0.0", "end")
                            self.text_input.insert("0.0", "재검색을 수행합니다.")
                            self.prompt_search(update_labels, perform_search, depth_search)
                            while(self.cached_rows.empty):
                                time.sleep(1)
                            self.random_function_button.configure(state="normal")
                            self.random_function_pressed = False
                            app.after(0, random_function)
                            return
                if self.toggle_prompt_fix.get():
                    self.random_function_pressed = False
                    return
                else:
                    if self.random_artist_button.get() == 1:
                        try:
                            if self.random_artist_prefix.get() == "artist:":
                                random_artist_name = "artist:"+ random.choice(self.random_artist)
                            elif self.random_artist_prefix.get() == "(artist)":
                                random_artist_name = random.choice(self.random_artist)+" (artist)"
                            else:
                                random_artist_name = random.choice(self.random_artist)
                        except:
                            random_artist_name = ""
                        magic_word = {
                            "random_artist":True,
                            "random_artist_name": random_artist_name
                        }
                    else:
                        magic_word = {
                            "random_artist":False
                        }
                    if self.resopnsive_prompt.get() == 1:
                        magic_word["resopnsive"] = True
                    if self.eye_catch.get() == 1:
                        magic_word["eye_catch"] = True
                    if self.compression_button.get() == 1:
                        magic_word["prompt_compress"] = True
                    if self.frequency_limit_button.get() == 1:
                        _value = self.frequency_limit_var.get()
                        try: _value = int(_value)
                        except: _value = 200
                        magic_word["frequency_limit"] = _value
                    if self.cond_prompt_button_var.get() == 1:
                        magic_word["cond"] = self.conditional_prompt_input.get("0.0", "end-1c") if len(self.conditional_prompt_input.get("0.0", "end-1c")) > 4 else None
                    if self.prior_queue:
                        if "fix_seed" in self.event_option and self.event_option["fix_seed"]:
                            if self.wildcard_preopen_repeat_current in self.event_current and self.event_option["fix_seed_trhresold"] > self.event_current[self.wildcard_preopen_repeat_current]['difference']:
                                self.seed_fix_button.select()
                            else:
                                self.seed_fix_button.deselect()
                            self.event_turbo3_already_run = False
                        popped_row = self.prior_queue.pop(0)
                        self.current_popped_row = copy.deepcopy(popped_row)
                        if self.registration_flag and not self.prior_queue:
                            self.prior_queue = [k for k in self.registration_queue]
                        if self.prior_queue:
                            self.cached_prompt_label.configure(text = "남은 우선예약 큐 : "+str(len(self.prior_queue)), text_color="#ED7D31")
                        else:
                            self.cached_prompt_label.configure(text = "남은 프롬프트 행 : "+str(len(self.cached_rows)), text_color="#F2FBFF")
                            if self.series_generation: 
                                self.finish_series_gen_request = True
                        if isinstance(self.current_popped_row, pd.Series) and 'wcfix' in self.current_popped_row:
                            self.wildcard_preopen_repeat = self.current_popped_row.loc['wcfix']
                            self.wildcard_preopen_repeat_current = self.wildcard_preopen_repeat
                            self.series_generation = []
                    elif self.logic_activation.get():
                        if self.wildcard_preopen_repeat_current == self.wildcard_preopen_repeat:
                            current = '0'
                        else:
                            current = str(self.wildcard_preopen_repeat_current)
                        if "reopen" in self.storyteller[current]['rating']:
                            popped_row = self.current_popped_row.copy()
                            if "f.seed" in self.storyteller[current]['rating']:
                                try:
                                    _seed = self.image_queue[-1][2]
                                    popped_row['general'] += f', seed:{_seed}'
                                except: pass
                        else:
                            if current != '0' and self.storyteller[current]['indiv']['isEnabled'] and 'depth_search' in self.storyteller[current]['indiv'] and self.storyteller[current]['indiv']['toggle_depth_search'] and len(self.storyteller[current]['indiv']['depth_search']) > 12:
                                _logic = self.storyteller[current]['indiv']['depth_search'].split('\n')
                                for line in _logic:
                                    _result = NAIA_random_function_core.conditional_search(self.general_prompt, line)
                                    if _result:
                                        exclude_start = line.rfind("exclude:")
                                        if exclude_start != -1:
                                            exclude = line[exclude_start + len("exclude:"):].strip()
                                            line = line[:exclude_start].strip()
                                        else:
                                            exclude = ''
                                        include_start = line.find("include:")
                                        if include_start != -1:
                                            include = line[include_start + len("include:"):].strip()
                                        else:
                                            include = ''
                                        if include != '' or exclude != '':
                                            instant_df = NAIA_search.search(self.storyteller_df[str(current)], include, exclude)
                                        try:
                                            random_index = np.random.choice(instant_df.index)
                                            popped_row = instant_df.loc[random_index]
                                            self.current_popped_row = copy.deepcopy(popped_row)
                                            break
                                        except:
                                            continue
                                    if line == _logic[-1]:
                                        random_index = np.random.choice(self.storyteller_df[current].index)
                                        popped_row = self.storyteller_df[current].loc[random_index]
                                        self.current_popped_row = copy.deepcopy(popped_row)
                                        self.image_label_report.configure(state="normal")
                                        self.image_label_report.delete("0.0", "end")
                                        self.image_label_report.insert("0.0", "<UserAttention> 조건부 재검색 실패 / 랜덤 프롬프트로 진행됩니다.")
                                        self.image_label_report.configure(text_color="#FFFF97")
                                        self.image_label_report.configure(state="disabled")
                            else:
                                random_index = np.random.choice(self.storyteller_df[current].index)
                                popped_row = self.storyteller_df[current].loc[random_index]
                                self.current_popped_row = copy.deepcopy(popped_row)
                    elif type(edf) == type(None):
                        random_index = np.random.choice(self.cached_rows.index)
                        popped_row = self.cached_rows.loc[random_index]
                        try:
                            if popped_row['id'] > 20000000:
                                general_str = popped_row['general']
                                if general_str and isinstance(general_str, str):  # 문자열이고 비어있지 않은지 확인
                                    values = general_str.split(', ')
                                    # 필터링된 새 리스트 생성
                                    filtered_values = [
                                        v for v in values 
                                        if v not in dan_character_dict 
                                        and v not in artist_dict 
                                        and "(" not in v
                                    ]
                                    popped_row['general'] = ', '.join(filtered_values)
                        except Exception as e:
                            pass
                        self.current_popped_row = copy.deepcopy(popped_row)
                        self.cached_rows.drop(random_index, inplace=True)
                        self.cached_prompt_label.configure(text = "남은 프롬프트 행 : "+str(len(self.cached_rows)), text_color="#F2FBFF")
                    else:
                        popped_row = edf.copy()
                        try:
                            if popped_row['id'] > 20000000:
                                general_str = popped_row['general']
                                if general_str and isinstance(general_str, str):  # 문자열이고 비어있지 않은지 확인
                                    values = general_str.split(', ')
                                    # 필터링된 새 리스트 생성
                                    filtered_values = [
                                        v for v in values 
                                        if v not in dan_character_dict 
                                        and v not in artist_dict 
                                        and "(" not in v
                                    ]
                                    popped_row['general'] = ', '.join(filtered_values)
                        except Exception as e:
                            pass
                        self.current_popped_row = copy.deepcopy(popped_row)
                    #조건 추가 부분
                    if self.rm_character_name_var.get() == 1: rmc = ", *(remove character name)"
                    else: rmc=""
                    if self.conditional_prompt_prefix.get() == 1: magic_word["cpp"] = True
                    if(self.toggle_wildcard_preopen.get()==1):
                        if(self.wildcard_preopen_repeat_current >= self.wildcard_preopen_repeat):
                            if self.preset_randomizer_button.get() ==1: 
                                try: get_random_preset()
                                except: pass
                            if self.turbo_mode == 3 and self.turbo_button.get() == 1 and self.reference_list:
                                self.reference_list = []
                                self.reference_list_ie = []
                                self.reference_list_irs = []
                            self.wildcard_preopen_repeat_current = 0
                            self.wildcard_current_dict = {}
                            self.nai4_character_list = []
                            self.nai4_character_uc_list = []
                            #와일드카드 개봉 구현 
                            temp_fixed = self.fixed_prompt_input.get("0.0", "end")
                            temp_fixed = NAIA_random_function_core.process_fix_prompt(temp_fixed)
                            global_temp = []
                            temp_fixed_after = self.fixed_prompt_after_input.get("0.0", "end")
                            temp_fixed_after = NAIA_random_function_core.process_fix_prompt(temp_fixed_after)
                            global_temp_after = []
                            # 선행고정 프롬프트 영역 처리
                            if '<' in self.fixed_prompt_input.get("0.0", "end") or '__' in self.fixed_prompt_input.get("0.0", "end"):
                                wildcard_present = True
                                itc = 0
                                while (wildcard_present and itc < 10):
                                    if not isinstance(temp_fixed, list): 
                                        temp_fixed = NAIA_random_function_core.process_fix_prompt(temp_fixed)
                                    elif any(', ' in item for item in temp_fixed):
                                        temp_fixed_str = ', '.join(temp_fixed)
                                        temp_fixed = temp_fixed_str.split(', ')
                                        temp_fixed = NAIA_random_function_core.process_fix_prompt(temp_fixed)
                                        temp_fixed = [k.strip() for k in temp_fixed]
                                    wildcard_present = False
                                    #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                    for i, keyword in enumerate(temp_fixed):
                                        if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                            wildcard_present = True
                                            vbar_check = keyword[1:-1]
                                            if '|' in vbar_check:
                                                choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                choice_dic = {}
                                                for choice in choices:
                                                    match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                    if match:
                                                        value, keyword = float(match.group(1)), match.group(2).strip()
                                                    else:
                                                        value, keyword = 1, choice.strip()
                                                    choice_dic[keyword] = value
                                                keywords = list(choice_dic.keys())
                                                weights = list(choice_dic.values())
                                                selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                temp_fixed[i] = selected_instant_wildcard

                                    #### 단계 2 : 글로벌 와일드카드 처리 ###
                                    i = 0
                                    while i < len(temp_fixed):
                                        keyword = temp_fixed[i]
                                        if "<" in keyword and not '<lora:' in keyword and ">" in keyword and "|" not in keyword or '__' in keyword:
                                            wildcard_present = True
                                            input_str = keyword.strip().strip('<>')
                                            
                                            if "__" in input_str:
                                                adjectives = re.findall(r'__(.*?)__', input_str)
                                                first_keyword, last_keyword = re.split(r'__.*?__', input_str)[0], re.split(r'__.*?__', input_str)[-1]
                                                if last_keyword:
                                                    split_result = last_keyword.split('>', 1)
                                                    wc_keyword = split_result[0].strip()
                                                    last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                                else: 
                                                    wc_keyword = ""
                                                
                                                adjective_string = ""
                                                for adjective in adjectives:
                                                    adjective_result = self.get_wildcard(adjective)
                                                    # 와일드카드 결과 검증
                                                    if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                                        wildcard_present = True
                                                        adjective_result.replace("<","__").replace(">","__")
                                                    if adjective_result.startswith(":") and adjective_result:
                                                        if adjective_string: 
                                                            adjective_string = adjective_string.rstrip() + adjective_result  
                                                        else:  
                                                            adjective_string += adjective_result  # 전체 추가
                                                    else:
                                                        adjective_string += adjective_result + " "
                                                wc_result = self.get_wildcard(wc_keyword)
                                                # 와일드카드 결과 검증
                                                if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                                    wildcard_present = True
                                                    wc_result.replace("<","__").replace(">","__")
                                                if not wc_result.startswith(":") and wc_result and not wc_result.startswith(")") and not wc_result.startswith("]") : wc_result = ' '+wc_result
                                                temp_fixed[i] = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                                i += 1
                                            else:
                                                out_wildcard = self.get_wildcard(input_str)
                                                # 와일드카드 결과 검증
                                                if ('__' in out_wildcard or ('<' in out_wildcard and '>' in out_wildcard)):
                                                    wildcard_present = True
                                                    temp_fixed[i] = out_wildcard
                                                    break
                                                    
                                                if ',' in out_wildcard:
                                                    split_wc = [item.strip() for item in out_wildcard.split(',')]
                                                    temp = []
                                                    for _key in split_wc[1:]:
                                                        temp.append(_key)
                                                    if temp:
                                                        for _key in temp:
                                                            if _key.startswith('*'):
                                                                split_wc[split_wc.index(_key)] = _key[1:]
                                                            else:
                                                                split_wc.remove(_key)
                                                                global_temp.append(_key)
                                                    if len(split_wc) == 2 and '{' not in split_wc[1] and '[' not in split_wc[1] and (split_wc[1].endswith('}') or split_wc[1].endswith(']')):
                                                        wc_post = split_wc[1].replace(']','').replace('}','')
                                                        global_temp.append(wc_post)
                                                        split_wc[0] += split_wc[1].replace(wc_post, '')
                                                        split_wc.pop()
                                                    out_wildcard = ', '.join(split_wc)
                                                temp_fixed[i] = out_wildcard
                                                i += 1
                                        else:
                                            i += 1
                                            
                                    itc += 1
                                    if not wildcard_present:
                                        break
                            temp_fixed_filtered = [item.strip() for item in temp_fixed if item.strip()]
                            global_temp_filtered = [item.strip() for item in global_temp if item.strip()]
                            combined_list = temp_fixed_filtered + global_temp_filtered
                            temp_fixed_result = ', '.join(combined_list)
                            #후행고정 프롬프트 처리 (10/15)
                            if '<' in self.fixed_prompt_after_input.get("0.0", "end") or '__' in self.fixed_prompt_after_input.get("0.0", "end"):
                                wildcard_present = True
                                itc = 0
                                while (wildcard_present and itc < 10):
                                    if not isinstance(temp_fixed_after, list): 
                                        temp_fixed_after = NAIA_random_function_core.process_fix_prompt(temp_fixed_after)
                                    elif any(', ' in item for item in temp_fixed_after):
                                        temp_fixed_str = ', '.join(temp_fixed_after)
                                        temp_fixed_after = temp_fixed_str.split(', ')
                                        temp_fixed_after = NAIA_random_function_core.process_fix_prompt(temp_fixed_after)
                                        temp_fixed_after = [k.strip() for k in temp_fixed_after]
                                    wildcard_present = False
                                    #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                    for i, keyword in enumerate(temp_fixed_after):
                                        if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                            wildcard_present = True
                                            vbar_check = keyword[1:-1]
                                            if '|' in vbar_check:
                                                choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                choice_dic = {}
                                                for choice in choices:
                                                    match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                    if match:
                                                        value, keyword = float(match.group(1)), match.group(2).strip()
                                                    else:
                                                        value, keyword = 1, choice.strip()
                                                    choice_dic[keyword] = value
                                                keywords = list(choice_dic.keys())
                                                weights = list(choice_dic.values())
                                                selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                temp_fixed_after[i] = selected_instant_wildcard

                                    #### 단계 2 : 글로벌 와일드카드 처리 ###
                                    i = 0
                                    while i < len(temp_fixed_after):
                                        keyword = temp_fixed_after[i]
                                        if "<" in keyword and not '<lora:' in keyword and ">" in keyword and "|" not in keyword or '__' in keyword:
                                            wildcard_present = True
                                            input_str = keyword.strip().strip('<>')
                                            
                                            if "__" in input_str:
                                                adjectives = re.findall(r'__(.*?)__', input_str)
                                                first_keyword, last_keyword = re.split(r'__.*?__', input_str)[0], re.split(r'__.*?__', input_str)[-1]
                                                if last_keyword:
                                                    split_result = last_keyword.split('>', 1)
                                                    wc_keyword = split_result[0].strip()
                                                    last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                                else: 
                                                    wc_keyword = ""
                                                
                                                adjective_string = ""
                                                for adjective in adjectives:
                                                    adjective_result = self.get_wildcard(adjective)
                                                    # 와일드카드 결과 검증
                                                    if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                                        wildcard_present = True
                                                        # 현재 인덱스에서 처리를 중단하고 다음 반복으로
                                                        adjective_result.replace("<","__").replace(">","__")
                                                    if adjective_result.startswith(":") and adjective_result:
                                                        if adjective_string: 
                                                            adjective_string = adjective_string.rstrip() + adjective_result  
                                                        else:  
                                                            adjective_string += adjective_result  # 전체 추가
                                                    else:
                                                        adjective_string += adjective_result + " "
                                                
                                                wc_result = self.get_wildcard(wc_keyword)
                                                # 와일드카드 결과 검증
                                                if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                                    wildcard_present = True
                                                    # 현재 인덱스에서 처리를 중단하고 다음 반복으로
                                                    wc_result.replace("<","__").replace(">","__")
                                                if not wc_result.startswith(":") and wc_result and not wc_result.startswith(")") and not wc_result.startswith("]") : wc_result = ' '+wc_result    
                                                temp_fixed_after[i] = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                                i += 1
                                            else:
                                                out_wildcard = self.get_wildcard(input_str)
                                                # 와일드카드 결과 검증
                                                if ('__' in out_wildcard or ('<' in out_wildcard and '>' in out_wildcard)):
                                                    wildcard_present = True
                                                    temp_fixed_after[i] = out_wildcard
                                                    break
                                                    
                                                if ',' in out_wildcard:
                                                    split_wc = [item.strip() for item in out_wildcard.split(',')]
                                                    temp = []
                                                    for _key in split_wc[1:]:
                                                        temp.append(_key)
                                                    if temp:
                                                        for _key in temp:
                                                            if _key.startswith('*'):
                                                                split_wc[split_wc.index(_key)] = _key[1:]
                                                            else:
                                                                split_wc.remove(_key)
                                                                global_temp_after.append(_key)
                                                    if len(split_wc) == 2 and '{' not in split_wc[1] and '[' not in split_wc[1] and (split_wc[1].endswith('}') or split_wc[1].endswith(']')):
                                                        wc_post = split_wc[1].replace(']','').replace('}','')
                                                        global_temp_after.append(wc_post)
                                                        split_wc[0] += split_wc[1].replace(wc_post, '')
                                                        split_wc.pop()
                                                    out_wildcard = ', '.join(split_wc)
                                                temp_fixed_after[i] = out_wildcard
                                                i += 1
                                        else:
                                            i += 1
                                    itc += 1
                                    if not wildcard_present:
                                        break
                            temp_after_filtered = [item.strip() for item in temp_fixed_after if item.strip()]
                            global_temp_after_filtered = [item.strip() for item in global_temp_after if item.strip()]
                            combined_list = temp_after_filtered + global_temp_after_filtered
                            temp_fixed_result_after = ', '.join(combined_list)
                            self.previous_fix_prompt = temp_fixed_result
                            self.previous_fix_prompt_after = temp_fixed_result_after
                        else:
                            temp_fixed_result = self.previous_fix_prompt
                            temp_fixed_result_after = self.previous_fix_prompt_after
                        self.wildcard_preopen_repeat_current += 1
                        if isinstance(popped_row, pd.DataFrame): popped_row = popped_row.iloc[0]
                        #기회될 때 이부분 dictionary로 싹 정리 하지만 글렀죠 
                        rm_location = self.rm_location_button.get()
                        rm_attire = self.rm_attire_var_button.get()
                        rm_not_nsfw = self.rm_not_nsfw_button.get()
                        _res = ""
                        if self.logic_activation.get() and current != '0':
                            rm_attire = 1 if self.storyteller[str(int(current) - 1)]['clothes'] else 0
                            rm_location =  1 if self.storyteller[str(int(current)- 1)]['background'] else 0
                            rm_not_nsfw = 1 if self.storyteller[str(int(current)- 1)]['nsfw'] else 0
                            if rm_attire and self.st_clothes: 
                                for k in self.st_clothes: 
                                    if k not in temp_fixed_result: temp_fixed_result += ', '+k
                            if rm_location and self.st_background:
                                for k in self.st_background: 
                                    if k not in temp_fixed_result: temp_fixed_result += ', '+k
                        if self.logic_activation.get():
                            _res = self.storyteller[current]['resolution']
                            if _res == "Previous":
                                try: 
                                    _x, _y = Image.open(self.image_queue[-1][3]).size
                                    _res = str(_x)+'x'+str(_y)
                                except:
                                    _res = random.choice(self.resolutions).replace(" ","")
                            elif _res == "Random":
                                _res = random.choice(self.resolutions).replace(" ","")
                            else:
                                _res = _res.replace(" ","")
                        if _res != '': rmc += ", resolution:"+_res
                        #새기능에 의한 전처리
                        autohide = self.auto_hide_keyword_input.get("0.0", "end")
                        if self.logic_activation.get():
                            if self.storyteller[current]['indiv']['isEnabled'] and 'toggle_hide' in self.storyteller[current]['indiv'] and self.storyteller[current]['indiv']['toggle_hide']:
                                autohide = self.storyteller[current]['indiv']['auto']
                            if self.storyteller[current]['indiv']['isEnabled'] and 'toggle_cond' in self.storyteller[current]['indiv'] and self.storyteller[current]['indiv']['toggle_cond']:
                                magic_word["cond"] = self.storyteller[current]['indiv']['cond_pos']
                        if self.rm_nsfw_disable and self.rm_nsfw_disable.get(): magic_word["nsfw_whitelist"] = []
                        else: magic_word["nsfw_whitelist"] = self.nsfw_whitelist
                        if self.male_before_girl.get():  magic_word["male_before_girl"] = True
                        else: magic_word["male_before_girl"] = False
                        if self.function_test_s1.get():  
                            magic_word["fts1"] = True
                            magic_word["fts1_pre"] = self.function_test_s1_entry2.get()
                            magic_word["fts1_post"] = self.function_test_s1_entry.get()
                            magic_word["fts1_character"] = self.function_test_s1_character_maintain.get()
                        else: magic_word["fts1"] = False                        
                        # 3 3 3 3 3 
                        if self.event_current and self.event_reorder_checkbox.get()==1 and self.wildcard_preopen_repeat_current-1 in self.event_current and len(self.event_current) >= self.wildcard_preopen_repeat_current-1:
                            magic_word["event"] = self.event_current[self.wildcard_preopen_repeat_current-1]
                        if isinstance(popped_row, pd.Series):
                            if '*(hold_seed)' in popped_row['general']:
                                popped_row['general'] = popped_row['general'].replace(", *(hold_seed)", "")
                                popped_row['general'] = popped_row['general'].replace(",*(hold_seed)", "")
                                popped_row['general'] = popped_row['general'].replace("*(hold_seed)", "")
                                self.seed_fix_button.select()
                            elif '*(reset_seed)' in popped_row['general']:
                                popped_row['general'] = popped_row['general'].replace(", *(reset_seed)", "")
                                popped_row['general'] = popped_row['general'].replace(",*(reset_seed)", "")
                                popped_row['general'] = popped_row['general'].replace("*(reset_seed)", "")
                                self.seed_fix_button.deselect()
                        if self.random_artist_rf_request:
                            if self.app_mode == "NAI":
                                first_comma_index = temp_fixed_result.find(',')
                                if first_comma_index != -1:  # 첫 번째 쉼표가 존재하는 경우
                                    if temp_fixed_result.startswith('#'):  # 문자열이 '#'으로 시작하면
                                        # 첫 번째 쉼표 이후부터 두 번째 쉼표 찾기
                                        second_comma_index = temp_fixed_result.find(',', first_comma_index + 1)
                                        if second_comma_index != -1:  # 두 번째 쉼표가 존재하는 경우
                                            temp_fixed_result = temp_fixed_result[:second_comma_index] + self.random_artist_rf_request + temp_fixed_result[second_comma_index:]
                                    else:  # '#'으로 시작하지 않으면 첫 번째 쉼표 위치에 삽입
                                        temp_fixed_result = temp_fixed_result[:first_comma_index] + self.random_artist_rf_request + temp_fixed_result[first_comma_index:]
                            else: temp_fixed_result = self.random_artist_rf_request + temp_fixed_result
                            self.random_artist_rf_request = None
                        if self.app_mode == "NAI":
                            prompt, self.current_prompt_rating, general, removed, rdict = NAIA_random_function_core.RFP(popped_row, temp_fixed_result, temp_fixed_result_after+rmc, autohide
                                                                    ,self.rm_artist_name_button.get(), self.rm_copyright_name_button.get(),self.rm_characteristic_button.get(), rm_location, self.rm_color_button.get(), rm_attire, rm_not_nsfw, self.data, magic_word)
                            hidden_prompt, hidden_current_prompt_rating, hidden_general, removed, _rdict = NAIA_random_function_core.RFP(popped_row, temp_fixed_result, temp_fixed_result_after+rmc, autohide
                                                                    ,self.rm_artist_name_button.get(), self.rm_copyright_name_button.get(),0, rm_location, self.rm_color_button.get(), 0, 0, self.data, magic_word)
                        else:
                            prompt, self.current_prompt_rating, general, removed, rdict = NAIA_random_function_core.RFP_WEBUI(popped_row, temp_fixed_result, temp_fixed_result_after+rmc, autohide
                                                                    ,self.rm_artist_name_button.get(), self.rm_copyright_name_button.get(),self.rm_characteristic_button.get(), rm_location, self.rm_color_button.get(),rm_attire, rm_not_nsfw, self.data, magic_word)                            
                    else:
                        temp_fixed_result = self.fixed_prompt_input.get("0.0", "end")
                        if self.random_artist_rf_request:
                            temp_fixed_result = self.random_artist_rf_request + temp_fixed_result
                            self.random_artist_rf_request = None
                        if isinstance(popped_row, pd.DataFrame): popped_row = popped_row.iloc[0]
                        if self.app_mode == "NAI":
                            prompt, self.current_prompt_rating, general, removed, rdict = NAIA_random_function_core.RFP(popped_row, temp_fixed_result, self.fixed_prompt_after_input.get("0.0", "end")+rmc, self.auto_hide_keyword_input.get("0.0", "end")
                                                                    ,self.rm_artist_name_button.get(), self.rm_copyright_name_button.get(),self.rm_characteristic_button.get(), self.rm_location_button.get(), self.rm_color_button.get(), self.rm_attire_var_button.get(), rm_not_nsfw, self.data, magic_word)
                        else:
                            prompt, self.current_prompt_rating, general, removed, rdict = NAIA_random_function_core.RFP_WEBUI(popped_row, temp_fixed_result, self.fixed_prompt_after_input.get("0.0", "end")+rmc, self.auto_hide_keyword_input.get("0.0", "end")
                                                                    ,self.rm_artist_name_button.get(), self.rm_copyright_name_button.get(),self.rm_characteristic_button.get(), self.rm_location_button.get(), self.rm_color_button.get(), self.rm_attire_var_button.get(), rm_not_nsfw, self.data, magic_word)    
                    if app.turbo_mode == 3 and app.turbo_button.get() == 1:
                        nf = [k.strip() for k in prompt.split(', ') if '#' not in k]
                        if app.wildcard_preopen_repeat_current != 1:
                            if nf in self.event_already_run:
                                self.after(200, random_function)
                        else:
                            self.event_already_run = []
                        self.event_already_run.append(nf)
                    if rm_not_nsfw:
                        if removed:
                            for k in removed.split(', '):
                                if k in rdict["rm_word"]: 
                                    try: rdict["rm_word"].remove(k)
                                    except: pass
                        if self.rm_nsfw_text1:
                            self.rm_nsfw_text1.configure(state="normal")
                            self.rm_nsfw_text1.delete('0.0', "end")
                            insert_with_color(self.rm_nsfw_text1, ', '.join(rdict["rm_word"]), "nsfw")
                            self.rm_nsfw_text1.configure(state="disabled")
                            if removed:
                                if len(removed) < 150:
                                    _itxt = "사전제거 : "+ removed
                                else:
                                    _itxt = "사전제거 : "+ removed[:150]
                            else:
                                _itxt = ''
                            self.rm_nsfw_label1.configure(text=_itxt)
                        if self.rm_nsfw_text2: 
                            self.rm_nsfw_text2.configure(state="normal")
                            self.rm_nsfw_text2.delete('0.0', "end")
                            self.rm_nsfw_text2.insert('0.0', ', '.join(rdict["w_word"]))
                            self.rm_nsfw_text2.configure(state="disabled")
                        if self.rm_nsfw_text4:
                            self.rm_nsfw_text4.configure(state="normal")
                            self.rm_nsfw_text4.delete('0.0', "end")
                            insert_with_color(self.rm_nsfw_text4, general['prompt'].replace('\\', '').replace(' , ', ' '), "nsfw_valid")
                            self.rm_nsfw_text4.configure(state="disabled")
                    if self.webui_dtg_var.get() == 0:
                        # try:
                        #     if popped_row is not None and not popped_row.empty:
                        #         _prx = ", # id:" + str(popped_row['id'])
                        #         prompt = prompt + _prx
                        # except: pass
                        self.text_input.delete("0.0", "end")
                        self.text_input.insert("0.0", prompt)
                        if self.app_mode == "WEBUI" and self.webui_e621_button.get() == 1:
                            try:
                                if not self.e621_dict_large:
                                    raise ValueError("no e621 dict")
                                origin = self.text_input.get("0.0", "end-1c")
                                pretest = [keyword.strip() for keyword in origin.split(',')]
                                filtered = [keyword for keyword in pretest if keyword in self.e621_dict_large]
                                result = ', '.join(filtered)
                                if result:
                                    _text = self.generate_e621_request(result)
                                    last_tag = filtered[-1]
                                    text_content = self.text_input.get("0.0", "end-1c")
                                    last_tag_pos = text_content.rfind(last_tag)
                                    if last_tag_pos != -1:
                                        content_before = text_content[:last_tag_pos + len(last_tag)]
                                        lines = content_before.split('\n')
                                        line_number = len(lines)
                                        column_number = len(lines[-1])
                                        
                                        # 태그 위치 이후에 새 태그 삽입
                                        insert_position = f"{line_number}.{column_number}"
                                        self.text_input.insert(insert_position, f", #e621, {_text}")
                                else:
                                    raise ValueError("no tags")
                            except:
                                open_e621()
                        if "fts1" in rdict:
                            self.fts1 = rdict["fts1"]
                    else:
                        prompt = [key.strip() for key in prompt.split(',')]
                        _count = 0
                        temp_artist = []
                        _iend = len(prompt)
                        for i, key in enumerate(prompt): 
                            if key.startswith('#') and _count != 2 and i+1 != _iend:
                                _count += 1
                                if _count != 2: prompt[i+1] = '\n'+prompt[i+1]
                            elif _count == 1:
                                if '(' in prompt[i]:
                                    prompt[i] = prompt[i].replace('(', '\\(').replace(')','\\)')
                            elif _count == 2 and not key.startswith('#'):
                                prompt[i] = '#'
                                temp_artist.append(key)
                            elif _count == 2 and key.startswith('#'):
                                _count += 1
                                prompt[i-1] = 'artist_temp'
                                if i < len(prompt): prompt[i+1] = '\n'+prompt[i+1]
                                else: prompt[i] = '\n'+prompt[i]
                        if temp_artist: temp_artist = ', '.join(temp_artist)
                        else: temp_artist = ''
                        prompt = [key for key in prompt if not key.startswith('#')]
                        dtg_temp = ', '.join(prompt)   
                update_rating()
                if self.app_mode == "NAI" and (self.current_model_nai.get() == "NAID4" or self.current_model_nai.get() == "NAID4-Curated") and self.naid4_characters_label.get() == 1 and self.wildcard_preopen_repeat_current == 1:
                    self.nai4_character_list = []
                    self.nai4_character_uc_list = []
                    _ix = 0
                    _ctext = ""
                    self.naid4_selected_character_textbox.configure(state = "normal")
                    self.naid4_selected_character_textbox.delete("0.0", "end")
                    for frame_dict in self.character_frames:
                        _ix += 1
                        textbox = frame_dict['textbox']  # 각 프레임의 textbox 참조
                        content = textbox.get("0.0", "end")
                        content = [k.strip() for k in content.split(',')]
                        global_content = []
                        if '<' in textbox.get("0.0", "end") or  '__' in textbox.get("0.0", "end") :
                            wildcard_present = True
                            itc = 0
                            while (wildcard_present and  itc < 10):
                                wildcard_present = False
                                #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                for i, keyword in enumerate(content):
                                    if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                        wildcard_present = True
                                        vbar_check = keyword[1:-1]
                                        if '|' in vbar_check:
                                            choices = vbar_check.split('|')  # '|'를 기준으로 split
                                            choice_dic = {}
                                            for choice in choices:
                                                match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                if match:
                                                    value, keyword = float(match.group(1)), match.group(2).strip()
                                                else:
                                                    value, keyword = 1, choice.strip()
                                                choice_dic[keyword] = value
                                            keywords = list(choice_dic.keys())
                                            weights = list(choice_dic.values())
                                            selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                            content[i] = selected_instant_wildcard
                                #### 단계 2 : 글로벌 와일드카드 처리 ###
                                content = NAIA_random_function_core.process_fix_prompt(content)
                                for i, keyword in enumerate(content):
                                    if "<" in keyword and not '<lora:' in keyword and ">" in keyword or '__' in keyword:
                                        wildcard_present = True
                                        input_str = keyword.strip().strip('<>')
                                        if("__" in input_str):
                                            adjectives = re.findall(r'__(.*?)__', input_str)
                                            first_keyword, last_keyword = re.split(r'__.*?__', input_str)[0], re.split(r'__.*?__', input_str)[-1]
                                            if last_keyword:
                                                split_result = last_keyword.split('>', 1)
                                                wc_keyword = split_result[0].strip()
                                                last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                            else: wc_keyword = ""
                                            adjective_string = ""
                                            for adjective in adjectives:
                                                adjective_result = self.get_wildcard_naid4(adjective)
                                                if adjective_result.startswith(":") and adjective_result:
                                                    if adjective_string: 
                                                        adjective_string = adjective_string.rstrip() + adjective_result  
                                                    else:  
                                                        adjective_string += adjective_result  # 전체 추가
                                                else:
                                                    adjective_string += adjective_result + " "
                                            wc_result = self.get_wildcard_naid4(wc_keyword)
                                            if not wc_result.startswith(":") and wc_result and not wc_result.startswith(")") and not wc_result.startswith("]") : wc_result = ' '+wc_result    
                                            content[i] = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                        else:
                                            out_wildcard = self.get_wildcard_naid4(input_str)
                                            if ',' in out_wildcard:
                                                split_wc = [item.strip() for item in out_wildcard.split(',')]
                                                temp = []
                                                for _key in split_wc[1:]:
                                                    temp.append(_key)
                                                if temp:
                                                    for _key in temp:
                                                        if _key.startswith('*'):
                                                            split_wc[split_wc.index(_key)] = _key[1:]
                                                        else:
                                                            split_wc.remove(_key)
                                                            global_content.append(_key)
                                                if len(split_wc) == 2 and '{' not in split_wc[1] and '[' not in split_wc[1] and (split_wc[1].endswith('}') or split_wc[1].endswith(']')):
                                                    wc_post = split_wc[1].replace(']','').replace('}','')
                                                    global_content.append(wc_post)
                                                    split_wc[0] += split_wc[1].replace(wc_post, '')
                                                    split_wc.pop()
                                                out_wildcard = ', '.join(split_wc)
                                            content[i] = out_wildcard
                                itc += 1
                                if not wildcard_present:
                                    break
                        result_content = ', '.join(content)
                        if content[0] != "girl" and content[0] != "boy":
                            _ctext += f"{content[0]}, "
                        elif len(content) >= 2:
                            _ctext += f"{content[1]}, "
                        else:
                            _ctext += f"null, "
                        if global_content: result_content += ', '+', '.join(global_content)
                        self.nai4_character_list.append(result_content)
                        _uc = frame_dict['uc'] 
                        _uc = _uc.get("0.0", "end")
                        _uc = [k.strip() for k in _uc.split(',')]
                        uc = ', '.join(_uc)
                        self.nai4_character_uc_list.append(uc)
                    self.naid4_selected_character_textbox.insert("0.0", _ctext)
                    self.naid4_selected_character_textbox.configure(state="disabled")
                self.general_prompt = general['prompt'].replace('\\', '')
                self.st_clothes = []
                self.st_background = []
                if self.logic_activation.get() and self.wildcard_preopen_repeat_current != self.wildcard_preopen_repeat:
                    self.st_clothes = [k for k in self.general_prompt.split(', ') if k in self.data.attire_list]
                    self.st_background = [k for k in self.general_prompt.split(', ') if k in ['indoors', 'outdoors', 'airplane interior', 'airport', 'apartment', 'arena', 'armory', 'bar', 'barn', 'bathroom', 'bathtub', 'bedroom', 'bell tower', 'billiard room', 'book store', 'bowling alley', 'bunker', 'bus interior', 'butcher shop', 'cafe', 'cafeteria', 'car interior', 'casino', 'castle', 'catacomb', 'changing room', 'church', 'classroom', 'closet', 'construction site', 'convenience store', 'convention hall', 'court', 'dining room', 'drugstore', 'ferris wheel', 'flower shop', 'gym', 'hangar', 'hospital', 'hotel room', 'hotel', 'infirmary', 'izakaya', 'kitchen', 'laboratory', 'library', 'living room', 'locker room', 'mall', 'messy room', 'mosque', 'movie theater', 'museum', 'nightclub', 'office', 'onsen', 'ovservatory', 'phone booth', 'planetarium', 'pool', 'prison', 'refinery', 'restaurant', 'restroom', 'rural', 'salon', 'school', 'sex shop', 'shop', 'shower room', 'skating rink', 'snowboard shop', 'spacecraft interior', 'staff room', 'stage', 'supermarket', 'throne', 'train station', 'tunnel', 'airfield', 'alley', 'amphitheater', 'aqueduct', 'bamboo forest', 'beach', 'blizzard', 'bridge', 'bus stop', 'canal', 'canyon', 'carousel', 'cave', 'cliff', 'cockpit', 'conservatory', 'cross walk', 'desert', 'dust storm', 'flower field', 'forest', 'garden', 'gas staion', 'gazebo', 'geyser', 'glacier', 'graveyard', 'harbor', 'highway', 'hill', 'island', 'jungle', 'lake', 'market', 'meadow', 'nuclear powerplant', 'oasis', 'ocean bottom', 'ocean', 'pagoda', 'parking lot', 'playground', 'pond', 'poolside', 'railroad', 'rainforest', 'rice paddy', 'roller coster', 'rooftop', 'rope bridge', 'running track', 'savannah', 'shipyard', 'shirine', 'skyscraper', 'soccor field', 'space elevator', 'stair', 'starry sky', 'swamp', 'tidal flat', 'volcano', 'waterfall', 'waterpark', 'wheat field', 'zoo', 'white background', 'simple background', 'grey background', 'gradient background', 'blue background', 'black background', 'yellow background', 'pink background', 'red background', 'brown background', 'green background', 'purple background', 'orange background']]
                self.auto_hide_result.configure(state="normal")
                self.auto_hide_result.delete("0.0", "end")
                self.auto_hide_result.insert("0.0", removed)
                self.auto_hide_result.configure(state="disabled")
                app.after(100, lambda: self.random_function_button.configure(state="normal"))
                self.random_function_pressed = False
                app.after(100, highlight_text)
                storyteller_current = str(self.wildcard_preopen_repeat_current - 1)
                if self.logic_activation.get() and "inpaint" in self.storyteller[storyteller_current]['rating'] and self.image_queue:
                    _prompt = [key for key in prompt.split(', ') if '|' not in key and 'seed:' not in key and "resolution:" not in key and '#' not in key and '*(' not in key]
                    _prompt = ', '.join(_prompt)
                    if self.storyteller[storyteller_current]['indiv']['isEnabled'] and 'toggle_cond_neg' in  self.storyteller[storyteller_current]['indiv'] and self.storyteller[storyteller_current]['indiv']['toggle_cond_neg'] and self.storyteller[storyteller_current]['indiv']['neg']:
                        _negative = NAIA_generation.event_cond_negative(_prompt, self.storyteller[storyteller_current]['indiv']['neg'], self.storyteller[storyteller_current]['indiv']['cond_neg'], self.current_prompt_rating)
                    else:
                        _negative = NAIA_generation.event_cond_negative(_prompt, self.negative_prompt_input.get("0.0", "end-1c"), self.conditional_negative_input.get("0.0", "end-1c"), self.current_prompt_rating)
                    if self.img2img_window is not None:
                        self.img2img_window.destroy()
                        self.img2img_window = None
                        img2img_window = None
                    _img2img(self, None,None,None,None,[_prompt, _negative])
                    self._evinpaint_flag = True
                    return
                if (self.webui_guide_var.get() == 1 and self.webui_guide_setting):
                    if "rm_character" in self.webui_guide_setting and self.webui_guide_setting["rm_character"] == 1:
                        if self.webui_guide_clothes_maintain.get()==1: temp_prompt = [key.strip() for key in hidden_general["prompt"].split(',')]
                        else: temp_prompt = [key.strip() for key in general["prompt"].split(',')]
                        temp_prompt = [key for key in temp_prompt if key.replace("\\", "") not in app.data.character_keys]
                        general["prompt"] = ', '.join(temp_prompt)
                    else: 
                        if self.webui_guide_clothes_maintain.get()==1: general["prompt"] = hidden_general["prompt"]
                    self.guide_generation_thread_contents = {
                        "prompt": general["prompt"],
                        "prefix": self.webui_guide_setting["prefix"],
                        "negative": self.webui_guide_setting["negative"],
                        "postfix": self.webui_guide_setting["postfix"],
                        "steps": self.webui_guide_setting["steps"],
                        "cfg_scale": self.webui_guide_setting["cfg_scale"],
                        "sampler": self.webui_guide_setting["sampler"],
                        "vibe_ie": self.webui_guide_setting["vibe_ie"],
                        "vibe_strength": self.webui_guide_setting["vibe_strength"],
                        "i2i_strength": self.webui_guide_setting["i2i_strength"]
                    }
                    guide_generation_thread = threading.Thread(target=run_webui_guide, args=(self.guide_generation_thread_contents,), daemon=True)
                    guide_generation_thread.start()
            self.generated_prompt_set['prompt'] = self.general_prompt
            self.generated_prompt_set['after'] = temp_fixed_result_after
            self.fixed_prompt_result_for_artist_check = self.fixed_prompt_input.get("0.0", "end-1c") + ", " + self.fixed_prompt_after_input.get("0.0", "end-1c")
        self.external_random_function = random_function

        def run_webui_guide(contents, option=""):
            if self.random_resolution_button.get() == 1:
                resolutions = self.resolutions
                random_resolution = random.choice(resolutions)
                self.resolution_var.set(random_resolution)
            try: 
                NAI_width, NAI_height = self.resolution_button.get().split('x')
            except:
                resolutions = app.resolutions
                random_resolution = random.choice(resolutions)
                app.resolution_button.set(random_resolution)
                NAI_width, NAI_height = random_resolution.split('x')
            NAI_width = NAI_width.strip()
            NAI_height = NAI_height.strip()
            NAI_width = str((int(NAI_width) // 64) * 64)
            NAI_height = str((int(NAI_height) // 64) * 64)
            if self.webui_image_resoluiton == 0:
                NAI_width, NAI_height = find_max_resolution(NAI_width, NAI_height)
            prompt = contents['prompt']
            if "rm_prompt" in self.webui_guide_setting:
                rm_list = [key.strip() for key in self.webui_guide_setting["rm_prompt"].split(',')]
                rm_list = [rm for rm in rm_list if rm]
                prompt = [key.strip() for key in prompt.split(',')]
                prompt = [p for p in prompt if all(rm not in p for rm in rm_list)]
                prompt = ', '.join(prompt)
            parameters = {
                "prompt": f"{contents['prefix']}, {prompt}, {contents['postfix']}",
                "negative prompt": contents["negative"],
                "steps": contents["steps"],
                "cfg_scale": contents["cfg_scale"],
                "sampler": contents["sampler"],
                "vibe_ie": contents["vibe_ie"],
                "vibe_strength": contents["vibe_strength"],
                "i2i_strength": contents["i2i_strength"],
                "seed": self.seed_entry.get() if option != "reroll" else -1,
                "width": NAI_width,
                "height": NAI_height
            }
            if self.rec_resolution.get() == 1 and "image_height" in app.current_popped_row:
                try:
                    rrw, rrh = find_max_resolution(int(app.current_popped_row["image_width"]), int(app.current_popped_row["image_height"]), 1048576)
                    self.resolution_button.set(str(rrw)+ " x " + str(rrh))
                    parameters["width"] = rrw
                    parameters["height"] = rrh
                except:
                    resolutions = self.resolutions
                    random_resolution = random.choice(resolutions)
                    self.resolution_button.set(random_resolution)
            #if self.webui_guide_image_save.get() == 1:
            parameters["save_folder"] = self.output_file_path
            parameters["png_rule"] = self.name_var.get()
            parameters["start_time"] = self.start_time
            try:
                if self.automation_button.get() == 0:
                    self.image_generation_button.configure(state="disabled")
                self.temp_guide_image, self.temp_guide_prompt, self.temp_guide_seed, self.temp_guide_filename = NAIA_generation.generate_guide_image_webui(self.NAI_webui_address, parameters)
                self.temp_guide_resized_image = resize_and_fill(self.temp_guide_image)
                app.after(50, lambda: self.webui_guide_image.configure(image=customtkinter.CTkImage(self.temp_guide_resized_image, size=self.temp_guide_image_size)))
                self.image_generation_button.configure(state="normal")
            except:
                self.image_generation_button.configure(state="normal")
                return

        def find_max_resolution(width, height, max_pixels=589824, multiple_of=64):
            ratio = int(width) / int(height)

            max_width = int((max_pixels * ratio)**0.5)
            max_height = int((max_pixels / ratio)**0.5)

            max_width = (max_width // multiple_of) * multiple_of
            max_height = (max_height // multiple_of) * multiple_of

            while max_width * max_height > max_pixels:
                max_width -= multiple_of
                max_height = int(max_width / ratio)
                max_height = (max_height // multiple_of) * multiple_of

            if max_pixels == 1048576:
                attempts = 0  
                max_attempts = 10  
                while (max_width % multiple_of + max_height % multiple_of) < 32 and attempts < max_attempts:
                    if random.choice([True, False]):
                        if (max_width + multiple_of) * max_height <= max_pixels:
                            max_width += multiple_of
                    else:
                        if max_width * (max_height + multiple_of) <= max_pixels:
                            max_height += multiple_of
                    attempts += 1

            return (str(max_width), str(max_height))

        def create_mask_image(width, height, filename):
            from ultralytics import YOLO
            def mask_to_base64(image):
                # PIL.Image 객체를 넘파이 배열로 변환
                i = np.array(image)
                # RGBA 채널 처리를 위해 알파 채널 추가 전 이미지 처리
                if i.shape[-1] == 3:  # RGB 이미지인 경우
                    alpha = np.sum(i, axis=-1) > 0  # 알파 마스크 생성
                    alpha = np.uint8(alpha * 255)  # 알파 채널 값으로 변환
                    rgba = np.dstack((i, alpha))  # RGBA 이미지 생성
                elif i.shape[-1] == 4:  # 이미 RGBA 이미지인 경우
                    rgba = i
                else:
                    raise ValueError("Unsupported image format")

                # 넘파이 배열에서 PIL.Image 객체로 변환
                img = Image.fromarray(rgba)
                
                # PIL.Image 객체를 Base64 문자열로 변환
                image_bytesIO = io.BytesIO()
                img.save(image_bytesIO, format="png")
                return base64.b64encode(image_bytesIO.getvalue()).decode()

            image = filename
            image_np = np.array(image.convert('RGB'))
            model_person = YOLO(os.path.join(app.basedir, 'person_yolov8n-seg.pt'))
            results_person = model_person(image_np, conf=0.25, device="cpu")

            # 원본 크기의 마스크 이미지 생성
            mask_image = Image.new('L', (image_np.shape[1], image_np.shape[0]), 0)

            if len(results_person[0]) >= 1:
                for result in results_person:
                    if result.masks is not None:
                        for mask in result.masks.data:
                            mask = mask.cpu().numpy() * 255
                            mask_pil = Image.fromarray(mask.astype(np.uint8), mode='L')
                            mask_pil = mask_pil.resize((image_np.shape[1], image_np.shape[0]), Image.Resampling.LANCZOS)
                            mask_image = Image.composite(mask_pil, mask_image, mask_pil)

            # 마스크 이미지를 1.1배 크기로 확대
            enlarged_width = int(image_np.shape[1] * 1.3)
            enlarged_height = int(image_np.shape[0] * 1.3)
            enlarged_mask = mask_image.resize((enlarged_width, enlarged_height), Image.Resampling.LANCZOS)

            # 원본 크기의 새 이미지 생성 및 확대된 마스크 중앙에 배치
            final_width = image_np.shape[1]
            final_height = image_np.shape[0]
            final_mask = Image.new('L', (final_width, final_height), 0)
            paste_x = (final_width - enlarged_width) // 2
            paste_y = (final_height - enlarged_height) // 2
            final_mask.paste(enlarged_mask, (paste_x, paste_y))

            # 원본 크기의 최종 마스크 이미지 생성
            final_rgba_mask = Image.new('RGBA', (final_width, final_height), (0, 0, 0, 0))
            draw = ImageDraw.Draw(final_rgba_mask)

            for y in range(final_height):
                for x in range(final_width):
                    if final_mask.getpixel((x, y)) > 0:
                        if not (x % 32 == 0 and y % 32 == 0): # 64픽셀 간격의 점은 그리지 않음
                            draw.point([x, y], fill=(255, 255, 255, 255))

            # 결과 시각화
            image.thumbnail((final_width, final_height))
            Image.composite(image, Image.new('RGBA', image.size, (128, 128, 128, 255)), final_mask)
            #final_rgba_mask.show()

            return mask_to_base64(final_rgba_mask)

        def update_rating():
            self.rating_select_explicit.configure(text_color="#F2FBFF")
            self.rating_select_nsfw.configure(text_color="#F2FBFF")
            self.rating_select_sensitive.configure(text_color="#F2FBFF")
            self.rating_select_general.configure(text_color="#F2FBFF")
            if self.current_prompt_rating == "e":
                self.rating_select_explicit.configure(text_color="#FFFF97")
            elif self.current_prompt_rating == "q":
                self.rating_select_nsfw.configure(text_color="#FFFF97")
            elif self.current_prompt_rating == "s":
                self.rating_select_sensitive.configure(text_color="#FFFF97")
            else:
                self.rating_select_general.configure(text_color="#FFFF97")

        def apply_transparency(image, bbox):
            x1, y1, x2, y2 = bbox
            width = x2 - x1
            height = y2 - y1
            offset_w = int(width * 0.13)
            offset_h = int(height * 0.13)
            x1, y1 = x1 + offset_w, y1 + offset_h
            x2, y2 = x2 - offset_w, y2 - offset_h
            image = image.convert("RGBA")
            pixels = image.load()
            for x in range(x1, x2):
                for y in range(y1, y2):
                    pixels[x, y] = (255, 255, 255, 0) 
            return image

        def process_image_with_yolo(_filename):
            from ultralytics import YOLO
            image = Image.open(_filename)
            image_rgb = image.convert("RGB")
            image_np = np.array(image_rgb) 
            model_face = YOLO(os.path.join(app.basedir,'face_yolov8n.pt'))
            results_face = model_face(image_np, conf=0.25, device="cpu")
            boxes_face = results_face[0].boxes.xyxy
            for box in boxes_face:
                bbox = [int(coord) for coord in box]
                image = apply_transparency(image, bbox)
            #image.show()
            result_image = NAIA_generation.image_to_base64(image)
            return result_image

        self.temp_guide_image = None
        self.temp_guide_resized_image = None
        self.temp_guide_image_size = (368, 368)
        self.webui_image_resoluiton = 1
        self.random_function_pressed = False
        self.running_flag = False
        self.error_count = 0
        self.turbo_fail_count = 0
        self.anlas_request = False
        self.image_generation_repeat_prompt = ""
        self.instant_i2i_state = False
        self.guide_generation_thread_contents = None
        self.auto_i2i_text = ""

        self.reference_list = []
        self.reference_list_ie = []
        self.reference_list_irs = []
        self.event_current = {}
        self.event_turbo3_already_run = False

        def NAIA_generate(self):
            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and (not self.control_pressed) and self.naid4_characters_label.get() == 1 and self.naid4_auto_reroll.get() == 1:
                naid4_character_update()
            if not self.generation_queue: 
                self.image_generation_button.configure(state="disabled")
            if app.event_turbo3_already_run == True :
                if app.reference_list and len(app.reference_list) >= app.wildcard_preopen_repeat_current - 1:
                    app.reference_list.pop()
                    app.reference_list_ie.pop()
                    app.reference_list_irs.pop()
                if app.event_option["fix_seed"]:
                    self.seed_fix_button.deselect()
            if self.seed_fix_button.get() == 0:
                _temp_new_seed = random.randint(0,2**32 - 1)
                self.entry_seed_value.set(_temp_new_seed)
            try: 
                if self.random_resolution_button.get() == 1 and not (self.webui_guide_button.get() == 1 or (self.app_mode == "NAI" and self.guide_i2i.get() == 1)) and not (self.rec_resolution.get() == 1 and "image_height" in app.current_popped_row):
                    resolutions = self.resolutions
                    random_resolution = random.choice(resolutions)
                    self.resolution_button.set(random_resolution)
            except:
                resolutions = self.resolutions
                random_resolution = random.choice(resolutions)
                self.resolution_button.set(random_resolution)        
            if type(app.current_popped_row) != type(None)  and self.rec_resolution.get() == 1 and "image_height" in app.current_popped_row:
                try:
                    rrw, rrh = find_max_resolution(int(app.current_popped_row["image_width"]), int(app.current_popped_row["image_height"]), 1048576)
                    self.resolution_button.set(str(rrw)+ " x " + str(rrh))
                except:
                    resolutions = self.resolutions
                    random_resolution = random.choice(resolutions)
                    self.resolution_button.set(random_resolution)
            if self.cached_rows is None and self.toggle_prompt_fix_button.get() == 0 and self.wildacrd_standalone.get() == 0 and self.automation_button.get() == 1:
                self.state_label.configure(text ="state : 자동화 전 프롬프트 검색을 수행하는 중 입니다", text_color = "#FFFF97")
                self.prompt_search(update_labels, perform_search, depth_search)
            if self.turbo_button.get() == 1:
                if app.turbo_mode == 3 and app.event_viewer_checkbox and app.event_viewer_checkbox.get() == 1:
                    app.event_skip_button.configure(state="disabled")
                    app.event_jump_button.configure(state="disabled")
                origin = self.text_input.get("0.0", "end-1c")
                pretest = [keyword.strip() for keyword in origin.split(',')]
                if ('*(split nsfw)' in pretest or '*(split nsfw)-rand' in pretest or app.turbo_mode == 2 or app.turbo_mode == 3):
                    pass
                elif self.toggle_prompt_fix_button.get() == 0 and (('sex' not in pretest and 'group sex' not in pretest) or ('1girl' not in pretest and 'girls' not in origin[:20]) or ('1boy' not in pretest and 'boys' not in origin[:20])):
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> Explicit Turbo 기능은 프롬프트 내에 1girl/girls, 1boy/boys, sex/group sex가 존재할 때 사용 가능합니다. 만약 인식이 제대로 안된다면 <*1boy, *1girl, sex|*2boys,*1girl, sex> 이렇게 기입하여 넣어주세요.")
                    self.turbo_fail_count += 1
                    if self.turbo_fail_count >= 20:
                        self.turbo_fail_count = 0
                        self.turbo_button.deselect()
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    if self.automation_button.get() == 1 and self.toggle_prompt_fix_button.get() == 0:
                        try: random_function()
                        except: self.random_function_button.configure(state="normal", command=_random_function)
                        time.sleep(0.5)  
                        if self.searching_flag == True:
                            self.search_thread.join()
                        return self.event_generate(GENERATE_EVENT, when="tail")
                    elif self.automation_button.get() == 1 and self.toggle_prompt_fix_button.get() == 1:
                        self.automation_button.deselect()
                        return
                    else:
                        if not self.generation_queue: self.image_generation_button.configure(state="normal")
                        return
                self.turbo_fail_count = 0
            try: 
                NAI_width, NAI_height = self.resolution_button.get().split('x')
            except:
                resolutions = app.resolutions
                random_resolution = random.choice(resolutions)
                app.resolution_button.set(random_resolution)
                NAI_width, NAI_height = random_resolution.split('x')
            NAI_width = NAI_width.strip()
            NAI_height = NAI_height.strip()
            NAI_width = str((int(NAI_width) // 64) * 64)
            NAI_height = str((int(NAI_height) // 64) * 64)
            if int(NAI_height) * int(NAI_width) > 1048576 and app.app_mode == "NAI":
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> Anlas가 소모되는 해상도 요청입니다.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")
                self.anlas_request = True
            scale_pre = self.cfg_scale_entry.get()
            try:
                scale_pre = float(scale_pre)
            except:
                scale_pre = 5.0
                self.cfg_scale_var.set("5.0")
            rescale_pre = self.prompt_guidance_rescale_entry.get()
            try:
                rescale_pre = float(rescale_pre)
            except:
                rescale_pre = 0
                self.prompt_guidance_rescale_var.set("0")
            uncond_pre = self.uncond_strength_entry.get()
            try:
                uncond_pre = float(uncond_pre)
                #uncond_pre = round(uncond_pre / 0.05) * 0.05
                if (uncond_pre > 162):
                    uncond_pre = 19.19
                    self.uncond_strength_entry.delete(0, "end")
                    self.uncond_strength_entry.insert(0, "19.19")
            except:
                uncond_pre = 1.0
                self.uncond_strength_entry.delete(0, "end")
                self.uncond_strength_entry.insert(0, "19.19")
            #### 여기서부터 와일드카드 처리 구문 ####
            wildcard_ir_flag = False
            if self.image_generation_repeat_flag == False or not self.hold_wildcard:
                if self.set_vibe_wildcard:
                    wildcard_ir_flag = True
                before_wildcard = self.text_input.get("0.0", "end-1c")
                before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)

                # 리스트의 각 항목에 '<' 또는 '__'가 포함되어 있는지 검사
                if any( ('<' in item or '__' in item) for item in before_wildcard ):
                    wildcard_present = True
                    itc = 0
                    while wildcard_present and itc < 10:
                        wildcard_present = False

                        #### 단계 1 : 인스턴트 와일드카드 처리 ###
                        for i, keyword in enumerate(before_wildcard):
                            if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                wildcard_present = True
                                vbar_check = keyword[1:-1]
                                if '|' in vbar_check:
                                    choices = vbar_check.split('|')  # '|'를 기준으로 split
                                    choice_dic = {}
                                    for choice in choices:
                                        match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                        if match:
                                            value, _keyword = float(match.group(1)), match.group(2).strip()
                                        else:
                                            value, _keyword = 1, choice.strip()
                                        choice_dic[_keyword] = value
                                    keywords = list(choice_dic.keys())
                                    weights = list(choice_dic.values())
                                    selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                    before_wildcard[i] = selected_instant_wildcard

                        #### 단계 2 : 글로벌 와일드카드 처리 ###
                        # (B)와 같이 외부 전처리 함수를 호출
                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                        i = 0
                        while i < len(before_wildcard):
                            keyword = before_wildcard[i]
                            if (("<" in keyword and not '<lora:' in keyword and ">" in keyword)
                                or ('__' in keyword)):
                                wildcard_present = True
                                # 양쪽 공백 제거 후, 양쪽의 '<', '>' 제거
                                input_str = keyword.strip().strip('<>')
                                
                                if "__" in input_str:
                                    # 앞부분과 뒷부분을 모두 보존하도록 분리함
                                    adjectives = re.findall(r'__(.*?)__', input_str)
                                    split_parts = re.split(r'__.*?__', input_str)
                                    first_keyword = split_parts[0]
                                    last_keyword = split_parts[-1]
                                    if last_keyword:
                                        # last_keyword 내에 '>'가 있다면 분리
                                        split_result = last_keyword.split('>', 1)
                                        wc_keyword = split_result[0].strip()
                                        last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                    else:
                                        wc_keyword = ""
                                    
                                    adjective_string = ""
                                    for adjective in adjectives:
                                        adjective_result = self.get_wildcard(adjective)
                                        # 결과에 여전히 와일드카드가 있다면 치환 후 재할당
                                        if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                            wildcard_present = True
                                            adjective_result = adjective_result.replace("<", "__").replace(">", "__")
                                        if adjective_result.startswith(":") and adjective_result:
                                            if adjective_string:
                                                adjective_string = adjective_string.rstrip() + adjective_result  
                                            else:
                                                adjective_string += adjective_result
                                        else:
                                            adjective_string += adjective_result + " "
                                    
                                    wc_result = self.get_wildcard(wc_keyword)
                                    if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                        wildcard_present = True
                                        wc_result = wc_result.replace("<", "__").replace(">", "__")
                                    # (B) 사양에 따라 wc_result에 선행 공백 추가
                                    if wc_result and not wc_result.startswith(":") and not wc_result.startswith(")") and not wc_result.startswith("]"):
                                        wc_result = ' ' + wc_result
                                    result = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                else:
                                    out_wildcard = self.get_wildcard(input_str)
                                    # get_wildcard 결과에 와일드카드가 남아있으면 재처리
                                    if ('__' in out_wildcard or ('<' in out_wildcard and '>' in out_wildcard)):
                                        wildcard_present = True
                                        before_wildcard[i] = out_wildcard
                                        break  # 즉시 재처리를 위해 while문 탈출

                                    result = out_wildcard
                                before_wildcard[i] = result
                                i += 1
                            else:
                                i += 1
                        itc += 1
                        if not wildcard_present:
                            break
                else:
                    after_wildcard = self.text_input.get("0.0", "end-1c")

                after_wildcard = ', '.join(before_wildcard)

            if self.image_generation_repeat > 1 and self.hold_wildcard:
                if self.image_generation_repeat_flag == False:
                    self.image_generation_repeat_flag = True
                    self.image_generation_repeat_prompt = after_wildcard
                    self.image_generation_repeat_current = 1
                else:
                    after_wildcard = self.image_generation_repeat_prompt
                    self.image_generation_repeat_current += 1
            elif self.image_generation_repeat > 1 and not self.hold_wildcard:
                if self.image_generation_repeat_flag == False:
                    self.image_generation_repeat_flag = True
                    self.image_generation_repeat_prompt = after_wildcard
                #after_wildcard = self.image_generation_repeat_prompt
                self.image_generation_repeat_current += 1
            ##############################
            if ' + ' in app.sampler_button.get():
                _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
            else:
                _sampler = app.sampler_button.get()
                _noise_schedule = "native"
            fix_seed_value = str(self.entry_seed_value.get())
            fix_res_value = [1024, 1024]
            fix_check = after_wildcard.split(', ')
            after_check = fix_check.copy()
            for i, v in  enumerate(fix_check):
                if "seed:" in v and v.startswith("seed:"):
                    if "->" in v:
                        current_arrow = (len(self.registration_queue) - len(self.prior_queue)) - 1
                        _v = v.split('->')
                        if len(_v) > current_arrow: v = _v[current_arrow]
                        else: v = _v[current_arrow % len(_v)]
                    fix_seed_value = v[5:]
                    after_check.remove(fix_check[i])
                elif "resolution:" in v and v.startswith("resolution:"):
                    if "->" in v:
                        current_arrow = (len(self.registration_queue) - len(self.prior_queue)) - 1
                        _v = v.split('->')
                        if len(_v) > current_arrow: v = _v[current_arrow]
                        else: v = _v[current_arrow % len(_v)]
                    try: fix_res_value = [int(l) for l in v[11:].split('x')]
                    except: fix_res_value = [1024, 1024]
                    NAI_width = fix_res_value[0]
                    NAI_height = fix_res_value[1]
                    after_check.remove(fix_check[i])
                elif "smea_" in v:
                    if v == "smea_on":
                        app.sema_button.select()
                    elif v == "smea_off":
                        app.sema_button.deselect()
                    after_check.remove(v)
            if '' in after_check: after_check.remove('')
            after_wildcard = ', '.join(after_check)
            gen_request = {
                "width":NAI_width,
                "height":NAI_height,
                "quality_toggle":app.auto_quality_toggle_var.get(),
                "seed": fix_seed_value,
                "sampler":_sampler,
                "noise_schedule": _noise_schedule,
                "scale":scale_pre,
                "uncond_scale":uncond_pre,
                "sema":self.sema_button.get(),
                "sema_dyn": self.dyn_button.get(),
                "cfg_rescale": rescale_pre,
                "prompt": after_wildcard,
                "negative":self.negative_prompt_input.get("0.0", "end-1c"),
                "user_screen_size": self.get_max_size(),
                "start_time": self.start_time,
                "access_token": self.access_token,
                "save_folder": self.output_file_path,
                "png_rule": self.name_var.get(),
                "type": "normal",
                "rating":self.current_prompt_rating,
                "enable_hr" : False,
                "enable_AD" : False,
                "enable_TV": False
            }
            if app.fts1 != "" and app.function_test_s1.get() == 1 and app.turbo_button.get() == 0:
                gen_request["fts1"] = app.fts1
                gen_request["fts1_val"] = app.function_test_s1_var.get()
            if app.app_mode == "NAI" and app.variety_button.get() == 1:
                gen_request["skip_cfg_above_sigma"] = True
            if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                gen_request["dynamic_thresholding"] = True
            storyteller_current = str(app.wildcard_preopen_repeat_current-1)
            if app.logic_activation.get() and self.storyteller[storyteller_current]['indiv']['isEnabled'] and 'toggle_negative' in self.storyteller[storyteller_current]['indiv'] and self.storyteller[storyteller_current]['indiv']['toggle_negative']:
                gen_request["negative"] = self.storyteller[storyteller_current]['indiv']['neg']
            if app.app_mode == "NAI": 
                gen_request["steps"] = int(app.force_steps_entry.get())
                if gen_request["steps"] > 28:
                    self.anlas_request = True
            else:
                try: gen_request["steps"] = int(self.prompt_guidance_rescale_entry.get())
                except: gen_request["steps"] = 23
            if app.app_mode == "WEBUI" and self.sema_button_var.get() == 1:
                try:
                    hr_steps_pre = int(self.hires_steps_entry.get())
                except:
                    hr_steps_pre = 16
                    self.hires_steps_entry.delete(0, "end")
                    self.hires_steps_entry.insert(0, '16')
                try:
                    upscale_pre = float(self.upscale_entry.get())
                    upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                except:
                    upscale_pre = 1.5
                self.upscale_entry.delete(0, "end")
                self.upscale_entry.insert(0, str(upscale_pre))
                try:
                    denoise_pre = float(self.denoise_entry.get())
                except:
                    denoise_pre = 0.35
                    self.denoise_entry.delete(0, "end")
                    self.denoise_entry.insert(0, '0.35')
                gen_request["enable_hr"] = True
                gen_request["hr_second_pass_steps"] = hr_steps_pre
                gen_request["hr_upscaler"] = self.hires_sampler_entry.get()
                gen_request["hr_scale"] = upscale_pre
                gen_request["denoising_strength"] = denoise_pre
            if app.app_mode == "WEBUI" and app.batch_size.get().strip() != "1":
                try : gen_request["batch_size"] = str(app.batch_size.get().strip())
                except: pass
            if app.app_mode == "WEBUI":
                if self.scheduler_isExist:
                    gen_request["scheduler"] = self.current_scheduler.get()
                if self.pag_isExist and self.pag_activate.get():
                    gen_request["pag"] = self.pag_strength.get()
            if app.app_mode == "WEBUI" and app.enable_cfg_rescale.get() == 1:
                gen_request["CFG_rescale"] = True
                cfg_str_pre = app.enable_cfg_rescale_strength.get()
                try:
                    cfg_str_pre = float(cfg_str_pre)
                    cfg_str_pre = round(cfg_str_pre, 2)
                except:
                    cfg_str_pre = 0.5
                    app.enable_cfg_rescale_strength.delete(0, "end")
                    app.enable_cfg_rescale_strength.insert(0, "0.5")
                gen_request["CFG_rescale_str"] =  cfg_str_pre
                gen_request["CFG_rescale_version"] = "normal" if app.enable_cfg_rescale_old.get() == 0 else "old"
            if app.app_mode == "WEBUI" and app.custom_script_activate_var.get() == 1: gen_request['custom_script'] = app.custom_script_text.get("1.0", "end-1c").strip()
            if app.app_mode == "WEBUI" and app.enable_DT.get() == 1:
                gen_request["DynamicThresholding"] = True
            if self.awai_activate_i2i.get() == 1:
                gen_request["enable_AD"] = True
                ad_str_pre = app.autodetailer_strength.get()
                try:
                    ad_str_pre = float(ad_str_pre)
                    ad_str_pre = round(ad_str_pre, 2)
                except:
                    ad_str_pre = 0.4
                    app.autodetailer_strength.delete(0, "end")
                    app.autodetailer_strength.insert(0, "0.4")
                gen_request["ad_data_str"] =  ad_str_pre
            if  app.app_mode == "WEBUI" and self.tiled_vae_button.get() == 1 and gen_request["enable_hr"] == True:
                gen_request["enable_TV"] = True
                tiled_vae_val = self.tiled_vae_entry.get()
                tiled_vae_val = [_key.strip() for _key in tiled_vae_val.split(',')]
                if len(tiled_vae_val) == 7:
                    try:
                        gen_request["tiled_vae_args"] = [
                            True if tiled_vae_val[0].lower() == "true" else False,
                            int(tiled_vae_val[1]),
                            int(tiled_vae_val[2]),
                            True if tiled_vae_val[3].lower() == "true" else False,
                            True if tiled_vae_val[4].lower() == "true" else False,
                            True if tiled_vae_val[5].lower() == "true" else False,
                            True if tiled_vae_val[6].lower() == "true" else False
                        ] 
                    except:
                        gen_request["enable_TV"] = False
                        gen_request["enable_hr"] = False
                        self.image_label_report.configure(state="normal")
                        self.image_label_report.delete("0.0","end")
                        self.image_label_report.insert("0.0", "<UserAttention> Tiled VAE의 Value가 잘못되었습니다 (인자의 순서가 잘못됨). 이번 생성에 hires가 적용되지 않았습니다.")
                        self.image_label_report.configure(text_color="#FFFF97")
                        self.image_label_report.configure(state="disabled")
                else:
                    gen_request["enable_TV"] = False
                    gen_request["enable_hr"] = False
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0","end")
                    self.image_label_report.insert("0.0", "<UserAttention> Tiled VAE의 Value가 잘못되었습니다 (인자는 총 7개 필요). 이번 생성에 hires가 적용되지 않았습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            try:
                if type(self.current_popped_row) != type(None) and 'xargs' in self.current_popped_row and not self.registration_queue:
                    gen_request["xargs"] = self.current_popped_row.loc["xargs"]
                    if self.series_generation and len(self.series_generation) > 1: 
                        gen_request["seed"] = int(self.series_generation[-1][2])
                        gen_request["width"], gen_request["height"] = Image.open(self.series_generation[-1][3]).size
                    if len(gen_request["xargs"]) > 4:
                        xargs = [key.strip() for key in gen_request["xargs"].split(',')]
                        xargs = NAIA_generation.process_xargs(xargs)
                        for key in xargs:
                            if len(self.series_generation) == 0 and "start_seed" in key:
                                _ss = key.split(':')
                                _ss = [_r.strip() for _r in _ss]
                                gen_request["seed"] = int(_ss[1])
                            if "reference_image" in key:
                                _rf = key.split(':')
                                _rf = [_r.strip() for _r in _rf]
                                _filename = self.series_generation[int(_rf[1])-1][3]
                                if len(_rf) >= 4:
                                    gen_request["reference_information_extracted"] = float(_rf[2])
                                    gen_request["reference_strength"] = float(_rf[3])
                                else:
                                    gen_request["reference_information_extracted"] = 1
                                    gen_request["reference_strength"] = 0.6
                                gen_request["reference_image"] = NAIA_generation.image_to_base64(Image.open(_filename))
                            elif "reset_seed" in key:
                                random_seed = random.randint(0,2**32 - 1)
                                gen_request["seed"] = random_seed
                            elif "return_seed" in key:
                                _rs = key.split(':')
                                _rs = [_r.strip() for _r in _rs]
                                seed_value = self.series_generation[int(_rs[1])-1][2]
                                gen_request["seed"] =seed_value
                            elif "rem_negative:<" in key:
                                key = key[14:-1]
                                _rn = key.split(',')
                                _rn = [_r.strip() for _r in _rn]
                                negative = [k.strip() for k in gen_request["negative"].split(',')]
                                negative = [item for item in negative if item not in _rn]
                                negative = ', '.join(negative)
                                gen_request["negative"] =negative
                            elif "add_negative:<" in key:
                                key = key[14:-1]+', '
                                _rn = key.split(',')
                                _rn = [_r.strip() for _r in _rn]
                                negative = key + gen_request["negative"]
                                gen_request["negative"] =negative
                            elif "set_resolution:" in key:
                                try: 
                                    res_str = key[15:].strip()
                                    res_str = ' '.join(res_str.replace('x', ' ').split())
                                    width, height = map(int, res_str.split())
                                    gen_request["width"], gen_request["height"] = find_max_resolution(width, height, 1048576)
                                except: 
                                    gen_request["width"], gen_request["height"] = (1024, 1024)
            except: pass

            if self.cond_negative_button_var.get() == 1:
                gen_request["cond_negative"] = self.conditional_negative_input.get("0.0", "end-1c")
            storyteller_current = str(app.wildcard_preopen_repeat_current-1)
            if app.logic_activation.get() and self.storyteller[storyteller_current]['indiv']['isEnabled'] and 'toggle_cond_neg' in self.storyteller[storyteller_current]['indiv'] and self.storyteller[storyteller_current]['indiv']['toggle_cond_neg']:
                gen_request["cond_negative"] = self.storyteller[storyteller_current]['indiv']['cond_neg']
            if self.auto_hide_add_negative.get() == 1:
                gen_request["negative"] = gen_request["negative"] + ", " + self.auto_hide_result.get("0.0", "end-1c")

            if "xargs" not in gen_request and self.irfr:
                images, ref_strengths, info_extracted = get_all_vibe_values()
                gen_request["reference_image"] = images
                gen_request["reference_information_extracted"] = info_extracted
                gen_request["reference_strength"] = ref_strengths
                if wildcard_ir_flag:
                    rem_image_reference()
                    app.set_vibe_wildcard = False

            """
            if "xargs" in self.current_popped_row:
                if "wcfix" in self.current_popped_row:
                    app.seed_fix_button.select()
                elif "hold_seed" not in self.current_popped_row["xargs"]:
                    app.seed_fix_button.deselect()
            """

            if self.turbo_button.get() == 1 and "*(split nsfw)"in gen_request["prompt"]:
                request_list = []
                for i in range(self.image_generation_repeat):
                    if i != 0: 
                        if self.hold_wildcard == False:
                            before_wildcard_turbo = self.text_input.get("0.0", "end-1c")
                            before_wildcard = [item.strip() for item in before_wildcard_turbo.split(',')]
                            if '<' in before_wildcard_turbo or '__' in before_wildcard_turbo:
                                wildcard_present = True
                                itc = 0
                                while (wildcard_present and itc < 10):
                                    if not isinstance(before_wildcard, list): 
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                    elif any(', ' in item for item in before_wildcard):
                                        temp_fixed_str = ', '.join(before_wildcard)
                                        before_wildcard = temp_fixed_str.split(', ')
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                        before_wildcard = [k.strip() for k in before_wildcard]
                                    wildcard_present = False
                                    #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                    for i, keyword in enumerate(before_wildcard):
                                        if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                            wildcard_present = True
                                            vbar_check = keyword[1:-1]
                                            if '|' in vbar_check:
                                                choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                choice_dic = {}
                                                for choice in choices:
                                                    match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                    if match:
                                                        value, keyword = float(match.group(1)), match.group(2).strip()
                                                    else:
                                                        value, keyword = 1, choice.strip()
                                                    choice_dic[keyword] = value
                                                keywords = list(choice_dic.keys())
                                                weights = list(choice_dic.values())
                                                selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                before_wildcard[i] = selected_instant_wildcard
                                                
                                    #### 단계 2 : 글로벌 와일드카드 처리 ###
                                    i = 0
                                    while i < len(before_wildcard):
                                        keyword = before_wildcard[i]
                                        if "<" in keyword and not keyword.startswith('<lora:') and ">" in keyword and "|" not in keyword or '__' in keyword:
                                            wildcard_present = True
                                            input_str = keyword.strip('<>').strip()
                                            
                                            if "__" in input_str:
                                                adjectives = re.findall(r'__(.*?)__', input_str)
                                                last_keyword = re.split(r'__.*?__', input_str)[-1]
                                                adjective_string = ""
                                                
                                                for adjective in adjectives:
                                                    adjective_result = self.get_wildcard(adjective)
                                                    if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                                        wildcard_present = True
                                                        adjective_result = adjective_result.replace("<", "__").replace(">", "__")
                                                    if adjective_result.startswith(":") and adjective_result:
                                                        if adjective_string: 
                                                            adjective_string = adjective_string.rstrip() + adjective_result  
                                                        else:  
                                                            adjective_string += adjective_result  # 전체 추가
                                                    else:
                                                        adjective_string += adjective_result + " "
                                                
                                                wc_result = self.get_wildcard(last_keyword)
                                                if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                                    wildcard_present = True
                                                    wc_result = wc_result.replace("<", "__").replace(">", "__")
                                                
                                                result = adjective_string + wc_result
                                            else:
                                                result = self.get_wildcard(input_str)
                                                if ('__' in result or ('<' in result and '>' in result)):
                                                    wildcard_present = True
                                                    result = result.replace("<", "__").replace(">", "__")
                                            
                                            # 결과에 추가 와일드카드가 있고 쉼표로 구분된 경우
                                            if ',' in result:
                                                new_items = [item.strip() for item in result.split(',')]
                                                before_wildcard[i:i+1] = new_items
                                            else:
                                                before_wildcard[i] = result
                                            i += 1
                                        else:
                                            i += 1
                                            
                                    itc += 1
                                    if not wildcard_present:
                                        break
                            else:
                                after_wildcard = self.text_input.get("0.0", "end-1c")

                            after_wildcard = ', '.join(before_wildcard)
                        cvalue = random.randint(0,2**32 - 1)
                        gen_request["seed"] = cvalue
                        gen_request["prompt"] = after_wildcard
                        cvalue = random.randint(0,2**32 - 1)
                        gen_request["seed"] = cvalue
                    pre_prompt = gen_request["prompt"]
                    pre_prompt = [keyword.strip() for keyword in pre_prompt.split(',')]
                    fix_words = self.fixed_prompt_input.get("0.0", "end-1c")+", "+self.fixed_prompt_after_input.get("0.0", "end-1c")
                    fix_words = [keyword.strip() for keyword in fix_words.split(',')]
                    if "*(split nsfw)-rand" in pre_prompt:
                        pre_prompt.remove("*(split nsfw)-rand")
                        random_seed = True
                    else:
                        pre_prompt.remove("*(split nsfw)")
                        random_seed = False
                    nsfw_word = []
                    colors = ['black','white','blond','silver','gray','yellow','blue','purple','red','pink','brown','orange','green','aqua','gradient']
                    patterns = ['polka dot', 'stripe', 'camouflage', 'plaid', 'filter', 'leotard', 'multicolored', 'strawberry', 'print', 'tone', 'trimmed', 'satin']
                    qe_word = app.data.get_qe_word() + ['cross-section', 'x-ray']
                    """ 
                    --- 의도를 파악하기 힘든 코드로 2월 24일 삭제 처리 --- # 
                    for keyword in pre_prompt: #전처리
                        if 'mouth' in keyword or 'eyes' in keyword:
                            if keyword not in fix_words:
                                pre_prompt.remove(keyword)
                    """
                    for keyword in pre_prompt:
                        if '{' not in keyword and '[' not in keyword and keyword in qe_word and all(color not in keyword for color in colors) and all(pattern not in keyword for pattern in patterns):
                            nsfw_word.append(keyword)
                    if len(nsfw_word) != 0:
                        basket = []
                        for keyword in nsfw_word:
                            if 'cross-section' in keyword or 'x-ray' in keyword:
                                if keyword not in basket: basket.append(keyword)
                        for keyword in nsfw_word:
                            if 'internal cumshot' in keyword or 'ejaculation' in keyword:
                                if keyword not in basket: basket.append(keyword)
                        for keyword in nsfw_word:
                            if 'cum' in keyword or 'ahegao' in keyword:
                                if keyword not in basket: basket.append(keyword)
                        for keyword in nsfw_word:
                            if 'after ' in keyword:
                                if keyword not in basket: basket.append(keyword)
                        for keyword in basket:
                            if keyword in nsfw_word:
                                nsfw_word.remove(keyword)
                        nsfw_word += basket
                        words = []
                        if len(nsfw_word) > 13:
                            max_val = len(nsfw_word) // 4
                            if len(nsfw_word) % 4 > 0: max_val += 1
                            for i in range(max_val):
                                current_word = []
                                if i < max_val - 1:
                                    words.append(nsfw_word[i*4])
                                    words.append(nsfw_word[i*4+1])
                                    words.append(nsfw_word[i*4+2])
                                    words.append(nsfw_word[i*4+3])
                                    current_word.append(nsfw_word[i*4])
                                    current_word.append(nsfw_word[i*4+1])
                                    current_word.append(nsfw_word[i*4+2])
                                    current_word.append(nsfw_word[i*4+3])
                                else:
                                    if len(nsfw_word) % 4 == 0:
                                        words.append(nsfw_word[i*4])
                                        words.append(nsfw_word[i*4+1])
                                        words.append(nsfw_word[i*4+2])
                                        words.append(nsfw_word[i*4+3])
                                        current_word.append(nsfw_word[i*4])
                                        current_word.append(nsfw_word[i*4+1])
                                        current_word.append(nsfw_word[i*4+2])
                                        current_word.append(nsfw_word[i*4+3])
                                    elif len(nsfw_word) % 4 == 3:
                                        words.append(nsfw_word[i*4])
                                        words.append(nsfw_word[i*4+1])
                                        words.append(nsfw_word[i*4+2])
                                        current_word.append(nsfw_word[i*4])
                                        current_word.append(nsfw_word[i*4+1])
                                        current_word.append(nsfw_word[i*4+2])
                                    elif len(nsfw_word) % 4 == 2:
                                        words.append(nsfw_word[i*4])
                                        words.append(nsfw_word[i*4+1])
                                        current_word.append(nsfw_word[i*4])
                                        current_word.append(nsfw_word[i*4+1])
                                    else:
                                        words.append(nsfw_word[i*4])
                                        current_word.append(nsfw_word[i*4])
                                gen_request_sub = copy.deepcopy(gen_request)
                                temp_prompt = []+pre_prompt
                                for keyword in nsfw_word:
                                    if keyword not in words:
                                        if random_seed == False:
                                            temp_prompt[temp_prompt.index(keyword)] = " "*len(keyword)
                                        else:
                                            temp_prompt.remove(keyword)
                                    elif keyword in current_word:
                                        temp_prompt[temp_prompt.index(keyword)] = "{"+keyword+"}"
                                gen_request_sub["prompt"] = ', '.join(temp_prompt)
                                if random_seed:
                                    gen_request_sub["seed" ] = random.randint(0,2**32 - 1)
                                request_list.append(copy.deepcopy(gen_request_sub))
                        elif len(nsfw_word) > 8:
                            max_val = len(nsfw_word) // 3
                            if len(nsfw_word) % 3 > 0: max_val += 1
                            for i in range(max_val):
                                current_word = []
                                if i < max_val - 1:
                                    words.append(nsfw_word[i*3])
                                    words.append(nsfw_word[i*3+1])
                                    words.append(nsfw_word[i*3+2])
                                    current_word.append(nsfw_word[i*3])
                                    current_word.append(nsfw_word[i*3+1])
                                    current_word.append(nsfw_word[i*3+2])
                                else:
                                    if len(nsfw_word) % 3 == 0:
                                        words.append(nsfw_word[i*3])
                                        words.append(nsfw_word[i*3+1])
                                        words.append(nsfw_word[i*3+2])
                                        current_word.append(nsfw_word[i*3])
                                        current_word.append(nsfw_word[i*3+1])
                                        current_word.append(nsfw_word[i*3+2])
                                    elif len(nsfw_word) % 3 == 2:
                                        words.append(nsfw_word[i*3])
                                        words.append(nsfw_word[i*3+1])
                                        current_word.append(nsfw_word[i*3])
                                        current_word.append(nsfw_word[i*3+1])
                                    else:
                                        words.append(nsfw_word[i*3])
                                        current_word.append(nsfw_word[i*3])
                                gen_request_sub = copy.deepcopy(gen_request)
                                temp_prompt = []+pre_prompt
                                for keyword in nsfw_word:
                                    if keyword not in words:
                                        if random_seed == False:
                                            temp_prompt[temp_prompt.index(keyword)] = " "*len(keyword)
                                        else:
                                            temp_prompt.remove(keyword)
                                    elif keyword in current_word:
                                        temp_prompt[temp_prompt.index(keyword)] = "{"+keyword+"}"
                                gen_request_sub["prompt"] = ', '.join(temp_prompt)
                                if random_seed:
                                    gen_request_sub["seed" ] = random.randint(0,2**32 - 1)
                                request_list.append(copy.deepcopy(gen_request_sub))
                        elif len(nsfw_word) > 3:
                            max_val = len(nsfw_word) // 2 + len(nsfw_word) % 2
                            for i in range(max_val):
                                current_word = []
                                if i < max_val - 1:
                                    words.append(nsfw_word[i*2])
                                    words.append(nsfw_word[i*2+1])
                                    current_word.append(nsfw_word[i*2])
                                    current_word.append(nsfw_word[i*2+1])
                                else:
                                    if len(nsfw_word) % 2 == 0:
                                        words.append(nsfw_word[i*2])
                                        words.append(nsfw_word[i*2+1])
                                        current_word.append(nsfw_word[i*2])
                                        current_word.append(nsfw_word[i*2+1])
                                    else:
                                        words.append(nsfw_word[i*2])
                                        current_word.append(nsfw_word[i*2])
                                gen_request_sub = copy.deepcopy(gen_request)
                                temp_prompt = []+pre_prompt
                                for keyword in nsfw_word:
                                    if keyword not in words:
                                        if random_seed == False:
                                            temp_prompt[temp_prompt.index(keyword)] = " "*len(keyword)
                                        else:
                                            temp_prompt.remove(keyword)
                                    elif keyword in current_word:
                                        temp_prompt[temp_prompt.index(keyword)] = "{"+keyword+"}"
                                gen_request_sub["prompt"] = ', '.join(temp_prompt)
                                if random_seed:
                                    gen_request_sub["seed" ] = random.randint(0,2**32 - 1)
                                request_list.append(copy.deepcopy(gen_request_sub))
                        else:
                            for word in nsfw_word:
                                words.append(word)
                                gen_request_sub = copy.deepcopy(gen_request)
                                temp_prompt = []+pre_prompt
                                for keyword in nsfw_word:
                                    if keyword not in words:
                                        if random_seed == False:
                                            temp_prompt[temp_prompt.index(keyword)] = " "*len(keyword)
                                        else:
                                            temp_prompt.remove(keyword)
                                    elif keyword == word:
                                        temp_prompt[temp_prompt.index(keyword)] = "{"+word+"}"
                                gen_request_sub["prompt"] = ', '.join(temp_prompt)
                                if random_seed:
                                    gen_request_sub["seed" ] = random.randint(0,2**32 - 1)
                                request_list.append(copy.deepcopy(gen_request_sub))
                    else:
                        request_list.append(gen_request)
            elif self.turbo_button.get() == 1 and self.turbo_mode == 2:
                request_list = app.turbo_transform_lines.copy()
            elif ":begin" in gen_request["prompt"] and ":seq" in gen_request["prompt"] and ":end" in gen_request["prompt"]:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.toggle_prompt_fix_button.select()
                    hold_prompt()
                request_list = []
                for i in range(self.image_generation_repeat):
                    if i != 0: 
                        if self.hold_wildcard == False:
                            before_wildcard_turbo = self.text_input.get("0.0", "end-1c")
                            before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                            if '<' in before_wildcard_turbo or '__' in before_wildcard_turbo:
                                wildcard_present = True
                                itc = 0
                                while (wildcard_present and itc < 10):
                                    if not isinstance(before_wildcard, list): 
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                    elif any(', ' in item for item in before_wildcard):
                                        temp_fixed_str = ', '.join(before_wildcard)
                                        before_wildcard = temp_fixed_str.split(', ')
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                        before_wildcard = [k.strip() for k in before_wildcard]
                                    wildcard_present = False
                                    #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                    for i, keyword in enumerate(before_wildcard):
                                        if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                            wildcard_present = True
                                            vbar_check = keyword[1:-1]
                                            if '|' in vbar_check:
                                                choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                choice_dic = {}
                                                for choice in choices:
                                                    match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                    if match:
                                                        value, keyword = float(match.group(1)), match.group(2).strip()
                                                    else:
                                                        value, keyword = 1, choice.strip()
                                                    choice_dic[keyword] = value
                                                keywords = list(choice_dic.keys())
                                                weights = list(choice_dic.values())
                                                selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                before_wildcard[i] = selected_instant_wildcard
                                                
                                    #### 단계 2 : 글로벌 와일드카드 처리 ###
                                    i = 0
                                    while i < len(before_wildcard):
                                        keyword = before_wildcard[i]
                                        if "<" in keyword and not keyword.startswith('<lora:') and ">" in keyword and "|" not in keyword or '__' in keyword:
                                            wildcard_present = True
                                            input_str = keyword.strip('<>').strip()
                                            
                                            if "__" in input_str:
                                                adjectives = re.findall(r'__(.*?)__', input_str)
                                                last_keyword = re.split(r'__.*?__', input_str)[-1]
                                                adjective_string = ""
                                                
                                                for adjective in adjectives:
                                                    adjective_result = self.get_wildcard(adjective)
                                                    if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                                        wildcard_present = True
                                                        adjective_result = adjective_result.replace("<", "__").replace(">", "__")
                                                    if adjective_result.startswith(":") and adjective_result:
                                                        if adjective_string: 
                                                            adjective_string = adjective_string.rstrip() + adjective_result  
                                                        else:  
                                                            adjective_string += adjective_result  # 전체 추가
                                                    else:
                                                        adjective_string += adjective_result + " "
                                                
                                                wc_result = self.get_wildcard(last_keyword)
                                                if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                                    wildcard_present = True
                                                    wc_result = wc_result.replace("<", "__").replace(">", "__")
                                                
                                                result = adjective_string + wc_result
                                            else:
                                                result = self.get_wildcard(input_str)
                                                if ('__' in result or ('<' in result and '>' in result)):
                                                    wildcard_present = True
                                                    result = result.replace("<", "__").replace(">", "__")
                                            
                                            # 결과에 추가 와일드카드가 있고 쉼표로 구분된 경우
                                            if ',' in result:
                                                new_items = [item.strip() for item in result.split(',')]
                                                before_wildcard[i:i+1] = new_items
                                            else:
                                                before_wildcard[i] = result
                                            i += 1
                                        else:
                                            i += 1
                                            
                                    itc += 1
                                    if not wildcard_present:
                                        break
                            else:
                                after_wildcard = self.text_input.get("0.0", "end-1c")
                            after_wildcard = ', '.join(before_wildcard)
                        cvalue = random.randint(0,2**32 - 1)
                        gen_request["seed"] = cvalue
                        gen_request["prompt"] = after_wildcard                
                    prompt_text = gen_request["prompt"]
                    if ":begin" in prompt_text and ":seq" in prompt_text and ":end" in prompt_text:
                        head_part = prompt_text.split(":begin", 1)[0].strip().rstrip(",")
                        after_part = prompt_text.split(":end", 1)[1].strip().lstrip(",")
                        middle_part = prompt_text.split(":begin", 1)[1].split(":end", 1)[0].strip().strip(",")
                        
                        body_tokens = middle_part.split(", ")
                        seq_indices = [i for i, token in enumerate(body_tokens) if ":seq" in token]
                        
                        _body = []
                        if seq_indices:
                            # :seq가 여러 개라면 각 구간별로 세그먼트 생성
                            for i in range(len(seq_indices)):
                                start_idx = seq_indices[i]
                                if i < len(seq_indices) - 1:
                                    end_idx = seq_indices[i+1]
                                else:
                                    end_idx = len(body_tokens)
                                segment = ", ".join(body_tokens[start_idx:end_idx])
                                if ":seq" in segment:
                                    parts = segment.split(":seq", 1)
                                    remaining = parts[1]
                                    m = re.search(r"[\s\n](.*)", remaining)
                                    if m:
                                        segment = m.group(1).strip()
                                    else:
                                        segment = remaining.strip()
                                _body.append(segment)
                        else:
                            # 만약 middle_part 내에 :seq가 없다면, 전체를 하나의 세그먼트로 처리
                            _body = [middle_part]
                        
                        # 각 _body 세그먼트마다 새 gen_request를 복사하여, 최종 프롬프트(_head, _body, _after)를 구성 후 request_list에 추가
                        for i, segment in enumerate(_body):
                            new_req = gen_request.copy()
                            new_prompt = ""
                            if head_part:
                                new_prompt += head_part + ", "
                            new_prompt += segment
                            if after_part:
                                new_prompt += ", " + after_part
                            new_req["prompt"] = new_prompt
                            if not self.sequence_index:
                                request_list.append(new_req)
                            else:
                                if i+1 == self.sequence_index:
                                    request_list.append(new_req)
                        self.sequence_index = None

                    app.turbo_button.select()
                    app.turbo_mode = 1
                    app.turbo_is_seq = True
            elif self.turbo_button.get() == 1:
                request_list = []
                for i in range(self.image_generation_repeat):
                    if i != 0: 
                        if self.hold_wildcard == False:
                            before_wildcard_turbo = self.text_input.get("0.0", "end-1c")
                            before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                            if '<' in before_wildcard_turbo or '__' in before_wildcard_turbo:
                                wildcard_present = True
                                itc = 0
                                while (wildcard_present and itc < 10):
                                    if not isinstance(before_wildcard, list): 
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                    elif any(', ' in item for item in before_wildcard):
                                        temp_fixed_str = ', '.join(before_wildcard)
                                        before_wildcard = temp_fixed_str.split(', ')
                                        before_wildcard = NAIA_random_function_core.process_fix_prompt(before_wildcard)
                                        before_wildcard = [k.strip() for k in before_wildcard]
                                    wildcard_present = False
                                    #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                    for i, keyword in enumerate(before_wildcard):
                                        if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                            wildcard_present = True
                                            vbar_check = keyword[1:-1]
                                            if '|' in vbar_check:
                                                choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                choice_dic = {}
                                                for choice in choices:
                                                    match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                    if match:
                                                        value, keyword = float(match.group(1)), match.group(2).strip()
                                                    else:
                                                        value, keyword = 1, choice.strip()
                                                    choice_dic[keyword] = value
                                                keywords = list(choice_dic.keys())
                                                weights = list(choice_dic.values())
                                                selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                before_wildcard[i] = selected_instant_wildcard
                                                
                                    #### 단계 2 : 글로벌 와일드카드 처리 ###
                                    i = 0
                                    while i < len(before_wildcard):
                                        keyword = before_wildcard[i]
                                        if "<" in keyword and not keyword.startswith('<lora:') and ">" in keyword or '__' in keyword:
                                            wildcard_present = True
                                            input_str = keyword.strip('<>').strip()
                                            
                                            if "__" in input_str:
                                                adjectives = re.findall(r'__(.*?)__', input_str)
                                                last_keyword = re.split(r'__.*?__', input_str)[-1]
                                                adjective_string = ""
                                                
                                                for adjective in adjectives:
                                                    adjective_result = self.get_wildcard(adjective)
                                                    if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                                        wildcard_present = True
                                                        adjective_result = adjective_result.replace("<", "__").replace(">", "__")
                                                    if adjective_result.startswith(":") and adjective_result:
                                                        if adjective_string: 
                                                            adjective_string = adjective_string.rstrip() + adjective_result  
                                                        else:  
                                                            adjective_string += adjective_result  # 전체 추가
                                                    else:
                                                        adjective_string += adjective_result + " "
                                                
                                                wc_result = self.get_wildcard(last_keyword)
                                                if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                                    wildcard_present = True
                                                    wc_result = wc_result.replace("<", "__").replace(">", "__")
                                                
                                                result = adjective_string + wc_result
                                            else:
                                                result = self.get_wildcard(input_str)
                                                if ('__' in result or ('<' in result and '>' in result)):
                                                    wildcard_present = True
                                                    result = result.replace("<", "__").replace(">", "__")
                                            
                                            # 결과에 추가 와일드카드가 있고 쉼표로 구분된 경우
                                            if ',' in result:
                                                new_items = [item.strip() for item in result.split(',')]
                                                before_wildcard[i:i+1] = new_items
                                            else:
                                                before_wildcard[i] = result
                                            i += 1
                                        else:
                                            i += 1
                                            
                                    itc += 1
                                    if not wildcard_present:
                                        break
                            else:
                                after_wildcard = self.text_input.get("0.0", "end-1c")
                            after_wildcard = ', '.join(before_wildcard)
                        cvalue = random.randint(0,2**32 - 1)
                        gen_request["seed"] = cvalue
                        gen_request["prompt"] = after_wildcard
                    try:
                        treq_0, treq_1, treq_2, treq_3 = NAIA_generation.make_turbo_prompt(gen_request)
                        request_list.append(gen_request.copy())
                        request_list.append(treq_0)
                        request_list.append(treq_1)
                        request_list.append(treq_2)
                        request_list.append(treq_3)
                    except:
                        request_list.append(gen_request)
            else:
                pre_prompt = gen_request["prompt"]
                pre_prompt = [keyword.strip() for keyword in pre_prompt.split(',')]
                if "*(split nsfw)-rand" in pre_prompt:
                    pre_prompt.remove("*(split nsfw)-rand")
                gen_request["prompt"] = ', '.join(pre_prompt)
            #3/7
            if app.app_mode == "NAI" and app.turbo_mode == 3 and app.turbo_button.get() == 1 and app.reference_list:
                if len(app.reference_list) != len(app.reference_list_ie) or len(app.reference_list) != len(app.reference_list_irs):
                    app.reference_list = []
                    app.reference_list_ie = []
                    app.reference_list_irs = []
                gen_request["reference_image"] = app.reference_list
                gen_request["reference_information_extracted"] = app.reference_list_ie
                gen_request["reference_strength"] = app.reference_list_irs
                if app.event_current and app.event_reorder_checkbox.get()==1:
                    if app.wildcard_preopen_repeat_current-1 in app.event_current and 'difference' in app.event_current[app.wildcard_preopen_repeat_current-1] and app.event_current[app.wildcard_preopen_repeat_current-1]['difference'] > 15:
                        gen_request["reference_information_extracted"] = [round(v*0.7, 2) for v in gen_request["reference_information_extracted"]]
                        gen_request["reference_strength"] = [round(v*0.5, 2) for v in gen_request["reference_strength"]]
            if self.app_mode == "NAI" and self.webui_guide_button.get() == 1:
                if self.guide_vibe.get() == 1:
                    try: 
                        images, ref_strengths, info_extracted = get_all_vibe_values()
                        gen_request["reference_image"] = images
                        gen_request["reference_information_extracted"] = info_extracted
                        gen_request["reference_strength"] = ref_strengths
                    except: pass
                if self.guide_i2i.get() == 1:
                    gen_request["type"] = "upper"
                    try: 
                        gen_request["image"] = NAIA_generation.image_to_base64(self.temp_guide_image)
                        gen_request["strength"] = self.webui_guide_setting["i2i_strength"]
                        gen_request["noise"] = 0
                        gen_request["steps"] = 28
                    except: pass
            def run_generation(gen_request):
                if gen_request["png_rule"] == "count":
                    self.generation_count += 1
                    gen_request["count"] =self.generation_count
                if app.auto_count_left_flag == True:
                    app.auto_count_left -= 1
                if app.event_current and app.event_reorder_checkbox.get()==1:
                    if len(app.image_queue) >= 1 and app.wildcard_preopen_repeat_current-1 in app.event_current and 'rem' in app.event_current[app.wildcard_preopen_repeat_current-1]:
                        temp_rm = []
                        rem = app.event_current[app.wildcard_preopen_repeat_current-1]['rem'].copy()
                        for k in app.event_current[app.wildcard_preopen_repeat_current-1]['rem']:
                            if k not in app.image_queue[-1][1]:
                                temp_rm.append(k)
                        for k in temp_rm:
                            if k in rem: 
                                rem.remove(k)
                        gen_request['negative'] = gen_request['negative'] + ', [[' + ', '.join(rem)+']]'
                if self.image_generation_repeat_flag == True:
                    gen_request["repeat"] = self.image_generation_repeat_current -1
                    gen_request["repeat_max"] = self.image_generation_repeat
                if self.running_flag:
                    app.generation_queue.append(copy.deepcopy(gen_request))
                    app.image_generation_button.configure(text=f"생성 큐에 삽입 ({len(app.generation_queue)})", state="normal")
                    return
                else: 
                    if self.automation_button.get() == 0 and self.auto_i2i_vibe.get() == 0 and not self.turbo_button.get() == 1: 
                        app.image_generation_button.configure(text=f"생성 큐에 삽입 (0)", state="normal")
                if app.auto_i2i_vibe.get() == 1:
                    app.auto_i2i_text = self.text_input.get("0.0", "end-1c")
                else:
                    app.auto_i2i_text = ""
                while True:
                    pass_bit = False
                    retry_count = 0
                    self.turbo_button.configure(state="disabled")
                    if app.save_folder_option and app.save_folder_option["isEnabled"]:
                        if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                        if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                        try:
                            gen_request["additional_save_folder"] = { 
                                "command1": app.save_folder_additional_name["command1"],
                                "command2": app.save_folder_additional_name["command2"]
                                }
                        except:
                            gen_request["additional_save_folder"] = { 
                                "command1": "",
                                "command2": ""
                                }                            
                        app.save_folder_additional_name = {}
                    while(not pass_bit):
                        self.running_flag = True
                        self.state_label.configure(text ="state : 이미지 생성 대기중 ... ", text_color = "#FFFF97")
                        if app.turbo_button.get() == 1 and app.turbo_mode == 3 and ("fix_seed" in app.event_option and app.event_option["fix_seed"]):
                            app.random_function_button.configure(state="disabled")
                        if "batch_size" not in gen_request or gen_request["batch_size"] == 1:
                            if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                            if app.anlas_request and app.access_token_muiti:
                                if app.my_anlas.get() > app.my_anlas_multi.get(): gen_request["access_token"] = app.access_token
                                else:gen_request["access_token"] = app.access_token_muiti
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                                gen_request['characters'] = app.nai4_character_list
                                gen_request['characters_uc'] = app.nai4_character_uc_list
                                gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                                gen_request['characters_pos_list'] = app.naid4_positions
                                gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                                if app.eye_catch.get() == 1: 
                                    gen_request["eye_catch"] = True
                                if type(app.current_popped_row) != type(None) and not app.current_popped_row.empty and app.wildacrd_standalone.get() == 0 and app.toggle_prompt_fix_button.get() == 0:
                                    gen_request["eye_catch_prompt"] = [k for k in app.current_popped_row['general'].split(', ')]
                            if type(self.generated_popped_row) != type(None) and not self.generated_popped_row.empty: self.generated_popped_row_freezed = self.generated_popped_row.copy()
                            else: self.generated_popped_row_freezed = None
                            result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                            app.nai_generation_count += 1
                            result_list = None
                        else:
                            start_time = time.time()
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                                gen_request['characters'] = app.nai4_character_list
                                gen_request['characters_uc'] = app.nai4_character_uc_list
                                gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                                gen_request['characters_pos_list'] = app.naid4_positions
                                gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                                if app.eye_catch.get() == 1: 
                                    gen_request["eye_catch"] = True
                                if type(app.current_popped_row) != type(None) and not app.current_popped_row.empty and app.wildacrd_standalone.get() == 0 and app.toggle_prompt_fix_button.get() == 0:
                                    gen_request["eye_catch_prompt"] = [k for k in app.current_popped_row['general'].split(', ')]
                            result_list = NAIA_generation.generate(gen_request, app.current_model_nai.get())[4]
                            end_time = time.time()
                            if len(result_list) != 1 and not isinstance(result_list[1], str) : 
                                result_image, result_prompt, result_seed, info, filename = result_list.pop(0)
                            else: 
                                result_image, result_prompt, result_seed, info, filename, response_time = result_list
                                result_list = None
                            response_time = round(end_time - start_time, 2)
                        if app.turbo_button.get() == 1 and app.turbo_mode == 3 and "fix_seed" in app.event_option and  app.event_option["fix_seed"]:
                            app.random_function_button.configure(state="normal")
                        self.state_label.configure(text =f"작업 완료!  RT : {response_time}s", text_color = "#DCE4EE")
                        app.image_generation_button.configure(border_width = 0)
                        if self.anlas_request:
                            self.anlas_request = False
                            self.get_anlas()
                        if info:
                            self.error_count = 0
                            temp = naia_functions.extract_prompt_info(info, app.app_mode)
                            if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                            pass_bit = True
                        else:
                            if self.random_artist_window_rf_request:
                                self.random_artist_window_rf_request = None
                                self.random_artist_window_rf_button.configure(state="normal")
                            self.error_count += 1
                            retry_count += 1
                            if self.error_count >= 10:
                                self.automation_button.deselect()
                            temp = result_prompt
                            if self.automation_button.get() == 1:
                                try: response_time 
                                except: response_time = 11.4
                                if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                                else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                                if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                                if instant_wait < 0 : instant_wait = 0.5
                                time.sleep(instant_wait)
                            else:
                                time.sleep(1)
                            if self.automation_button.get() == 0 or retry_count >= 5:
                                break
                    self.running_flag = False
                    if not app.generation_queue:
                        self.turbo_button.configure(state="normal")
                    naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                    if app.turbo_button.get() == 1 and app.turbo_mode == 3:
                        app.event_turbo3_already_run = True
                        if app.random_function_pressed == True:
                            app.random_function_pressed = False
                    if app.turbo_button.get() == 1 and app.turbo_mode == 3 and "rem_prev" in app.event_option and app.event_option["rem_prev"] and len(app.image_queue) > 1 and result_prompt == app.image_queue[len(app.image_queue)-1][1]:
                        image_history_0_yield()
                        delete_image()
                    if result_image:
                        if app.state() != 'zoomed':
                            instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                        else:
                            current_image = Image.open(filename)
                            new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                            instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                        if self.random_artist_window_rf_request:
                            self.random_artist_window_rf_request.configure(image=customtkinter.CTkImage(result_image, size=(781,781)))
                            self.random_artist_window_rf_request = None
                            self.random_artist_window_rf_button.configure(state="normal")
                            self.random_artist_window_rf_button = None
                            try:
                                self.random_artist_loop_check()
                            except:
                                pass
                        self.image_label.configure(image=instant_result_image)
                        if app.rm_not_nsfw_button.get() and app.nsfw_window.state() != 'withdrawn': app.nsfw_image_label.configure(image=customtkinter.CTkImage(result_image, size=(360,360)))
                        set_image_to_queue(result_image, result_prompt, result_seed, filename)
                        if self.app_mode == "WEBUI" and result_list:
                            image_list = []
                            image_list.append(Image.open(filename))
                            while(result_list):
                                result_image, result_prompt, result_seed, info, filename = result_list.pop(0)
                                set_image_to_queue(result_image, result_prompt, result_seed, filename)
                                image_list.append(Image.open(filename))
                            concat_image = self.create_square_image(image_list)
                            if app.state() != 'zoomed':
                                instant_result_image = customtkinter.CTkImage(concat_image, size=(620,620))
                            else:
                                new_image = self.resize_and_center_image(concat_image, self.wide_res_width, self.wide_res_height)
                                instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                            self.image_label.configure(image=instant_result_image)
                        if app.turbo_button.get() == 1 and app.turbo_mode == 3 and app.wildcard_preopen_repeat_current <= app.wildcard_preopen_repeat - 1:
                            if pd.isna(app.current_popped_row["parent_id"]):
                                ev_id = int(app.current_popped_row["id"])
                                _items = app.event_image_view_listbox.get(0, tk.END)
                                if ev_id in _items:
                                    _index = _items.index(ev_id)
                                    app.event_image_view_listbox.delete(_index)
                                app.event_image_view_listbox.insert(0, ev_id)
                            else: ev_id = int(app.current_popped_row["parent_id"])
                            try:
                                with open(f't3_event/{ev_id}', 'r', encoding='utf-8') as f:
                                    ev_list = json.load(f)
                            except FileNotFoundError: ev_list = {}
                            except json.JSONDecodeError: ev_list = {}
                            image_bytes = io.BytesIO()
                            ev_image = result_image.resize((256,256))
                            ev_image = ev_image.convert('RGB')
                            ev_image.save(image_bytes, format='JPEG', quality=90)
                            image_bytes = base64.b64encode(image_bytes.getvalue()).decode('utf-8')
                            ev_list[app.wildcard_preopen_repeat_current - 1] = image_bytes
                            if "text" not in ev_list:
                                ev_list["text"] = app.event_current["text"]
                            with open(f't3_event/{ev_id}', 'w', encoding='utf-8') as f:
                                json.dump(ev_list, f, ensure_ascii=False, indent=4)
                            if ev_id == app.event_image_view_listbox.get(0) and int(app.event_viewer_textbox.get("1.0", "2.0").strip().replace("parent:", "")) == ev_id:
                                app.event_image_view_listbox.select_set(0)
                                app.event_image_view_listbox.event_generate('<<ListboxSelect>>')
                            _filename = app.image_queue[len(app.image_queue)-1][3]
                            if app.app_mode == "NAI":
                                if len(app.image_queue) > 1 and result_prompt != app.image_queue[len(app.image_queue)-2][1] and app.wildcard_preopen_repeat_current != app.wildcard_preopen_repeat -1:
                                    if len(app.reference_list) >= 1 and app.event_option["ie_irs_voltile"]:
                                        for i, v in enumerate(app.reference_list_irs):
                                            if app.reference_list_irs[i] > app.event_option["irs_voltile"]:
                                                app.reference_list_irs[i] = round(v - app.event_option["irs_voltile"], 2)
                                        for i, v in enumerate(app.reference_list_ie):
                                            if app.reference_list_ie[i] > app.event_option["ie_voltile"]:
                                                app.reference_list_ie[i] = round(v - app.event_option["ie_voltile"], 2)
                                    if app.event_yolo_checkbox.get():
                                        start_time = time.time()
                                        app.reference_list.append(process_image_with_yolo(_filename))
                                        end_time = time.time()
                                        response_time += round(end_time - start_time, 2)
                                        self.state_label.configure(text =f"YOLO 처리 완료!  RT : {round(response_time, 2)}s", text_color = "#DCE4EE")
                                    else:
                                        app.reference_list.append(NAIA_generation.image_to_base64(Image.open(_filename)))
                                    app.reference_list_ie.append(app.event_option["ie_value"])
                                    app.reference_list_irs.append(app.event_option["irs_value"])
                                else:
                                    if app.wildcard_preopen_repeat_current == app.wildcard_preopen_repeat -1:
                                        pass              
                                    else:
                                        if app.event_yolo_checkbox.get():
                                            start_time = time.time()
                                            app.reference_list.append(process_image_with_yolo(_filename))
                                            end_time = time.time()
                                            response_time += round(end_time - start_time, 2)
                                            self.state_label.configure(text =f"YOLO 처리 완료!  RT : {round(response_time, 2)}s", text_color = "#DCE4EE")
                                        else:
                                            app.reference_list.append(NAIA_generation.image_to_base64(Image.open(_filename)))
                                        app.reference_list_ie.append(app.event_option["ie_value"])
                                        app.reference_list_irs.append(app.event_option["irs_value"])
                                if len(app.reference_list) > app.event_option["multivibe_max"]:
                                    app.reference_list.pop(0)
                                    app.reference_list_ie.pop(0)
                                    app.reference_list_irs.pop(0)
                    #자동화 체크
                    if not app.generation_queue:
                        app.image_generation_button.configure(text="NAI 이미지 생성")
                        if self.automation_button.get() == 1:
                            self.image_generation_button.configure(state="disabled")
                            try: response_time 
                            except: response_time = 11.4
                            if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                            else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                            if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                            if instant_wait < 0 : instant_wait = 0.5
                            if self.image_generation_repeat > 1 and self.hold_wildcard == False and (self.image_generation_repeat > self.image_generation_repeat_current):
                                pass
                            elif self.image_generation_repeat_flag == False or (self.image_generation_repeat <= self.image_generation_repeat_current):
                                self.image_generation_repeat_current = 0
                                self.image_generation_repeat_flag = False
                                if self.toggle_prompt_fix_button.get() == 0:
                                    if not (self.webui_guide_button.get() == 1 or (self.app_mode == "NAI" and self.guide_i2i.get() == 1) or (self.turbo_button.get() == 1 and self.turbo_mode == 2)):
                                        try: random_function()
                                        except: self.random_function_button.configure(state="normal", command=_random_function)
                                        if app.turbo_button.get() == 1 and app.turbo_mode == 3 and app.event_viewer_checkbox.get() == 1:
                                            app.event_skip_button.configure(state="normal")
                                            app.event_jump_button.configure(state="normal")
                                        if app.app_mode == "NAI" : 
                                            if self.logic_activation.get() == 1  and app.wildcard_preopen_repeat_current != 1 and app.wildcard_preopen_repeat != app.wildcard_preopen_repeat_current - 1 and app.wildcard_preopen_repeat_current != 0 and app.storyteller[str(app.wildcard_preopen_repeat_current - 2)]['vibe']:
                                                #if self.image_reference: rem_image_reference()
                                                try: set_image_reference(Image.open(filename))
                                                except: pass
                                            elif self.logic_activation.get() == 1  and app.wildcard_preopen_repeat_current == 1:
                                                if self.irfr: clear_all_vibe_frames()
                            #반복생성 처리구문, 트래킹 필요
                            evinpaint_exist = False
                            while(instant_wait > 0):
                                if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                                else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                                if instant_wait >= 1:
                                    time.sleep(1)
                                    if self._evinpaint_flag == True: 
                                        instant_wait += 1.35
                                        evinpaint_exist = True
                                else:
                                    time.sleep(instant_wait)
                                    if self.dtg_flag == True: instant_wait += 1
                                    if evinpaint_exist == True:
                                        random_function()
                                        if self._evinpaint_flag == True: 
                                            try: response_time 
                                            except: response_time = 11.4
                                            if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                                            else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                                            if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                                instant_wait -= 1
                            if app.app_mode == "NAI" : self.image_generation_button.configure(text="NAI 이미지 생성")
                            else: self.image_generation_button.configure(text="WEBUI 생성 요청")
                            if app.auto_i2i_vibe.get() == 1:
                                self.current_window = self.window
                                instant_img2img(self, app.access_token, None, False, "auto_i2i")
                                while(self.instant_i2i_state):
                                    time.sleep(1)
                                try: response_time 
                                except: response_time = 11.4
                                if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                                else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                                if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                                while(instant_wait > 0):
                                    if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                                    else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                                    if instant_wait >= 1:
                                        time.sleep(1)
                                    else:
                                        time.sleep(instant_wait)
                                    instant_wait -= 1
                            if app.turbo_button.get() == 1 and app.turbo_mode != 3:
                                return
                            if self.automation_button.get() == 1:
                                self.event_generate(GENERATE_EVENT, when="tail")
                            else:
                                self.image_generation_button.configure(state="normal")
                        else:
                            if app.turbo_button.get() == 1 and app.turbo_mode == 3 and app.event_viewer_checkbox.get() == 1:
                                app.event_skip_button.configure(state="normal")
                                app.event_jump_button.configure(state="normal")
                            if app.auto_i2i_vibe.get() == 1:
                                self.image_generation_button.configure(state="disabled")
                                try: response_time 
                                except: response_time = 11.4
                                if self.lazymode: instant_wait = random.uniform(0.5, 2.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                                else: instant_wait = random.uniform(0.5, 2.5) + self.delay_offset + (11.4 - response_time)
                                if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                                while(instant_wait > 0):
                                    if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                                    else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                                    if instant_wait >= 1:
                                        time.sleep(1)
                                    else:
                                        time.sleep(instant_wait)
                                    instant_wait -= 1
                                instant_img2img(self, app.access_token, None, False, "auto_i2i")
                                while(self.instant_i2i_state):
                                    time.sleep(1)
                                time.sleep(2)
                                if app.app_mode == "NAI" : self.image_generation_button.configure(text="NAI 이미지 생성")
                                else: self.image_generation_button.configure(text="WEBUI 생성 요청")
                            self.image_generation_repeat_current = 0
                            self.image_generation_repeat_flag = False
                            self.image_generation_button.configure(state="normal")
                        return
                    else:
                        if app.auto_i2i_vibe.get() == 1:
                            self.image_generation_button.configure(state="disabled")
                            try: response_time 
                            except: response_time = 11.4
                            if self.lazymode: instant_wait = random.uniform(0.5, 2.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                            else: instant_wait = random.uniform(0.5, 2.5) + self.delay_offset + (11.4 - response_time)
                            if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                            while(instant_wait > 0):
                                if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                                else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                                if instant_wait >= 1:
                                    time.sleep(1)
                                else:
                                    time.sleep(instant_wait)
                                instant_wait -= 1
                            instant_img2img(self, app.access_token, None, False, "auto_i2i")
                            while(self.instant_i2i_state):
                                time.sleep(1)
                        time.sleep(1)
                        gen_request = app.generation_queue.pop(0)
                        if len(app.generation_queue) > 0:
                            app.image_generation_button.configure(text=f"생성 큐에 삽입 ({len(app.generation_queue)})")
                        else:
                            app.image_generation_button.configure(text="NAI 이미지 생성")

            def run_generation_turbo(gen_request):
                if gen_request["png_rule"] == "count":
                    self.generation_count += 1
                    gen_request["count"] =self.generation_count
                if app.auto_count_left_flag == True:
                    app.auto_count_left -= 1      
                if "batch_size" in gen_request: del(gen_request["batch_size"])
                app.image_generation_button.configure(border_width = 2, state="disabled")
                pass_bit = False
                retry_count = 0
                if app.save_folder_option and app.save_folder_option["isEnabled"]:
                    if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                        app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                    elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                    else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                    if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                        app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                    elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                    else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                    try:
                        gen_request["additional_save_folder"] = { 
                            "command1": app.save_folder_additional_name["command1"],
                            "command2": app.save_folder_additional_name["command2"]
                            }
                    except:
                        gen_request["additional_save_folder"] = { 
                            "command1": "",
                            "command2": ""
                            }                     
                    app.save_folder_additional_name = {}
                self.running_flag = True
                while(not pass_bit):
                    self.state_label.configure(text ="state : 이미지 생성 대기중 (EXP.turbo) ... ", text_color = "#FFFF97")
                    if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                    if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                        gen_request['characters'] = app.nai4_character_list
                        gen_request['characters_uc'] = app.nai4_character_uc_list
                        gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                        gen_request['characters_pos_list'] = app.naid4_positions
                        gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                        if app.eye_catch.get() == 1: 
                            gen_request["eye_catch"] = True
                        if type(app.current_popped_row) != type(None) and not app.current_popped_row.empty and app.wildacrd_standalone.get() == 0 and app.toggle_prompt_fix_button.get() == 0:
                            gen_request["eye_catch_prompt"] = [k for k in app.current_popped_row['general'].split(', ')]
                    if type(self.generated_popped_row) != type(None) and not self.generated_popped_row.empty: self.generated_popped_row_freezed = self.generated_popped_row.copy()
                    else: self.generated_popped_row_freezed = None
                    result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                    self.nai_generation_count += 1
                    self.state_label.configure(text =f"작업 완료!  RT : {response_time}s", text_color = "#DCE4EE")
                    app.image_generation_button.configure(border_width = 0)
                    if info:
                        self.error_count = 0
                        temp = naia_functions.extract_prompt_info(info, app.app_mode)
                        if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                        pass_bit = True
                    else:
                        self.error_count += 1
                        retry_count += 1
                        if self.error_count >= 10:
                            self.automation_button.deselect()
                            self.turbo_button.deselect()
                        temp = result_prompt
                        if self.automation_button.get() == 1:
                            try: response_time 
                            except: response_time = 11.4
                            if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                            else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                            if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                            if instant_wait < 0 : instant_wait = 0.5
                            time.sleep(instant_wait)
                        else:
                            time.sleep(1)
                        if self.turbo_button.get() == 0 or retry_count >= 5:
                            break
                self.running_flag = False
                naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                if result_image:
                    if app.state() != 'zoomed':
                        instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                    else:
                        current_image = Image.open(filename)
                        new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                        instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                    if app.rm_not_nsfw_button.get() and app.nsfw_window.state() != 'withdrawn': app.nsfw_image_label.configure(image=customtkinter.CTkImage(result_image, size=(360,360)))
                    set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                try: response_time 
                except: response_time = 11.4
                if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                if app.automation_button.get() == 0: instant_wait = 0.5
                if instant_wait < 0 : instant_wait = 0.5
                while(instant_wait > 0):
                    if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                    else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                    if instant_wait >= 1:
                        time.sleep(1)
                    else:
                        time.sleep(instant_wait)
                        if self.dtg_flag == True: instant_wait += 1
                    instant_wait -= 1
                if app.auto_i2i_vibe.get() == 1:
                    instant_img2img(self, app.access_token, None, False, "auto_i2i")
                    while(self.instant_i2i_state):
                        time.sleep(1)
                    try: response_time 
                    except: response_time = 11.4
                    if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                    else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                    if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                    while(instant_wait > 0):
                        if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                        else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                        if instant_wait >= 1:
                            time.sleep(1)
                        else:
                            time.sleep(instant_wait)
                        instant_wait -= 1
                if app.app_mode == "NAI" : self.image_generation_button.configure(text="NAI 이미지 생성")
                else: self.image_generation_button.configure(text="WEBUI 생성 요청")

            def run_turbo_transform(line, pfilename):
                def process_prompt(prompt):
                    tokens = self.s_token.encode(prompt)
                    if len(tokens) > 62:
                        app.image_label_report.configure(state="normal")
                        app.image_label_report.delete("0.0", "end")
                        app.image_label_report.configure(text_color="#DCE4EE")
                        _ex = len(tokens) - 62
                        app.image_label_report.insert("0.0", f"토큰 수가 {_ex}만큼 초과됩니다. Director Tool의 Emotion Prompt는 60 ~ 62개의 토큰을 허용합니다. 초과된 토큰은 자동으로 제외되지만 'Response' object has no attribute 'decode' 오류가 발생한다면 프롬프트 토큰을 더 줄이시기 바랍니다. (일반적으로 4바이트(알파벳 4개)당 1토큰으로 간주됩니다.)")
                        app.image_label_report.configure(state="disabled")
                    while len(tokens) > 62:
                        last_comma = prompt.rfind(',')
                        if last_comma == -1:
                            prompt = prompt[:62]
                        else:
                            prompt = prompt[:last_comma]
                        tokens = self.s_token.encode(prompt)
                    return prompt
                self.image_generation_button.configure(state="disabled")
                self.transform_button.configure(state="disabled")
                img = Image.open(pfilename)
                width, height = img.size
                prompt = line[1]
                defry = self.defry_value.get()
                defry_list = ["Normal", "Slightly Weak", "Weak", "Even Weaker", "Very Weak", "Weakest"]
                if ';' in prompt:
                    before_semicolon, after_semicolon = prompt.split(';', 1)
                    before_semicolon = before_semicolon.strip()
                    after_semicolon = after_semicolon.strip().title()            
                    if after_semicolon in defry_list:
                        defry = after_semicolon
                        prompt = before_semicolon
                if self.last_call_character != "":
                    prompt = self.last_call_character + ', ' + prompt
                gen_request = {
                    "save_folder": app.output_file_path,
                    "png_rule": app.name_var.get(),
                    "access_token" : app.access_token,
                    "mode":line[0],
                    "defry": defry,
                    "prompt": process_prompt(prompt),
                    "width" : width,
                    "height" : height,
                    "image" : img,
                    "user_screen_size": app.get_max_size(),
                    "start_time": app.start_time
                }
                def q_run_generation():
                    if gen_request["png_rule"] == "count":
                        app.generation_count += 1
                        gen_request["count"] =app.generation_count
                    app.running_flag = True
                    pass_bit = False
                    retry_count = 0
                    if app.save_folder_option and app.save_folder_option["isEnabled"]:
                        if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                        if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                        try:
                            gen_request["additional_save_folder"] = { 
                                "command1": app.save_folder_additional_name["command1"],
                                "command2": app.save_folder_additional_name["command2"]
                                }
                        except:
                            gen_request["additional_save_folder"] = { 
                                "command1": "",
                                "command2": ""
                                }                     
                        app.save_folder_additional_name = {}
                    if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                    while(not pass_bit):
                        app.state_label.configure(text ="state : Director Tool 요청됨 (Turbo) ", text_color = "#FFFF97")
                        result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.augment_image_NAI(gen_request)
                        app.running_flag = False
                        app.nai_generation_count += 1
                        self.state_label.configure(text =f"Director Tool 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                        app.image_generation_button.configure(border_width = 0)
                        if info:
                            self.error_count = 0
                            temp = naia_functions.extract_prompt_info(info, app.app_mode)
                            if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                            pass_bit = True
                            if result_image:
                                if app.state() != 'zoomed':
                                    instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                                else:
                                    current_image = Image.open(filename)
                                    new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                                    instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                                app.image_label.configure(image=instant_result_image)
                                app.ext_set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                        else:
                            self.error_count += 1
                            retry_count += 1
                            if self.error_count >= 10:
                                self.automation_button.deselect()
                                self.turbo_button.deselect()
                            temp = result_prompt
                        self.control_pressed = False
                        app.running_flag = False
                        app.state_label.configure(text =f"state : Director Tool 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                        if info:
                            temp = naia_functions.extract_prompt_info(info, app.app_mode)
                            if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                        else:
                            temp = result_prompt
                        naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                        if self.automation_button.get() == 1 or self.turbo_button.get() == 1:
                            try: response_time 
                            except: response_time = 11.4
                            if self.lazymode: instant_wait = random.uniform(3.5, 5.5) + random.uniform(0, self.delay_offset) + (11.4 - response_time)
                            else: instant_wait = random.uniform(3.5, 5.5) + self.delay_offset + (11.4 - response_time)
                            if app.app_mode == "NAI" and app.access_token_muiti: instant_wait -= 7.6
                            while(instant_wait > 0):
                                if app.app_mode == "NAI" : self.image_generation_button.configure(text=f"NAI 이미지 생성 ({round(instant_wait)})")
                                else:  self.image_generation_button.configure(text=f"WEBUI 생성 요청 ({round(instant_wait)})")
                                if instant_wait >= 1:
                                    time.sleep(1)
                                else:
                                    time.sleep(instant_wait)
                                instant_wait -= 1
                        self.image_generation_button.configure(state="normal")
                        self.transform_button.configure(state="normal")
                        if self.turbo_button.get() == 0 or retry_count >= 5:
                            break
                generation_thread = threading.Thread(target=q_run_generation, daemon=True)
                generation_thread.start()
                generation_thread.join()

            def turbo_transform_request(gen_request):
                turbo_count = 0
                while(request_list): #0223 수정 :  
                    if app.app_mode == "NAI":
                        if turbo_count == 1 or (turbo_count >= 1 and app.use_cont_image.get() == 1):
                            _filename = app.image_queue[len(app.image_queue)-1][3]
                        if turbo_count == 2 and app.use_first_image.get() == 1:
                            _filename = app.image_queue[len(app.image_queue)-1][3]
                    if turbo_count == 0:
                        generation_thread = threading.Thread(target=run_generation, args=(gen_request,), daemon=True)
                        generation_thread.start()
                        generation_thread.join()
                    else:
                        if app.running_flag:
                            time.sleep(1)
                            continue
                        line = request_list.pop(0)
                        line1 = [key.strip() for key in line[1].split(',')]
                        if "(reassign)" in line1:
                            line1.remove("(reassign)")
                            _filename = app.image_queue[len(app.image_queue)-1][3]
                        if "tentacle sex" in gen_request["prompt"]:
                            if "sex" in line1: line1[line1.index("sex")] = "tentacle sex"
                            if "penis" in line1: line1[line1.index("penis")] = "penis tentacle"
                        line = (line[0], ', '.join(line1))
                        transform_thread = threading.Thread(target=run_turbo_transform, args=(line, _filename,), daemon=True)
                        transform_thread.start()
                        transform_thread.join()
                    turbo_count += 1
                    if app.turbo_button.get() == 0:
                        app.state_label.configure(text =f"state : 사용자에 의한 터보요청 중단 ({turbo_count})", text_color = "#FFFF97")
                        self.image_generation_button.configure(state="normal")
                        break
                self.last_call_character = ""
                if self.automation_button.get() == 1:
                    if self.toggle_prompt_fix_button.get() == 0:
                        if not (self.webui_guide_button.get() == 1 or (self.app_mode == "NAI" and self.guide_i2i.get() == 1)):
                            try: random_function()
                            except: self.random_function_button.configure(state="normal", command=_random_function)
                    self.event_generate(GENERATE_EVENT, when="tail")
                else:
                    self.image_generation_button.configure(state="normal")


            def turbo_process_request():
                turbo_count = 0
                try: last_gen_request_seed = request_list[0]['seed']
                except:
                    self.image_generation_button.configure(state="normal")
                    return
                while(request_list): #0223 수정 :  
                    gen_request = request_list.pop(0) #length=5
                    if app.app_mode == "NAI":
                        if turbo_count == 1:
                            _filename = app.image_queue[len(app.image_queue)-1][3]
                            if app.set_vibe_wildcard:
                                rem_image_reference()
                                app.set_vibe_wildcard = False
                            app.reference_list = []
                            app.reference_list_ie = []
                            app.reference_list_irs = []
                        if turbo_count >= 1 and self.t2i_porn_vibe.get() == 1:
                            app.reference_list.append(NAIA_generation.image_to_base64(Image.open(_filename)))
                            app.reference_list_ie.append(0.2)
                            for i, v in enumerate(app.reference_list_irs):
                                app.reference_list_irs[i] = round(v - 0.05, 2)
                            app.reference_list_irs.append(0.25)
                            gen_request["reference_image"] = app.reference_list
                            gen_request["reference_information_extracted"] = app.reference_list_ie
                            gen_request["reference_strength"] = app.reference_list_irs
                    generation_thread = threading.Thread(target=run_generation_turbo, args=(gen_request,), daemon=True)
                    generation_thread.start()
                    generation_thread.join()
                    turbo_count += 1
                    if app.turbo_button.get() == 0:
                        app.state_label.configure(text =f"state : 사용자에 의한 터보요청 중단 ({turbo_count})", text_color = "#FFFF97")
                        break
                    if self.automation_button.get() == 0:
                        if request_list and request_list[0]['seed'] != last_gen_request_seed:
                            app.state_label.configure(text =f"state : 사용자에 의한 터보요청 중단 ({turbo_count})", text_color = "#FFFF97")
                            break
                    last_gen_request_seed = gen_request['seed']
                if app.turbo_is_seq:
                    app.turbo_button.deselect()
                    app.turbo_is_seq = False
                if self.automation_button.get() == 1:
                    if self.toggle_prompt_fix_button.get() == 0:
                        if not (self.webui_guide_button.get() == 1 or (self.app_mode == "NAI" and self.guide_i2i.get() == 1)):
                            try: random_function()
                            except: self.random_function_button.configure(state="normal", command=_random_function)
                    self.event_generate(GENERATE_EVENT, when="tail")
                else:
                    self.image_generation_button.configure(state="normal")

            if self.finish_series_gen_request == True:
                self.wildcard_preopen_repeat = 1
                self.wildcard_preopen_repeat_current = self.wildcard_preopen_repeat
                self.automation_button.deselect()
                self.finish_series_gen_request = False
                self.series_generation = []        

            if type(self.current_popped_row) != type(None) and not self.current_popped_row.empty:
                self.generated_popped_row = copy.deepcopy(self.current_popped_row)

            if self.automation_button.get() == 1:
                self.image_generation_button.configure(state="disabled")

            if self.turbo_button.get() == 0 or (app.turbo_mode == 3 and self.turbo_button.get() == 1):
                generation_thread = threading.Thread(target=run_generation, args=(gen_request,), daemon=True)
                generation_thread.start()
            elif self.turbo_button.get() == 1 and app.turbo_mode == 2: 
                generation_thread = threading.Thread(target=turbo_transform_request, args=(gen_request,), daemon=True)
                generation_thread.start()                
            else:
                turbo_process_request_thread = threading.Thread(target=turbo_process_request, daemon=True)
                turbo_process_request_thread.start()
            if (self.automation_button.get() == 1 and (self.webui_guide_button.get() == 1 or (self.app_mode == "NAI" and self.guide_i2i.get() == 1))):
                try: 
                    random_function()
                except: self.random_function_button.configure(state="normal", command=_random_function)
        self.external_NAIA_generate = lambda: NAIA_generate(self)

        def open_AutomationSetting(self):
            if self.Automation_setting is None:
                self.Automation_setting = Automation_setting(self)
            else:
                if self.Automation_setting.state() == 'withdrawn':
                    self.Automation_setting.deiconify()  # 숨겨진 윈도우를 다시 화면에 표시
                else:
                    self.Automation_setting.focus()  

        def show_advanced_settings(self):
            if self.Advanced_setting is None:
                self.Advanced_setting = Advanced_setting(self)
            else:
                if self.Advanced_setting.state() == 'withdrawn':
                    self.Advanced_setting.deiconify()
                else:
                    self.Advanced_setting.focus()  

        def open_Character_search(self, button):
            if self.Character_search is None:
                    # if not os.path.exists("csdataset2.parquet"):
                    #     button.configure(state="disabled")
                    #     self.image_label_report.configure(state="normal")
                    #     self.image_label_report.delete("0.0","end")
                    #     self.image_label_report.insert("0.0", "<UserAttention> 캐릭터 도감 최초 생성을 위한 전처리 작업을 시작합니다. 이 작업에는 어느정도 시간이 소요됩니다.")
                    #     self.image_label_report.configure(text_color="#FFFF97")
                    #     self.image_label_report.configure(state="disabled")
                    #     make_parquet(self)
                    #   button.configure(state="normal")
                self.Character_search = Character_search(self)
            else:
                if self.Character_search.state() == 'withdrawn':
                    self.Character_search.deiconify()
                else:
                    self.Character_search.focus()  

        def make_parquet(self):
            dflist = [os.path.join(basedir, f"tags\\tags_{i:02}.parquet" if i < 100 else f"tags\\tags_{i:03}.parquet") for i in range(130)]
            filtered_dfs = []

            for filepath in dflist:
                # 파일 존재 여부 확인
                if os.path.exists(filepath):
                    df = pd.read_parquet(filepath, engine="pyarrow")
                    filtered_df = df[df['general'].str.contains(' solo,', na=False) & ~df['general'].str.contains('monochrome', na=False)]
                    filtered_dfs.append(filtered_df)

            final_df = pd.concat(filtered_dfs, ignore_index=True)
            final_df.to_parquet("csdataset2.parquet")

        self.Advanced_setting = None
        self.Automation_setting = None
        self.Character_search = None
        self.lazymode = False
        self.notify_check = True

        #이미지 생성 프레임
        self.image_generation_frame = customtkinter.CTkFrame(self.text_input_frame, fg_color="#2B2B2B")
        self.image_generation_frame.grid(row=2, column=0, sticky="nsew")
        self.image_generation_frame.columnconfigure(0, weight= 1)
        self.image_generation_frame.columnconfigure(1, weight= 1)
        self.image_generation_frame.columnconfigure(2, weight= 1)

        def _random_function():
            if self.control_pressed and type(self.current_popped_row) != type(None) and not self.current_popped_row.empty:
                if self.seed_fix_button.get() == 0: self.entry_seed_value.set(random.randint(0,2**32 - 1))
                random_function(self.current_popped_row)
                self.control_pressed = False
            else:
                random_function()

        def _NAIA_generate():
            if self.control_pressed and self.generation_queue:
                self.generation_queue.clear()
                self.image_generation_button.configure(text=f"생성 큐에 삽입 ({len(self.generation_queue)})")
            else:
                NAIA_generate(self)

        self.random_function_button = customtkinter.CTkButton(self.image_generation_frame, text="랜덤/다음 프롬프트", font=my_font, command=_random_function)
        self.random_function_button.grid(row=0, column=0, pady=5, sticky="nsew")
        self.automation_setting_button = customtkinter.CTkButton(self.image_generation_frame, text="자동화 설정", fg_color="#CDCDCD", text_color="black", hover_color="#848484", font=my_font, command=lambda: open_AutomationSetting(self))
        self.automation_setting_button.grid(row=0, column=1, padx=15, sticky="ew")
        if self.app_mode == "NAI":
            self.image_generation_button = customtkinter.CTkButton(self.image_generation_frame, text="NAI 이미지 생성", fg_color="#ED7D31", hover_color="#CC5D12", font=my_font, state="disabled", command=_NAIA_generate , text_color_disabled="black")
        else:
            self.image_generation_button = customtkinter.CTkButton(self.image_generation_frame, text="WEBUI 생성 요청", fg_color="#ED7D31", hover_color="#CC5D12", font=my_font, command=_NAIA_generate, text_color_disabled="black")
        self.image_generation_button.grid(row=0, column=2, pady=5, sticky="nsew")

        def hold_prompt():
            if self.toggle_prompt_fix_button.get() == 1:
                if self.unlock_hold_prompt_var.get() == 0:
                    self.fixed_prompt_input.configure(state="disabled", text_color="#A2B8D2")
                    self.fixed_prompt_after_input.configure(state="disabled", text_color="#A2B8D2")
                self.random_function_button.configure(state="disabled")
                self.rm_not_nsfw_button.deselect()
                self.rm_not_nsfw_button.configure(state="disabled")
                self.random_artist_button.deselect()
                self.random_artist_button.configure(state="disabled")
                self.unlock_hold_prompt.configure(state="normal")
            else:
                self.fixed_prompt_input.configure(state="normal", text_color="#DCE4EE")
                self.fixed_prompt_after_input.configure(state="normal", text_color="#DCE4EE")
                self.random_function_button.configure(state="normal")
                self.rm_not_nsfw_button.configure(state="normal")
                self.random_artist_button.configure(state="normal")

        def explicit_user_attention():
            if self.turbo_button.get() == 1:
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0","end")
                self.image_label_report.insert("0.0", "<UserAttention> Turbo 생성 도중 중단 희망시 체크박스를 해제 하시기 바랍니다.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")
            else:
                self.image_label_report.configure(text_color="#DCE4EE")

        self.reapply_automation_check = False
        def re_automation():
            if self.automation.get() == 1 and self.reapply_automation_check:
                self.Automation_setting.on_apply()
            if self.automation_button.get() == 1 and self.event_automation_copy_button:
                self.event_automation_copy_button.select()
            elif self.automation_button.get() == 0 and self.event_automation_copy_button:
                self.event_automation_copy_button.deselect()

        self.last_call_character = ""
        self.logic_window = None
        self.logic_activation = customtkinter.IntVar(value = 0)
        self.logic_show_window = None
        self.storyteller= {}
        self.storyteller_df = {}
        self.storyteller_last_current = 0
        self.valid_index = None
        self.evinpaint_withdraw =customtkinter.IntVar(value = 0)
        def open_logic():
            if self.logic_window is None:
                logic_window_open()
            else:
                if self.logic_window.state() == 'withdrawn':
                    self.logic_window.deiconify()
                else:
                    self.logic_window.lift()

        def logic_window_open():
            logic_window = customtkinter.CTkToplevel()
            self.logic_window = logic_window
            logic_window.title("이벤트 자동화 설정")
            logic_window.attributes('-topmost', True)
            logic_window.resizable(width=False, height=False)

            def on_close():
                logic_window.withdraw()

            logic_window_left = customtkinter.CTkFrame(logic_window)
            logic_window_left.grid(row=0, column=0, sticky="nsew")
            logic_window_center = customtkinter.CTkFrame(logic_window)
            logic_window_center.grid(row=0, column=1, sticky="nsew")
            current_prompt_label = customtkinter.CTkLabel(logic_window_left, text="랜덤 프롬프트(General)", font=my_font, text_color="#FFFF97")
            current_prompt_label.grid(row=0, column=0, sticky="nsew", padx=5, pady=5)

            current_prompt = customtkinter.CTkTextbox(logic_window_left, width=250, height=250, font=my_font)
            current_prompt.grid(row=1, column=0, sticky="nsew", padx=5, pady=5)
            current_prompt.insert("0.0", self.general_prompt)
            current_prompt.configure(state="disabled")

            def call_next():
                random_function()
                if self.logic_activation.get() == 0:
                    current_prompt.configure(state="normal")
                    current_prompt.delete("0.0", "end")
                    current_prompt.insert("0.0", self.general_prompt)
                    current_prompt.configure(state="disabled")
                else:
                    current_prompt.configure(state="normal")
                    current_prompt.delete("0.0", "end")
                    _insert_with_color(current_prompt, self.general_prompt, self.wildcard_preopen_repeat_current - 1)
                    current_prompt.configure(state="disabled")

            next_prompt = customtkinter.CTkButton(logic_window_left, text="다음 프롬프트", font=my_font, command=call_next)
            next_prompt.grid(row=2, column=0, sticky="nsew", padx=5, pady=5)

            evinpaint_witdraw = customtkinter.CTkCheckBox(logic_window_left, text="(ES/중요) reopen_인페인트 창을 열지않기", font=my_font, variable=self.evinpaint_withdraw, text_color="white")
            evinpaint_witdraw.grid(row=3, column=0, sticky="nsew", padx=5, pady=5)
            self.storyteller_last_current = 0

            def _insert_with_color(cs_text_input, current_lookup, _current):
                words = [word.strip() for word in current_lookup.split(',')]
                for index, word in enumerate(words):
                    start_index = cs_text_input.index("end-1c")
                    if index == len(words) - 1:  # 마지막 원소인 경우
                        cs_text_input.insert("end", word)
                    else:
                        cs_text_input.insert("end", word + ", ")
                    end_index = cs_text_input.index("end-1c")
                    if word in self.storyteller[str(_current)]['include']:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#FFFF97")

            def sync_teller():
                current = self.wildcard_preopen_repeat_current - 1
                if current != self.storyteller_last_current:
                    for i, frame in enumerate(show_window):
                        if i == current: frame.configure(fg_color = "#224554")
                        else: frame.configure(fg_color = "#2B2B2B")
                    self.storyteller_last_current = current
                _current_pr = current_prompt.get("0.0", "end").strip() 
                if _current_pr != self.general_prompt:
                    current_prompt.configure(state="normal")
                    current_prompt.delete("0.0", "end")
                    _insert_with_color(current_prompt, self.general_prompt, current)
                    current_prompt.configure(state="disabled")
                if self.logic_activation.get() == 1 and self.logic_window.state() != 'withdrawn': logic_window.after(500, sync_teller)
                
            #Center
            def activated():
                if self.logic_activation.get() == 1:
                    self.wildcard_preopen_repeat = len(dlogic_dict)
                    self.wildcard_preopen_repeat_current = self.wildcard_preopen_repeat
                    self.storyteller_last_current = 0
                    sync_teller()
                else:
                    self.wildcard_preopen_repeat = 1

                    
            logic_activation = customtkinter.CTkCheckBox(logic_window_center, text="기본 이벤트 자동화 도구를 활성화 합니다", font=my_font, variable=self.logic_activation, state="disabled", command=activated)
            logic_activation.grid(row=0, column=0, sticky="nsew", pady=8)

            default_logic_frame = customtkinter.CTkScrollableFrame(logic_window_center, width=900, height=340, orientation="horizontal")
            default_logic_frame.grid(row=1, column=0, sticky="nsew", pady=5, columnspan=5)

            logic_frame_label = customtkinter.CTkLabel(logic_window_center, text="* 이벤트 자동화 도구는 현재 검색된 프롬프트를 기반으로 작동합니다. 모든 Step을 검증 해주세요. Invalid가 뜨면 메인화면에서 프롬프트 재검색하거나 프롬프트 스태커를 활용해주세요. ", font=my_font, text_color="#FFFF97")
            logic_frame_label.grid(row=2, column=0, sticky="w", pady=5)

            def export_event():
                file_path = filedialog.asksaveasfilename(defaultextension=".json", filetypes=[("JSON files", "*.json")])
                if file_path:
                    storyteller_df_json = {key: df.to_dict() for key, df in self.storyteller_df.items() if df is not None}
                    combined_dict = {
                        "storyteller": self.storyteller,
                        "storyteller_df": storyteller_df_json
                    }
                    with open(file_path, 'w') as json_file:
                        json.dump(combined_dict, json_file, indent=4)

            def import_event():
                def load_data_from_json():
                    file_path = filedialog.askopenfilename(defaultextension=".json", filetypes=[("JSON files", "*.json")])
                    
                    if file_path:
                        with open(file_path, 'r') as json_file:
                            combined_dict = json.load(json_file)
                        
                        storyteller = combined_dict["storyteller"]
                        storyteller_df = {key: pd.DataFrame(value) for key, value in combined_dict["storyteller_df"].items()}
                        
                        return storyteller, storyteller_df
                    return None, None
                self_storyteller, self_storyteller_df = load_data_from_json()

                if self_storyteller and self_storyteller_df:
                    for widget in default_logic_frame.winfo_children():
                        widget.destroy()
                    self.logic_show_window.clear()
                    self.valid_index.clear()
                    dlogic_dict.clear()
                    self.storyteller.clear()
                    self.storyteller_df.clear()
                    self.storyteller.update(self_storyteller)
                    self.storyteller_df = self_storyteller_df
                    initialize()

            import_button = customtkinter.CTkButton(logic_window_center, text="이벤트 불러오기", font=my_font, command=import_event)
            import_button.grid(row=2, column=1, sticky="nsew", padx=5, pady=5)

            export_button = customtkinter.CTkButton(logic_window_center, text="이벤트 내보내기", font=my_font, command=export_event, state='disabled', fg_color="#ED7D31", hover_color="#CC5D12")
            export_button.grid(row=2, column=2, sticky="nsew", padx=5, pady=5)

            #Step, Rating, Include, Exclude, Vibe, Resolution, Clothes, Background

            ev_automation_file_path = os.path.join('.', 'NAIA_ev_automation_default.json')

            if os.path.exists(ev_automation_file_path):
                with open(ev_automation_file_path, 'r', encoding='utf-8') as f:
                    dlogic_dict = json.load(f)
            else:
                dlogic_dict = {}

            if not dlogic_dict:
                dlogic_dict['0'] = {
                    "rating" : "q",
                    "include" : "1girl, solo",
                    "exclude" : "boy",
                    "vibe" : True,
                    "resolution" : "Random",
                    "clothes" : True,
                    "background" : True,
                    "nsfw" : False,
                    "indiv": {
                        'isEnabled': False,
                        'neg' : '',
                        'auto' : '',
                        'cond_pos' : '',
                        'cond_neg' : ''
                    }
                }
                dlogic_dict['1'] = {
                    "rating" : "e",
                    "include" : "1girl, 1boy",
                    "exclude" : "",
                    "vibe" : False,
                    "resolution" : "Random",
                    "clothes" : True,
                    "background" : True,
                    "nsfw" : False,
                    "indiv": {
                        'isEnabled': False,
                        'neg' : '',
                        'auto' : '',
                        'cond_pos' : '',
                        'cond_neg' : ''
                    }
                }

            ratings = ["g", "s", "q", "e", "all", "eq", "sg"]
            resolutions = ["1024 x 1024", "960 x 1088", "896 x 1152", "832 x 1216", "1088 x 960", "1152 x 896", "1216 x 832", "Random", "Previous"]
            show_window = []
            valid_index = []
            self.valid_index = valid_index
            self.logic_show_window = show_window
            self.storyteller = dlogic_dict

            def individualizer(num, val, _mute = False):
                if _mute:
                    dlogic_dict[str(num)]['indiv']['isEnabled'] = True
                    return
                if val == 1:
                    prompt_window = customtkinter.CTkToplevel()
                    prompt_window.title("스텝 개별화")
                    prompt_window.attributes('-topmost', True)
                    prompt_window.resizable(width=False, height=False)

                    neg = dlogic_dict[str(num)]['indiv']['neg']
                    if neg == '': neg = self.negative_prompt_input.get("0.0", "end")
                    cond_pos = dlogic_dict[str(num)]['indiv']['cond_pos']
                    if cond_pos == '': cond_pos = self.conditional_prompt_input.get("0.0", "end")
                    cond_neg = dlogic_dict[str(num)]['indiv']['cond_neg']
                    if cond_neg == '': cond_neg = self.conditional_negative_input.get("0.0", "end")
                    auto = dlogic_dict[str(num)]['indiv']['auto']
                    if auto == '': auto = self.auto_hide_keyword_input.get("0.0", "end")

                    dp_search = dlogic_dict[str(num)]['indiv']['depth_search'] if 'depth_search' in dlogic_dict[str(num)]['indiv'] else ''

                    toggle_negative = customtkinter.IntVar(value = 0)
                    toggle_hide = customtkinter.IntVar(value = 0)
                    toggle_cond = customtkinter.IntVar(value = 0)
                    toggle_cond_neg = customtkinter.IntVar(value = 0)
                    toggle_depth_search = customtkinter.IntVar(value = 0)

                    def toggle_negative_button():
                        if text_label1.get():
                            text_output1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                        else:
                            text_output1.grid_forget()

                    def toggle_hide_button():
                        if text_label2.get():
                            text_output2.grid(row=3, column=0, padx=5, pady=5, sticky="nsew")
                        else:
                            text_output2.grid_forget()

                    def toggle_cond_button():
                        if text_label3.get():
                            text_output3.grid(row=5, column=0, padx=5, pady=5, sticky="nsew")
                        else:
                            text_output3.grid_forget()

                    def toggle_cond_neg_button():
                        if text_label4.get():
                            text_output4.grid(row=7, column=0, padx=5, pady=5, sticky="nsew")              
                        else:
                            text_output4.grid_forget()                        

                    def toggle_depth_search_button():
                        if text_label5.get():
                            text_output5.grid(row=1, column=0, padx=5, pady=5, sticky="w")
                            text_output5_sub.grid(row=2, column=0, padx=5, pady=5, sticky="w")
                            validation.grid(row=3, column=0, padx=5, pady=5, sticky="n")         
                        else:
                            text_output5.grid_forget()
                            text_output5_sub.grid_forget()
                            validation.grid_forget()

                    text_label1 = customtkinter.CTkCheckBox(prompt_window, text="1. 독립 네거티브 프롬프트 적용", font=customtkinter.CTkFont('Pretendard', 13), width=500, variable=toggle_negative, command=toggle_negative_button)
                    text_label1.grid(row=0, column=0, padx=5, pady=5, sticky="w")
                    text_output1 = customtkinter.CTkTextbox(prompt_window, height=140, width=350, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output1.insert("0.0", neg)

                    text_label2 = customtkinter.CTkCheckBox(prompt_window, text="2. 독립 자동숨김 프롬프트 적용", font=customtkinter.CTkFont('Pretendard', 13), width=500, variable=toggle_hide, command=toggle_hide_button)
                    text_label2.grid(row=2, column=0, padx=5, pady=5, sticky="w")
                    text_output2 = customtkinter.CTkTextbox(prompt_window, height=140, width=350, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output2.insert("0.0", auto)

                    text_label3 = customtkinter.CTkCheckBox(prompt_window, text="3. 독립 조건부 프롬프트 적용", font=customtkinter.CTkFont('Pretendard', 13), width=500, variable=toggle_cond, command=toggle_cond_button)
                    text_label3.grid(row=4, column=0, padx=5, pady=5, sticky="w")
                    text_output3 = customtkinter.CTkTextbox(prompt_window, height=140, width=350, font=customtkinter.CTkFont('Pretendard', 15))                    
                    text_output3.insert("0.0", cond_pos)

                    text_label4 = customtkinter.CTkCheckBox(prompt_window, text="4. 독립 조건부 네거티브 적용", font=customtkinter.CTkFont('Pretendard', 13), width=500, variable=toggle_cond_neg, command=toggle_cond_neg_button)
                    text_label4.grid(row=6, column=0, padx=5, pady=5, sticky="w")
                    text_output4 = customtkinter.CTkTextbox(prompt_window, height=140, width=350, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output4.insert("0.0", cond_neg)

                    def _validation():
                        text_output5_sub.configure(state='normal')
                        if int(num) == 0: 
                            text_output5_sub.delete("0.0", "end")
                            text_output5_sub.insert("0.0", "Step 0 에서는 해당 기능을 사용할 수 없습니다. 이 기능은 이전 스텝의 결과 프롬프트를 참조합니다.")
                            text_output5_sub.configure(state='disabled')
                            return
                        lines = text_output5.get("0.0", "end-1c").split('\n')
                        text_output5_sub.delete("0.0", "end")
                        if str(num) not in self.storyteller_df:
                            text_output5_sub.delete("0.0", "end")
                            text_output5_sub.insert("0.0", "먼저 Step validation을 수행해주세요.")
                            text_output5_sub.configure(state='disabled')
                            return
                        for line in lines:
                            exclude_start = line.rfind("exclude:")
                            if exclude_start != -1:
                                exclude = line[exclude_start + len("exclude:"):].strip()
                                line = line[:exclude_start].strip()
                            else:
                                exclude = ''
                            include_start = line.find("include:")
                            if include_start != -1:
                                include = line[include_start + len("include:"):].strip()
                            else:
                                include = ''
                            if include != '' or exclude != '':
                                xdf = self.storyteller_df[str(int(num))]
                                xdf = NAIA_search.search(xdf, include, exclude)
                                try:
                                    result = f" valid : {len(xdf)}\n"
                                except:
                                    result = " No prompts\n"
                                text_output5_sub.insert("end", line.split(':')[0] + result)
                            else:
                                text_output5_sub.insert("end", "Search Failed !\n")
                        text_output5_sub.insert("end", "\n이 검증에서는 조건문 로직 검증은 수행되지 않았습니다.")
                        text_output5_sub.configure(state='disabled')

                    frame_left = customtkinter.CTkFrame(prompt_window, fg_color="#242424")
                    frame_left.grid(row=0, column=1, rowspan=8, padx=5, pady=5, sticky="nsew")
                    text_label5 = customtkinter.CTkCheckBox(frame_left, text="5. 데이터 프레임 내 조건부 재검색 (엔터로 구분)", font=customtkinter.CTkFont('Pretendard', 13), width=500, variable=toggle_depth_search, command=toggle_depth_search_button)
                    text_label5.grid(row=0, column=0, padx=5, pady=5, sticky="w")
                    text_output5 = customtkinter.CTkTextbox(frame_left, height=140, width=500, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output5.insert("0.0", dp_search)
                    text_output5_sub = customtkinter.CTkTextbox(frame_left, height=140, width=500, font=customtkinter.CTkFont('Pretendard', 15), text_color="#FFFF97")
                    text_output5_sub.insert("0.0", "(조건): include:검색1,검색2 ... 검색n exclude:제외1,제외2 ...")
                    text_output5_sub.configure(state="disabled")
                    validation = customtkinter.CTkButton(frame_left, text="유효성 검사", font=customtkinter.CTkFont('Pretendard', 13), command=_validation)

                    if 'toggle_negative' in dlogic_dict[str(num)]['indiv'] and dlogic_dict[str(num)]['indiv']['toggle_negative'] == True: 
                        text_label1.select()
                        text_output1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                    if 'toggle_hide' in dlogic_dict[str(num)]['indiv'] and dlogic_dict[str(num)]['indiv']['toggle_hide'] == True: 
                        text_label2.select()
                        text_output2.grid(row=3, column=0, padx=5, pady=5, sticky="nsew")
                    if 'toggle_cond' in dlogic_dict[str(num)]['indiv'] and dlogic_dict[str(num)]['indiv']['toggle_cond'] == True: 
                        text_label3.select()
                        text_output3.grid(row=5, column=0, padx=5, pady=5, sticky="nsew")
                    if 'toggle_cond_neg' in dlogic_dict[str(num)]['indiv'] and dlogic_dict[str(num)]['indiv']['toggle_cond_neg'] == True: 
                        text_label4.select()
                        text_output4.grid(row=7, column=0, padx=5, pady=5, sticky="nsew")    
                    if 'toggle_depth_search' in dlogic_dict[str(num)]['indiv'] and dlogic_dict[str(num)]['indiv']['toggle_depth_search'] == True: 
                        text_label5.select()
                        text_output5.grid(row=1, column=0, padx=5, pady=5, sticky="w")
                        text_output5_sub.grid(row=2, column=0, padx=5, pady=5, sticky="w")
                        validation.grid(row=3, column=0, padx=5, pady=5, sticky="n")       


                    def save_all():
                        dlogic_dict[str(num)]['indiv']['neg'] = text_output1.get("0.0", "end-1c")
                        dlogic_dict[str(num)]['indiv']['cond_pos'] = text_output3.get("0.0", "end-1c")
                        dlogic_dict[str(num)]['indiv']['cond_neg'] = text_output4.get("0.0", "end-1c")
                        dlogic_dict[str(num)]['indiv']['auto'] = text_output2.get("0.0", "end-1c")
                        dlogic_dict[str(num)]['indiv']['isEnabled'] = True
                        dlogic_dict[str(num)]['indiv']['toggle_negative'] = True if toggle_negative.get() else False
                        dlogic_dict[str(num)]['indiv']['toggle_hide'] = True if toggle_hide.get() else False
                        dlogic_dict[str(num)]['indiv']['toggle_cond'] = True if toggle_cond.get() else False
                        dlogic_dict[str(num)]['indiv']['toggle_cond_neg'] = True if toggle_cond_neg.get() else False
                        dlogic_dict[str(num)]['indiv']['toggle_depth_search'] = True if toggle_depth_search.get() else False
                        dlogic_dict[str(num)]['indiv']['depth_search'] = text_output5.get("0.0", "end-1c")
                        prompt_window.destroy()

                    save = customtkinter.CTkButton(prompt_window, text="저장", font=customtkinter.CTkFont('Pretendard', 13), command=save_all)
                    save.grid(row=8, column=0, columnspan=2, padx=5, pady=5, sticky="n")              
                else:
                    dlogic_dict[str(num)]['indiv']['isEnabled'] = False

            def step_validation(key, button):
                key = str(key)
                button.configure(text="검색중", state="disabled")
                self.storyteller_df[key] = None
                df = self.cached_rows
                if "reopen" in dlogic_dict[key]['rating']:
                    self.storyteller_df[key] = None
                    button.configure(text=f"valid : Reopen", state="normal", fg_color="#3392D9")
                    valid_index[int(key)] = True
                    if len(self.storyteller_df) == len(dlogic_dict) and all(valid_index): 
                        logic_activation.configure(state="normal")
                        export_button.configure(state="normal")
                    return
                try:
                    if dlogic_dict[key]['rating'] == "all":
                        xdf = df
                    elif dlogic_dict[key]['rating'] == "eq":
                        xdf = df[df['rating'].isin(['e', 'q'])]
                    elif dlogic_dict[key]['rating'] == "sg":
                        xdf = df[df['rating'].isin(['s', 'g'])]
                    else:
                        xdf = df[df['rating'] == dlogic_dict[key]['rating']]
                    xdf = NAIA_search.search(xdf, dlogic_dict[key]['include'], dlogic_dict[key]['exclude'])
                    self.storyteller_df[key] = xdf
                    button.configure(text=f"valid : {len(xdf)}", state="normal", fg_color="#3392D9")
                    valid_index[int(key)] = True
                    if len(self.storyteller_df) == len(dlogic_dict) and all(valid_index): 
                        logic_activation.configure(state="normal")
                        export_button.configure(state="normal")
                except:
                    button.configure(text=f"Invalid", state="normal", fg_color="#C00000")
                    logic_activation.deselect()
                    logic_activation.configure(state="disabled")
                    export_button.configure(state="disabled")
                    valid_index[int(key)] = False

            def rem_def_logic(index=None):
                if not index:
                    self.logic_show_window[-1].destroy()
                    self.logic_show_window.pop()
                    key = str(len(dlogic_dict)-1)
                    del dlogic_dict[key]
                    if key in self.storyteller_df: del self.storyteller_df[key]
                    if len(dlogic_dict) == 1: rem_step.configure(state="disabled")
                    valid_index.pop()
                else:
                    dlogic_dict.pop(str(index))
                    self.storyteller_df.pop(str(index), None)
                    for widget in default_logic_frame.winfo_children():
                        widget.destroy()
                    self.logic_show_window.clear()
                    self.valid_index.clear()
                    # dlogic_dict와 self.storyteller_df를 순회하며 key를 str(0)부터 str(len(dlogic_dict) - 1)까지 초기화
                    new_dlogic_dict = {}
                    new_storyteller_df = {}
                    for i, (old_key, value) in enumerate(sorted(dlogic_dict.items(), key=lambda item: int(item[0]))):
                        new_key = str(i)
                        new_dlogic_dict[new_key] = value
                    for i, (old_key, df) in enumerate(sorted(self.storyteller_df.items(), key=lambda item: int(item[0]))):
                        new_key = str(i)
                        new_storyteller_df[new_key] = df
                    
                    dlogic_dict.clear()
                    dlogic_dict.update(new_dlogic_dict)
                    
                    self.storyteller_df.clear()
                    self.storyteller_df.update(new_storyteller_df)
                    
                    self.logic_show_window.clear()
                    self.valid_index.clear()
                    initialize()

            def initialize():
                for key, value in dlogic_dict.items():
                    if key == '0':
                        new_dlogic_dict = {}
                        new_storyteller_df = {}
                        for i, (old_key, _value) in enumerate(sorted(dlogic_dict.items(), key=lambda item: int(item[0]))):
                            new_key = str(i)
                            new_dlogic_dict[new_key] = _value
                        for i, (old_key, df) in enumerate(sorted(self.storyteller_df.items(), key=lambda item: int(item[0]))):
                            new_key = str(i)
                            new_storyteller_df[new_key] = df
                        
                        dlogic_dict.clear()
                        dlogic_dict.update(new_dlogic_dict)
                        
                        self.storyteller_df.clear()
                        self.storyteller_df.update(new_storyteller_df)
                        
                        self.logic_show_window.clear()
                        self.valid_index.clear()
                    f = customtkinter.CTkFrame(default_logic_frame, width = 220, height=300)
                    f.grid(row=0, column=key, sticky="nsew", padx=2, pady=2)
                    label1 = customtkinter.CTkLabel(f, font=my_font, text=f"Step {key}")
                    if int(key) > 1: label1.grid(row=0, column=1, sticky="nsew", padx=2, pady=2)
                    else: label1.grid(row=0, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    delete_button = customtkinter.CTkButton(f, text="Delete", width=5, command=lambda idx=key: rem_def_logic(idx), fg_color="grey10")
                    if int(key) > 0 and len(dlogic_dict) > 2: delete_button.grid(row=0, column=0, sticky="nsew", padx=2, pady=2)
                    insert_button = customtkinter.CTkButton(f, text="+", width=12, command=lambda idx=int(key)+1: add_def_logic(idx))
                    insert_button.grid(row=0, column=1, sticky="e", padx=2, pady=2)
                    label2 = customtkinter.CTkLabel(f, font=my_font, text=f"Rating : ")
                    label2.grid(row=1, column=0, sticky="nsew", padx=2, pady=2)
                    rating = customtkinter.CTkComboBox(f, font=my_font, values=ratings if int(key) < 1 else ratings + ["reopen","reopen+f.seed","reopen+inpaint"], command=lambda value, k=key  : update_dict(k,"rating",value))
                    rating.grid(row=1, column=1, sticky="nsew", padx=2, pady=2)
                    rating.set(value['rating'])
                    label3 = customtkinter.CTkLabel(f, font=my_font, text=f"Include : ")
                    label3.grid(row=2, column=0, sticky="nsew", padx=2, pady=2)
                    include = customtkinter.CTkEntry(f, font=my_font)
                    include.grid(row=2, column=1, sticky="nsew", padx=2, pady=2)
                    include.insert(0, value['include'])
                    include.bind("<KeyRelease>", lambda e, _include=include, k=key: update_dict(k, 'include', _include.get()))
                    label4 = customtkinter.CTkLabel(f, font=my_font, text=f"Exclude : ")
                    label4.grid(row=3, column=0, sticky="nsew", padx=2, pady=2)
                    exclude = customtkinter.CTkEntry(f, font=my_font)
                    exclude.grid(row=3, column=1, sticky="nsew", padx=2, pady=2)
                    exclude.insert(0, value['exclude'])
                    exclude.bind("<KeyRelease>", lambda e, _exclude=exclude, k=key: update_dict(k, 'exclude', _exclude.get()))
                    label5 = customtkinter.CTkLabel(f, font=my_font, text=f"Res : ")
                    label5.grid(row=4, column=0, sticky="nsew", padx=2, pady=2)
                    res = customtkinter.CTkComboBox(f, font=my_font, values=resolutions, command=lambda value, k=key: update_dict(k, 'resolution', value))
                    res.grid(row=4, column=1, sticky="nsew", padx=2, pady=2)
                    res.set(value['resolution'])
                    vibe = customtkinter.CTkCheckBox(f,  font=my_font, text="생성 후 vibe 할당")
                    vibe.configure(command=lambda _vibe = vibe, k=key: update_dict(k, 'vibe', _vibe.get()))
                    vibe.grid(row=5, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    if value["vibe"] == True : vibe.select()
                    clothes = customtkinter.CTkCheckBox(f,  font=my_font, text="의상 정보 유지")
                    clothes.configure(command=lambda _clothes=clothes, k=key: update_dict(k, 'clothes', _clothes.get()))
                    clothes.grid(row=6, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    if value["clothes"] == True : clothes.select()
                    background = customtkinter.CTkCheckBox(f,  font=my_font, text="배경 정보 유지")
                    background.configure(command=lambda _background=background, k=key: update_dict(k, 'background', _background.get()))
                    background.grid(row=7, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    if value["background"] == True : background.select()
                    nsfw = customtkinter.CTkCheckBox(f,  font=my_font, text="NSFW Only")
                    nsfw.configure(command=lambda _nsfw=nsfw, k=key: update_dict(k, 'nsfw', _nsfw.get()))
                    nsfw.grid(row=8, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    if value["nsfw"] == True : nsfw.select()
                    indiv = customtkinter.CTkCheckBox(f,  font=my_font, text="스텝 네거/조건부 개별화")
                    indiv.configure(command=lambda _indiv=indiv, k=key: individualizer(k, _indiv.get()))
                    indiv.grid(row=9, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                    if value["indiv"]['isEnabled'] == True : indiv.select()
                    valid = customtkinter.CTkButton(f, font=my_font, text="프롬프트 검증")
                    valid.configure(command=lambda k=key, _valid=valid: step_validation(k,_valid))
                    valid.grid(row=10, column=0, columnspan=2, sticky="n", padx=2, pady=2)

                    show_window.append(f)
                    if str(key) in self.storyteller_df and type(self.storyteller_df[key]) != type(None): 
                        valid.configure(text=f"valid : {len(self.storyteller_df[str(key)])}", fg_color="#3392D9")
                        valid_index.append(True)
                    else:
                        if 'reopen' in dlogic_dict[key]['rating']:
                            valid_index.append(True)
                            self.storyteller_df[key] = None
                            valid.configure(text=f"valid : Reopen", fg_color="#3392D9")
                        else:
                            valid_index.append(False)
                    
                if len(self.storyteller_df) == len(dlogic_dict) and all(valid_index): 
                    logic_activation.configure(state="normal")
                    export_button.configure(state="normal")
            
            def update_dict(num, txt, val):
                num = str(num)
                if isinstance(val, int):
                    dval = True if val == 1 else False 
                    dlogic_dict[num][txt] = dval
                else:
                    dlogic_dict[num][txt] = val

            def add_def_logic(index=None):
                if not index:
                    key = len(dlogic_dict)
                    dlogic_dict[str(key)] = {
                        "rating" : "e",
                        "include" : "1girl",
                        "exclude" : "",
                        "vibe" : False,
                        "resolution" : "Random",
                        "clothes" : False,
                        "background" : False,
                        "nsfw" : False,
                        "indiv": {
                            'isEnabled': False,
                            'neg' : '',
                            'auto' : '',
                            'cond_pos' : '',
                            'cond_neg' : ''
                        }
                    }
                else:
                    for widget in default_logic_frame.winfo_children():
                        widget.destroy()
                    self.logic_show_window.clear()
                    self.valid_index.clear()
                    new_dlogic_dict = {}
                    new_storyteller_df = {}
                    for i in range(len(dlogic_dict), index, -1):
                        old_key = str(i - 1)
                        new_key = str(i)
                        new_dlogic_dict[new_key] = dlogic_dict.pop(old_key)
                        if old_key in self.storyteller_df:
                            new_storyteller_df[new_key] = self.storyteller_df.pop(old_key)
                    new_storyteller_df[str(index)] = None

                    dlogic_dict[str(index)] = {
                        "rating" : "e",
                        "include" : "1girl",
                        "exclude" : "",
                        "vibe" : False,
                        "resolution" : "Random",
                        "clothes" : False,
                        "background" : False,
                        "nsfw" : False,
                        "indiv": {
                            'isEnabled': False,
                            'neg' : '',
                            'auto' : '',
                            'cond_pos' : '',
                            'cond_neg' : ''
                        }
                    }

                    # Update the dictionaries
                    dlogic_dict.update(new_dlogic_dict)
                    self.storyteller_df.update(new_storyteller_df)
                    return initialize()

                value = dlogic_dict[str(key)]
                f = customtkinter.CTkFrame(default_logic_frame, width = 220, height=300)
                f.grid(row=0, column=key, sticky="nsew", padx=2, pady=2)
                label1 = customtkinter.CTkLabel(f, font=my_font, text=f"Step {key}")
                label1.grid(row=0, column=1, sticky="nsew", padx=2, pady=2)
                delete_button = customtkinter.CTkButton(f, text="Delete", width=5, command=lambda idx=key: rem_def_logic(idx), fg_color="grey10")
                delete_button.grid(row=0, column=0, sticky="nsew", padx=2, pady=2)
                insert_button = customtkinter.CTkButton(f, text="+", width=12, command=lambda idx=int(key)+1: add_def_logic(idx))
                insert_button.grid(row=0, column=1, sticky="e", padx=2, pady=2)
                label2 = customtkinter.CTkLabel(f, font=my_font, text=f"Rating : ")
                label2.grid(row=1, column=0, sticky="nsew", padx=2, pady=2)
                rating = customtkinter.CTkComboBox(f, font=my_font, values=ratings if int(key) < 1 else ratings + ["reopen","reopen+f.seed","reopen+inpaint"], command=lambda value, k=key  : update_dict(k,"rating",value))
                rating.grid(row=1, column=1, sticky="nsew", padx=2, pady=2)
                rating.set(value['rating'])
                label3 = customtkinter.CTkLabel(f, font=my_font, text=f"Include : ")
                label3.grid(row=2, column=0, sticky="nsew", padx=2, pady=2)
                include = customtkinter.CTkEntry(f, font=my_font)
                include.grid(row=2, column=1, sticky="nsew", padx=2, pady=2)
                include.insert(0, value['include'])
                include.bind("<KeyRelease>", lambda e, _include=include, k=key: update_dict(k, 'include', _include.get()))
                label4 = customtkinter.CTkLabel(f, font=my_font, text=f"Exclude : ")
                label4.grid(row=3, column=0, sticky="nsew", padx=2, pady=2)
                exclude = customtkinter.CTkEntry(f, font=my_font)
                exclude.grid(row=3, column=1, sticky="nsew", padx=2, pady=2)
                exclude.insert(0, value['exclude'])
                exclude.bind("<KeyRelease>", lambda e, _exclude=exclude, k=key: update_dict(k, 'exclude', _exclude.get()))
                label5 = customtkinter.CTkLabel(f, font=my_font, text=f"Res : ")
                label5.grid(row=4, column=0, sticky="nsew", padx=2, pady=2)
                res = customtkinter.CTkComboBox(f, font=my_font, values=resolutions, command=lambda value, k=key: update_dict(k, 'resolution', value))
                res.grid(row=4, column=1, sticky="nsew", padx=2, pady=2)
                res.set(value['resolution'])
                vibe = customtkinter.CTkCheckBox(f,  font=my_font, text="생성 후 vibe 할당")
                vibe.configure(command=lambda _vibe = vibe, k=key: update_dict(k, 'vibe', _vibe.get()))
                vibe.grid(row=5, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                if value["vibe"] == True : vibe.select()
                clothes = customtkinter.CTkCheckBox(f,  font=my_font, text="의상 정보 유지")
                clothes.configure(command=lambda _clothes=clothes, k=key: update_dict(k, 'clothes', _clothes.get()))
                clothes.grid(row=6, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                if value["clothes"] == True : clothes.select()
                background = customtkinter.CTkCheckBox(f,  font=my_font, text="배경 정보 유지")
                background.configure(command=lambda _background=background, k=key: update_dict(k, 'background', _background.get()))
                background.grid(row=7, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                if value["background"] == True : background.select()
                nsfw = customtkinter.CTkCheckBox(f,  font=my_font, text="NSFW Only")
                nsfw.configure(command=lambda _nsfw=nsfw, k=key: update_dict(k, 'nsfw', _nsfw.get()))
                nsfw.grid(row=8, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                if value["nsfw"] == True : nsfw.select()
                indiv = customtkinter.CTkCheckBox(f,  font=my_font, text="스텝 네거/조건부 개별화")
                indiv.configure(command=lambda _indiv=indiv, k=key: individualizer(k, _indiv.get()))
                indiv.grid(row=9, column=0, columnspan=2, sticky="nsew", padx=2, pady=2)
                if value["indiv"]['isEnabled'] == True : indiv.select()
                valid = customtkinter.CTkButton(f, font=my_font, text="프롬프트 검증")
                valid.configure(command=lambda k=key, _valid=valid: step_validation(k,_valid))
                valid.grid(row=10, column=0, columnspan=2, sticky="n", padx=2, pady=2)
                self.logic_show_window.append(f)
                valid_index.append(False)
                logic_activation.deselect()
                logic_activation.configure(state="disabled")
                export_button.configure(state="disabled")

                if len(dlogic_dict) == 2: rem_step.configure(state="normal")

            def apply_NAIA():
                with open("NAIA_ev_automation_default.json", "w") as f:
                    json.dump(dlogic_dict, f, ensure_ascii=False, indent=4)
                apply_event.configure(text="저장됨", state="disabled")
                logic_window.after(3000, lambda: apply_event.configure(text="이벤트 저장", state="normal"))

            initialize()

            add_step = customtkinter.CTkButton(logic_window_center, text="Step 추가 (+)", font=my_font, command=add_def_logic)
            #add_step.grid(row=0, column=1, sticky="nsew", pady=8)
            rem_step = customtkinter.CTkButton(logic_window_center, text="Step 제거 (-)", font=my_font, command=rem_def_logic, fg_color="grey10", hover_color="grey")
            #rem_step.grid(row=0, column=2, sticky="nsew", pady=8)
            apply_event = customtkinter.CTkButton(logic_window_center, text="이벤트 저장", font=my_font, command=apply_NAIA,  fg_color="#ED7D31", hover_color="#CC5D12")
            apply_event.grid(row=0, column=3, sticky="nsew", pady=8)
            
            logic_window.protocol("WM_DELETE_WINDOW", on_close)
            logic_window.after(1500, lambda: logic_window.attributes('-topmost', False))

        def insert_sequence():
            self.text_input.delete("0.0", "end")
            _pre = self.fixed_prompt_input.get("0.0", "end-1c")+", \n\n\n"
            _end = self.fixed_prompt_after_input.get("0.0", "end-1c")
            _text = _pre + ":begin\n\n\n,:seq1 \n\n\n,:seq2 \n\n\n:end\n\n\n" + _end
            self.text_input.insert("0.0", _text)
        
        self.toggle_prompt_fix = customtkinter.IntVar()
        self.toggle_prompt_fix_button = customtkinter.CTkCheckBox(self.image_generation_frame, text="프롬프트 고정", variable=self.toggle_prompt_fix, font=my_font, command=hold_prompt)
        self.toggle_prompt_fix_button.grid(row=1, column=0, sticky="ew", padx=15, pady=5)
        self.automation = customtkinter.IntVar()
        self.automation_button = customtkinter.CTkCheckBox(self.image_generation_frame, text="자동화", variable=self.automation, font=my_font, command=re_automation)
        self.automation_button.grid(row=1, column=1, sticky="ew", padx=15)
        self.turbo = customtkinter.IntVar()
        self.turbo_button = customtkinter.CTkCheckBox(self.image_generation_frame, text="터보", variable=self.turbo, font=my_font, command=explicit_user_attention)
        self.turbo_button.grid(row=1, column=2, sticky="w")
        self.turbo_seq_button = customtkinter.CTkButton(self.image_generation_frame, text=":seq", font=my_font, text_color="#F5F3C2", fg_color="grey10", hover_color="grey", height=24, width=30, command=insert_sequence)
        self.turbo_seq_button.grid(row=1, column=2, sticky="n", pady=6)
        self.logic_setting_button = customtkinter.CTkButton(self.image_generation_frame, text="EV.A", font=my_font, fg_color="grey10", hover_color="grey", width=20, height=24, command=open_logic)
        self.logic_setting_button.grid(row=1, column=1, sticky="e", padx=10)
        self.autocomplete_var = customtkinter.IntVar()
        self.wildcard_dict_tree = None

        def create_character_frame(parent, idx, large_font, v_large_font, frames_list, add_callback, remove_callback):
            frame = customtkinter.CTkFrame(parent)
            character_btn = customtkinter.CTkButton(
                frame, 
                text=f"C{idx}", 
                fg_color="grey10", 
                width=25, 
                height=90, 
                font=v_large_font,
                command=lambda: open_character_window(textbox)
            )
            character_btn.grid(row=0, rowspan=2, column=0, pady=5, sticky="nsew")
            
            textbox = customtkinter.CTkTextbox(
                frame, 
                width=400, 
                height=65 * self.naid4_characters_frame_size_weight, 
                font=v_large_font, 
                undo=True
            )
            textbox.grid(row=0, column=1, padx=10, pady=2, sticky="nsew")

            auto_complete = AutoCompleteHandler(
                self,
                self.app_mode,
                text_widget=textbox,
                autocomplete_var=self.autocomplete_var,
                wildcard_dict_tree= self.wildcard_dict_tree
            )

            uc = customtkinter.CTkTextbox(
                frame, 
                width=400, 
                height=25 * self.naid4_characters_frame_size_weight, 
                font=v_large_font, 
                text_color="grey",
                undo=True
            )
            uc.grid(row=1, column=1, padx=10, pady=3, sticky="nsew")
            
            remove_btn = customtkinter.CTkButton(
                frame, 
                text=" - ", 
                fg_color="grey", 
                hover_color="grey10", 
                width=25, 
                height=25, 
                font=v_large_font,
                command=lambda: remove_callback(frame, frames_list)
            )
            remove_btn.grid(row=0, column=2, pady=5, sticky="nsew")
            
            add_btn = customtkinter.CTkButton(
                frame, 
                text=" + ", 
                width=25, 
                height=25, 
                font=v_large_font,
                command=add_callback
            )
            add_btn.grid(row=1, column=2, pady=5, sticky="nsew")
            
            return {
                'frame': frame,
                'character_btn': character_btn,
                'textbox': textbox,
                'uc':uc,
                'remove_btn': remove_btn,
                'add_btn': add_btn
            }
        self.create_character_frame = create_character_frame

        def open_character_window(parent_textbox):
            # 새 toplevel 윈도우 생성
            window = customtkinter.CTkToplevel()
            window.title("캐릭터 검색")
            window.geometry("800x450")
            window.attributes('-topmost', True)
            
            # 검색 프레임 생성
            search_frame = customtkinter.CTkFrame(window)
            search_frame.grid(row=0, column=0, columnspan=2, padx=10, pady=5, sticky="ew")
            
            # 검색 엔트리
            search_entry = customtkinter.CTkEntry(search_frame, width=200, font=("", 14))
            search_entry.grid(row=0, column=0, padx=(0,5), sticky="ew")
            search_entry.bind('<Return>', lambda event: do_search())
            
            # 검색 버튼
            search_btn = customtkinter.CTkButton(
                search_frame, 
                text="검색 (엔터)",
                width=80,
                command=lambda: do_search()
            )
            search_btn.grid(row=0, column=1, padx=(5,0))
            
            # 리스트박스
            listbox = tk.Listbox(window, width=32, height=30, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
            listbox.grid(row=1, column=0, padx=10, pady=5, sticky="nsew")
            scrollbar = tk.Scrollbar(window, orient="v", command=listbox.yview)
            scrollbar.grid(row=1, column=1, sticky='nsw')  # 'nsw'로 변경: north, south, west
            listbox.config(yscrollcommand=scrollbar.set)
            
            # 텍스트박스
            content_textbox = customtkinter.CTkTextbox(window, font=v_large_font)
            content_textbox.grid(row=1, column=1, padx=20, pady=5, sticky="nsew")
            
            # 버튼 프레임
            button_frame = customtkinter.CTkFrame(window)
            button_frame.grid(row=2, column=0, columnspan=2, sticky="ew")
            
            insert_btn = customtkinter.CTkButton(
                button_frame, 
                text="삽입",
                command=lambda: insert_content(parent_textbox, content_textbox, window)
            )
            insert_btn.grid(row=0, column=1, padx=5, pady=5)
            
            close_btn = customtkinter.CTkButton(
                button_frame, 
                text="닫기",
                fg_color = "grey",
                command=window.destroy
            )
            close_btn.grid(row=0, column=0, padx=5, pady=5)
            
            # 그리드 설정
            window.grid_columnconfigure(1, weight=1)
            window.grid_rowconfigure(1, weight=1)
            search_frame.grid_columnconfigure(0, weight=1)
            button_frame.grid_columnconfigure((0,1), weight=1)
            
            def on_listbox_select(event):
                selection = listbox.curselection()
                if selection:
                    selected_text = listbox.get(selection[0])
                    keyword = selected_text.split(" - ")[0]
                    
                    content_textbox.delete("0.0", "end")
                    if keyword in character_dict_full:
                        _text = character_dict_full[keyword].split(', ')
                        _text = ", ".join(_text[1:]) if len(_text) >= 2 else ", ".join(_text)
                        content_textbox.insert("0.0", _text)
            
            def do_search():
                search_keyword = search_entry.get().strip()
                if listbox.size() > 0:
                    listbox.delete(0, "end")

                all_matching_keywords = []
                added_keywords = set()

                if search_keyword and len(search_keyword) >= 3:
                    # dan_character_dict에서 키워드 검색
                    for character, tags in dan_character_dict.items():
                        if (search_keyword.lower() in character.lower() or 
                            search_keyword.lower() in tags.lower()):
                            count = character_dict_count.get(character, 0)
                            if count > 20 and character not in added_keywords:
                                all_matching_keywords.append((character, count))
                                added_keywords.add(character)

                else:
                    # 빈 검색어일 때는 v > 50인 항목만 표시
                    all_matching_keywords = [
                        (k, v) for k, v in character_dict_count.items() 
                        if v > 50 and k not in added_keywords
                    ]

                # Sort and insert into listbox
                all_matching_keywords.sort(key=lambda item: item[1], reverse=True)
                for keyword, count in all_matching_keywords:
                    listbox.insert("end", f"{keyword} - {count}")
            
            # 이벤트 바인딩
            listbox.bind('<<ListboxSelect>>', on_listbox_select)
            search_entry.bind('<Return>', lambda e: do_search())  # Enter 키로도 검색 가능
            
            # 초기 리스트 로딩
            do_search()

        def insert_content(parent_textbox, content_textbox, window):
            content = content_textbox.get("0.0", "end")
            current_text = parent_textbox.get("0.0", "end")
            parent_textbox.delete("0.0", "end")
            parent_textbox.insert("0.0", content)
            window.destroy()

        def update_character_buttons():
            current_num_chars = len(self.character_frames)
            prev_num_chars = sum(1 for pos in self.naid4_positions if pos is not None)

            if current_num_chars > prev_num_chars:
                for i in range(prev_num_chars, current_num_chars):
                    if i < len(self.naid4_positions):  # 범위 체크
                        self.naid4_positions[i] = "C3"  # 기본 위치 설정
                        self.naid4_cps[i].configure(text=f"Character{i+1} : C3")

                        row = i // 3
                        col = i % 3
                        self.naid4_cps[i].grid(row=row, column=col, padx=2, pady=2, sticky="nsew")
            
            elif current_num_chars < prev_num_chars:
                for i in range(current_num_chars, prev_num_chars):
                    if i < len(self.naid4_positions):  # 범위 체크
                        self.naid4_positions[i] = None  # 위치 정보 초기화
                        self.naid4_cps[i].grid_forget()  # UI에서 제거
            
            for i in range(min(current_num_chars, len(self.naid4_positions))):
                row = i // 3
                col = i % 3
                
                grid_info = self.naid4_cps[i].grid_info()

                if not grid_info or int(grid_info['row']) != row or int(grid_info['column']) != col:
                    self.naid4_cps[i].grid(row=row, column=col, padx=5, pady=5, sticky="nsew")
            update_position_image()

            if current_num_chars == 1:
                if self.ai_choice.get() == 0: 
                    self.ai_choice.select()
                    ai_choice_update()
                self.ai_choice.configure(state="disabled")
            elif current_num_chars > 1 and self.ai_choice.cget("state") == "disabled":
                self.ai_choice.configure(state="normal")
        self.update_character_buttons = update_character_buttons

        def add_new_character(parent, large_font, v_large_font, frames_list):
            if len(frames_list) < 6:
                idx = len(frames_list) + 1
                new_frame_dict = create_character_frame(
                    parent,
                    idx,
                    large_font,
                    v_large_font,
                    frames_list,
                    lambda: add_new_character(parent, large_font, v_large_font, frames_list),
                    remove_character
                )
                new_frame_dict['frame'].grid(row=len(frames_list) + 2, column=0, columnspan=3, sticky="nsew")
                frames_list.append(new_frame_dict)
                update_character_buttons()
        self.add_new_character = add_new_character

        def remove_character(frame_to_remove, frames_list):
            if len(frames_list) > 1:  # 최소 1개는 유지
                # 제거할 프레임 찾기
                frame_dict = next((f for f in frames_list if f['frame'] == frame_to_remove), None)
                if frame_dict:
                    frame_dict['frame'].grid_forget()
                    frames_list.remove(frame_dict)
                    
                    # 남은 프레임들의 위치와 번호 재조정
                    for idx, frame_dict in enumerate(frames_list, start=1):
                        frame_dict['character_btn'].configure(text=f"C{idx}")
                        frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")
                update_character_buttons()
        self.remove_character = remove_character

        def toggle_character_frames():
            if self.naid4_characters_label.get() == 0:  # 체크박스가 해제된 경우
                self.naid4_characters_label.configure(
                    text=" -----------------------  NAID4 캐릭터 프롬프트/UC (비활성) ----------- ",
                    text_color="grey"
                )
                self.naid4_selected_character_textbox.grid_forget()
                self.ai_choice.grid_forget()
                self.naid4_position_frame.grid_forget()
                self.pos_viewer.grid_forget()
                self.naid4_characters_update.configure(state="disabled")
                for frame_dict in self.character_frames:
                    frame_dict['frame'].grid_forget()
            else:  # 체크박스가 선택된 경우
                self.naid4_characters_label.configure(
                    text=" -----------------------  NAID4 캐릭터 프롬프트/UC (활성) ----------",
                    text_color=("black", "white")  # (라이트 모드 색상, 다크 모드 색상)
                )
                self.ai_choice.grid(row=3, column=0, padx=5, pady=14, sticky="w")
                self.pos_viewer.grid(row=3, column=0, padx=5, sticky="e")
                self.naid4_position_frame.grid(row=3, column=1, columnspan=2, sticky="nsew")
                self.naid4_selected_character_textbox.grid(row=1, column=0, columnspan=3, sticky="nsew")
                self.naid4_characters_update.configure(state="normal")
                for idx, frame_dict in enumerate(self.character_frames, start=1):
                    frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")

        self.naid4_characters_frame = customtkinter.CTkFrame(self.image_generation_frame)
        self.naid4_characters_label = customtkinter.CTkCheckBox(
            self.naid4_characters_frame, 
            text=" -----------------------  NAID4 캐릭터 프롬프트/UC (활성) ----------", 
            font=large_font,
            command=toggle_character_frames
        )
        self.naid4_characters_label.select()
        self.naid4_characters_label.grid(row=0, column=0, sticky="nsew")

        def naid4_character_update():
            self.wildcard_preopen_repeat_current = 1
            self.nai4_character_list = []
            self.nai4_character_uc_list = []
            self.nai4_character_list_freeze = []
            self.nai4_character_uc_list_freeze = []
            _ix = 0
            _ctext = ""
            self.naid4_selected_character_textbox.configure(state = "normal")
            self.naid4_selected_character_textbox.delete("0.0", "end")
            for frame_dict in self.character_frames:
                _ix += 1
                textbox = frame_dict['textbox']  # 각 프레임의 textbox 참조
                content = textbox.get("0.0", "end")
                content = [k.strip() for k in content.split(',')]
                global_content = []
                if '<' in textbox.get("0.0", "end") or '__' in textbox.get("0.0", "end"):
                    wildcard_present = True
                    itc = 0
                    temp_content = content.copy()  # content의 복사본을 사용
                    while (wildcard_present and itc < 10):
                        if not isinstance(temp_content, list): 
                            temp_content = NAIA_random_function_core.process_fix_prompt(temp_content)
                        elif any(', ' in item for item in temp_content):
                            temp_fixed_str = ', '.join(temp_content)
                            temp_content = temp_fixed_str.split(', ')
                            temp_content = NAIA_random_function_core.process_fix_prompt(temp_content)
                            temp_content = [k.strip() for k in temp_content]
                        wildcard_present = False
                        #### 단계 1 : 인스턴트 와일드카드 처리 ###
                        for i, keyword in enumerate(temp_content):
                            if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                wildcard_present = True
                                vbar_check = keyword[1:-1]
                                if '|' in vbar_check:
                                    choices = vbar_check.split('|')  # '|'를 기준으로 split
                                    choice_dic = {}
                                    for choice in choices:
                                        match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                        if match:
                                            value, keyword = float(match.group(1)), match.group(2).strip()
                                        else:
                                            value, keyword = 1, choice.strip()
                                        choice_dic[keyword] = value
                                    keywords = list(choice_dic.keys())
                                    weights = list(choice_dic.values())
                                    selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                    temp_content[i] = selected_instant_wildcard

                        #### 단계 2 : 글로벌 와일드카드 처리 ###
                        i = 0
                        while i < len(temp_content):
                            keyword = temp_content[i]
                            if "<" in keyword and not keyword.startswith('<lora:') and ">" in keyword and "|" not in keyword or '__' in keyword:
                                wildcard_present = True
                                input_str = keyword.strip().strip('<>')
                                
                                if "__" in input_str:
                                    adjectives = re.findall(r'__(.*?)__', input_str)
                                    first_keyword, last_keyword = re.split(r'__.*?__', input_str)[0], re.split(r'__.*?__', input_str)[-1]
                                    if last_keyword:
                                        split_result = last_keyword.split('>', 1)
                                        wc_keyword = split_result[0].strip()
                                        last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                    else: 
                                        wc_keyword = ""
                                    
                                    adjective_string = ""
                                    for adjective in adjectives:
                                        adjective_result = self.get_wildcard_naid4(adjective)
                                        # 와일드카드 결과 검증
                                        if ("<lora:" not in adjective_result and ('__' in adjective_result or ('<' in adjective_result and '>' in adjective_result))):
                                            wildcard_present = True
                                            # 현재 인덱스에서 처리를 중단하고 다음 반복으로
                                            adjective_result.replace("<","__").replace(">","__")
                                        if adjective_result.startswith(":") and adjective_result:                   
                                            if adjective_string: 
                                                adjective_string = adjective_string.rstrip() + adjective_result  
                                            else:  
                                                adjective_string += adjective_result  # 전체 추가
                                        else:
                                            adjective_string += adjective_result + " "
                                    
                                    wc_result = self.get_wildcard_naid4(wc_keyword)
                                    # 와일드카드 결과 검증
                                    if ('__' in wc_result or ('<' in wc_result and '>' in wc_result)):
                                        wildcard_present = True
                                        # 현재 인덱스에서 처리를 중단하고 다음 반복으로
                                        wc_result.replace("<","__").replace(">","__")
                                    if not wc_result.startswith(":") and wc_result and not wc_result.startswith(")") and not wc_result.startswith("]"): wc_result = ' '+wc_result    
                                    temp_content[i] = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                    i += 1
                                else:
                                    out_wildcard = self.get_wildcard_naid4(input_str)
                                    # 와일드카드 결과 검증
                                    if ('__' in out_wildcard or ('<' in out_wildcard and '>' in out_wildcard)):
                                        wildcard_present = True
                                        temp_content[i] = out_wildcard
                                        break
                                        
                                    if ',' in out_wildcard:
                                        split_wc = [item.strip() for item in out_wildcard.split(',')]
                                        temp = []
                                        for _key in split_wc[1:]:
                                            temp.append(_key)
                                        if temp:
                                            for _key in temp:
                                                if _key.startswith('*'):
                                                    split_wc[split_wc.index(_key)] = _key[1:]
                                                else:
                                                    split_wc.remove(_key)
                                                    global_content.append(_key)
                                        if len(split_wc) == 2 and '{' not in split_wc[1] and '[' not in split_wc[1] and (split_wc[1].endswith('}') or split_wc[1].endswith(']')):
                                            wc_post = split_wc[1].replace(']','').replace('}','')
                                            global_content.append(wc_post)
                                            split_wc[0] += split_wc[1].replace(wc_post, '')
                                            split_wc.pop()
                                        out_wildcard = ', '.join(split_wc)
                                    temp_content[i] = out_wildcard
                                    i += 1
                            else:
                                i += 1
                                
                        itc += 1
                        if not wildcard_present:
                            break
                    
                    # 처리가 끝난 후 원본 content 업데이트
                    content = temp_content.copy()
                result_content = ', '.join(content)
                if content[0] != "girl" and content[0] != "boy":
                    _ctext += f"{content[0]}, "
                elif len(content) >= 2:
                    _ctext += f"{content[1]}, "
                else:
                    _ctext += f"null, "
                if global_content: result_content += ', '+', '.join(global_content)
                self.nai4_character_list.append(result_content)
                _uc = frame_dict['uc'] 
                _uc = _uc.get("0.0", "end")
                _uc = [k.strip() for k in _uc.split(',')]
                uc = ', '.join(_uc)
                self.nai4_character_uc_list.append(uc)
            self.naid4_selected_character_textbox.insert("0.0", _ctext)
            self.naid4_selected_character_textbox.configure(state="disabled")

        def update_position_image():
            colors = [
                (255, 182, 193),  # 연한 분홍색 (Light Pink)
                (173, 216, 230),  # 연한 파란색 (Light Blue)
                (144, 238, 144),  # 연한 녹색 (Light Green)
                (255, 255, 153),  # 연한 노란색 (Light Yellow)
                (216, 191, 216),  # 연한 보라색 (Light Purple)
                (250, 218, 185)   # 연한 주황색 (Light Orange)
            ]

            img = Image.new('RGB', (25, 25), "#4B4B4B")
            draw = ImageDraw.Draw(img)

            position_counts = {}
            
            for idx, pos in enumerate(self.naid4_positions):
                if pos is not None:  # None이 아닌 위치만 처리
                    col = ord(pos[0]) - ord('A')  # A=0, B=1, ..., E=4
                    row = int(pos[1]) - 1  # 1=0, 2=1, ..., 5=4

                    if pos in position_counts:
                        position_counts[pos] += 1
                        offset = position_counts[pos]
                    else:
                        position_counts[pos] = 0
                        offset = 0

                    x_offset = offset * 1
                    y_offset = offset * 1

                    x = col * 5 + x_offset
                    y = row * 5 + y_offset

                    if x < 21 and y < 21:
                        color = colors[idx % len(colors)]  
                        draw.rectangle([x, y, x+4, y+4], fill=color, outline=None)

            ctk_img = customtkinter.CTkImage(light_image=img, size=(50, 50))
            self.pos_viewer.configure(image=ctk_img)

            self.pos_viewer._image = ctk_img

        def ai_choice_update():
            if self.ai_choice.get() == 0:
                for button in self.naid4_cps:
                    button.configure(state="normal")
            else:
                for button in self.naid4_cps:
                    button.configure(state="disabled")                

        def update_naid4_size():
            if self.naid4_characters_frame_size_weight == 1:
                self.naid4_characters_plus.configure(text="-")
                self.naid4_characters_frame_size_weight = 2
            else:
                self.naid4_characters_plus.configure(text="+")
                self.naid4_characters_frame_size_weight = 1
            for _dict in self.character_frames:
                _dict['textbox'].configure(height= 65 * self.naid4_characters_frame_size_weight)
                _dict['uc'].configure(height= 25 * self.naid4_characters_frame_size_weight)

        self.naid4_characters_update = customtkinter.CTkButton(self.naid4_characters_frame, width=25, height=20, font=large_font, text="적용", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", command=naid4_character_update)
        self.naid4_characters_update.grid(row=0, column=2, sticky="n")
        self.naid4_characters_plus = customtkinter.CTkButton(self.naid4_characters_frame, width=5, height=20, font=large_font, text="+", fg_color="grey", hover_color="grey10", command=update_naid4_size)
        self.naid4_characters_plus.grid(row=0, column=1, sticky="e")
        self.ai_choice = customtkinter.CTkCheckBox(self.image_generation_frame, text="AI Choice", font=my_font, width=45, height=20, text_color="#F4F4C3", command=ai_choice_update)
        self.ai_choice.select()
        temp_5_5_image = Image.new('RGB', (25, 25), "#4B4B4B")
        temp_photo = customtkinter.CTkImage(temp_5_5_image, size=(50,50))
        self.pos_viewer = customtkinter.CTkLabel(self.image_generation_frame, text="", image=temp_photo)
        self.naid4_position_frame = customtkinter.CTkFrame(self.image_generation_frame, width=490, height=28)
        self.naid4_positions = ["C3", None, None, None, None, None]
        self.cp1 = customtkinter.CTkButton(self.naid4_position_frame, text="Character1 : C3", command= lambda: PositionSelector(self.cp1, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#FFB6C1", fg_color="grey10", hover_color="grey", state="disabled")
        self.cp1.grid(row=0, column=0, padx=2, pady=2, sticky="nsew")
        self.cp2 = customtkinter.CTkButton(self.naid4_position_frame, text="Character2 : C3", command= lambda: PositionSelector(self.cp2, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#ADD8E6", fg_color="grey10", hover_color="grey", state="disabled")
        self.cp3 = customtkinter.CTkButton(self.naid4_position_frame, text="Character3 : C3", command= lambda: PositionSelector(self.cp3, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#90EE90", fg_color="grey10", hover_color="grey", state="disabled")
        self.cp4 = customtkinter.CTkButton(self.naid4_position_frame, text="Character4 : C3", command= lambda: PositionSelector(self.cp4, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#FFFF99", fg_color="grey10", hover_color="grey", state="disabled")
        self.cp5 = customtkinter.CTkButton(self.naid4_position_frame, text="Character5 : C3", command= lambda: PositionSelector(self.cp5, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#D8BFD8", fg_color="grey10", hover_color="grey", state="disabled")
        self.cp6 = customtkinter.CTkButton(self.naid4_position_frame, text="Character6 : C3", command= lambda: PositionSelector(self.cp6, self.naid4_positions, v_large_font, self.pos_viewer), font=my_font, width = 100, height=20, text_color="#FADAB9", fg_color="grey10", hover_color="grey", state="disabled")
        self.naid4_cps = [self.cp1, self.cp2, self.cp3, self.cp4, self.cp5, self.cp6]
        self.naid4_selected_character_textbox = customtkinter.CTkTextbox(self.naid4_characters_frame, width=490, height=20, font=large_font, state="disabled", text_color="#F5F3C2")
        self.naid4_selected_character_textbox.grid(row=1, column=0, columnspan=3, sticky="nsew")
        self.character_frames = []
        add_new_character(
            self.naid4_characters_frame,
            large_font,
            v_large_font,
            self.character_frames
        )

        
        self.turbo_logic_window = None
        self.turbo_mode = 1
        self.turbo_transform_lines = []
        self.use_first_image = customtkinter.IntVar(value = 0)
        self.use_cont_image = customtkinter.IntVar(value = 0)
        self.event_viewer_checkbox = None
        self.event_viewer_textbox = None
        self.event_viewer_window = None
        self.event_activate_resolution = customtkinter.IntVar(value = 0)
        self.t2i_porn_vibe = customtkinter.IntVar(value = 0)
        self.event_reorder_checkbox = None
        self.event_option = {}
        self.event_yolo_checkbox = None
        self.event_automation_copy_button = None

        def open_turbo_logic():
            if self.turbo_logic_window is None:
                turbo_logic_window_open()
            else:
                if self.turbo_logic_window.state() == 'withdrawn':
                    self.turbo_logic_window.deiconify()
                else:
                    self.turbo_logic_window.lift()

        def open_event_viewer():
            if self.event_viewer_window is None:
                event_viewer_window_open()
            else:
                if self.event_viewer_window.state() == 'withdrawn':
                    self.event_viewer_window.deiconify()
                else:
                    self.event_viewer_window.lift()

        self.event_image_view = None
        self.event_image_view_listbox = None
        self.event_list_show = None
        def event_viewer_window_open():
            event_viewer_window = customtkinter.CTkToplevel()
            self.event_viewer_window = event_viewer_window
            event_viewer_window.title("이벤트 뷰어")
            #event_viewer_window.resizable(width=False, height=False)                  
            transform_text = customtkinter.CTkTextbox(event_viewer_window, font=v_large_font, width=430, height=730)
            transform_text.grid(row=0, column=1, sticky="nsew")
            image_frame = customtkinter.CTkScrollableFrame(event_viewer_window,  fg_color="#242424", width=138, height=730)
            image_frame.grid(row=0, column=2, sticky="n")
            self.event_viewer_textbox = transform_text
            self.event_viewer_textbox.tag_config("hl", foreground="#FFFF97")
            self.event_viewer_textbox.tag_config("hl2", foreground="white")
            self.event_image_view = image_frame
            extra_function_frame = customtkinter.CTkFrame(event_viewer_window,  fg_color="#242424")
            extra_function_frame.grid(row=1, column=0, columnspan=3, sticky="w")

            def show(event=None):
                selected_indices = listbox.curselection()
                keyword = listbox.get(selected_indices[0])
                event_file_path = os.path.join('t3_event', str(keyword))

                if os.path.exists(event_file_path):
                    try:
                        with open(event_file_path, 'r', encoding='utf-8') as f:
                            ev_list = json.load(f)
                    except FileNotFoundError: ev_list = {}
                    except json.JSONDecodeError: ev_list = {}
                    if ev_list:
                        if "text" in ev_list:
                            self.event_viewer_textbox.delete("0.0", "end")
                            self.event_viewer_textbox.insert("0.0", ev_list["text"])
                            text = self.event_viewer_textbox.get("0.0", "end")
                            # 하이라이트할 단어와 태그 매핑
                            highlight_map = {
                                "parent:": "hl",
                                "start prompt ": "hl2",
                                "event step ": "hl2",
                                "      add ": "hl",
                                "      rem ": "hl2"
                            }
                            # 텍스트 라인을 한 줄씩 순회
                            for line_num, line_text in enumerate(text.splitlines(), start=1):
                                for keyword, tag in highlight_map.items():
                                    # 특정 단어가 라인에 포함되어 있을 때 해당 구간을 하이라이트
                                    start_idx = line_text.find(keyword)
                                    if start_idx != -1:
                                        # 텍스트 위치 계산 (line_num은 텍스트 상의 라인 번호, start_idx는 해당 라인 내의 시작 인덱스)
                                        start_pos = f"{line_num}.{start_idx}"
                                        # 해당 구간을 라인의 끝까지 하이라이트
                                        end_pos = f"{line_num}.end"
                                        # 해당 구간에 태그 적용
                                        self.event_viewer_textbox.tag_add(tag, start_pos, end_pos)
                        for widget in self.event_image_view.winfo_children():
                            widget.destroy()
                        for key in sorted(ev_list.keys()):
                            if key == "text": continue
                            value = ev_list[key]
                            image_stream = io.BytesIO(base64.b64decode(value))
                            reloaded_image = Image.open(image_stream)
                            _label1 = customtkinter.CTkLabel(self.event_image_view, text=f"[{key}]", font=my_font, width=128)
                            _label1.grid(row=int(key)*2, column=1, padx=5, sticky="n")
                            _label2 = customtkinter.CTkLabel(self.event_image_view, text="", image=customtkinter.CTkImage(reloaded_image, size=(128,128)), width=128)
                            _label2.grid(row=int(key)*2+1, column=1, padx=5, sticky="n")
            self.event_list_show = show

            listbox = tk.Listbox(event_viewer_window, width=22, height=43, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
            listbox.grid(row = 0, column=0, padx=5, pady=5, sticky="nsew")
            listbox.bind('<<ListboxSelect>>', show)
            self.event_image_view_listbox = listbox

            def skip():
                self.prior_queue.clear()
                random_function()

            def on_close():
                event_viewer_window.withdraw()

            def call():
                _text = call_event_entry.get().strip()
                try:
                    if not app.event_df[(app.event_df['id'] == int(_text)) & (app.event_df['has_children'] == True)].empty:
                        self.prior_queue.clear()
                        random_function(app.event_df[(app.event_df['id'] == int(_text))])
                    else:
                        call_event_entry.delete(0, "end")
                        call_event_entry.insert(0, "Invalid")
                except:
                    call_event_entry.delete(0, "end")
                    call_event_entry.insert(0, "Invalid")                   

            event_skip_button = customtkinter.CTkButton(extra_function_frame, font=my_font, text="스킵", command=skip, width=50)
            event_skip_button.grid(row=0, column=0, sticky="w")
            self.event_skip_button = event_skip_button
            call_event_entry = customtkinter.CTkEntry(extra_function_frame, font=my_font, width=70)
            call_event_entry.grid(row=0, column=0, sticky="w", padx=55)
            jump_button = customtkinter.CTkButton(extra_function_frame, font=my_font, text="호출", command=call, width=50, fg_color="#ED7D31")
            jump_button.grid(row=0, column=0, sticky="w", padx=130)
            self.event_jump_button = jump_button
            def autobutton():
                if automation_copy_button.get() == 1: self.automation_button.select()
                else: self.automation_button.deselect()
            automation_copy_button = customtkinter.CTkCheckBox(extra_function_frame, font=my_font, text="자동화 (미러 버튼)", command=autobutton)
            automation_copy_button.grid(row=0, column=1, sticky="w")
            if self.automation_button.get() ==1: automation_copy_button.select()
            self.event_automation_copy_button = automation_copy_button

            event_viewer_window.protocol("WM_DELETE_WINDOW", on_close)

        def turbo_logic_window_open():
            turbo_logic_window = customtkinter.CTkToplevel()
            self.turbo_logic_window = turbo_logic_window
            turbo_logic_window.title("터보(연속) 이미지 생성 옵션 설정")
            turbo_logic_window.attributes('-topmost', True)
            turbo_logic_window.resizable(width=False, height=True)            

            turbo_radio_frame = customtkinter.CTkFrame(turbo_logic_window,  fg_color="#333333", width=400)
            turbo_radio_frame.grid(row=1, column=0, columnspan=2, pady=5, sticky="nsew")

            radio_var = customtkinter.IntVar(value=self.turbo_mode)

            def on_close():
                turbo_logic_window.withdraw()

            def radiobutton_event():
                v = radio_var.get()
                if v == 1: 
                    transform_text.grid(row=3, column=0, columnspan=2, sticky="nsew")
                    try: 
                        randomized_label.grid_forget()
                        randomized_label0.grid_forget()
                        randomized_entry0.grid_forget()
                        randomized_label1.grid_forget()
                        randomized_entry1.grid_forget()
                        turbo_label2.grid_forget()
                        turbo_label3.grid_forget()
                        randomized_label2.grid_forget()
                        randomized_entry.grid_forget()
                        randomized_label3.grid_forget()
                        randomized_entry3.grid_forget()
                        use_first_image.grid_forget()
                        use_cont_image.grid_forget()
                        event_viewer_checkbox.grid_forget()
                        event_resolution_checkbox.grid_forget()
                        event_control_frame.grid_forget()
                    except: pass
                    transform_text.configure(state="disabled", text_color="grey")
                    transform_assign.configure(text="닫기")
                    activate_vibe_transfer.grid(row=4, column=0, columnspan=2, sticky="w")
                elif v == 2:
                    transform_text.grid(row=3, column=0, columnspan=2, sticky="nsew")
                    turbo_label2.grid(row=2, column=0, columnspan=2, sticky="n")
                    turbo_label3.grid(row=4, column=0, columnspan=2, sticky="n")
                    use_first_image.grid(row=5, column=0, columnspan=2, sticky="n")
                    use_cont_image.grid(row=6, column=0, columnspan=2, sticky="n")
                    try:
                        randomized_label.grid_forget()
                        randomized_label0.grid_forget()
                        randomized_entry0.grid_forget()
                        randomized_label1.grid_forget()
                        randomized_entry1.grid_forget()
                        randomized_label2.grid_forget()
                        randomized_entry.grid_forget()
                        randomized_label3.grid_forget()
                        randomized_entry3.grid_forget()
                        event_viewer_checkbox.grid_forget()
                        event_resolution_checkbox.grid_forget()
                        event_control_frame.grid_forget()
                        activate_vibe_transfer.grid_forget()
                    except: pass
                    transform_text.configure(state="normal", text_color="#DCE4EE")
                    transform_assign.configure(text="탑재")
                else:
                    transform_text.grid_forget()
                    try:
                        turbo_label2.grid_forget()
                        turbo_label3.grid_forget()
                        use_first_image.grid_forget()
                        use_cont_image.grid_forget()
                        activate_vibe_transfer.grid_forget()
                    except: pass
                    randomized_label.grid(row=2, column=0, columnspan=2, pady=2, sticky="nsew")
                    randomized_label0.grid(row=3, column=0, columnspan=2, pady=2, sticky="nsew")
                    randomized_entry0.grid(row=4, column=0, columnspan=2, pady=2, sticky="n")
                    randomized_label1.grid(row=5, column=0, columnspan=2, pady=2, sticky="nsew")
                    randomized_entry1.grid(row=6, column=0, columnspan=2, pady=2, sticky="n")
                    randomized_label2.grid(row=7, column=0, columnspan=2, pady=2, sticky="nsew")
                    randomized_entry.grid(row=8, column=0, columnspan=2, pady=2, sticky="n")
                    randomized_label3.grid(row=9, column=0, columnspan=2, pady=2, sticky="nsew")
                    randomized_entry3.grid(row=10, column=0, columnspan=2, pady=2, sticky="n")
                    event_viewer_checkbox.grid(row=11, column=0, columnspan=2, pady=2, sticky="n")
                    event_resolution_checkbox.grid(row=12, column=0, columnspan=2, pady=2, sticky="n")
                    event_control_frame.grid(row=13, column=0, columnspan=2, pady=2, sticky="n")
                    transform_assign.configure(text="할당")


            turbo_label = customtkinter.CTkLabel(turbo_logic_window, text="연속 이미지 생성 옵션", font=my_font)
            turbo_label.grid(row=0, column=0, columnspan=2, sticky="n")

            turbo_label2 = customtkinter.CTkLabel(turbo_logic_window, text="Transform 자동화 (테스트용, 엔터로 구분)", font=my_font)
            randomized_label0 = customtkinter.CTkLabel(turbo_logic_window, text="parent는 다음 프롬프트를 가지고 있어야 합니다 (쉼표로 구분, 프로그램이 잠시 멈춤니다)", font=my_font)
            randomized_entry0 = customtkinter.CTkEntry(turbo_logic_window, font=my_font, width=440)
            randomized_label1 = customtkinter.CTkLabel(turbo_logic_window, text="parent는 다음 프롬프트를 제외 합니다", font=my_font)
            randomized_entry1 = customtkinter.CTkEntry(turbo_logic_window, font=my_font, width=440)
            randomized_label2 = customtkinter.CTkLabel(turbo_logic_window, text="child는 다음 프롬프트를 포함해야 합니다", font=my_font)
            randomized_entry = customtkinter.CTkEntry(turbo_logic_window, font=my_font, width=440)
            randomized_label3 = customtkinter.CTkLabel(turbo_logic_window, text="child는 다음 프롬프트를 포함해서는 안됩니다 (추가 검색 시간 소모)", font=my_font)
            randomized_entry3 = customtkinter.CTkEntry(turbo_logic_window, font=my_font, width=440)
            randomized_entry0.insert(0, app.search_label_entry.get())
            randomized_entry1.insert(0, app.exclude_label_entry.get()) 
            event_viewer_checkbox = customtkinter.CTkCheckBox(turbo_logic_window, font=my_font,text="이벤트 뷰어를 활성화 합니다")
            event_viewer_checkbox.select()
            event_resolution_checkbox = customtkinter.CTkCheckBox(turbo_logic_window, font=my_font,text="추천 해상도를 적용 합니다")
            self.event_activate_resolution =  event_resolution_checkbox
            self.event_viewer_checkbox = event_viewer_checkbox
            

            event_control_frame = customtkinter.CTkFrame(turbo_logic_window, fg_color="#242424")
            ev_img_reference_number_label = customtkinter.CTkLabel(event_control_frame, text="멀티바이브 최대 이미지 수 (1을 권장합니다) : ", font=my_font)
            ev_img_reference_number_entry = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_img_reference_number_entry.insert(0, "1")
            ev_img_reference_number_label.grid(row=0,column=0, padx=5, pady=2, sticky="n")
            ev_img_reference_number_entry.grid(row=0,column=1, padx=5, pady=2, sticky="w")
            ev_img_reference_ie_label = customtkinter.CTkLabel(event_control_frame, text="Information Extract 강도 : ", font=my_font)
            ev_img_reference_ie_label.grid(row=1,column=0, padx=5, pady=2, sticky="n")
            ev_img_reference_ie_entry = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_img_reference_ie_entry.insert(0, "1.0")
            ev_img_reference_ie_entry.grid(row=1,column=1, padx=5, pady=2, sticky="w")
            ev_img_reference_irs_label = customtkinter.CTkLabel(event_control_frame, text="Reference Strength 강도 : ", font=my_font)
            ev_img_reference_irs_label.grid(row=2,column=0, padx=5, pady=2, sticky="n")
            ev_img_reference_irs_entry = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_img_reference_irs_entry.insert(0, "0.6")
            ev_img_reference_irs_entry.grid(row=2,column=1, padx=5, pady=2, sticky="w")
            ev_img_instant_delete_checkbox = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="[주의] 현재 스텝의 이미지를 재생성하면 이전 이미지를 삭제합니다", text_color="#FFFF97")
            ev_img_instant_delete_checkbox.grid(row=3,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            ev_fimg_reference_optional = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="IE/RS 값 휘발 옵션 활성화")
            ev_fimg_reference_optional.grid(row=4,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            ev_fimg_reference_optional.select()
            ev_img_reference_ie_volatile_label = customtkinter.CTkLabel(event_control_frame, text="매 스텝마다 오래된 vibe 이미지의 IE값을 줄입니다 : ", font=my_font)
            ev_img_reference_ie_volatile_label.grid(row=5,column=0, padx=5, pady=2, sticky="n")
            ev_img_reference_ie_volatile_entry = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_img_reference_ie_volatile_entry.grid(row=5,column=1, padx=5, pady=2, sticky="w")
            ev_img_reference_ie_volatile_entry.insert(0, "0.75")
            ev_img_reference_irs_volatile_label = customtkinter.CTkLabel(event_control_frame, text="매 스텝마다 오래된 vibe 이미지의 RS값을 줄입니다 : ", font=my_font)
            ev_img_reference_irs_volatile_label.grid(row=6,column=0, padx=5, pady=2, sticky="n")
            ev_img_reference_irs_volatile_entry =  customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_img_reference_irs_volatile_entry.grid(row=6,column=1, padx=5, pady=2, sticky="w")
            ev_img_reference_irs_volatile_entry.insert(0, "0.42")
            ev_fix_or_not_fix = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="동적 시드 고정 옵션 활성화 (생성중 랜덤 버튼 사용 불가)", text_color="#FFFF97")
            ev_fix_or_not_fix.grid(row=7,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            ev_seed_fix_label = customtkinter.CTkLabel(event_control_frame, text="step difference가 이것 보다 낮으면 이번 시드를 고정합니다 : ", font=my_font)
            ev_seed_fix_label.grid(row=8,column=0, padx=5, pady=2, sticky="n")
            ev_seed_fix_entry = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_seed_fix_entry.grid(row=8,column=1, padx=5, pady=2, sticky="w")
            ev_seed_fix_entry.insert(0, "11")
            event_reorder_checkbox = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="스텝별 프롬프트 재배열/강조/동적 바이브 선행 고정 내 마지막 , #태그, 추적")
            event_reorder_checkbox.grid(row=9,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            self.event_reorder_checkbox = event_reorder_checkbox
            event_reorder_checkbox.select()
            event_yolo_checkbox = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="YOLO를 이용해 vibe로 인한 표정 고정 현상을 방지합니다")
            event_yolo_checkbox.grid(row=10,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            self.event_yolo_checkbox = event_yolo_checkbox
            page_length_checkbox = customtkinter.CTkCheckBox(event_control_frame, font=my_font,text="이벤트 길이를 제한합니다")
            page_length_checkbox.grid(row=11,column=0, columnspan=2, padx=5, pady=2, sticky="n")
            ev_max_page_length_label = customtkinter.CTkLabel(event_control_frame, text="최대 이벤트 길이를 제한합니다 : ", font=my_font)
            ev_max_page_length_label.grid(row=12,column=0, padx=5, pady=2, sticky="n")
            ev_max_page_length = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_max_page_length.grid(row=12,column=1, padx=5, pady=2, sticky="w")
            ev_max_page_length.insert(0, "100")
            ev_min_page_length_label = customtkinter.CTkLabel(event_control_frame, text="최소 이벤트 길이를 제한합니다 : ", font=my_font)
            ev_min_page_length_label.grid(row=13,column=0, padx=5, pady=2, sticky="n")
            ev_min_page_length = customtkinter.CTkEntry(event_control_frame, font=my_font, width=50)
            ev_min_page_length.grid(row=13,column=1, padx=5, pady=2, sticky="w")
            ev_min_page_length.insert(0, "2")


            turbo_label3 = customtkinter.CTkLabel(turbo_logic_window, text="작성법 : 감정;프롬프트;강도 엔터", font=my_font)
            

            transform_text = customtkinter.CTkTextbox(turbo_logic_window, font=v_large_font, width=400)
            transform_text.grid(row=3, column=0, columnspan=2, sticky="nsew")
            activate_vibe_transfer = customtkinter.CTkCheckBox(turbo_logic_window, font=my_font,text="매 스텝에 vibe transfer를 할당합니다")
            activate_vibe_transfer.grid(row=4, column=0, columnspan=2, sticky="w")
            if app.app_mode == "WEBUI": activate_vibe_transfer.configure(state="disableds")
            self.t2i_porn_vibe = activate_vibe_transfer

            randomized_label = customtkinter.CTkLabel(turbo_logic_window, font=v_large_font, text_color="yellow", width=400, text="검색어 및 제외는 메인화면 상단 검색/제외 키워드를 따라갑니다")

            if not self.turbo_transform_lines:
                transform_text.insert("0.0", "scared;looking at viewer;weak\nscared;closed eyes, tears;weak\ncolorize;crying with eyes open;weakest\nsurprised;scared,embarrassed, open mouth, tears;very weak\ncolorize;determined, empty eyes;weakest")
                transform_text.configure(state="disabled", text_color="grey")
            else:
                _text = ""
                for _line in self.turbo_transform_lines:
                    _l = ";".join(_line)
                    _text = _text + _l +"\n"
                _text = _text[:-1]
                transform_text.insert("0.0", _text)

            em_list = ["Neutral", "Happy", "Sad", "Angry", "Scared", "Surprised", "Tired", "Excited", "Nervous", "Thinking", "Confused", "Shy", "Disgusted", "Smug", "Bored", "Laughing", "Irritated", "Aroused", "Embarrassed", "Worried", "Love", "Determined", "Hurt", "Playful"]
            
            def assign():
                if radio_var.get() == 2:
                    text = transform_text.get("0.0", "end").strip()
                    lines = text.split('\n')
                    new_lines = []
                    for i, line in enumerate(lines):
                        if ';' in line:
                            before_semicolon, after_semicolon = line.split(';', 1)
                            before_semicolon = before_semicolon.strip().title()
                            after_semicolon = after_semicolon.strip()
                            
                            # 검증: em_list에 존재하는지 확인
                            if before_semicolon in em_list or before_semicolon in ["Declutter", "Lineart", "Sketch", "Colorize"]:
                                if before_semicolon in ["Declutter", "Lineart", "Sketch", "Colorize"]:
                                    before_semicolon = before_semicolon.lower()
                                new_lines.append((before_semicolon, after_semicolon))
                            else:
                                transform_assign.configure(text=f"{i+1}행 잘못된 감정 입력")
                                return
                        else:
                            transform_assign.configure(text=f"{i+1}행 ; 누락")
                            return
                    
                    transform_assign.configure(text="탑재")
                    self.turbo_transform_lines = new_lines
                    app.turbo_mode = 2
                    turbo_logic_window.withdraw()
                elif radio_var.get() == 1:
                    app.turbo_mode = 1
                    turbo_logic_window.withdraw()
                else:
                    app.turbo_mode = 3
                    app.event_df = pd.read_parquet(os.path.join(basedir, 'NAIA_event_dataset.parquet')) #.str.contains(keyword, na=False)
                    app.event_df_parent  = app.event_df[app.event_df["has_children"]]
                    num_of_cpu = os.cpu_count()//2 if os.cpu_count() <= 20 else  os.cpu_count()//3
                    if num_of_cpu == 0: num_of_cpu = 1
                    memory_info = psutil.virtual_memory()
                    available_memory_gb = memory_info.available / (1024 ** 3)
                    memory_based_cpu_count = int(available_memory_gb)
                    num_of_cpu = min(num_of_cpu, memory_based_cpu_count)
                    app.event_df_parent = NAIA_search.search(app.event_df_parent, randomized_entry0.get(), randomized_entry1.get())
                    print(len(app.event_df_parent))
                    if type(app.event_df_parent) != type(None):
                        if len(randomized_entry.get()) or len(randomized_entry3.get()):
                            temp_parent_list = app.event_df_parent['id'].tolist()
                            start_time = time.time()
                            _mode = "normal"
                            if len(app.event_df_parent) > 2000: _mode = "vheavy"
                            elif len(app.event_df_parent) > 1000: _mode = "heavy"
                            elif len(app.event_df_parent) > 500: _mode = "high"
                            parents_to_remove = []
                            if(_mode == "normal"):
                                for parent in temp_parent_list:
                                    lx = app.event_df[app.event_df['parent_id'] == parent]['id'].tolist()
                                    df =  app.event_df[app.event_df['id'].isin(lx)]
                                    df = NAIA_search.search(df, randomized_entry.get(), "")
                                    if type(df) == type(None) or len(df): 
                                        parents_to_remove.append(parent)
                                        app.event_df_parent = app.event_df_parent[~app.event_df_parent['id'].isin(parents_to_remove)]
                            else:
                                if _mode != "vhevy":
                                    if _mode == "heavy": num_of_cpu = min(4, num_of_cpu)
                                    elif _mode == "high": num_of_cpu = 2
                                if num_of_cpu == 0: num_of_cpu = 1
                                chunk_size = math.ceil(len(temp_parent_list) / num_of_cpu)
                                parent_chunks = [temp_parent_list[i:i + chunk_size] for i in range(0, len(temp_parent_list), chunk_size)]
                                event_df_data = app.event_df
                                pr = randomized_entry.get()
                                nr = randomized_entry3.get()
                                with multiprocessing.Pool(processes=num_of_cpu) as pool:
                                    iterable = [(chunk, pr, nr, event_df_data) for chunk in parent_chunks]
                                    results = pool.starmap(process_parent, iterable)
                                parents_to_remove = [parent for sublist in results for parent in sublist]
                                app.event_df_parent = app.event_df_parent[~app.event_df_parent['id'].isin(parents_to_remove)]
                            end_time = time.time()
                            response_time = round(end_time - start_time, 2)
                            print(f"time : {response_time}")
                        if type(app.event_df_parent) != type(None) and page_length_checkbox.get()==1:
                            parents_to_remove = []
                            try:
                                emax = int(ev_max_page_length.get())
                                emin = int(ev_min_page_length.get())
                            except:
                                emax = 100
                                emin = 2
                            temp_parent_list = app.event_df_parent['id'].tolist()
                            for parent in temp_parent_list:
                                lx = app.event_df[app.event_df['parent_id'] == parent]['id'].tolist()
                                if len(lx) > emax-1 or len(lx) < emin-1: 
                                    parents_to_remove.append(parent)
                            app.event_df_parent = app.event_df_parent[~app.event_df_parent['id'].isin(parents_to_remove)]
                    if type(app.event_df_parent) == type(None):
                        app.image_label_report.configure(state="normal")
                        app.image_label_report.delete("0.0", "end")
                        app.image_label_report.insert("0.0", f"매칭되는 이벤트가 없습니다. 다시 검색해주세요.")
                        app.image_label_report.configure(text_color="#FFFF97")
                        app.image_label_report.configure(state="disabled")
                        return
                    app.event_df_parent = app.event_df_parent['id'].tolist()
                    #app.automation_button.select()
                    app.turbo_button.select()
                    app.image_label_report.configure(state="normal")
                    app.image_label_report.delete("0.0", "end")
                    app.image_label_report.insert("0.0", f"캐싱된 이벤트 수 : {len(app.event_df_parent)} 입니다.")
                    app.image_label_report.configure(text_color="#FFFF97")
                    app.image_label_report.configure(state="disabled")
                    if event_viewer_checkbox.get(): open_event_viewer()
                    if self.event_activate_resolution.get() == 1:
                        self.random_resolution_button.deselect()
                    app.event_option = {
                        "multivibe_max" : ev_img_reference_number_entry.get(),
                        "ie_value" : ev_img_reference_ie_entry.get(),
                        "irs_value" : ev_img_reference_irs_entry.get(),
                        "rem_prev" : False if ev_img_instant_delete_checkbox.get() == 0 else True,
                        "ie_irs_voltile" : False if ev_fimg_reference_optional.get() == 0 else True,
                        "ie_voltile" : ev_img_reference_ie_volatile_entry.get(),
                        "irs_voltile" : ev_img_reference_irs_volatile_entry.get(),
                        "fix_seed" : False if ev_fix_or_not_fix.get() == 0 else True,
                        "fix_seed_trhresold" : ev_seed_fix_entry.get()
                    }
                    try: app.event_option["multivibe_max"] = int(app.event_option["multivibe_max"])
                    except: app.event_option["multivibe_max"] = 2
                    try: app.event_option["ie_value"] = float(app.event_option["ie_value"])
                    except: app.event_option["ie_value"] = 0.55
                    try: app.event_option["irs_value"] = float(app.event_option["irs_value"])
                    except: app.event_option["irs_value"] = 0.3
                    if app.event_option["ie_irs_voltile"]:
                        try: app.event_option["ie_voltile"] = float(app.event_option["ie_voltile"])
                        except: app.event_option["ie_voltile"] = 0.05
                        try: app.event_option["irs_voltile"] = float(app.event_option["irs_voltile"])
                        except: app.event_option["irs_voltile"] = 0.05       
                    if app.event_option["fix_seed"]:
                        try: app.event_option["fix_seed_trhresold"] = int(app.event_option["fix_seed_trhresold"])
                        except: app.event_option["fix_seed_trhresold"] = 10
                    turbo_logic_window.withdraw()
                    os.makedirs('t3_event', exist_ok=True)

            def press_ufi():
                if use_first_image.get():
                    use_cont_image.deselect()
            
            def press_uci():
                if use_cont_image.get():
                    use_first_image.deselect()

            use_first_image = customtkinter.CTkCheckBox(turbo_logic_window, variable=self.use_first_image, text="첫 transform 이미지를 고정합니다", font=my_font, command = press_ufi)
            use_first_image.grid(row=5, column=0, columnspan=2, sticky="n")

            use_cont_image = customtkinter.CTkCheckBox(turbo_logic_window, variable=self.use_cont_image, text="매 스텝이 이전 transform 이미지를 참조", font=my_font, command=press_uci)
            use_cont_image.grid(row=6, column=0, columnspan=2, sticky="n")

            transform_assign = customtkinter.CTkButton(turbo_logic_window, font=my_font, text="닫기", command=assign)
            transform_assign.grid(row=15, column=0, columnspan=2, pady=10, sticky="n")

            radio_button_1 = customtkinter.CTkRadioButton(turbo_radio_frame, text="t2i Porn", command=radiobutton_event, variable= radio_var, value=1, font=large_font)
            radio_button_1.grid(row=0, column=0, sticky="n", padx=30)
            radio_button_2 = customtkinter.CTkRadioButton(turbo_radio_frame, text="DT Transform", command=radiobutton_event, variable= radio_var, value=2, font=large_font)
            radio_button_2.grid(row=0, column=1, sticky="n", padx=30)
            radio_button_3 = customtkinter.CTkRadioButton(turbo_radio_frame, text="Randomized", command=radiobutton_event, variable= radio_var, value=3, font=large_font)
            radio_button_3.grid(row=0, column=2, sticky="n", padx=30)

            if app.app_mode != "NAI":
                radio_button_2.configure(state="disabled")

            radiobutton_event()
            turbo_logic_window.protocol("WM_DELETE_WINDOW", on_close)
            turbo_logic_window.after(2000, lambda: turbo_logic_window.attributes('-topmost', False))

        self.turbo_setting_button = customtkinter.CTkButton(self.image_generation_frame, text="✨", font=my_font, fg_color="grey10", hover_color="grey", width=14, height=24, command=open_turbo_logic)
        self.turbo_setting_button.grid(row=1, column=2, sticky="e", padx=5)
        #if self.app_mode != "NAI":
        #    self.turbo_setting_button.configure(state="disabled")

        def fixed_prompt_label_command():
            if self.fixed_prompt_label_var.get() == 0:
                self.fixed_prompt_input.grid_forget()
            else:
                self.fixed_prompt_input.grid(row=4, column=0, pady=5, sticky="nsew")

        def highlight_text_fixed(event=None):
            if '#' in self.fixed_prompt_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.fixed_prompt_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.fixed_prompt_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.fixed_prompt_input.tag_add("highlight", start, end)    

        self.fixed_prompt_label_var = customtkinter.IntVar(value=1)
        if self.app_mode == "NAI":
            self.fixed_prompt_label = customtkinter.CTkCheckBox(self.text_input_frame, text=" ----------------------  선행 고정 프롬프트 (110) ------------------- Steps : ", fg_color="grey10", hover_color="#50164A", font=large_font, variable=self.fixed_prompt_label_var, command=fixed_prompt_label_command, border_color="#333333")
            self.fixed_prompt_label.grid(row = 3, column=0, sticky="w" )
            self.force_steps_entry = customtkinter.CTkEntry(self.text_input_frame, font=my_font, width=50)
            self.force_steps_entry.grid(row = 3, column=0, sticky="e" )
            self.force_steps_entry.insert(0, "28")
        else:
            self.fixed_prompt_label = customtkinter.CTkCheckBox(self.text_input_frame, text=" ----------------------------- 선행 고정 프롬프트 ----------------------------- ", fg_color="grey10", hover_color="#50164A", font=large_font, variable=self.fixed_prompt_label_var, command=fixed_prompt_label_command, border_color="#333333")
            self.fixed_prompt_label.grid(row = 3, column=0, sticky="w" )
        self.fixed_prompt_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['prefix'], font=v_large_font, undo=True)
        self.fixed_prompt_input.grid(row=4, column=0, pady=5, sticky="nsew")
        self.fixed_prompt_input.bind("<FocusOut>", highlight_text_fixed)
        self.fixed_prompt_input.tag_config("highlight", foreground="#FFFF97")
        self.last_search_entry_input = []
        self.last_exclude_entry_input = []

        def strip_brackets(keyword):
            prefix_match = re.match(r'^[\{\[\(]+', keyword)
            prefix = prefix_match.group(0) if prefix_match else ''

            suffix_match = re.search(r'[\}\]\)]+$', keyword)
            suffix = suffix_match.group(0) if suffix_match else ''

            stripped_keyword = keyword[len(prefix):len(keyword) - len(suffix)]
            return stripped_keyword, prefix, suffix

        def restore_brackets(keyword, prefix, suffix):
            return f"{prefix}{keyword}{suffix}"
        
        def update_processed_prompt(textbox, last_fixprompt, new_prompt_list):
            updated_texts = []
            updated_indices = []

            # 수정된 항목의 인덱스 추적
            for index, (new, old) in enumerate(zip(last_fixprompt, new_prompt_list)):
                if old.strip() != new.strip():
                    if self.app_mode == "NAI": updated_texts.append(" " + new.strip())
                    else:
                        if not (new.startswith('(') and new.endswith(')')):
                            updated_texts.append(" " + new.strip().replace('(', '\\(').replace(')', '\\)'))
                        else: updated_texts.append(" " + new.strip())
                    if app.app_mode == "NAI": 
                        updated_indices.append(index)
                    else:
                        updated_indices.append(index)

            if updated_indices:
                for idx in updated_indices:
                    # 기존 문자열 위치 추적 및 교체
                    start_index = textbox.search(new_prompt_list[idx], "1.0", stopindex="end")
                    if start_index:
                        end_index = f"{start_index} + {len(new_prompt_list[idx])} chars"
                        textbox.delete(start_index, end_index)
                        textbox.insert(start_index, updated_texts[updated_indices.index(idx)])

            last_fixprompt[:] = [key.strip() for key in new_prompt_list]

        self.exclude_label_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.exclude_label_entry,
            autocomplete_var=tk.IntVar(value=1),
            wildcard_dict_tree=None
        )

        self.search_label_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.search_label_entry,
            autocomplete_var=tk.IntVar(value=1),
            wildcard_dict_tree=None
        )

        #작가명 제거 및 기타 기능
        self.check_box_frame = customtkinter.CTkFrame(self.text_input_frame, width=490)
        self.check_box_frame.grid(row=5, column=0, pady=5, columnspan=3, sticky="nsew")
        self.rm_artist_name_var = customtkinter.IntVar()
        self.rm_artist_name_button = customtkinter.CTkCheckBox(self.check_box_frame, text="작가명 제거", variable=self.rm_artist_name_var, font=my_font)
        if self.app_mode == "NAI" : 
            self.rm_artist_name_button.grid(row=0, column=0, pady=5, padx=10, sticky="nsew")
        else: 
            self.rm_artist_name_button.select()
            self.rm_artist_name_var.set(1)
            #self.rm_artist_name_button.configure(state="disabled")
            self.rm_artist_name_button.grid(row=0, column=0, pady=5, padx=10, sticky="nsew")
        self.rm_copyright_name_var = customtkinter.IntVar()
        self.rm_copyright_name_button = customtkinter.CTkCheckBox(self.check_box_frame, text="작품명 제거", variable=self.rm_copyright_name_var, font=my_font)
        self.rm_copyright_name_button.grid(row=0, column=1, pady=5, sticky="nsew")


        def rm_characteristic():
            if self.rm_characteristic_var.get() == 1:
                self.rm_character_name_button.deselect()

        self.rm_characteristic_var = customtkinter.IntVar()
        self.rm_characteristic_button = customtkinter.CTkCheckBox(self.check_box_frame, text="캐릭터 특징 제거", variable=self.rm_characteristic_var, font=my_font, command=rm_characteristic)
        self.rm_characteristic_button.grid(row=0, column=2, padx=10, pady=5, sticky="nsew")


        def open_extend_frame():
            if self.rm_extend_var.get() == 1:
                self.rm_extend_frame.grid(row=1, column=0, columnspan=4, pady=5, sticky="nsew")
            else:
                self.rm_extend_frame.grid_forget()

        self.rm_extend_frame = customtkinter.CTkFrame(self.check_box_frame, fg_color="#333333")

        self.rm_extend_var = customtkinter.IntVar()
        self.rm_extend_button = customtkinter.CTkCheckBox(self.check_box_frame, text="확장 기능(+)", variable=self.rm_extend_var, font=my_font, command=open_extend_frame)
        self.rm_extend_button.deselect()
        self.rm_extend_button.grid(row=0, column=3, padx=5, pady=5, sticky="nsew")

        self.nsfw_window = None
        self.current_removed_prompt = ""
        self.rm_nsfw_text1 = None #제외프롬
        self.rm_nsfw_text2= None #허용프롬 (RFP에서 비교 필요)
        self.rm_nsfw_text3= None
        self.rm_nsfw_text4= None
        self.rm_nsfw_label1= None
        self.nsfw_whitelist = []
        self.nsfw_blacklist = []
        self.nsfw_image_label = None
        self.rm_nsfw_disable = None

        def open_nsfw_monitor():
            if self.rm_not_nsfw_button.get() == 1:
                if self.nsfw_window == None:
                    open_nsfw_window()
                else:
                    if self.nsfw_window.state() == 'withdrawn':
                        self.nsfw_window.deiconify()
                    else:
                        self.nsfw_window.lift()
            else:
                self.nsfw_window.withdraw()
                    
        def open_nsfw_window():
            nsfw_window = customtkinter.CTkToplevel()
            self.nsfw_window = nsfw_window
            nsfw_window.title("None-NSFW Remover 개인화")
            nsfw_window.attributes('-topmost', True)

            label1 = customtkinter.CTkLabel(nsfw_window, text="이번 랜덤 프롬프트에서 제외된 프롬프트", font=my_font)
            label1.grid(row =0, column= 1, sticky="n", padx=5, pady=5)
            text1 = customtkinter.CTkTextbox(nsfw_window, height=180, width=390, font=customtkinter.CTkFont('Pretendard', 15), state='disabled')
            text1.grid(row =1, column= 1, sticky="n", padx=5, pady=5)
            self.rm_nsfw_text1 = text1

            if len(self.current_removed_prompt) > 2:
                text1.configure(state="normal")
                text1.insert("0.0",self.current_removed_prompt)
                text1.configure(state="disabled")

            label3 = customtkinter.CTkLabel(nsfw_window, text="이번 랜덤 프롬프트에서 허용된 프롬프트 (조건부 처리 전에 적용)", font=my_font, text_color="#FFFF97")
            label3.grid(row =2, column= 1, sticky="n", padx=5, pady=5)
            text3 = customtkinter.CTkTextbox(nsfw_window, height=90, width=390, font=customtkinter.CTkFont('Pretendard', 15), state='disabled')
            text3.grid(row =3, column= 1, sticky="n", padx=5, pady=5)
            self.rm_nsfw_text2 = text3

            label2 = customtkinter.CTkLabel(nsfw_window, text="프롬프트 화이트리스트", font=my_font, text_color="white")
            label2.grid(row =0, column= 2, sticky="n", padx=5, pady=5)
            text2 = customtkinter.CTkTextbox(nsfw_window, height=328, width=390, font=customtkinter.CTkFont('Pretendard', 15))
            text2.grid(row =1, column= 2, rowspan=4, sticky="n", padx=5, pady=5)
            self.rm_nsfw_text3 = text2

            label4 = customtkinter.CTkLabel(nsfw_window, text="프롬프트 블랙리스트 (제외된 프롬프트에서 음영처리함)", font=my_font, text_color="grey")
            label4.grid(row =0, column= 3, sticky="n", padx=5, pady=5)
            text4 = customtkinter.CTkTextbox(nsfw_window, height=328, width=390, font=customtkinter.CTkFont('Pretendard', 15))
            text4.grid(row =1, column= 3, rowspan=4, sticky="n", padx=5, pady=5)

            label0 = customtkinter.CTkLabel(nsfw_window, text="")
            label0.grid(row =0, column= 0, rowspan=4, sticky="n", padx=5, pady=5)
            label0.configure(image=customtkinter.CTkImage(white_image, size=(360,360)))
            self.nsfw_image_label= label0

            def auto_stop():
                if automation.get():
                    app.automation_button.select()
                else:
                    app.automation_button.deselect()

            button_layer = customtkinter.CTkFrame(nsfw_window)
            button_layer.grid(row=6, column=0, columnspan=4,sticky="w", padx=5, pady=5)

            text5 = customtkinter.CTkTextbox(nsfw_window, height=52, width=1560, font=customtkinter.CTkFont('Pretendard', 14), state="disabled")
            text5.grid(row =5, column= 0, columnspan=4, sticky="w", padx=5, pady=5)
            self.rm_nsfw_text4 = text5

            automation = customtkinter.CTkCheckBox(button_layer, text="자동화 유지", font=my_font, command=auto_stop)
            automation.grid(row =1, column= 0, sticky="w", padx=5, pady=5)

            def generate_on():
                if not app.running_flag and self.image_generation_button.cget("state") != "disabled": 
                   _NAIA_generate()

            generate_image = customtkinter.CTkButton(button_layer, text="이미지 생성", fg_color="#ED7D31", hover_color="#CC5D12", font=my_font, command=generate_on, text_color_disabled="black")
            generate_image.grid(row =1, column= 3, sticky="w", padx=5, pady=5)

            if self.nsfw_whitelist:
                text2.insert("0.0", ', '.join(self.nsfw_whitelist))
            if self.nsfw_blacklist:
                text4.insert("0.0", ', '.join(self.nsfw_blacklist))

            def on_close():
                nsfw_window.withdraw()

            def lfpi():
                save_button.configure(state="normal", text="저장")

            def save():
                _instant_text = text2.get("0.0", "end")
                whtx = [k.strip() for k in _instant_text.split(',')]
                self.nsfw_whitelist[:] = whtx
                _instant_text2 = text4.get("0.0", "end")
                bltx = [k.strip() for k in _instant_text2.split(',')]
                self.nsfw_blacklist[:] = bltx
                save_button.configure(state="disabled", text="저장됨")
                nsfw_window.after(3000, lambda: lfpi())

            def rand_func():
                save()
                _random_function()

            def reopen():
                save()
                self.control_pressed = True
                _random_function()

            #command=_random_function
            save_button = customtkinter.CTkButton(button_layer, text="저장", font=my_font, command=save, width=52)
            save_button.grid(row =1, column= 1, sticky="n", padx=5, pady=5)

            random_button = customtkinter.CTkButton(button_layer, text="랜덤/다음 프롬프트", font=my_font, command=rand_func, fg_color="grey10", hover_color="grey")
            random_button.grid(row =1, column= 2, sticky="n", padx=5, pady=5)

            random_buttonb = customtkinter.CTkButton(button_layer, text="프롬프트 재개봉 (검증)", font=my_font, command=reopen, fg_color="grey", hover_color="grey10", text_color="white")
            random_buttonb.grid(row =1, column= 4, sticky="n", padx=5, pady=5)

            rm_nsfw_disable = customtkinter.CTkCheckBox(button_layer, text="화이트리스트 일시적 비활성화",  font=my_font)
            rm_nsfw_disable.grid(row =2, column= 0, sticky="n", padx=5, pady=5)
            self.rm_nsfw_disable = rm_nsfw_disable

            rm_label = customtkinter.CTkLabel(button_layer, text="", font=customtkinter.CTkFont('Pretendard', 13))
            rm_label.grid(row =1, column= 5, sticky="n", padx=5, pady=5)
            self.rm_nsfw_label1 = rm_label

            nsfw_window.protocol("WM_DELETE_WINDOW", on_close)
            nsfw_window.after(1000, lambda: nsfw_window.attributes('-topmost', False))

        self.rm_not_nsfw_var = customtkinter.IntVar()
        self.rm_not_nsfw_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="NSFW 제외 전부 제거", variable=self.rm_not_nsfw_var, command=open_nsfw_monitor, font=my_font)

        self.rm_color_var = customtkinter.IntVar()
        self.rm_color_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="의류 색상 제거", variable=self.rm_color_var, font=my_font)

        self.rm_location_var = customtkinter.IntVar()
        self.rm_location_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="장소/배경색 제거", variable=self.rm_location_var, font=my_font)

        self.image_reference_frame = customtkinter.CTkFrame(self.rm_extend_frame)

        def clear_seq_dict():
            self.sequential_wildcard.clear()
            self.observer_wildcard.clear()
            self.sequential_wildcard_length.clear()
            self.sequential_wildcard_depth.clear()
            self.rest_sequential.grid_forget()

        def responsive():
            pass

        self.responsive_window = None
        def open_responsive_window():
            responsive_window = customtkinter.CTkToplevel()
            self.responsive_window = responsive_window
            responsive_window.title("반응형 프롬프트 감도 설정")
            responsive_window.attributes('-topmost', True)
            responsive_window.resizable(width=False, height=False)

            label1 = customtkinter.CTkLabel(responsive_window, text="검색할 키워드 입력", font=my_font, text_color="yellow")
            label1.grid(row =0, column= 0, sticky="n", padx=5, pady=5)
            entry = customtkinter.CTkEntry(responsive_window, font=my_font, width=140)
            entry.grid(row =1, column= 0, sticky="n", padx=5, pady=5)

        self.freezed_fix = ""

        def recall_fix():
            self.fixed_prompt_input.delete("0.0", "end")
            self.fixed_prompt_input.insert("0.0", self.freezed_fix)
            self.recall_fix.grid_forget()
            self.apply_fix.grid_forget()
            self.freezed_fix = ""

        def appy_fix():
            self.freezed_fix = ""
            self.recall_fix.grid_forget()
            self.apply_fix.grid_forget()

        self.rest_sequential = customtkinter.CTkButton(self.rm_extend_frame, text="순차적 와일드카드 초기화", font=my_font, text_color="#FFFF97", command=clear_seq_dict, fg_color="transparent")
        self.recall_fix = customtkinter.CTkButton(self.rm_extend_frame, text="선행 프롬프트 복원", font=my_font, text_color="#FFFF97", command=recall_fix, fg_color="transparent")
        self.apply_fix = customtkinter.CTkButton(self.rm_extend_frame, text="선행 프롬프트 적용", font=my_font, text_color="#ED7D31", command=appy_fix, fg_color="transparent")
        self.eye_catch = customtkinter.CTkCheckBox(self.rm_extend_frame, text="랜덤프롬 눈 동기화 해제", font=my_font)
        self.eye_catch.grid(row=2, column=0, pady=5,  padx=10, sticky="nsew")
        self.resopnsive_prompt = customtkinter.CTkCheckBox(self.rm_extend_frame, text="반응형 프롬프트", font=my_font, command=responsive)
        self.resopnsive_prompt.grid(row=2, column=1, padx=5, pady=5, sticky="nsew")
        

        def auto_i2i_activate():
            if self.auto_i2i_vibe.get() == 1:
                self.i2i_resolution = 0

        self.auto_i2i_window = None
        self.auto_i2i_option_activate= customtkinter.IntVar()
        self.auto_i2i_t1 = ""
        self.auto_i2i_t2 = ""
        self.auto_i2i_rm_prompt = customtkinter.IntVar()

        def auto_i2i_logic():
            if self.auto_i2i_window is None:
                auto_i2i_window_open()
            else:
                if self.auto_i2i_window.state() == 'withdrawn':
                    self.auto_i2i_window.deiconify()
                else:
                    self.auto_i2i_window.lift()

        def auto_i2i_window_open():
            auto_i2i_window = customtkinter.CTkToplevel()
            self.auto_i2i_window = auto_i2i_window
            auto_i2i_window.title("auto i2i 옵션 설정")
            auto_i2i_window.attributes('-topmost', True)
            auto_i2i_window.resizable(width=False, height=False)            

            def on_close():
                auto_i2i_window.withdraw()

            turbo_label = customtkinter.CTkLabel(auto_i2i_window, text="#캐릭터명, #프롬프트 사이에 교체", font=my_font)
            turbo_label.grid(row=0, column=0, columnspan=2, sticky="n")

            i2i_t1 = customtkinter.CTkTextbox(auto_i2i_window, font=v_large_font, width=400, height=100)
            i2i_t1.grid(row=1, column=0, columnspan=2, sticky="nsew")

            if len(self.auto_i2i_t1) > 4: i2i_t1.insert("0.0", self.auto_i2i_t1)

            turbo_label2 = customtkinter.CTkLabel(auto_i2i_window, text="#프롬프트, 뒤에 추가 (가중치 줘도 잘 안먹습니다)", font=my_font)
            turbo_label2.grid(row=2, column=0, columnspan=2, sticky="n")

            i2i_t2 = customtkinter.CTkTextbox(auto_i2i_window, font=v_large_font, width=400, height=100)
            i2i_t2.grid(row=3, column=0, columnspan=2, sticky="nsew")

            if len(self.auto_i2i_t2) > 4: i2i_t2.insert("0.0", self.auto_i2i_t2)

            def assign():
                self.auto_i2i_t1 = i2i_t1.get("0.0", "end-1c")
                self.auto_i2i_t2 = i2i_t2.get("0.0", "end-1c")
                auto_i2i_window.withdraw()

            rm_prompt = customtkinter.CTkCheckBox(auto_i2i_window, font=my_font, text="캐릭터 특징, nsfw word, 퀄리티 프롬 제외 모두 제거", variable=self.auto_i2i_rm_prompt)
            rm_prompt.grid(row=13, column=0, columnspan=2, sticky="n", pady=5)

            auto_i2i_option_activate = customtkinter.CTkCheckBox(auto_i2i_window, font=my_font, text="이 설정을 활성화 합니다", variable=self.auto_i2i_option_activate)
            auto_i2i_option_activate.grid(row=14, column=0, columnspan=2, sticky="n", pady=5)

            auto_i2i_window_assign = customtkinter.CTkButton(auto_i2i_window, font=my_font, text="적용", command=assign)
            auto_i2i_window_assign.grid(row=15, column=0, columnspan=2, sticky="n")

            auto_i2i_window.protocol("WM_DELETE_WINDOW", on_close)
            auto_i2i_window.after(2000, lambda: auto_i2i_window.attributes('-topmost', False))

        self.auto_e621_tag_window = None

        class SearchWindow(customtkinter.CTkToplevel):
            def __init__(self, master, e621_dict_large, *args, **kwargs):
                super().__init__(*args, **kwargs)
                self.title("e621 태그 검색")
                self.attributes('-topmost', True)
                self.resizable(width=False, height=False)
                
                # 변수 초기화
                self.master = master
                self.tag_dict_large = e621_dict_large
                self.min_search_length = 2
                
                # 검색 인덱스 생성
                self.eng_index = self.create_search_index(is_korean=False)
                self.kor_index = self.create_search_index(is_korean=True)
                
                # UI 구성
                self.setup_ui()
                self.on_key_release()
                
                # 윈도우 설정
                self.after(1500, lambda: self.attributes('-topmost', False))
                
            def setup_ui(self):
                # 검색 레이블 (column 0)
                self.label = customtkinter.CTkLabel(self, text="검색할 키워드 입력", text_color="yellow", font=v_large_font)
                self.label.grid(row=0, column=0, sticky="n", padx=5, pady=5)
                
                # 검색창
                self.entry = customtkinter.CTkEntry(self, width=200, font=v_large_font)
                self.entry.grid(row=1, column=0, sticky="n", padx=5, pady=5)
                self.entry.bind('<KeyRelease>', self.on_key_release)
                
                # 결과 리스트
                self.listbox = tk.Listbox(self, width=36, height=30, font=font.Font(family='Pretendard', size=13), 
                                        bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
                self.listbox.grid(row=2, column=0, sticky="nsew", padx=5, pady=5)
                self.listbox.bind('<<ListboxSelect>>', self.on_select)
                scrollbar = tk.Scrollbar(self, orient="v", command=self.listbox.yview)
                scrollbar.grid(row=2, column=1, sticky='ns')
                self.listbox.config(yscrollcommand=scrollbar.set)
                
                # 연관 프롬프트 섹션 (column 1)
                self.related_label = customtkinter.CTkLabel(self, text="연관 프롬프트", font=v_large_font)
                self.related_label.grid(row=1, column=2, sticky="n", padx=5, pady=5)
                
                self.related_text = customtkinter.CTkTextbox(self, width=400, height=600, font=v_large_font)
                self.related_text.grid(row=2, column=2, sticky="nsew", padx=5, pady=5)
                
            def create_search_index(self, is_korean=False):
                index = {}
                for eng_tag, data in self.tag_dict_large.items():
                    target_tag = data['kor'] if is_korean else eng_tag
                    if not target_tag:
                        continue
                        
                    for i in range(len(target_tag) - 1):
                        bigram = target_tag[i:i+2]
                        if bigram not in index:
                            index[bigram] = set()
                        index[bigram].add(eng_tag)
                return index
            
            def on_select(self, event):
                selection = self.listbox.curselection()
                if selection:
                    selected_item = self.listbox.get(selection[0])
                    eng_tag = selected_item.split(" (")[0]
                    
                    if eng_tag in self.tag_dict_large:
                        data = self.tag_dict_large[eng_tag] #self.e621_dict_all
                        related_tags = list(zip(data['tags'], data['counts']))
                        # counts 기준으로 정렬
                        related_tags.sort(key=lambda x: x[1], reverse=True)
                        
                        # 결과 텍스트 생성
                        result_text = []
                        for tag, count in related_tags:
                            if tag in app.e621_dict_all:
                                kor_trans = app.e621_dict_all[tag]['kor']
                                result_text.append(f"{tag} ({kor_trans}) : {count}")
                            else:
                                result_text.append(f"{tag} : {count}")
                        
                        # 텍스트박스 업데이트
                        self.related_text.configure(state="normal")
                        self.related_text.delete("0.0", "end")
                        self.related_text.insert("0.0", "\n".join(result_text))
                        self.related_text.configure(state="disabled")

            def on_key_release(self, event=None):
                """키 입력시 실시간 검색 수행"""
                search_word = self.entry.get()
                
                # 리스트박스 초기화
                self.listbox.delete(0, 'end')
                
                # 검색어가 최소 길이 이상일 때만 검색
                if len(search_word) >= self.min_search_length or len(search_word) == 0:
                    matches = self.find_matching_tags(search_word, max_results=200)
                    
                    if matches:
                        for eng_tag, kor_tag in matches:
                            display_text = f"{eng_tag} ({kor_tag})"
                            self.listbox.insert('end', display_text)
                    else:
                        self.listbox.insert('end', "해당하는 검색어가 없습니다.")
            
            def find_matching_tags(self, query: str, max_results: int = 10) -> list:
                query = query.strip().lower()
                
                # 검색어가 비어있을 때 모든 태그 반환
                if len(query) == 0:
                    return [(eng_tag, self.tag_dict_large[eng_tag]['kor']) 
                            for eng_tag in list(self.tag_dict_large.keys())[:8000]]
                
                # 최소 검색 길이 체크
                if len(query) < self.min_search_length:
                    return []

                is_korean = any(ord('가') <= ord(char) <= ord('힣') for char in query)
                search_index = self.kor_index if is_korean else self.eng_index
                
                candidate_tags = None
                for i in range(len(query) - 1):
                    bigram = query[i:i+2]
                    if bigram in search_index:
                        if candidate_tags is None:
                            candidate_tags = search_index[bigram].copy()
                        else:
                            candidate_tags &= search_index[bigram]
                            
                        if len(candidate_tags) <= max_results:
                            break
                
                if not candidate_tags:
                    return []

                matches = []
                for eng_tag in candidate_tags:
                    kor_tag = self.tag_dict_large[eng_tag]['kor']
                    search_target = kor_tag if is_korean else eng_tag
                    
                    if query in search_target:
                        matches.append((eng_tag, kor_tag))
                        
                    if len(matches) >= max_results:
                        break

                matches.sort(key=lambda x: (
                    0 if (x[1 if is_korean else 0].lower().startswith(query)) else 1,
                    len(x[0])
                ))

                return matches[:max_results]

        def open_e621_search():
            self.auto_e621_tag_window = SearchWindow(self, self.e621_dict_large)
            if app.app_mode == "WEBUI":self.webui_e621_button.configure(state="normal")

        self.e621_dict_large = None
        def _open_e621_search():
            if self.auto_i2i_window is not None:
                self.auto_i2i_window.deiconify()
            else:
                if not self.e621_dict_large:
                    self.e621_csva = pd.read_csv(os.path.join(app.basedir,"e621_translated_ko_count_repeat_50_mp.csv"), encoding='ANSI')
                    self.e621_dict_large = {}
                    for _, row in self.e621_csva.iterrows():
                        eng_tag = str(row.iloc[0]).strip().lower()
                        kor_tag = str(row.iloc[1]).strip()
                        tags = str(row.iloc[2]).split(', ')
                        counts = list(map(int, str(row.iloc[3]).split(', ')))
                        
                        if eng_tag and kor_tag:  # 빈 값 체크
                            self.e621_dict_large[eng_tag] = {
                                'kor': kor_tag,
                                'tags': tags,
                                'counts': counts
                            }
                    self.e621_dict_all = {}
                    self.e621_csv2 = pd.read_csv(os.path.join(app.basedir,"translated_results_ansi.csv"), encoding="ANSI")
                    for _, row in self.e621_csv2.iterrows():
                        try:
                            eng_tag = str(row.iloc[0]).strip().lower()
                            kor_tag = str(row.iloc[1]).strip()
                        except:
                            continue
                        if eng_tag and kor_tag:  # 빈 값 체크
                            self.e621_dict_all[eng_tag] = {
                                'kor': kor_tag
                            }
                open_e621_search()
                self.e621_search.configure(text="e621 키워드/활성화됨")

        if self.app_mode == "WEBUI": 
            self.e621_search = customtkinter.CTkButton(self.rm_extend_frame, text="e621 키워드/활성화", font=my_font, fg_color="grey10", hover_color="grey", width=32, height=24, command=_open_e621_search)
            self.e621_search.grid(row=2, column=2, padx=5, pady=5, sticky="nsew")
        else:
            self.e621_search = customtkinter.CTkButton(self.rm_extend_frame, text="e621 키워드/활성화", font=my_font, fg_color="grey10", hover_color="grey", width=32, height=24, command=_open_e621_search)
            self.e621_search.grid(row=14, column=1, padx=5, pady=5, sticky="nsew")            

        self.auto_i2i_vibe = customtkinter.CTkCheckBox(self.rm_extend_frame, text="생성 후 자동 i2i",command=auto_i2i_activate, font=my_font)
        self.auto_i2i_setting = customtkinter.CTkButton(self.rm_extend_frame, text="설정", font=my_font, text_color="white", fg_color="grey", width=30, command=auto_i2i_logic)
        if self.app_mode == "NAI": 
            self.auto_i2i_vibe.grid(row=2, column=2, padx=5, pady=5, sticky="w")
            self.auto_i2i_setting.grid(row=2, column=2, padx=5, pady=5, sticky="e")

        self.artist_information = None
        self.registration_queue = []
        self.registration_flag = False
        def open_wc_registration():
            if self.registration_button.get() == 1:
                if not self.prior_queue:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 해당 기능은 현재 우선순위큐에 삽입된 프롬프트들을 freeze하여 반복적으로 호출하는 기능입니다. 먼저 반복할 프롬프트를 큐에 삽입해주세요.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    self.registration_button.deselect()
                else:
                    self.registration_flag = True
                    self.registration_queue = [k for k in self.prior_queue]
            else:
                self.registration_flag = False
                self.registration_queue = []

        self.activation_rp = False
        def preset_check():
            if not self.activation_rp:
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> 랜덤 프리셋 활성 상태에서 [랜덤 프롬프트] 버튼이 작동하면 현재 선행 고정 프롬프트/후행 고정 프롬프트/네거티브 프롬프트가 소실됩니다. 확인하였으면 다시 한번 [랜덤 프리셋] 버튼을 눌러주세요.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.preset_randomizer_button.deselect()
                self.activation_rp = True
                return
            if self.preset_randomizer_button.get() == 1:
                if not self.random_preset or len(self.random_preset) < 2:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 해당 기능은 프리셋에 존재하는 선행 고정 프롬프트/후행 고정 프롬프트/네거티브 프롬프트를 랜덤으로 가져오는 기능입니다. 먼저 2개 이상의 프리셋을 추가해주세요.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    self.preset_randomizer_button.deselect()                    

        self.image_preview_toplelvel = customtkinter.CTkToplevel()
        self.image_preview_toplelvel.overrideredirect(True)
        self.image_preview_toplelvel.grid_columnconfigure(0, weight=1)
        self.image_preview_toplelvel.grid_columnconfigure(1, weight=1)
        self.image_preview_toplelvel.grid_columnconfigure(2, weight=1)
        self.image_count_label = customtkinter.CTkLabel(self.image_preview_toplelvel, text="", font=my_font)
        self.image_count_label.grid(row=0, column=0, columnspan=3, padx=5, pady=2)

        def find_and_replace_text():
            text_widget = self.fixed_prompt_input
            change_text = self.image_count_label.cget("text").split(" : ")[0]
            find_text = self.image_count_label.cget("text").split(" <")[1][:-1]
            try:
                filename = self.image_queue[self.current_window][3]
                dictionary = self.filename_wildcard_dict[filename]
                target_value = dictionary.get(change_text)
                filtered_dict = {k: v for k, v in dictionary.items() if v == target_value}
                keys_list = list(filtered_dict.keys())
                order = keys_list.index(change_text)
            except:
                filename = self.image_queue[-1][3]
                dictionary = self.filename_wildcard_dict[filename]
                target_value = dictionary.get(change_text)
                filtered_dict = {k: v for k, v in dictionary.items() if v == target_value}
                keys_list = list(filtered_dict.keys())
                order = keys_list.index(change_text)
            order += 1

            if self.app_mode == "WEBUI":
                change_text = change_text.replace('(', '\\(').replace(')', '\\)')
            else:
                change_text = "artist:"+change_text

            current_order = 1
            start_idx = "1.0"

            escaped_find_text = find_text
            if '(' in find_text or ')' in find_text:
                escaped_find_text = find_text.replace('(', '\\(').replace(')', '\\)')
            
            while True:
                pos = text_widget.search(find_text, start_idx, "end")
                if not pos and find_text != escaped_find_text:
                    pos = text_widget.search(escaped_find_text, start_idx, "end")
                
                if not pos:
                    break
                    
                end_pos = f"{pos}+{len(find_text)}c"
                
                start_search_idx = pos
                while True:
                    if start_search_idx == "1.0":  
                        adjusted_start = start_search_idx
                        break
                    
                    char = text_widget.get(f"{start_search_idx}-1c", start_search_idx)
                    if char == ',':
                        adjusted_start = f"{start_search_idx}+1c"
                        break
                    
                    start_search_idx = text_widget.index(f"{start_search_idx}-1c")

                end_search_idx = end_pos
                while True:
                    if text_widget.compare(end_search_idx, ">=", "end"):  
                        adjusted_end = end_search_idx
                        break
                    
                    char = text_widget.get(end_search_idx, f"{end_search_idx}+1c")
                    if char == ',':
                        adjusted_end = f"{end_search_idx}-1c"
                        break

                    end_search_idx = text_widget.index(f"{end_search_idx}+1c")

                if current_order == order:
                    range_text = text_widget.get(adjusted_start, adjusted_end)
                    
                    if '|' in range_text:
                        text_widget.delete(adjusted_start, adjusted_end)
                        insertion_start = adjusted_start
                        text_widget.insert(adjusted_start, f" {change_text}")
                        insertion_end = text_widget.index(f"{insertion_start}+{len(change_text)+1}c")
                    else:
                        surrounded_text = f"__{find_text}__"
                        surrounded_pos = text_widget.search(surrounded_text, adjusted_start, adjusted_end)
                        if not surrounded_pos:
                            surrounded_text = f"<{find_text}>"
                            surrounded_pos = text_widget.search(surrounded_text, adjusted_start, adjusted_end)
                        if surrounded_pos:
                            surr_end_pos = f"{surrounded_pos}+{len(surrounded_text)}c"
                            text_widget.delete(surrounded_pos, surr_end_pos)
                            insertion_start = surrounded_pos
                            text_widget.insert(surrounded_pos, change_text)
                            insertion_end = text_widget.index(f"{insertion_start}+{len(change_text)}c")
                        else:
                            exact_pos = text_widget.search(find_text, adjusted_start, adjusted_end)
                            exact_end_pos = f"{exact_pos}+{len(find_text)}c"
                            text_widget.delete(exact_pos, exact_end_pos)
                            insertion_start = exact_pos
                            text_widget.insert(exact_pos, change_text)
                            insertion_end = text_widget.index(f"{insertion_start}+{len(change_text)}c")
                    text_widget.focus_set()
                    if insertion_start and insertion_end:
                        text_widget.tag_add("sel", insertion_start, insertion_end)
                        text_widget.mark_set("insert", insertion_end)
                    break

                current_order += 1
                start_idx = end_pos

        def delete_line_from_wildcard():
            text_to_delete = self.image_count_label.cget("text").split(" : ")[0]
            modified_input_str = self.image_count_label.cget("text").split(" <")[1][:-1]
            try:
                # 파일 경로 확인
                if '/' in modified_input_str:
                    folder, filename = modified_input_str.split('/', 1)
                    file_path = os.path.join(self.wildcards_dir, folder, filename + '.txt')
                    valid_file = folder in self.wildcard_dict and filename + ".txt" in self.wildcard_dict[folder] and os.path.exists(file_path)
                else:
                    file_path = os.path.join(self.wildcards_dir, modified_input_str + ".txt")
                    valid_file = modified_input_str + ".txt" in self.wildcard_dict['none'] and os.path.exists(file_path)
                    
                if not valid_file:
                    return False
                    
                # 파일 읽기
                with open(file_path, 'r', encoding='utf-8') as file:
                    lines = file.readlines()
                
                # 삭제할 텍스트가 있는 라인 제외하고 새 리스트 생성
                new_lines = [line for line in lines if line.strip() != text_to_delete.strip()]
                
                # 라인 수가 같다면 삭제할 텍스트를 찾지 못한 것
                if len(lines) == len(new_lines):
                    raise ValueError(f"텍스트를 찾을 수 없습니다: {text_to_delete}")
                
                # 파일 다시 쓰기
                with open(file_path, 'w', encoding='utf-8') as file:
                    file.writelines(new_lines)
                    
                self.image_preview_button2.configure(fg_color="#6A306B", state="disabled", text="삭제 완료!")
                self.activate_wildcards()
                return True
                
            except Exception as e:
                self.image_preview_button2.configure(fg_color="grey10", state="disabled", text="삭제 실패!")
                return False

        def test_image_generation():
            def _valid(t):
                starts_with_open = t.startswith('(')
                ends_with_close = t.endswith(')')
                
                # 전체 괄호 짝 확인
                open_count = t.count('(')
                close_count = t.count(')')
                
                # 괄호 불일치 또는 개수 불일치
                if starts_with_open != ends_with_close or open_count != close_count:
                    # 열린 괄호로 시작하거나 열린 괄호가 더 많은 경우
                    if starts_with_open:
                        base_text = t[1:]  # 앞 괄호 제거
                        return base_text not in artist_dict and base_text.count('(') == base_text.count(')')
                    # 닫힌 괄호로 끝나거나 닫힌 괄호가 더 많은 경우
                    if ends_with_close:
                        base_text = t[:-1]  # 뒤 괄호 제거
                        return base_text not in artist_dict and base_text.count('(') == base_text.count(')')
                    # 괄호 개수만 다른 경우
                    return t not in artist_dict
                elif starts_with_open and ends_with_close:
                    return t[1:-1] not in artist_dict
                    
                return t not in artist_dict

            random_function()
            _ptext = self.generated_prompt_set['prompt'].split(', ')
            _ptext = [t for t in _ptext if _valid(t)]
            _ptext = ', '.join(_ptext)
            input_text = _ptext + ", " + self.generated_prompt_set['after']
            if len(input_text) > 50: check_text = input_text[:50]
            else: check_text = input_text[:len(input_text)-1]
            gender_positions = [
                check_text.rfind("girl,"),
                check_text.rfind("girls,"),
                check_text.rfind("boy,"),
                check_text.rfind("boys,")
            ]
            _text = ""
            ext_str = self.image_count_label.cget("text").split(" : ")[0]
            if self.app_mode == "WEBUI":
                ext_str = "("+ext_str.replace('(', '\\(').replace(')', '\\)')+")"
            else:
                ext_str = "{artist:"+ext_str+"}"
            valid_positions = [pos for pos in gender_positions if pos > -1]
            if valid_positions:
                insert_index = max(valid_positions)
                if check_text[insert_index:insert_index+6] == "girls,":
                    insert_index += 6 
                elif check_text[insert_index:insert_index+5] in ["girl,", "boys,"]:
                    insert_index += 5 
                else:
                    insert_index += 4 
                _text = input_text[:insert_index] + f" {ext_str}," + input_text[insert_index:]
                # 삽입된 위치 계산
                insertion_start = f"1.{insert_index + 1}"  # 공백 다음 위치
                insertion_end = f"1.{insert_index + 1 + len(ext_str)}"
            else:
                _text = f"{ext_str}, " + input_text
                # 맨 앞에 삽입된 경우
                insertion_start = "1.0"
                insertion_end = f"1.{len(ext_str)}"
                
            self.text_input.delete("0.0", "end")
            self.text_input.insert("0.0", _text)
            
            # 포커스 설정 및 텍스트 선택
            self.text_input.focus_set()
            self.text_input.tag_add("sel", insertion_start, insertion_end)
            self.text_input.mark_set("insert", insertion_end)
            try: 
                _NAIA_generate()
            except: pass

        self.image_preview_button1 = customtkinter.CTkButton(self.image_preview_toplelvel, text="이 위치에 고정", font=my_font, command=find_and_replace_text)
        self.image_preview_button2 = customtkinter.CTkButton(self.image_preview_toplelvel, text="WC에서 제거", font=my_font, fg_color="grey", hover_color="grey10", command=delete_line_from_wildcard)
        self.image_preview_button3 = customtkinter.CTkButton(self.image_preview_toplelvel, text="테스트 생성", font=my_font, fg_color="#ED7D31", hover_color="#CC5D12", command=test_image_generation)
        self.image_preview_label = customtkinter.CTkLabel(self.image_preview_toplelvel, text="", width=320, height=320)
        self.image_preview_label.grid(row=2, column=0, columnspan=3, padx=5, pady=2)
        self.image_preview_toplelvel.withdraw()

        self.registration_button =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="우선생성큐 반복",command=open_wc_registration, font=my_font)
        self.registration_button.grid(row=10, column=0, padx=10, pady=5, sticky="nsew")

        self.preset_randomizer_button =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="랜덤 프리셋 / 고정WC : ",command=preset_check, font=my_font)
        self.preset_randomizer_button.grid(row=10, column=1, padx=5, pady=5, sticky="nsew")

        self.preset_randomizer_var = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=150)
        self.preset_randomizer_var.grid(row=10, column=2, pady=5, sticky="w")
        self.preset_randomizer_var.insert(0, "<favorite_character[0]>")

        self.compression_button =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="하위 프롬프트 압축", font=my_font)
        self.compression_button.grid(row=11, column=0, padx=10, pady=5, sticky="nsew")

        self.frequency_limit_button =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="프롬프트 수 Thresholding (권장 : 200) ", font=my_font)
        self.frequency_limit_button.grid(row=11, column=1, columnspan=2, padx=5, pady=5, sticky="w")

        self.skip_225_button =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="자동화 토큰>225: 스킵", font=my_font)
        self.skip_225_button.grid(row=12, column=0, padx=10, pady=5, sticky="nsew")

        self.male_before_girl =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="랜덤: 남성이 여성 앞에", font=my_font)
        self.male_before_girl.grid(row=12, column=1, padx=10, pady=5, sticky="nsew")

        if self.app_mode == "WEBUI":
            self.male_before_girl.select()
            self.male_before_girl.configure(state="disabled")
            self.male_before_girl.grid_forget()

        def pm_active():
            if self.function_test_s1.get():
                self.function_test_s1_label2.grid(row=33, column=0, columnspan=3, pady=5, padx=10, sticky="w")
                self.function_test_s1_entry2.grid(row=33, column=0, columnspan=3, pady=5, padx=10, sticky="e")
                self.function_test_s1_label.grid(row=34, column=0, columnspan=3, pady=5, padx=10, sticky="w")
                self.function_test_s1_entry.grid(row=34, column=0, columnspan=3, pady=5, padx=10, sticky="e")
                self.function_test_s1_character_maintain.grid(row=35, column=0, columnspan=3, pady=5, padx=10, sticky="w")
            else:
                self.function_test_s1_label2.grid_forget()
                self.function_test_s1_entry2.grid_forget()
                self.function_test_s1_label.grid_forget()
                self.function_test_s1_entry.grid_forget()
                self.function_test_s1_character_maintain.grid_forget()

        self.function_test_s1 =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="프롬프트믹싱", font=my_font, command=pm_active)
        if self.app_mode == "NAI": self.function_test_s1.grid(row=12, column=2, padx=10, pady=5, sticky="nsew")

        self.rec_resolution = customtkinter.CTkCheckBox(self.rm_extend_frame, text="해상도 자동 매칭", font=my_font)
        self.rec_resolution.grid(row=13, column=0, padx=10, pady=5, sticky="nsew")

        self.autocomplete = customtkinter.CTkCheckBox(self.rm_extend_frame, text="태그 자동완성", font=my_font, variable=self.autocomplete_var)
        self.autocomplete.grid(row=13, column=2, padx=10, pady=5, sticky="nsew")

        self.naid4_legacy_uc =  customtkinter.IntVar(value = 0)
        self.naid4_auto_character_prompt_fill =  customtkinter.IntVar(value = 0)
        self.anid4_auto_character_add_negative_series = customtkinter.IntVar(value = 0)
        self.naid4_auto_character_girls = customtkinter.IntVar(value = 0)
        self.naid4_auto_character_boys = customtkinter.IntVar(value = 0)
        self.naid4_cond = customtkinter.IntVar(value = 0)
        self.naid4_cond_prompt = ""
        self.naid4_cond_negative = ""

        def open_naid4_setting_window():
            naid4_settings_window = customtkinter.CTkToplevel()
            self.naid4_settings_window = naid4_settings_window
            naid4_settings_window.title("NAID4 추가설정 윈도우")
            #naid4_settings_window.geometry("400x250")
            naid4_settings_window.attributes('-topmost', True)
            #naid4_settings_window.resizable(width=False, height=False)

            def on_close():
                naid4_settings_window.withdraw()

            frame_left = customtkinter.CTkFrame(naid4_settings_window)
            frame_left.grid(row =0, column= 0, sticky="nsew", padx=5, pady=5)

            frame_right = customtkinter.CTkFrame(naid4_settings_window)

            checkbox1 = customtkinter.CTkCheckBox(frame_left, text="Legacy Prompt Conditioning 활성화 (Not Recommended)", font=my_font, variable=self.naid4_legacy_uc)
            checkbox1.grid(row =0, column= 0, sticky="nsew", padx=10, pady=5)

            checkbox2 = customtkinter.CTkCheckBox(frame_left, text="캐릭터 이름을 인식하여 자동으로 girl, boy, 눈, 머리색 적용", font=my_font, variable=self.naid4_auto_character_prompt_fill)
            checkbox2.grid(row =1, column= 0, sticky="nsew", padx=10, pady=5)
            #checkbox2.select()

            checkbox3 = customtkinter.CTkCheckBox(frame_left, text="캐릭터가 속한 작품명을 네거티브로 넣습니다", font=my_font, variable=self.anid4_auto_character_add_negative_series)
            checkbox3.grid(row =2, column= 0, sticky="nsew", padx=10, pady=5)

            checkbox4 = customtkinter.CTkCheckBox(frame_left, text="[랜덤 프롬프트] girl/girls 프롬프트에 반응하여 캐릭 프롬을 할당", font=my_font, variable=self.naid4_auto_character_girls)
            checkbox4.grid(row =3, column= 0, sticky="nsew", padx=10, pady=5)
            #checkbox4.select()

            checkbox5 = customtkinter.CTkCheckBox(frame_left, text="[랜덤 프롬프트] boy/boys 프롬프트에 반응하여 캐릭 프롬을 할당", font=my_font, variable=self.naid4_auto_character_boys)
            checkbox5.grid(row =4, column= 0, sticky="nsew", padx=10, pady=5)
            #checkbox5.select()

            def conditional_on_off():
                if checkbox6.get() == 1:
                    frame_right.grid(row =0, column= 1, sticky="nsew", padx=5, pady=5)
                else:
                    frame_right.grid_forget()

            checkbox6 = customtkinter.CTkCheckBox(frame_left, text="[캐릭터 프롬프트] 조건부 프롬프트를 적용합니다", font=my_font, command=conditional_on_off, variable=self.naid4_cond)
            checkbox6.grid(row =5, column= 0, sticky="nsew", padx=10, pady=5)
            if self.naid4_cond.get() == 1: frame_right.grid(row =0, column= 1, sticky="nsew", padx=5, pady=5)

            conditional_label  = customtkinter.CTkLabel(frame_right, text="조건부 캐릭터 프롬프트 (슬롯마다 적용)", font=my_font)
            conditional_label.grid(row = 0, column = 0, sticky="n", padx=5, pady=5)

            def highlight_conditional_textbox(event=None):
                self.naid4_cond_prompt =conditional_textbox.get("1.0", tk.END).strip()
                if '#' in conditional_textbox.get("1.0", tk.END):
                    conditional_textbox.tag_remove("highlight", "1.0", tk.END)
                    for match in re.finditer(r'#.*?([,\n]|$)', conditional_textbox.get("1.0", tk.END)):
                        start = "1.0 + {}c".format(match.start())
                        end = "1.0 + {}c".format(match.end())
                        conditional_textbox.tag_add("highlight", start, end)    

            def highlight_conditional_textbox_neg(event=None):
                self.naid4_cond_negative =conditional_neg_textbox.get("1.0", tk.END).strip()
                if '#' in conditional_neg_textbox.get("1.0", tk.END):
                    conditional_neg_textbox.tag_remove("highlight", "1.0", tk.END)
                    for match in re.finditer(r'#.*?([,\n]|$)', conditional_neg_textbox.get("1.0", tk.END)):
                        start = "1.0 + {}c".format(match.start())
                        end = "1.0 + {}c".format(match.end())
                        conditional_neg_textbox.tag_add("highlight", start, end)    

            conditional_textbox = customtkinter.CTkTextbox(frame_right, width=400, height=150, font=v_large_font, undo=True)
            conditional_textbox.grid(row = 1, column = 0, sticky="n", padx=5, pady=5)
            if self.naid4_cond_prompt: conditional_textbox.insert("0.0", self.naid4_cond_prompt)
            conditional_textbox.bind("<FocusOut>", highlight_conditional_textbox)
            conditional_textbox.tag_config("highlight", foreground="#FFFF97")

            conditional_neg_label  = customtkinter.CTkLabel(frame_right, text="조건부 캐릭터 네거티브 (슬롯마다 적용)", font=my_font)
            conditional_neg_label.grid(row = 2, column = 0, sticky="n", padx=5, pady=5)

            conditional_neg_textbox = customtkinter.CTkTextbox(frame_right, width=400, height=150, font=v_large_font, undo=True)
            conditional_neg_textbox.grid(row = 13, column = 0, sticky="n", padx=5, pady=5)
            if self.naid4_cond_negative: conditional_neg_textbox.insert("0.0", self.naid4_cond_negative)
            conditional_neg_textbox.bind("<FocusOut>", highlight_conditional_textbox_neg)
            conditional_neg_textbox.tag_config("highlight", foreground="#FFFF97")

            naid4_settings_window.protocol("WM_DELETE_WINDOW", on_close)
            naid4_settings_window.after(1500, lambda: naid4_settings_window.attributes('-topmost', False))

        def open_naid4_setting():
            if self.naid4_settings_window is not None:
                self.naid4_settings_window.deiconify()
            else:
                open_naid4_setting_window()

        self.naid4_settings_window = None
        self.naid4_settings = customtkinter.CTkCheckBox(self.rm_extend_frame, text="NAID4 확장옵션", font=my_font)
        self.naid4_settings_button = customtkinter.CTkButton(self.rm_extend_frame, text="NAID4 확장옵션", font=my_font, text_color="white", fg_color="grey", width=30, command=open_naid4_setting)

        self.naid4_auto_reroll = customtkinter.CTkCheckBox(self.rm_extend_frame, text="NAID4 생성-Apply", font=my_font)
        if self.app_mode == "NAI":
            self.naid4_auto_reroll.grid(row=13, column=1, padx=10, pady=5, sticky="nsew")
            #self.naid4_settings.grid(row=14, column=2, padx=10, pady=5, sticky="nsew")
            self.naid4_settings_button.grid(row=14, column=2, padx=10, pady=5, sticky="nsew")

        def reset_generation_button():
            self.image_generation_button.configure(state="normal")
            if self.app_mode == "NAI": self.transform_button.configure(state="normal")            
            if self.app_mode == "NAI": self.image_generation_button.configure(text="NAI 이미지 생성", text_color="#DCE4EE")
            else: self.image_generation_button.configure(text="WEBUI 생성 요청", text_color="#DCE4EE")
            self.running_flag = False

        self.reset_generation = customtkinter.CTkButton(self.rm_extend_frame, text="생성 버튼 복원", font=my_font, text_color="#FFFF97", command=reset_generation_button, fg_color="transparent")
        self.reset_generation.grid(row=14, column=0, padx=10, pady=5, sticky="nsew")

        if self.app_mode == "WEBUI":
            self.function_test_s1.configure(state="disabled")

        self.function_test_s1_var = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=40)
        if self.app_mode == "NAI": self.function_test_s1_var.grid(row=12, column=2, columnspan=2, pady=5, padx=10, sticky="e")
        self.function_test_s1_var.insert(0, "0.15")    

        self.function_test_s1_label2 = customtkinter.CTkLabel(self.rm_extend_frame, font=my_font, text="PM 선행프롬 : ")
        self.function_test_s1_entry2 = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=395)

        self.function_test_s1_label = customtkinter.CTkLabel(self.rm_extend_frame, font=my_font, text="PM 후행프롬 : ")
        self.function_test_s1_entry = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=395)

        self.function_test_s1_character_maintain =  customtkinter.CTkCheckBox(self.rm_extend_frame, text="girl/boy 뒤에 처음으로 오는 캐릭터 정보를 유지합니다", font=my_font)
        self.function_test_s1_character_maintain.select()

        self.frequency_limit_var = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=50)
        self.frequency_limit_var.grid(row=11, column=1, columnspan=2, pady=5, padx=10, sticky="e")
        self.frequency_limit_var.insert(0, "200")    

        def get_clipboard_image():
            try:
                clipboard_content = ImageGrab.grabclipboard()
                if clipboard_content is None:
                    return None
                elif isinstance(clipboard_content, Image.Image):
                    return clipboard_content
                elif isinstance(clipboard_content, list):
                    if clipboard_content and len(clipboard_content) > 0:
                        try:
                            return Image.open(clipboard_content[0])
                        except:
                            pass
                try:
                    clipboard_data = pyperclip.paste()
                    if clipboard_data:
                        try:
                            if clipboard_data.startswith(('data:image', 'iVBORw0KGgo')):  # PNG header in base64
                                img_data = base64.b64decode(clipboard_data.split(',')[1] if ',' in clipboard_data else clipboard_data)
                                return Image.open(io.BytesIO(img_data))
                            else:
                                try:
                                    return Image.open(io.BytesIO(clipboard_data.encode('utf-8')))
                                except:
                                    return None
                        except:
                            return None
                except:
                    return None

            except Exception as e:
                return None


        def slider_event_IRS(value, image_reference_strength_label):
            image_reference_strength_label.configure(text=f"Reference Strength : {value:.2f}")
            self.irs = round(value, 2)
            
        def slider_event_IE(value, information_extracted_label):
            information_extracted_label.configure(text=f"Information Extracted : {value:.2f}")
            self.ie = round(value, 2)

        
        #기능 추가 : i2i_reference에 대응
        self.image_reference = None
        self.image_reference_string = None
        self.image_reference_tk = None
        self.image_id = None
        self.ie = 0.25
        self.irs = 0.3

        def rem_image_reference():
            if self.image_reference:
                self.image_reference = None
                self.image_reference_string = None
                self.image_reference_tk = None
            #self.image_reference_frame.grid_forget()
            #self.image_reference_canvas.delete(self.image_id)
            self.image_id = None

        #oepn_vibe
        def import_clipboard_vibe():
            image = get_clipboard_image()
            if image:  
                set_image_reference(image)

        def reorganize_frames(image_reference_frame, irfr):
            for idx, frame_info in enumerate(irfr):
                frame_info["frame"].grid(row=idx, column=0, padx=5, pady=5, sticky="nsew")

        def remove_vibe(frame_info, image_reference_frame, irfr):
            frame_info["frame"].destroy()  
            irfr.remove(frame_info)  
            reorganize_frames(image_reference_frame, irfr)

        def set_image_reference(img):
            add_vibe(img)
            # if self.image_reference:
            #     self.image_reference = None
            #     self.image_reference_string = None
            #     self.image_reference_tk = None
            #     self.image_reference_canvas.delete(self.image_id)
            #     self.image_id = None
            # reference_string = NAIA_generation.image_to_base64(img)
            # self.image_reference = copy.deepcopy(img.convert('RGBA'))
            # self.image_reference_string = reference_string

        self.irfr = []

        def add_vibe(_image, _irs = None, _ie = None):
            if len(self.irfr) >= 16:
                print("Maximum number of vibe frames (16) reached!")
                return
                
            vb_image = self.resize_and_center_image(_image, 112, 112)
            
            # Create frame
            frame = customtkinter.CTkFrame(self.image_reference_frame)
            
            # Create image label
            image = customtkinter.CTkLabel(
                frame, 
                text="", 
                image=customtkinter.CTkImage(vb_image, size=(112,112))
            )
            image.grid(row=0, column=0, rowspan=4, padx=5, pady=5, sticky="w")

            # Reference Strength widgets
            image_reference_strength_label = customtkinter.CTkLabel(
                frame, 
                font=v_large_font, 
                text_color='white',
                text=f"Reference Strength : {self.irs if not _irs else _irs}", 
                fg_color='transparent', 
                width=256
            )
            
            image_reference_strength = customtkinter.CTkSlider(
                frame, 
                from_=0.01, 
                to=1.00, 
                number_of_steps=100,
                command=lambda value: slider_event_IRS(value, image_reference_strength_label),
                button_color='grey', 
                button_hover_color='grey10',
                height=15, 
                width=180, 
                progress_color='transparent'
            )
            image_reference_strength.set(self.irs  if not _irs else _irs)

            # Information Extracted widgets
            information_extracted_label = customtkinter.CTkLabel(
                frame, 
                font=v_large_font, 
                text_color='white',
                text=f"Information Extracted : {self.ie  if not _ie else _ie}", 
                fg_color='transparent', 
                width=256
            )
            
            information_extracted = customtkinter.CTkSlider(
                frame, 
                from_=0.01, 
                to=1.00, 
                number_of_steps=100,
                command=lambda value: slider_event_IE(value, information_extracted_label),
                button_color='grey', 
                button_hover_color='grey10',
                height=15, 
                width=180, 
                progress_color='transparent'
            )
            information_extracted.set(self.ie if not _ie else _ie)

            # Grid layout for sliders and labels
            image_reference_strength_label.grid(row=0, column=1, padx=5, pady=5, sticky="n")
            image_reference_strength.grid(row=1, column=1, padx=5, pady=5, sticky="n")
            information_extracted_label.grid(row=2, column=1, padx=5, pady=5, sticky="n")
            information_extracted.grid(row=3, column=1, padx=5, pady=5, sticky="n")

            # Create frame info dictionary
            frame_info = {
                "frame": frame,
                "image": image,
                "ref_strength": image_reference_strength,
                "ref_strength_label": image_reference_strength_label,
                "info_extracted": information_extracted,
                "info_extracted_label": information_extracted_label,
                "image_origin" :  NAIA_generation.image_to_base64(_image)
            }

            # Create remove button with frame reference
            remove = customtkinter.CTkButton(
                frame, 
                font=v_large_font, 
                fg_color="grey10",
                hover_color="grey", 
                text="Remove", 
                width=96, 
                height=46,
                command=lambda: remove_vibe(frame_info, self.image_reference_frame, self.irfr)
            )
            remove.grid(row=0, column=2, rowspan=2, padx=5, pady=5, sticky="e")
            frame.grid(row=len(self.irfr), column=0, padx=5, pady=5, sticky="nsew")
            self.irfr.append(frame_info)
        self.add_vibe = add_vibe

        def clear_all_vibe_frames():
            for frame_info in self.irfr:
                frame_info["frame"].destroy()  
            self.irfr.clear()

        def get_all_vibe_values():
            images = []
            reference_strengths = []
            information_extracteds = []
            
            for frame_info in self.irfr:
                images.append(frame_info["image_origin"])
                reference_strengths.append(round(frame_info["ref_strength"].get(), 2))
                information_extracteds.append(round(frame_info["info_extracted"].get(), 2))
            
            return images, reference_strengths, information_extracteds

        if self.app_mode == "NAI": self.image_reference_frame.grid(row=3, column=0, columnspan=3, sticky="nsew")

        self.vibe_transfer_button_frame =  customtkinter.CTkFrame(self.image_reference_frame)
        self.vibe_transfer_button_frame.grid(row=16, column=0, padx=5, pady=5, sticky="nsew")
        self.vibe_transfer_button_frame.columnconfigure(0, weight=2)
        self.vibe_transfer_button_frame.columnconfigure(1, weight=1)
        self.vibe_add_image_button = customtkinter.CTkButton(self.vibe_transfer_button_frame, font=v_large_font, fg_color="grey10", hover_color="grey", text = "Upload Vibe Transfer Image (+)", command=open_vibe)
        self.vibe_add_image_button.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
        self.vibe_clipboard_button = customtkinter.CTkButton(self.vibe_transfer_button_frame, font=v_large_font, fg_color="grey10", hover_color="grey", text = "Vibe Transfer from Clipboard (📋)", command=import_clipboard_vibe)
        self.vibe_clipboard_button.grid(row=0, column=1, padx=5, pady=5, sticky="nsew")

        def initialize_reference():
            pass

        # def initialize_reference():
        #     self.image_reference_canvas = customtkinter.CTkCanvas(self.image_reference_frame, width=int(468* (self.dpi / 100)), bg="#333333", highlightthickness  = 1, highlightbackground = 'grey10')
        #     self.image_reference_canvas.grid(row=0, column=0, columnspan=3, pady=5, sticky="n")
            
        #     self.image_reference_strength_label = customtkinter.CTkLabel(self.image_reference_canvas, font=v_large_font, text_color='white', text=f"Reference Strength : 0.6", fg_color='transparent', width=190)
        #     self.information_extracted_label = customtkinter.CTkLabel(self.image_reference_canvas, font=v_large_font, text_color='white', text=f"Information Extracted : 1", fg_color='transparent', width=190)
        #     self.image_reference_strength = customtkinter.CTkSlider(self.image_reference_canvas,  from_=0.01, to=1.00, number_of_steps=100, command=slider_event_IRS, button_color='grey', button_hover_color='grey10', height=20, width=180, progress_color='transparent')
        #     self.information_extracted = customtkinter.CTkSlider(self.image_reference_canvas,  from_=0.01, to=1.00, number_of_steps=100, command=slider_event_IE, button_color='grey', button_hover_color='grey10', height=20, width=180, progress_color='transparent')
        #     self.exit_reference_mode = customtkinter.CTkButton(self.image_reference_canvas, text="Vibe Transfer 해제", font=my_font, command=rem_image_reference, fg_color='grey10', hover_color='grey', corner_radius=0)
        #     irc_xpos = [int(130* (self.dpi / 100)), int(130* (self.dpi / 100)), int(320* (self.dpi / 100)), int(320* (self.dpi / 100)), int(260* (self.dpi / 100))]
        #     self.image_reference_canvas.create_window(irc_xpos[0], 140, window=self.image_reference_strength_label)
        #     self.image_reference_canvas.create_window(irc_xpos[1], 90, window=self.information_extracted_label)
        #     self.image_reference_canvas.create_window(irc_xpos[2], 140, window=self.image_reference_strength)
        #     self.image_reference_canvas.create_window(irc_xpos[3], 90, window=self.information_extracted)
        #     self.image_reference_canvas.create_window(irc_xpos[4], 190, window=self.exit_reference_mode)

        def yield_rm_character_name():
            if self.rm_character_name_var.get() == 1:
                self.rm_characteristic_button.deselect()

        def yield_rm_clothes():
            if self.rm_attire_var.get() == 1:
                self.rm_color_button.deselect()
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> 의상 정보를 제거하고 나면 프롬프트는 많이 압축되지만 clothes around one leg, bikini pull 과 같이 의상에 종속되는 랜덤 프롬프트들이 정상적으로 동작하지 않습니다. 가급적 색상 제거를 사용하세요.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")

        self.rm_character_name_var = customtkinter.IntVar()
        self.rm_character_name_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="캐릭터 이름만 제거", variable=self.rm_character_name_var, font=my_font, command=yield_rm_character_name)

        self.rm_attire_var = customtkinter.IntVar()
        self.rm_attire_var_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="의상/악세사리 제거", variable=self.rm_attire_var, font=my_font, command=yield_rm_clothes)

        def on_off_webui_guide():
            if self.webui_guide_button.get() == 1:
                self.image_guide_frame.grid(row=1, rowspan=4, column=0, columnspan=3 , pady=2, sticky="nsew")
                #self.webui_guide_clothes_maintain.grid(row=3, column=0, columnspan=2, pady=5,  padx=10, sticky="nsew")
                self.NAI_Account_State.deselect()
                search_ui_hide()
            else:
                self.image_guide_frame.grid_forget()
                self.webui_guide_clothes_maintain.grid_forget()

        """
        def on_off_dtg():
            if self.webui_dtg_button.get() == 1:
                self.wildacrd_standalone.select()
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "(1) 해당 기능은 와일드카드 단독 모드와 함께 동작합니다. 해제하지 마시기 바랍니다. (2) WEBUI의 Danbooru Tag Generator를 사용하기 위해 다음 가이드를 참고해주시기 바랍니다 : ")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.insert(tk.END, "아카라이브(arca.live) 가이드 링크", "hyperlink")
                self.image_label_report.tag_config("hyperlink", foreground="lightblue", underline=True)
                self.image_label_report.tag_bind("hyperlink", "<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/102334369"))
                self.image_label_report.configure(state="disabled")
                self.webui_dtg_neg.grid(row=2, column=1, columnspan=2, padx=5, sticky="w")
                self.dtg_radio_frame.grid(row=3, column=0, columnspan=3, pady=5, sticky="nsew")
                self.resopnsive_prompt.grid_forget()
                self.resopnsive_prompt.grid(row=4, column=1, padx=5, pady=5, sticky="nsew")
                self.auto_i2i_vibe.grid_forget()
                self.auto_i2i_vibe.grid(row=4, column=2, padx=5, pady=5, sticky="nsew")
            else:
                self.image_label_report.tag_bind("hyperlink", "<Button-1>", None)
                self.wildacrd_standalone.deselect()
                self.webui_dtg_neg.grid_forget()
                self.dtg_radio_frame.grid_forget()
                self.resopnsive_prompt.grid_forget()
                self.resopnsive_prompt.grid(row=2, column=1, padx=5, pady=5, sticky="nsew")
                self.auto_i2i_vibe.grid_forget()
                self.auto_i2i_vibe.grid(row=2, column=2, padx=5, pady=5, sticky="nsew")
        """
        
        self.webui_guide_var = customtkinter.IntVar()
        self.webui_guide_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="WEBUI 이미지 가이드", variable=self.webui_guide_var, command=on_off_webui_guide, font=my_font, state="disabled")

        self.webui_dtg_var = customtkinter.IntVar()

        self.webui_guide_clothes_maintain = customtkinter.CTkCheckBox(self.rm_extend_frame, text="WEBUI에서 생성할때는 의상 정보를 유지", font=my_font)

        def open_e621():
            if self.e621_window is None or not self.e621_window.winfo_exists():
                from subui.e621 import E621_window
                
                self.e621_csv = pd.read_csv(os.path.join(app.basedir,"e621_translated_ko_count_repeat_50_mp.csv"), encoding='ANSI')
                self.e621_csv1 = pd.read_csv(os.path.join(app.basedir,"e621_translated_ko_count_repeat_51_mp.csv"), encoding='ANSI')
                self.e621_window = E621_window(self, self.e621_csv)
            else:
                if self.e621_window.state() == 'withdrawn':
                    self.e621_window.deiconify()
                else:
                    self.e621_window.text_input.focus()
            self.webui_e621_button.deselect()

        self.e621_window = None
        self.tag_recommender = None
        self.rm_color_button.grid(row=0, column=0, pady=5,  padx=10, sticky="nsew")
        self.rm_location_button.grid(row=0, column=1, pady=5, sticky="nsew")
        self.rm_not_nsfw_button.grid(row=0, column=2, pady=5, padx=5, sticky="w")
        self.rm_character_name_button.grid(row=1, column=0, pady=5,  padx=10, sticky="nsew")
        self.rm_attire_var_button.grid(row=1, column=1, pady=5,  padx=10, sticky="nsew")
        if self.app_mode == "NAI":
            #self.webui_dtg_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="WEBUI DanTagGen", variable=self.webui_dtg_var, command=on_off_dtg, font=my_font, state="disabled")
            #self.webui_dtg_neg = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=310)
            #self.webui_dtg_neg.insert(0, ".*background, .*text.*, .*blurry.*, comic, .*manga.*, .*magazine.*, .*koma.*, censored, .*censoring.*, bar censor, monochrome, greyscale")
            self.webui_guide_button.grid(row=1, column=2, pady=5,  padx=10, sticky="nsew")
            #self.webui_dtg_button.grid(row=2, column=0, pady=5,  padx=10, sticky="nsew")
        if self.app_mode == "WEBUI":
            self.webui_e621_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="e621 Turbo", font=my_font, command=open_e621, state="disabled")
            self.webui_e621_button.grid(row=1, column=2, pady=5,  padx=10, sticky="nsew")
            #self.webui_dtg_button = customtkinter.CTkCheckBox(self.rm_extend_frame, text="WEBUI DanTagGen", variable=self.webui_dtg_var, command=on_off_dtg, font=my_font)
            #self.webui_dtg_neg = customtkinter.CTkEntry(self.rm_extend_frame, font=my_font, width=310)
            #self.webui_dtg_button.grid(row=2, column=0, pady=5,  padx=10, sticky="nsew")
            #self.webui_dtg_neg.insert(0, ".*background, .*text.*, .*blurry.*, comic, .*manga.*, .*magazine.*, .*koma.*, censored, .*censoring.*, bar censor, monochrome, greyscale")
        self.dtg_radio_frame = customtkinter.CTkFrame(self.rm_extend_frame, fg_color="#333333")
        self.dtg_radio_var = customtkinter.StringVar(value="short")
        self.dtg_radio1 = customtkinter.CTkRadioButton(self.dtg_radio_frame, text="매우짧게", variable= self.dtg_radio_var, value="very short", font=my_font)
        self.dtg_radio1.grid(row=0, column=0, padx=10,sticky="nsew")
        self.dtg_radio2 = customtkinter.CTkRadioButton(self.dtg_radio_frame, text="짧게", variable= self.dtg_radio_var, value="short", font=my_font)
        self.dtg_radio2.grid(row=0, column=1, padx=5,sticky="nsew")
        self.dtg_radio3 = customtkinter.CTkRadioButton(self.dtg_radio_frame, text="길게", variable= self.dtg_radio_var, value="long", font=my_font)
        self.dtg_radio3.grid(row=0, column=2, padx=5,sticky="nsew")
        self.dtg_radio4 = customtkinter.CTkRadioButton(self.dtg_radio_frame, text="매우길게", variable= self.dtg_radio_var, value="very long", font=my_font)
        self.dtg_radio4.grid(row=0, column=3, padx=5,sticky="nsew")
        self.dtg_temperature = 1.35
        def dtg_slider_event(value):
            self.dtg_slider_label.configure(text=f"Strength : {value:.2f}")
            self.dtg_temperature = value
        self.dtg_slider_label = customtkinter.CTkLabel(self.dtg_radio_frame, text="Temperature : "+str(self.dtg_temperature), font=my_font)
        self.dtg_slider_label.grid(row=1, column=0, columnspan=2, pady=5, sticky="n")
        self.dtg_slider = customtkinter.CTkSlider(self.dtg_radio_frame, from_=0.1, to=2.5, number_of_steps=48, command=dtg_slider_event, width=240)
        self.dtg_slider.grid(row=1, column=2, columnspan=2, pady=5, sticky="n")
        self.dtg_slider.set(1.35)
        self.dtg_timeout_label = customtkinter.CTkLabel(self.dtg_radio_frame, text="DTG Timeout 초 : ", font=my_font)
        self.dtg_timeout_label.grid(row=2, column=0, sticky="n")
        self.webui_dtg_timeout = customtkinter.CTkEntry(self.dtg_radio_frame, font=my_font, width=50)
        self.webui_dtg_timeout.insert(0, "30")
        self.webui_dtg_timeout.grid(row=2, column=1, sticky="w")
        self.dtg_format_label = customtkinter.CTkLabel(self.dtg_radio_frame, text=" Format : ", font=my_font)
        self.dtg_format_label.grid(row=2, column=2, sticky="n")
        self.dtg_format  =customtkinter.StringVar(value="Animagine")
        self.dtg_format_select = customtkinter.CTkComboBox(self.dtg_radio_frame, values=["Animagine", "Pony"], variable=self.dtg_format, font=my_font)
        self.dtg_format_select.grid(row=2, column=3, padx=5, sticky="n")

        def fixed_prompt_after_label_command():
            if self.fixed_prompt_after_label_var.get() == 0:
                self.fixed_prompt_after_input.grid_forget()
            else:
                self.fixed_prompt_after_input.grid(row=7, column=0, pady=5, sticky="nsew")

        def highlight_text_after(event=None):
            if '#' in self.fixed_prompt_after_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.fixed_prompt_after_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.fixed_prompt_after_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.fixed_prompt_after_input.tag_add("highlight", start, end)    

        self.fixed_prompt_after_label_var = customtkinter.IntVar(value=1)
        self.fixed_prompt_after_label = customtkinter.CTkCheckBox(self.text_input_frame, text=" ----------------------------- 후행 고정 프롬프트 ----------------------------- ", fg_color="grey10", hover_color="#50164A", font=large_font, variable=self.fixed_prompt_after_label_var, command=fixed_prompt_after_label_command, border_color="#333333")
        self.fixed_prompt_after_label.grid(row = 6, column=0, sticky="w" )
        self.fixed_prompt_after_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['postfix'], font=v_large_font, undo=True)
        self.fixed_prompt_after_input.grid(row=7, column=0, pady=5, sticky="nsew")
        self.negative_prompt_label_frame = customtkinter.CTkFrame(self.text_input_frame, fg_color="#2B2B2B")
        self.negative_prompt_label_frame.grid(row = 8, column=0, sticky="nsew" )
        self.fixed_prompt_after_input.bind("<FocusOut>", highlight_text_after)
        self.fixed_prompt_after_input.tag_config("highlight", foreground="#FFFF97")

        def negative_prompt_label_command():
            if self.negative_prompt_label_var.get() == 0:
                self.negative_prompt_input.grid_forget()
            else:
                self.negative_prompt_input.grid(row=9, column=0, pady=5, sticky="nsew")

        def highlight_text_negative(event=None):
            if '#' in self.negative_prompt_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.negative_prompt_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.negative_prompt_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.negative_prompt_input.tag_add("highlight", start, end)    

        self.negative_prompt_label_var = customtkinter.IntVar(value=1)
        self.negative_prompt_label = customtkinter.CTkCheckBox(self.negative_prompt_label_frame, text=" --------------------------- 네거티브 프롬프트 ---------- CFG Early Skip : ", fg_color="grey10", hover_color="#50164A", font=large_font, variable=self.negative_prompt_label_var, command=negative_prompt_label_command,border_color="#333333" )
        self.negative_prompt_label.grid(row = 0, column=0, sticky="w" )
        self.uncond_strength_entry = customtkinter.CTkEntry(self.negative_prompt_label_frame, font=customtkinter.CTkFont('Pretendard', 12), width=42)
        self.uncond_strength_entry.grid(row = 0, column=1, sticky="e" )
        self.uncond_strength_entry.insert(0, "19.19")
        if self.app_mode == "WEBUI": 
            self.uncond_strength_entry.configure(state="disabled")
        self.negative_prompt_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['negative'], font=v_large_font, undo=True)
        self.negative_prompt_input.insert("0.0", "lowres, {bad}, error, fewer, extra, missing, worst quality, jpeg artifacts, bad quality, watermark, unfinished, displeasing, chromatic aberration, signature, extra digits, artistic error, username, scan, [abstract]")
        self.negative_prompt_input.grid(row=9, column=0, pady=5, sticky="nsew")
        self.negative_prompt_input.bind("<FocusOut>", highlight_text_negative)
        self.negative_prompt_input.tag_config("highlight", foreground="#FFFF97")

        def auto_hide_label_command():
            if self.auto_hide_keyword_input_var.get() == 0:
                self.auto_hide_keyword_input.grid_forget()
            else:
                self.auto_hide_keyword_input.grid(row=11, column=0, pady=5, sticky="nsew")

        def highlight_text_autohide(event=None):
            if '#' in self.auto_hide_keyword_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.auto_hide_keyword_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.auto_hide_keyword_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.auto_hide_keyword_input.tag_add("highlight", start, end)    

        self.auto_hide_keyword_input_var = customtkinter.IntVar(value=1)

        self.auto_hide_keyword_input_var =  customtkinter.IntVar(value=1)
        self.auto_hide_label = customtkinter.CTkCheckBox(self.text_input_frame, text=" -----------------------------  자동숨김 키워드  ---------------------- ", fg_color="grey10", hover_color="#50164A", font=my_font, variable=self.auto_hide_keyword_input_var, command=auto_hide_label_command,border_color="#333333" )
        self.auto_hide_label.grid(row = 10, column=0, sticky="w" )
        self.auto_hide_keyword_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['autohide'], font=v_large_font, undo=True)
        self.auto_hide_keyword_input.grid(row=11, column=0, pady=5, sticky="nsew")
        self.auto_hide_keyword_input.bind("<FocusOut>", highlight_text_autohide)
        self.auto_hide_keyword_input.tag_config("highlight", foreground="#FFFF97")
        self.auto_hide_keyword_input.insert("0.0", "monochrome, doujin cover, bad source, __censor__, bad id, _logo, bad twitter id, comic, __background__, __stuffed__, __bubble__, __text__, __watermark__, __address__, __writing__, fake screenshot, __piercing__, tattoo, __effects__, greyscale, peeing, __chess__, trading card, __(medium)__, __theme__, __pokemon__, recording, viewfinder, toddlercon, __name__, __pasties__, __butt plug__, __eyepatch__, blurry")
        self.auto_hide_window = None

        def open_auto_hide_search():
            auto_hide_window = customtkinter.CTkToplevel()
            self.auto_hide_window = auto_hide_window
            auto_hide_window.title("자동숨김 키워드 검색")
            auto_hide_window.attributes('-topmost', True)
            auto_hide_window.resizable(width=False, height=False)

            def on_close():
                text.configure(state="normal")
                text.delete("0.0", "end")
                text.configure(font=my_font)
                text.insert("0.0", "__키워드__  ,  _키워드_ , _키워드 , 키워드_  또는 언더바 없는 키워드로 검색합니다. \n\n 키워드 : 키워드를 포함하는 nai 태그를 전부 보여줍니다. \n\n __키워드__ : 자동숨김 키워드에 입력했을 때 자동으로 제거되는 nai 태그를 나타냅니다. 문자열에 키워드가 존재하면 모두 제거합니다. \n\n _키워드 , 키워드_ , _키워드_ : 자동숨김 키워드에 입력했을 때 자동으로 제거되는 nai 태그를 나타냅니다. _는 공백 문자 ' '로 치환됩니다. \n\n 참고사항 : 이 검색기능에는 작품명, 작가명, 캐릭터명, variant set 같은 메타 정보들은 포함되지 않습니다. \n\n 자동숨김 키워드에 ~키워드 입력시 해당 키워드는 조건에 포함되어도 보존합니다.")
                text.configure(state="disabled")
                auto_hide_window.withdraw()

            def on_search():
                search_word = entry.get()
                if search_word.startswith("__") and search_word.endswith("__"):
                    modified_search = search_word.replace("_", "")
                elif search_word.startswith("_") and search_word.endswith("_"):
                    modified_search = search_word.replace("_", " ")
                elif search_word.startswith("_"):
                    modified_search = search_word.replace("_", " ", 1)
                elif search_word.endswith("_"):
                    modified_search = search_word[:-1] + " "
                else:
                    modified_search = search_word
                filtered_items = [(key, value) for key, value in generals.items() if modified_search in key]
                sorted_items = sorted(filtered_items, key=lambda x: x[1], reverse=True)
                result_str = "".join([f"{key} : {value}\n" for key, value in sorted_items])
                text.configure(state="normal")
                text.delete("0.0", "end")
                text.configure(font=v_large_font)
                if result_str == "": 
                    text.insert("0.0", "해당하는 검색어가 없습니다. \n\n 참고사항 : 이 검색기능에는 작품명, 작가명, 캐릭터명, variant set 같은 메타 정보들은 포함되지 않습니다.")
                else:
                    text.insert("0.0", result_str)
                text.configure(state="disabled")

            label1 = customtkinter.CTkLabel(auto_hide_window, text="검색할 키워드 입력", font=my_font, text_color="yellow")
            label1.grid(row =0, column= 0, sticky="n", padx=5, pady=5)
            entry = customtkinter.CTkEntry(auto_hide_window, font=my_font, width=140)
            entry.grid(row =1, column= 0, sticky="n", padx=5, pady=5)
            button = customtkinter.CTkButton(auto_hide_window, text="검색", font=my_font, width=140, command=on_search)
            button.grid(row =1, column= 1, sticky="n", padx=5, pady=5)
            text = customtkinter.CTkTextbox(auto_hide_window, width=280, height=400,font=my_font, undo=True)
            text.insert("0.0", "__키워드__  ,  _키워드_ , _키워드 , 키워드_  또는 언더바 없는 키워드로 검색합니다. \n\n 키워드 : 키워드를 포함하는 nai 태그를 전부 보여줍니다. \n\n __키워드__ : 자동숨김 키워드에 입력했을 때 자동으로 제거되는 nai 태그를 나타냅니다. 문자열에 키워드가 존재하면 모두 제거합니다. \n\n _키워드 , 키워드_ , _키워드_ : 자동숨김 키워드에 입력했을 때 자동으로 제거되는 nai 태그를 나타냅니다. _는 공백 문자 ' '로 치환됩니다. \n\n 참고사항 : 이 검색기능에는 작품명, 작가명, 캐릭터명, variant set 같은 메타 정보들은 포함되지 않습니다.")
            text.grid(row =2, column= 0, columnspan=2, sticky="n", padx=5, pady=5)
            text.configure(state="disabled")

            auto_hide_window.protocol("WM_DELETE_WINDOW", on_close)
            auto_hide_window.after(1500, lambda: auto_hide_window.attributes('-topmost', False))


        def _open_auto_hide_search():
            if self.auto_hide_window is not None:
                self.auto_hide_window.deiconify()
            else:
                open_auto_hide_search()

        self.auto_hide_search = customtkinter.CTkButton(self.text_input_frame, text="키워드 검색", font=my_font, fg_color="grey10", hover_color="grey", width=32, height=24, command=_open_auto_hide_search)
        self.auto_hide_search.grid(row=10, column=0, sticky="e")

        self.fix_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.fixed_prompt_input,
            autocomplete_var=self.autocomplete_var,
            wildcard_dict_tree=self.wildcard_dict_tree
        )

        self.text_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.text_input,
            autocomplete_var=self.autocomplete_var,
            wildcard_dict_tree=self.wildcard_dict_tree
        )

        self.fix_after_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.fixed_prompt_after_input,
            autocomplete_var=self.autocomplete_var,
            wildcard_dict_tree=self.wildcard_dict_tree
        )

        self.negative_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.negative_prompt_input,
            autocomplete_var=self.autocomplete_var,
            wildcard_dict_tree=None
        )

        self.auto_hide_autocomplete = AutoCompleteHandler(
            master=self,
            app_mode=self.app_mode, 
            text_widget=self.auto_hide_keyword_input,
            autocomplete_var=self.autocomplete_var,
            wildcard_dict_tree=None
        )

        def bottom_ui_hide_command():
            if self.bottom_ui_hide_var.get() == 0:
                self.bottom_ui_toggle.configure(text="하단 기능 펼치기")
                self.unlock_hold_prompt.grid_forget()
                self.toggle_wildcard_preopen.grid_forget()
                self.conditional_frame.grid_forget()
                self.conditional_prompt_label.grid_forget()
                self.conditional_prompt_input.grid_forget()
                self.conditional_negative_label.grid_forget()
                self.conditional_negative_input.grid_forget()
            else:
                self.bottom_ui_toggle.configure(text="하단 기능 숨기기")
                self.unlock_hold_prompt.grid(row = 13, column = 0, pady=5, sticky="w")
                self.toggle_wildcard_preopen.grid(row = 14, column = 0, pady=5, sticky="w")
                self.conditional_frame.grid(row = 15, column=0, sticky="w", pady=5)
                self.conditional_prompt_label.grid(row = 16, column=0, sticky="n" )
                self.conditional_prompt_input.grid(row=17, column=0, pady=5, sticky="nsew")
                self.conditional_negative_label.grid(row = 18, column=0, sticky="n" )
                self.conditional_negative_input.grid(row=19, column=0, pady=5, sticky="nsew")

        self.bottom_ui_hide_var = customtkinter.IntVar(value=1)
        self.bottom_ui_toggle = customtkinter.CTkCheckBox(self.text_input_frame, text="하단 기능 숨기기", fg_color="grey10", hover_color="#50164A", font=my_font, variable=self.bottom_ui_hide_var, command=bottom_ui_hide_command,border_color="#333333" )
        self.bottom_ui_toggle.grid(row = 12, column = 0, pady=5, sticky="w")
        self.auto_quality_toggle_var = customtkinter.IntVar()
        self.auto_quality_toggle =customtkinter.CTkCheckBox(self.text_input_frame, text="Auto Quality Tag 활성화 (UC Preset은 제외)", font=my_font, variable=self.auto_quality_toggle_var)
        self.auto_quality_toggle.grid(row = 12, column = 0, pady=5, sticky="e")
        self.auto_quality_toggle.select()

        self.awai_activate_i2i = customtkinter.IntVar(value=0)
        self.custom_script_activate_var = customtkinter.IntVar(value=0)

        self.custom_script_text = customtkinter.CTkTextbox(self.text_input_frame,  width=490, height=700, font=v_large_font, undo=True)
        cs_text_hyperlink = customtkinter.CTkLabel(self.text_input_frame, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2")
        cs_text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/129566421"))

        def activate_custom_script():
            if self.custom_script_activate_var.get() == 1:
                self.custom_script_text.grid(row = 30, column = 0, pady=5, sticky="nsew")
            else:
                self.custom_script_text.grid_forget()

        if self.app_mode == "WEBUI":
            self.awai_activate_i2i = customtkinter.CTkCheckBox(self.text_input_frame,text="매 NAI 생성마다 ADetailer 및 i2i 자동 실행", font=my_font)
            self.awai_activate_i2i.grid(row=26, column=0, sticky="w")
            self.enable_autodetailer = customtkinter.CTkCheckBox(self.text_input_frame,text="WEBUI img2img ADetailer 활성화 / 강도 : ", font=my_font)
            self.enable_autodetailer.grid(row = 27, column = 0, sticky="w")
            self.autodetailer_strength = customtkinter.CTkEntry(self.text_input_frame, font=my_font,  textvariable=tk.StringVar(value = "0.4"), width=50)
            self.autodetailer_strength.grid(row = 27, column = 0, padx=165, sticky="e")
            self.enable_cfg_rescale = customtkinter.CTkCheckBox(self.text_input_frame,text="( Reforge )  CFG Rescale  활성화  /  강도 : ", font=my_font)
            self.enable_cfg_rescale.grid(row = 28, column = 0, sticky="w")
            self.enable_cfg_rescale_strength = customtkinter.CTkEntry(self.text_input_frame, font=my_font,  textvariable=tk.StringVar(value = "0.5"), width=50)
            self.enable_cfg_rescale_strength.grid(row = 28, column = 0, padx=165, sticky="e")
            self.enable_DT = customtkinter.CTkCheckBox(self.text_input_frame,text="(Reforge) DynamicThresholding 7 / 99% 활성 : ", font=my_font, state="disabled")
            self.enable_cfg_rescale_old =  customtkinter.CTkCheckBox(self.text_input_frame,text="구버전 체크", font=my_font)
            self.enable_cfg_rescale_old.grid(row = 28, column = 0, sticky="e")
            self.custom_script_activate = customtkinter.CTkCheckBox(self.text_input_frame,text="커스텀 스크립트 (sd-webui-api-payload-display) 활성화", font=my_font, variable=self.custom_script_activate_var, command=activate_custom_script)
            self.custom_script_activate.grid(row = 29, column = 0, sticky="w")
            cs_text_hyperlink.grid(row=29, column=0, padx=5, pady=5, sticky="e")
            
        self.unlock_hold_prompt_var = customtkinter.IntVar()

        def unlock_hold():
            if self.unlock_hold_prompt_var.get() == 1:
                self.fixed_prompt_input.configure(state="normal", text_color="#DCE4EE")
                self.fixed_prompt_after_input.configure(state="normal", text_color="#DCE4EE")
            elif self.unlock_hold_prompt_var.get() == 0 and self.toggle_prompt_fix_button.get() == 1:
                self.fixed_prompt_input.configure(state="disabled", text_color="#A2B8D2")
                self.fixed_prompt_after_input.configure(state="disabled", text_color="#A2B8D2")

        def reset_wildcard_preopen():
            if self.toggle_wildcard_preopen_var.get() == 1:
                self.wildcard_preopen_repeat_current = self.wildcard_preopen_repeat
            if self.Automation_setting:
                if self.toggle_wildcard_preopen.get() == 1: 
                    self.Automation_setting.repeat_wildcard_hold.deselect()
                    self.Automation_setting.repeat_wildcard_hold.configure(state="disabled")
                else: self.Automation_setting.repeat_wildcard_hold.configure(state="normal")

        def wildcard_standalone():
            if self.app_mode == "NAI" and self.current_model_nai.get() == "NAID4":
                if self.wildacrd_standalone.get() == 1:
                    self.naid4_auto_reroll.select()
                else:
                    self.naid4_auto_reroll.deselect()

        def upscale_image():
            def run_upscale():
                gen_request = {
                    "prompt" : self.image_queue[self.current_window][1],
                    "save_folder": self.output_file_path,
                    "start_time": self.start_time,
                    "png_rule": self.name_var.get(),
                    "user_screen_size": self.get_max_size(),
                }
                if gen_request["png_rule"] == "count":
                    self.generation_count += 1
                    gen_request["count"] =self.generation_count
                image = Image.open(self.image_queue[self.current_window][3])
                _width, _height = image.size
                if _width * _height < 1111111:
                    self.state_label.configure(text ="Upscale 요청됨 (Anlas 소모)")
                else:
                    self.state_label.configure(text ="Upscale은 기본 해상도만 가능합니다")
                    return
                result_image, result_prompt, result_seed, info, filename = NAIA_generation.upscale_NAI(self.access_token, image, gen_request)
                self.get_anlas()
                self.state_label.configure(text ="Upscale 요청 반환됨")
                if info:
                    temp = naia_functions.extract_prompt_info(info, app.app_mode)
                    if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                else:
                    temp = result_prompt
                naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                if result_image:
                    if app.state() != 'zoomed':
                        instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                    else:
                        current_image = Image.open(filename)
                        new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                        instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                    app.image_label.configure(image=instant_result_image)
                    app.ext_set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
            generation_thread = threading.Thread(target=run_upscale, daemon=True)
            generation_thread.start()

        self.unlock_hold_prompt = customtkinter.CTkCheckBox(self.text_input_frame, text="프롬프트 고정: 선행/후행/랜덤 프롬프트 잠금 강제해제 ", font=my_font, variable=self.unlock_hold_prompt_var, state="disabled", command=unlock_hold)
        self.unlock_hold_prompt.grid(row = 13, column = 0, pady=5, sticky="w")
        self.unlock_hold_prompt.deselect()
        self.toggle_wildcard_preopen_var = customtkinter.IntVar()
        self.toggle_wildcard_preopen = customtkinter.CTkCheckBox(self.text_input_frame, text="선행프롬의 와일드카드를 랜덤 프롬프트에서 먼저 오픈", font=my_font, variable=self.toggle_wildcard_preopen_var, command=reset_wildcard_preopen)
        self.toggle_wildcard_preopen.select()
        self.wildacrd_standalone = customtkinter.CTkCheckBox(self.text_input_frame, text="와일드카드 단독 모드", font=my_font, command=wildcard_standalone)
        self.wildacrd_standalone.grid(row = 13, column = 0, padx=20, pady=5, sticky="e")

        self.conditional_frame = customtkinter.CTkFrame(self.text_input_frame, fg_color="#2B2B2B")
        self.conditional_frame.grid(row = 15, column=0, sticky="w", pady=5)

        self.cond_prompt_button_var = customtkinter.IntVar()
        self.cond_prompt_button = customtkinter.CTkCheckBox(self.conditional_frame,text="조건부 프롬프트 활성화", variable=self.cond_prompt_button_var,font=my_font )
        self.cond_prompt_button.grid(row = 0, column = 0, sticky="w")

        self.cond_negative_button_var = customtkinter.IntVar()
        self.cond_negative_button = customtkinter.CTkCheckBox(self.conditional_frame,text="조건부 네거티브 활성화", variable=self.cond_negative_button_var, font=my_font )
        self.cond_negative_button.grid(row = 0, column = 1, sticky="w", padx=5)

        if self.app_mode == "WEBUI":
            self.tiled_vae_var = customtkinter.IntVar()
            self.tiled_vae_button = customtkinter.CTkCheckBox(self.conditional_frame,text="Tiled VAE 지원종료", variable=self.tiled_vae_var, font=my_font, state="disabled")
            self.tiled_vae_button.grid(row = 1, column = 0, sticky="w", pady=5)
            self.tiled_vae_entry = customtkinter.CTkEntry(self.conditional_frame, font=my_font, width=240, state="disabled")
            self.tiled_vae_entry.grid(row = 1, column = 1, sticky="nsew", padx=5, pady=5)
            self.tiled_vae_entry.insert(0, "True, 1536, 96, True, True, True, True")

        def highlight_text_cond(event=None):
            if '#' in self.conditional_prompt_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.conditional_prompt_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.conditional_prompt_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.conditional_prompt_input.tag_add("highlight", start, end)    

        def highlight_text_cond_neg(event=None):
            if '#' in self.conditional_negative_input.get("1.0", tk.END):
                # 기존의 하이라이트를 모두 제거
                self.conditional_negative_input.tag_remove("highlight", "1.0", tk.END)

                # '#'으로 시작하여 ','나 '\n', 또는 텍스트 끝까지 이어지는 모든 부분을 찾음
                for match in re.finditer(r'#.*?([,\n]|$)', self.conditional_negative_input.get("1.0", tk.END)):
                    start = "1.0 + {}c".format(match.start())
                    end = "1.0 + {}c".format(match.end())
                    self.conditional_negative_input.tag_add("highlight", start, end)    

        self.conditional_prompt_label = customtkinter.CTkLabel(self.text_input_frame, text=" ------------------------  조건부 프롬프트 (랜덤시 적용) ------------------------", font=my_font)
        self.conditional_prompt_label.grid(row = 16, column=0, sticky="w" )
        self.conditional_prompt_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['cond_prompt'], font=v_large_font, undo=True)
        self.conditional_prompt_input.grid(row=17, column=0, pady=5, sticky="nsew")
        self.conditional_prompt_input.bind("<FocusOut>", highlight_text_cond)
        self.conditional_prompt_input.tag_config("highlight", foreground="#FFFF97")

        def check_cpp():
            if self.conditional_prompt_prefix.get() == 1:
                if "프롬프트" not in self.fixed_prompt_input.get("0.0", "end"):
                    self.fixed_prompt_input.insert("end", " ,#프롬프트")

        self.conditional_prompt_prefix = customtkinter.CTkCheckBox(self.text_input_frame, text="조건부 프롬프트를 선행고정 프롬프트에도 적용 (작가명 뒤에 ,#프롬프트, 로 구분 필요)", font=my_font, command=check_cpp)
        self.conditional_prompt_prefix.grid(row=18, column=0, pady=5, sticky="nsew")


        self.conditional_negative_label = customtkinter.CTkLabel(self.text_input_frame, text=" ------------------------  조건부 네거티브 (생성시 적용) ------------------------", font=my_font)
        self.conditional_negative_label.grid(row = 19, column=0, sticky="w" )
        self.conditional_negative_input = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=self.ui_size['cond_negative'], font=v_large_font, undo=True)
        self.conditional_negative_input.grid(row=20, column=0, pady=5, sticky="nsew")
        self.conditional_negative_input.bind("<FocusOut>", highlight_text_cond_neg)
        self.conditional_negative_input.tag_config("highlight", foreground="#FFFF97")

        self.auto_hide_result_label = customtkinter.CTkLabel(self.text_input_frame, text=" 이번 프롬프트에서 숨겨진 키워드 : ", font=my_font)
        self.auto_hide_result_label.grid(row = 22, column=0, pady=5, sticky="w" )
        self.auto_hide_result = customtkinter.CTkTextbox(self.text_input_frame, width=490, height=100, font=v_large_font, undo=True, state="disabled")
        self.auto_hide_result.grid(row=23, column=0, pady=5, sticky="nsew")
        self.auto_hide_add_negative = customtkinter.CTkCheckBox(self.text_input_frame, text="네거티브에 자동 추가                                                    ", font=my_font)
        self.auto_hide_add_negative.grid(row = 22, column=0, pady=5, sticky="e")
        if self.app_mode == "WEBUI":
            check_extension = NAIA_utils.get_extensions_list(self.access_token)
            #'sd-webui-incantations'
            self.pag_isExist = False
            if 'sd-webui-incantations' in check_extension:
                self.pag_isExist = True
                self.pag_activate = customtkinter.CTkCheckBox(self.text_input_frame, text="Activate Perturbed Attention Guidance (PAG) : ", font=my_font)
                self.pag_activate.grid(row = 24, column=0, pady=5, sticky="w" )
                self.pag_strength = customtkinter.CTkEntry(self.text_input_frame, font=my_font,  textvariable=tk.StringVar(value = "5.0"), width=50)
                self.pag_strength.grid(row = 24, column = 0, padx=125, sticky="e")

        #이미지 히스토리
        self.image_history_frame = customtkinter.CTkFrame(self.right_frame)
        self.image_history_frame.grid(row=0, column=0, columnspan=2, rowspan=15, padx=5, pady=5, sticky="w")

        def show_context_menu(event):
            if len(app.image_queue) != 0:
                self.image_label_context_menu.tk_popup(event.x_root, event.y_root)

        def copy_file(event=None):
            focused_widget = self.focus_get()
            if focused_widget == self:
                file_path = self.image_queue[self.current_window][3]
                command = f"powershell -command \"Get-Item '{file_path}' | Set-Clipboard\""
                os.system(command)
            self.control_pressed = False

        def copy_file_instant(event=None):
            file_path = self.image_queue[self.current_window][3]
            command = f"powershell -command \"Get-Item '{file_path}' | Set-Clipboard\""
            os.system(command)

        def copy_image_instant(event=None):
            file_path = self.image_queue[self.current_window][3]
            img = Image.open(file_path)
            if sys.platform == "win32":
                output = io.BytesIO()
                img.convert("RGB").save(output, "BMP")
                data = output.getvalue()[14:]
                output.close()
                win32clipboard.OpenClipboard()
                win32clipboard.EmptyClipboard()
                win32clipboard.SetClipboardData(win32clipboard.CF_DIB, data)
                win32clipboard.CloseClipboard()
            elif sys.platform == "Darwin":
                temp_path = "/tmp/clipboard_image.png"
                img.save(temp_path)
                subprocess.run(["osascript", "-e", 
                            f'set the clipboard to (read (POSIX file "{temp_path}") as JPEG picture)'])

        def import_file_instant(event=None):
            file_path = self.image_queue[self.current_window][3]
            _img = Image.open(file_path)
            set_image_reference(_img)

        def large_image_generation(vibe=None):
            file_path = self.image_queue[self.current_window][3]
            _img = Image.open(file_path)
            NAI_width, NAI_height = _img.size
            prompt = self.image_queue[self.current_window][1]
            NAI_width, NAI_height = find_max_resolution(NAI_width, NAI_height, 2166784)
            if self.seed_fix_button.get() == 0:
                _temp_new_seed = random.randint(0,2**32 - 1)
                self.entry_seed_value.set(_temp_new_seed)            
            scale_pre = self.cfg_scale_entry.get()
            try:
                scale_pre = float(scale_pre)
            except:
                scale_pre = 5.0
                self.cfg_scale_var.set("5.0")
            rescale_pre = self.prompt_guidance_rescale_entry.get()
            try:
                rescale_pre = float(rescale_pre)
            except:
                rescale_pre = 0
                self.prompt_guidance_rescale_var.set("0")
            uncond_pre = self.uncond_strength_entry.get()
            try:
                uncond_pre = float(uncond_pre)
                #uncond_pre = round(uncond_pre / 0.05) * 0.05
                if (uncond_pre > 162):
                    uncond_pre = 19.19
                    self.uncond_strength_entry.delete(0, "end")
                    self.uncond_strength_entry.insert(0,"19.19")
            except:
                uncond_pre = 1.0
                self.uncond_strength_entry.delete(0, "end")
                self.uncond_strength_entry.insert(0, "19.19")
            if ' + ' in app.sampler_button.get():
                _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
            else:
                _sampler = app.sampler_button.get()
                _noise_schedule = "native"
            gen_request = {
                "width":NAI_width,
                "height":NAI_height,
                "quality_toggle":app.auto_quality_toggle_var.get(),
                "seed":self.seed_entry.get(),
                "sampler":_sampler,
                "noise_schedule": _noise_schedule,
                "scale":scale_pre,
                "uncond_scale":uncond_pre,
                "sema":self.sema_button.get(),
                "sema_dyn": self.dyn_button.get(),
                "cfg_rescale": rescale_pre,
                "prompt": prompt,
                "negative":self.negative_prompt_input.get("0.0", "end-1c"),
                "user_screen_size": self.get_max_size(),
                "start_time": self.start_time,
                "access_token": self.access_token,
                "save_folder": self.output_file_path,
                "png_rule": self.name_var.get(),
                "type": "normal",
                "rating":self.current_prompt_rating,
                "hires":True,
                "enable_hr" : False,
                "enable_AD" : False,
                "enable_TV": False
            }
            if app.app_mode == "NAI" and app.variety_button.get() == 1:
                gen_request["skip_cfg_above_sigma"] = True
            if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                gen_request["dynamic_thresholding"] = True
            if self.irfr:
                images, ref_strengths, info_extracted = get_all_vibe_values()
                gen_request["reference_image"] = images
                gen_request["reference_information_extracted"] = info_extracted
                gen_request["reference_strength"] = ref_strengths
            if app.app_mode == "NAI": 
                gen_request["steps"] = int(app.force_steps_entry.get())
            self.image_label_report.configure(state="normal")
            self.image_label_report.delete("0.0", "end")
            self.image_label_report.insert("0.0", "<UserAttention> Anlas가 소모되는 해상도 요청입니다.")
            self.image_label_report.configure(text_color="#FFFF97")
            self.image_label_report.configure(state="disabled")
            self.anlas_request = True
            self.state_label.configure(text ="고해상도 이미지 요청됨")
            if gen_request["png_rule"] == "count":
                self.generation_count += 1
                gen_request["count"] =self.generation_count
            def run_generation(gen_request):
                if app.save_folder_option and app.save_folder_option["isEnabled"]:
                    if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                        app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                    elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                    else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                    if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                        app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                    elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                    else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                    try:
                        gen_request["additional_save_folder"] = { 
                            "command1": app.save_folder_additional_name["command1"],
                            "command2": app.save_folder_additional_name["command2"]
                            }
                    except:
                        gen_request["additional_save_folder"] = { 
                            "command1": "",
                            "command2": ""
                            }                     
                    app.save_folder_additional_name = {}
                if self.access_token_muiti and self.anlas_request:
                    if self.my_anlas.get() > self.my_anlas_multi.get(): gen_request["access_token"] = self.access_token
                    else:gen_request["access_token"] = self.access_token_muiti
                if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                    gen_request['characters'] = app.nai4_character_list
                    gen_request['characters_uc'] = app.nai4_character_uc_list
                    gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                    gen_request['characters_pos_list'] = app.naid4_positions
                    gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                    if app.eye_catch.get() == 1: 
                        gen_request["eye_catch"] = True
                    if type(app.current_popped_row) != type(None) and not app.current_popped_row.empty and app.wildacrd_standalone.get() == 0 and app.toggle_prompt_fix_button.get() == 0:
                        gen_request["eye_catch_prompt"] = [k for k in app.current_popped_row['general'].split(', ')]
                if type(self.generated_popped_row) != type(None) and not self.generated_popped_row.empty: self.generated_popped_row_freezed = self.generated_popped_row.copy()
                else: self.generated_popped_row_freezed = None
                result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                self.state_label.configure(text =f"고해상도 요청 반환됨, RT : {response_time}s")
                if self.anlas_request:
                    self.anlas_request = False
                    self.get_anlas()
                if info:
                    temp = naia_functions.extract_prompt_info(info, app.app_mode)
                    if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                if not app.generation_queue:
                    self.turbo_button.configure(state="normal")
                naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                if result_image:
                    if app.state() != 'zoomed':
                        instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                    else:
                        current_image = Image.open(filename)
                        new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                        instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                    set_image_to_queue(result_image, result_prompt, result_seed, filename)
            generation_thread = threading.Thread(target=run_generation, args=(gen_request,), daemon=True)
            generation_thread.start()

        #이미지 레이블
        self.image_label = customtkinter.CTkLabel(self.image_history_frame, text="")
        self.image_label.grid(row=1, column=0, rowspan=14, padx=10, pady=5, sticky="w")
        self.image_label.bind("<Button-3>", show_context_menu)
        self.image_label.bind("<Button-2>", show_context_menu)
        self.transform_button2 = None

        def view_image_info():
            file_path = self.image_queue[self.current_window][3]
            self.on_drop(file_path)
        
        self.image_label_context_menu = tk.Menu(self, tearoff=0, font=v_large_font)
        self.image_label_context_menu.add_command(label="파일을 클립보드에 복사", command=copy_file_instant)
        self.image_label_context_menu.add_command(label="이미지를 클립보드에 복사", command=copy_image_instant)
        self.image_label_context_menu.add_command(label="이미지 메타데이터 확인", command=view_image_info)
        if self.app_mode == "NAI" and "NAID4" not in self.current_model_nai.get(): 
            self.image_label_context_menu.add_command(label="이미지를 Vibe Transfer로 할당", command=import_file_instant)
            self.image_label_context_menu.add_command(label="즉시 고해상도 이미지 재생성", command=large_image_generation)
            self.image_label_context_menu.add_command(label="고해상도 이미지 재생성 (vibe)", command=lambda: large_image_generation(True))

        if self.display_scale > 150:  self.image_label_report = customtkinter.CTkTextbox(self.right_frame, width=710, height=60, font=large_font)
        else: self.image_label_report = customtkinter.CTkTextbox(self.right_frame, width=710, height=100, font=large_font)
        #image_label_report.insert("0.0", "1girl, {{minato aqua, ahoge, blue hair, braid, colored inner hair}}, artist:healthyman, [[[[[[[[[[artist:mikozin]]]]]]]]]], [[[artist:lakilolom]]], [[[[artist:crumbles]]]], [[artist:tianliang_duohe_fangdongye]], breasts, dutch angle, gloves, groin, gun, handgun, looking at viewer, nipples, no panties, one eye closed, skirt, smile, solo, topless, weapon, commentary request, highres, nsfw, great quality, aesthetic, absurdres, retouched, smooth lines, excellent color, suitable texture (SEED:22222222222), This text is sample, not an output of the actual generated result.")
        self.image_label_under_frame = customtkinter.CTkFrame(self.image_history_frame)
        self.image_label_under_frame.grid(row=0, column=0, padx=10, pady=5, sticky="ew")
        self.open_save_folder = customtkinter.CTkButton(self.image_label_under_frame, text="📁", font=my_font, fg_color="transparent", text_color="#FFFF97", width=20,command=lambda: open_file_explorer(self))
        self.open_save_folder.grid(row=0, column=0,padx=5, pady=5, sticky="nsew")
        self.window_label = customtkinter.CTkLabel(self.image_label_under_frame, text="0 / 0", font=my_font, width=80)
        self.window_label.grid(row=0, column=4,padx=5, pady=5, sticky="w")
        self.my_anlas = customtkinter.IntVar(value=0)
        self.my_anlas_multi = customtkinter.IntVar(value=0)
        self.anlas_label = customtkinter.CTkLabel(self.image_label_under_frame, text="Anlas : 0", font=my_font)
        if self.app_mode == "NAI":self.anlas_label.grid(row=0, column=5,padx=5, pady=5, sticky="nsew")
        else:
            self.batch_size_label = customtkinter.CTkLabel(self.image_label_under_frame, text="Batch size :        ", font=my_font)
            self.batch_size_label.grid(row=0, column=5,padx=5, pady=5, sticky="w")
            self.batch_size = customtkinter.CTkEntry(self.image_label_under_frame, font=my_font, width=25)
            self.batch_size.grid(row=0, column=5, padx=5, pady=5, sticky="e")
            self.batch_size.insert(0, "1")
        self.request_upper_size_button = customtkinter.CTkButton(self.image_label_under_frame, text="img2img / inpaint",fg_color="transparent", hover_color="grey10", text_color="#FFFF97", font=my_font,state="disabled",  command=lambda: img2img(self), width=100)
        self.request_upper_size_button.grid(row=0, column=6,padx=5, pady=5, sticky="nsew")
        #self.upscale_request = customtkinter.CTkButton(self.image_label_under_frame, text="Upscale", hover_color="grey10", text_color="#FFFF97", font=my_font, fg_color="transparent", state="disabled", width=50)
        #self.upscale_request.grid(row=0, column=7,padx=5, pady=5, sticky="nsew")        
        #self.canvas_mode = customtkinter.CTkButton(self.image_label_under_frame, text="Inpaint", font=my_font, text_color="#0E0F21",fg_color="#F5F3C2", hover_color="#F2F2F2",width=50)
        #self.canvas_mode.grid(row=0, column=9,padx=5, pady=5, sticky="nsew")
        self.open_in_file_explorer = customtkinter.CTkButton(self.image_label_under_frame, text="파일위치열기", font=my_font, text_color="#D7DFE8", fg_color="transparent", width=65,command=lambda: open_in_file_explorer(self))
        self.open_in_file_explorer.grid(row=0, column=8,padx=5, pady=5, sticky="nsew")
        self.open_save_folder.grid(row=0, column=0,padx=5, pady=5, sticky="nsew")
        if self.app_mode == "NAI" or "http" not in self.nai_access_token:
            self.director_frame = customtkinter.CTkFrame(self.right_frame)
            self.director_frame.grid(row=16, column=0, padx=10, pady=2, sticky="nsew")
            em_list = ["declutter", "lineart", "sketch", "colorize", "Neutral", "Happy", "Sad", "Angry", "Scared", "Surprised", "Tired", "Excited", "Nervous", "Thinking", "Confused", "Shy", "Disgusted", "Smug", "Bored", "Laughing", "Irritated", "Aroused", "Embarrassed", "Worried", "Love", "Determined", "Hurt", "Playful"]
            self.emotion_value = customtkinter.StringVar(value="colorize")
            self.emotion_list = customtkinter.CTkComboBox(self.director_frame, values = em_list, variable=self.emotion_value, font=my_font, width=120)
            self.emotion_list.grid(row=0, column=1, padx=2, pady=2, sticky="w")
            defry_list = ["Normal", "Slightly Weak", "Weak", "Even Weaker", "Very Weak", "Weakest"]
            self.defry_value = customtkinter.StringVar(value="Weakest")
            self.defry_list = customtkinter.CTkComboBox(self.director_frame, values = defry_list, variable=self.defry_value, font=my_font, width=110)
            self.defry_list.grid(row=0, column=2, padx=2, pady=2, sticky="w")

            def instant_transform(result_image, filename):
                if not hasattr(app, 'transform_window') or not app.transform_window.winfo_exists():
                    # 새 TopLevel 창 생성
                    app.transform_window = customtkinter.CTkToplevel(app)
                    app.transform_window.title("Transform Result")
                    app.transform_window.attributes('-topmost', True)
                    app.stored_transform_image = result_image
                    
                    # 현재 결과를 저장할 속성 추가
                    app.transform_window.current_result = {
                        'image': None,
                        'prompt': None,
                        'seed': None,
                        'filename': None
                    }
                    
                    # 이미지 레이블 생성
                    app.image_label_transform_temp = customtkinter.CTkLabel(app.transform_window, text="")
                    app.image_label_transform_temp.pack(pady=10, padx=10)
                    
                    # 버튼 프레임 생성
                    button_frame = customtkinter.CTkFrame(app.transform_window)
                    button_frame.pack(pady=10)
                    entry_frame = customtkinter.CTkFrame(app.transform_window)
                    entry_frame.pack(pady=10)
                    
                    # 삭제 버튼 기능
                    def delete_action():
                        if app.transform_window.current_result['filename']:
                            move_to_trash(app.transform_window.current_result['filename'])
                        self.em_entry.configure(textvariable=original_var)
                        self.transform_button.configure(state="normal")
                        self.transform_button2 = None
                        app.transform_window.destroy()
                    
                    # 저장 버튼 기능
                    def save_action():
                        if all(v is not None for v in app.transform_window.current_result.values()):
                            app.ext_set_image_to_queue(
                                app.transform_window.current_result['image'],
                                app.transform_window.current_result['prompt'],
                                str(app.transform_window.current_result['seed']),
                                app.transform_window.current_result['filename']
                            )
                        self.em_entry.configure(textvariable=original_var)
                        self.transform_button.configure(state="normal")
                        self.transform_button2 = None
                        app.transform_window.destroy()
                    
                    # 창 닫기 버튼 기능
                    def on_closing():
                        if app.transform_window.current_result['filename']:
                            move_to_trash(app.transform_window.current_result['filename'])
                        self.em_entry.configure(textvariable=original_var)
                        self.transform_button.configure(state="normal")
                        self.transform_button2 = None
                        app.transform_window.destroy()
                    
                    # 버튼 생성
                    delete_button = customtkinter.CTkButton(button_frame, text="삭제 (닫기)", 
                                                        command=delete_action, font=my_font, 
                                                        fg_color="grey", hover_color="grey10")
                    delete_button.pack(side="left", padx=5)
                    
                    save_button = customtkinter.CTkButton(button_frame, text="저장", command=save_action)
                    save_button.pack(side="left", padx=5)

                    transform_button = customtkinter.CTkButton(button_frame, text="Transform", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", command=transform, font=my_font)
                    transform_button.pack(side="left", padx=5)
                    app.transform_button2 = transform_button

                    # StringVar 생성 및 Entry 배치
                    transform_entry_var = customtkinter.StringVar(value=self.em_entry.get())
                    transform_label = customtkinter.CTkLabel(entry_frame, font=my_font, text="Prompt : ")
                    transform_label.pack(side="left", pady=5)
                    transform_entry = customtkinter.CTkEntry(entry_frame, font=my_font, width=296, textvariable=transform_entry_var)
                    transform_entry.pack(pady=5)

                    # 기존 Entry의 textvariable 저장 및 새로운 StringVar 설정
                    original_var = self.em_entry.cget("textvariable")  # 기존 변수 저장
                    self.em_entry.configure(textvariable=transform_entry_var)

                    info_label = customtkinter.CTkLabel(app.transform_window, 
                                                    text="[저장]을 누르지 않으면 이 창의 이미지는 자동으로 삭제됩니다\n 이 창을 닫기 전 까지는 처음 요청한 이미지로 계속 요청됩니다", 
                                                    font=my_font)
                    info_label.pack(pady=5)
                    
                    # 창 닫기 프로토콜 설정
                    app.transform_window.protocol("WM_DELETE_WINDOW", on_closing)
                
                # 이미지 크기 설정 및 표시
                if app.state() != 'zoomed':
                    current_image = result_image.copy()
                    new_image = app.resize_and_center_image(current_image, 620, 620)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(620,620))
                else:
                    current_image = result_image.copy()
                    new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                
                # 이미지 업데이트
                if hasattr(app, 'transform_window') and app.transform_window.winfo_exists():
                    app.transform_window.current_result.update({
                        'image': result_image,
                        'prompt': "",
                        'seed': 0,
                        'filename': filename
                    })
                app.image_label_transform_temp.configure(image=instant_result_image)

            def transform():
                if len(self.image_queue) < 1 and not hasattr(app, 'transform_window'):
                    app.image_label_report.configure(state="normal")
                    app.image_label_report.delete("0.0", "end")
                    app.image_label_report.configure(text_color="#DCE4EE")
                    app.image_label_report.insert("0.0", f"먼저 하나 이상의 이미지를 생성하세요.")
                    app.image_label_report.configure(state="disabled")
                    return
                def process_prompt(prompt):
                    tokens = self.s_token.encode(prompt)
                    if len(tokens) > 62:
                        app.image_label_report.configure(state="normal")
                        app.image_label_report.delete("0.0", "end")
                        app.image_label_report.configure(text_color="#DCE4EE")
                        _ex = len(tokens) - 62
                        app.image_label_report.insert("0.0", f"토큰 수가 {_ex}만큼 초과됩니다. Director Tool의 Emotion Prompt는 60 ~ 62개의 토큰을 허용합니다. 초과된 토큰은 자동으로 제외되지만 'Response' object has no attribute 'decode' 오류가 발생한다면 프롬프트 토큰을 더 줄이시기 바랍니다. (일반적으로 4바이트(알파벳 4개)당 1토큰으로 간주됩니다.)")
                        app.image_label_report.configure(state="disabled")
                    while len(tokens) > 62:
                        last_comma = prompt.rfind(',')
                        if last_comma == -1:
                            prompt = prompt[:62]
                        else:
                            prompt = prompt[:last_comma]
                        tokens = self.s_token.encode(prompt)
                    return prompt
                if app.app_mode == "NAI": self.image_generation_button.configure(state="disabled")
                self.transform_button.configure(state="disabled")
                if self.transform_button2: self.transform_button2.configure(state="disabled")
                if not hasattr(app, 'transform_window') or not app.transform_window.winfo_exists():
                    try:
                        current_lookup = self.image_queue[self.current_window].copy()
                    except:
                        _i = 1
                        current_lookup = self.image_queue[self.window-_i].copy()
                    app.stored_transform_image = Image.open(current_lookup[3])
                img = app.stored_transform_image
                nw, nh = img.size
                new_width, target_height = find_max_resolution(nw, nh, 1048576)
                img = img.resize((int(new_width), int(target_height)), Image.Resampling.LANCZOS)
                width, height = img.size
                gen_request = {
                    "save_folder": self.output_file_path,
                    "png_rule": self.name_var.get(),
                    "access_token" : self.access_token if app.app_mode =="NAI" else self.nai_access_token,
                    "mode":self.emotion_value.get(),
                    "defry":self.defry_value.get(),
                    "prompt": process_prompt(self.em_entry.get()),
                    "width" : width,
                    "height" : height,
                    "image" : img,
                    "user_screen_size": app.get_max_size(),
                    "start_time": app.start_time
                }
                def run_generation():
                    if app.app_mode == "NAI" and app.running_flag: 
                        print("running_flag 활성상태")
                        return
                    if gen_request["png_rule"] == "count":
                        app.generation_count += 1
                        gen_request["count"] =app.generation_count
                    if app.app_mode == "NAI": app.running_flag = True
                    app.state_label.configure(text ="state : Director Tool 이미지 요청됨 ", text_color = "#FFFF97")
                    if app.save_folder_option and app.save_folder_option["isEnabled"]:
                        if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                        if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                        try:
                            gen_request["additional_save_folder"] = { 
                                "command1": app.save_folder_additional_name["command1"],
                                "command2": app.save_folder_additional_name["command2"]
                                }
                        except:
                            gen_request["additional_save_folder"] = { 
                                "command1": "",
                                "command2": ""
                                }                     
                        app.save_folder_additional_name = {}
                    if app.app_mode == "NAI" and app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                    result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.augment_image_NAI(gen_request)
                    self.image_generation_button.configure(state="normal")
                    if self.transform_button2: self.transform_button2.configure(state="normal")
                    app.nai_generation_count += 1
                    self.control_pressed = False
                    app.running_flag = False
                    app.state_label.configure(text =f"Director Tool 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                    if info:
                        temp = naia_functions.extract_prompt_info(info, app.app_mode)
                        if app.app_mode == "NAI" or "http" not in self.nai_access_token: temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                    else:
                        temp = result_prompt
                    naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                    if result_image:
                        # 기존 창이 있는 경우 이전 파일 삭제
                        if not hasattr(app, 'transform_window') or not app.transform_window.winfo_exists():
                            # 새 TopLevel 창 생성
                            app.transform_window = customtkinter.CTkToplevel(app)
                            app.transform_window.title("Transform Result")
                            app.transform_window.attributes('-topmost', True)
                            
                            # 현재 결과를 저장할 속성 추가
                            app.transform_window.current_result = {
                                'image': None,
                                'prompt': None,
                                'seed': None,
                                'filename': None
                            }
                            
                            # 이미지 레이블 생성
                            app.image_label_transform_temp = customtkinter.CTkLabel(app.transform_window, text="")
                            app.image_label_transform_temp.pack(pady=10, padx=10)
                            
                            # 버튼 프레임 생성
                            button_frame = customtkinter.CTkFrame(app.transform_window)
                            button_frame.pack(pady=10)
                            entry_frame = customtkinter.CTkFrame(app.transform_window)
                            entry_frame.pack(pady=10)
                            
                            # 삭제 버튼 기능
                            def delete_action():
                                if app.transform_window.current_result['filename']:
                                    move_to_trash(app.transform_window.current_result['filename'])
                                self.em_entry.configure(textvariable=original_var)
                                self.transform_button.configure(state="normal")
                                self.transform_button2 = None
                                app.transform_window.destroy()
                            
                            # 저장 버튼 기능
                            def save_action():
                                if all(v is not None for v in app.transform_window.current_result.values()):
                                    app.ext_set_image_to_queue(
                                        app.transform_window.current_result['image'],
                                        app.transform_window.current_result['prompt'],
                                        str(app.transform_window.current_result['seed']),
                                        app.transform_window.current_result['filename']
                                    )
                                self.transform_button.configure(state="normal")
                                self.em_entry.configure(textvariable=original_var)
                                self.transform_button2 = None
                                app.transform_window.destroy()
                            
                            # 창 닫기 버튼 기능
                            def on_closing():
                                if app.transform_window.current_result['filename']:
                                    move_to_trash(app.transform_window.current_result['filename'])
                                self.em_entry.configure(textvariable=original_var)
                                self.transform_button.configure(state="normal")
                                self.transform_button2 = None
                                app.transform_window.destroy()
                            
                            # 버튼 생성
                            delete_button = customtkinter.CTkButton(button_frame, text="삭제 (닫기)", 
                                                                command=delete_action, font=my_font, 
                                                                fg_color="grey", hover_color="grey10")
                            delete_button.pack(side="left", padx=5)
                            
                            save_button = customtkinter.CTkButton(button_frame, text="저장", command=save_action)
                            save_button.pack(side="left", padx=5)

                            transform_button = customtkinter.CTkButton(button_frame, text="Transform", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", command=transform, font=my_font)
                            transform_button.pack(side="left", padx=5)
                            app.transform_button2 = transform_button

                            # StringVar 생성 및 Entry 배치
                            transform_label = customtkinter.CTkLabel(entry_frame, font=my_font, text="Prompt : ")
                            transform_label.pack(side="left", pady=5)
                            transform_entry_var = customtkinter.StringVar(value=self.em_entry.get())
                            transform_entry = customtkinter.CTkEntry(entry_frame, font=my_font, width=296, textvariable=transform_entry_var)
                            transform_entry.pack(pady=5)

                            # 기존 Entry의 textvariable 저장 및 새로운 StringVar 설정
                            original_var = self.em_entry.cget("textvariable")  # 기존 변수 저장
                            self.em_entry.configure(textvariable=transform_entry_var)

                            info_label = customtkinter.CTkLabel(app.transform_window, 
                                                            text="[저장]을 누르지 않으면 이 창의 이미지는 자동으로 삭제됩니다\n 이 창을 닫기 전 까지는 처음 요청한 이미지로 계속 요청됩니다", 
                                                            font=my_font)
                            info_label.pack(pady=5)
                            
                            # 창 닫기 프로토콜 설정
                            app.transform_window.protocol("WM_DELETE_WINDOW", on_closing)
                        
                        # 이미지 크기 설정 및 표시
                        if app.state() != 'zoomed':
                            instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                        else:
                            current_image = Image.open(filename)
                            new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                            instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                        
                        # 이미지 업데이트
                        if hasattr(app, 'transform_window') and app.transform_window.winfo_exists():
                            if app.transform_window.current_result['filename']:
                                move_to_trash(app.transform_window.current_result['filename'])
                            app.transform_window.current_result.update({
                                'image': result_image,
                                'prompt': result_prompt,
                                'seed': result_seed,
                                'filename': filename
                            })
                        app.image_label_transform_temp.configure(image=instant_result_image)
                generation_thread = threading.Thread(target=run_generation, daemon=True)
                generation_thread.start()

            self.transform_button = customtkinter.CTkButton(self.director_frame, text="Transform", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", command=transform, font=my_font, width=80)
            self.transform_button.grid(row=0, column=3, padx=5, pady=2, sticky="w")
            self.em_label = customtkinter.CTkLabel(self.director_frame, text="Prompt : ", font=my_font)
            self.em_label.grid(row=0, column=4, padx=2, pady=2, sticky="w")
            self.em_entry_var = customtkinter.StringVar()
            self.em_entry = customtkinter.CTkEntry(self.director_frame, font=my_font, width=296, textvariable=self.em_entry_var)
            self.em_entry.grid(row=0, column=5, padx=2, pady=2, sticky="w")
            self.last_clicked_window = 0
            self.em_hold = customtkinter.CTkButton(self.director_frame, text="미구현", font=my_font, width=68, command=press_Awildcard, state="disabled", fg_color="grey")
            self.em_hold.grid(row=0, column=6, padx=2, pady=2, sticky="w")
        if self.display_scale > 150: self.image_label_report.grid(row=19, column=0, columnspan=7, padx=10, pady=5, sticky="ew")
        else: self.image_label_report.grid(row=17, column=0, columnspan=7, padx=10, pady=5, sticky="ew")
        self.image_label_report.configure(state="disabled")

        self.tag_window = None
        self.ag_config = None
        self.pt_last_prompt = []
        self.pt_webui_is_busy = False
        self.ag_seed = random.randint(0,2**32 - 1)
        self.proto_current_tags = None
        self.proto_last_generated_image = None
        self.popup_proto = None
        self.listbox_proto = None
        self.proto_last_mainprompt = []
        self.proto_target_index = None
        self.save_folder_option = None
        self.save_folder_additional_name = {
            "command1" : '',
            "command2" : ''
        }

        def open_tag_viewer():
            tag_window = customtkinter.CTkToplevel()
            self.tag_window = tag_window
            tag_window.title("NAIA Prompt Prototyper")
            tag_window.attributes('-topmost', True)
            tag_window.resizable(width=False, height=False)

            tags = NAIA_utils.tags
            master_list = list(tags.keys())

            left_window = customtkinter.CTkScrollableFrame(tag_window, width=420, height=840)
            left_window.grid(row=0, column=0 ,padx=5, pady=5, sticky="nsew")

            center_window = customtkinter.CTkScrollableFrame(tag_window, width=720, height=840)
            center_window.grid(row=0, column=1 ,padx=5, pady=5, sticky="nsew")

            right_window = customtkinter.CTkFrame(tag_window, width=360)
            right_window.grid(row=0, column=2 ,padx=5, pady=5, sticky="nsew")

            if not os.path.exists(os.path.join("prototyper")):
                os.makedirs(os.path.join("prototyper"))

            def instant_image_generation_proto_gen():
                if app.running_flag: 
                    return
                nai_generate.configure(state="disabled")
                pr = preprompt.get("0.0","end").strip()
                ar = postprompt.get("0.0","end").strip()
                mp = mainprompt.get("0.0","end").strip()
                if app.app_mode == "NAI": 
                    request_prompt = pr+", "+mp+", "+ar
                else: 
                    request_prompt = pr+", "+mp+", "+ar
                if app.running_flag == False and app.automation_button.get() == 0:
                    app.running_flag = True
                    scale_pre = self.cfg_scale_entry.get()
                    try:
                        scale_pre = float(scale_pre)
                    except:
                        scale_pre = 5.0
                        app.cfg_scale_var.set("5.0")
                    rescale_pre = app.prompt_guidance_rescale_entry.get()
                    try:
                        rescale_pre = float(rescale_pre)
                    except:
                        rescale_pre = 0
                        app.prompt_guidance_rescale_var.set("0")
                    uncond_pre = app.uncond_strength_entry.get()
                    try:
                        uncond_pre = float(uncond_pre)
                        #uncond_pre = round(uncond_pre / 0.05) * 0.05
                        if (uncond_pre > 162):
                            uncond_pre = 19.19
                            app.uncond_strength_entry.delete(0, "end")
                            app.uncond_strength_entry.insert(0, "1.5")
                    except:
                        uncond_pre = 1.0
                        app.uncond_strength_entry.delete(0, "end")
                        app.uncond_strength_entry.insert(0, "1.0")
                    if ' + ' in app.sampler_button.get():
                        _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
                    else:
                        _sampler = app.sampler_button.get()
                        _noise_schedule = "native"
                    file_path = os.path.join(os.path.join("prototyper"), "prototyper.ini")
                    config = configparser.ConfigParser()
                    config['PROMPTS'] = {
                        'preprompt': pr,
                        'postprompt': ar,
                        'mainprompt': mp,
                        'brackets': br
                    }
                    with open(file_path, 'w') as configfile:
                        config.write(configfile)
                    NAI_width, NAI_height = self.resolution_button.get().split('x')
                    if int(NAI_width) * int(NAI_height) > 1048576:
                        NAI_width = 1024
                        NAI_height = 1024
                    gen_request = {
                            "width":NAI_width,
                            "height":NAI_height,
                            "quality_toggle":app.auto_quality_toggle.get(),
                            "seed":random.randint(0,2**32 - 1) if not app.seed_fix_var.get() == 1 else int(app.seed_entry.get()),
                            "sampler":_sampler,
                            "noise_schedule": _noise_schedule,
                            "scale":scale_pre,
                            "sema":app.sema_button.get(),
                            "sema_dyn": app.dyn_button.get(),
                            "cfg_rescale": rescale_pre,
                            "uncond_scale":uncond_pre,
                            "prompt": request_prompt,
                            "negative":app.negative_prompt_input.get("0.0", "end-1c"),
                            "user_screen_size": app.get_max_size(),
                            "start_time": app.start_time,
                            "access_token": app.access_token,
                            "save_folder": app.output_file_path,
                            "png_rule": app.name_var.get(),
                            "type": "normal",
                            "enable_hr" : False,
                            "enable_AD" : False
                        }
                    if app.app_mode == "NAI" and app.variety_button.get() == 1:
                        gen_request["skip_cfg_above_sigma"] = True
                    if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                        gen_request["dynamic_thresholding"] = True
                    if app.app_mode == "WEBUI" and app.sema_button_var.get() == 1:
                        try:
                            hr_steps_pre = int(app.hires_steps_entry.get())
                        except:
                            hr_steps_pre = 16
                            app.hires_steps_entry.delete(0, "end")
                            app.hires_steps_entry.insert(0, '16')
                        try:
                            upscale_pre = float(app.upscale_entry.get())
                            upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                        except:
                            upscale_pre = 1.5
                        app.upscale_entry.delete(0, "end")
                        app.upscale_entry.insert(0, str(upscale_pre))
                        try:
                            denoise_pre = float(app.denoise_entry.get())
                        except:
                            denoise_pre = 0.35
                            app.denoise_entry.delete(0, "end")
                            app.denoise_entry.insert(0, '0.35')
                        gen_request["enable_hr"] = True
                        gen_request["hr_second_pass_steps"] = hr_steps_pre
                        gen_request["hr_upscaler"] = app.hires_sampler_entry.get()
                        gen_request["hr_scale"] = upscale_pre
                        gen_request["denoising_strength"] = denoise_pre
                    if app.app_mode == "WEBUI" and app.enable_cfg_rescale.get() == 1:
                        gen_request["CFG_rescale"] = True
                        cfg_str_pre = app.enable_cfg_rescale_strength.get()
                        try:
                            cfg_str_pre = float(cfg_str_pre)
                            cfg_str_pre = round(cfg_str_pre, 2)
                        except:
                            cfg_str_pre = 0.5
                            app.enable_cfg_rescale_strength.delete(0, "end")
                            app.enable_cfg_rescale_strength.insert(0, "0.5")
                        gen_request["CFG_rescale_str"] =  cfg_str_pre
                        gen_request["CFG_rescale_version"] = "normal" if app.enable_cfg_rescale_old.get() == 0 else "old"
                    if app.app_mode == "WEBUI" and app.custom_script_activate_var.get() == 1: gen_request['custom_script'] = app.custom_script_text.get("1.0", "end-1c").strip()
                    if app.app_mode == "WEBUI" and app.enable_DT.get() == 1:
                        gen_request["DynamicThresholding"] = True
                    if app.awai_activate_i2i.get() == 1:
                        gen_request["enable_AD"] = True
                        ad_str_pre = app.autodetailer_strength.get()
                        try:
                            ad_str_pre = float(ad_str_pre)
                            ad_str_pre = round(ad_str_pre, 2)
                        except:
                            ad_str_pre = 0.4
                            app.autodetailer_strength.delete(0, "end")
                            app.autodetailer_strength.insert(0, "0.4")
                        gen_request["ad_data_str"] =  ad_str_pre
                    def run_generation():
                            if gen_request["png_rule"] == "count":
                                app.generation_count += 1
                                gen_request["count"] =app.generation_count
                            app.state_label.configure(text ="state : 프로토타이퍼 이미지 요청됨 ", text_color = "#FFFF97")
                            if app.save_folder_option and app.save_folder_option["isEnabled"]:
                                if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                                    app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                                elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                                else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                                if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                                    app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                                elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                                else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                                try:
                                    gen_request["additional_save_folder"] = { 
                                        "command1": app.save_folder_additional_name["command1"],
                                        "command2": app.save_folder_additional_name["command2"]
                                        }
                                except:
                                    gen_request["additional_save_folder"] = { 
                                        "command1": "",
                                        "command2": ""
                                        }                     
                                app.save_folder_additional_name = {}
                            if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                                gen_request['characters'] = app.nai4_character_list
                                gen_request['characters_uc'] = app.nai4_character_uc_list
                                gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                                gen_request['characters_pos_list'] = app.naid4_positions
                                gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                                if app.eye_catch.get() == 1: 
                                    gen_request["eye_catch"] = True
                            if type(self.generated_popped_row) != type(None) and not self.generated_popped_row.empty: self.generated_popped_row_freezed = self.generated_popped_row.copy()
                            else: self.generated_popped_row_freezed = None
                            result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                            self.nai_generation_count += 1
                            nai_generate.configure(state="normal")
                            self.control_pressed = False
                            app.running_flag = False
                            app.state_label.configure(text =f"프로토타이퍼 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                            if info:
                                temp = naia_functions.extract_prompt_info(info, app.app_mode)
                                if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                            else:
                                temp = result_prompt
                            naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                            if result_image:
                                image_label.configure(image=customtkinter.CTkImage(result_image, size=(512,512)))
                                if app.state() != 'zoomed':
                                    instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                                else:
                                    current_image = Image.open(filename)
                                    new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                                    instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                                app.image_label.configure(image=instant_result_image)
                                app.ext_set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                    generation_thread = threading.Thread(target=run_generation, daemon=True)
                    generation_thread.start()

            white_image = Image.new('RGB', (512, 512), 'white')
            image_label = customtkinter.CTkLabel(right_window, text="", image=customtkinter.CTkImage(white_image, size=(512,512)))
            image_label.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
            self.pt_last_prompt = []
            self.pt_webui_is_busy = False
            self.ag_seed = random.randint(0,2**32 - 1)

            def reset_ag_seed():
                self.ag_seed = random.randint(0,2**32 - 1)
                if not self.pt_webui_is_busy and webui_auto_generation.get() == 1:
                    self.pt_webui_is_busy = True
                    guide_generation_thread = threading.Thread(target=run_generation, daemon=True)
                    guide_generation_thread.start()

            def run_generation():
                pr = preprompt.get("0.0","end").strip()
                ar = postprompt.get("0.0","end").strip()
                mp = mainprompt.get("0.0","end").strip()

                if self.ag_config["format_select"] == "Pony":
                    pr = "(score_9,score_8_up,score_7_up,score_6_up,score_5_up,score_4_up), " + pr
                    negative = "(score_4,score_3,score_2,score_1)"
                elif self.ag_config["format_select"] == "Animagine":
                    mp = mp+", masterpiece, best quality, very aesthetic, absurdres"
                    negative = "lowres, (bad), text, error, fewer, extra, missing, worst quality, jpeg artifacts, low quality, watermark, unfinished, displeasing, oldest, early, chromatic aberration, signature, extra digits, artistic error, username, scan, [abstract]"
                else:
                    negative = "lowres, (bad), text, error, fewer, extra, missing, worst quality, jpeg artifacts, low quality, watermark, signature, extra digits, artistic error, username, scan"

                NAI_width, NAI_height = self.ag_config["current_resolution"].split('x')
                gen_request = {
                    "prompt": pr+", "+mp+", "+ar,
                    "negative prompt": negative,
                    "width":NAI_width,
                    "height":NAI_height,
                    "seed": self.ag_seed if self.ag_config["not_fix_seed"] == 0 else random.randint(0,2**32 - 1),
                    "sampler":self.ag_config["current_sampler"],
                    "cfg_scale":self.ag_config["cfg_scale"],
                    "steps": self.ag_config["sampling_step"]
                    }
                if self.ag_config["current_scheduler"]: gen_request["scheduler"] = self.ag_config["current_scheduler"]
                try:
                    result_image = NAIA_generation.generate_typer_image_webui(self.NAI_webui_address, gen_request)
                    try:
                        info = result_image.info['parameters']
                        app.image_label_report.configure(state="normal")
                        app.image_label_report.delete("0.0", "end")
                        app.image_label_report.configure(text_color="#DCE4EE")
                        app.image_label_report.insert("0.0", "Prototyper generated image : "+info)
                        app.image_label_report.configure(state="disabled")
                    except:
                        pass
                    if app.state() != 'zoomed':
                        instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                    else:
                        instant_result_image = customtkinter.CTkImage(result_image, size=(self.wide_res_width, self.wide_res_height))
                    file_path = os.path.join(os.path.join("prototyper"), "temp.jpg")
                    result_image.save(file_path, "JPEG", quality=90)
                    self.image_label.configure(image=instant_result_image)
                    if result_image: image_label.configure(image=customtkinter.CTkImage(result_image, size=(512,512)))
                    self.pt_webui_is_busy = False
                    if webui_auto_generation.get() == 1: tag_window.after(500, webui_auto_generate)
                except:
                    self.pt_webui_is_busy = False
                    if webui_auto_generation.get() == 1: tag_window.after(500, webui_auto_generate)

            def final_check():
                prompt_check = []
                prompt_check = preprompt.get("0.0","end").strip().split(',') + mainprompt.get("0.0","end").strip().split(',') + postprompt.get("0.0","end").strip().split(',')
                prompt_check = [key.strip() for key in prompt_check]          

                if not self.pt_webui_is_busy and prompt_check != self.pt_last_prompt:
                    self.pt_last_prompt = []
                    self.pt_last_prompt[:] = prompt_check
                    if webui_auto_generation.get() == 1: tag_window.after(500, final_check)      
                elif not self.pt_webui_is_busy and prompt_check == self.pt_last_prompt:
                    self.pt_webui_is_busy = True
                    self.pt_last_prompt = []
                    self.pt_last_prompt[:] = prompt_check
                    guide_generation_thread = threading.Thread(target=run_generation, daemon=True)
                    guide_generation_thread.start()

            def webui_auto_generate():
                prompt_check = []
                prompt_check = preprompt.get("0.0","end").strip().split(',') + mainprompt.get("0.0","end").strip().split(',') + postprompt.get("0.0","end").strip().split(',')
                prompt_check = [key.strip() for key in prompt_check]

                if not self.pt_webui_is_busy and prompt_check != self.pt_last_prompt:
                    self.pt_last_prompt = []
                    self.pt_last_prompt[:] = prompt_check
                    tag_window.after(500, final_check)
                else:
                    if webui_auto_generation.get() == 1: tag_window.after(500, webui_auto_generate)

            def auto_generation():
                if webui_auto_generation.get() == 1:
                    self.pt_last_prompt = []
                    webui_auto_generate()

            webui_auto_generation = customtkinter.CTkCheckBox(right_window, font=my_font,text="WEBUI Auto Generation (For Hyper-SD / Lightning)", state="disabled", command=auto_generation)
            webui_auto_generation.grid(row=1, column=0 ,padx=5, pady=5, sticky="w")
            refresh = customtkinter.CTkButton(right_window, text=" Seed 🔄️", font=v_large_font, width=55, command=reset_ag_seed)
            refresh.grid(row=1, column=0 ,padx=5,  pady=5, sticky="e")
            nai_generate = customtkinter.CTkButton(right_window, fg_color="#ED7D31", hover_color="#CC5D12", text="NAI Generate" if app.app_mode == "NAI" else "WEBUI Generate", font=my_font, command=instant_image_generation_proto_gen)
            nai_generate.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")

            def open_webui_automation():
                webui_auto_window = customtkinter.CTkToplevel()
                webui_auto_window.title("자동화 설정")
                webui_auto_window.attributes('-topmost', True)
                webui_auto_window.resizable(width=False, height=False)

                ini_file_path = os.path.join(os.path.join("prototyper"), "prototyper_webui.ini")
                config = configparser.ConfigParser()

                def open_lora_list():
                    _list = NAIA_utils.get_lora_list(self.NAI_webui_address)
                    _text = "\n".join(_list)
                    prompt_window = customtkinter.CTkToplevel()
                    prompt_window.title("LoRA 리스트")
                    prompt_window.attributes('-topmost', True)
                    prompt_window.resizable(width=False, height=False)

                    text_label1 = customtkinter.CTkLabel(prompt_window, text="WEBUI 활성 로라 목록", font=customtkinter.CTkFont('Pretendard', 13))
                    text_label1.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                    text_output1 = customtkinter.CTkTextbox(prompt_window, height=550, width=380, font=customtkinter.CTkFont('Pretendard', 15))
                    text_output1.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
                    text_output1.insert("0.0", _text)
                    text_label2 = customtkinter.CTkLabel(prompt_window, text="드래그 후 Ctrl + C로 복사", font=customtkinter.CTkFont('Pretendard', 13))
                    text_label2.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")

                lora_label1 = customtkinter.CTkLabel(webui_auto_window, text="사용할 Hyper/Lightning LoRA를 찾습니다", font=my_font)
                lora_label1.grid(row=0, column=0,pady=5, padx=5, sticky="nsew")
                lora_button = customtkinter.CTkButton(webui_auto_window, text="LoRA 리스트 불러오기", font=my_font, fg_color="grey10", hover_color="grey", command=open_lora_list)
                lora_button.grid(row=1, column=0,pady=5, padx=5, sticky="nsew")
                lora_label2 = customtkinter.CTkLabel(webui_auto_window, text="사용할 해상도를 선택합니다", font=my_font)
                lora_label2.grid(row=2, column=0,pady=5, padx=5, sticky="nsew")
                current_resolution = customtkinter.StringVar(value="768 x 768")
                resolutionbox = customtkinter.CTkComboBox(webui_auto_window, values=["768 x 768", "1024 x 1024"], variable=current_resolution, font=my_font)
                resolutionbox.grid(row=3, column=0,pady=5, padx=5, sticky="nsew")
                lora_label3 = customtkinter.CTkLabel(webui_auto_window, text="Sampling method", font=my_font)
                lora_label3.grid(row=4, column=0,pady=5, padx=5, sticky="nsew")
                current_sampler = customtkinter.StringVar(value="LMS")
                sampler_button = customtkinter.CTkComboBox(webui_auto_window, width=210,values=NAIA_utils.get_sampler_list(self.NAI_webui_address), variable=current_sampler, font=my_font)
                sampler_button.grid(row=5, column=0,pady=5, padx=5, sticky="nsew")
                current_scheduler = None
                try:
                    webui_scheduler_list = NAIA_utils.get_schedulers_list(self.NAI_webui_address)
                    lora_label4 = customtkinter.CTkLabel(webui_auto_window, text="Schedule Type", font=my_font)
                    lora_label4.grid(row=6, column=0,pady=5, padx=5, sticky="nsew")
                    current_scheduler = customtkinter.StringVar(value="SGM Uniform")
                    scheduler_button = customtkinter.CTkComboBox(webui_auto_window, width=210, values=webui_scheduler_list, variable=current_scheduler, font=my_font)
                    scheduler_button.grid(row=7, column=0,pady=5, padx=5, sticky="nsew")
                except: pass
                lora_label5 = customtkinter.CTkLabel(webui_auto_window, text="Sampling Step (3/5/7/9 ..)", font=my_font)
                lora_label5.grid(row=8, column=0,pady=5, padx=5, sticky="nsew")            
                sampling_step = customtkinter.CTkEntry(webui_auto_window, font=my_font, width=35)
                sampling_step.grid(row=9, column=0,pady=5, padx=5, sticky="n")
                lora_label6 = customtkinter.CTkLabel(webui_auto_window, text="CFG Scale (1/1.5/2 ..)", font=my_font)
                lora_label6.grid(row=10, column=0,pady=5, padx=5, sticky="nsew")            
                cfg_scale = customtkinter.CTkEntry(webui_auto_window, font=my_font, width=35)
                cfg_scale.grid(row=11, column=0,pady=5, padx=5, sticky="n")
                webui_current_model = customtkinter.StringVar(value=NAIA_utils.get_current_model(self.NAI_webui_address))
                previous_model = webui_current_model.get()

                def change_model(choice):
                    def change_model_request():
                        current_model_box.configure(state="disabled")
                        try:
                            res = NAIA_utils.change_model(self.NAI_webui_address, choice)
                            current_model_box.configure(state="normal")
                        except:
                            current_model_box.configure(state="normal")
                        if res == True:
                            webui_current_model.set(choice)
                    if choice == previous_model:
                        return
                    else:
                        model_change_thread = threading.Thread(target=change_model_request, daemon=True)
                        model_change_thread.start()

                lora_label7 = customtkinter.CTkLabel(webui_auto_window, text="WEBUI Model", font=my_font)
                lora_label7.grid(row=12, column=0,pady=5, padx=5, sticky="nsew")           
                webui_model_list = NAIA_utils.get_model_list(self.NAI_webui_address)
                current_model_box = customtkinter.CTkComboBox(webui_auto_window, values=webui_model_list, variable=webui_current_model, command=change_model, font=my_font)
                current_model_box.grid(row=13, column=0, pady=5, padx=5, sticky="nsew")
                lora_label8 = customtkinter.CTkLabel(webui_auto_window, text="퀄리티 프롬프트 프리셋", font=my_font)
                lora_label8.grid(row=14, column=0,pady=5, padx=5, sticky="nsew")
                format = customtkinter.StringVar(value="None")
                format_select = customtkinter.CTkComboBox(webui_auto_window, values=["None", "Animagine", "Pony"], variable=format, font=my_font)
                format_select.grid(row=15, column=0, padx=5, sticky="nsew")
                not_fix_seed = customtkinter.CTkCheckBox(webui_auto_window, font=my_font, text="시드 자동 고정 해제")
                not_fix_seed.grid(row=16, column=0,pady=5, padx=5, sticky="nsew")

                if not os.path.exists(ini_file_path):
                    pass
                else:
                    config.read(ini_file_path)
                    current_resolution.set(config['OPTIONS']['current_resolution'])
                    current_sampler.set(config['OPTIONS']['current_sampler'])
                    if config['OPTIONS']['current_scheduler'] is not None:
                        current_scheduler.set(config['OPTIONS']['current_scheduler'])
                    sampling_step.insert(0, config['OPTIONS']['sampling_step'])
                    cfg_scale.insert(0, config['OPTIONS']['cfg_scale'])
                    format_select.set(config['OPTIONS']['format_select'])
                    if int(config['OPTIONS']['not_fix_seed']) == 1:
                        not_fix_seed.select()
                    else: not_fix_seed.deselect()

                def save_and_close():
                    option_list = {
                        'current_resolution': current_resolution.get(),
                        'current_sampler': current_sampler.get(),
                        'current_scheduler': current_scheduler.get() if current_scheduler else None,
                        'sampling_step': sampling_step.get(),
                        'cfg_scale': cfg_scale.get(),
                        'format_select': format_select.get(),
                        'not_fix_seed': not_fix_seed.get()
                    }
                    config['OPTIONS'] = option_list
                    self.ag_config = option_list
                    with open(ini_file_path, 'w') as configfile:
                        config.write(configfile)
                    webui_auto_generation.configure(state="normal")
                    webui_auto_window.destroy()

                close_button = customtkinter.CTkButton(webui_auto_window, font=my_font, text="저장하고 닫기", command=save_and_close)
                close_button.grid(row=17, column=0,pady=5, padx=5, sticky="n")

            webui_generate = customtkinter.CTkButton(right_window, text="Hyper-SD / Lightning WEBUI 자동화 설정", font=my_font, hover_color="grey", state="disabled", command=open_webui_automation)
            webui_generate.grid(row=12, column=0, padx=5, sticky="nsew")
            if app.app_mode == "WEBUI" or self.NAI_webui_address: 
                webui_auto_generation.configure(state="normal")
                webui_generate.configure(state="normal")

            ini_file_path_auto = os.path.join(os.path.join("prototyper"), "prototyper_webui.ini")
            if not os.path.exists(ini_file_path_auto):
                webui_auto_generation.configure(state="disabled")
            else:
                ag_config = configparser.ConfigParser()
                ag_config.read(ini_file_path_auto)
                self.ag_config = {
                    "current_resolution" : ag_config['OPTIONS']['current_resolution'],
                    "current_sampler" : ag_config['OPTIONS']['current_sampler'],
                    "current_scheduler" : ag_config['OPTIONS']['current_scheduler'] if ag_config['OPTIONS']['current_scheduler'] is not None else None,
                    "sampling_step" : ag_config['OPTIONS']['sampling_step'],
                    "cfg_scale" : ag_config['OPTIONS']['cfg_scale'],
                    "format_select" : ag_config['OPTIONS']['format_select'],
                    "not_fix_seed" : 1 if int(ag_config['OPTIONS']['not_fix_seed']) == 1 else 0
                }

            label1 = customtkinter.CTkLabel(right_window, text="선행 프롬프트", font=my_font, height=24)
            label1.grid(row=4, column=0, padx=5, pady=3, sticky="nsew")
            label2 = customtkinter.CTkLabel(right_window, text="프롬프트", font=my_font, height=24)
            label2.grid(row=6, column=0, padx=5, pady=3, sticky="nsew")
            label3 = customtkinter.CTkLabel(right_window, text="후행 프롬프트 / WEBUI LoRA", font=my_font, height=24)
            label3.grid(row=8, column=0, padx=5, pady=3, sticky="nsew")

            ini_file_path = os.path.join(os.path.join("prototyper"), "prototyper.ini")
            config = configparser.ConfigParser()
            if not os.path.exists(ini_file_path):
                # 섹션 및 기본값 설정
                config['PROMPTS'] = {
                    'preprompt': ' ',
                    'postprompt': ' ',
                    'mainprompt': ' ',
                    'brackets': '5'
                }
                pr = ''
                ar = ''
                mp = ''
                br = '5'
                # 설정 파일 쓰기
                with open(ini_file_path, 'w') as configfile:
                    config.write(configfile)
            else:
                config.read(ini_file_path)
                pr = config['PROMPTS']['preprompt']
                ar = config['PROMPTS']['postprompt']
                mp = config['PROMPTS']['mainprompt']
                br = config['PROMPTS']['brackets']

            def hide_main_ui():
                if hide_ui.get() == 0:
                    right_window.grid_forget()
                    left_window.grid(row=0, column=0 ,padx=5, pady=5, sticky="nsew")
                    center_window.grid(row=0, column=1 ,padx=5, pady=5, sticky="nsew")
                    right_window.grid(row=0, column=2 ,padx=5, pady=5, sticky="nsew")
                else:
                    left_window.grid_forget()
                    center_window.grid_forget()
                    right_window.grid_forget()
                    right_window.grid(row=0, column=0 ,padx=5, pady=5, sticky="nsew")

            preprompt = customtkinter.CTkTextbox(right_window, font=my_font, width=284, height=50)
            preprompt.grid(row=5, column=0, padx=5, pady=2, sticky="nsew")
            preprompt.insert("0.0", pr)
            mainprompt = customtkinter.CTkTextbox(right_window, font=my_font, width=284, height=90)
            mainprompt.grid(row=7, column=0, padx=5, pady=2, sticky="nsew")
            mainprompt.insert("0.0", mp)
            postprompt = customtkinter.CTkTextbox(right_window, font=my_font, width=284, height=45)
            postprompt.grid(row=9, column=0, padx=5, pady=2, sticky="nsew")
            postprompt.insert("0.0", ar)
            check_ctrl = customtkinter.CTkCheckBox(right_window, font=my_font,text="ctrl + 클릭을 WEBUI에서 처리")
            #check_ctrl.grid(row=10, column=0 ,padx=5, pady=7, sticky="n")
            hide_image = customtkinter.CTkCheckBox(right_window, font=my_font,text="도감 이미지 숨기기")
            hide_image.grid(row=11, column=0 ,padx=5, pady=7, sticky="n")
            bracket_frame = customtkinter.CTkFrame(right_window, fg_color="#2B2B2B")
            bracket_frame.grid(row=11, column=0 ,padx=5, pady=5, sticky="nsew")
            bracket_num_label =  customtkinter.CTkLabel(bracket_frame, text="                   ctrl + click시 브래킷 수 : ", font=my_font)
            bracket_num_label.grid(row=0, column=0, sticky="nsew")
            bracket_num = customtkinter.CTkEntry(bracket_frame, font=my_font, width=28)
            bracket_num.grid(row=0, column=1 ,padx=2, sticky="nsew")
            bracket_num.insert(0, br)
            hide_ui = customtkinter.CTkCheckBox(bracket_frame, font=my_font,text="태그메뉴 UI 숨기기", command=hide_main_ui)
            hide_ui.grid(row=0, columnspan=2, column=2 ,padx=2, sticky="e")

            def lfpi(): self.proto_last_mainprompt = [key for key in mainprompt.get("0.0", "end-1c").split(',')]

            tag_window.after(3000, lambda: lfpi())

            self.popup_proto = tk.Toplevel(self)
            self.popup_proto.withdraw()  # 팝업을 숨김
            self.popup_proto.overrideredirect(True)
            self.listbox_proto = tk.Listbox(self.popup_proto, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey', width=50, height=11)
            self.listbox_proto.pack()

            def popup_focus_out(event=None):
                self.popup_proto.withdraw()

            self.popup_proto.bind("<FocusOut>", popup_focus_out)
            self.proto_target_index = None

            def hard_insertion(event=None):
                try:
                    selected_indices = self.listbox_proto.curselection()
                    keyword = self.listbox_proto.get(selected_indices[0])
                    index = keyword.rfind("  ")
                    keyword = keyword[index + 2:]
                    self.popup_proto.withdraw()
                    self.proto_last_mainprompt[self.proto_target_index] = keyword
                    self.proto_last_mainprompt = [key.strip() for key in self.proto_last_mainprompt]
                    mainprompt.delete("0.0", "end")
                    mainprompt.insert("0.0", ', '.join(self.proto_last_mainprompt))
                    self.proto_target_index = None
                except: pass
            self.listbox_proto.bind('<<ListboxSelect>>',  hard_insertion)

            def key_yield(event):
                try: self.listbox_proto.delete(0, tk.END)
                except: pass
                current_prompt = [key for key in mainprompt.get("0.0", "end-1c").split(',')]
                changed_elements = []
                changed_indices = []
                for index, (old, new) in enumerate(zip(self.proto_last_mainprompt, current_prompt)):
                    if old != new: 
                        changed_elements.append(new)
                        changed_indices.append(index)
                if changed_elements and changed_elements[-1].strip() != '':
                    target_element = changed_elements[-1]
                    if target_element in current_prompt and target_element.strip() in self.proto_last_mainprompt:
                        self.proto_last_mainprompt = [key for key in current_prompt]
                        return
                    target_index = changed_indices[-1]
                    self.proto_target_index = target_index
                    _list = NAIA_utils.find_top_matches(target_element.strip())
                    if _list:
                        for k, v in _list:
                            k_formatted = k
                            v_formatted = f"{v:>9}".replace(' ', '  ')
                            formatted_line = f"{v_formatted}  {k_formatted}"
                            self.listbox_proto.insert(tk.END, f"{formatted_line}")
                        bbox = mainprompt.dlineinfo("insert")
                        if bbox:
                            x, y, width, height, baseline = bbox
                            abs_x = mainprompt.winfo_rootx() + x
                            abs_y = mainprompt.winfo_rooty() + y + height*2  # 커서 바로 아래에 팝업
                            self.popup_proto.geometry(f"+{abs_x}+{abs_y}")
                            self.popup_proto.deiconify()  # 팝업 표시
                    else:
                        self.popup_proto.withdraw()
                else:
                    self.popup_proto.withdraw()
                self.proto_last_mainprompt = []
                self.proto_last_mainprompt[:] = current_prompt
            mainprompt.bind('<KeyRelease>', key_yield)
            mainprompt.bind("<FocusOut>", popup_focus_out)

            show_window = []
            def check_prompt_in_tags(prompt, tags):
                for category in tags["인원"]:
                    if prompt in tags["인원"][category]:
                        return True
                return False
            
            def open_image_window(sub, key):
                # 새 창 생성
                top = tk.Toplevel()
                top.geometry("768x768")  # 창 크기 설정
                top.title("미리보기 창 (창 밖을 누르면 자동으로 닫힙니다)")

                # 이미지 불러오기 및 표시
                try:
                    file_path = os.path.join("prototyper", sub, f"{key}.jpg")
                    reloaded_image = Image.open(file_path)
                except:
                    top.destroy()
                photo = ImageTk.PhotoImage(reloaded_image)
                label = tk.Label(top, image=photo)
                label.image = photo  # 참조 유지
                label.pack()

                # 창에 포커스 주기
                top.focus_set()

                # 포커스가 창을 벗어나면 창 닫기
                top.bind("<FocusOut>", lambda e: top.destroy())
            
            def instant_image_generation_proto(sub, prompt_text, image_label_inst):
                if app.running_flag: 
                    return
                image_label_inst.configure(text="생성중 ...", text_color="black", image=customtkinter.CTkImage(white_image, size=(218,218)))
                pr = preprompt.get("0.0","end").strip()
                ar = postprompt.get("0.0","end").strip()
                mp = mainprompt.get("0.0","end").strip()
                try:
                    brackets = bracket_num.get()
                    br = int(brackets)
                except:
                    br = 5
                if app.app_mode == "NAI": 
                    request_prompt = pr+", "+'{'*br+prompt_text+'}'*br+", "+mp+", "+ar
                else: 
                    request_prompt = pr+", "+'('*br+prompt_text+')'*br+", "+mp+", "+ar
                if app.running_flag == False and app.automation_button.get() == 0:
                    app.running_flag = True
                    scale_pre = self.cfg_scale_entry.get()
                    try:
                        scale_pre = float(scale_pre)
                    except:
                        scale_pre = 5.0
                        app.cfg_scale_var.set("5.0")
                    rescale_pre = app.prompt_guidance_rescale_entry.get()
                    try:
                        rescale_pre = float(rescale_pre)
                    except:
                        rescale_pre = 0
                        app.prompt_guidance_rescale_var.set("0")
                    uncond_pre = app.uncond_strength_entry.get()
                    try:
                        uncond_pre = float(uncond_pre)
                        #uncond_pre = round(uncond_pre / 0.05) * 0.05
                        if (uncond_pre > 162):
                            uncond_pre = 19.19
                            app.uncond_strength_entry.delete(0, "end")
                            app.uncond_strength_entry.insert(0, "1.5")
                    except:
                        uncond_pre = 1.0
                        app.uncond_strength_entry.delete(0, "end")
                        app.uncond_strength_entry.insert(0, "1.0")
                    if ' + ' in app.sampler_button.get():
                        _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
                    else:
                        _sampler = app.sampler_button.get()
                        _noise_schedule = "native"
                    file_path = os.path.join(os.path.join("prototyper"), "prototyper.ini")
                    config = configparser.ConfigParser()
                    config['PROMPTS'] = {
                        'preprompt': pr,
                        'postprompt': ar,
                        'mainprompt': mp,
                        'brackets': br
                    }
                    with open(file_path, 'w') as configfile:
                        config.write(configfile)
                    NAI_width, NAI_height = self.resolution_button.get().split('x')
                    if int(NAI_width) * int(NAI_height) > 1048576:
                        NAI_width = 1024
                        NAI_height = 1024
                    gen_request = {
                            "width":NAI_width,
                            "height":NAI_height,
                            "quality_toggle":app.auto_quality_toggle.get(),
                            "seed":random.randint(0,2**32 - 1) if not app.seed_fix_var.get() == 1 else int(app.seed_entry.get()),
                            "sampler":_sampler,
                            "noise_schedule": _noise_schedule,
                            "scale":scale_pre,
                            "sema":app.sema_button.get(),
                            "sema_dyn": app.dyn_button.get(),
                            "cfg_rescale": rescale_pre,
                            "uncond_scale":uncond_pre,
                            "prompt": request_prompt,
                            "negative":app.negative_prompt_input.get("0.0", "end-1c"),
                            "user_screen_size": app.get_max_size(),
                            "start_time": app.start_time,
                            "access_token": app.access_token,
                            "save_folder": app.output_file_path,
                            "png_rule": app.name_var.get(),
                            "type": "normal",
                            "enable_hr" : False,
                            "enable_AD" : False
                        }
                    if app.app_mode == "NAI" and app.variety_button.get() == 1:
                        gen_request["skip_cfg_above_sigma"] = True
                    if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                        gen_request["dynamic_thresholding"] = True
                    if app.app_mode == "WEBUI" and app.sema_button_var.get() == 1:
                        try:
                            hr_steps_pre = int(app.hires_steps_entry.get())
                        except:
                            hr_steps_pre = 16
                            app.hires_steps_entry.delete(0, "end")
                            app.hires_steps_entry.insert(0, '16')
                        try:
                            upscale_pre = float(app.upscale_entry.get())
                            upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                        except:
                            upscale_pre = 1.5
                        app.upscale_entry.delete(0, "end")
                        app.upscale_entry.insert(0, str(upscale_pre))
                        try:
                            denoise_pre = float(app.denoise_entry.get())
                        except:
                            denoise_pre = 0.35
                            app.denoise_entry.delete(0, "end")
                            app.denoise_entry.insert(0, '0.35')
                        gen_request["enable_hr"] = True
                        gen_request["hr_second_pass_steps"] = hr_steps_pre
                        gen_request["hr_upscaler"] = app.hires_sampler_entry.get()
                        gen_request["hr_scale"] = upscale_pre
                        gen_request["denoising_strength"] = denoise_pre
                    if app.app_mode == "WEBUI" and app.enable_cfg_rescale.get() == 1:
                        gen_request["CFG_rescale"] = True
                        cfg_str_pre = app.enable_cfg_rescale_strength.get()
                        try:
                            cfg_str_pre = float(cfg_str_pre)
                            cfg_str_pre = round(cfg_str_pre, 2)
                        except:
                            cfg_str_pre = 0.5
                            app.enable_cfg_rescale_strength.delete(0, "end")
                            app.enable_cfg_rescale_strength.insert(0, "0.5")
                        gen_request["CFG_rescale_str"] =  cfg_str_pre
                        gen_request["CFG_rescale_version"] = "normal" if app.enable_cfg_rescale_old.get() == 0 else "old"
                    if app.app_mode == "WEBUI" and app.custom_script_activate_var.get() == 1: gen_request['custom_script'] = app.custom_script_text.get("1.0", "end-1c").strip()
                    if app.app_mode == "WEBUI" and app.enable_DT.get() == 1:
                        gen_request["DynamicThresholding"] = True
                    if app.awai_activate_i2i.get() == 1:
                        gen_request["enable_AD"] = True
                        ad_str_pre = app.autodetailer_strength.get()
                        try:
                            ad_str_pre = float(ad_str_pre)
                            ad_str_pre = round(ad_str_pre, 2)
                        except:
                            ad_str_pre = 0.4
                            app.autodetailer_strength.delete(0, "end")
                            app.autodetailer_strength.insert(0, "0.4")
                        gen_request["ad_data_str"] =  ad_str_pre
                    def run_generation():
                            if gen_request["png_rule"] == "count":
                                app.generation_count += 1
                                gen_request["count"] =app.generation_count
                            app.state_label.configure(text ="state : 프로토타이퍼 이미지 요청됨 ", text_color = "#FFFF97")
                            if app.save_folder_option and app.save_folder_option["isEnabled"]:
                                if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                                    app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                                elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                                else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                                if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                                    app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                                elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                                else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                                try:
                                    gen_request["additional_save_folder"] = { 
                                        "command1": app.save_folder_additional_name["command1"],
                                        "command2": app.save_folder_additional_name["command2"]
                                        }
                                except:
                                    gen_request["additional_save_folder"] = { 
                                        "command1": "",
                                        "command2": ""
                                        }                     
                                app.save_folder_additional_name = {}
                            if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                                gen_request['characters'] = app.nai4_character_list
                                gen_request['characters_uc'] = app.nai4_character_uc_list
                                gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                                gen_request['characters_pos_list'] = app.naid4_positions
                                gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.char, "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                                if app.eye_catch.get() == 1: gen_request["eye_catch"] = True
                            if type(self.generated_popped_row) != type(None) and not self.generated_popped_row.empty: self.generated_popped_row_freezed = self.generated_popped_row.copy()
                            else: self.generated_popped_row_freezed = None
                            result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                            self.nai_generation_count += 1
                            self.control_pressed = False
                            app.running_flag = False
                            app.state_label.configure(text =f"프로토타이퍼 이미지 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                            if info:
                                temp = naia_functions.extract_prompt_info(info, app.app_mode)
                                if app.app_mode == "NAI": temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                            else:
                                temp = result_prompt
                            naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                            if result_image:
                                folder_path = os.path.join("prototyper", sub)
                                file_path = os.path.join(folder_path, prompt_text + ".jpg")
                                if not os.path.exists(folder_path):
                                    os.makedirs(folder_path)
                                # 텍스트 추가
                                font = ImageFont.truetype("arial", 15)  # 폰트 파일 경로 확인 필요
                                font2 = ImageFont.truetype("arial", 15)
                                # textbbox 사용하여 텍스트 바운딩 박스 계산
                                text_x = 384
                                text_y = 710
                                text_y2 = 740
                                draw_image = result_image.copy()
                                draw = ImageDraw.Draw(draw_image)
                                bbox = draw.textbbox((text_x, text_y), pr+", "+'{'*br+prompt_text+'}'*br, font=font, anchor="mm")
                                bbox2 = draw.textbbox((text_x, text_y2), mp, font=font2, anchor="mm")
                                text_width = bbox[2] - bbox[0]
                                text_height = bbox[3] - bbox[1]
                                text_width2 = bbox2[2] - bbox2[0]
                                text_height2 = bbox2[3] - bbox2[1]
                                draw.rectangle([text_x - text_width // 2 - 10, text_y - text_height // 2 - 10, text_x + text_width // 2 + 10, text_y + text_height // 2 + 10], fill="white")
                                if len(mp) >= 2: draw.rectangle([text_x - text_width2 // 2 - 10, text_y2 - text_height2 // 2 - 10, text_x + text_width2 // 2 + 10, text_y2 + text_height2 // 2 + 10], fill="white")
                                draw.text((text_x, text_y), pr+", "+'{'*br+prompt_text+'}'*br, fill="black", font=font, anchor="mm")
                                if len(mp) >= 2: draw.text((text_x, text_y2), mp, fill="black", font=font2, anchor="mm")
                                draw_image.save(file_path, "JPEG", quality=90)
                                image_label_inst.configure(text="", image=customtkinter.CTkImage(draw_image, size=(218,218)))
                                image_label.configure(image=customtkinter.CTkImage(result_image, size=(512,512)))
                                if app.state() != 'zoomed':
                                    instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                                else:
                                    current_image = Image.open(filename)
                                    new_image = app.resize_and_center_image(current_image, app.wide_res_width, app.wide_res_height)
                                    instant_result_image = customtkinter.CTkImage(new_image, size=(app.wide_res_width, app.wide_res_height))
                                app.image_label.configure(image=instant_result_image)
                                app.ext_set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                    generation_thread = threading.Thread(target=run_generation, daemon=True)
                    generation_thread.start()
            
            def add_prompt(sub, prompt, image_label_inst):
                if self.control_pressed:
                    self.control_pressed = False
                    instant_image_generation_proto(sub, prompt, image_label_inst)
                elif self.alt_pressed:
                    self.alt_pressed = False
                    open_image_window(sub, prompt)
                else:
                    pyperclip.copy(prompt)
                    if check_prompt_in_tags(prompt, tags):
                        xtext = preprompt.get("0.0", "end")
                        xtext = [key.strip() for key in xtext.split(',')]
                        if prompt not in xtext:
                            if prompt in tags["인원"]["여성"]:
                                xtext = [item for item in xtext if item not in tags["인원"]["여성"]]
                            elif prompt in tags["인원"]["남자"]:
                                xtext = [item for item in xtext if item not in tags["인원"]["남자"]]
                            elif prompt in tags["인원"]["인외"]:
                                xtext = [item for item in xtext if item not in tags["인원"]["인외"]]
                            xtext.insert(0, prompt)
                        else:
                            xtext.remove(prompt)
                        if '' in xtext:
                            xtext.remove('')
                        preprompt.delete("0.0", "end")
                        preprompt.insert("0.0", ", ".join(xtext))
                    else:
                        xtext = mainprompt.get("0.0", "end")
                        xtext = [key.strip() for key in xtext.split(',')]
                        atext = []
                        for key in xtext:
                            if key in self.proto_current_tags:
                                atext.append(key)
                        if prompt in xtext:
                            xtext.remove(prompt)
                        elif atext:
                            for key in atext: xtext.remove(key)
                            xtext.append(prompt)
                        elif prompt not in xtext:
                            xtext.append(prompt)
                        else:
                            xtext.remove(prompt)
                        if '' in xtext:
                            xtext.remove('')
                        mainprompt.delete("0.0", "end")
                        mainprompt.insert("0.0", ", ".join(xtext))

            def button_callback(sub, text):
                center_window._parent_canvas.yview_moveto(0)
                subdict = tags[sub][text]
                self.proto_current_tags = list(subdict.keys())
                if show_window:
                    for _i in show_window:
                        try: _i.destroy()
                        except: pass
                folder_path = os.path.join("prototyper", sub)
                if not os.path.exists(folder_path):
                    os.makedirs(folder_path)
                count = 0
                for (key, value) in subdict.items():
                    file_path = os.path.join("prototyper", sub, f"{key}.jpg")
                    if hide_image.get() != 1:
                        _row = count//3
                        _column = count%3
                        if os.path.exists(file_path):
                            reloaded_image = Image.open(file_path)
                        else:
                            reloaded_image = white_image
                        f = customtkinter.CTkFrame(center_window, width = 230, height=300)
                        f.grid(row=_row, column=_column, padx=5, pady=5, sticky="nsew")
                        name = key
                        if len(key) > 45:
                            name = key[:44]
                        i = customtkinter.CTkLabel(f, text="", font=v_large_font, image=customtkinter.CTkImage(reloaded_image, size=(218,218)))
                        i.grid(row=2, column=0, padx=5, pady=5, sticky="nsew")
                    else:
                        reloaded_image = white_image
                        _row = count//4
                        _column = count%4
                        f = customtkinter.CTkFrame(center_window, width = 230, height=82)
                        f.grid(row=_row, column=_column, padx=5, pady=5, sticky="nsew")        
                        name = key
                        if len(key) > 45:
                            name = key[:44]     
                    b = customtkinter.CTkButton(f, font=my_font,text=name if len(name) < 35 else name[:34], state="disabled" if len(key) > 45 else "normal", fg_color="grey10", hover_color="grey10", text_color_disabled="white", command=lambda sub=sub, name=name, i=i: add_prompt(sub, name, i))
                    b.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                    l = customtkinter.CTkLabel(f, text=value, font=my_font)
                    l.grid(row=1, column=0, padx=5, pady=2, sticky="nsew")
                    show_window.append(f)
                    count += 1
                if hide_image.get() != 1: f_row = 1 + count//3
                else: f_row = 1 + count//4
                dlabel = customtkinter.CTkLabel(center_window, font=my_font,text="버튼 클릭으로 프롬프트를 삽입/복사하고, ctrl + 클릭으로 즉시 생성합니다. (우측 선/후행 프롬프트를 참조)", text_color="#FFFF97")
                dlabel.grid(row=f_row, column=0, columnspan=3 if hide_image.get() != 1 else 4, padx=5, pady=5, sticky="n")
                dlabel2 = customtkinter.CTkLabel(center_window, font=my_font,text="생성된 이미지가 존재하는 경우 alt + 클릭을 하면 확대가 가능합니다. *대부분의 프롬프트가 nsfw 태그를 요구함*", text_color="#FFFF97")
                dlabel2.grid(row=1+f_row, column=0, columnspan=3 if hide_image.get() != 1 else 4, padx=5, sticky="n")
                show_window.append(dlabel)
                show_window.append(dlabel2)
            frame_list = []
            for i, sub in enumerate(master_list):
                frame = customtkinter.CTkFrame(left_window)
                frame.grid(row=1+i, column=0, columnspan=4, padx=5, pady=5, sticky="nsew")
                flabel = customtkinter.CTkButton(frame, fg_color="#ED7D31", hover_color="#CC5D12", state="disabled", text=sub, text_color_disabled="white", font=v_large_font)
                flabel.grid(row=0, column=0, columnspan=4, padx=5, pady=5, sticky="nsew")
                fkey = list(tags[sub].keys())
                fa = flabel.cget("text")
                for num in range(len(fkey)):
                    ix = num%4
                    iy = 1 + num//4
                    fb = fkey[num]
                    button = customtkinter.CTkButton(frame, text=fkey[num], font=my_font, fg_color="grey10", hover_color="grey", width=90, height=20, command=lambda fa=fa, fb=fb: button_callback(fa, fb))
                    button.grid(row=iy, column=ix, padx=5, pady=2, sticky="nsew")
                if sub == "인원" or sub == "행위/노출":
                    _tlb = customtkinter.CTkLabel(frame, text="", width=90, height=20)
                    _tlb.grid(row=1, column=3, padx=5, pady=2, sticky="nsew")                    
                frame_list.append(frame)
            button_callback("인원", "여성")

            tag_window.after(3500, lambda: tag_window.attributes('-topmost', False))

        self.tags_viewer = customtkinter.CTkButton(self.image_label_under_frame, text="프로토타이퍼", text_color="#FFFF97", font=my_font, fg_color="transparent", width=60, command=open_tag_viewer)
        self.tags_viewer.grid(row=0, column=9,padx=5, pady=5, sticky="nsew")

        def delete_mode():
            if self.delete_activate.get() == 1:
                self.focus_set()
                self.image_label_report.configure(state="normal")
                self.delete_activate.configure(text_color="yellow")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> 1) 해당 모드를 사용하는 동안 이미지 생성을 잠시 중단하는 것을 권장합니다. 삭제 버튼을 누르는 순간 이미지가 반환되면 새로 생성한 이미지가 삭제됩니다.  2) 키보드의 Del 버튼을 누르면 이미지가 삭제됩니다. 삭제된 이미지는 휴지통에서 복원할 수 있습니다.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")
            else:
                self.delete_activate.configure(text_color="#DCE4EE")
                self.image_label_report.configure(text_color="#DCE4EE")

        self.delete_activate = customtkinter.CTkCheckBox(self.image_label_under_frame, text="삭제모드", font=my_font, width=50, command=delete_mode)
        self.delete_activate.grid(row=0, column=10,padx=5, pady=5, sticky="nsew")     
        white_image = Image.new('RGB', (768, 768), 'white')

        white_photo = customtkinter.CTkImage(white_image, size=(620,620))
        self.image_label.configure(image=white_photo)
        self.image_label.image = white_photo

        self.image_queue = []
        self.window = 0

        #image history 버튼
        self.image_history_sub_frame = customtkinter.CTkFrame(self.image_history_frame, width=100, height=550)
        self.image_history_sub_frame.grid(row=1, rowspan=12, column=1, sticky="n")

        self.output_file_path = f"output_NAI\\{self.start_time}"
        self.import_image_count = 0

        def open_file_explorer(self):
            if not os.path.exists(self.output_file_path):
                os.makedirs(self.output_file_path)
            os.startfile(self.output_file_path)

        def open_in_file_explorer(self):
            if self.control_pressed:
                self.control_pressed = False
                upscale_image()
            else:
                filename = self.image_queue[self.current_window][3]
                abs_path = os.path.abspath(filename)
                if self.is_mac:
                    subprocess.run(['open', '-R', abs_path])
                else:
                    explorer_command = f'explorer /select,"{abs_path}"'
                    subprocess.run(explorer_command)

        def move_to_trash(filename):
            abs_file = os.path.abspath(filename)
            send2trash(abs_file)


        def up_button_pressed():
            if not self.control_pressed and self.what_i_clicked != 0:
                if self.what_i_clicked == 1: image_history_0_yield()
                elif self.what_i_clicked == 2: image_history_1_yield()
                elif self.what_i_clicked == 3: image_history_2_yield()
                elif self.what_i_clicked == 4: image_history_3_yield()
                return
            if self.what_i_clicked == 0 and self.current_window == self.window:
                return
            if self.image_history_button_down.cget("state") == "disabled":
                self.image_history_button_down.configure(state="normal")
            if self.control_pressed:
                self.window = len(self.image_queue)
            else:
                self.window+=1
            update()
            show_text = str(self.window)+" / "+ str(len(self.image_queue))
            self.window_label.configure(text=show_text)
            if self.window >= len(self.image_queue):
                self.image_history_button_up.configure(state="disabled")
            self.control_pressed = False
            image_history_0_yield()

        def down_button_pressed():
            if not self.control_pressed and self.what_i_clicked != 4:
                if self.what_i_clicked == 0: image_history_1_yield()
                elif self.what_i_clicked == 1: image_history_2_yield()
                elif self.what_i_clicked == 2: image_history_3_yield()
                elif self.what_i_clicked == 3: image_history_4_yield()
                return
            if self.image_history_button_up.cget("state") == "disabled":
                self.image_history_button_up.configure(state="normal")
            if self.control_pressed:
                if self.window >= 105:
                    self.window -= 100
                else:
                    self.window = 5
            else:
                self.window-=1
            update()
            show_text = str(self.window)+" / "+ str(len(self.image_queue))
            self.window_label.configure(text=show_text)
            if self.window <= 5:
                self.image_history_button_down.configure(state="disabled")
            self.control_pressed = False
            image_history_4_yield()

        def on_scroll_up(): up_button_pressed()

        def on_scroll_down():down_button_pressed()

        highlight_tags = ["aqua","black","blonde","blue","brown","cyan","green","grey","orange","pink","purple","red","violet","white","yellow","mouth", "eyes", " cap", " ears", " girl", " ornament"," hat", "beret", " ear "]

        def insert_with_color(cs_text_input, current_lookup, mode="normal"):
                words = [word.strip() for word in current_lookup.split(',')]
                for index, word in enumerate(words):
                    highlight = False
                    start_index = cs_text_input.index("end-1c")
                    if index == len(words) - 1:  # 마지막 원소인 경우
                        cs_text_input.insert("end", word)
                    else:
                        cs_text_input.insert("end", word + ", ")
                    end_index = cs_text_input.index("end-1c")

                    for tag in highlight_tags:
                        if tag in word:
                            highlight = True
                    if word == "hat": highlight = True
                    # 조건 확인
                    if (mode == "normal") and (word in cd.character_dictionary or word in tagbag.bag_of_tags[5:] or 'tail' in word or 'pupil' in word):
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#FFFF97")
                    elif mode == "nsfw" and word in self.nsfw_blacklist:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#474747")
                    elif mode == "nsfw_valid" and word in self.nsfw_whitelist:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#FFFF97")
                    elif mode == "normal" and highlight:
                        cs_text_input.tag_add(word, start_index, end_index)
                        cs_text_input.tag_config(word, foreground="#AED395")

        self.current_window = None
        self.series_generation = []
        self.filename_wildcard_dict = {}

        def set_image_to_queue(imagen, prompt, seed, filename, addict = None):
            recent_counts_limit = False
            unique_hours_limit = False
            usage_count_file_path = os.path.join('.', 'api_usage_count.json')

            if self.app_mode == "NAI" and os.path.exists(usage_count_file_path):
                try:
                    with open(usage_count_file_path, 'r', encoding='utf-8') as f:
                        data = json.load(f)
                    
                    twenty_four_hours_ago = datetime.now() - timedelta(hours=24)
                    
                    # 10분 단위의 고유 시간(버킷) 계산: 로그의 timestamp는 이미 "%Y-%m-%d %H:%M" 포맷임
                    unique_intervals = len(set(
                        log["timestamp"]
                        for log in data["usage_logs"]
                        if datetime.strptime(log["timestamp"], "%Y-%m-%d %H:%M") > twenty_four_hours_ago
                    ))
                    recent_counts = sum(
                        log["count"] for log in data["usage_logs"]
                        if datetime.strptime(log["timestamp"], "%Y-%m-%d %H:%M") > twenty_four_hours_ago
                    )
                    data["usage_logs"] = [
                        log for log in data["usage_logs"]
                        if datetime.strptime(log["timestamp"], "%Y-%m-%d %H:%M") > twenty_four_hours_ago
                    ]
                    with open(usage_count_file_path, 'w', encoding='utf-8') as f:
                        json.dump(data, f, indent=2)

                    recent_counts_var = int(recent_counts / 42) if not self.access_token_muiti else int(recent_counts / 84)
                    total_intervals = 100
                    usage_times = unique_intervals * 10
                    usage_time_percent = int((unique_intervals / total_intervals) * 100)
                    if self.access_token_muiti:
                        self.title(self.main_title + f" ( NAI 일일 사용량 {recent_counts_var}% : {recent_counts} / 8400 , 사용 시간 {usage_time_percent}% : {usage_times} / 1000분 )")
                    else:
                        self.title(self.main_title + f" ( NAI 일일 사용량 {recent_counts_var}% : {recent_counts} / 4200 , 사용 시간 {usage_time_percent}% : {usage_times} / 1000분 )")
                    
                    if self.nai_api_limit_off.get() == 0:
                        if recent_counts >= 4200 and self.automation_button.get() == 1:
                            if not self.access_token_muiti or recent_counts >= 8400:
                                recent_counts_limit = True
                                self.automation_button.deselect()
                        elif unique_intervals >= 100 and not self.access_token_muiti and self.automation_button.get() == 1:
                            unique_hours_limit = True
                            self.automation_button.deselect()
                            self.image_label_report.configure(state="normal")
                except:
                    pass

            if type(self.generated_popped_row_freezed) != type(None) and not self.generated_popped_row_freezed.empty:
                if not addict and (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and app.nai4_character_list: 
                    try:
                        image_origin = os.path.abspath(filename)
                        img = Image.open(image_origin)
                        exif = img.getexif()
                        comment = img.info.get('Comment')
                        if comment:
                            temp_c_list =[]
                            temp_uc_list = []
                            for i, k in enumerate(app.nai4_character_list):
                                kx = [_k.strip() for _k in k.split(",")]
                                if len(kx) >= 2:
                                    check_var = kx[1] if kx[0].lower() in ['girl', 'boy'] else kx[0]
                                else:
                                    check_var = kx[0]
                                if check_var.lower() in comment.lower():
                                    temp_c_list.append(app.nai4_character_list[i])
                                    temp_uc_list.append(app.nai4_character_uc_list[i])
                        if temp_c_list:
                            _text = ""
                            self.naid4_selected_character_textbox.configure(state="normal")
                            self.naid4_selected_character_textbox.delete("0.0", "end")
                            for i in range(len(temp_c_list)):
                                _text += temp_c_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                            self.naid4_selected_character_textbox.insert("0.0", _text)
                            self.naid4_selected_character_textbox.configure(state="disabled")
                        self.generated_popped_row_freezed['characters'] = temp_c_list.copy() if temp_c_list else [""]
                        self.generated_popped_row_freezed['characters_uc'] = temp_uc_list.copy() if temp_uc_list else [""]
                    except:
                        self.generated_popped_row_freezed['characters'] = app.nai4_character_list.copy()
                        self.generated_popped_row_freezed['characters_uc'] = app.nai4_character_uc_list.copy()         
                elif addict and "from" in addict and addict["from"] == "i2i":
                    if "nai4_character_list" in addict:
                        try:
                            image_origin = os.path.abspath(filename)
                            img = Image.open(image_origin)
                            exif = img.getexif()
                            comment = img.info.get('Comment')
                            if comment:
                                temp_c_list =[]
                                temp_uc_list = []
                                for i, k in enumerate(addict["nai4_character_list"]):
                                    kx = [_k.strip() for _k in k.split(",")]
                                    if len(kx) >= 2:
                                        check_var = kx[1] if kx[0].lower() in ['girl', 'boy'] else kx[0]
                                    else:
                                        check_var = kx[0]
                                    if check_var.lower() in comment.lower():
                                        temp_c_list.append(addict["nai4_character_list"][i])
                                        temp_uc_list.append(addict["nai4_character_uc_list"][i])
                            if temp_c_list:
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(temp_c_list)):
                                    _text += temp_c_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                            self.generated_popped_row_freezed['characters'] = temp_c_list.copy() if temp_c_list else [""]
                            self.generated_popped_row_freezed['characters_uc'] = temp_uc_list.copy() if temp_uc_list else [""]
                        except: 
                            self.generated_popped_row_freezed['characters'] = addict["nai4_character_list"]
                            self.generated_popped_row_freezed['characters_uc'] = addict["nai4_character_uc_list"]
                _item = [imagen, prompt, seed, filename,copy.deepcopy(self.generated_popped_row_freezed), self.previous_fix_prompt]
                self.image_queue.append(_item)
                if "xargs" in self.current_popped_row:
                    self.series_generation.append(_item)
            else:
                self.image_queue.append([imagen, prompt, seed, filename])
            self.current_window = self.window
            if self.app_mode == "WEBUI":
                if self.auto_nai_setting is not None:
                    if self.auto_nai_setting[0][0] in prompt:
                        if self.autonai.get() == 1 and "webui_nai_i2i" not in filename:
                            instant_img2img(self, self.nai_access_token, self.auto_nai_setting, False, "autonai")
                        else:
                            self.nai_i2i_button.configure(state="normal")
                    else:
                        self.nai_i2i_button.configure(state="disabled")
                else:
                    self.nai_i2i_button.configure(state="disabled")
            if self.app_mode == "NAI" and self.NAI_webui_address and (self.awai_activate_i2i.get() == 1):
                check_img = Image.open(filename)
                if check_img.info.get('Comment', ''):
                    instant_img2img(self, self.NAI_webui_address, None, False, "adetailer")
            self.request_upper_size_button.configure(state="normal")
            if self.window == len(self.image_queue)-1:
                self.window+=1
                update()
            self.filename_wildcard_dict[filename] = self.wildcard_current_dict.copy()
            show_text = str(self.window)+" / "+ str(len(self.image_queue))
            self.generated_popped_row = None
            self.window_label.configure(text=show_text)
            if recent_counts_limit:
                self.image_label_report.configure(state="normal")
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> NAIA에서 설정된 일일 생성 한도에 도달하였습니다. 이 조건을 무시하려면 기타설정에서 NAI 사용량 제한을 해제하세요.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")
            elif unique_hours_limit:
                self.image_label_report.delete("0.0", "end")
                self.image_label_report.insert("0.0", "<UserAttention> NAIA에서 설정된 일일 연속 생성 시간 제한(18시간)에 도달하였습니다. 이 조건을 무시하려면 기타설정에서 NAI 사용량 제한을 해제하세요.")
                self.image_label_report.configure(text_color="#FFFF97")
                self.image_label_report.configure(state="disabled")

        self.what_i_clicked = None
        def image_history_0_yield(event=None):
            if len(self.image_queue) < 1:
                return
            if self.control_pressed:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.text_input.delete("0.0", "end")
                    if len(self.image_queue[self.window-1]) > 4 and "characters" in self.image_queue[self.window-1][4]:
                        image = Image.open(self.image_queue[self.window-1][3])
                        result = image.info.get('Comment', '')
                        result = json.loads(result)
                        insert_with_color(self.text_input, result['prompt'])
                        if 'v4_prompt' in result:
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                                app.nai4_character_list = []
                                app.nai4_character_uc_list = []
                                for k in result["v4_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_list.append(k["char_caption"])
                                for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_uc_list.append(k["char_caption"])
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(app.nai4_character_list)):
                                    _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                    else:
                        insert_with_color(self.text_input, self.image_queue[self.window-1][1])
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 프롬프트 고정 상태에서는 사용 할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            else:
                self.current_window = self.window-1
                self.what_i_clicked = 0
                if app.state() != 'zoomed':
                    self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(620,620)))
                else:
                    current_image = Image.open(self.image_queue[self.window-1][3])
                    new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                if len(self.image_queue) > 1:
                    naia_functions.process_text_with_links(self, app.image_label_report, self.image_queue[self.window-1][1] + " seed : " + str(self.image_queue[self.window-1][2]), artist_dict, "clicked")
                    self.image_label_report.configure(state="disabled")
                    highlighter()
                if len(self.image_queue) < 5: self.image_history_button_up.configure(state="disabled")
                if len(self.image_queue[self.window-1]) >= 5 and 'id' in self.image_queue[self.window-1][4].index:
                    if fav_check(self.image_queue[self.window-1][4]['id']):
                        self.history_export.configure(text="+ FAV (★)", state="disabled")
                    else:
                        self.history_export.configure(text="+ FAV (☆)", state="normal")
                else:
                    self.history_export.configure(state="disabled")
                if self.app_mode == "WEBUI":
                    if self.auto_nai_setting and self.auto_nai_setting[0][0] in self.image_queue[self.window-1][1]:
                        self.nai_i2i_button.configure(state="normal")
                    else: self.nai_i2i_button.configure(state="disabled")


        def image_history_1_yield(event=None):
            if len(self.image_queue) < 2:
                return
            if self.control_pressed:
                if self.toggle_prompt_fix_button.get() == 0:
                    if len(self.image_queue[self.window-2]) > 4 and "characters" in self.image_queue[self.window-2][4]:
                        image = Image.open(self.image_queue[self.window-2][3])
                        result = image.info.get('Comment', '')
                        result = json.loads(result)
                        insert_with_color(self.text_input, result['prompt'])
                        if 'v4_prompt' in result:
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                                app.nai4_character_list = []
                                app.nai4_character_uc_list = []
                                for k in result["v4_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_list.append(k["char_caption"])
                                for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_uc_list.append(k["char_caption"])
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(app.nai4_character_list)):
                                    _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                    else:
                        self.text_input.delete("0.0", "end")
                        insert_with_color(self.text_input, self.image_queue[self.window-2][1])
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 프롬프트 고정 상태에서는 사용 할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            else:
                self.current_window = self.window-2
                self.what_i_clicked = 1
                if app.state() != 'zoomed':
                    self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(620,620)))
                else:
                    current_image = Image.open(self.image_queue[self.window-2][3])
                    new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                naia_functions.process_text_with_links(self, app.image_label_report, self.image_queue[self.window-2][1] + " seed : " + str(self.image_queue[self.window-2][2]), artist_dict, "clicked")
                highlighter()
                if len(self.image_queue[self.window-2]) >= 5 and 'id' in self.image_queue[self.window-2][4].index:
                    if fav_check(self.image_queue[self.window-2][4]['id']):
                        self.history_export.configure(text="+ FAV (★)", state="disabled")
                    else:
                        self.history_export.configure(text="+ FAV (☆)", state="normal")
                else:
                    self.history_export.configure(state="disabled")
                if self.app_mode == "WEBUI":
                    if self.auto_nai_setting and self.auto_nai_setting[0][0] in self.image_queue[self.window-2][1]:
                        self.nai_i2i_button.configure(state="normal")
                    else: self.nai_i2i_button.configure(state="disabled")

        def image_history_2_yield(event=None):
            if len(self.image_queue) < 3:
                return
            if self.control_pressed:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.text_input.delete("0.0", "end")
                    if len(self.image_queue[self.window-3]) > 4 and "characters" in self.image_queue[self.window-3][4]:
                        image = Image.open(self.image_queue[self.window-3][3])
                        result = image.info.get('Comment', '')
                        result = json.loads(result)
                        insert_with_color(self.text_input, result['prompt'])
                        if 'v4_prompt' in result:
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                                app.nai4_character_list = []
                                app.nai4_character_uc_list = []
                                for k in result["v4_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_list.append(k["char_caption"])
                                for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_uc_list.append(k["char_caption"])
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(app.nai4_character_list)):
                                    _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                    else:
                        self.text_input.delete("0.0", "end")
                        insert_with_color(self.text_input, self.image_queue[self.window-3][1])
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 프롬프트 고정 상태에서는 사용 할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            else:
                self.what_i_clicked = 2
                self.current_window = self.window-3
                if app.state() != 'zoomed':
                    self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-3][0], size=(620,620)))
                else:
                    current_image = Image.open(self.image_queue[self.window-3][3])
                    new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                naia_functions.process_text_with_links(self, app.image_label_report, self.image_queue[self.window-3][1] + " seed : " + str(self.image_queue[self.window-3][2]), artist_dict, "clicked")
                highlighter()
                if len(self.image_queue[self.window-3]) >= 5 and 'id' in self.image_queue[self.window-3][4].index:
                    if fav_check(self.image_queue[self.window-3][4]['id']):
                        self.history_export.configure(text="+ FAV (★)", state="disabled")
                    else:
                        self.history_export.configure(text="+ FAV (☆)", state="normal")
                else:
                    self.history_export.configure(state="disabled")
                if self.app_mode == "WEBUI":
                    if self.auto_nai_setting and self.auto_nai_setting[0][0] in self.image_queue[self.window-3][1]:
                        self.nai_i2i_button.configure(state="normal")
                    else: self.nai_i2i_button.configure(state="disabled")
                
        def image_history_3_yield(event=None):
            if len(self.image_queue) < 4:
                return
            if self.control_pressed:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.text_input.delete("0.0", "end")
                    if len(self.image_queue[self.window-4]) > 4 and "characters" in self.image_queue[self.window-4][4]:
                        image = Image.open(self.image_queue[self.window-4][3])
                        result = image.info.get('Comment', '')
                        result = json.loads(result)
                        insert_with_color(self.text_input, result['prompt'])
                        if 'v4_prompt' in result:
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                                app.nai4_character_list = []
                                app.nai4_character_uc_list = []
                                for k in result["v4_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_list.append(k["char_caption"])
                                for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_uc_list.append(k["char_caption"])
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(app.nai4_character_list)):
                                    _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                    else:
                        self.text_input.delete("0.0", "end")
                        insert_with_color(self.text_input, self.image_queue[self.window-4][1])
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 프롬프트 고정 상태에서는 사용 할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            else:
                self.what_i_clicked = 3
                self.current_window = self.window-4
                if app.state() != 'zoomed':
                    self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-4][0], size=(620,620)))
                else:
                    current_image = Image.open(self.image_queue[self.window-4][3])
                    new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                naia_functions.process_text_with_links(self, app.image_label_report, self.image_queue[self.window-4][1] + " seed : " + str(self.image_queue[self.window-4][2]), artist_dict, "clicked")
                highlighter()
                if len(self.image_queue[self.window-4]) >= 5 and 'id' in self.image_queue[self.window-4][4].index:
                    if fav_check(self.image_queue[self.window-4][4]['id']):
                        self.history_export.configure(text="+ FAV (★)", state="disabled")
                    else:
                        self.history_export.configure(text="+ FAV (☆)", state="normal")
                else:
                    self.history_export.configure(state="disabled")
                if self.app_mode == "WEBUI":
                    if self.auto_nai_setting and self.auto_nai_setting[0][0] in self.image_queue[self.window-4][1]:
                        self.nai_i2i_button.configure(state="normal")
                    else: self.nai_i2i_button.configure(state="disabled")

        def image_history_4_yield(event=None):
            if len(self.image_queue) < 5:
                return
            if self.control_pressed:
                if self.toggle_prompt_fix_button.get() == 0:
                    self.text_input.delete("0.0", "end")
                    if len(self.image_queue[self.window-5]) > 4 and "characters" in self.image_queue[self.window-5][4]:
                        image = Image.open(self.image_queue[self.window-5][3])
                        result = image.info.get('Comment', '')
                        result = json.loads(result)
                        insert_with_color(self.text_input, result['prompt'])
                        if 'v4_prompt' in result:
                            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                                app.nai4_character_list = []
                                app.nai4_character_uc_list = []
                                for k in result["v4_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_list.append(k["char_caption"])
                                for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                                    app.nai4_character_uc_list.append(k["char_caption"])
                                _text = ""
                                self.naid4_selected_character_textbox.configure(state="normal")
                                self.naid4_selected_character_textbox.delete("0.0", "end")
                                for i in range(len(app.nai4_character_list)):
                                    _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                                self.naid4_selected_character_textbox.insert("0.0", _text)
                                self.naid4_selected_character_textbox.configure(state="disabled")
                    else:
                        self.text_input.delete("0.0", "end")
                        insert_with_color(self.text_input, self.image_queue[self.window-5][1])
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 프롬프트 고정 상태에서는 사용 할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
            else:
                self.what_i_clicked = 4
                self.current_window = self.window-5
                if self.current_window < 0:
                    self.window += 1
                    return update()
                if app.state() != 'zoomed':
                    self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-5][0], size=(620,620)))
                else:
                    current_image = Image.open(self.image_queue[self.window-5][3])
                    new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                    instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                    self.image_label.configure(image=instant_result_image)
                naia_functions.process_text_with_links(self, app.image_label_report, self.image_queue[self.window-5][1] + " seed : " + str(self.image_queue[self.window-5][2]), artist_dict, "clicked")
                highlighter()
                if len(self.image_queue[self.window-5]) >= 5 and 'id' in self.image_queue[self.window-5][4].index:
                    if fav_check(self.image_queue[self.window-5][4]['id']):
                        self.history_export.configure(text="+ FAV (★)", state="disabled")
                    else:
                        self.history_export.configure(text="+ FAV (☆)", state="normal")
                else:
                    self.history_export.configure(state="disabled")
                if self.app_mode == "WEBUI":
                    if self.auto_nai_setting and self.auto_nai_setting[0][0] in self.image_queue[self.window-5][1]:
                        self.nai_i2i_button.configure(state="normal")
                    else: self.nai_i2i_button.configure(state="disabled")

        def update():
            button_item_0, button_item_1, button_item_2, button_item_3, button_item_4 = None, None, None, None, None
            if len(self.image_queue) <= 5:
                if len(self.image_queue) == 1:
                    self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                    if len(self.image_queue[self.window-1]) >= 5:
                        button_item_0 = self.image_queue[self.window-1].copy()
                        self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                        self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                    self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(black_image, size=(100,100)))
                    image_history_0_yield()
                if len(self.image_queue) == 2:
                    self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                    if len(self.image_queue[self.window-1]) >= 5:
                        button_item_0 = self.image_queue[self.window-1].copy()
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                        self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                        self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                    else:
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                    self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(100,100)))
                    if len(self.image_queue[self.window-2]) >= 5:
                        button_item_1 = self.image_queue[self.window-2].copy()
                        self.image_history_1.bind("<Button-3>", lambda event: on_right_click(event, button_item_1))
                        self.image_history_1.bind("<Button-2>", lambda event: on_right_click(event, button_item_1))
                    else:
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                    self.image_history_2.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(black_image, size=(100,100)))
                if len(self.image_queue) == 3:
                    self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                    if len(self.image_queue[self.window-1]) >= 5:
                        button_item_0 = self.image_queue[self.window-1].copy()
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                        self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                        self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                    else:
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                    self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(100,100)))
                    if len(self.image_queue[self.window-2]) >= 5:
                        button_item_1 = self.image_queue[self.window-2].copy()
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                        self.image_history_1.bind("<Button-3>", lambda event: on_right_click(event, button_item_1))
                        self.image_history_1.bind("<Button-2>", lambda event: on_right_click(event, button_item_1))
                    else:
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                    self.image_history_2.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-3][0], size=(100,100)))
                    if len(self.image_queue[self.window-3]) >= 5:
                        button_item_2 = self.image_queue[self.window-3].copy()
                        self.image_history_2.bind("<Button-3>", lambda event: on_right_click(event, button_item_2))
                        self.image_history_2.bind("<Button-2>", lambda event: on_right_click(event, button_item_2))
                    else:
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                    self.image_history_3.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(black_image, size=(100,100)))
                if len(self.image_queue) == 4:
                    self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                    if len(self.image_queue[self.window-1]) >= 5:
                        button_item_0 = self.image_queue[self.window-1].copy()
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                        self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                        self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                    else:
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                    self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(100,100)))
                    if len(self.image_queue[self.window-2]) >=5:
                        button_item_1 = self.image_queue[self.window-2].copy()
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                        self.image_history_1.bind("<Button-3>", lambda event: on_right_click(event, button_item_1))
                        self.image_history_1.bind("<Button-2>", lambda event: on_right_click(event, button_item_1))
                    else:
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                    self.image_history_2.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-3][0], size=(100,100)))
                    if len(self.image_queue[self.window-3]) >= 5:
                        button_item_2 = self.image_queue[self.window-3].copy()
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                        self.image_history_2.bind("<Button-3>", lambda event: on_right_click(event, button_item_2))
                        self.image_history_2.bind("<Button-2>", lambda event: on_right_click(event, button_item_2))
                    else:
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                    self.image_history_3.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-4][0], size=(100,100)))
                    if len(self.image_queue[self.window-4]) >= 5:
                        button_item_3 = self.image_queue[self.window-4].copy()
                        self.image_history_3.bind("<Button-3>", lambda event: on_right_click(event, button_item_3))
                        self.image_history_3.bind("<Button-2>", lambda event: on_right_click(event, button_item_3))
                    else:
                        self.image_history_3.unbind("<Button-3>")
                        self.image_history_3.unbind("<Button-2>")
                    self.image_history_4.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(black_image, size=(100,100)))
                if len(self.image_queue) == 5:
                    self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                    if len(self.image_queue[self.window-1]) >= 5:
                        button_item_0 = self.image_queue[self.window-1].copy()
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                        self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                        self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                    else:
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                    self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(100,100)))
                    if len(self.image_queue[self.window-2]) >= 5:
                        button_item_1 = self.image_queue[self.window-2].copy()
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                        self.image_history_1.bind("<Button-3>", lambda event: on_right_click(event, button_item_1))
                        self.image_history_1.bind("<Button-2>", lambda event: on_right_click(event, button_item_1))
                    else:
                        self.image_history_1.unbind("<Button-3>")    
                        self.image_history_1.unbind("<Button-2>")    
                    self.image_history_2.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-3][0], size=(100,100)))
                    if len(self.image_queue[self.window-3]) >= 5:
                        button_item_2 = self.image_queue[self.window-3].copy()
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                        self.image_history_2.bind("<Button-3>", lambda event: on_right_click(event, button_item_2))
                        self.image_history_2.bind("<Button-2>", lambda event: on_right_click(event, button_item_2))
                    else:
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                    self.image_history_3.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-4][0], size=(100,100)))
                    if len(self.image_queue[self.window-4]) >= 5:
                        button_item_3 = self.image_queue[self.window-4].copy()
                        self.image_history_3.unbind("<Button-3>")
                        self.image_history_3.unbind("<Button-2>")
                        self.image_history_3.bind("<Button-3>", lambda event: on_right_click(event, button_item_3))
                        self.image_history_3.bind("<Button-2>", lambda event: on_right_click(event, button_item_3))
                    else:
                        self.image_history_3.unbind("<Button-3>")
                        self.image_history_3.unbind("<Button-2>")
                    if self.window-4 > 0: self.image_history_4.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-5][0], size=(100,100)))
                    else: button_item_4 = None
                    if self.window-4 > 0 and len(self.image_queue[self.window-5]) >= 5:
                        button_item_4 = self.image_queue[self.window-5].copy()
                        self.image_history_4.bind("<Button-3>", lambda event: on_right_click(event, button_item_4))
                        self.image_history_4.bind("<Button-2>", lambda event: on_right_click(event, button_item_4))
                    else:
                        self.image_history_4.unbind("<Button-3>")
                        self.image_history_4.unbind("<Button-2>")
            else:
                self.image_history_0.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(100,100)))
                if len(self.image_queue[self.window-1]) >= 5:
                    button_item_0 = self.image_queue[self.window-1].copy()
                    self.image_history_0.unbind("<Button-3>")
                    self.image_history_0.unbind("<Button-2>")
                    self.image_history_0.bind("<Button-3>", lambda event: on_right_click(event, button_item_0))
                    self.image_history_0.bind("<Button-2>", lambda event: on_right_click(event, button_item_0))
                else:
                        self.image_history_0.unbind("<Button-3>")
                        self.image_history_0.unbind("<Button-2>")
                self.image_history_1.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-2][0], size=(100,100)))
                if len(self.image_queue[self.window-2]) >= 5:
                    button_item_1 = self.image_queue[self.window-2].copy()
                    self.image_history_1.unbind("<Button-3>")
                    self.image_history_1.unbind("<Button-2>")
                    self.image_history_1.bind("<Button-3>", lambda event: on_right_click(event, button_item_1))
                    self.image_history_1.bind("<Button-2>", lambda event: on_right_click(event, button_item_1))
                else:
                        self.image_history_1.unbind("<Button-3>")
                        self.image_history_1.unbind("<Button-2>")
                self.image_history_2.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-3][0], size=(100,100)))
                if len(self.image_queue[self.window-3]) >= 5:
                        button_item_2 = self.image_queue[self.window-3].copy()
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                        self.image_history_2.bind("<Button-3>", lambda event: on_right_click(event, button_item_2))
                        self.image_history_2.bind("<Button-2>", lambda event: on_right_click(event, button_item_2))
                else:
                        self.image_history_2.unbind("<Button-3>")
                        self.image_history_2.unbind("<Button-2>")
                self.image_history_3.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-4][0], size=(100,100)))
                if len(self.image_queue[self.window-4]) >= 5:
                        button_item_3 = self.image_queue[self.window-4].copy()
                        self.image_history_3.unbind("<Button-3>")
                        self.image_history_3.unbind("<Button-2>")
                        self.image_history_3.bind("<Button-3>", lambda event: on_right_click(event, button_item_3))
                        self.image_history_3.bind("<Button-2>", lambda event: on_right_click(event, button_item_3))
                else:
                        self.image_history_3.unbind("<Button-3>")
                        self.image_history_3.unbind("<Button-2>")
                self.image_history_4.configure(self.image_history_sub_frame, image=customtkinter.CTkImage(self.image_queue[self.window-5][0], size=(100,100)))
                if len(self.image_queue[self.window-5]) >= 5:
                    button_item_4 = self.image_queue[self.window-5].copy()
                    self.image_history_4.unbind("<Button-3>")
                    self.image_history_4.unbind("<Button-2>")
                    self.image_history_4.bind("<Button-3>", lambda event: on_right_click(event, button_item_4))
                    self.image_history_4.bind("<Button-2>", lambda event: on_right_click(event, button_item_4))
                else:
                        self.image_history_4.unbind("<Button-3>")
                        self.image_history_4.unbind("<Button-2>")
            if len(self.image_queue) >= 6 and self.window >= 6:
                self.image_history_button_down.configure(state="normal")
            elif len(self.image_queue) >= 6: 
                self.image_history_button_up.configure(state="normal")

        def highlighter():
            self.image_history_0.configure(fg_color = "transparent")
            self.image_history_1.configure(fg_color = "transparent")
            self.image_history_2.configure(fg_color = "transparent")
            self.image_history_3.configure(fg_color = "transparent")
            self.image_history_4.configure(fg_color = "transparent")
            if self.what_i_clicked == 0: self.image_history_0.configure(fg_color = "grey10")
            elif self.what_i_clicked == 1: self.image_history_1.configure(fg_color = "grey10")
            elif self.what_i_clicked == 2: self.image_history_2.configure(fg_color = "grey10")
            elif self.what_i_clicked == 3: self.image_history_3.configure(fg_color = "grey10")
            elif self.what_i_clicked == 4: self.image_history_4.configure(fg_color = "grey10")

        def delete_image(event=None): 
            if not (self.turbo_button.get() == 1 and self.turbo_mode == 3 and app.event_option["rem_prev"]):
                if self.turbo_button.get() == 1 and self.automation_button.get() == 1:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<UserAttention> 연속 이미지 생성 도중에는 삭제할 수 없습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    return
                if self.delete_activate.get() == 0:
                    return
            if self.current_window is not None and len(self.image_queue) > 1:
                filename = self.image_queue[self.current_window][3]
                self.image_queue.pop(self.current_window)
                self.window -= 1
                update()
                move_to_trash(filename)
                if not (self.turbo_button.get() == 1 and self.turbo_mode == 3):
                    if self.what_i_clicked == 0: image_history_0_yield()
                    elif self.what_i_clicked == 1:
                        if len(self.image_queue) > 1: image_history_1_yield()
                        else: image_history_0_yield()
                    elif self.what_i_clicked == 2:
                        if len(self.image_queue) > 2: image_history_2_yield()
                        else: image_history_1_yield()
                    elif self.what_i_clicked == 3:
                        if len(self.image_queue) > 3: image_history_3_yield()
                        else: image_history_2_yield()
                    elif self.what_i_clicked == 4:
                        if len(self.image_queue) > 4: image_history_4_yield()
                        else: image_history_3_yield()
                else:
                    image_history_0_yield()
            if self.window <= 5:
                self.image_history_button_up.configure(state="disabled")
                self.image_history_button_down.configure(state="disabled")
                if len(self.image_queue) <= 5: self.window = len(self.image_queue)
                else: self.window += 1
                if self.what_i_clicked == 0: image_history_0_yield()
                elif self.what_i_clicked == 1:
                    if len(self.image_queue) > 1: image_history_1_yield()
                    else: image_history_0_yield()
                elif self.what_i_clicked == 2:
                    if len(self.image_queue) > 2: image_history_2_yield()
                    else: image_history_1_yield()
                elif self.what_i_clicked == 3:
                    if len(self.image_queue) > 3: image_history_3_yield()
                    else: image_history_2_yield()
                elif self.what_i_clicked == 4:
                    if len(self.image_queue) > 4: image_history_4_yield()
                    else: image_history_3_yield()
                update()
            show_text = str(self.window)+" / "+ str(len(self.image_queue))
            self.window_label.configure(text=show_text)
        self.bind('<Delete>', delete_image)

        def some_command(item):
            random_function(item)

        def insert_pq_0(item):
            self.prior_queue.insert(0, item)
            self.cached_prompt_label.configure(text = "남은 우선예약 큐 : "+str(len(self.prior_queue)), text_color="#ED7D31")
        
        def insert_pq(item):
            self.prior_queue.append(item)
            self.cached_prompt_label.configure(text = "남은 우선예약 큐 : "+str(len(self.prior_queue)), text_color="#ED7D31")

        def insert_fix(item):
            if self.freezed_fix == "" : 
                self.freezed_fix = self.fixed_prompt_input.get("0.0", "end")
                self.recall_fix.grid(row=4, column=1, padx=5, pady=5, sticky="nsew")
                self.apply_fix.grid(row=4, column=2, padx=5, pady=5, sticky="nsew")
            if self.preset_randomizer_button.get() == 1:
                self.preset_randomizer_button.deselect()
            self.fixed_prompt_input.delete("0.0", "end")
            self.fixed_prompt_input.insert("0.0", item)

        def insert_fix_replace_char(item):
            if self.freezed_fix == "" : 
                self.freezed_fix = self.fixed_prompt_input.get("0.0", "end")
                self.recall_fix.grid(row=4, column=1, padx=5, pady=5, sticky="nsew")
                self.apply_fix.grid(row=4, column=2, padx=5, pady=5, sticky="nsew")
            if self.preset_randomizer_button.get() == 1:
                self.preset_randomizer_button.deselect()
            origin = [k.strip() for k in self.freezed_fix.split(',')]
            origin = [k for k in origin if '#' not in k or k == '#프롬프트']
            start = next((i for i, k in enumerate(origin) if k.startswith('<')), -1)
            end = origin[-1]
            replace = [k.strip() for k in item.split(', ')]
            last = next((i for i in range(len(replace)-1, -1, -1) if replace[i] == end), -1)
            if len(replace) >= len(origin):
                replace = replace[:last+1] if last != -1 else replace[:len(origin)]
            else:
                replace = replace
            replace[start] = origin[start]
            item = ', '.join(replace)
            self.fixed_prompt_input.delete("0.0", "end")
            self.fixed_prompt_input.insert("0.0", item)

        def insert_characters(item):
            image = Image.open(item)
            result = image.info.get('Comment', '')
            result = json.loads(result)
            if 'v4_prompt' in result:
                if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"):
                    app.nai4_character_list = []
                    app.nai4_character_uc_list = []
                    for k in result["v4_prompt"]["caption"]["char_captions"]:
                        app.nai4_character_list.append(k["char_caption"])
                    for k in result["v4_negative_prompt"]["caption"]["char_captions"]:
                        app.nai4_character_uc_list.append(k["char_caption"])
                    _text = ""
                    self.naid4_selected_character_textbox.configure(state="normal")
                    self.naid4_selected_character_textbox.delete("0.0", "end")
                    for i in range(len(app.nai4_character_list)):
                        _text += app.nai4_character_list[i].replace("girl, ","").replace("boy, ","").split(', ')[0] + ", "
                    self.naid4_selected_character_textbox.insert("0.0", _text)
                    self.naid4_selected_character_textbox.configure(state="disabled")

                char_captions = result["v4_prompt"]["caption"]["char_captions"]
                if len(char_captions) == len(self.character_frames):
                    # 길이가 같은 경우: 내용만 업데이트
                    for idx, frame_dict in enumerate(self.character_frames):
                        frame_dict['textbox'].delete("0.0", "end")
                        frame_dict['textbox'].insert("0.0", char_captions[idx]["char_caption"])
                        frame_dict['uc'].delete("0.0", "end")
                        frame_dict['uc'].insert("0.0", result["v4_negative_prompt"]["caption"]["char_captions"][idx]["char_caption"])
                else:
                    # 길이가 다른 경우: 프레임 재생성
                    for frame_dict in self.character_frames:
                        frame_dict['frame'].grid_forget()
                    self.character_frames.clear()
                    for idx, character in enumerate(char_captions, start=1):
                        new_frame_dict = create_character_frame(
                            self.naid4_characters_frame,
                            idx,
                            large_font,
                            v_large_font,
                            self.character_frames,
                            lambda: add_new_character(self.naid4_characters_frame, large_font, v_large_font, self.character_frames),
                            remove_character
                        )
                        new_frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")
                        new_frame_dict['textbox'].delete("0.0", "end")
                        new_frame_dict['textbox'].insert("0.0", character["char_caption"])
                        new_frame_dict['uc'].delete("0.0", "end")
                        new_frame_dict['uc'].insert("0.0", result["v4_negative_prompt"]["caption"]["char_captions"][idx-1]["char_caption"])
                        self.character_frames.append(new_frame_dict)

        def on_right_click(event, button_item):
            context_menu.delete(0, tk.END)  # 기존 메뉴 항목을 모두 삭제
            context_menu.add_command(label="이 프롬프트를 다시 개봉", command=lambda: some_command(button_item[4]))  # 새 커맨드 추가
            context_menu.add_command(label="우선생성 큐에 삽입 (다음)", command=lambda: insert_pq_0(button_item[4]))
            context_menu.add_command(label="우선생성 큐에 삽입 (마지막)", command=lambda: insert_pq(button_item[4]))
            context_menu.add_command(label="선행고정 프롬프트 추출", command=lambda: insert_fix(button_item[5]))
            context_menu.add_command(label="→ 캐릭터WC 제외 추출", command=lambda: insert_fix_replace_char(button_item[5]))
            if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated"): context_menu.add_command(label="[NAI4] 캐릭터 불러오기", command=lambda: insert_characters(button_item[3]))
            context_menu.tk_popup(event.x_root, event.y_root)
                
        context_menu = tk.Menu(self, tearoff=0, font=v_large_font, fg="black")

        black_image = Image.new('RGB', (100, 100), '#2B2B2B')
        self.image_history_0 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_0_yield)
        self.image_history_0.grid(row=0, column=1, padx=5, pady=1, sticky="n")
        self.image_history_1 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_1_yield)
        self.image_history_1.grid(row=1, column=1, padx=5, pady=1, sticky="n")
        self.image_history_2 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_2_yield)
        self.image_history_2.grid(row=2, column=1, padx=5, pady=1, sticky="n")
        self.image_history_3 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_3_yield)
        self.image_history_3.grid(row=3,column=1, padx=5, pady=1, sticky="n")
        self.image_history_4 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",  image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_4_yield)
        self.image_history_4.grid(row=4, column=1, padx=5, pady=1, sticky="n")
        self.image_history_button_up = customtkinter.CTkButton(self.image_history_frame, text="▲", width=100, font=my_font, state="disabled", command=up_button_pressed)
        self.image_history_button_up.grid(row=0, column=1, pady=10, padx=5, sticky="n")
        self.image_history_button_down = customtkinter.CTkButton(self.image_history_frame, text="▼", width=100, font=my_font, state="disabled", command=down_button_pressed)
        self.image_history_button_down.grid(row=13, column=1, pady=5, padx=5, sticky="n")

        def save_to_excel():
            #contributor : highnoon1
            #function : 히스토리 엑셀로 저장 (무제한 보기는 성능 이슈로 제외)
            workbook = Workbook()
            sheet = workbook.active

            alignment = Alignment(wrapText=True)
            sheet['A1'].alignment = alignment
            sheet['A1'] = 'Prompt'
            sheet['B1'] = 'Seed'
            sheet['C1'] = 'Image'

            image_objects = []  # BytesIO 객체를 추적하기 위한 리스트

            # history 데이터를 반복하며 Excel에 저장
            for index, (pil_image, prompt, seed, *_rest) in enumerate(self.image_queue):
                
                row_num = index + 1  # 행 번호 (Excel 행은 1부터 시작)

                # 프롬프트와 시드 삽입
                prompt_cell = sheet.cell(row=row_num, column=1, value=prompt)
                sheet.cell(row=row_num, column=2, value=seed)
                prompt_cell.alignment = Alignment(wrap_text=True)

                # PIL 이미지를 BytesIO 객체에 PNG 형식으로 저장
                pil_image = self.resize_image_to_fit(pil_image,192)
                output = io.BytesIO()
                pil_image.save(output, format='PNG')
                output.seek(0)
                image_objects.append(output)  # 리스트에 추가

                # Openpyxl 이미지 생성 및 시트에 추가
                img = OpenpyxlImage(output)
                img.anchor = f'C{row_num}'  # 이미지를 C열에 고정
                sheet.add_image(img)

                # 이미지 크기에 따라 행 높이 및 열 너비 조정
                scale_factor = 0.75
                sheet.row_dimensions[row_num].height = pil_image.height * scale_factor
                sheet.column_dimensions['C'].width = pil_image.width * scale_factor / 7

            # A열과 B열 크기 조정
            sheet.column_dimensions['A'].width = 50
            sheet.column_dimensions['B'].width = 15

            # 워크북 저장
            workbook.save(f"history_with_images_{self.start_time}.xlsx")
            file_path = f"history_with_images_{self.start_time}.xlsx"

            # 모든 BytesIO 객체 닫기
            for img_obj in image_objects:
                img_obj.close()
            file_path = os.path.join('.', f"history_with_images_{self.start_time}.xlsx")

            if os.path.exists(file_path):
                if sys.platform == "darwin":  # Mac OS
                    subprocess.run(["open", file_path])
                elif sys.platform == "win32":  # Windows
                    os.startfile(file_path)

            print("엑셀 파일에 저장됨")

        def history_export():
            if self.control_pressed:
                save_to_excel()
                self.history_export.configure(text="+ FAV (☆)", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black")
                if self.image_queue and len(self.image_queue[self.current_window]) >= 5:
                    self.history_export.configure(state="normal")
                else:
                    self.history_export.configure(state="disabled")
            else:
                """
                Description : @history_export 평상시에는 FAV 기능으로 동작
                """
                new_data = self.image_queue[self.current_window][4]
                validation_prompt = self.image_queue[self.current_window][1]
                prompt = new_data['general']
                validation_prompt = [key.strip() for key in validation_prompt.split(',')]
                prompt = [key.strip() for key in prompt.split(',')]
                autohide = self.auto_hide_keyword_input.get("0.0", "end")
                autohide = [key.strip() for key in autohide.split(',')] + app.data.bag_of_tags
                prompt = [key for key in prompt if key not in autohide]
                not_validated = [key for key in prompt if key not in validation_prompt]
                if len(not_validated) >= 3:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", f"<ValidationError> 랜덤하게 생성된 프롬프트가 아니거나, {len(not_validated)}개의 제거된 태그가 검출되었습니다. 실제 저장된 프롬프트는 기대와 다른 결과물을 생성할 수 있습니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                try:
                    favorite_prompts = pd.read_parquet('favorite_prompt.parquet')
                except FileNotFoundError:
                    dtype_dict = {
                        'id': 'int64',
                        'copyright': 'object',
                        'character': 'object',
                        'artist': 'object',
                        'general': 'object',
                        'meta': 'object',
                        'rating': 'object',
                        'score': 'object',
                        'created_at': 'object',
                    }
                    favorite_prompts = pd.DataFrame(columns=dtype_dict.keys())
                    self.fav_button.configure(state="normal")
                try:
                    _temp = new_data['id']
                except:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<TagsError> 0215 버전부터 tags의 구성이 변경되었습니다. favorite 기능을 사용하기 위해 검색을 다시 수행 해 주세요.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                    return
                new_data_id = new_data['id']
                new_data = pd.DataFrame([new_data])
                success = False
                if 'id' not in favorite_prompts.columns:
                    favorite_prompts = pd.concat([favorite_prompts, new_data], ignore_index=True)
                    success = True
                elif not favorite_prompts['id'].isin([new_data_id]).any():
                    favorite_prompts = pd.concat([favorite_prompts, new_data], ignore_index=True)
                    success = True
                else:
                    self.image_label_report.configure(state="normal")
                    self.image_label_report.delete("0.0", "end")
                    self.image_label_report.insert("0.0", "<AlreadyExist> 이미 favorite에 등록되어있는 프롬프트입니다.")
                    self.image_label_report.configure(text_color="#FFFF97")
                    self.image_label_report.configure(state="disabled")
                if success:
                    pil_image = self.image_queue[self.current_window][0]
                    folder_path = 'favorite_prompts'
                    if not os.path.exists(folder_path):
                        os.makedirs(folder_path)
                    favorite_prompts.to_parquet('favorite_prompt.parquet')
                    image_path = os.path.join(folder_path, f"{_temp}.jpg")
                    pil_image.save(image_path, 'JPEG')
                    self.fav_id_list.append(_temp)
                self.history_export.configure(text="FAV (★)", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", state="disabled")

        self.history_export = customtkinter.CTkButton(self.image_history_frame, text="+ FAV (☆)", width=100, fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", font=my_font, command=history_export, state="disabled")
        self.history_export.grid(row=14, column=1, pady=10, padx=5, sticky="n")

        def sema_pressed():
            if self.sema_button_var.get() == 0:
                self.dyn_button.deselect()

        def sema_dyn_pressed():
            if self.dyn_button_var.get() == 1:
                self.sema_button.select()

        def _open_instant_event():
            if self.app_mode == "NAI":
                if self.instant_event_window is not None:
                    self.instant_event_window.deiconify()
                else:
                    self.open_instant_event()
            else:
                if not self.control_pressed:
                    self.control_pressed = False
                    self.random_artist_window()
                else:
                    if self.instant_event_window is not None:
                        self.instant_event_window.deiconify()
                    else:
                        self.open_instant_event()

        def instant_nai_request():
            if self.control_pressed:
                self.control_pressed = False
                current_lookup = self.image_queue[self.current_window].copy()
                prompt = current_lookup[1]
                for replace_item in self.auto_nai_setting[0]:
                    prompt = prompt.replace(replace_item, "")
                if self.auto_nai_setting[1] != '':
                    prompt = prompt.replace(self.auto_nai_setting[1], self.auto_nai_setting[2])
                else:
                    prompt = self.auto_nai_setting[1] + ', ' + prompt
                prompt = prompt.replace('\\(', '(').replace('\\)', ')')
                prompt = re.sub(r':\d+\.\d+', '', prompt)
                prompt += self.auto_nai_setting[3]
                uc= self.auto_nai_setting[4] if len(self.auto_nai_setting[4]) > 2 else "watermark, blurry, very displeasing, lowres, worst quality, bad anatomy, bad hands, greyscale, signature, multiple views, low quality"
                remake_contents = {
                    "prompt": prompt,
                    "seed": random.randint(0,2**32 - 1),
                    "uc": uc
                }
                self.sync_i2i_img = Image.open(current_lookup[3])
                self.sync_i2i_contents = remake_contents
                self.nai_i2i_button.configure(state="disabled")
            else:
                instant_img2img(self, self.nai_access_token, self.auto_nai_setting, True)

        def random_artist_wrapper():
            if self.NAI_webui_address and self.control_pressed:
                self.control_pressed = False
                instant_img2img(self, self.NAI_webui_address, None, False, "adetailer_current")
            else:
                self.random_artist_window()

        def resolution_event(event = None):
            if self.resolution_var.get() == "랜덤 해상도 설정":
                open_res_setting()

        self.resolution_window = None
        self.resolution_setting = None

        def open_res_setting():
            resolution_window = customtkinter.CTkToplevel()
            self.resolution_window = resolution_window
            resolution_window.title("랜덤 해상도 설정")
            resolution_window.attributes('-topmost', True)
            resolution_window.resizable(width=False, height=False)

            def on_apply():
                res_list = [key.strip() for key in entry1.get("0.0", "end").split(',')]
                if "" in res_list:
                    res_list.remove("")
                valid_resolutions = True

                for res in res_list:
                    try:
                        width, height = [int(dim) for dim in res.split(" x ")]
                        if self.app_mode == "NAI":
                            # NAI 모드일 때 64의 배수로 구성되어 있는지 확인
                            if width % 64 != 0 or height % 64 != 0:
                                valid_resolutions = False
                                label2.configure(text="가로 세로는 각각 64배수여야함", text_color="yellow")
                                break
                        else:
                            # NAI 모드가 아닐 때 8의 배수로 구성되어 있는지 확인
                            if width % 8 != 0 or height % 8 != 0:
                                valid_resolutions = False
                                label2.configure(text="가로 세로는 각각 8배수여야함", text_color="yellow")
                                break
                    except ValueError:
                        # 분할한 결과가 정수로 변환될 수 없는 경우(잘못된 형식의 입력)
                        valid_resolutions = False
                        break

                if not valid_resolutions or any(" x " not in key for key in res_list):
                    button1.configure(text="적용 후 닫기 (실패)", text_color="yellow")
                else:
                    self.resolutions = res_list.copy()
                    on_close()
            
            def reset():
                entry1.delete("0.0", "end")
                entry1.insert("0.0", "1024 x 1024,\n960 x 1088,\n896 x 1152,\n832 x 1216,\n1088 x 960,\n1152 x 896,\n1216 x 832")
                
            def on_close():
                resolution_window.withdraw()

            label1 = customtkinter.CTkLabel(resolution_window, text="생성 버튼을 누를때 사용될 랜덤 해상도", font=my_font)
            entry1 = customtkinter.CTkTextbox(resolution_window, height=300, font=v_large_font)
            button1 = customtkinter.CTkButton(resolution_window, text="적용 후 닫기", font=my_font, command=on_apply)
            button2= customtkinter.CTkButton(resolution_window, text="초기화", font=my_font, command=reset,fg_color="grey10", hover_color="grey")
            label2 = customtkinter.CTkLabel(resolution_window, text="가로 x 세로 띄어쓰기, 쉼표 줄넘김 필수", font=my_font)
            entry1.insert("0.0", ",\n".join(self.resolutions))

            label1.grid(row=0, column=0, padx=5, sticky="n")
            entry1.grid(row=1, column=0, padx=5, sticky="n")
            button1.grid(row=2, column=0, padx=5, sticky="n")
            button2.grid(row=3, column=0, padx=5, sticky="n")
            label2.grid(row=4, column=0, padx=5, sticky="n")

            resolution_window.protocol("WM_DELETE_WINDOW", on_close)
            resolution_window.after(1500, lambda: resolution_window.attributes('-topmost', False))

        def variety_enable():
            if self.variety_button.get() == 1:
                self.uncond_strength_entry.configure(state="normal")
            else:
                self.uncond_strength_entry.configure(state="disabled")

        #랜덤작가 및 와일드카드 설정
        if self.app_mode == "NAI":
            self.extended_right_frame = customtkinter.CTkFrame(self.right_frame)
            self.extended_right_frame.grid(row=18, column=0, columnspan=2, padx=5, sticky="w")
            self.random_artist_var = customtkinter.IntVar()
            self.random_artist_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="랜덤작가 추가", variable=self.random_artist_var, font=my_font, state="disabled")
            self.random_artist_button.grid(row=1, column=0,pady=5, padx=10, sticky="nsew")
            self.random_artist_manage_button = customtkinter.CTkButton(self.extended_right_frame, text="랜덤작가 관리", font=my_font, command=random_artist_wrapper)
            self.random_artist_manage_button.grid(row=1, column=1,pady=5, padx=5, sticky="nsew")
            self.recommended_prompt_button = customtkinter.CTkButton(self.extended_right_frame, text="추천 프롬프트", font=my_font, command= self.open_prompt_window)
            self.recommended_prompt_button.grid(row=1, column=3,pady=5, padx=5, sticky="nsew")
            self.wildcard_manager_button = customtkinter.CTkButton(self.extended_right_frame, text="와일드카드 관리", font=my_font, command=self.open_wildcard_window)
            self.wildcard_manager_button.grid(row=1, column=2,pady=5, padx=5, sticky="nsew")
            self.character_search_button = customtkinter.CTkButton(self.extended_right_frame, text="캐릭터 검색", fg_color="#7030A0", hover_color="#481F67", font=my_font, command= lambda: open_Character_search(self, self.character_search_button))
            self.character_search_button.grid(row=1, column=4,pady=5, padx=5, sticky="nsew")
            self.seed_fix_var = customtkinter.IntVar()
            self.seed_fix_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="시드고정 ", variable=self.seed_fix_var, font=my_font)
            self.seed_fix_button.grid(row=2, column=0,pady=5, padx=10, sticky="nsew")
            self.entry_seed_value = customtkinter.IntVar()
            self.seed_entry = customtkinter.CTkEntry(self.extended_right_frame, textvariable=self.entry_seed_value)
            self.seed_entry.grid(row=2, column=1,pady=5, padx=5, sticky="nsew")
            self.seed_entry.insert(0, random.randint(0,2**32 - 1))
            self.cfg_scale_label = customtkinter.CTkLabel(self.extended_right_frame, text="CFG Scale : ", font=my_font)
            self.cfg_scale_label.grid(row=2, column=2,pady=5, padx=5, sticky="w")
            self.cfg_scale_var = customtkinter.StringVar(value="5.0")
            self.cfg_scale_entry = customtkinter.CTkEntry(self.extended_right_frame, width=65, textvariable=self.cfg_scale_var)
            self.cfg_scale_entry.grid(row=2, column=2,pady=5, padx=5, sticky="e")
            self.prompt_guidance_rescale_var = customtkinter.StringVar(value="0")
            self.prompt_guidance_rescale_label = customtkinter.CTkLabel(self.extended_right_frame, text="Prompt Guidance Rescale :", font=my_font)
            self.prompt_guidance_rescale_label.grid(row=2, column=3, pady=5, padx=5, sticky="w")
            self.prompt_guidance_rescale_entry = customtkinter.CTkEntry(self.extended_right_frame, width=65, textvariable=self.prompt_guidance_rescale_var)
            self.prompt_guidance_rescale_entry.grid(row=2, column=4,pady=5, padx=10, sticky="w")
            self.extra_setting_button = customtkinter.CTkButton(self.extended_right_frame, width=55, text="기타설정", font=my_font, fg_color="grey", hover_color="grey5", command=lambda: show_advanced_settings(self))
            self.extra_setting_button.grid(row=2, column=4,pady=5, padx=5, sticky="e")
            self.random_resolution_var = customtkinter.IntVar()
            self.random_resolution_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="랜덤 해상도 ", variable=self.random_resolution_var, font=my_font)
            self.random_resolution_button.grid(row=3, column=0,pady=5, padx=10, sticky="nsew")
            self.resolution_var = customtkinter.StringVar(value="1024 x 1024")
            self.resolution_button = customtkinter.CTkComboBox(self.extended_right_frame, width=160,values=["랜덤 해상도 설정", "--- 2.1MP~(42/51/59 Anlas)--- ", "1472 x 1472", "1088 x 1920", "1280 x 1664", "1344 x 1536", "1536 x 1344","1664 x 1280", "1920 x 1088", "--- 1.6MP (30/36/42 Anlas)--- ", "1216 x 1216", "1024 x 1536", "1536 x 1024", "--- 기본 1MP 해상도 (랜덤O) --- ", "1024 x 1024", "960 x 1088", "896 x 1152", "832 x 1216", "1088 x 960", "1152 x 896", "1216 x 832"], command=resolution_event,variable=self.resolution_var, font=my_font)
            self.resolution_button.grid(row=3, column=1, padx=5, sticky="w")
            self.sampler_label = customtkinter.CTkLabel(self.extended_right_frame, text="Sampler :", font=my_font)
            self.sampler_label.grid(row=3, column=2,pady=5, padx=15, sticky="w")
            self.sampler_var = customtkinter.StringVar(value="k_dpmpp_sde + native" if self.app_mode == "NAI" else "k_euler_ancestral")
            self.sampler_button = customtkinter.CTkComboBox(self.extended_right_frame, width=210,values=["k_euler + native", "k_euler + karras", "k_euler + exponential", "k_euler_ancestral + native", "k_euler_ancestral + karras","k_euler_ancestral + exponential", "k_dpmpp_2s_ancestral + native", "k_dpmpp_2s_ancestral + karras", "k_dpmpp_2s_ancestral + exponential", "k_dpmpp_sde + native", "k_dpmpp_sde + karras", "k_dpmpp_sde + exponential", "k_dpmpp_2m + native", "k_dpmpp_2m + karras", "k_dpmpp_2m + exponential","k_dpmpp_2m + native", "k_dpmpp_2m + karras", "k_dpmpp_2m + exponential",  "k_dpmpp_2m_sde + native", "k_dpmpp_2m_sde + karras", "k_dpmpp_2m_sde + exponential"], variable=self.sampler_var, font=my_font)
            self.sampler_button.grid(row=3, column=2, columnspan=2, pady=5, padx=15, sticky="e")
            self.show_fullscreen_btn = customtkinter.CTkButton(self.extended_right_frame, text="전체화면(ESC닫기)", font=my_font, command=self.show_fullscreen_image)
            self.show_fullscreen_btn.grid(row=3, column=4,pady=5, padx=5, sticky="nsew")
            self.smea_frame = customtkinter.CTkFrame(self.extended_right_frame, fg_color="#2B2B2B")
            self.smea_frame.grid(row=4, column=0, columnspan=2, pady=5, padx=10, sticky="w")
            self.sema_button_var = customtkinter.IntVar()
            self.sema_button = customtkinter.CTkCheckBox(self.smea_frame, text="SMEA", variable=self.sema_button_var,font=my_font, command=sema_pressed, width=55)
            self.sema_button.grid(row=4, column=0, pady=5, sticky="w")
            self.dyn_button_var = customtkinter.IntVar()
            self.dyn_button = customtkinter.CTkCheckBox(self.smea_frame, text="DYN", variable=self.dyn_button_var, font=my_font, command=sema_dyn_pressed, width=55)
            self.dyn_button.grid(row=4, column=1, pady=5, padx=2, sticky="w")
            self.variety_var = customtkinter.IntVar()
            self.variety_button = customtkinter.CTkCheckBox(self.smea_frame, text="VAR+", variable=self.variety_var, font=my_font, width=55, command=variety_enable)
            self.variety_button.grid(row=4, column=2, pady=5, padx=2, sticky="w")
            self.decrsp_var = customtkinter.IntVar()
            self.decrsp_button = customtkinter.CTkCheckBox(self.smea_frame, text="DECRISP", variable=self.decrsp_var, font=my_font, width=55)
            self.decrsp_button.grid(row=4, column=3, pady=5, padx=2, sticky="w")
            self.state_label = customtkinter.CTkLabel(self.extended_right_frame, text="state : idle", font=my_font)
            self.state_label.grid(row=4, column=2, columnspan=2, pady=5, padx=10, sticky="n")
            self.instant_event_window = None
            self.instant_row_button = customtkinter.CTkButton(self.extended_right_frame, text="인스턴트 이벤트", font=my_font, fg_color="grey10", command=_open_instant_event)
            self.instant_row_button.grid(row=4, column=4,pady=5, padx=5, sticky="nsew")
            GENERATE_EVENT = "<<GenerateEvent>>"
            self.sync_i2i_img = None
            self.sync_i2i_contents = None
            self.sync_characters_nai4 = None
            self.sync_outpainting = None
            self.sync_transform_image = None
            sync_text()
            self.bind(GENERATE_EVENT, lambda x=None: NAIA_generate(self))
            self.output_file_path_personal = False
            self.png_name_rule = "time"
            self.name_var = customtkinter.StringVar(value=self.png_name_rule)
            self.window_resize_last_access = None
            self.last_window_size_conf = None
            self.generation_count = 0
            self.random_artist_list = None
            self.random_artist = []
            self.random_artist_prefix = customtkinter.StringVar(value="none")
            self.nai_i2i_button = customtkinter.CTkButton(self.extended_right_frame, text="⬆ NAI I2I", width=100, fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", font=my_font, command=instant_nai_request, state="disabled")
            naid4_character_update()
        else:
            self.sync_transform_image = None
            self.extended_right_frame = customtkinter.CTkFrame(self.right_frame)
            self.extended_right_frame.grid(row=18, column=0, columnspan=2, padx=5, sticky="w")
            self.random_artist_var = customtkinter.IntVar()
            self.random_artist_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="랜덤작가 추가", variable=self.random_artist_var, font=my_font, state="disabled")
            #self.random_artist_button.grid(row=0, column=0,pady=5, padx=10, sticky="nsew")
            self.nai_i2i_button = customtkinter.CTkButton(self.extended_right_frame, text="⬆ NAI I2I", width=100, fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", font=my_font, command=instant_nai_request, state="disabled")
            self.nai_i2i_button.grid(row=0, column=0,pady=5, padx=10, sticky="nsew")
            self.random_artist_button.configure(state="disabled")
            self.instant_event_window = None
            self.random_artist_manage_button = customtkinter.CTkButton(self.extended_right_frame, text="랜덤작가 관리", font=my_font, fg_color="grey10", command=_open_instant_event)
            self.random_artist_manage_button.grid(row=0, column=1,pady=5, padx=5, sticky="nsew")
            self.recommended_prompt_button = customtkinter.CTkButton(self.extended_right_frame, text="추천 프롬프트", font=my_font, command= self.open_prompt_window)
            self.recommended_prompt_button.grid(row=0, column=3,pady=5, padx=5, sticky="nsew")
            self.wildcard_manager_button = customtkinter.CTkButton(self.extended_right_frame, text="와일드카드 관리", font=my_font, command=self.open_wildcard_window)
            self.wildcard_manager_button.grid(row=0, column=2,pady=5, padx=5, sticky="nsew")
            self.character_search_button = customtkinter.CTkButton(self.extended_right_frame, text="캐릭터 검색", fg_color="#7030A0", hover_color="#481F67", font=my_font, command= lambda: open_Character_search(self, self.character_search_button))
            self.character_search_button.grid(row=0, column=4,pady=5, padx=5, sticky="nsew")
            self.seed_fix_var = customtkinter.IntVar()
            self.seed_fix_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="시드고정 ", variable=self.seed_fix_var, font=my_font)
            self.seed_fix_button.grid(row=1, column=0,pady=5, padx=10, sticky="nsew")
            self.entry_seed_value = customtkinter.IntVar()
            self.seed_entry = customtkinter.CTkEntry(self.extended_right_frame, textvariable=self.entry_seed_value)
            self.seed_entry.grid(row=1, column=1,pady=5, padx=5, sticky="nsew")
            self.seed_entry.insert(0, random.randint(0,2**32 - 1))
            self.cfg_scale_label = customtkinter.CTkLabel(self.extended_right_frame, text="CFG Scale : ", font=my_font)
            self.cfg_scale_label.grid(row=1, column=2,pady=5, padx=5, sticky="w")
            self.cfg_scale_var = customtkinter.StringVar(value="5.0")
            self.cfg_scale_entry = customtkinter.CTkEntry(self.extended_right_frame, width=65, textvariable=self.cfg_scale_var)
            self.cfg_scale_entry.grid(row=1, column=2,pady=5, padx=5, sticky="e")
            self.prompt_guidance_rescale_var = customtkinter.StringVar(value="0")
            self.steps_frame = customtkinter.CTkFrame(self.extended_right_frame, width= 200, height= 28, fg_color="#2B2B2B")
            self.steps_frame.grid(row=1, column=3, columnspan=2,sticky="w")
            self.prompt_guidance_rescale_label = customtkinter.CTkLabel(self.steps_frame, text="Steps :", font=my_font)
            self.prompt_guidance_rescale_label.grid(row=0, column=0, sticky="w")
            self.prompt_guidance_rescale_entry = customtkinter.CTkEntry(self.steps_frame, width=40)
            self.prompt_guidance_rescale_entry.grid(row=0, column=1, sticky="w", padx=5)
            self.prompt_guidance_rescale_entry.insert(0, '28')
            self.hires_steps_label = customtkinter.CTkLabel(self.steps_frame, text="Hires.steps :", font=my_font)
            self.hires_steps_label.grid(row=0, column=2, sticky="w", padx=5)
            self.hires_steps_entry = customtkinter.CTkEntry(self.steps_frame, width=40)
            self.hires_steps_entry.grid(row=0, column=3, sticky="w", padx=5)
            self.hires_steps_entry.insert(0, '16')
            self.extra_setting_button = customtkinter.CTkButton(self.extended_right_frame, width=55, text="기타설정", font=my_font, fg_color="grey", hover_color="grey5", command=lambda: show_advanced_settings(self))
            self.extra_setting_button.grid(row=1, column=4,pady=5, padx=5, sticky="e")
            self.random_resolution_var = customtkinter.IntVar()
            self.random_resolution_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="랜덤 해상도 ", variable=self.random_resolution_var, font=my_font)
            self.random_resolution_button.grid(row=2, column=0,pady=5, padx=10, sticky="nsew")
            self.resolution_var = customtkinter.StringVar(value="1024 x 1024")
            self.resolution_button = customtkinter.CTkComboBox(self.extended_right_frame, width=160,values=["랜덤 해상도 설정", "1024 x 1024", "960 x 1088", "896 x 1152", "832 x 1216", "1088 x 960", "1152 x 896", "1216 x 832"], variable=self.resolution_var, command=resolution_event, font=my_font)
            self.resolution_button.grid(row=2, column=1, padx=5, sticky="w")
            self.sampler_label = customtkinter.CTkLabel(self.extended_right_frame, text="Sampler :", font=my_font)
            self.sampler_label.grid(row=2, column=2,pady=5, padx=5, sticky="w")
            self.sampler_var = customtkinter.StringVar(value="Euler a")
            self.sampler_button = customtkinter.CTkComboBox(self.extended_right_frame, width=210,values=NAIA_utils.get_sampler_list(self.access_token), variable=self.sampler_var, font=my_font)
            self.sampler_button.grid(row=2, column=2, columnspan=2, pady=5, padx=15, sticky="e")
            self.show_fullscreen_btn = customtkinter.CTkButton(self.extended_right_frame, text="전체화면(ESC닫기)", font=my_font, command=self.show_fullscreen_image)
            self.show_fullscreen_btn.grid(row=3, column=4,pady=5, padx=5, sticky="nsew")
            self.sema_button_var = customtkinter.IntVar()
            self.sema_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="Hires.fix/Upscale:", variable=self.sema_button_var,font=my_font, command=sema_pressed)
            self.sema_button.grid(row=3, column=0, columnspan=2, pady=5, padx=10, sticky="w")
            self.upscalers = NAIA_utils.get_upscaler_list(self.access_token)
            self.upscaler_current = customtkinter.StringVar(value="Lanczos")
            self.hires_sampler_entry = customtkinter.CTkComboBox(self.extended_right_frame, width=125,  font=my_font, values=self.upscalers, variable=self.upscaler_current)
            self.hires_sampler_entry.grid(row=3, column=0, columnspan=2, pady=5, padx=5, sticky="e")
            self.dyn_button_var = customtkinter.IntVar()
            self.dyn_button = customtkinter.CTkCheckBox(self.extended_right_frame, text="SMEA+DYN", variable=self.dyn_button_var, font=my_font, command=sema_dyn_pressed)
            self.state_label_frame = customtkinter.CTkFrame(self.extended_right_frame, height=28, fg_color="#2B2B2B")
            self.state_label_frame.grid(row=3, column=2, columnspan=2, sticky="nsew")
            self.state_label_frame.columnconfigure(0, weight=2)
            self.state_label_frame.columnconfigure(1, weight=1)
            self.state_label_frame.columnconfigure(2, weight=7)
            self.upscale_label = customtkinter.CTkLabel(self.state_label_frame, text="Upscale:", font=my_font)
            self.upscale_label.grid(row=0, column=0, pady=5, padx=5, sticky="w")
            self.upscale_entry = customtkinter.CTkEntry(self.state_label_frame, width=35, font=customtkinter.CTkFont('Pretendard', 11))
            self.upscale_entry.grid(row=0, column=0, pady=5, padx=5, sticky="e")
            self.upscale_entry.insert(0, '1.5')
            self.state_label = customtkinter.CTkLabel(self.state_label_frame, text="state : idle", font=my_font)
            self.state_label.grid(row=0, column=1, columnspan=2,pady=5, padx=5, sticky="n")
            self.denoise_label = customtkinter.CTkLabel(self.extended_right_frame, text="Hires.Denoise : ", font=my_font)
            self.denoise_label.grid(row=2, column=4,pady=5, padx=5, sticky="w")
            self.denoise_entry = customtkinter.CTkEntry(self.extended_right_frame, width=45)
            self.denoise_entry.grid(row=2, column=4,pady=5, padx=5, sticky="e")
            self.denoise_entry.insert(0, '0.35')
            GENERATE_EVENT = "<<GenerateEvent>>"
            self.sync_i2i_img = None
            self.sync_i2i_contents = None
            self.sync_outpainting = None
            sync_text()
            self.bind(GENERATE_EVENT, lambda x=None: NAIA_generate(self))
            self.output_file_path_personal = False
            self.png_name_rule = "time"
            self.name_var = customtkinter.StringVar(value=self.png_name_rule)
            self.window_resize_last_access = None
            self.last_window_size_conf = None
            self.generation_count = 0
            self.random_artist_list = None
            self.random_artist = []
            self.random_artist_prefix = customtkinter.StringVar(value="none")
            self.outpainting_box = None
            self.prev_iimg_id = None
            self.instant_row_button = customtkinter.CTkButton(self.searched_prompt_frame, text="인스턴트 이벤트", font=my_font, fg_color="grey10", command=self.open_instant_event)
            self.instant_row_button.grid(row=2, column=2,pady=5, padx=5, sticky="nsew")

        def on_window_resize(event):
            if datetime.now() == app.last_window_size_conf:
                return
            time_difference = datetime.now() - app.start_time_prime
            if (time_difference.total_seconds() < 5):
                return
            if app.last_window_size is None:
                app.last_window_size = (app.winfo_width(), app.winfo_height())
        # 윈도우가 최대화되었는지 확인
            current_size = (app.winfo_width(), app.winfo_height())
            if current_size != app.last_window_size:
                app.last_window_size = current_size
                if app.state() == 'zoomed':
                    self.hidden_frame.configure(width=round(360 * (app.dpi /100), 0))
                    if app.dpi >= 100 and app.dpi < 125 : offset = 10
                    elif app.dpi >= 125 and app.dpi < 150 : offset = 5
                    elif app.dpi >= 150: offset = 0
                    main_window_size = round(app.winfo_width() / (app.dpi /100), 0) - 860 + offset
                    self.right_frame.configure(width=main_window_size - (120+ offset))
                    self.image_label.grid_forget()
                    self.image_label_under_frame.grid_forget()

                    #와이드 해상도 대응을 위해 다음 전략으로 진행. 기존 uI 파괴 후 재할당
                    self.image_history_sub_frame.destroy()
                    self.image_history_sub_frame = customtkinter.CTkFrame(self, width=(120+ offset), height=550, fg_color="#333333")
                    self.image_history_sub_frame.grid(row=0, column=2,rowspan=15, sticky="n")
                    self.image_history_button_down.destroy()
                    self.image_history_button_up.destroy()
                    self.image_history_button_up = customtkinter.CTkButton(self.image_history_sub_frame, text="▲", width=100, font=my_font, state="disabled", command=up_button_pressed)
                    self.image_history_button_up.grid(row=0, column=0, pady=10, padx=5, sticky="n")
                    self.history_export.destroy()
                    self.image_label.grid(row=0, column=0,rowspan=14, padx=10, pady=5, sticky="w")
                    self.hidden_frame.grid(row=0, column=3,rowspan=14, sticky="nsew")

                    self.image_history_0 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_0_yield)
                    self.image_history_0.grid(row=1, column=0, padx=5, pady=1, sticky="n")
                    self.image_history_1 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_1_yield)
                    self.image_history_1.grid(row=2, column=0, padx=5, pady=1, sticky="n")
                    self.image_history_2 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_2_yield)
                    self.image_history_2.grid(row=3, column=0, padx=5, pady=1, sticky="n")
                    self.image_history_3 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_3_yield)
                    self.image_history_3.grid(row=4,column=0, padx=5, pady=1, sticky="n")
                    self.image_history_4 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",  image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_4_yield)
                    self.image_history_4.grid(row=5, column=0, padx=5, pady=1, sticky="n")
                    self.image_history_button_down = customtkinter.CTkButton(self.image_history_sub_frame, text="▼", width=100, font=my_font, state="disabled", command=down_button_pressed)
                    self.image_history_button_down.grid(row=6, column=0, pady=5, padx=5, sticky="n")
                    self.history_export = customtkinter.CTkButton(self.image_history_sub_frame, text="+ FAV (☆)", width=100, fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", font=my_font, command=history_export, state="disabled")
                    self.history_export.grid(row=7, column=0, pady=5, padx=5, sticky="n")

                    self.random_artist_button = customtkinter.CTkCheckBox(self.hidden_frame, text="랜덤작가 추가", variable=self.random_artist_var, font=my_font, state="disabled")
                    self.random_artist_button.grid(row=0, column=0,pady=5, padx=5, sticky="nsew")
                    self.seed_fix_button = customtkinter.CTkCheckBox(self.hidden_frame, text="시드고정 ", variable=self.seed_fix_var, font=my_font)
                    self.seed_fix_button.grid(row=1, column=0,pady=5, padx=5, sticky="nsew")
                    self.seed_entry = customtkinter.CTkEntry(self.hidden_frame, textvariable=self.entry_seed_value)
                    self.seed_entry.grid(row=1, column=1,pady=5, padx=5, sticky="nsew")
                    if app.app_mode == "NAI":
                        self.random_artist_manage_button2 = customtkinter.CTkButton(self.hidden_frame, text="랜덤작가 관리", font=my_font, command=random_artist_wrapper)
                        self.random_artist_manage_button2.grid(row=0, column=1,pady=5, padx=5, sticky="nsew")
                    else:
                        self.random_artist_manage_button2 = customtkinter.CTkButton(self.hidden_frame, text="랜덤작가 관리", font=my_font, command=lambda: self.random_artist_window())
                        self.random_artist_manage_button2.grid(row=0, column=1,pady=5, padx=5, sticky="nsew")                        
                    self.random_resolution_button2 = customtkinter.CTkCheckBox(self.hidden_frame, text="랜덤 해상도", variable=self.random_resolution_var, font=my_font)
                    self.random_resolution_button2.grid(row=3, column=0,pady=5, padx=5, sticky="nsew")
                    self.resolution_button2 = customtkinter.CTkComboBox(self.hidden_frame, width=160,values=self.resolutions, variable=self.resolution_var, font=my_font)
                    self.resolution_button2.grid(row=3, column=1, padx=5, sticky="w")
                    self.sampler_label2 = customtkinter.CTkLabel(self.hidden_frame, text="Sampler :", font=my_font)
                    self.sampler_label2.grid(row=4, column=0,pady=5, padx=5, sticky="w")
                    self.sampler_button2 = customtkinter.CTkComboBox(self.hidden_frame, width=160,values=["k_euler + native", "k_euler + karras", "k_euler + exponential", "k_euler_ancestral + native", "k_euler_ancestral + karras", "k_euler_ancestral + exponential", "k_dpmpp_2s_ancestral + native", "k_dpmpp_2s_ancestral + karras",  "k_dpmpp_2s_ancestral + exponential", "k_dpmpp_sde + native", "k_dpmpp_sde + karras", "k_dpmpp_sde + exponential", "k_dpmpp_2m_sde + native", "k_dpmpp_2m_sde + karras", "k_dpmpp_2m_sde + exponential"] if self.app_mode == "NAI" else NAIA_utils.get_sampler_list(self.access_token), variable=self.sampler_var, font=my_font)
                    self.sampler_button2.grid(row=4, column=1, columnspan=2, pady=5, padx=5, sticky="e")
                    self.cfg_scale_label2 = customtkinter.CTkLabel(self.hidden_frame, text="CFG Scale : ", font=my_font)
                    self.cfg_scale_label2.grid(row=5, column=0,pady=5, padx=5, sticky="w")
                    self.cfg_scale_entry2 = customtkinter.CTkEntry(self.hidden_frame, width=65, textvariable=self.cfg_scale_var)
                    self.cfg_scale_entry2.grid(row=5, column=1,pady=5, padx=5, sticky="w")
                    if self.app_mode == "NAI":
                        self.prompt_guidance_rescale_label2 = customtkinter.CTkLabel(self.hidden_frame, text="P.Guide Rescale :", font=my_font)
                        self.prompt_guidance_rescale_label2.grid(row=6, column=0, pady=5, padx=5, sticky="w")
                        self.prompt_guidance_rescale_entry2 = customtkinter.CTkEntry(self.hidden_frame, width=65, textvariable=self.prompt_guidance_rescale_var)
                        self.prompt_guidance_rescale_entry2.grid(row=6, column=1,pady=5, padx=5, sticky="w")
                        self.sema_button2 = customtkinter.CTkCheckBox(self.hidden_frame, text="SEMA", variable=self.sema_button_var,font=my_font)
                        self.sema_button2.grid(row=7, column=0, pady=5, padx=5, sticky="w")
                        self.dyn_button2 = customtkinter.CTkCheckBox(self.hidden_frame, text="SEMA+DYN", variable=self.dyn_button_var, font=my_font)
                        self.dyn_button2.grid(row=7, column=1, pady=5, padx=5, sticky="w")
                    else:
                        self.prompt_guidance_rescale_label2 = customtkinter.CTkLabel(self.hidden_frame, text="Steps :", font=my_font)
                        self.prompt_guidance_rescale_label2.grid(row=6, column=0, pady=5, padx=5, sticky="w")
                        self.prompt_guidance_rescale_entry2 = customtkinter.CTkEntry(self.hidden_frame, width=65, textvariable=self.prompt_guidance_rescale_var)
                        self.prompt_guidance_rescale_entry2.grid(row=6, column=1,pady=5, padx=5, sticky="w")
                        self.sema_button2 = customtkinter.CTkCheckBox(self.hidden_frame, text="고해상도 보정", variable=self.sema_button_var,font=my_font)
                        self.sema_button2.grid(row=7, column=0, pady=5, padx=5, sticky="w")
                        self.dyn_button2 = customtkinter.CTkCheckBox(self.hidden_frame, text="SEMA+DYN", variable=self.dyn_button_var, font=my_font)
                        #self.dyn_button2.grid(row=7, column=1, pady=5, padx=5, sticky="w")
                    self.open_save_folder2 = customtkinter.CTkButton(self.hidden_frame, text="폴더 열기", font=my_font, fg_color="transparent", command=lambda: open_file_explorer(self), width=80)
                    self.open_save_folder2.grid(row=5, column=1,padx=5, pady=5, sticky="e")
                    self.extra_setting_button2 = customtkinter.CTkButton(self.hidden_frame, width=80, text="기타설정", font=my_font, fg_color="grey", hover_color="grey5", command=lambda: show_advanced_settings(self))
                    self.extra_setting_button2.grid(row=6, column=1,pady=5, padx=5, sticky="e")
                    self.recommended_prompt_button2 = customtkinter.CTkButton(self.hidden_frame, text="추천 프롬프트", font=my_font,  command= self.open_prompt_window)
                    self.recommended_prompt_button2.grid(row=9, column=0, columnspan=2, pady=5, padx=5, sticky="nsew")
                    self.wildcard_manager_button2 = customtkinter.CTkButton(self.hidden_frame, text="와일드카드 관리", font=my_font, command=self.open_wildcard_window)
                    self.wildcard_manager_button2.grid(row=10, column=0,columnspan=2, pady=5, padx=5, sticky="nsew")
                    self.character_search_button2 = customtkinter.CTkButton(self.hidden_frame, text="캐릭터 검색", fg_color="#7030A0", hover_color="#481F67", font=my_font, command= lambda: open_Character_search(self, self.character_search_button2))
                    self.character_search_button2.grid(row=11, column=0,columnspan=2, pady=5, padx=5, sticky="nsew")
                    self.window_label.grid_forget()
                    self.window_label = customtkinter.CTkLabel(self.hidden_frame, text=str(self.window)+" / "+ str(len(self.image_queue)), font=my_font)
                    self.window_label.grid(row=12, column=0,padx=5, pady=5, sticky="w")
                    self.request_upper_size_button2 = customtkinter.CTkButton(self.hidden_frame, text="img2img / inpaint",fg_color="transparent", hover_color="grey10", text_color="#FFFF97", font=my_font,  command=lambda: img2img(self), width=110)
                    self.request_upper_size_button2.grid(row=12, column=1,padx=5, pady=5, sticky="nsew")
                    window_height_size = round(app.winfo_height() / (app.dpi /100), 0) - 50 + offset

                    self.wide_res_width = main_window_size-150
                    self.wide_res_height = window_height_size
                                
                    if self.image_queue:
                        update()
                        if self.current_window:
                            current_image = Image.open(self.image_queue[self.current_window][3])
                        else:
                            current_image = Image.open(self.image_queue[self.window-1][3])
                        new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                        instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                        self.image_label.configure(image=instant_result_image)
                    else:
                        self.image_label.configure(image=customtkinter.CTkImage(white_image, size=(main_window_size-150, window_height_size)))
                else:
                    self.right_frame.configure(width=768)
                    self.image_label_report.grid_forget()
                    self.image_label.grid_forget()
                    self.image_label_under_frame.grid_forget()
                    self.image_history_sub_frame.destroy()
                    self.image_history_button_up = customtkinter.CTkButton(self.image_history_frame, text="▲", width=100, font=my_font, state="disabled", command=up_button_pressed)
                    self.image_history_button_up.grid(row=0, column=1, pady=10, padx=5, sticky="n")
                    self.image_history_sub_frame = customtkinter.CTkFrame(self.image_history_frame, width=100, height=550)
                    self.image_history_sub_frame.grid(row=1, rowspan=12, column=1, sticky="n")
                    self.image_history_0 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_0_yield)
                    self.image_history_0.grid(row=0, column=1, padx=5, pady=1, sticky="n")
                    self.image_history_1 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_1_yield)
                    self.image_history_1.grid(row=1, column=1, padx=5, pady=1, sticky="n")
                    self.image_history_2 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_2_yield)
                    self.image_history_2.grid(row=2, column=1, padx=5, pady=1, sticky="n")
                    self.image_history_3 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent", image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_3_yield)
                    self.image_history_3.grid(row=3,column=1, padx=5, pady=1, sticky="n")
                    self.image_history_4 = customtkinter.CTkButton(self.image_history_sub_frame, width=100, height=100, corner_radius=8,text="", fg_color="transparent",  image=customtkinter.CTkImage(black_image, size=(100,100)), command=image_history_4_yield)
                    self.image_history_4.grid(row=4, column=1, padx=5, pady=1, sticky="n")
                    self.image_history_button_down = customtkinter.CTkButton(self.image_history_frame, text="▼", width=100, font=my_font, state="disabled", command=down_button_pressed)
                    self.image_history_button_down.grid(row=13, column=1, pady=5, padx=5, sticky="n")
                    self.history_export = customtkinter.CTkButton(self.image_history_frame, text="+ FAV (☆)", width=100, fg_color="#F5F3C2", hover_color="#A69F40", text_color="black", font=my_font, command=history_export, state="disabled")
                    self.history_export.grid(row=14, column=1, pady=10, padx=5, sticky="n")
                    self.image_label.grid(row=1, column=0, rowspan=14, padx=10, pady=5, sticky="w")
                    #self.random_artist_manage_button = customtkinter.CTkButton(self.extended_right_frame, text="랜덤작가 관리", font=my_font, command=random_artist_wrapper)
                    #self.random_artist_manage_button.grid(row=1, column=1,pady=5, padx=5, sticky="nsew")
                    self.image_label_under_frame.grid(row=0, column=0, padx=10, pady=5, sticky="ew")
                    if self.display_scale > 150: self.image_label_report.grid(row=19, column=0, columnspan=7, padx=10, pady=5, sticky="ew")
                    else: self.image_label_report.grid(row=17, column=0, columnspan=7, padx=10, pady=5, sticky="ew")
                    self.hidden_frame.grid_forget()
                    self.window_label.grid_forget()
                    self.window_label = customtkinter.CTkLabel(self.image_label_under_frame, text=str(self.window)+" / "+ str(len(self.image_queue)), font=my_font)
                    self.window_label.grid(row=0, column=4,padx=5, pady=5, sticky="w")
                    
                    if self.image_queue:
                        update()
                        if self.current_window:
                            self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.current_window][0], size=(620,620)))
                        else:
                            self.image_label.configure(image=customtkinter.CTkImage(self.image_queue[self.window-1][0], size=(620,620)))
                    else:
                        self.image_label.configure(image=customtkinter.CTkImage(white_image, size=(620, 620)))
                app.last_window_size_conf =  datetime.now()
        
        self.bind("<Configure>", on_window_resize)

        def on_ctrl_press(event):
            self.control_pressed = True
            self.search_button.configure(text="심층 검색")
            self.image_history_button_up.configure(text="▲ (Top)")
            self.image_history_button_down.configure(text="▼ (100)")
            if self.app_mode == "WEBUI" and self.i2i_automatic_NAI_var.get() == 1: self.request_upper_size_button.configure(text="img2img (*NAI*)", text_color="#FD8853")
            else: self.request_upper_size_button.configure(text="Enhance / INST i2i", text_color="#FD8853")
            self.history_export.configure(text=f"export ({len(self.image_queue)})", fg_color="#1F6AA5", hover_color="#144870", text_color="#DCE4EE")
            if self.generation_queue:
                self.image_generation_button.configure(text="생성 예약 큐 비우기", text_color="black")
            if self.image_queue:
                self.history_export.configure(state="normal")
            else:
                self.history_export.configure(state="disabled")
            if type(self.current_popped_row) != type(None) and not self.current_popped_row.empty:
                self.random_function_button.configure(text="프롬프트 재개봉", text_color="#FFFF97")
            if self.app_mode == "WEBUI":
                self.nai_i2i_button.configure(text="Open NAI I2I", fg_color="#ED7D31", hover_color="#CC5D12")
                self.random_artist_manage_button.configure(text="이벤트 제너레이션", fg_color="grey10")
            if app.state() == 'zoomed':
                self.request_upper_size_button2.configure(text="Enhance / INST i2i", text_color="#FD8853")
            if self.app_mode == "NAI" and self.NAI_webui_address and self.image_queue:
                self.random_artist_manage_button.configure(text="⬆ WEBUI ADetailer i2i", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black")
            if self.app_mode == "NAI" and self.image_queue:
                self.open_in_file_explorer.configure(text="Upscale", text_color="white")

        def on_ctrl_release(event):
            self.control_pressed = False
            self.search_button.configure(text="검색")
            self.image_history_button_up.configure(text="▲")
            self.image_history_button_down.configure(text="▼")
            self.request_upper_size_button.configure(text="img2img / inpaint", text_color="#FFFF97")
            self.history_export.configure(text="+ FAV (☆)", fg_color="#F5F3C2", hover_color="#A69F40", text_color="black")
            self.random_function_button.configure(text="랜덤/다음 프롬프트", text_color="#DCE4EE")
            if self.generation_queue or (not (self.automation_button.get()==1 or self.turbo_button.get()==1) and self.running_flag):  self.image_generation_button.configure(text=f"생성 큐에 삽입 ({len(app.generation_queue)})", text_color="#DCE4EE")
            elif self.app_mode == "NAI": self.image_generation_button.configure(text="NAI 이미지 생성", text_color="#DCE4EE")
            else: self.image_generation_button.configure(text="WEBUI 생성 요청", text_color="#DCE4EE")
            if self.image_queue and len(self.image_queue[self.current_window]) >= 5:
                self.history_export.configure(state="normal")
            else:
                self.history_export.configure(state="disabled")
            if self.app_mode == "WEBUI":
                self.nai_i2i_button.configure(text="⬆ NAI I2I", fg_color="#F5F3C2", hover_color="#A69F40")
                self.random_artist_manage_button.configure(text="랜덤작가 관리", fg_color="#1F6AA5")
            if app.state() == 'zoomed':
                self.request_upper_size_button2.configure(text="img2img / inpaint", text_color="#FFFF97")
            if self.app_mode == "NAI" and self.NAI_webui_address:
                self.random_artist_manage_button.configure(text="랜덤작가 관리", fg_color="#1F6AA5", hover_color="#144870", text_color="#DCE4EE")
            if self.app_mode == "NAI":
                self.open_in_file_explorer.configure(text="파일위치열기", text_color="#D7DFE8")

        self.alt_pressed = False
        def on_alt_press(event):
            self.alt_pressed = True
            #self.search_button.configure(text="심층 검색")

        def on_alt_release(event):
            self.alt_pressed = False
            #self.search_button.configure(text="검색")

        def on_escape(event=None):
            self.focus_set()
        self.bind('<Escape>', on_escape)

        self.control_pressed = False
        self.bind_all("<Control_L>", on_ctrl_press)
        self.bind_all("<KeyRelease-Control_L>", on_ctrl_release)
        self.bind_all("<Alt_L>", on_alt_press)
        self.bind_all("<KeyRelease-Alt_L>", on_alt_release)
        self.bind('<Control-c>', copy_file)
        self.last_window_size = None
        self.random_artist_select = "global"
        self.random_artist_list_length = 0
        self.protocol("WM_DELETE_WINDOW", lambda: (self.Automation_setting.destroy()))
        self.wildcard_dict = None
        self.wildacrds_dir = ""

        self.i2i_vibe_ie = 0.8
        self.i2i_vibe_rs = 0.55
        self.i2i_cfg = self.cfg_scale_var.get()
        self.i2i_rescale = self.prompt_guidance_rescale_var.get()
        self.i2i_instant_text = ""
        self.i2i_instant_change = ""
        self.i2i_auto_vibe = False
        self.img2img_window = None
        self.image_swap_filename = ""
        self.i2i_result_image_view_var = customtkinter.IntVar()
        self.i2i_automatic_NAI_var = customtkinter.IntVar()
        self.e621_values = None
        self.e621_dict = None

        def resize_and_fill(image, max_size=None):
            if max_size is None:
                max_size = 768
            original_width, original_height = image.size
            if original_width > max_size or original_height > max_size:
                # 비율을 유지하면서 크기 조정
                image.thumbnail((max_size, max_size))

                # 새 이미지 크기 계산
                width, height = image.size
                new_image = Image.new("RGB", (max_size, max_size), "black")
                new_image.paste(image, ((max_size - width) // 2, (max_size - height) // 2))
                return new_image
            else:
                return image

        def on_arrow_key(event):
            key_pressed = event.keysym
            #self.focus_set()
            if key_pressed == "Up" and self.image_history_button_up.cget("state") == "normal":
                up_button_pressed()
            elif key_pressed == "Up":
                if not self.control_pressed and self.what_i_clicked != 0:
                    if self.what_i_clicked == 1: image_history_0_yield()
                    elif self.what_i_clicked == 2: image_history_1_yield()
                    elif self.what_i_clicked == 3: image_history_2_yield()
                    elif self.what_i_clicked == 4: image_history_3_yield()
            elif key_pressed == "Down" and self.image_history_button_down.cget("state") == "normal":
                down_button_pressed()
            elif key_pressed == "Down":
                if not self.control_pressed and self.what_i_clicked != 4:
                    if self.what_i_clicked == 0: image_history_1_yield()
                    elif self.what_i_clicked == 1: image_history_2_yield()
                    elif self.what_i_clicked == 2: image_history_3_yield()
                    elif self.what_i_clicked == 3: image_history_4_yield()


        def img2img(self):
            if self.control_pressed: 
                instant_img2img(self, app.access_token)
                self.control_pressed = False
            else: 
                global img2img_window
                if self.img2img_window is not None:
                    self.img2img_window.destroy()
                    self.img2img_window = None
                    img2img_window = None
                _img2img(self)

        def _img2img(self, import_img=None, _contents=None, _from = None, _filename = None, _event = None):
            global iimg, img2img_window, inpaint_mode, global_brush_size, original_image

            def has_transparency(img):
                if img.mode != 'RGBA':
                    return False

                # 알파 채널만 추출 (A)
                alpha_channel = img.split()[-1]
                
                # 알파 채널에서 255가 아닌 값이 하나라도 있으면 True 반환
                for pixel in alpha_channel.getdata():
                    if pixel < 255:
                        return True
                return False

            def instant_image_generation(self, current_lookup, i2irf=None, token=app.access_token):
                try:
                    img2img_window.attributes('-topmost', False)
                except:
                    pass
                def image_to_base64(image):
                    image_bytesIO = io.BytesIO()
                    img.save(image_bytesIO, format="png")
                    return base64.b64encode(image_bytesIO.getvalue()).decode()
                def mask_to_base64(image):
                    # PIL.Image 객체를 넘파이 배열로 변환
                    i = np.array(image)
                    # RGBA 채널 처리를 위해 알파 채널 추가 전 이미지 처리
                    if i.shape[-1] == 3:  # RGB 이미지인 경우
                        alpha = np.sum(i, axis=-1) > 0  # 알파 마스크 생성
                        alpha = np.uint8(alpha * 255)  # 알파 채널 값으로 변환
                        rgba = np.dstack((i, alpha))  # RGBA 이미지 생성
                    elif i.shape[-1] == 4:  # 이미 RGBA 이미지인 경우
                        rgba = i
                    else:
                        raise ValueError("Unsupported image format")

                    # 넘파이 배열에서 PIL.Image 객체로 변환
                    img = Image.fromarray(rgba)
                    
                    # PIL.Image 객체를 Base64 문자열로 변환
                    image_bytesIO = io.BytesIO()
                    img.save(image_bytesIO, format="png")
                    return base64.b64encode(image_bytesIO.getvalue()).decode()
                
                try:
                    i2i_generate_button.configure(state="disabled")
                    if app.app_mode == "WEBUI": i2i_generate_button2.configure(state="disabled")
                    if i2i_repeat.get() == 1 and int(i2i_repeat_count_var.get()) > 0:
                        i2i_repeat_count_var.set(int(i2i_repeat_count_var.get()) - 1)
                except:
                    pass
                try:
                    request_prompt = i2i_text_input.get("0.0", "end")
                except:
                    request_prompt = self.text_input.get("0.0", "end")
                try:
                    request_seed = current_lookup[2]
                    filename = current_lookup[3] if _from != "outpaint" else "tempimage.png"
                except:
                    current_lookup = self.image_queue[self.current_window].copy()
                    request_seed = current_lookup[2]
                    filename = current_lookup[3]
                img = Image.open(filename)
                inpaint_check = sum(sum(row) for row in mirror_image) >= 50
                _cwidth, _cheight = cwidth, cheight
                nw, nh = img.size
                if radio_var.get() != 0 and"http" not in token and inpaint_check:
                    new_width, target_height = find_max_resolution(nw, nh, 1048576)
                    img = img.resize((new_width, target_height), Image.Resampling.LANCZOS)
                    _cwidth, _cheight = img.size
                send_image = image_to_base64(img)
                scale_pre = self.cfg_scale_entry.get()
                try:
                    steps = request_upper_size_steps.get()
                except:
                    steps = 28
                try:
                    scale_pre = float(scale_pre)
                except:
                    scale_pre = 5.0
                    self.cfg_scale_var.set("5.0")
                rescale_pre = self.prompt_guidance_rescale_entry.get()
                try:
                    rescale_pre = float(rescale_pre)
                except:
                    rescale_pre = 0
                    self.prompt_guidance_rescale_var.set("0")
                try:
                    steps = int(steps)
                except:
                    steps = 28
                    self.cfg_scale_var.set("28")
                uncond_pre = self.uncond_strength_entry.get()
                try:
                    uncond_pre = float(uncond_pre)
                    #uncond_pre = round(uncond_pre / 0.05) * 0.05
                    if (uncond_pre > 162):
                        uncond_pre = 19.19
                        self.uncond_strength_entry.delete(0, "end")
                        self.uncond_strength_entry.insert(0, "19.19")
                except:
                    uncond_pre = 1.0
                    self.uncond_strength_entry.delete(0, "end")
                    self.uncond_strength_entry.insert(0, "19.19")
                try:
                    i2i_negative_text = i2i_negative_input.get("0.0", "end-1c")
                except:
                    i2i_negative_text = self.negative_prompt_input.get("0.0", "end-1c")
                if ' + ' in app.sampler_button.get():
                    _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
                else:
                    _sampler = app.sampler_button.get()
                    _noise_schedule = "native"
                gen_request = {
                        "width":self.i2i_width if not inpaint_check else _cwidth ,
                        "height":self.i2i_height if not inpaint_check else _cheight,
                        "quality_toggle":app.auto_quality_toggle_var.get(),
                        "seed":request_seed if self.i2i_seed_hold_check == True else random.randint(0,2**32 - 1),
                        "sampler":_sampler,
                        "noise_schedule": _noise_schedule,
                        "scale":scale_pre,
                        "uncond_scale":uncond_pre,
                        "sema":self.sema_button.get(),
                        "sema_dyn": self.dyn_button.get(),
                        "cfg_rescale": rescale_pre,
                        "prompt": request_prompt,
                        "negative":i2i_negative_text,
                        "user_screen_size": self.get_max_size(),
                        "start_time": self.start_time,
                        "access_token": token,
                        "save_folder": self.output_file_path,
                        "png_rule": self.name_var.get(),
                        "type": "upper" if not inpaint_check else "inpaint",
                        "steps": steps if steps <= 50 else 50,
                        "image": send_image,
                        "enable_hr" : False,
                        "enable_AD" : False
                    }
                if int(gen_request["width"]) * int(gen_request["height"]) > 1048576 and app.app_mode == "NAI":
                    app.image_label_report.configure(state="normal")
                    app.image_label_report.delete("0.0", "end")
                    app.image_label_report.insert("0.0", "<UserAttention> Anlas가 소모되는 해상도 요청입니다.")
                    app.image_label_report.configure(text_color="#FFFF97")
                    app.image_label_report.configure(state="disabled")
                    app.anlas_request = True
                if app.app_mode == "NAI" and app.variety_button.get() == 1:
                    gen_request["skip_cfg_above_sigma"] = True
                if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                    gen_request["dynamic_thresholding"] = True
                if app.app_mode == "NAI": 
                    gen_request["steps"] = int(app.force_steps_entry.get())
                    if gen_request["steps"] > 28: self.anlas_request = True
                if app.app_mode == "WEBUI" and self.sema_button_var.get() == 1:
                    try:
                        hr_steps_pre = int(self.hires_steps_entry.get())
                    except:
                        hr_steps_pre = 16
                        self.hires_steps_entry.delete(0, "end")
                        self.hires_steps_entry.insert(0, '16')
                    try:
                        upscale_pre = float(self.upscale_entry.get())
                        upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                    except:
                        upscale_pre = 1.5
                    self.upscale_entry.delete(0, "end")
                    self.upscale_entry.insert(0, str(upscale_pre))
                    try:
                        denoise_pre = float(self.denoise_entry.get())
                    except:
                        denoise_pre = 0.35
                        self.denoise_entry.delete(0, "end")
                        self.denoise_entry.insert(0, '0.35')
                    gen_request["enable_hr"] = True
                    gen_request["hr_second_pass_steps"] = hr_steps_pre
                    gen_request["hr_upscaler"] = self.hires_sampler_entry.get()
                    gen_request["hr_scale"] = upscale_pre
                    gen_request["denoising_strength"] = denoise_pre
                if self.awai_activate_i2i.get() == 1:
                    gen_request["enable_AD"] = True
                    ad_str_pre = self.autodetailer_strength.get()
                    try:
                        ad_str_pre = float(ad_str_pre)
                        ad_str_pre = round(ad_str_pre, 2)
                    except:
                        ad_str_pre = 0.4
                        self.autodetailer_strength.delete(0, "end")
                        self.autodetailer_strength.insert(0, "0.4")
                    gen_request["ad_data_str"] =  ad_str_pre
                if app.app_mode == "WEBUI" and app.enable_cfg_rescale.get() == 1:
                    gen_request["CFG_rescale"] = True
                    cfg_str_pre = app.enable_cfg_rescale_strength.get()
                    try:
                        cfg_str_pre = float(cfg_str_pre)
                        cfg_str_pre = round(cfg_str_pre, 2)
                    except:
                        cfg_str_pre = 0.5
                        app.enable_cfg_rescale_strength.delete(0, "end")
                        app.enable_cfg_rescale_strength.insert(0, "0.5")
                    gen_request["CFG_rescale_str"] =  cfg_str_pre
                    gen_request["CFG_rescale_version"] = "normal" if app.enable_cfg_rescale_old.get() == 0 else "old"
                if app.app_mode == "WEBUI" and app.custom_script_activate_var.get() == 1: gen_request['custom_script'] = app.custom_script_text.get("1.0", "end-1c").strip()    
                if app.app_mode == "WEBUI" and app.enable_DT.get() == 1:
                    gen_request["DynamicThresholding"] = True
                if i2irf and i2irf["image_reference"]:
                    gen_request["reference_image"] = i2irf["image_reference_string"]
                    gen_request["reference_information_extracted"] = round(i2irf["ie"], 2)
                    gen_request["reference_strength"] = round(i2irf["irs"], 2)
                if not inpaint_check:
                    gen_request["strength"] = round(self.i2i_value, 2) #self.i2i_noise
                    gen_request["noise"] = round(self.i2i_noise, 2)
                if app.app_mode == "WEBUI" and inpaint_check:
                    gen_request["strength"] = round(self.i2i_value, 2)
                    gen_request["noise"] = 0
                if gen_request["type"] == "inpaint":
                    mask_mode = reverse_mask.get() == 1
                    if app.app_mode == "NAI": gen_request["mask"] = mask_to_base64(create_and_save_mask_image('nai', mask_mode))
                    else: gen_request["mask"] = mask_to_base64(create_and_save_mask_image('webui', mask_mode))
                    gen_request["add_original_image"] = True if overlay_original_image_var.get()==1 else False

                def run_generation():
                    if gen_request["png_rule"] == "count":
                        self.generation_count += 1
                        gen_request["count"] =self.generation_count
                    self.state_label.configure(text ="state : img2img 요청됨 ", text_color = "#FFFF97")
                    if app.save_folder_option and app.save_folder_option["isEnabled"]:
                        if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                        if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                            app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                        elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                        else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                        try:
                            gen_request["additional_save_folder"] = { 
                                "command1": app.save_folder_additional_name["command1"],
                                "command2": app.save_folder_additional_name["command2"]
                                }
                        except:
                            gen_request["additional_save_folder"] = { 
                                "command1": "",
                                "command2": ""
                                }                     
                        app.save_folder_additional_name = {}
                    try:
                        if app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                        if app.anlas_request and app.access_token_muiti:
                            if app.my_anlas.get() > app.my_anlas_multi.get(): 
                                gen_request["access_token"] = app.access_token
                            else:gen_request["access_token"] = app.access_token_muiti
                        if current_nai.get() == "NAID4" or current_nai.get() == "NAID4-Curated":
                            nai4_character_list = []
                            nai4_character_uc_list = []
                            _ix = 0
                            _ctext = ""
                            naid4_selected_character_textbox.configure(state = "normal")
                            naid4_selected_character_textbox.delete("0.0", "end")
                            for frame_dict in character_frames:
                                _ix += 1
                                textbox = frame_dict['textbox']  # 각 프레임의 textbox 참조
                                content = textbox.get("0.0", "end")
                                content = [k.strip() for k in content.split(',')]
                                global_content = []
                                if '<' in textbox.get("0.0", "end") or  '__' in textbox.get("0.0", "end") :
                                    wildcard_present = True
                                    itc = 0
                                    while (wildcard_present and  itc < 10):
                                        wildcard_present = False
                                        #### 단계 1 : 인스턴트 와일드카드 처리 ###
                                        for i, keyword in enumerate(content):
                                            if keyword.startswith('<') and keyword.endswith('>') and not keyword.startswith('<lora:'):
                                                wildcard_present = True
                                                vbar_check = keyword[1:-1]
                                                if '|' in vbar_check:
                                                    choices = vbar_check.split('|')  # '|'를 기준으로 split
                                                    choice_dic = {}
                                                    for choice in choices:
                                                        match = re.match(r'(\d*\.?\d+):(.+)', choice)
                                                        if match:
                                                            value, keyword = float(match.group(1)), match.group(2).strip()
                                                        else:
                                                            value, keyword = 1, choice.strip()
                                                        choice_dic[keyword] = value
                                                    keywords = list(choice_dic.keys())
                                                    weights = list(choice_dic.values())
                                                    selected_instant_wildcard = random.choices(keywords, weights=weights, k=1)[0]
                                                    content[i] = selected_instant_wildcard
                                        #### 단계 2 : 글로벌 와일드카드 처리 ###
                                        content = NAIA_random_function_core.process_list(content)
                                        for i, keyword in enumerate(content):
                                            if "<" in keyword and not '<lora:' in keyword and ">" in keyword or '__' in keyword:
                                                wildcard_present = True
                                                input_str = keyword.strip().strip('<>')
                                                if("__" in input_str):
                                                    adjectives = re.findall(r'__(.*?)__', input_str)
                                                    first_keyword, last_keyword = re.split(r'__.*?__', input_str)[0], re.split(r'__.*?__', input_str)[-1]
                                                    if last_keyword:
                                                        split_result = last_keyword.split('>', 1)
                                                        wc_keyword = split_result[0].strip()
                                                        last_keyword = split_result[1].strip() if len(split_result) > 1 else ""
                                                    else: wc_keyword = ""
                                                    adjective_string = ""
                                                    for adjective in adjectives:
                                                        adjective_result = self.get_wildcard_naid4(adjective)
                                                        if adjective_result.startswith(":") and adjective_result:
                                                            if adjective_string: 
                                                                adjective_string = adjective_string.rstrip() + adjective_result  
                                                            else:  
                                                                adjective_string += adjective_result  # 전체 추가
                                                        else:
                                                            adjective_string += adjective_result + " "
                                                    wc_result = self.get_wildcard_naid4(wc_keyword)
                                                    if not wc_result.startswith(":") and wc_result and not wc_result.startswith(")") and not wc_result.startswith("]"): wc_result = ' '+wc_result    
                                                    content[i] = first_keyword + adjective_string.strip() + wc_result + last_keyword
                                                else:
                                                    out_wildcard = app.get_wildcard_naid4(input_str)
                                                    if ',' in out_wildcard:
                                                        split_wc = [item.strip() for item in out_wildcard.split(',')]
                                                        temp = []
                                                        for _key in split_wc[1:]:
                                                            temp.append(_key)
                                                        if temp:
                                                            for _key in temp:
                                                                if _key.startswith('*'):
                                                                    split_wc[split_wc.index(_key)] = _key[1:]
                                                                else:
                                                                    split_wc.remove(_key)
                                                                    global_content.append(_key)
                                                        if len(split_wc) == 2 and '{' not in split_wc[1] and '[' not in split_wc[1] and (split_wc[1].endswith('}') or split_wc[1].endswith(']')):
                                                            wc_post = split_wc[1].replace(']','').replace('}','')
                                                            global_content.append(wc_post)
                                                            split_wc[0] += split_wc[1].replace(wc_post, '')
                                                            split_wc.pop()
                                                        out_wildcard = ', '.join(split_wc)
                                                    content[i] = out_wildcard
                                        itc += 1
                                        if not wildcard_present:
                                            break
                                result_content = ', '.join(content)
                                if content[0] != "girl" and content[0] != "boy":
                                    _ctext += f"{content[0]}, "
                                elif len(content) >= 2:
                                    _ctext += f"{content[1]}, "
                                else:
                                    _ctext += f"null, "
                                if global_content: result_content += ', '+', '.join(global_content)
                                nai4_character_list.append(result_content)
                                _uc = frame_dict['uc'] 
                                _uc = _uc.get("0.0", "end")
                                _uc = [k.strip() for k in _uc.split(',')]
                                uc = ', '.join(_uc)
                                nai4_character_uc_list.append(uc)
                            naid4_selected_character_textbox.insert("0.0", _ctext)
                            naid4_selected_character_textbox.configure(state="disabled")
                            gen_request['characters'] = nai4_character_list
                            gen_request['characters_uc'] = nai4_character_uc_list
                        result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, current_model_nai.get())
                        self.nai_generation_count += 1
                    except:
                        print('Automatically assigned '+app.current_model_nai.get())
                        result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                    afterevinpaint = False
                    if self._evinpaint_flag == True:
                        self._evinpaint_flag = False
                        afterevinpaint = True
                    self.state_label.configure(text =f"img2img 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                    if app.anlas_request: 
                        self.get_anlas()
                        app.anlas_request = False
                    i2i_generate_button.configure(state="normal")
                    if app.app_mode == "WEBUI": i2i_generate_button2.configure(state="normal")
                    if info:
                        temp = naia_functions.extract_prompt_info(info, app.app_mode)
                        if app.app_mode == "NAI" or "https" not in token: temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                    else:
                        temp = result_prompt
                    naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                    if result_image:
                        current_image = Image.open(filename)
                        cw, ch = current_image.size
                        cw = int(cw * (100 / app.dpi))
                        ch = int(ch * (100 / app.dpi))
                        if app.state() != 'zoomed':
                            instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                        else:
                            new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                            instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                        self.image_label.configure(image=instant_result_image)
                        if i2i_result_image_view.get() == 1:
                            img_label_result.grid(row=0, column=1)
                            limit_cw = int(832 * (100 / app.dpi))
                            if cw >= ch:
                                ratio = limit_cw / cw
                                cw = int(cw * ratio)
                                ch = int(ch * ratio)
                            #if app.winfo_screenheight() >= 1152:
                            img_label_result.configure(image=customtkinter.CTkImage(current_image, size=(cw, ch)))
                            if (current_image.size == iimg.size): 
                                app.image_swap_filename = filename
                                image_swap.grid(row=11, column=0, padx=5, pady=5, sticky="nsew")
                        _dic = None
                        try:
                            if  nai4_character_list:
                                _dic = {
                                    "from" : "i2i",
                                    "nai4_character_list" : nai4_character_list,
                                    "nai4_character_uc_list" :nai4_character_uc_list
                                }
                        except: pass
                        set_image_to_queue(result_image, result_prompt, str(result_seed), filename, _dic)
                    if i2i_repeat.get() == 1 and int(i2i_repeat_count_var.get()) > 0:
                        if int(i2i_repeat_count_var.get()) <= 0: 
                            i2i_repeat.deselect()
                        img2img_window.after(1000, instant_image_generation(self, current_lookup, i2irf, token))
                    if afterevinpaint == True:
                        self.img2img_window  = None
                        img2img_window.after(100, close)
                generation_thread = threading.Thread(target=run_generation, daemon=True)
                generation_thread.start()
            
            def find_max_resolution(width, height, max_pixels=2166784, multiple_of=64):
                ratio = width / height

                max_width = int((max_pixels * ratio)**0.5)
                max_height = int((max_pixels / ratio)**0.5)

                max_width = (max_width // multiple_of) * multiple_of
                max_height = (max_height // multiple_of) * multiple_of

                while max_width * max_height > max_pixels:
                    max_width -= multiple_of
                    max_height = int(max_width / ratio)
                    max_height = (max_height // multiple_of) * multiple_of

                return (max_width, max_height)

            def close():
                try:
                    app.i2i_vibe_ie = round(app.i2i_vibe_ie, 2)
                    app.i2i_vibe_rs = round(app.i2i_vibe_rs, 2)
                    app.i2i_rescale = nai_rescale_entry.get()
                    app.i2i_cfg = nai_cfg_entry.get()
                    app.i2i_instant_text = nai_text_entry.get()
                    app.i2i_instant_change = nai_change_entry.get()
                    app.i2i_auto_vibe = True if nai_auto_vibe.get() == 1 else False
                    img2img_window.destroy()
                except:
                    app.img2img_window.destroy()

            img2img_window = customtkinter.CTkToplevel()
            img2img_window.title("img2img")
            img2img_window.attributes('-topmost', True)
            img2img_window.resizable(width=False, height=True)
            self.img2img_window = img2img_window

            if _event and self.evinpaint_withdraw.get():
                img2img_window.withdraw()

            if not import_img or _from=="outpaint":
                if _event:
                    for item in reversed(app.image_queue):
                        if len(item) >= 5:
                            current_lookup = copy.deepcopy(item)
                            break                    
                elif not  _from=="outpaint":
                    try: current_lookup = copy.deepcopy(self.image_queue[self.current_window])
                    except: current_lookup = copy.deepcopy(self.image_queue[self.current_window-1])
                else: 
                    try: 
                        if len(_contents) > 4: current_lookup = [import_img, _contents[1], _contents[2], "tempimage.png"]
                        else: current_lookup = _contents.copy()
                    except: 
                        if 'uc' in _contents: current_lookup = [import_img, _contents["prompt"], _contents["seed"], "tempimage.png"]
                        else: current_lookup = [import_img, "External Image", random.randint(0,2**32 - 1), "tempimage.png"]
                if not _filename: filename = current_lookup[3]
                else: filename = _filename if _from != "outpaint" else "tempimage.png"
                img = Image.open(filename)
                width, height = img.size
                if width * height > 2662400:
                    width, height = find_max_resolution(width, height, 2662400)
                    img = img.resize((width, height), Image.Resampling.LANCZOS)
            else:
                img = import_img
                width, height = img.size
                if width * height > 2662400:
                    width, height = find_max_resolution(width, height, 2662400)
                    img = img.resize((width, height), Image.Resampling.LANCZOS)
                elif width % 64 > 0 or height % 64 > 0:
                    width, height = find_max_resolution(width, height, width*height)
                    img = img.resize((width, height), Image.Resampling.LANCZOS)
                img.save("i2i_temp.png")
                width, height = img.size
                if not _contents: 
                    current_lookup = [import_img, "External Image", random.randint(0,2**32 - 1), "i2i_temp.png"]
                    _contents = current_lookup
                else: current_lookup = [import_img, _contents["prompt"], _contents["seed"], "i2i_temp.png"]
                filename = current_lookup[3]

            extra_width, h = img.size
            if app.is_mac: rwidth = extra_width + 352
            else: rwidth = 542
            img2img_window_left = customtkinter.CTkScrollableFrame(img2img_window)
            img2img_window_left.grid(row=0, column=0, pady=5, padx=5, sticky="nsew")
            img2img_window_right = customtkinter.CTkScrollableFrame(img2img_window, width=rwidth)
            img2img_window_right.grid(row=0, column=2, pady=5, padx=5, sticky="nsew")


            iimg = None
            inpaint_mode = False
            global_brush_size = 5
            if not _contents and import_img: 
                iimg = Image.open(filename)
                if has_transparency(iimg): 
                    iimg = iimg.convert("RGBA")
                else: iimg = iimg.convert("RGB")
            else: iimg = Image.open(filename).convert("RGB") if _from != "outpaint" else import_img.copy()
            _width, _height = iimg.size
            if _width * _height > 2662400:
                _width, _height = find_max_resolution(_width, _height, 2662400)
                iimg = iimg.resize((_width, _height), Image.Resampling.LANCZOS)
            original_image = iimg.copy()
            cwidth, cheight = iimg.size
            current_dpi = app.dpi
            dpi_scale = 100 / current_dpi if not app.is_mac else 1
            window_height = app.winfo_height()
            if window_height * int(current_dpi / 100) >= 1216:
                img2img_window_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=round(cheight * dpi_scale, 0)+2 if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)
            else:
                img2img_window_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=min(cheight, 930) if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)

            # mirror_width와 mirror_height 계산
            mirror_width = _width // 8
            mirror_height = _height // 8
            mirror_image = [[0 for _ in range(mirror_height)] for _ in range(mirror_width)]

            img_label = customtkinter.CTkCanvas(img2img_window_left, width=cwidth, height=cheight)
            img_label.grid(row=0, column=0)
            img_label_result = customtkinter.CTkLabel(img2img_window, text="")

            # 마스크 이미지 생성 및 저장 함수
            def create_and_save_mask_image(option=None, mask_reverse=False):
                # 마스크 이미지 생성: 원본 이미지 크기의 1/8, 투명 배경
                if option == "webui":
                    mask_image = Image.new('RGBA', (width, height), (0, 0, 0, 0))
                else:
                    mask_image = Image.new('RGBA', (mirror_width, mirror_height), (0, 0, 0, 0))
                draw = ImageDraw.Draw(mask_image)
                
                if not mask_reverse:
                    # 이중리스트를 순회하며 value > 0인 위치에 하얀색으로 칠함
                    for x in range(mirror_width):
                        for y in range(mirror_height):
                            if mirror_image[x][y] > 0:
                                if option == "webui":
                                    # option이 "webui"일 때, 8배 영역 채우기
                                    draw.rectangle([x*8, y*8, x*8+7, y*8+7], fill=(255, 255, 255, 255))
                                else:
                                    # 기본 옵션일 때, 단일 픽셀 채우기
                                    draw.point((x, y), fill=(255, 255, 255, 255))
                else:
                    for x in range(mirror_width):
                        for y in range(mirror_height):
                            if mirror_image[x][y] == 0:
                                if option == "webui":
                                    # option이 "webui"일 때, 8배 영역 채우기
                                    draw.rectangle([x*8, y*8, x*8+7, y*8+7], fill=(255, 255, 255, 255))
                                else:
                                    # 기본 옵션일 때, 단일 픽셀 채우기
                                    draw.point((x, y), fill=(255, 255, 255, 255))
                
                # 마스크 이미지를 파일로 저장
                return mask_image

            tk_image = ImageTk.PhotoImage(iimg)
            canvas = img_label
            app.prev_iimg_id = canvas.create_image(0, 0, anchor="nw", image=tk_image)
            canvas.image = tk_image  # 참조를 유지

            def create_custom_cursor():
                brush_size = global_brush_size
                cursor_size = brush_size * 8
                # cursor_size x cursor_size 투명 이미지 생성
                cursor_image = Image.new("RGBA", (cursor_size, cursor_size), (0, 0, 0, 0))
                draw = ImageDraw.Draw(cursor_image)
                # 1px 하얀색 테두리 그리기
                draw.rectangle([0, 0, cursor_size - 1, cursor_size - 1], outline=(255, 255, 255, 255))
                return cursor_image

            # 마우스 이동 이벤트에 대한 핸들러
            def on_mouse_move(event):
                # 이전에 그려진 커스텀 커서가 있다면 삭제
                canvas.delete("custom_cursor")
                # 마우스 위치에 커스텀 커서 이미지를 표시
                cursor_image = create_custom_cursor()
                tk_cursor_image = ImageTk.PhotoImage(cursor_image)
                # canvas에 커스텀 커서 이미지 렌더링. 이 때, 'tags' 옵션을 사용하여 태그를 지정
                canvas.create_image(event.x, event.y, image=tk_cursor_image, anchor="center", tags="custom_cursor")
                # 커스텀 커서 이미지의 참조를 별도로 유지
                canvas.cursor_image = tk_cursor_image

            # 마우스 이동 이벤트 바인딩
            canvas.bind("<Motion>", on_mouse_move)

            def wheel_up():
                global global_brush_size
                if global_brush_size < 15:
                    global_brush_size += 2

            def wheel_down():
                global global_brush_size
                if global_brush_size > 1:
                    global_brush_size -= 2

            def wheel_up_down(event):
                if event.num == 5 or event.delta == -120: wheel_down()
                else: wheel_up()
                on_mouse_move(event)

            canvas.bind("<MouseWheel>", wheel_up_down)

            def inpaint_check():
                global inpaint_mode
                check =  sum(sum(row) for row in mirror_image) >= 50
                if(check and not inpaint_mode):
                    inpaint_mode = True
                    i2i_slider_frame.grid_forget()
                    i2i_inpaintr_frame.grid(row=5, column=0, columnspan=3, pady=5, padx=5, sticky="n")
                    #if current_nai.get() == "NAID4": naid4_characters_frame.grid_forget()
                elif(inpaint_mode and not check):
                    inpaint_mode = False
                    i2i_slider_frame.grid(row=5, column=0, pady=5, padx=5, sticky="nsew")
                    i2i_inpaintr_frame.grid_forget()
                    #if current_nai.get() == "NAID4": naid4_characters_frame.grid(row=7, column=0, pady=5, sticky="nsew")
                    
            def update_canvas_image():
                global tk_image  # 전역 변수 사용
                tk_image = ImageTk.PhotoImage(iimg)
                canvas.create_image(0, 0, anchor="nw", image=tk_image, tags="original_image")  # 'tags' 옵션을 사용하여 태그 지정
                canvas.image = tk_image  # 원본 이미지 참조 업데이트

            def on_canvas_click_or_move(event):
                x, y = event.x // 8, event.y // 8
                paint_on_image(x, y)
                update_canvas_image()

            def paint_on_image(x, y):
                draw = ImageDraw.Draw(iimg, 'RGBA')
                # brush_size에 따라 페인트 칠할 범위를 동적으로 설정
                brush_size = global_brush_size
                half_brush = brush_size // 2
                for i in range(max(0, x - half_brush), min(mirror_width, x + half_brush + 1)):
                    for j in range(max(0, y - half_brush), min(mirror_height, y + half_brush + 1)):
                        mirror_image[i][j] += 1  # 마스크 업데이트
                        if mirror_image[i][j] == 1:  # 마스크 값이 0보다 큰 경우에만 페인트 칠함
                            draw.rectangle([(i*8, j*8), ((i+1)*8-1, (j+1)*8-1)], fill=(0, 0, 255, 128))
                inpaint_check()

            def remove_paint_from_image(x, y):
                global iimg, original_image
                # brush_size에 따라 페인트 제거할 범위를 동적으로 설정
                brush_size = global_brush_size
                half_brush = brush_size // 2
                for i in range(max(0, x - half_brush), min(mirror_width, x + half_brush + 1)):
                    for j in range(max(0, y - half_brush), min(mirror_height, y + half_brush + 1)):
                        mirror_image[i][j] = 0  # 마스크 값을 0으로 설정
                        
                        # 원본 이미지에서 해당 영역의 픽셀 값을 가져옴
                        original_pixels = original_image.load()
                        current_pixels = iimg.load()
                        
                        for xi in range(i*8, min((i+1)*8, width)):
                            for yi in range(j*8, min((j+1)*8, height)):
                                # 원본 이미지의 픽셀 값을 현재 이미지에 복원
                                current_pixels[xi, yi] = original_pixels[xi, yi]
                inpaint_check()

            def on_canvas_right_click_or_move(event):
                # 마우스 우클릭 위치를 축소된 좌표로 변환
                x, y = event.x // 8, event.y // 8
                # 페인트 제거 함수 호출
                remove_paint_from_image(x, y)
                # 변경된 이미지를 캔버스에 다시 표시
                update_canvas_image()

            # 우클릭 이벤트와 우클릭 드래그 이벤트에 대한 바인딩
            canvas.bind("<Button-3>", on_canvas_right_click_or_move)
            canvas.bind("<B3-Motion>", on_canvas_right_click_or_move)
            canvas.bind("<Button-1>", on_canvas_click_or_move)
            canvas.bind("<B1-Motion>", on_canvas_click_or_move)

            highlight_tags = ["aqua","black","blonde","blue","brown","cyan","green","grey","orange","pink","purple","red","violet","white","yellow","mouth", "eyes", " cap", " ears", " girl", " ornament", " hat", "beret", " ear "]

            def insert_with_color(cwords = current_lookup[1]):
                words = [word.strip() for word in cwords.split(',')]
                for index, word in enumerate(words):
                    highlight = False
                    start_index = i2i_text_input.index("end-1c")
                    if index == len(words) - 1:  # 마지막 원소인 경우
                        i2i_text_input.insert("end", word)
                    else:
                        i2i_text_input.insert("end", word + ", ")
                    end_index = i2i_text_input.index("end-1c")

                    for tag in highlight_tags:
                        if tag in word:
                            highlight = True
                    if word == "hat": highlight = True
                    # 조건 확인
                    if word in cd.character_dictionary or word in tagbag.bag_of_tags[5:] or 'tail' in word or 'pupil' in word:
                        i2i_text_input.tag_add(word, start_index, end_index)
                        i2i_text_input.tag_config(word, foreground="#FFFF97")
                    elif highlight:
                        i2i_text_input.tag_add(word, start_index, end_index)
                        i2i_text_input.tag_config(word, foreground="#AED395")

            i2i_text_input_label = customtkinter.CTkLabel(img2img_window_right, text="            ------------------- i2i 프롬프트 -------------------  ", font=large_font)
            i2i_text_input_label.grid(row = 0, sticky="w" )
            text_hyperlink = customtkinter.CTkLabel(img2img_window_right, text="가이드 열기 (arca.live)", font=customtkinter.CTkFont('Pretendard', 13), width=180, text_color="lightblue", cursor="hand2", state="disabled")
            text_hyperlink.grid(row=0, column=0, padx=5, pady=5, sticky="e")
            if current_lookup[1] == "External Image" and (self.app_mode == "WEBUI" or self.NAI_webui_address):
                def interrogate_wd14():
                    _img = img
                    _textbox = i2i_text_input
                    result, rating = NAIA_generation.interrogate_webui(_img, self.access_token if self.app_mode == "WEBUI" else self.NAI_webui_address)
                    _textbox.delete("0.0", "end")
                    _textbox.insert("0.0", "#WD14 Tagger Generated text,\n\n"+result)
                    interrogate_button.grid_forget()
                interrogate_button = customtkinter.CTkButton(img2img_window_right, font=customtkinter.CTkFont('Pretendard', 14), text="WD14 Interrogate Image", fg_color="#ED7D31", hover_color="#CC5D12", command=interrogate_wd14)
                interrogate_button.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
            #text_hyperlink.bind("<Button-1>", lambda e: webbrowser.open_new("https://arca.live/b/aiart/95877361"))
            i2i_text_input = customtkinter.CTkTextbox(img2img_window_right, width=490,  height=155 if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") else 210,font=v_large_font)
            i2i_text_input.grid(row=2, column=0, pady=5, sticky="nsew")
            insert_with_color()
            i2i_autocomplete = AutoCompleteHandler(
                master=img2img_window_right,
                app_mode=self.app_mode, 
                text_widget=i2i_text_input,
                autocomplete_var=self.autocomplete_var,
                wildcard_dict_tree=self.wildcard_dict_tree
            )

            def slider_event(value):
                i2i_slider_label.configure(text=f"Strength : {value:.2f}")
                self.i2i_value = value

            def noise_slider_event(value):
                i2i_noise_label.configure(text=f"Noise : {value:.2f}")
                self.i2i_noise = value

            def get_i2i_neagtive(filename):
                with Image.open(filename) as img:
                    info = img.info.get('Comment', '')
                start_pattern = '"uc": "'
                end_pattern = '", "'
                start_index = info.find(start_pattern)
                if start_index != -1:
                    # 실제 추출할 문자열의 시작 인덱스 조정
                    start_index += len(start_pattern)
                    
                    # 종료 패턴의 인덱스를 찾기
                    end_index = info.find(end_pattern, start_index)
                    if end_index != -1:
                        # 문자열 추출
                        extracted_string = info[start_index:end_index]
                else:
                    if app.current_window in app.import_image_negative:
                        extracted_string = app.import_image_negative[app.current_window]
                    else:
                        extracted_string = ""
                if extracted_string == "" : 
                    extracted_string = [ext.strip() for ext in app.negative_prompt_input.get("0.0", "end-1c").split(',')]
                    extracted_string = [ext for ext in extracted_string if not ext.startswith("#")]
                    extracted_string = ", ".join(extracted_string)
                return extracted_string

            def i2i_offset_input():
                if i2i_offset_input_label.get() == 1:
                    i2i_negative_input.grid(row=4, column=0, pady=5, sticky="nsew")
                    app.i2i_negative_is_on = True
                else:
                    i2i_negative_input.grid_forget()
                    app.i2i_negative_is_on = False

            i2i_offset_input_label = customtkinter.CTkCheckBox(img2img_window_right, text="            ------------------- i2i 네거티브 ----------------  ", font=large_font, command=i2i_offset_input)
            i2i_offset_input_label.grid(row = 3, column=0,sticky="w" )
            i2i_character_search_button = customtkinter.CTkButton(img2img_window_right, text="캐릭터 검색", fg_color="#7030A0", hover_color="#481F67", font=my_font, command= lambda: open_Character_search(self, i2i_character_search_button))
            i2i_character_search_button.grid(row=3, column=0, pady=5, padx=5, sticky="e")
            i2i_negative_input = customtkinter.CTkTextbox(img2img_window_right, width=490, height=95 if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") else 115,font=v_large_font)
            if type(_contents) == type(None):  
                i2i_negative = get_i2i_neagtive(filename)
            else:
                try: i2i_negative = get_i2i_neagtive(_filename)
                except: i2i_negative = _contents["uc"] if "uc" in _contents else get_i2i_neagtive(filename)
            i2i_negative_input.insert("0.0", i2i_negative)
            i2i_neg_autocomplete = AutoCompleteHandler(
                master=img2img_window_right,
                app_mode=self.app_mode, 
                text_widget=i2i_negative_input,
                autocomplete_var=self.autocomplete_var,
                wildcard_dict_tree=self.wildcard_dict_tree
            )

            if app.i2i_negative_is_on:
                i2i_offset_input_label.select()
                i2i_negative_input.grid(row=4, column=0, pady=5, sticky="nsew")

            if _event:
                i2i_text_input.delete("0.0", "end")
                i2i_negative_input.delete("0.0", "end")
                i2i_text_input.insert("0.0", _event[0])
                i2i_negative_input.insert("0.0", _event[1])
                global_brush_size = 7

            i2i_slider_frame = customtkinter.CTkFrame(img2img_window_right, fg_color="#333333")
            i2i_slider_frame.grid(row=5, column=0, pady=5, padx=5, sticky="nsew")

            i2i_value = round(self.i2i_value, 2)
            i2i_noise = round(self.i2i_noise, 2)
            i2i_seed_hold_check = 1 if self.i2i_seed_hold_check else 0
            i2i_slider_label = customtkinter.CTkLabel(i2i_slider_frame, text="Strength : "+str(i2i_value), font=large_font, width=140)
            i2i_slider_label.grid(row=0, column=0, sticky="nsew")
            i2i_slider = customtkinter.CTkSlider(i2i_slider_frame, from_=0.01, to=0.99, number_of_steps=99, command=slider_event, width=340)
            i2i_slider.grid(row=0, column=1, sticky="nsew")
            i2i_slider.set(i2i_value)

            i2i_noise_label = customtkinter.CTkLabel(i2i_slider_frame, text="Noise : "+str(i2i_noise), font=large_font, width=140)
            i2i_noise_label.grid(row=1, column=0, sticky="nsew")
            i2i_noise_slider = customtkinter.CTkSlider(i2i_slider_frame, from_=0.00, to=0.99, number_of_steps=100, command=noise_slider_event, width=340)
            i2i_noise_slider.grid(row=1, column=1, sticky="nsew")
            i2i_noise_slider.set(i2i_noise)

            i2i_resolution_label = customtkinter.CTkLabel(i2i_slider_frame, text="해상도 배율", font=large_font, width=140)
            i2i_resolution_label.grid(row=2, column=0, sticky="nsew")

            def restore_original_image(_sp = None):
                global tk_image, iimg
                if not _sp: iimg = Image.open(current_lookup[3]).convert("RGB")
                else: iimg = Image.open(_sp).convert("RGB")
                tk_image = ImageTk.PhotoImage(iimg.copy())  # 원본 이미지를 사용하여 Tkinter 호환 이미지 생성
                canvas.create_image(0, 0, anchor="nw", image=tk_image)
                canvas.image = tk_image
                for i in range(len(mirror_image)):
                    for j in range(len(mirror_image[i])):
                        mirror_image[i][j] = 0
                inpaint_check()

            overlay_original_image_var = customtkinter.IntVar()
            reverse_mask_var = customtkinter.IntVar()

            i2i_inpaintr_frame = customtkinter.CTkFrame(img2img_window_right, fg_color="#2B2B2B")
            #i2i_inpaintr_frame.grid(row=5, column=0, pady=5, padx=5, sticky="nsew")

            overlay_original_image = customtkinter.CTkCheckBox(i2i_inpaintr_frame, text="Overlay Original Image", font=large_font, variable=overlay_original_image_var, width=280)
            reverse_mask = customtkinter.CTkCheckBox(i2i_inpaintr_frame, text="Apply Inpaint not masked", font=large_font, variable=reverse_mask_var, width=280)
            cancel_inpainting_button = customtkinter.CTkButton(i2i_inpaintr_frame, text="인페인트 취소", font=large_font, command=restore_original_image)
            overlay_original_image.grid(row=0, column=0, columnspan=3, sticky="n")
            cancel_inpainting_button.grid(row=2, column=0, columnspan=3, sticky="n")
            reverse_mask.grid(row=1, column=0, columnspan=3,  sticky="n")

            i2i_radio_frame = customtkinter.CTkFrame(i2i_slider_frame,  fg_color="#333333")
            i2i_radio_frame.grid(row=2, column=1, pady=5, sticky="nsew")

            radio_var = customtkinter.IntVar(value=self.i2i_resolution)
            i2i_request_width = customtkinter.IntVar(value=width)
            i2i_request_height = customtkinter.IntVar(value=height)
            img2img_window.after(2500, lambda: img2img_window.attributes('-topmost', False))



            def radiobutton_event():
                v = radio_var.get()
                if v == 0: 
                    request_width = width
                    request_height = height
                    self.i2i_resolution = 0
                elif v == 1:
                    request_width, request_height = find_max_resolution(width, height, 2166784)
                    self.i2i_resolution = 1
                elif v == 2:
                    request_width, request_height = find_max_resolution(width, height, 2662400)
                    self.i2i_resolution = 2
                elif v == 3:
                    request_width, request_height = find_max_resolution(width, height, 1048576)
                    self.i2i_resolution = 3
                elif v == 4:
                    request_width, request_height = find_max_resolution(width, height, 1572864)
                    self.i2i_resolution = 4
                i2i_resolution_label.configure(text=f"{request_width} x {request_height}")
                i2i_request_width.set(request_width)
                self.i2i_width = request_width
                i2i_request_height.set(request_height)
                self.i2i_height = request_height

            radio_button_1 = customtkinter.CTkRadioButton(i2i_radio_frame, text="해상도 유지", command=radiobutton_event, variable= radio_var, value=0, font=large_font)
            radio_button_1.grid(row=0, column=0, sticky="nsew")
            radio_button_2 = customtkinter.CTkRadioButton(i2i_radio_frame, text="2.16 MP", command=radiobutton_event, variable= radio_var, value=1, font=large_font)
            radio_button_2.grid(row=0, column=1, sticky="nsew")
            radio_button_3 = customtkinter.CTkRadioButton(i2i_radio_frame, text="2.66 MP", command=radiobutton_event, variable= radio_var, value=2, font=large_font)
            radio_button_3.grid(row=0, column=2, sticky="nsew")
            radio_button_4 = customtkinter.CTkRadioButton(i2i_radio_frame, text="1 MP", command=radiobutton_event, variable= radio_var, value=3, font=large_font)
            radio_button_4.grid(row=1, column=0, sticky="nsew")
            radio_button_5 = customtkinter.CTkRadioButton(i2i_radio_frame, text="1.6 MP", command=radiobutton_event, variable= radio_var, value=4, font=large_font)
            radio_button_5.grid(row=1, column=1, sticky="nsew")
            radiobutton_event()

            i2i_generate_frame = customtkinter.CTkFrame(img2img_window_right,  fg_color="#2B2B2B")
            i2i_generate_frame.grid(row=6, column=0, pady=5, sticky="n")

            i2i_offset_input_label2 = customtkinter.CTkLabel(i2i_generate_frame, text=" 해상도와 Strength에 따라 Anlas가 소모됩니다 " if app.app_mode == "NAI" else " Vibe 기능은 NAI로 i2i 요청을 보낼때만 적용됩니다. ", font=large_font, text_color="#FFFF97")
            i2i_offset_input_label2.grid(row = 0, column=0, columnspan=3, sticky="n" )

            def seed_button_event():
                self.i2i_seed_hold_check = True if request_upper_size_seed_hold.get() == 1 else False

            #기능 추가 : i2i_reference에 대응
            i2irf = {"image_reference" : None, "image_reference_string" : None, "image_reference_tk" : None, "image_id" : None, "ie" : app.i2i_vibe_ie, "irs" : app.i2i_vibe_rs}

            request_upper_size_seed_hold_var = customtkinter.IntVar(value=i2i_seed_hold_check)
            request_upper_size_seed_hold = customtkinter.CTkCheckBox(i2i_generate_frame, text="시드고정  Step : ", font=my_font, variable=request_upper_size_seed_hold_var, command=seed_button_event)
            request_upper_size_seed_hold.grid(row=1, column=0, padx=5, pady=5, sticky="nsew")
            request_upper_size_seed_hold.select() if i2i_seed_hold_check == 1 else request_upper_size_seed_hold.deselect()
            request_upper_size_steps = customtkinter.StringVar(value="28")
            request_upper_size_steps_entry = customtkinter.CTkEntry(i2i_generate_frame, font=my_font, textvariable=request_upper_size_steps, width=40)
            request_upper_size_steps_entry.grid(row=1, column=1,padx=5, pady=5, sticky="w")
            i2i_generate_button = customtkinter.CTkButton(i2i_generate_frame, text="Request I2I", font=large_font,  command=lambda: instant_image_generation(self, current_lookup, i2irf))
            i2i_generate_button.grid(row = 1, column= 1, padx=50, pady=5, sticky="w" )

            def i2i_set_image_reference(filepath = None):
                if not filepath: filepath = filedialog.askopenfilename(title="Open Image", filetypes=[("Image files", "*.png;*.jpg;*.webp"), ("All files", "*.*")])
                if filepath:
                    i2irf["image_reference"] = Image.open(filepath).convert('RGBA')
                    i2irf["image_reference_string"] = NAIA_generation.image_to_base64(i2irf["image_reference"])
                    enhancer = ImageEnhance.Brightness(i2irf["image_reference"])
                    darker_image = enhancer.enhance(0.5)
                    i2irf["image_reference_tk"] = ImageTk.PhotoImage(darker_image.resize((int(486* (self.dpi / 100)), int(486* (self.dpi / 100))), Image.Resampling.LANCZOS))
                    i2irf["image_id"] = image_reference_canvas.create_image(0, 0, image=i2irf["image_reference_tk"], anchor='nw')
                    image_reference_strength.set(app.i2i_vibe_rs)
                    information_extracted.set(app.i2i_vibe_rs)
                    image_reference_frame.grid(row=3, column=0, columnspan=4, sticky="nsew")
                    i2i_offset_input_label2.configure(text="*인페인트 기능은 Vibe Transfer와 함께 사용할 수 없습니다")

            i2i_vibe_import = customtkinter.CTkButton(i2i_generate_frame, font=my_font, width=40, text="(+) Vibe", fg_color="grey10", hover_color="grey", command=i2i_set_image_reference)
            i2i_vibe_import.grid(row = 1, column=2, pady=5, sticky="w")

            if app.app_mode == "WEBUI":
                def wrapper():
                    text = i2i_text_input.get("0.0", "end")
                    text = NAIA_utils.transform_prompt(text)
                    bq =["best quality", "amazing quality", "very aesthetic", "absurdres"]
                    for k in bq: 
                        if k not in text:
                            text += f", {k}"
                    text = text.split(", ")
                    lora_rem = []
                    for k in text[2:]:
                        if k in cd.character_dictionary:
                            text.remove(k)
                            if "boy" in text[1] or "girl" in text[1]: text.insert(2, k)
                            else: text.insert(1, k)
                        elif "lora:" in k:
                            lora_rem.append(k)
                    if lora_rem:
                        for k in lora_rem:
                            if k in text: text.remove(k)
                    text = ", ".join(text)
                    ntext = i2i_negative_input.get("0.0", "end")
                    ntext = NAIA_utils.transform_prompt(ntext)
                    nq = ["lowres", "bad", "error", "fewer", "extra", "missing", "worst quality", "jpeg artifacts", "bad quality", "watermark", "unfinished", "displeasing", "chromatic aberration", "signature", "extra digits", "artistic error", "username", "scan", "abstract"]
                    nnq = ""
                    for k in nq:
                        if k not in ntext:
                            nnq += f"{k}, "
                    ntext = nnq + ntext
                    i2i_text_input.delete("0.0", "end")
                    insert_with_color(text)
                    i2i_negative_input.delete("0.0", "end")
                    i2i_negative_input.insert("0.0", ntext)
                    i2i_transform_button.configure(state="disabled")
                i2i_generate_button2 = customtkinter.CTkButton(i2i_generate_frame, text="Request I2I (NAI)", font=large_font,fg_color="#F5F3C2", hover_color="#A69F40", text_color="black",  command=lambda: instant_image_generation(self, current_lookup, i2irf, app.nai_access_token))
                i2i_generate_button2.grid(row = 2, column= 0, pady=5, sticky="w" )
                i2i_transform_button = customtkinter.CTkButton(i2i_generate_frame, text="NAI 프롬프트 변환", font=large_font, fg_color="grey10", hover_color="grey", command=wrapper)
                i2i_transform_button.grid(row = 2, column= 1, pady=5, sticky="w" )
                i2i_automatic_nai = customtkinter.CTkCheckBox(i2i_generate_frame, text="자동 적용", font=my_font, variable=app.i2i_automatic_NAI_var)
                i2i_automatic_nai.grid(row = 2, column= 1, pady=5, sticky="e" )
            i2i_repeat = customtkinter.CTkCheckBox(i2i_generate_frame, text="I2I 자동반복 / 횟수 : ", font=my_font)
            i2i_repeat.grid(row=3, column=1, columnspan=2, padx=5, pady=5, sticky="nsew")
            i2i_repeat_count_var = customtkinter.StringVar(value="1")
            i2i_repeat_count = customtkinter.CTkEntry(i2i_generate_frame, font=my_font, width=40, textvariable=i2i_repeat_count_var)
            i2i_repeat_count.grid(row=3, column=1, columnspan=2, padx=155, pady=5, sticky="w")

            i2i_result_image_view = customtkinter.CTkCheckBox(i2i_generate_frame, text="img2img 결과를 이 창에 출력", font=my_font, variable=app.i2i_result_image_view_var)
            i2i_result_image_view.grid(row=3, column=0,  padx=5, pady=5, sticky="n")

            def open_options():
                if nai_options.get() == 1:
                    nai_cfg_label.grid(row=5, column=0, padx=5, pady=5, sticky="nsew")                    
                    nai_cfg_entry.grid(row=5, column=1, padx=5, pady=5, sticky="w")
                    nai_auto_vibe.grid(row=5, column=1, columnspan=2, padx=5, pady=5, sticky="e")
                    nai_rescale_label.grid(row=6, column=0, padx=5, pady=5, sticky="nsew")
                    nai_rescale_entry.grid(row=6, column=1, padx=5, pady=5, sticky="w")
                    nai_extra_label.grid(row=7, column=0, columnspan=3, padx=5, pady=5, sticky="n")
                    nai_text_label.grid(row=8, column=0, padx=5, pady=5, sticky="nsew")
                    nai_text_entry.grid(row=8, column=1, columnspan=2, padx=5, pady=5, sticky="nsew")
                    nai_change_label.grid(row=9, column=0, padx=5, pady=5, sticky="nsew")
                    nai_change_entry.grid(row=9, column=1, columnspan=2, padx=5, pady=5, sticky="nsew")
                else:
                    nai_cfg_label.grid_forget()
                    nai_cfg_entry.grid_forget()
                    nai_rescale_label.grid_forget()
                    nai_rescale_entry.grid_forget()
                    nai_extra_label.grid_forget()
                    nai_text_label.grid_forget()
                    nai_text_entry.grid_forget()
                    nai_change_label.grid_forget()
                    nai_change_entry.grid_forget()

            def open_image_edit_window():
                import_img = iimg.copy()
                try: image_edit_window = ImageEdit(filename, _contents.copy())
                except: image_edit_window = ImageEdit(filename, current_lookup.copy())
                image_edit_window.run()

            def yolo_person_mask():
                from ultralytics import YOLO
                restore_original_image()
                # YOLO 모델 로드
                img2img_window.attributes('-topmost', True)
                model_person = YOLO(os.path.join(app.basedir, 'person_yolov8n-seg.pt'))

                # YOLO 모델로 예측
                image_np = np.array(iimg.convert('RGB'))
                results_person = model_person(image_np, conf=0.25, device="cpu")

                if len(results_person[0]) >= 1:
                    mask_image = Image.new('L', (image_np.shape[1], image_np.shape[0]), 0)
                    for result in results_person:
                        if result.masks is not None:
                            for mask in result.masks.data:
                                mask = mask.cpu().numpy() * 255
                                mask_pil = Image.fromarray(mask.astype(np.uint8), mode='L')
                                mask_pil = mask_pil.resize((image_np.shape[1], image_np.shape[0]), Image.Resampling.LANCZOS)
                                mask_image.paste(mask_pil, (0, 0), mask_pil)

                    small_width = image_np.shape[1] // 8
                    small_height = image_np.shape[0] // 8
                    small_mask_image = mask_image.resize((small_width, small_height), Image.Resampling.LANCZOS)
                    small_mask_array = np.array(small_mask_image)

                    for i in range(small_mask_array.shape[0]):
                        for j in range(small_mask_array.shape[1]):
                            if small_mask_array[i, j] == 255: 
                                paint_on_image(j, i)
                    update_canvas_image()
                    nai_extract_person.configure(text="Model by Bingsu/adetailer", state='disabled')
                else:
                    nai_extract_person.configure(text="Detection Failed", state='disabled')

                img2img_window.after(2000, lambda: img2img_window.attributes('-topmost', False))

            if app.app_mode == "NAI" or app.nai_access_token and "http" not in app.nai_access_token:
                current_nai = customtkinter.StringVar(value=self.current_model_nai.get())
                nai_model_select = customtkinter.CTkLabel(i2i_generate_frame, text="NAID Model Override : ", font=my_font)
                nai_model_select.grid(row=4, column=0, padx=5, pady=5, sticky="nsew")
                nai_model_list = ["NAID4", "NAID4-Curated","NAID3-Anime", "NAID3-Furry"]
                nai_options = customtkinter.CTkCheckBox(i2i_generate_frame, text="auto i2i / INST 옵션 펼치기", command=open_options, font=my_font)

                def naid4_detect(choice):
                    if "NAID4" in choice:
                        naid4_characters_frame.grid(row=7, column=0, pady=5, sticky="nsew")
                    else:
                        naid4_characters_frame.grid_forget()

                current_model_nai = customtkinter.CTkComboBox(i2i_generate_frame, values=nai_model_list, variable=current_nai, width=120, font=my_font, command=naid4_detect)
                current_model_nai.grid(row=4, column=1, padx=5, pady=5, sticky="w")
                nai_options.grid(row=4, column=1, padx=5, columnspan=2, sticky="e")
                nai_cfg_label = customtkinter.CTkLabel(i2i_generate_frame, text="CFG Scale 재할당 : ", font=my_font)

                nai_auto_vibe = customtkinter.CTkCheckBox(i2i_generate_frame, text="자동으로 Vibe를 적용합니다", font=my_font)

                nai_cfg_entry = customtkinter.CTkEntry(i2i_generate_frame, font=my_font, width=40)

                nai_rescale_label = customtkinter.CTkLabel(i2i_generate_frame, text="PG 리스케일값 재할당 : ", font=my_font)

                nai_rescale_entry = customtkinter.CTkEntry(i2i_generate_frame, font=my_font, width=40)
                
                nai_extra_label = customtkinter.CTkLabel(i2i_generate_frame, text="---- auto i2i / Instant i2i 설정 (닫으면 저장) ----", font=my_font)
                
                nai_text_label = customtkinter.CTkLabel(i2i_generate_frame, text="이 프롬프트를 : ", font=my_font)
                
                nai_text_entry = customtkinter.CTkEntry(i2i_generate_frame, font=my_font)
                
                nai_change_label = customtkinter.CTkLabel(i2i_generate_frame, text="다음 프롬프트로 스왑합니다 : ", font=my_font)
                
                nai_change_entry = customtkinter.CTkEntry(i2i_generate_frame, font=my_font)

                nai_cfg_entry.insert(0, app.i2i_cfg)
                nai_rescale_entry.insert(0, app.i2i_rescale)
                nai_text_entry.insert(0, app.i2i_instant_text)
                nai_change_entry.insert(0, app.i2i_instant_change)
                if app.i2i_auto_vibe == True: nai_auto_vibe.select()

                def create_character_frame(parent, idx, large_font, v_large_font, frames_list, add_callback, remove_callback):
                    frame = customtkinter.CTkFrame(parent)
                    
                    character_btn = customtkinter.CTkButton(
                        frame, 
                        text=f"C{idx}", 
                        fg_color="grey10", 
                        width=25, 
                        height=90, 
                        font=v_large_font,
                        command=lambda: open_character_window(textbox)
                    )
                    character_btn.grid(row=0, rowspan=2, column=0, pady=5, sticky="nsew")
                    
                    textbox = customtkinter.CTkTextbox(
                        frame, 
                        width=440, 
                        height=65, 
                        font=v_large_font, 
                        undo=True
                    )
                    textbox.grid(row=0, column=1, padx=10, pady=2, sticky="nsew")

                    auto_complete = AutoCompleteHandler(
                        frame,
                        self.app_mode,
                        text_widget=textbox,
                        autocomplete_var=app.autocomplete_var,
                        wildcard_dict_tree= app.wildcard_dict_tree
                    )

                    uc = customtkinter.CTkTextbox(
                        frame, 
                        width=440, 
                        height=20, 
                        font=v_large_font, 
                        text_color="grey",
                        undo=True
                    )
                    uc.grid(row=1, column=1, padx=10, pady=3, sticky="nsew")
                    
                    remove_btn = customtkinter.CTkButton(
                        frame, 
                        text=" - ", 
                        fg_color="grey", 
                        hover_color="grey10", 
                        width=25, 
                        height=25, 
                        font=v_large_font,
                        command=lambda: remove_callback(frame, frames_list)
                    )
                    remove_btn.grid(row=0, column=2, pady=5, sticky="nsew")
                    
                    add_btn = customtkinter.CTkButton(
                        frame, 
                        text=" + ", 
                        width=25, 
                        height=25, 
                        font=v_large_font,
                        command=add_callback
                    )
                    add_btn.grid(row=1, column=2, pady=5, sticky="nsew")
                    
                    return {
                        'frame': frame,
                        'character_btn': character_btn,
                        'textbox': textbox,
                        'uc':uc,
                        'remove_btn': remove_btn,
                        'add_btn': add_btn
                    }

                def open_character_window(parent_textbox):
                    # 새 toplevel 윈도우 생성
                    window = customtkinter.CTkToplevel()
                    window.title("캐릭터 검색")
                    window.geometry("800x450")
                    window.attributes('-topmost', True)
                    
                    # 검색 프레임 생성
                    search_frame = customtkinter.CTkFrame(window)
                    search_frame.grid(row=0, column=0, columnspan=2, padx=10, pady=5, sticky="ew")
                    
                    # 검색 엔트리
                    search_entry = customtkinter.CTkEntry(search_frame, width=200, font=("", 14))
                    search_entry.grid(row=0, column=0, padx=(0,5), sticky="ew")
                    search_entry.bind('<Return>', lambda event: do_search())
                    
                    # 검색 버튼
                    search_btn = customtkinter.CTkButton(
                        search_frame, 
                        text="검색 (엔터)",
                        width=80,
                        command=lambda: do_search()
                    )
                    search_btn.grid(row=0, column=1, padx=(5,0))
                    
                    # 리스트박스
                    listbox = tk.Listbox(window, width=32, height=30, font = font.Font(family='Pretendard', size=13), bg='#2B2B2B', fg='#F8F8F8', borderwidth=2, highlightbackground='lightgrey')
                    listbox.grid(row=1, column=0, padx=10, pady=5, sticky="nsew")
                    scrollbar = tk.Scrollbar(window, orient="v", command=listbox.yview)
                    scrollbar.grid(row=1, column=1, sticky='nsw')  # 'nsw'로 변경: north, south, west
                    listbox.config(yscrollcommand=scrollbar.set)
                    
                    # 텍스트박스
                    content_textbox = customtkinter.CTkTextbox(window, font=v_large_font)
                    content_textbox.grid(row=1, column=1, padx=20, pady=5, sticky="nsew")
                    
                    # 버튼 프레임
                    button_frame = customtkinter.CTkFrame(window)
                    button_frame.grid(row=2, column=0, columnspan=2, sticky="ew")
                    
                    insert_btn = customtkinter.CTkButton(
                        button_frame, 
                        text="삽입",
                        command=lambda: insert_content(parent_textbox, content_textbox, window)
                    )
                    insert_btn.grid(row=0, column=1, padx=5, pady=5)
                    
                    close_btn = customtkinter.CTkButton(
                        button_frame, 
                        text="닫기",
                        fg_color = "grey",
                        command=window.destroy
                    )
                    close_btn.grid(row=0, column=0, padx=5, pady=5)
                    
                    # 그리드 설정
                    window.grid_columnconfigure(1, weight=1)
                    window.grid_rowconfigure(1, weight=1)
                    search_frame.grid_columnconfigure(0, weight=1)
                    button_frame.grid_columnconfigure((0,1), weight=1)
                    
                    def on_listbox_select(event):
                        selection = listbox.curselection()
                        if selection:
                            selected_text = listbox.get(selection[0])
                            keyword = selected_text.split(" - ")[0]
                            
                            content_textbox.delete("0.0", "end")
                            if keyword in character_dict_full:
                                _text = character_dict_full[keyword].split(', ')
                                _text = ", ".join(_text[1:]) if len(_text) >= 2 else ", ".join(_text)
                                content_textbox.insert("0.0", _text)
                    
                    def do_search():
                        search_keyword = search_entry.get().strip()
                        if listbox.size() > 0:
                            listbox.delete(0, "end")

                        all_matching_keywords = []
                        added_keywords = set()

                        if search_keyword and len(search_keyword) >= 3:
                            # dan_character_dict에서 키워드 검색
                            for character, tags in dan_character_dict.items():
                                if (search_keyword.lower() in character.lower() or 
                                    search_keyword.lower() in tags.lower()):
                                    count = character_dict_count.get(character, 0)
                                    if count > 20 and character not in added_keywords:
                                        all_matching_keywords.append((character, count))
                                        added_keywords.add(character)

                        else:
                            # 빈 검색어일 때는 v > 50인 항목만 표시
                            all_matching_keywords = [
                                (k, v) for k, v in character_dict_count.items() 
                                if v > 50 and k not in added_keywords
                            ]

                        # Sort and insert into listbox
                        all_matching_keywords.sort(key=lambda item: item[1], reverse=True)
                        for keyword, count in all_matching_keywords:
                            listbox.insert("end", f"{keyword} - {count}")
                    
                    # 이벤트 바인딩
                    listbox.bind('<<ListboxSelect>>', on_listbox_select)
                    search_entry.bind('<Return>', lambda e: do_search())  # Enter 키로도 검색 가능
                    
                    # 초기 리스트 로딩
                    do_search()

                def insert_content(parent_textbox, content_textbox, window):
                    content = content_textbox.get("0.0", "end")
                    current_text = parent_textbox.get("0.0", "end")
                    parent_textbox.delete("0.0", "end")
                    parent_textbox.insert("0.0", content)
                    window.destroy()

                def add_new_character(parent, large_font, v_large_font, frames_list):
                    if len(frames_list) < 6:
                        idx = len(frames_list) + 1
                        add_callback = lambda: add_new_character(parent, large_font, v_large_font, frames_list)
                        new_frame_dict = create_character_frame(
                            parent,
                            idx,
                            large_font,
                            v_large_font,
                            frames_list,
                            add_callback,
                            remove_character
                        )
                        new_frame_dict['frame'].grid(row=len(frames_list) + 2, column=0, columnspan=3, sticky="nsew")
                        frames_list.append(new_frame_dict)

                def remove_character(frame_to_remove, frames_list):
                    if len(frames_list) > 1:  # 최소 1개는 유지
                        # 제거할 프레임 찾기
                        frame_dict = next((f for f in frames_list if f['frame'] == frame_to_remove), None)
                        if frame_dict:
                            frame_dict['frame'].grid_forget()
                            frames_list.remove(frame_dict)
                            
                            # 남은 프레임들의 위치와 번호 재조정
                            for idx, frame_dict in enumerate(frames_list, start=1):
                                frame_dict['character_btn'].configure(text=f"C{idx}")
                                frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")

                def _toggle_character_frames():
                    if naid4_characters_label.get() == 0:  # 체크박스가 해제된 경우
                        naid4_characters_label.configure(
                            text=" ---------------------------  NAID4 캐릭터 프롬프트/UC (비활성) ----------- ",
                            text_color="grey"
                        )
                        naid4_selected_character_textbox.grid_forget()
                        for frame_dict in character_frames:
                            frame_dict['frame'].grid_forget()
                        if self.nai4_character_list:
                            self.nai4_character_list_freeze = self.nai4_character_list
                            self.nai4_character_uc_list_freeze = self.nai4_character_uc_list
                            self.nai4_character_list = []
                            self.nai4_character_uc_list = []
                    else:  # 체크박스가 선택된 경우
                        naid4_characters_label.configure(
                            text=" ---------------------------  NAID4 캐릭터 프롬프트/UC (활성) ----------",
                            text_color=("black", "white")  # (라이트 모드 색상, 다크 모드 색상)
                        )
                        naid4_selected_character_textbox.grid(row=1, column=0, columnspan=3, sticky="nsew")
                        for idx, frame_dict in enumerate(character_frames, start=1):
                            frame_dict['frame'].grid(row=idx + 1, column=0, columnspan=3, sticky="nsew")
                        if self.nai4_character_list_freeze: 
                            self.nai4_character_list = self.nai4_character_list_freeze
                            self.nai4_character_uc_list = self.nai4_character_uc_list_freeze        
                            self.nai4_character_list_freeze =[]                    
                            self.nai4_character_uc_list_freeze = []
                naid4_characters_frame = customtkinter.CTkFrame(img2img_window_right, width=520)
                naid4_characters_label = customtkinter.CTkCheckBox(
                    naid4_characters_frame, 
                    text=" ---------------------------  NAID4 캐릭터 프롬프트/UC (활성) ----------", 
                    font=large_font,
                    command=_toggle_character_frames
                )
                naid4_characters_label.select()
                naid4_characters_label.grid(row=0, column=0, padx=5, pady=5, sticky="nsew")
                naid4_selected_character_textbox = customtkinter.CTkTextbox(naid4_characters_frame, width=490, height=20, font=large_font, state="disabled", text_color="#F5F3C2")
                naid4_selected_character_textbox.grid(row=1, column=0, columnspan=3, sticky="nsew")
                character_frames = []
                add_new_character(
                    naid4_characters_frame,
                    large_font,
                    v_large_font,
                    character_frames
                )




            nai_outpainting_request = customtkinter.CTkButton(i2i_generate_frame, font=my_font, text="Outpainting", command=open_image_edit_window)
            nai_outpainting_request.grid(row=10, column=0, padx=5, pady=5, sticky="nsew")

            nai_extract_person = customtkinter.CTkButton(i2i_generate_frame, font=my_font, text="Person Mask Request", command=yolo_person_mask)
            nai_extract_person.grid(row=10, column=1, padx=5, pady=5, sticky="nsew")

            if current_nai.get() == "NAID4" or current_nai.get() == "NAID4-Curated": 
                naid4_characters_frame.grid(row=7, column=0, pady=5, sticky="nsew")
                naid4_selected_character_textbox.grid(row=1, column=0, columnspan=3, sticky="nsew")
                if len(current_lookup) > 4 and "characters" in current_lookup[4]:
                    for frame_dict in character_frames:
                        frame_dict['frame'].grid_forget()
                    character_frames.clear()
                    characters =  current_lookup[4]["characters"]
                    characters_uc = current_lookup[4]["characters_uc"]
                    for i in range(len(characters)):
                        new_frame_dict = create_character_frame(
                            naid4_characters_frame,
                            i,
                            large_font,
                            v_large_font,
                            character_frames,
                            lambda: add_new_character(naid4_characters_frame, large_font, v_large_font, character_frames),
                            remove_character
                        )
                        new_frame_dict['frame'].grid(row=i + 1, column=0, columnspan=3, sticky="nsew")
                        new_frame_dict['textbox'].delete("0.0", "end")
                        new_frame_dict['textbox'].insert("0.0", characters[i])
                        new_frame_dict['uc'].delete("0.0", "end")
                        new_frame_dict['uc'].insert("0.0", characters_uc[i])
                        character_frames.append(new_frame_dict)

            def swap_image():
                global iimg, tk_image, original_image
                if app.prev_iimg_id: 
                    canvas.delete(app.prev_iimg_id)
                    app.prev_iimg_id = None
                restore_original_image(app.image_swap_filename)
                original_image = iimg.copy()
                iimg = Image.open(app.image_swap_filename).convert("RGB")
                tk_image = ImageTk.PhotoImage(iimg)
                update_canvas_image()
                current_lookup[3] = app.image_swap_filename
                app.image_swap_filename = ""
                image_swap.grid_forget()
                img_label_result.grid_forget()

            image_swap = customtkinter.CTkButton(i2i_generate_frame, font=my_font, text="오른쪽 이미지를 왼쪽에 할당", fg_color="#ED7D31", hover_color="#CC5D12", command=swap_image)
            #image_swap.grid(row=11, column=0, padx=5, pady=5, sticky="nsew")

            def slider_event_IRS(value):
                image_reference_strength_label.configure(text=f"Reference Strength : {value:.2f}")
                i2irf["irs"] = value
                app.i2i_vibe_ie = value
            
            def slider_event_IE(value):
                information_extracted_label.configure(text=f"Information Extracted : {value:.2f}")
                i2irf["ie"]  = value
                app.i2i_vibe_rs = value

            def i2i_rem_image_reference(i2irf):
                if i2irf["image_reference"]:
                    i2irf = {"image_reference" : None, "image_reference_string" : None, "image_reference_tk" : None, "image_id" : None, "ie" : 1, "irs" : 0.6}
                image_reference_frame.grid_forget()
                image_reference_canvas.delete(i2irf["image_id"])
                i2irf["image_id"] = None

            image_reference_frame = customtkinter.CTkFrame(i2i_generate_frame)
            image_reference_canvas = customtkinter.CTkCanvas(image_reference_frame, width=int(468 * (app.dpi / 100)), height=200,bg="#333333", highlightthickness  = 1, highlightbackground = 'grey10')
            image_reference_canvas.grid(row=0, column=0, columnspan=4, pady=5, sticky="n")
            image_reference_strength_label = customtkinter.CTkLabel(image_reference_canvas, font=v_large_font, text_color='white', text=f"Reference Strength : {app.i2i_vibe_rs}", fg_color='transparent', width=190)
            information_extracted_label = customtkinter.CTkLabel(image_reference_canvas, font=v_large_font, text_color='white', text=f"Information Extracted : {app.i2i_vibe_ie}", fg_color='transparent', width=190)
            image_reference_strength = customtkinter.CTkSlider(image_reference_canvas,  from_=0.01, to=1.00, number_of_steps=100, command=slider_event_IRS, button_color='grey', button_hover_color='grey10', height=20, progress_color='transparent')
            information_extracted = customtkinter.CTkSlider(image_reference_canvas,  from_=0.01, to=1.00, number_of_steps=100, command=slider_event_IE, button_color='grey', button_hover_color='grey10', height=20, progress_color='transparent')
            exit_reference_mode = customtkinter.CTkButton(image_reference_canvas, text="Vibe Transfer 해제", font=my_font, command=lambda: i2i_rem_image_reference(i2irf), fg_color='grey10', hover_color='grey', corner_radius=0)
            irc_xpos = [int(110* (self.dpi / 100)), int(110* (self.dpi / 100)), int(320* (self.dpi / 100)), int(320* (self.dpi / 100)), int(240* (self.dpi / 100))]
            image_reference_canvas.create_window(irc_xpos[0], 120, window=image_reference_strength_label)
            image_reference_canvas.create_window(irc_xpos[1], 70, window=information_extracted_label)
            image_reference_canvas.create_window(irc_xpos[2], 120, window=image_reference_strength)
            image_reference_canvas.create_window(irc_xpos[3], 70, window=information_extracted)
            image_reference_canvas.create_window(irc_xpos[4], 170, window=exit_reference_mode)

            if _from == "outpaint":
                global_brush_size = 9
                outpainting_box = app.outpainting_box
                for i in range(outpainting_box.shape[0]):
                    for j in range(outpainting_box.shape[1]):
                            if outpainting_box[i, j] == 1: 
                                paint_on_image(j, i)
                update_canvas_image()
                overlay_original_image.select()
            
            if _event:
                yolo_person_mask()
                #reverse_mask.select()
                paint_on_image(_width//2, _height//2)
                overlay_original_image.select()
                for item in reversed(app.image_queue):
                    if len(item) >= 5:
                        i2i_set_image_reference(item[3])
                        break
                pass_check = len(app.image_queue)
                instant_image_generation(self, current_lookup, i2irf)

            if app.app_mode == "WEBUI" and app.i2i_automatic_NAI_var.get() == 1:
                wrapper()

            img2img_window.protocol("WM_DELETE_WINDOW", close)
        
        class ImageEdit(customtkinter.CTkToplevel):
            def __init__(self, filename,  _contents):
                super().__init__()
                self.title("Outpainting Request")
                self.attributes('-topmost', True)
                self.resizable(width=False, height=True)
                self.app = app
                self.attributes('-topmost', True)
                my_font = customtkinter.CTkFont('Pretendard', 13)

                self.ImageEdit_left = customtkinter.CTkScrollableFrame(self)
                self.ImageEdit_left.grid(row=0, column=0, pady=5, padx=5, sticky="nsew")
                self.ImageEdit_right = customtkinter.CTkFrame(self, width=586)
                self.ImageEdit_right.grid(row=0, column=1, pady=5, padx=5, sticky="nsew")
                self._contents = _contents

                self.bg_size_var = customtkinter.StringVar(value="1024x1024")
                self.radio_frame = customtkinter.CTkFrame(self.ImageEdit_right)
                self.radio_1 = customtkinter.CTkRadioButton(self.radio_frame, text="1024x1024", variable=self.bg_size_var, value="1024x1024", command=self.update_bg_size)
                self.radio_2 = customtkinter.CTkRadioButton(self.radio_frame, text="832x1216", variable=self.bg_size_var, value="832x1216", command=self.update_bg_size)
                self.radio_3 = customtkinter.CTkRadioButton(self.radio_frame, text="1216x832", variable=self.bg_size_var, value="1216x832", command=self.update_bg_size)
                self.radio_frame.grid(row=0, column=1, pady=5, padx=5, sticky="nsew")
                self.radio_1.grid(row=0, column=0, padx=10)
                self.radio_2.grid(row=1, column=0, padx=10)
                self.radio_3.grid(row=2, column=0, padx=10)
                self.finish_task = customtkinter.CTkButton(self.radio_frame, text="Save Image",  font=my_font, command=self.save_image)
                self.finish_task.grid(row=3, column=0, pady=10, padx=5, sticky="nsew")
                self.bg_size = (1024, 1024)

                # Canvas for image manipulation
                self.canvas = Canvas(self.ImageEdit_left, width=self.bg_size[0], height=self.bg_size[1], bg='white')
                self.canvas.grid(row=1, column=0, columnspan=4, pady=20)



                self.resize_handle_selected = None
                
                self.image = None
                self.image_id = None
                self.img_original = None
                self.already_used_rotate = False
                self.img_size = (200, 200)
                self.angle = 0  # 초기 회전 각도
                self.canvas_last_pos = []
                self.filename = filename

                self.canvas.bind("<Button-1>", self.select_handle)
                self.canvas.bind("<ButtonRelease-1>", self.release_handle)

                self.bind("<Left>", self.rotate_left)
                self.bind("<Right>", self.rotate_right)

                self.selected_image = False
                self.rotated_first_time = False

                cwidth, cheight = self.bg_size_var.get().split('x')
                cwidth = int(cwidth)
                cheight = int(cheight)
                current_dpi = app.dpi
                dpi_scale = 100 / current_dpi
                window_height = app.winfo_height()
                if window_height * int(current_dpi / 100) >= 1216:
                    self.ImageEdit_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=round(cheight * dpi_scale, 0)+2 if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)
                else:
                    self.ImageEdit_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=min(cheight, 930) if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)

                self.after(50, self.load_image())

            def load_image(self):
                self.img_original = Image.open(self.filename).convert('RGB')
                self.img_origin2 = self.img_original.copy()
                
                # 이미지 크기를 배경 영역 내로 조정
                bg_width, bg_height = self.bg_size
                aspect_ratio = self.img_original.width / self.img_original.height
                
                if self.img_original.width > bg_width or self.img_original.height > bg_height:
                    if self.img_original.width / bg_width > self.img_original.height / bg_height:
                        new_width = bg_width
                        new_height = int(bg_width / aspect_ratio)
                    else:
                        new_height = bg_height
                        new_width = int(bg_height * aspect_ratio)
                else:
                    new_width, new_height = self.img_original.width, self.img_original.height

                self.img_size = (new_width, new_height)
                self.apply_transformation()



            def save_image(self):
                if self.angle != 0:
                    rotated_image = self.img_origin2.rotate(-self.angle, resample=Image.Resampling.BILINEAR, expand=True, fillcolor=(255, 255, 255))
                    #rotated_image.show()
                else:
                    rotated_image = self.img_origin2

                min_x = self.canvas.coords(self.handles[0])[0] + 5
                max_x = self.canvas.coords(self.handles[1])[0] + 5
                min_y = self.canvas.coords(self.handles[0])[1] + 5
                max_y = self.canvas.coords(self.handles[3])[1] + 5

                # 크롭 및 리사이즈
                resized_image = rotated_image.resize((int(max_x - min_x), int(max_y - min_y)))

                # 새로운 이미지 생성
                width, height = self.bg_size_var.get().split('x')
                width = int(width)
                height = int(height)
                composite_image = Image.new("RGB", (width, height), "white")
                #min_x = min(coord[0] for coord in self.canvas_last_pos)
                #max_x = max(coord[0] for coord in self.canvas_last_pos)
                #min_y = min(coord[1] for coord in self.canvas_last_pos)
                #max_y = max(coord[1] for coord in self.canvas_last_pos)
                
                # 이미지의 새로운 중심을 계산합니다.
                center_x, center_y = self.canvas.coords(self.image_id)
                print(center_x, center_y)

                x_adj = (max_x - abs(min_x))/2
                y_adj = (max_y - abs(min_y))/2

                # 이미지 합성
                composite_image.paste(resized_image, (int(min_x), int(min_y)))
                composite_image.save('tempimage.png')

                # mirror_mask 생성
                mask_width = width // 8
                mask_height = height // 8
                mirror_mask = np.zeros((mask_height, mask_width), dtype=int)

                # handle의 좌표를 기준으로 mask 업데이트
                min_x_idx = int(min_x // (width / mask_width))
                max_x_idx = int(max_x // (width / mask_width))
                min_y_idx = int(min_y // (height / mask_height))
                max_y_idx = int(max_y // (height / mask_height))

                for y in range(mask_height):
                    for x in range(mask_width):
                        if x < min_x_idx or x > max_x_idx or y < min_y_idx or y > max_y_idx:
                            mirror_mask[y][x] = 1

                app.outpainting_box = mirror_mask.copy()
                app.sync_outpainting = [composite_image.copy(),"outpaint", self.filename, self._contents, "manual"]
                self.after(500, self.destroy())

            def update_bg_size(self):
                size_str = self.bg_size_var.get()
                width, height = map(int, size_str.split('x'))
                self.bg_size = (width, height)
                self.canvas.configure(width=width, height=height)
                self.canvas.delete("all")
                self.image = None
                self.image_id = None
                cwidth, cheight = self.bg_size_var.get().split('x')
                cwidth = int(cwidth)
                cheight = int(cheight)
                current_dpi = app.dpi
                dpi_scale = 100 / current_dpi
                window_height = app.winfo_height()
                if window_height * int(current_dpi / 100) >= 1216:
                    self.ImageEdit_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=round(cheight * dpi_scale, 0)+2 if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)
                else:
                    self.ImageEdit_left.configure(width=round(cwidth * dpi_scale, 0)+2, height=min(cheight, 930) if cheight <= 1216 else round(1216 * dpi_scale, 0)+2)
                self.load_image()

            def rotate_left(self, event):
                if not self.already_used_rotate:
                    self.angle = (self.angle - 5) % 360
                    self.apply_transformation()

            def rotate_right(self, event):
                if not self.already_used_rotate:
                    self.angle = (self.angle + 5) % 360
                    self.apply_transformation()

            def apply_transformation(self):
                if self.already_used_rotate:
                    return
                if not self.img_original:
                    return
                
                if self.rotated_first_time == False and self.image_id and not self.already_used_rotate:
                    self.rotated_first_time = True
                    self.radio_1.configure(state='disabled')
                    self.radio_2.configure(state='disabled')
                    self.radio_3.configure(state='disabled')
                    min_x = min(coord[0] for coord in self.canvas_last_pos)
                    max_x = max(coord[0] for coord in self.canvas_last_pos)
                    min_y = min(coord[1] for coord in self.canvas_last_pos)
                    max_y = max(coord[1] for coord in self.canvas_last_pos)
                    
                    # 이미지의 새로운 중심을 계산합니다.
                    center_x = (min_x + max_x) / 2
                    center_y = (min_y + max_y) / 2
                    new_width = max_x - min_x
                    new_height = max_y - min_y

                    # 새로운 크기에 맞게 원본 이미지를 자릅니다.
                    resized_image = self.img_original.resize((int(new_width), int(new_height)), Image.Resampling.LANCZOS)
                    
                    # 조정된 이미지 업데이트
                    self.img_resized = resized_image
                    self.img_original = resized_image.copy()
                    self.image = ImageTk.PhotoImage(resized_image)
                    self.img_size = resized_image.size

                    # 이미지를 새로운 위치에 배치
                    if self.image_id:
                        self.canvas.delete(self.image_id)  # 기존 이미지 삭제
                    self.image_id = self.canvas.create_image(center_x, center_y, image=self.image, anchor='center')
                    self.canvas_last_pos = [(center_x - new_width / 2, center_y - new_height / 2),
                                            (center_x + new_width / 2, center_y - new_height / 2),
                                            (center_x - new_width / 2, center_y + new_height / 2),
                                            (center_x + new_width / 2, center_y + new_height / 2)]

                center_x, center_y = self.bg_size[0] // 2, self.bg_size[1] // 2

                # 현재 이미지 크기 핸들러의 좌표값을 받아 해당 좌표의 이미지를  self.image로 할당한다.

                # 이미지 회전 및 크기 조절
                rotated = self.img_original.rotate(-self.angle, resample=Image.Resampling.BILINEAR, expand=True, fillcolor=(255, 255, 255))

                # 회전된 이미지 크기 계산
                rotated_width, rotated_height = rotated.size
                scale_factor = min(self.bg_size[0] / rotated_width, self.bg_size[1] / rotated_height)
                new_width = int(rotated_width * scale_factor)
                new_height = int(rotated_height * scale_factor)

                # 크기 조정
                resized = rotated.resize((new_width, new_height), Image.Resampling.LANCZOS)
                self.img_resized = ImageTk.PhotoImage(resized)

                # 중앙에 이미지 배치
                self.canvas.delete(self.image_id)
                self.image_id = self.canvas.create_image(center_x, center_y, anchor='center', image=self.img_resized)

                # 핸들러 업데이트
                self.canvas.delete("handle")
                self.add_resize_handles()

            def add_resize_handles(self):
                self.handles = []
                handle_size = 5  # 인식 범위를 확장합니다.
                x, y  = self.canvas.coords(self.image_id)
                try: img_width, img_height = self.img_resized.size
                except: img_width, img_height = self.img_resized.width(), self.img_resized.height()

                # 핸들의 좌표를 저장할 리스트 초기화
                self.canvas_last_pos = []

                # Top-left handle
                tl_x = x - img_width / 2
                tl_y = y - img_height / 2
                self.handles.append(self.canvas.create_rectangle(
                    tl_x - handle_size, tl_y - handle_size,
                    tl_x + handle_size, tl_y + handle_size,
                    outline='black', fill='black', tags=("handle", "top_left")))
                self.canvas.tag_bind(self.handles[-1], "<Enter>", lambda e: self.canvas.config(cursor="top_left_corner"))
                self.canvas.tag_bind(self.handles[-1], "<Leave>", lambda e: self.canvas.config(cursor=""))
                self.canvas_last_pos.append((tl_x, tl_y))  # 핸들의 중심 좌표 저장

                # Top-right handle
                tr_x = x + img_width / 2
                tr_y = y - img_height / 2
                self.handles.append(self.canvas.create_rectangle(
                    tr_x - handle_size, tr_y - handle_size,
                    tr_x + handle_size, tr_y + handle_size,
                    outline='black', fill='black', tags=("handle", "top_right")))
                self.canvas.tag_bind(self.handles[-1], "<Enter>", lambda e: self.canvas.config(cursor="top_right_corner"))
                self.canvas.tag_bind(self.handles[-1], "<Leave>", lambda e: self.canvas.config(cursor=""))
                self.canvas_last_pos.append((tr_x, tr_y))

                # Bottom-left handle
                bl_x = x - img_width / 2
                bl_y = y + img_height / 2
                self.handles.append(self.canvas.create_rectangle(
                    bl_x - handle_size, bl_y - handle_size,
                    bl_x + handle_size, bl_y + handle_size,
                    outline='black', fill='black', tags=("handle", "bottom_left")))
                self.canvas.tag_bind(self.handles[-1], "<Enter>", lambda e: self.canvas.config(cursor="bottom_left_corner"))
                self.canvas.tag_bind(self.handles[-1], "<Leave>", lambda e: self.canvas.config(cursor=""))
                self.canvas_last_pos.append((bl_x, bl_y))

                # Bottom-right handle
                br_x = x + img_width / 2
                br_y = y + img_height / 2
                self.handles.append(self.canvas.create_rectangle(
                    br_x - handle_size, br_y - handle_size,
                    br_x + handle_size, br_y + handle_size,
                    outline='black', fill='black', tags=("handle", "bottom_right")))
                self.canvas.tag_bind(self.handles[-1], "<Enter>", lambda e: self.canvas.config(cursor="bottom_right_corner"))
                self.canvas.tag_bind(self.handles[-1], "<Leave>", lambda e: self.canvas.config(cursor=""))
                self.canvas_last_pos.append((br_x, br_y))

            def select_handle(self, event):
                items = self.canvas.find_withtag("current")
                if items:
                    tags = self.canvas.gettags(items[0])
                    if "rotate_handle" in tags:
                        self.rotate_handle_selected = True
                        self.canvas.create_line(self.bg_size[0] // 2 - 50, self.bg_size[1] // 2, self.bg_size[0] // 2 + 50, self.bg_size[1] // 2, dash=(4, 2), fill='blue', tags="rotation_line")
                    elif "handle" in tags:
                        self.resize_handle_selected = tags[1]
                    else:
                        self.selected_image = True
                else:
                    self.selected_image = False

            def release_handle(self, event):
                self.rotate_handle_selected = False
                self.resize_handle_selected = None
                self.selected_image = False
                self.canvas.delete("rotation_line")

            def select_image(self, event):
                items = self.canvas.find_withtag("current")
                if items:
                    tags = self.canvas.gettags(items[0])
                    if "handle" in tags:
                        self.resize_handle_selected = tags[1]
                    else:
                        self.selected_image = True
                else:
                    self.selected_image = False

            def drag_image(self, event):
                if self.rotated_first_time == True:
                    self.already_used_rotate = True
                    self.radio_1.configure(state='disabled')
                    self.radio_2.configure(state='disabled')
                    self.radio_3.configure(state='disabled')
                    rotated_image = self.img_original.rotate(-self.angle, expand=True, fillcolor=(255, 255, 255))
            
                    width, height = rotated_image.size
                    center_x, center_y = width // 2, height // 2

                    # 핸들 좌표로부터 이미지의 너비, 높이 및 중심점 계산
                    min_x = center_x + min(coord[0] - center_x for coord in self.canvas_last_pos)
                    max_x = center_x + max(coord[0] - center_x for coord in self.canvas_last_pos)
                    min_y = center_y + min(coord[1] - center_y for coord in self.canvas_last_pos)
                    max_y = center_y + max(coord[1] - center_y for coord in self.canvas_last_pos)
                    
                    # 이미지의 새로운 중심을 계산합니다.
                    center_x = (min_x + max_x) / 2
                    center_y = (min_y + max_y) / 2
                    new_width = max_x - min_x
                    new_height = max_y - min_y

                    # 회전된 이미지에서 새로운 영역을 추출합니다.
                    cropped_image = rotated_image.crop((min_x, min_y, max_x, max_y))   
                    
                    # 조정된 이미지 업데이트
                    self.img_resized = cropped_image
                    self.img_original = cropped_image.copy()
                    self.image = ImageTk.PhotoImage(cropped_image)
                    self.img_size = cropped_image.size

                    # 이미지를 새로운 위치에 배치
                    if self.image_id:
                        self.canvas.delete(self.image_id)  # 기존 이미지 삭제
                    self.image_id = self.canvas.create_image(center_x, center_y, image=self.image, anchor='center')
                    self.canvas_last_pos = [(center_x - new_width / 2, center_y - new_height / 2),
                                            (center_x + new_width / 2, center_y - new_height / 2),
                                            (center_x - new_width / 2, center_y + new_height / 2),
                                            (center_x + new_width / 2, center_y + new_height / 2)]
                    
                self.rotated_first_time = False

                if self.resize_handle_selected:
                    self.resize_image(event)
                elif self.selected_image:
                    x, y = self.canvas.coords(self.image_id)
                    offset_x, offset_y = event.x - x, event.y - y

                    # 이미지를 정밀하게 움직이기 위해 이동 단위를 작게 조정
                    move_x = offset_x / 5  # 이동 단위 조정 (값을 더 작게 설정 가능)
                    move_y = offset_y / 5

                    self.canvas.move(self.image_id, move_x, move_y)
                    for handle in self.handles:
                        self.canvas.move(handle, move_x, move_y)
                # 핸들러 업데이트
                self.canvas.delete("handle")
                self.add_resize_handles()

            def resize_image(self, event):
                if not self.img_original:
                    return
                #self.already_used_rotate = True
                if self.rotated_first_time == True:
                    #self.already_used_rotate = True
                    self.radio_1.configure(state='disabled')
                    self.radio_2.configure(state='disabled')
                    self.radio_3.configure(state='disabled')
                    rotated_image = self.img_original.rotate(-self.angle, expand=True, fillcolor=(255, 255, 255))
            
                    # 핸들 좌표로부터 이미지의 너비, 높이 및 중심점 계산
                    min_x = min(coord[0] for coord in self.canvas_last_pos)
                    max_x = max(coord[0] for coord in self.canvas_last_pos)
                    min_y = min(coord[1] for coord in self.canvas_last_pos)
                    max_y = max(coord[1] for coord in self.canvas_last_pos)
                    
                    # 이미지의 새로운 중심을 계산합니다.
                    center_x = (min_x + max_x) / 2
                    center_y = (min_y + max_y) / 2
                    new_width = max_x - min_x
                    new_height = max_y - min_y

                    # 회전된 이미지에서 새로운 영역을 추출합니다.
                    cropped_image = rotated_image.crop((min_x, min_y, max_x, max_y))   
                    
                    # 조정된 이미지 업데이트
                    self.img_resized = cropped_image
                    self.img_original = cropped_image.copy()
                    self.image = ImageTk.PhotoImage(cropped_image)
                    self.img_size = cropped_image.size

                    # 이미지를 새로운 위치에 배치
                    if self.image_id:
                        self.canvas.delete(self.image_id)  # 기존 이미지 삭제
                    self.image_id = self.canvas.create_image(center_x, center_y, image=self.image, anchor='center')
                    self.canvas_last_pos = [(center_x - new_width / 2, center_y - new_height / 2),
                                            (center_x + new_width / 2, center_y - new_height / 2),
                                            (center_x - new_width / 2, center_y + new_height / 2),
                                            (center_x + new_width / 2, center_y + new_height / 2)]

                x, y = self.canvas.coords(self.image_id)
                handle_position = self.resize_handle_selected
                aspect_ratio = self.img_original.width / self.img_original.height

                if handle_position == "top_left":
                    new_width = int(((x + self.img_size[0] / 2) - event.x) * 1.05)
                    new_height = int(new_width / aspect_ratio)
                    new_x = x + (self.img_size[0] - new_width) / 2
                    new_y = y + (self.img_size[1] - new_height) / 2
                elif handle_position == "top_right":
                    new_width = int((event.x - (x - self.img_size[0] / 2)) * 1.05)
                    new_height = int(new_width / aspect_ratio)
                    new_x = x - (self.img_size[0] - new_width) / 2
                    new_y = y + (self.img_size[1] - new_height) / 2
                elif handle_position == "bottom_left":
                    new_width = int(((x + self.img_size[0] / 2) - event.x) * 1.05)
                    new_height = int(new_width / aspect_ratio)
                    new_x = x + (self.img_size[0] - new_width) / 2
                    new_y = y - (self.img_size[1] - new_height) / 2
                elif handle_position == "bottom_right":
                    new_width = int((event.x - (x - self.img_size[0] / 2)) * 1.05)
                    new_height = int(new_width / aspect_ratio)
                    new_x = x - (self.img_size[0] - new_width) / 2
                    new_y = y - (self.img_size[1] - new_height) / 2
                else:
                    return

                self.rotated_first_time = False
                self.radio_1.configure(state='disabled')
                self.radio_2.configure(state='disabled')
                self.radio_3.configure(state='disabled')
                if new_width > 20 and new_height > 20:  # Minimum size limit
                    self.img_size = (new_width, new_height)
                    self.img_resized = self.img_original.resize(self.img_size, Image.Resampling.LANCZOS)
                    self.image = ImageTk.PhotoImage(self.img_resized)

                    self.canvas.coords(self.image_id, new_x, new_y)
                    self.canvas.itemconfig(self.image_id, image=self.image)

                    self.canvas.delete("handle")
                    self.add_resize_handles()

            def run(self):
                self.canvas.bind("<B1-Motion>", self.drag_image)
                self.canvas.bind("<Button-1>", self.select_image)
                self.canvas.bind("<ButtonRelease-1>", lambda event: setattr(self, 'resize_handle_selected', None))

        class ImageEdit_SA:
            def __init__(self, filename, _contents, canvas_resolution, x_offset, y_offset, expand):
                self.filename = filename
                self._contents = _contents
                self.canvas_resolution = canvas_resolution
                self.x_offset = x_offset
                self.y_offset = y_offset
                self.expand = expand

                self.bg_size = tuple(map(int, canvas_resolution.split('x')))
                self.img_original = Image.open(self.filename).convert('RGB')
                self.load_image()
                self.apply_transformations()
                self.create_output()

            def load_image(self):
                # 이미지 크기를 배경 영역 내로 조정
                bg_width, bg_height = self.bg_size
                aspect_ratio = self.img_original.width / self.img_original.height
                
                if self.img_original.width > bg_width or self.img_original.height > bg_height:
                    if self.img_original.width / bg_width > self.img_original.height / bg_height:
                        new_width = bg_width
                        new_height = int(bg_width / aspect_ratio)
                    else:
                        new_height = bg_height
                        new_width = int(bg_height * aspect_ratio)
                else:
                    new_width, new_height = self.img_original.width, self.img_original.height

                self.img_size = (new_width, new_height)
                self.img_resized = self.img_original.resize(self.img_size, Image.Resampling.LANCZOS)

            def apply_transformations(self):
                # 확대/축소 적용
                new_width = int(self.img_size[0] * self.expand)
                new_height = int(self.img_size[1] * self.expand)
                self.img_resized = self.img_resized.resize((new_width, new_height), Image.Resampling.LANCZOS)

                # 오프셋 적용
                bg_width, bg_height = self.bg_size
                paste_x = (bg_width - new_width) // 2 + self.x_offset
                paste_y = (bg_height - new_height) // 2 + self.y_offset

                # 새 이미지 생성 및 붙여넣기
                self.composite_image = Image.new("RGB", self.bg_size, "white")
                self.composite_image.paste(self.img_resized, (paste_x, paste_y))

            def create_output(self):
                # mirror_mask 생성
                width, height = self.bg_size
                mask_width = width // 8
                mask_height = height // 8
                self.mirror_mask = np.zeros((mask_height, mask_width), dtype=int)

                # 이미지가 있는 영역 계산
                img_width, img_height = self.img_resized.size
                paste_x = (width - img_width) // 2 + self.x_offset
                paste_y = (height - img_height) // 2 + self.y_offset

                # mask 업데이트
                for y in range(mask_height):
                    for x in range(mask_width):
                        pixel_x = x * (width // mask_width)
                        pixel_y = y * (height // mask_height)
                        if (pixel_x < paste_x or pixel_x >= paste_x + img_width or
                            pixel_y < paste_y or pixel_y >= paste_y + img_height):
                            self.mirror_mask[y][x] = 1

                self.composite_image.save('tempimage.png')

                # 결과 저장
                app.outpainting_box = self.mirror_mask.copy()
                app.sync_outpainting = [self.composite_image.copy(), "outpaint", self.filename, self._contents, "auto"]

        # 사용 예:
        # image_edit = ImageEdit(filename, current_lookup.copy(), "1024x1024", 50, -30, 1.2)

        self.auto_i2i_request = False

        def instant_img2img(self, token=self.access_token, _replace=None, webui_nai_i2i_request=False, _from = "self"):
            if self.instant_i2i_state: 
                return
            else:
                self.instant_i2i_state = True
                self.nai_i2i_button.configure(state="disabled")
            if _from == "autonai": 
                current_lookup = self.image_queue[-1].copy()
                if self.auto_nai_setting[0][0] not in current_lookup[1]:
                    return
            elif _from == "adetailer":
                token = self.NAI_webui_address
                current_lookup = self.image_queue[-1].copy()
            elif  _from == "adetailer_current":
                _from = "adetailer"
                token = self.NAI_webui_address
                current_lookup = self.image_queue[self.current_window].copy()
            elif _from == "auto_i2i" or _from == "auto_inp":
                current_lookup = self.image_queue[-1].copy()
            else: current_lookup = self.image_queue[self.current_window].copy()
            def instant_image_generation(self, token):
                def image_to_base64(image):
                    image_bytesIO = io.BytesIO()
                    img.save(image_bytesIO, format="png")
                    return base64.b64encode(image_bytesIO.getvalue()).decode()
                def resize_image_to_64_multiples(filename):
                    img = Image.open(filename)
                    width, height = img.size

                    # 64의 배수로 맞추기 위해 새로운 너비와 높이 계산
                    new_width = (width // 64) * 64
                    new_height = (height // 64) * 64

                    # 이미지가 이미 64의 배수라면, 원본 이미지 반환
                    if new_width == width and new_height == height:
                        return img

                    # 이미지 크기를 조정하기 위한 상단 왼쪽 좌표 (0, 0)과
                    # 하단 오른쪽 좌표 (new_width, new_height)를 사용하여 이미지를 자름
                    img_cropped = img.crop((0, 0, new_width, new_height))
                    return img_cropped
                request_prompt = current_lookup[1]
                request_seed = current_lookup[2]
                filename = current_lookup[3]
                img = resize_image_to_64_multiples(filename)
                nw, nh = img.size
                if nw * nh > 2662400:
                    nw, nh = find_max_resolution(nw, nh, 2662400)
                    img = img.resize((nw, nh), Image.Resampling.LANCZOS)
                if _from == "autonai" or webui_nai_i2i_request:
                    nw, nh = find_max_resolution(nw, nh, 1048576)
                send_image = image_to_base64(img)
                scale_pre = self.cfg_scale_entry.get()
                steps = 28
                try:
                    scale_pre = round(float(app.i2i_cfg), 2) if (_from == "auto_i2i" or _from == "self") else float(app.cfg_scale_var.get())
                except:
                    scale_pre = 5.0
                    self.cfg_scale_var.set("5.0")
                rescale_pre = app.i2i_rescale if (_from == "auto_i2i" or _from == "self") else float(app.prompt_guidance_rescale_var.get())
                try:
                    rescale_pre = float(rescale_pre)
                except:
                    rescale_pre = 0
                    self.prompt_guidance_rescale_var.set("0")
                try:
                    steps = int(steps)
                except:
                    steps = 28
                    #self.cfg_scale_var.set("28")
                uncond_pre = self.uncond_strength_entry.get()
                try:
                    uncond_pre = float(uncond_pre)
                    #uncond_pre = round(uncond_pre / 0.05) * 0.05
                    if (uncond_pre > 162):
                        uncond_pre = 19.19
                        self.uncond_strength_entry.delete(0, "end")
                        self.uncond_strength_entry.insert(0,"19.19")
                except:
                    uncond_pre = 1.0
                    self.uncond_strength_entry.delete(0, "end")
                    self.uncond_strength_entry.insert(0, "19.19")
                i2i_negative_text = self.negative_prompt_input.get("0.0", "end-1c")
                if app.app_mode == "WEBUI" and _from == "self" and app.i2i_automatic_NAI_var.get() == 1:
                    text = request_prompt
                    text = NAIA_utils.transform_prompt(text)
                    bq =["best quality", "amazing quality", "very aesthetic", "absurdres"]
                    for k in bq: 
                        if k not in text:
                            text += f", {k}"
                    text = text.split(", ")
                    for k in text[2:]:
                        if k in cd.character_dictionary:
                            text.remove(k)
                            if "boy" in text[1] or "girl" in text[1]: text.insert(2, k)
                            else: text.insert(1, k)
                    text = ", ".join(text)
                    ntext = i2i_negative_text
                    ntext = NAIA_utils.transform_prompt(ntext)
                    nq = ["lowres", "bad", "error", "fewer", "extra", "missing", "worst quality", "jpeg artifacts", "bad quality", "watermark", "unfinished", "displeasing", "chromatic aberration", "signature", "extra digits", "artistic error", "username", "scan", "abstract"]
                    nnq = ""
                    for k in nq:
                        if k not in ntext:
                            nnq += f"{k}, "
                    ntext = nnq + ntext
                    request_prompt = text
                    i2i_negative_text = ntext                    
                    token = app.nai_access_token
                if _replace or webui_nai_i2i_request:
                    if len(self.auto_nai_setting) >= 6:
                        if ' + ' in self.auto_nai_setting[5]:
                            try: _sampler, _noise_schedule = self.auto_nai_setting[5].split(' + ')
                            except:
                                _sampler = "k_euler_ancestral"
                                _noise_schedule = "native"                   
                        else:
                            _sampler = "k_euler_ancestral"
                            _noise_schedule = "native"                                   
                    else:
                        _sampler = "k_euler_ancestral"
                        _noise_schedule = "native"                
                else:
                    if ' + ' in app.sampler_button.get():
                        _sampler, _noise_schedule = app.sampler_button.get().split(' + ')
                    else:
                        _sampler = app.sampler_button.get()
                        _noise_schedule = "native"
                gen_request = {
                        "width":self.i2i_width if not (webui_nai_i2i_request or _from == "autonai" or _from == "adetailer") else nw,
                        "height":self.i2i_height if not (webui_nai_i2i_request or _from == "autonai" or _from == "adetailer") else nh,
                        "quality_toggle":app.auto_quality_toggle_var.get(),
                        "seed":request_seed if self.i2i_seed_hold_check == True else random.randint(0,2**32 - 1),
                        "sampler":_sampler,
                        "noise_schedule": _noise_schedule,
                        "scale":scale_pre,
                        "uncond_scale":uncond_pre,
                        "sema":self.sema_button.get(),
                        "sema_dyn": self.dyn_button.get(),
                        "cfg_rescale": rescale_pre,
                        "prompt": request_prompt,
                        "negative":i2i_negative_text,
                        "user_screen_size": self.get_max_size(),
                        "start_time": self.start_time,
                        "access_token": token if token else app.access_token,
                        "save_folder": self.output_file_path,
                        "png_rule": self.name_var.get(),
                        "type": "upper",
                        "steps": steps if steps <= 50 else 50,
                        "image": send_image,
                        "strength": round(self.i2i_value, 2),
                        "noise": 0,
                        "enable_hr" : False,
                        "enable_AD" : False
                    }
                if int(gen_request["width"]) * int(gen_request["height"]) > 1048576 and "http" not in gen_request["access_token"]:
                    app.image_label_report.configure(state="normal")
                    app.image_label_report.delete("0.0", "end")
                    app.image_label_report.insert("0.0", "<UserAttention> Anlas가 소모되는 해상도 요청입니다.")
                    app.image_label_report.configure(text_color="#FFFF97")
                    app.image_label_report.configure(state="disabled")
                    app.anlas_request = True
                if app.app_mode == "NAI" and app.variety_button.get() == 1:
                    gen_request["skip_cfg_above_sigma"] = True
                if app.app_mode == "NAI" and app.decrsp_button.get() == 1:
                    gen_request["dynamic_thresholding"] = True
                if app.app_mode == "NAI": 
                    gen_request["steps"] = int(app.force_steps_entry.get())
                    if (_from == "auto_i2i" or _from == "self") and len(app.i2i_instant_text) > 2:
                        try: gen_request["prompt"] = request_prompt.replace(app.i2i_instant_text, app.i2i_instant_change)
                        except: pass
                    if (_from == "auto_i2i" or _from == "self") and app.i2i_auto_vibe:
                        gen_request["reference_information_extracted"] = app.i2i_vibe_ie
                        gen_request["reference_strength"] = app.i2i_vibe_rs
                        gen_request["reference_image"] = send_image
                    if app.auto_i2i_option_activate.get() == 1:
                        _text = app.auto_i2i_text
                        tx1 = _text.find("\n\n#캐릭터명\n")
                        tx2 = _text.find("\n\n#프롬프트\n")
                        _text = _text[:tx2+7] + ', ' + app.auto_i2i_t2 + ', ' +_text[tx2+7:]
                        _text = _text[:tx1] + app.auto_i2i_t1 + ', ' + _text[tx2-1:]
                        ltext = [t.strip() for t in _text.split(',')]
                        rm_list = []
                        for t in ltext:
                            if "|" in t or "<" in t or t == '': 
                                rm_list.append(t)
                        for t in rm_list:
                            if t in ltext:
                                ltext.remove(t)
                        rm_list = []
                        if app.auto_i2i_rm_prompt.get() == 1:
                            qe_word = app.data.get_qe_word()
                            wlist = [key.strip() for key in app.auto_i2i_t2.split(",")]
                            crst = ["hair", "eyes", "pupils", "heterochromia", "ears", "breast", "chest", "year", "quality", "aesthetic", "absurdres", "3d", "realistic", "anime", "nsfw", "loli", "aged down", "mature"]
                            try: tx3 = ltext.index("#프롬프트")
                            except: 
                                tlist = [key.strip() for key in app.auto_i2i_t2.split(",")]
                                tx3 = ltext.index(tlist[-1]) + 1
                            for t in ltext[tx3:]:                            
                                if not(any(color in t for color in crst) or t in qe_word or t in wlist):
                                    rm_list.append(t)
                            for t in rm_list:
                                if t in ltext:
                                    ltext.remove(t)
                        if "#프롬프트" in ltext:
                            ltext.remove("#프롬프트")
                        gen_request["prompt"] = ', '.join(ltext)
                    if _from == "adetailer":
                        ftext = gen_request["prompt"]
                        #ftext = ftext.replace("{", "").replace("}", "").replace("]", "").replace("[", "")
                        _rm_text = app.awai_entry3.get()
                        if len(_rm_text) > 3:
                            ftext = ftext.replace(_rm_text, "")
                        if app.awai_rm_artist.get() == 0:
                            ftext = [key.strip() for key in ftext.split(',')]
                            for i, _ in enumerate(ftext):
                                if "artist:" in ftext[i]:
                                    ftext[i] = ftext[i].replace("artist:", "")
                            # for i, _ in enumerate(ftext):
                            #     if ftext[i] in app.data.afilter_30000:
                            #         ftext[i] = "(" + ftext[i].replace("(", "\\(").replace(")", "\\)") + ":1.1)"
                            #         #ftext[i] = "by " + ftext[i].replace("(", "\(").replace(")", "\)") + ""
                            #     else:
                            #         ftext[i] = ftext[i].replace("(", "\\(").replace(")", "\\)")
                            ftext = ', '.join(ftext)
                            try: ftext = prompt_NAI_to_WEBUI(ftext)
                            except:
                                ftext = ftext.replace("{", "").replace("}", "").replace("]", "").replace("[", "")
                                ftext = prompt_NAI_to_WEBUI(ftext)
                        else:
                            _rm = []
                            ftext = [key.strip() for key in ftext.split(',')]
                            for i, _ in enumerate(ftext):
                                if "artist" in ftext[i]:
                                    _rm.append(ftext[i])
                            for k in _rm:
                                if k in ftext: ftext.remove(k)
                            ftext = ', '.join(ftext)
                            ftext = ftext.replace("(", "\\(")
                            ftext = ftext.replace(")", "\\)")
                        _add_prefix = app.awai_entry1.get()
                        if len(_add_prefix) > 3:
                            ftext = _add_prefix+', '+ftext
                        _add_postfix = app.awai_entry2.get()
                        if len(_add_postfix) > 3:
                            ftext = ftext+', '+_add_postfix
                        gen_request["prompt"] = ftext
                        _negative = app.awai_negative.get("0.0", "end-1c")
                        if len(_negative) > 3:
                            gen_request["negative"] = _negative
                if app.app_mode == "NAI" and int(gen_request["width"]) * int(gen_request["height"]) > 1048576:
                    gen_request["hires"] = True
                else:
                    gen_request["hires"] = False
                if app.app_mode == "NAI" and app.auto_i2i_vibe.get() == 1:
                    gen_request["auto_i2i"] = True
                if app.app_mode == "NAI" and _from == "adetailer" and (app.enable_autodetailer.get() == 1 or app.enable_auto_webui_i2i.get() == 0):
                    gen_request["nai_enable_AD"] = True
                    gen_request["enable_AD"] = True
                    gen_request["sampler"] = _sampler if _sampler in ["k_euler", "k_euler_ancestral", "k_dpmpp_sde"] else "k_dpmpp_sde"
                    gen_request["ad_data"] = app.data
                    gen_request["access_token"] = token
                    ad_str_pre = app.autodetailer_strength.get()
                    try:
                        ad_str_pre = float(ad_str_pre)
                        ad_str_pre = round(ad_str_pre, 2)
                    except:
                        ad_str_pre = 0.4
                        app.autodetailer_strength.delete(0, "end")
                        app.autodetailer_strength.insert(0, "0.4")
                    gen_request["ad_data_str"] =  ad_str_pre
                if _from == "adetailer":
                    gen_request["sampler_awai"] = app.awai_sampler_var.get()
                    gen_request["scheduler_awai"] = app.awai_current_scheduler.get()
                if _from == "adetailer" and (app.enable_auto_webui_i2i.get() == 1):
                    try: _ds =  round(float(app.enable_auto_webui_i2i_strength.get()), 2)
                    except: _ds = 0.55
                    gen_request["denoising_strength"] = _ds
                    if app.enable_auto_hires.get() == 1:
                        try:
                            upscale_pre = float(app.enable_auto_hires_x.get())
                            upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                            gen_request["width"] = math.floor(gen_request["width"] * upscale_pre / 8) * 8
                            gen_request["height"] = math.floor(gen_request["height"] * upscale_pre / 8) * 8
                        except:
                            pass
                if app.app_mode == "WEBUI" and (app.autonai.get()==1 or webui_nai_i2i_request):
                    if _replace:
                        for replace_item in _replace[0]:
                            gen_request["prompt"] = gen_request["prompt"].replace(replace_item, "")
                        if _replace[1] != '':
                            gen_request["prompt"] = gen_request["prompt"].replace(_replace[1], _replace[2])
                        else:
                            if _replace[2]: gen_request["prompt"] = _replace[2] + ', ' + gen_request["prompt"]
                        #gen_request["prompt"] = gen_request["prompt"].replace('\(', '(').replace('\)', ')')
                        #gen_request["prompt"] = re.sub(r':\d+\.\d+', '', gen_request["prompt"])
                        gen_request["prompt"] += _replace[3]
                        gen_request["negative"] = _replace[4] if len(_replace[4]) > 2 else i2i_negative_text
                        gen_request["webui_nai_i2i"] = True
                        text = gen_request["prompt"]
                        text = NAIA_utils.transform_prompt(text)
                        bq =["best quality", "amazing quality", "very aesthetic", "absurdres"]
                        for k in bq: 
                            if k not in text:
                                text += f", {k}"
                        text = text.split(", ")
                        for k in text[2:]:
                            if k in cd.character_dictionary:
                                text.remove(k)
                                if "boy" in text[1] or "girl" in text[1]: text.insert(2, k)
                                else: text.insert(1, k)
                        text = ", ".join(text)
                        ntext = gen_request["negative"]
                        ntext = NAIA_utils.transform_prompt(ntext)
                        nq = ["lowres", "bad", "error", "fewer", "extra", "missing", "worst quality", "jpeg artifacts", "bad quality", "watermark", "unfinished", "displeasing", "chromatic aberration", "signature", "extra digits", "artistic error", "username", "scan", "abstract"]
                        nnq = ""
                        for k in nq:
                            if k not in ntext:
                                nnq += f"{k}, "
                        ntext = nnq + ntext
                        gen_request["prompt"] = text
                        gen_request["negative"] = ntext                    
                if app.app_mode == "WEBUI" and self.sema_button_var.get() == 1:
                    try:
                        hr_steps_pre = int(self.hires_steps_entry.get())
                    except:
                        hr_steps_pre = 16
                        self.hires_steps_entry.delete(0, "end")
                        self.hires_steps_entry.insert(0, '16')
                    try:
                        upscale_pre = float(self.upscale_entry.get())
                        upscale_pre = math.floor(upscale_pre / 0.05) * 0.05
                    except:
                        upscale_pre = 1.5
                    self.upscale_entry.delete(0, "end")
                    self.upscale_entry.insert(0, str(upscale_pre))
                    try:
                        denoise_pre = float(self.denoise_entry.get())
                    except:
                        denoise_pre = 0.35
                        self.denoise_entry.delete(0, "end")
                        self.denoise_entry.insert(0, '0.35')
                    gen_request["enable_hr"] = True
                    gen_request["hr_second_pass_steps"] = hr_steps_pre
                    gen_request["hr_upscaler"] = self.hires_sampler_entry.get()
                    gen_request["hr_scale"] = upscale_pre
                    gen_request["denoising_strength"] = denoise_pre
                if self.awai_activate_i2i.get() == 1:
                    gen_request["enable_AD"] = True
                    ad_str_pre = app.autodetailer_strength.get()
                    try:
                        ad_str_pre = float(ad_str_pre)
                        ad_str_pre = round(ad_str_pre, 2)
                    except:
                        ad_str_pre = 0.4
                        app.autodetailer_strength.delete(0, "end")
                        app.autodetailer_strength.insert(0, "0.4")
                    gen_request["ad_data_str"] =  ad_str_pre
                if app.app_mode == "WEBUI" and app.enable_cfg_rescale.get() == 1:
                    gen_request["CFG_rescale"] = True
                    cfg_str_pre = app.enable_cfg_rescale_strength.get()
                    try:
                        cfg_str_pre = float(cfg_str_pre)
                        cfg_str_pre = round(cfg_str_pre, 2)
                    except:
                        cfg_str_pre = 0.5
                        app.enable_cfg_rescale_strength.delete(0, "end")
                        app.enable_cfg_rescale_strength.insert(0, "0.5")
                    gen_request["CFG_rescale_str"] =  cfg_str_pre
                    gen_request["CFG_rescale_version"] = "normal" if app.enable_cfg_rescale_old.get() == 0 else "old"
                if app.app_mode == "WEBUI" and app.custom_script_activate_var.get() == 1: gen_request['custom_script'] = app.custom_script_text.get("1.0", "end-1c").strip()
                if app.app_mode == "WEBUI" and app.enable_DT.get() == 1:
                    gen_request["DynamicThresholding"] = True
                def run_generation():
                        if gen_request["png_rule"] == "count":
                            self.generation_count += 1
                            gen_request["count"] =self.generation_count
                        self.state_label.configure(text ="state : img2img 요청됨 ", text_color = "#FFFF97")
                        if app.save_folder_option and app.save_folder_option["isEnabled"]:
                            if app.save_folder_option["depth1"] == "EQ(nsfw)/SG(safe)":
                                app.save_folder_additional_name["command1"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                            elif app.save_folder_option["depth1"] == "와일드카드 지정": pass
                            else: app.save_folder_additional_name["command1"] = app.save_folder_update(gen_request, app.save_folder_option, 1)
                            if app.save_folder_option["depth2"] == "EQ(nsfw)/SG(safe)":
                                app.save_folder_additional_name["command2"] = "nsfw" if (app.current_prompt_rating == "e" or app.current_prompt_rating == "q") else "safe"
                            elif app.save_folder_option["depth2"] == "와일드카드 지정": pass
                            else: app.save_folder_additional_name["command2"] = app.save_folder_update(gen_request, app.save_folder_option, 2)
                            try:
                                gen_request["additional_save_folder"] = { 
                                    "command1": app.save_folder_additional_name["command1"],
                                    "command2": app.save_folder_additional_name["command2"]
                                    }
                            except:
                                gen_request["additional_save_folder"] = { 
                                    "command1": "",
                                    "command2": ""
                                    }                     
                            app.save_folder_additional_name = {}
                        if _from != "adetailer" and app.access_token_muiti and app.nai_generation_count%2 == 1: gen_request["access_token"] = app.access_token_muiti
                        if _from != "adetailer" and app.anlas_request and app.access_token_muiti:
                            if app.my_anlas.get() > app.my_anlas_multi.get(): 
                                gen_request["access_token"] = app.access_token
                            else:gen_request["access_token"] = app.access_token_muiti
                        if (app.current_model_nai.get() == "NAID4" or app.current_model_nai.get() == "NAID4-Curated") and (len(self.image_queue[self.current_window]) > 4 and "characters" in self.image_queue[self.current_window][4]): 
                            gen_request['characters'] = self.image_queue[self.current_window][4]['characters']
                            gen_request['characters_uc'] = self.image_queue[self.current_window][4]['characters_uc']
                            gen_request['characters_pos'] = False if app.ai_choice.get() == 1 else True
                            gen_request['characters_pos_list'] = app.naid4_positions[:len(gen_request['characters'])]
                            gen_request['naid4_addict'] = {"naid4_legacy_uc": bool(app.naid4_legacy_uc.get()), "naid4_auto_character_prompt_fill": bool(app.naid4_auto_character_prompt_fill.get()), "anid4_auto_character_add_negative_series": bool(app.anid4_auto_character_add_negative_series.get()), "copyright_dict": app.character_copyright_dict, "character_dict":character_dict_full, "naid4_auto_character_girls": bool(app.naid4_auto_character_girls.get()), "naid4_auto_character_boys": bool(app.naid4_auto_character_boys.get()), "conditional": bool(app.naid4_cond.get()), "cond_prompt":app.naid4_cond_prompt, "cond_negative":app.naid4_cond_negative}
                            #if app.eye_catch.get() == 1: gen_request["eye_catch"] = True
                        result_image, result_prompt, result_seed, info, filename, response_time = NAIA_generation.generate(gen_request, app.current_model_nai.get())
                        if _from != "adetailer" : self.nai_generation_count += 1
                        self.instant_i2i_state = False
                        self.state_label.configure(text =f"img2img 요청 반환됨, RT : {response_time}s", text_color = "#DCE4EE")
                        try:
                            if app.anlas_request and app.app_mode == "NAI" and filename and "Adetailer" not in filename: 
                                self.get_anlas()
                                app.anlas_request = False
                        except:
                            pass
                        if info:
                            if (app.app_mode == "NAI" and "https" not in token):
                                temp = info.get('Comment', '')
                            elif 'parameters' in info.keys():
                                temp = info['parameters']
                            elif 'Comment' in info.keys():
                                temp = info.get('Comment', '')
                            else:
                                temp = result_prompt
                            if temp == '': 
                                try: temp = info['parameters']
                                except: temp = ''
                            if app.app_mode == "NAI" and "http" not in token: temp = temp[temp.find("prompt")+10:temp.find("skip_cfg_below_sigma")-3].replace('"','')
                        else:
                            temp = result_prompt
                        naia_functions.process_text_with_links(self, app.image_label_report, temp, artist_dict)
                        if result_image:
                            if app.state() != 'zoomed':
                                instant_result_image = customtkinter.CTkImage(result_image, size=(620,620))
                            else:
                                current_image = Image.open(filename)
                                new_image = self.resize_and_center_image(current_image, self.wide_res_width, self.wide_res_height)
                                instant_result_image = customtkinter.CTkImage(new_image, size=(self.wide_res_width, self.wide_res_height))
                            self.image_label.configure(image=instant_result_image)
                            set_image_to_queue(result_image, result_prompt, str(result_seed), filename)
                generation_thread = threading.Thread(target=run_generation, daemon=True)
                generation_thread.start()
            
            def find_max_resolution(width, height, max_pixels=2166784, multiple_of=64):
                ratio = width / height

                max_width = int((max_pixels * ratio)**0.5)
                max_height = int((max_pixels / ratio)**0.5)

                max_width = (max_width // multiple_of) * multiple_of
                max_height = (max_height // multiple_of) * multiple_of

                while max_width * max_height > max_pixels:
                    max_width -= multiple_of
                    max_height = int(max_width / ratio)
                    max_height = (max_height // multiple_of) * multiple_of

                return (max_width, max_height)


            img = Image.open(current_lookup[3])
            width, height = img.size
            v = self.i2i_resolution
            if v == 0 or (app.app_mode=="WEBUI" and app.autonai.get()==1): 
                self.i2i_width = width
                self.i2i_height = height
            elif v == 1:
                self.i2i_width, self.i2i_height = find_max_resolution(width, height, 2166784)
            elif v == 2:
                self.i2i_width, self.i2i_height = find_max_resolution(width, height, 