import pandas as pd
import numpy as np
import re
from NAIA_utils import keyword_dict
from character_dictionary import character_dictionary as cd

def conditional_search(prompt: str, command: str) -> bool:
    def _parse_conditional_command(command):
        match = re.match(r"\((.*?)\)\:(.*)", command)
        if match:
            return match.groups()
        return '', command
    def _check_condition(processed, condition):
        if not condition:
            return True
        sub_conditions = re.split(r'\)\s*&\s*\(', condition)
        sub_conditions = [re.sub(r'^\(|\)$', '', cond) for cond in sub_conditions]

        results = []
        for sub_cond in sub_conditions:
            if '&' in sub_cond:
                results.append(all(_check_condition(processed, cond) for cond in sub_cond.split('&')))
            elif '|' in sub_cond:
                results.append(any(_check_condition(processed, cond) for cond in sub_cond.split('|')))
            else:
                # PM
                if sub_cond.startswith('*'):
                    results.append(sub_cond[1:] in processed)
                # NOT IN
                elif sub_cond.startswith('~!'):
                    results.append(sub_cond[2:] not in processed)
                elif sub_cond.startswith('~'):
                    results.append(all(sub_cond[1:] not in element for element in processed))
                # CONTAIN
                else:
                    results.append(any(sub_cond in element for element in processed))
        return all(results)
    processed = [pr.strip() for pr in prompt.split(',')]
    condition, cmd = _parse_conditional_command(command)
    if not _check_condition(processed, condition):
        return False
    else:
        return True

def parse_and_execute_commands(processed, user_input, fix, after, popped_row):
    commands = [cmd.strip() for cmd in user_input.split(',') if not cmd.strip().startswith('#')]
    for command in commands:
        condition, cmd = parse_conditional_command(command)
        nfix = [item.translate(str.maketrans('', '', '{}[]')) for item in fix if not item.startswith('#')]
        if check_condition(processed+nfix, condition, popped_row):
            processed = execute_command(processed, cmd, fix, after)
    return processed

def parse_conditional_command(command):
    match = re.match(r"\((.*?)\)\:(.*)", command)
    if match:
        return match.groups()
    return '', command

def check_condition(processed, condition, popped_row):
    if not condition:
        return True
    sub_conditions = re.split(r'\)\s*&\s*\(', condition)
    sub_conditions = [re.sub(r'^\(|\)$', '', cond) for cond in sub_conditions]

    results = []
    for sub_cond in sub_conditions:
        if '&' in sub_cond:
            results.append(all(check_condition(processed, cond, popped_row) for cond in sub_cond.split('&')))
        elif '|' in sub_cond:
            results.append(any(check_condition(processed, cond, popped_row) for cond in sub_cond.split('|')))
        else:
            if sub_cond in ['e', 'q', 's', 'g']:
                results.append(sub_cond == popped_row['rating'])
            elif sub_cond in ['~e', '~q', '~s', '~g']:
                results.append(sub_cond != popped_row['rating'])
            # PM
            elif sub_cond.startswith('*'):
                results.append(sub_cond[1:] in processed)
            # NOT IN
            elif sub_cond.startswith('~!'):
                results.append(sub_cond[2:] not in processed)
            elif sub_cond.startswith('~'):
                results.append(all(sub_cond[1:] not in element for element in processed))
            # CONTAIN
            else:
                results.append(any(sub_cond in element for element in processed))
    return all(results)

def execute_command(processed, command, fix, after):
    if '+=' in command:
        keyword, addition = command.split('+=', 1)
        addition = addition.replace('^', ', ')
        #addiction split 해서 프롬프트 존재하는지 체크 필요
        return insert_text_after_keyword(processed, keyword, addition, fix, after)
    elif '=' in command:
        keyword, replacement = command.split('=', 1)
        if keyword in processed:
            replacement = replacement.replace('^', ', ')
            #replacement split 해서 프롬프트 존재하는지 체크 필요
            index = processed.index(keyword)
            processed[index] = replacement
    return processed

def insert_text_after_keyword(processed, user_keyword, user_additional_keyword, fix, after):
    if user_keyword == "prompt":
        processed.append(user_additional_keyword)
    elif user_keyword == "prefix":
        fix.append(user_additional_keyword)
    elif user_keyword == "postfix":
        after.append(user_additional_keyword)
    elif user_keyword in processed:
        index = processed.index(user_keyword) + 1
        processed.insert(index, user_additional_keyword)
    return processed

def find_keyword_index(general):
    # boys와 girls 리스트의 원소가 있는지 확인 및 인덱스 저장
    boys = ["1boy", "2boys", "3boys", "4boys", "5boys", "6+boys"]
    girls = ["1girl", "2girls", "3girls", "4girls", "5girls", "6+girls"]
    #others = ["1other", "2others", "3others", "4others", "5others", "6+others"]
    boys_indices = [i for i, item in enumerate(general[:6]) if item in boys]
    girls_indices = [i for i, item in enumerate(general[:6]) if item in girls]

    # case 1과 case 2: girls 리스트의 원소 찾기
    if girls_indices:
        return girls_indices[0]+1
    
    # case 3: boys 리스트의 원소 찾기
    if boys_indices:
        return boys_indices[0]+1

    # case 4: 해당 사항 없음
    # 2월 12일에 해당 부분 return 2 -> return 0 으로 수정하였으며 이 부분 트래킹 필요
    return 0

def process_list(temp_fixed):
    i = 0
    while i < len(temp_fixed):
        if ', ' in temp_fixed[i]:
            # 해당 원소를 처리하는 함수에 전달하고 결과를 받음
            processed_items = process_fix_prompt(temp_fixed[i])
            # 원래 원소를 제거
            temp_fixed.pop(i)
            # 처리된 원소들을 현재 인덱스에 삽입
            for item in reversed(processed_items):
                temp_fixed.insert(i, item)
            # 삽입된 원소들을 건너뛰기 위해 인덱스 조정
            i += len(processed_items)
        else:
            i += 1
    return temp_fixed

def process_fix_prompt(fix_prompt):
    fix = []
    lt_count = 0  # '<' 문자 개수 추적
    current_item = ""  # 현재 항목을 결합하기 위한 변수
    if isinstance(fix_prompt, list):
        fix_prompt = ', '.join(fix_prompt)

    # fix_prompt를 쉼표로 분리하고 각 항목을 순회
    for item in fix_prompt.split(','):
        item = item.strip()  # 공백 제거

        if '<' in item:
            lt_count += item.count('<')  # '<' 발견 시 카운트 증가
            lt_count -=  item.count('>')
            if current_item:  # 이미 current_item에 값이 있는 경우 쉼표와 공백 추가
                current_item += ", "
            if lt_count <= 0:  # lt_count가 0이면 일반 항목으로 처리
                fix.append(item)
            else:
                current_item += item  # 현재 항목에 추가
        elif '>' in item:
            lt_count -= item.count('>')  # '>' 발견 시 카운트 감소
            current_item += ", " + item  # '>'가 있는 항목도 현재 항목에 추가
            if lt_count == 0:  # '<'와 '>'의 개수가 매칭되면 fix에 추가하고 current_item 초기화
                fix.append(current_item)
                current_item = ""
        else:
            if lt_count <= 0:  # lt_count가 0이면 일반 항목으로 처리
                fix.append(item)
            else:  # lt_count가 0이 아니면 현재 항목에 계속해서 추가
                current_item += ", " + item

    # 마지막에 남은 current_item 처리
    if current_item:
        fix.append(current_item)

    return fix

def prompt_frequency_limit(general, removed, frequency_limit, prompt_freq):
    # general 리스트를 순회하면서 빈도를 체크합니다.
    i = 0
    while i < len(general):
        prompt = general[i]
        # prompt_freq에서 빈도를 가져옵니다. 없으면 0을 반환합니다.
        frequency = prompt_freq.get(prompt, 0)
        # 빈도가 frequency_limit보다 작으면 제거합니다.
        if frequency < frequency_limit:
            removed.append(general.pop(i))
        else:
            i += 1
    return general

def prompt_frequency_limit_hidden(general, data, colors, mf):
    sub_general = general.copy()
    i = 0
    while i < len(sub_general):
        prompt = sub_general[i]
        frequency = data.prompt_freq.get(prompt, 0)
        if frequency < 2000:
            sub_general.pop(i)
        else:
            i += 1
    temp_general = []
    for keyword in sub_general:
        if any(color in keyword for color in colors):
            temp_general.append(keyword)
    for keyword in temp_general:
        if " eyes" not in keyword and " hair" not in keyword and " pupils" not in keyword:
            if keyword in sub_general: sub_general.remove(keyword)
    clothes = data.attire_list
    for keyword in sub_general:
        if keyword in clothes or ":" in keyword or len(keyword) <= 3:
            temp_general.append(keyword)
    for keyword in temp_general:
        if keyword not in data.bag_of_tags:
            if keyword in sub_general: sub_general.remove(keyword)
    for keyword in sub_general:
        if keyword in data.bag_of_tags:
            temp_general.append(keyword)
    for keyword in temp_general:
        if keyword in sub_general: sub_general.remove(keyword)
    if mf:
        if "girl" in sub_general[0] and "boy" in sub_general[1]:
            sub_general[0], sub_general[1] = sub_general[1], sub_general[0]
    else:
        if "boy" in sub_general[0] and "girl" in sub_general[1]:
            sub_general[0], sub_general[1] = sub_general[1], sub_general[0]

    return sub_general

def get_joined_string(fix):
    for idx in range(len(fix) - 1, -1, -1):
        if '#' in fix[idx] or 'artist' in fix[idx]:
            plr = fix[idx + 1:]
            temp_general = []
            for keyword in plr:
                if 'eyes' in keyword or 'pupils' in keyword or 'multicolored' in keyword:
                    temp_general.append(keyword)
            for keyword in temp_general:
                if keyword in plr: plr.remove(keyword)
            return ', '.join(plr).replace("{", "").replace("}", "").replace("]", "").replace("[", "")
    return ''


def compress_prompt(general, removed):
    # 1. general 리스트의 모든 원소를 split
    split_general = [item.split() for item in general]
    # 2. 하위 집합 문자열 소거
    i = 0
    while i < len(split_general):
        j = 0
        while j < len(split_general):
            if i != j:
                if all(word in split_general[j] for word in split_general[i]):
                    if len(split_general[i]) <= len(split_general[j]):
                        removed.append(" ".join(split_general[i]))  # 제거된 항목을 removed 리스트에 추가
                        del split_general[i]
                        i -= 1
                        break
                    else:
                        removed.append(" ".join(split_general[j]))  # 제거된 항목을 removed 리스트에 추가
                        del split_general[j]
                        j -= 1
            j += 1
        i += 1
    compressed_general = [" ".join(item) for item in split_general]
    return compressed_general

def RFP(popped_row, fix_prompt, after_prompt, auto_hide_prompt, rm_a, rm_s, rm_c, rm_loc, rm_color, rm_clothes, nsfw, data, magic_word):
    boys = ["1boy", "2boys", "3boys", "4boys", "5boys", "6+boys"]
    girls = ["1girl", "2girls", "3girls", "4girls", "5girls", "6+girls"]
    if "|" in popped_row['general']:
        popped_row['general'] = popped_row['general'].replace("<|>_<|>", "bar eyes")
        popped_row['general'] = popped_row['general'].replace("| |", "bar eyes")
        popped_row['general'] = popped_row['general'].replace("|_|", "bar eyes")
        popped_row['general'] = popped_row['general'].replace("\||/", "open \m/")
        popped_row['general'] = popped_row['general'].replace(":|", "neutral face")
        popped_row['general'] = popped_row['general'].replace(";|", "neutral face")
    general = [item.strip() for item in popped_row['general'].split(',')]
    if "v" in general: 
        general[general.index("v")] = "peace sign"
    if "double v" in general: 
        general[general.index("double v")] = "double peace"
    eye_check = False
    if '*(wildcard standalone)' in general or "eye_catch" in magic_word:
        eye_check = True
    else:
        for key in general: 
            if ('eye' in key and key != 'closed eyes'): eye_check = True
    special_word_check = fix_prompt+', '+after_prompt
    prompt_duplicate_check = re.sub(r'[\{\}\[\]]', '', special_word_check)
    special_word_check = [item.strip() for item in special_word_check.split(',')]
    prompt_duplicate_check = [item.strip() for item in prompt_duplicate_check.split(',')]
    special_word_check = [item for item in special_word_check if item.startswith('*')]
    colors = ['black','white','blond','silver','gray','yellow','blue','purple','red','pink','brown','orange','green','aqua','gradient']
    ecs = [color+" eye" for color in colors] + [' pupils','ing eye']
    general = [item for item in general if item not in prompt_duplicate_check]

    rm_dict = {}
    exc = []
    for keyword in general:
        if keyword == '!' or keyword == '!?' or keyword == '!!' or keyword == '...' or keyword == '^^^' or keyword == '+++':
            exc.append(keyword)
    if exc:
        for keyword in exc:
            general.remove(keyword)
        general[3:3] = exc

    rm_word = []
    w_word = []
    rdict = {
        "rm_word": rm_word,
        "w_word": w_word
    }
    removed = []
    if "prompt_compress" in magic_word:
        general = compress_prompt(general, removed)
    if "frequency_limit" in magic_word:
        general = prompt_frequency_limit(general, removed, magic_word["frequency_limit"], data.prompt_freq)
    if magic_word["fts1"] == True:
        sub_general = prompt_frequency_limit_hidden(general, data, colors, magic_word["male_before_girl"])

    if nsfw == 1:
        nsfw_word = []
        for keyword in general:
            if keyword in data.qe_word or keyword in data.bag_of_tags or "horns" in keyword or "(" in keyword or keyword in boys or keyword in girls:
                nsfw_word.append(keyword)
            elif keyword in magic_word["nsfw_whitelist"]:
                nsfw_word.append(keyword)
                w_word.append(keyword)
            else:
                rm_word.append(keyword)
        nsfw_word = list(set(nsfw_word))
        nsfw_word.sort()
        general = nsfw_word
    if rm_loc == 1:
        temp_general = []
        locations = ['indoors', 'outdoors', 'airplane interior', 'airport', 'apartment', 'arena', 'armory', 'bar', 'barn', 'bathroom', 'bathtub', 'bedroom', 'bell tower', 'billiard room', 'book store', 'bowling alley', 'bunker', 'bus interior', 'butcher shop', 'cafe', 'cafeteria', 'car interior', 'casino', 'castle', 'catacomb', 'changing room', 'church', 'classroom', 'closet', 'construction site', 'convenience store', 'convention hall', 'court', 'dining room', 'drugstore', 'ferris wheel', 'flower shop', 'gym', 'hangar', 'hospital', 'hotel room', 'hotel', 'infirmary', 'izakaya', 'kitchen', 'laboratory', 'library', 'living room', 'locker room', 'mall', 'messy room', 'mosque', 'movie theater', 'museum', 'nightclub', 'office', 'onsen', 'ovservatory', 'phone booth', 'planetarium', 'pool', 'prison', 'refinery', 'restaurant', 'restroom', 'rural', 'salon', 'school', 'sex shop', 'shop', 'shower room', 'skating rink', 'snowboard shop', 'spacecraft interior', 'staff room', 'stage', 'supermarket', 'throne', 'train station', 'tunnel', 'airfield', 'alley', 'amphitheater', 'aqueduct', 'bamboo forest', 'beach', 'blizzard', 'bridge', 'bus stop', 'canal', 'canyon', 'carousel', 'cave', 'cliff', 'cockpit', 'conservatory', 'cross walk', 'desert', 'dust storm', 'flower field', 'forest', 'garden', 'gas staion', 'gazebo', 'geyser', 'glacier', 'graveyard', 'harbor', 'highway', 'hill', 'island', 'jungle', 'lake', 'market', 'meadow', 'nuclear powerplant', 'oasis', 'ocean bottom', 'ocean', 'pagoda', 'parking lot', 'playground', 'pond', 'poolside', 'railroad', 'rainforest', 'rice paddy', 'roller coster', 'rooftop', 'rope bridge', 'running track', 'savannah', 'shipyard', 'shirine', 'skyscraper', 'soccor field', 'space elevator', 'stair', 'starry sky', 'swamp', 'tidal flat', 'volcano', 'waterfall', 'waterpark', 'wheat field', 'zoo', 'white background', 'simple background', 'grey background', 'gradient background', 'blue background', 'black background', 'yellow background', 'pink background', 'red background', 'brown background', 'green background', 'purple background', 'orange background']
        for keyword in general:
            if keyword in locations:
                temp_general.append(keyword)
        for keyword in temp_general:
            general.remove(keyword)
            removed.append(keyword)
    if rm_color == 1:
        temp_general = []
        for keyword in general:
            if any(color in keyword for color in colors):
                temp_general.append(keyword)
        for keyword in temp_general:
            if " eyes" not in keyword and " hair" not in keyword and " pupils" not in keyword:
                general.remove(keyword)
                removed.append(keyword)
    if rm_clothes == 1:
        temp_general = []
        clothes = data.attire_list
        for keyword in general:
            if keyword in clothes:
                temp_general.append(keyword)
        for keyword in temp_general:
            if keyword not in data.bag_of_tags:
                general.remove(keyword)
                removed.append(keyword)
    if "*(keep only characteristic and clothes)" in special_word_check:
        _temp_general = []
        whitelist = data.attire_list + data.bag_of_tags
        for keyword in general:
            if "horns" in keyword or "(" in keyword or keyword in boys or keyword in girls or keyword in whitelist:
                _temp_general.append(keyword)
        _temp_general = list(set(_temp_general))
        _temp_general.sort()
        general = _temp_general
    if rm_c == 1:
        temp_general = []
        for keyword in general:
            if keyword in data.bag_of_tags:
                temp_general.append(keyword)
        for keyword in temp_general:
            general.remove(keyword)
            removed.append(keyword)
    
    #NAIA_random_function_core.process_fix_prompt()
    fix = process_fix_prompt(fix_prompt)

    if magic_word["fts1"] == True:
        ffix = get_joined_string(fix)
        if ffix != '': 
            sub_general.insert(2, ffix)

    if not fix or fix  == ['']:
        fix = ['#선행태그']

    at_first = []
    for fp in fix:
        if fp.startswith('*'):
            at_first.append(fp[1:])
    if at_first:
        for af in at_first:
            if '*'+af in fix:
                fix.remove('*'+af)
    if rm_a == 0:
        if popped_row['artist']:
            artists = [item.strip() for item in popped_row['artist'].split(',')]
            artist = ["artist:" + _artist for _artist in artists]
            fix = fix + artist
    if rm_s == 0:
        if popped_row['copyright']:
            series = [item.strip() for item in popped_row['copyright'].split(',')]
        else:
            series = []
        fix = fix + series
    after = [item.strip() for item in after_prompt.split(',')]

    if not after or after == ['']:
        after = ['#후행태그']

    auto_hide = [item.strip() for item in auto_hide_prompt.split(',') if not item.strip().startswith('#')] + ["| |", ":|", "\||/", "<|> <|>", "|| ||", ";|"]
    processed = general.copy()
    temp_hide_prompt = []
    pass_prompt = [item.replace('~', '') for item in auto_hide if item.startswith('~')]
    auto_hide = [item for item in auto_hide if not item.startswith('~')]
    for keyword in processed:
        if keyword in auto_hide:
            temp_hide_prompt.append(keyword)
    for keyword in temp_hide_prompt:
        processed.remove(keyword)
        removed.append(keyword)

    to_remove = []
    for item in auto_hide:
        modified_item = item
        if item.startswith("__") and item.endswith("__"):
            # 모든 _를 제거합니다.
            modified_item = modified_item.replace("_", "")
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.startswith("_") and item.endswith("_"):                                                                                              
            # 모든 _를 공백으로 대체합니다.
            modified_item = modified_item.replace("_", " ")
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.startswith("_"):
            # 시작하는 _를 공백으로 대체합니다.
            modified_item = modified_item.replace("_", " ", 1)
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.endswith("_"):
            # 끝나는 _를 공백으로 대체합니다.
            modified_item = " " + modified_item.rstrip("_") + " "
            to_remove += [keyword for keyword in processed if modified_item.strip() in keyword]

    # 조건에 맞는 키워드를 processed에서 제거합니다.
    to_remove = list(set(to_remove))
    if to_remove:
        for keyword in to_remove:
            if keyword in processed and keyword not in pass_prompt: 
                processed.remove(keyword)
                removed.append(keyword)
    removed = ', '.join(removed)

    add_ev = []
    if 'event' in magic_word and magic_word['event']['add']:
        add_ev = magic_word['event']['add']
        fixc = fix.copy()

    #여기에서 문제의 magic word 처리
    if "cpp" in magic_word and magic_word["cpp"] and "cond" in magic_word and magic_word["cond"]:
        user_input = magic_word["cond"]
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix
        fix_index += len(fix)
        fix = []
        processed = parse_and_execute_commands(processed, user_input, fix, after, popped_row)
        if fix: processed[fix_index:fix_index] = fix
    elif "cond" in magic_word and magic_word["cond"]:
        user_input = magic_word["cond"]
        processed = parse_and_execute_commands(processed, user_input, fix, after, popped_row)
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix
    else:
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix

    if add_ev:
        last_hash_string = None
        for item in reversed(fixc):
            if '#' in item:
                last_hash_string = item
                break
        if last_hash_string:
            last_hash_index = fixc.index(last_hash_string)
            insert_index = last_hash_index + 2 
            temp_rm = [k for k in add_ev if k in processed]
            for k in temp_rm:
                if k in processed: processed.remove(k)
            for k in temp_rm:
                processed.insert(insert_index, "{"+k+"}")
                insert_index += 1

    temp_processed = processed.copy()
    processed += after

    if rm_c == 0 and '*(remove character name)' not in special_word_check and '*(set character name after prefix)' not in special_word_check and '*(set character name before prefix)' not in special_word_check:
        if popped_row['character']:
            character = [item.strip() for item in popped_row['character'].split(',')]
            if "resopnsive" in magic_word:
                for i, k in enumerate(character):
                    if k in cd:
                        if cd[k] < 151: character[i] = "{{{{" + k + "}}}}"
                        elif cd[k] < 251: character[i] = "{{{" + k + "}}}"
                        elif cd[k] < 351: character[i] = "{{" + k + "}}"
                        elif cd[k] < 501: character[i] = "{" + k + "}"
            processed[fix_index:fix_index] = character
            fix_index+=len(character)
    elif rm_c == 0 and '*(set character name after prefix)' in special_word_check:
        if popped_row['character']:
            character = [item.strip() for item in popped_row['character'].split(',')]
            if "resopnsive" in magic_word:
                for i, k in enumerate(character):
                    if k in cd:
                        if cd[k] < 151: character[i] = "{{{{" + k + "}}}}"
                        elif cd[k] < 251: character[i] = "{{{" + k + "}}}"
                        elif cd[k] < 351: character[i] = "{{" + k + "}}"
                        elif cd[k] < 501: character[i] = "{" + k + "}"
            processed[fix_index+len(fix):fix_index+len(fix)] = character
            #fix_index+=len(character)
    elif rm_c == 0 and '*(set character name before prefix)' in special_word_check:
        if popped_row['character']:
            character = [item.strip() for item in popped_row['character'].split(',')]
            if "resopnsive" in magic_word:
                for i, k in enumerate(character):
                    if k in cd:
                        if cd[k] < 151: character[i] = "{{{{" + k + "}}}}"
                        elif cd[k] < 251: character[i] = "{{{" + k + "}}}"
                        elif cd[k] < 351: character[i] = "{{" + k + "}}"
                        elif cd[k] < 501: character[i] = "{" + k + "}"
            processed[fix_index+1:fix_index+1] = character
            fix_index+=len(character)
    if rm_c == 0 and popped_row['character']:
        try: 
            if "resopnsive" in magic_word:
                for i, k in enumerate(character):
                    if k in cd:
                        if cd[k] < 151: character[i] = "{{{{" + k + "}}}}"
                        elif cd[k] < 251: character[i] = "{{{" + k + "}}}"
                        elif cd[k] < 351: character[i] = "{{" + k + "}}"
                        elif cd[k] < 501: character[i] = "{" + k + "}"
            temp_processed[fix_index:fix_index] = character
        except: pass
    if magic_word["random_artist"] == True:
        processed.insert(fix_index, magic_word["random_artist_name"])
        

    _general = {}
    temp_prompt = [key for key in temp_processed if (":" not in key and "artist" not in key and "#" not in key and "*(" not in key)]

    boy_in_processed = girl_in_processed = None
    for boy in boys:
        if boy in processed:
            boy_in_processed = boy
            break

    for girl in girls:
        if girl in processed:
            girl_in_processed = girl
            break
        
    if boy_in_processed and girl_in_processed:
        boy_index = processed.index(boy_in_processed)
        girl_index = processed.index(girl_in_processed)
        t_boy_index = temp_prompt.index(boy_in_processed)
        t_girl_index = temp_prompt.index(girl_in_processed)
        if magic_word["male_before_girl"] == True:
            if boy_index > girl_index or boy_index +1 != girl_index:
                processed.pop(boy_index)
                processed.insert(girl_index, boy_in_processed)
        else:
            if girl_index > boy_index or girl_index +1 != boy_index:
                if boy_index == 0:
                    processed.pop(girl_index)
                    processed.insert(0, girl_in_processed)
                else:
                    processed.pop(boy_index)
                    girl_index = processed.index(girl_in_processed)
                    processed.pop(girl_index)
                    processed.insert(0, girl_in_processed)
                    processed.insert(1, boy_in_processed)

    _general["prompt"] = ', '.join(temp_prompt)
    _general["prompt"] = _general["prompt"].replace('[', '').replace(']', '').replace('{', '').replace('}', '').replace('(', '\(').replace(')', '\)')

    s_word = ['*(remove character name)', '*(set character name after prefix)', '*(set character name before prefix)', '*(keep only characteristic and clothes)']
    for keyword in s_word:
        if keyword in processed:
            processed.remove(keyword)
    af_s_word = ['(remove character name)', '(set character name after prefix)', '(set character name before prefix)', '(keep only characteristic and clothes)']
    _temp_af = []
    for keyword in at_first:
        if keyword in af_s_word:
            _temp_af.append(keyword)
    for keyword in _temp_af:
        at_first.remove(keyword)
            
    if at_first:
        processed = at_first + processed
    if "#캐릭터작품명제거_작가명" in processed:
        for i, key in enumerate(processed):
            if i >= 1:
                if key == "#캐릭터작품명제거_작가명": break
                elif key in boys or key in girls or "others" in key: continue
                elif " (" in key and ")" in key:
                    processed[i] = key.split(" (")[0]

    if "resopnsive" in magic_word:
        if fix: start_index = processed.index(fix[-1].strip()) + 1
        elif "cpp" in magic_word:
            for i, key in enumerate(processed):
                if "프롬프트" in key: 
                    start_index = i
                    break
                if i == len(processed) - 1:
                    start_index = 3
        else: start_index = 1
        last_index = processed.index(after[0].strip())
        rework_prompt = processed[start_index:last_index]

        grouped_keywords = {i: [] for i in range(7)}
        for keyword in rework_prompt:
            if keyword != '':
                if '{' not in keyword and '<' not in keyword and all(color not in keyword for color in colors):
                    value = keyword_dict.get(keyword, 6)
                    if value != 0: 
                        grouped_keywords[value].append(keyword)
                    else:
                        if keyword in data.qe_word: grouped_keywords[value].append(keyword)
                        else: grouped_keywords[value].append(keyword)
                else:
                    grouped_keywords[0].append(keyword)
        for key in grouped_keywords:
            if grouped_keywords[key]: grouped_keywords[key].sort()
        for key in grouped_keywords:
            if grouped_keywords[key]:
                if key > 0 and key <= 2:
                    grouped_keywords[key][0] = (key+1)*'{' + grouped_keywords[key][0]
                    grouped_keywords[key][-1] = grouped_keywords[key][-1] + (key+1)*'}'
                elif key > 2 and key < 5:
                    grouped_keywords[key][0] = (key+2)*'{' + grouped_keywords[key][0]
                    grouped_keywords[key][-1] = grouped_keywords[key][-1] + (key+2)*'}'
                elif key == 5:
                    grouped_keywords[key][0] = (key)*'{' + grouped_keywords[key][0]
                    grouped_keywords[key][-1] = grouped_keywords[key][-1] + (key)*'}'                    
                elif key == 0:
                    keys = [key for key in grouped_keywords[key] if (key in data.qe_word or '{' in key or '[' in key)]
                    keys1 = [key for key in grouped_keywords[key] if key not in keys]
                    if keys1: 
                        keys1[0] = '[' + keys1[0]
                        keys1[-1] = keys1[-1] + ']'             
                    grouped_keywords[0] = keys + keys1
        rework_prompt = []
        for key in sorted(grouped_keywords.keys(), reverse=True):
            rework_prompt.extend(grouped_keywords[key])
        processed[start_index:last_index] = rework_prompt

    for i, key in enumerate(processed):
        if key.startswith('#'): processed[i] = '\n\n'+key+'\n'
    if eye_check == False:
        processed = [key for key in processed if all(ec not in key for ec in ecs)]
    combined = boys + girls
    check_range = processed[:6] if len(processed) >= 6 else processed[:len(processed)-1]
    if processed[0] not in combined and any(item in check_range for item in combined):
        for _ in range(3):
            if any(item in check_range for item in combined):
                first_element = processed.pop(0)
                middle_index = len(processed) // 2
                processed.insert(middle_index, first_element)
                check_range = processed[:6] if len(processed) >= 6 else processed[:len(processed)-1]
                if processed[0] in check_range:
                    break
            else:
                break
    
    if magic_word["fts1"] == True:
        sub_general = [k for k in sub_general if (k in processed or ',' in k or 'girl' in k or 'boy' in k)]
        additional_prompt2 = magic_word["fts1_pre"].replace(':', ' ').strip()
        if len(additional_prompt2) >= 3:
            if "girl" in sub_general[1] or "boy" in sub_general[1]:
                sub_general.insert(2, additional_prompt2)
            else:
                sub_general.insert(1, additional_prompt2)
        additional_prompt = magic_word["fts1_post"]
        if len(additional_prompt) >= 3:
            additional_prompt = ', ' + additional_prompt.replace(':', ' ').strip()
        if magic_word["fts1_character"] == True:
            for i, item in enumerate(processed):
                if not any(keyword in item for keyword in ['boy', 'girl', '#', 'artist']):
                    sub_general.insert(i, item.replace(':', '_'))
                    break
        rdict["fts1"] = ', '.join(sub_general) + additional_prompt

    return ', '.join(processed).replace('princess connect!', 'princess connect'), popped_row['rating'], _general, removed, rdict.copy()

def RFP_WEBUI(popped_row, fix_prompt, after_prompt, auto_hide_prompt, rm_a, rm_s, rm_c, rm_loc, rm_color, rm_clothes, nsfw, data, magic_word):
    boys = ["1boy", "2boys", "3boys", "4boys", "5boys", "6+boys"]
    girls = ["1girl", "2girls", "3girls", "4girls", "5girls", "6+girls"]
    general = [item.strip() for item in popped_row['general'].split(',')]
    eye_check = False
    if '*(wildcard standalone)' in general or "eye_catch" in magic_word:
        eye_check = True
    else:
        for key in general: 
            if ('eye' in key and key != 'closed eyes'): eye_check = True
    special_word_check = fix_prompt+', '+after_prompt
    prompt_duplicate_check = re.sub(r'[\{\}\[\]]', '', special_word_check)
    special_word_check = [item.strip() for item in special_word_check.split(',')]
    prompt_duplicate_check = [item.strip() for item in prompt_duplicate_check.split(',')]
    special_word_check = [item for item in special_word_check if item.startswith('*')]
    colors = ['black','white','blond','silver','gray','yellow','blue','purple','red','pink','brown','orange','green','aqua','gradient']
    ecs = [color+" eye" for color in colors] + [' pupils','ing eye']
    general = [item for item in general if item not in prompt_duplicate_check]
    exc = []
    for keyword in general:
        if keyword == '!' or keyword == '!?' or keyword == '!!' or keyword == '...' or keyword == '^^^' or keyword == '+++':
            exc.append(keyword)
    if exc:
        for keyword in exc:
            general.remove(keyword)
        general[3:3] = exc

    rm_word = []
    w_word = []
    rdict = {
        "rm_word": rm_word,
        "w_word": w_word
    }
    removed = []
    if "prompt_compress" in magic_word:
        general = compress_prompt(general, removed)
    if "frequency_limit" in magic_word:
        general = prompt_frequency_limit(general, removed, magic_word["frequency_limit"], data.prompt_freq)
    if magic_word["fts1"] == True:
        sub_general = prompt_frequency_limit_hidden(general, data, colors, magic_word["male_before_girl"])

    if nsfw == 1:
        nsfw_word = []
        for keyword in general:
            if keyword in data.qe_word or keyword in data.bag_of_tags or "horns" in keyword or "(" in keyword or keyword in boys or keyword in girls:
                nsfw_word.append(keyword)
            elif keyword in magic_word["nsfw_whitelist"]:
                nsfw_word.append(keyword)
                w_word.append(keyword)
            else:
                rm_word.append(keyword)
        nsfw_word = list(set(nsfw_word))
        nsfw_word.sort()
        general = nsfw_word
    if rm_loc == 1:
        temp_general = []
        locations = ['indoors', 'outdoors', 'airplane interior', 'airport', 'apartment', 'arena', 'armory', 'bar', 'barn', 'bathroom', 'bathtub', 'bedroom', 'bell tower', 'billiard room', 'book store', 'bowling alley', 'bunker', 'bus interior', 'butcher shop', 'cafe', 'cafeteria', 'car interior', 'casino', 'castle', 'catacomb', 'changing room', 'church', 'classroom', 'closet', 'construction site', 'convenience store', 'convention hall', 'court', 'dining room', 'drugstore', 'ferris wheel', 'flower shop', 'gym', 'hangar', 'hospital', 'hotel room', 'hotel', 'infirmary', 'izakaya', 'kitchen', 'laboratory', 'library', 'living room', 'locker room', 'mall', 'messy room', 'mosque', 'movie theater', 'museum', 'nightclub', 'office', 'onsen', 'ovservatory', 'phone booth', 'planetarium', 'pool', 'prison', 'refinery', 'restaurant', 'restroom', 'rural', 'salon', 'school', 'sex shop', 'shop', 'shower room', 'skating rink', 'snowboard shop', 'spacecraft interior', 'staff room', 'stage', 'supermarket', 'throne', 'train station', 'tunnel', 'airfield', 'alley', 'amphitheater', 'aqueduct', 'bamboo forest', 'beach', 'blizzard', 'bridge', 'bus stop', 'canal', 'canyon', 'carousel', 'cave', 'cliff', 'cockpit', 'conservatory', 'cross walk', 'desert', 'dust storm', 'flower field', 'forest', 'garden', 'gas staion', 'gazebo', 'geyser', 'glacier', 'graveyard', 'harbor', 'highway', 'hill', 'island', 'jungle', 'lake', 'market', 'meadow', 'nuclear powerplant', 'oasis', 'ocean bottom', 'ocean', 'pagoda', 'parking lot', 'playground', 'pond', 'poolside', 'railroad', 'rainforest', 'rice paddy', 'roller coster', 'rooftop', 'rope bridge', 'running track', 'savannah', 'shipyard', 'shirine', 'skyscraper', 'soccor field', 'space elevator', 'stair', 'starry sky', 'swamp', 'tidal flat', 'volcano', 'waterfall', 'waterpark', 'wheat field', 'zoo', 'white background', 'simple background', 'grey background', 'gradient background', 'blue background', 'black background', 'yellow background', 'pink background', 'red background', 'brown background', 'green background', 'purple background', 'orange background']
        for keyword in general:
            if keyword in locations:
                temp_general.append(keyword)
        for keyword in temp_general:
            general.remove(keyword)
            removed.append(keyword)
    if rm_color == 1:
        temp_general = []
        for keyword in general:
            if any(color in keyword for color in colors):
                temp_general.append(keyword)
        for keyword in temp_general:
            if " eyes" not in keyword and " hair" not in keyword and " pupils" not in keyword:
                general.remove(keyword)
                removed.append(keyword)
    if rm_clothes == 1:
        temp_general = []
        clothes = data.attire_list
        for keyword in general:
            if keyword in clothes:
                temp_general.append(keyword)
        for keyword in temp_general:
            if keyword not in data.bag_of_tags:
                general.remove(keyword)
                removed.append(keyword)
    if "*(keep only characteristic and clothes)" in special_word_check:
        _temp_general = []
        whitelist = data.attire_list + data.bag_of_tags
        for keyword in general:
            if "horns" in keyword or "(" in keyword or keyword in boys or keyword in girls or keyword in whitelist:
                _temp_general.append(keyword)
        _temp_general = list(set(_temp_general))
        _temp_general.sort()
        general = _temp_general
    if rm_c == 1:
        temp_general = []
        for keyword in general:
            if keyword in data.bag_of_tags:
                temp_general.append(keyword)
        for keyword in temp_general:
            general.remove(keyword)
            removed.append(keyword)
    
    #NAIA_random_function_core.process_fix_prompt()
    fix = process_fix_prompt(fix_prompt)

    if magic_word["fts1"] == True:
        ffix = get_joined_string(fix)
        if ffix != '': 
            sub_general.insert(2, ffix)

    if not fix or fix== ['']:
        fix = ['#선행태그']

    at_first = []
    for fp in fix:
        if fp.startswith('*'):
            at_first.append(fp[1:])
    if at_first:
        for af in at_first:
            if '*'+af in fix:
                fix.remove('*'+af)
    if rm_a == 0:
        if popped_row['artist']:
            artists = [item.strip() for item in popped_row['artist'].split(',')]
            artist = ["(" + _artist.replace('(', '\\(').replace(')', '\\)') + ")" for _artist in artists]
            fix = artist + fix
    if rm_s == 0:
        if popped_row['copyright']:
            series = [item.strip().replace('(', '\\(').replace(')', '\\)') for item in popped_row['copyright'].split(',')]
        else:
            series = []
        fix = fix + series
    after = [item.strip() for item in after_prompt.split(',')]

    if not after or after== ['']:
        after = ['#후행태그']    
    auto_hide = [item.strip() for item in auto_hide_prompt.split(',') if not item.strip().startswith('#')] + ["| |", ":|", "\||/", "<|> <|>", "|| ||", ";|"]
    fix_index = find_keyword_index(general)
    processed = general.copy()
    temp_hide_prompt = []
    pass_prompt = [item.replace('~', '') for item in auto_hide if item.startswith('~')]
    auto_hide = [item for item in auto_hide if not item.startswith('~')]
    for keyword in processed:
        if keyword in auto_hide:
            temp_hide_prompt.append(keyword)
    for keyword in temp_hide_prompt:
        processed.remove(keyword)
        removed.append(keyword)

    to_remove = []
    for item in auto_hide:
        modified_item = item
        if item.startswith("__") and item.endswith("__"):
            # 모든 _를 제거합니다.
            modified_item = modified_item.replace("_", "")
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.startswith("_") and item.endswith("_"):
            # 모든 _를 공백으로 대체합니다.
            modified_item = modified_item.replace("_", " ")
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.startswith("_"):
            # 시작하는 _를 공백으로 대체합니다.
            modified_item = modified_item.replace("_", " ", 1)
            to_remove += [keyword for keyword in processed if modified_item in keyword]
        elif item.endswith("_"):
            # 끝나는 _를 공백으로 대체합니다.
            modified_item = " " + modified_item.rstrip("_") + " "
            to_remove += [keyword for keyword in processed if modified_item.strip() in keyword]

    # 조건에 맞는 키워드를 processed에서 제거합니다.
    to_remove = list(set(to_remove))
    if to_remove:
        for keyword in to_remove:
            if keyword in processed and keyword not in pass_prompt: 
                processed.remove(keyword)
                removed.append(keyword)
    removed = ', '.join(removed)

    add_ev = []
    if 'event' in magic_word and magic_word['event']['add']:
        add_ev = magic_word['event']['add']
        fixc = fix.copy()

    #여기에서 문제의 magic word 처리
    if "cpp" in magic_word and magic_word["cpp"] and "cond" in magic_word and magic_word["cond"]:
        user_input = magic_word["cond"]
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix
        fix_index += len(fix)
        fix = []
        processed = parse_and_execute_commands(processed, user_input, fix, after, popped_row)
        if fix: processed[fix_index:fix_index] = fix
    elif "cond" in magic_word and magic_word["cond"]:
        user_input = magic_word["cond"]
        processed = parse_and_execute_commands(processed, user_input, fix, after, popped_row)
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix
    else:
        fix_index = find_keyword_index(processed)
        processed[fix_index:fix_index] = fix

    if add_ev:
        last_hash_string = None
        for item in reversed(fixc):
            if '#' in item:
                last_hash_string = item
                break
        if last_hash_string:
            last_hash_index = fixc.index(last_hash_string)
            insert_index = last_hash_index + 2
            temp_rm = [k for k in add_ev if k in processed]
            for k in temp_rm:
                if k in processed: processed.remove(k)
            for k in temp_rm:
                processed.insert(insert_index, '(' +k+')')
                insert_index += 1
    
    temp_processed = processed.copy()
    processed += after

    if rm_c == 0 and '*(remove character name)' not in special_word_check and '*(set character name after prefix)' not in special_word_check and '*(set character name before prefix)' not in special_word_check:
        if popped_row['character']:
            character = [item.strip().replace('(', '\\(').replace(')', '\\)') for item in popped_row['character'].split(',')]
            processed[fix_index:fix_index] = character
            fix_index+=len(character)
    elif rm_c == 0 and '*(set character name after prefix)' in special_word_check:
        if popped_row['character']:
            character = [item.strip().replace('(', '\\(').replace(')', '\\)') for item in popped_row['character'].split(',')]
            processed[fix_index+len(fix):fix_index+len(fix)] = character
            #fix_index+=len(character)
    elif rm_c == 0 and '*(set character name before prefix)' in special_word_check:
        if popped_row['character']:
            character = [item.strip().replace('(', '\\(').replace(')', '\\)') for item in popped_row['character'].split(',')]
            processed[fix_index+1:fix_index+1] = character
            fix_index+=len(character)
    if magic_word["random_artist"] == True:
        processed.insert(fix_index, magic_word["random_artist_name"])

    _general = {}
    temp_prompt = [key for key in temp_processed if (":" not in key and "artist" not in key and "#" not in key and "*(" not in key)]
        
    boy_in_processed = girl_in_processed = None
    for boy in boys:
        if boy in processed:
            boy_in_processed = boy
            break

    for girl in girls:
        if girl in processed:
            girl_in_processed = girl
            break
        
    if boy_in_processed and girl_in_processed:
        boy_index = processed.index(boy_in_processed)
        girl_index = processed.index(girl_in_processed)
        if magic_word["male_before_girl"] == True:
            if boy_index > girl_index or boy_index +1 != girl_index:
                processed.pop(boy_index)
                processed.insert(girl_index, boy_in_processed)
        else:
            if girl_index > boy_index or girl_index +1 != boy_index:
                processed.pop(boy_index)
                processed.insert(girl_index+1, boy_in_processed)

    _general["prompt"] = ', '.join(temp_prompt)
    _general["prompt"] = _general["prompt"].replace('[', '').replace(']', '').replace('{', '').replace('}', '').replace('(', '\(').replace(')', '\)')

    s_word = ['*(remove character name)', '*(set character name after prefix)', '*(set character name before prefix)', '*(keep only characteristic and clothes)']
    for keyword in s_word:
        if keyword in processed:
            processed.remove(keyword)
    af_s_word = ['(remove character name)', '(set character name after prefix)', '(set character name before prefix)', '(keep only characteristic and clothes)']
    _temp_af = []
    for keyword in at_first:
        if keyword in af_s_word:
            _temp_af.append(keyword)
    for keyword in _temp_af:
        at_first.remove(keyword)
            
    if at_first:
        processed = at_first + processed

    if "resopnsive" in magic_word:
        if fix: start_index = processed.index(fix[-1].strip()) + 1
        elif "cpp" in magic_word:
            for i, key in enumerate(processed):
                if "프롬프트" in key: 
                    start_index = i
                    break
                if i == len(processed) - 1:
                    start_index = 3
        else: start_index = 1
        last_index = processed.index(after[0].strip()) - 1
        rework_prompt = processed[start_index:last_index]

        grouped_keywords = {i: [] for i in range(7)}
        for keyword in rework_prompt:
            if keyword != '':
                if '{' not in keyword and '<' not in keyword and all(color not in keyword for color in colors):
                    value = keyword_dict.get(keyword, 6)
                    if value != 0: 
                        grouped_keywords[value].append(keyword)
                    else:
                        if keyword in data.qe_word: grouped_keywords[value].append(keyword)
                        else: grouped_keywords[value].append(keyword)
                else:
                    grouped_keywords[0].append(keyword)
        for key in grouped_keywords:
            if grouped_keywords[key]: grouped_keywords[key].sort()
        for key in grouped_keywords:
            if grouped_keywords[key]:
                grouped_keywords[key][0] = '(' + grouped_keywords[key][0]
                if key == 1:
                    grouped_keywords[key][-1] = grouped_keywords[key][-1] + ')'
                else:
                    grouped_keywords[key][-1] = grouped_keywords[key][-1] + ':' + str(round(1.05 + key * 0.05, 2)) + ')'
        rework_prompt = []
        for key in sorted(grouped_keywords.keys(), reverse=True):
            rework_prompt.extend(grouped_keywords[key])
        processed[start_index:last_index] = rework_prompt

    for i, key in enumerate(processed):
        if key.startswith('#'): 
            if i != 0 : processed[i] = '\n\n'+key+'\n'
            else: processed[i] = key+'\n'
    if eye_check == False:
        processed = [key for key in processed if all(ec not in key for ec in ecs)]

    if magic_word["fts1"] == True:
        sub_general = [k for k in sub_general if (k in processed or ',' in k or 'girl' in k or 'boy' in k)]
        additional_prompt2 = magic_word["fts1_pre"].replace(':', ' ').strip()
        if len(additional_prompt2) >= 3:
            if "girl" in sub_general[1] or "boy" in sub_general[1]:
                sub_general.insert(2, additional_prompt2)
            else:
                sub_general.insert(1, additional_prompt2)
        additional_prompt = magic_word["fts1_post"]
        if len(additional_prompt) >= 3:
            additional_prompt = ', ' + additional_prompt.replace(':', ' ').strip()
        if magic_word["fts1_character"] == True:
            for i, item in enumerate(processed):
                if not any(keyword in item for keyword in ['boy', 'girl', '#', 'artist']):
                    sub_general.insert(i, item.replace(':', '_'))
                    break
        rdict["fts1"] = ', '.join(sub_general) + additional_prompt

    return ', '.join(processed), popped_row['rating'], _general, removed, rdict.copy()