#!/bin/bash

# Python 3.10을 찾아서 사용
for python_path in "/Library/Frameworks/Python.framework/Versions/3.10/bin/python3" "/usr/local/bin/python3.10" "/opt/homebrew/bin/python3.10"; do
    if [ -x "$python_path" ]; then
        PYTHON_PATH="$python_path"
        break
    fi
done

if [ -z "$PYTHON_PATH" ]; then
    echo "Python 3.10 is not found. Please install Python 3.10"
    exit 1
fi

PYTHON_VERSION=$("$PYTHON_PATH" -c 'import sys; print(".".join(map(str, sys.version_info[:3])))')
echo "Found Python version: $PYTHON_VERSION"

if [ ! -d "venv" ]; then
    echo "Creating venv environment for execute NAIA..."
    /Library/Frameworks/Python.framework/Versions/3.10/bin/python3 -m venv venv
    echo
fi

source venv/bin/activate
pip install --upgrade pip
pip install --no-cache-dir -r requirements_mac.txt
python3 NAIA_main.py