import customtkinter
import NAIA_Login
import requests, json

class AccountSetting(customtkinter.CTkToplevel):
    def __init__(self, app, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.title("NAI Account Setting")
        self.attributes('-topmost', True)

        def on_close(self):
            self.withdraw()

        def NAI_connect(self):
            if self.change_login_pattern.get() == 0:
                username = self.NAI_ID_entry.get().strip()
                password = self.NAI_PW_entry.get().strip()
                access_key = NAIA_Login.get_access_key(username, password)
                try:
                    app.access_token = NAIA_Login.login(access_key)
                    app.NAI_ID = username[:4]
                    self.state_label.configure(text="(로그인 성공, 닫기 버튼을 눌러주세요.)", font=my_font)
                    app.NAI_Account_Login.configure(state="disabled")
                    app.NAI_Token_Remove.configure(state="normal")
                    app.NAI_Account_State.configure(text="NAI Login : OK")
                    app.image_generation_button.configure(state="normal")
                    app.get_anlas()
                except Exception as e:
                    print(e)
                    self.state_label.configure(text="아이디 혹은 비밀번호 오류입니다.", font=my_font)
            else:
                access_key = self.NAI_PW_entry.get().strip()
                try:
                    response = requests.get("https://api.novelai.net/user/subscription", headers={
                        "Authorization": f"Bearer {access_key}"}, timeout=3)
                    data_dict = json.loads(response.content)
                    if data_dict['active']:
                        app.NAI_ID = "Ptkn"
                        app.access_token = access_key
                        self.state_label.configure(text="(로그인 성공, 닫기 버튼을 눌러주세요.)", font=my_font)
                        app.NAI_Account_Login.configure(state="disabled")
                        app.NAI_Token_Remove.configure(state="normal")
                        app.NAI_Account_State.configure(text="NAI Login : OK")
                        app.image_generation_button.configure(state="normal")
                except:
                    print(e)
                    self.state_label.configure(text="잘못된 영구토큰 혹은 활성상태가 아닙니다.", font=my_font)

        def change_login_type(self):
            if self.change_login_pattern.get() == 1:
                self.NAI_PW_label.configure(text="P.Token:")
                self.NAI_ID_entry.grid_forget()
                self.NAI_ID_label.grid_forget()
            else:
                self.NAI_ID_entry.grid(row = 0, column = 1, padx=5, pady=5, sticky="nsew")
                self.NAI_ID_label.grid(row = 0, column = 0, padx=5, pady=5, sticky="nsew")
                self.NAI_PW_label.configure(text="NAI PW:")

        self.button_frame = customtkinter.CTkFrame(self)
        self.button_frame.grid(row=0, padx=5, pady=5, sticky="nsew")
        self.button_frame.columnconfigure(0, weight=1)
        self.button_frame.columnconfigure(1, weight=4)

        my_font = customtkinter.CTkFont('Pretendard', 13)
        self.NAI_ID_label = customtkinter.CTkLabel(self.button_frame, text="NAI ID:", font=my_font)
        self.NAI_ID_label.grid(row = 0, column = 0, padx=5, pady=5, sticky="nsew")
        self.NAI_PW_label = customtkinter.CTkLabel(self.button_frame, text="NAI PW:", font=my_font)
        self.NAI_PW_label.grid(row = 1, column = 0, padx=5, pady=5, sticky="nsew")
        self.NAI_ID_entry = customtkinter.CTkEntry(self.button_frame)
        self.NAI_ID_entry.grid(row = 0, column = 1, padx=5, pady=5, sticky="nsew")
        self.NAI_PW_entry = customtkinter.CTkEntry(self.button_frame, show="*")
        self.NAI_PW_entry.grid(row = 1, column = 1, padx=5, pady=5, sticky="nsew")
        self.change_login_pattern = customtkinter.CTkCheckBox(self.button_frame, text="영구 토큰 사용", command=lambda:change_login_type(self))
        self.change_login_pattern.grid(row = 2, column = 0,  padx=5, pady=5, sticky="n")
        self.connect_button = customtkinter.CTkButton(self.button_frame, text="Connect", command=lambda:NAI_connect(self))
        self.connect_button.grid(row = 2, column = 1,  padx=5, pady=5, sticky="n")
        self.state_label = customtkinter.CTkLabel(self.button_frame, text="해당 접속기능은 정상적인 접속 패턴이 아닌점 참고 부탁드립니다.\n가급적 영구토큰을 이용한 로그인을 권장합니다", font=my_font)
        self.state_label.grid(row = 3, column = 0, columnspan=2, padx=5, pady=5, sticky="nsew")

        self.protocol("WM_DELETE_WINDOW", lambda: on_close(self))